/* RestBreakView.c generated by valac 0.56.17, the Vala compiler
 * generated from RestBreakView.vala, do not modify */

/* RestBreakView.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "common.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_0_PROPERTY,
	BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_REST_BREAK_PROPERTY,
	BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY,
	BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY,
	BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_rest_break_rest_break_view_properties[BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BreakTimerDaemonRestBreakRestBreakViewPrivate {
	BreakTimerDaemonUtilFocusPriority _focus_priority;
	gchar** _notification_ids;
	gint _notification_ids_length1;
	gint __notification_ids_size_;
	gint64 original_start_time;
	gboolean was_skipped;
	gboolean human_is_resting;
	gint64 last_break_notification_time;
};

static gint BreakTimerDaemonRestBreakRestBreakView_private_offset;
static gpointer break_timer_daemon_rest_break_rest_break_view_parent_class = NULL;

static void break_timer_daemon_rest_break_rest_break_view_focused_and_activated_cb (BreakTimerDaemonRestBreakRestBreakView* self);
static void _break_timer_daemon_rest_break_rest_break_view_focused_and_activated_cb_break_timer_daemon_break_break_view_focused_and_activated (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                                        gpointer self);
static void break_timer_daemon_rest_break_rest_break_view_lost_ui_focus_cb (BreakTimerDaemonRestBreakRestBreakView* self);
static void _break_timer_daemon_rest_break_rest_break_view_lost_ui_focus_cb_break_timer_daemon_break_break_view_lost_ui_focus (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                        gpointer self);
static void break_timer_daemon_rest_break_rest_break_view_finished_cb (BreakTimerDaemonRestBreakRestBreakView* self,
                                                                BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                gboolean was_active);
static void _break_timer_daemon_rest_break_rest_break_view_finished_cb_break_timer_daemon_break_break_controller_finished (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                    BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                                                                    gboolean was_active,
                                                                                                                    gpointer self);
static gchar* break_timer_daemon_rest_break_rest_break_view_real_get_status_message (BreakTimerDaemonBreakBreakView* base);
static void break_timer_daemon_rest_break_rest_break_view_real_dismiss_break (BreakTimerDaemonBreakBreakView* base);
static void break_timer_daemon_rest_break_rest_break_view_show_start_notification (BreakTimerDaemonRestBreakRestBreakView* self);
static void break_timer_daemon_rest_break_rest_break_view_add_notification_actions (BreakTimerDaemonRestBreakRestBreakView* self,
                                                                             GNotification* notification);
static void break_timer_daemon_rest_break_rest_break_view_show_interrupted_notification (BreakTimerDaemonRestBreakRestBreakView* self);
static void break_timer_daemon_rest_break_rest_break_view_show_overdue_notification (BreakTimerDaemonRestBreakRestBreakView* self);
static void break_timer_daemon_rest_break_rest_break_view_show_finished_notification (BreakTimerDaemonRestBreakRestBreakView* self);
static gint break_timer_daemon_rest_break_rest_break_view_seconds_since_last_break_notification (BreakTimerDaemonRestBreakRestBreakView* self);
static void break_timer_daemon_rest_break_rest_break_view_counting_cb (BreakTimerDaemonRestBreakRestBreakView* self,
                                                                gint lap_time,
                                                                gint total_time);
static void _break_timer_daemon_rest_break_rest_break_view_counting_cb_break_timer_daemon_timer_break_timer_break_controller_counting (BreakTimerDaemonTimerBreakTimerBreakController* _sender,
                                                                                                                                gint lap_time,
                                                                                                                                gint total_time,
                                                                                                                                gpointer self);
static void break_timer_daemon_rest_break_rest_break_view_delayed_cb (BreakTimerDaemonRestBreakRestBreakView* self,
                                                               gint lap_time,
                                                               gint total_time);
static void _break_timer_daemon_rest_break_rest_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed (BreakTimerDaemonTimerBreakTimerBreakController* _sender,
                                                                                                                              gint lap_time,
                                                                                                                              gint total_time,
                                                                                                                              gpointer self);
static void break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb (BreakTimerDaemonRestBreakRestBreakView* self);
static void _break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb_break_timer_daemon_rest_break_rest_break_controller_current_duration_changed (BreakTimerDaemonRestBreakRestBreakController* _sender,
                                                                                                                                                              gpointer self);
static void break_timer_daemon_rest_break_rest_break_view_finalize (GObject * obj);
static GType break_timer_daemon_rest_break_rest_break_view_get_type_once (void);
static void _vala_break_timer_daemon_rest_break_rest_break_view_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
break_timer_daemon_rest_break_rest_break_view_get_instance_private (BreakTimerDaemonRestBreakRestBreakView* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonRestBreakRestBreakView_private_offset);
}

static void
_break_timer_daemon_rest_break_rest_break_view_focused_and_activated_cb_break_timer_daemon_break_break_view_focused_and_activated (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                                   gpointer self)
{
	break_timer_daemon_rest_break_rest_break_view_focused_and_activated_cb ((BreakTimerDaemonRestBreakRestBreakView*) self);
}

static void
_break_timer_daemon_rest_break_rest_break_view_lost_ui_focus_cb_break_timer_daemon_break_break_view_lost_ui_focus (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                   gpointer self)
{
	break_timer_daemon_rest_break_rest_break_view_lost_ui_focus_cb ((BreakTimerDaemonRestBreakRestBreakView*) self);
}

static void
_break_timer_daemon_rest_break_rest_break_view_finished_cb_break_timer_daemon_break_break_controller_finished (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                               BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                                                               gboolean was_active,
                                                                                                               gpointer self)
{
	break_timer_daemon_rest_break_rest_break_view_finished_cb ((BreakTimerDaemonRestBreakRestBreakView*) self, reason, was_active);
}

BreakTimerDaemonRestBreakRestBreakView*
break_timer_daemon_rest_break_rest_break_view_construct (GType object_type,
                                                         BreakTimerDaemonRestBreakRestBreakController* rest_break,
                                                         BreakTimerDaemonUIManager* ui_manager)
{
	BreakTimerDaemonRestBreakRestBreakView * self = NULL;
	BreakTimerDaemonRestBreakRestBreakController* _tmp0_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
	g_return_val_if_fail (rest_break != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (BreakTimerDaemonRestBreakRestBreakView*) break_timer_daemon_timer_break_timer_break_view_construct (object_type, (BreakTimerDaemonTimerBreakTimerBreakController*) rest_break, ui_manager);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakView*) self, "focused-and-activated", (GCallback) _break_timer_daemon_rest_break_rest_break_view_focused_and_activated_cb_break_timer_daemon_break_break_view_focused_and_activated, self, 0);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakView*) self, "lost-ui-focus", (GCallback) _break_timer_daemon_rest_break_rest_break_view_lost_ui_focus_cb_break_timer_daemon_break_break_view_lost_ui_focus, self, 0);
	_tmp0_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((BreakTimerDaemonBreakBreakController*) _tmp1_, "finished", (GCallback) _break_timer_daemon_rest_break_rest_break_view_finished_cb_break_timer_daemon_break_break_controller_finished, self, 0);
	return self;
}

BreakTimerDaemonRestBreakRestBreakView*
break_timer_daemon_rest_break_rest_break_view_new (BreakTimerDaemonRestBreakRestBreakController* rest_break,
                                                   BreakTimerDaemonUIManager* ui_manager)
{
	return break_timer_daemon_rest_break_rest_break_view_construct (BREAK_TIMER_DAEMON_REST_BREAK_TYPE_REST_BREAK_VIEW, rest_break, ui_manager);
}

static gchar*
break_timer_daemon_rest_break_rest_break_view_real_get_status_message (BreakTimerDaemonBreakBreakView* base)
{
	BreakTimerDaemonRestBreakRestBreakView * self;
	gint starts_in_value = 0;
	BreakTimerDaemonRestBreakRestBreakController* _tmp0_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
	gchar* starts_in_text = NULL;
	BreakTimerCommonNaturalTime* _tmp2_;
	BreakTimerCommonNaturalTime* _tmp3_;
	gchar* _tmp4_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp5_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp6_;
	BreakTimerDaemonBreakBreakControllerState _tmp7_;
	BreakTimerDaemonBreakBreakControllerState _tmp8_;
	gchar* result;
	self = (BreakTimerDaemonRestBreakRestBreakView*) base;
	_tmp0_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp1_ = _tmp0_;
	starts_in_value = break_timer_daemon_timer_break_timer_break_controller_starts_in ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_);
	_tmp2_ = break_timer_common_natural_time_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = break_timer_common_natural_time_get_countdown_for_seconds (_tmp3_, starts_in_value, NULL);
	starts_in_text = _tmp4_;
	_tmp5_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = starts_in_text;
		_tmp10_ = g_strdup_printf (ngettext ("Break starts in %s", "Break starts in %s", (gulong) starts_in_value), _tmp9_);
		result = _tmp10_;
		_g_free0 (starts_in_text);
		return result;
	} else {
		BreakTimerDaemonRestBreakRestBreakController* _tmp11_;
		BreakTimerDaemonRestBreakRestBreakController* _tmp12_;
		BreakTimerDaemonBreakBreakControllerState _tmp13_;
		BreakTimerDaemonBreakBreakControllerState _tmp14_;
		_tmp11_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup (_ ("Time for a break"));
			result = _tmp15_;
			_g_free0 (starts_in_text);
			return result;
		} else {
			result = NULL;
			_g_free0 (starts_in_text);
			return result;
		}
	}
}

static void
break_timer_daemon_rest_break_rest_break_view_real_dismiss_break (BreakTimerDaemonBreakBreakView* base)
{
	BreakTimerDaemonRestBreakRestBreakView * self;
	BreakTimerDaemonRestBreakRestBreakController* _tmp0_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp2_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	self = (BreakTimerDaemonRestBreakRestBreakView*) base;
	_tmp0_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = break_timer_daemon_timer_break_timer_break_controller_get_interval ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp3_);
	_tmp5_ = _tmp4_;
	break_timer_daemon_timer_break_timer_break_controller_postpone ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_, _tmp5_ / 4);
}

static void
break_timer_daemon_rest_break_rest_break_view_show_start_notification (BreakTimerDaemonRestBreakRestBreakView* self)
{
	gchar* body_text = NULL;
	gchar* _tmp0_;
	GNotification* notification = NULL;
	GNotification* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("It’s time to take a break. Get away from the computer for a little whi" \
"le!"));
	body_text = _tmp0_;
	_tmp1_ = g_notification_new (_ ("Time for a break"));
	notification = _tmp1_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	break_timer_daemon_rest_break_rest_break_view_add_notification_actions (self, notification);
	self->priv->last_break_notification_time = break_timer_common_time_unit_get_real_time_seconds ();
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.finished");
	break_timer_daemon_ui_fragment_show_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.active", notification);
	_g_object_unref0 (notification);
	_g_free0 (body_text);
}

static void
break_timer_daemon_rest_break_rest_break_view_show_interrupted_notification (BreakTimerDaemonRestBreakRestBreakView* self)
{
	gint countdown_value = 0;
	gint time_remaining = 0;
	BreakTimerDaemonRestBreakRestBreakController* _tmp0_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
	gint start_time = 0;
	BreakTimerDaemonRestBreakRestBreakController* _tmp2_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp3_;
	gchar* countdown_text = NULL;
	BreakTimerCommonNaturalTime* _tmp4_;
	BreakTimerCommonNaturalTime* _tmp5_;
	gint _tmp6_ = 0;
	gchar* _tmp7_;
	gchar* body_text = NULL;
	gchar* _tmp8_;
	GNotification* notification = NULL;
	GNotification* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp1_ = _tmp0_;
	time_remaining = break_timer_daemon_timer_break_timer_break_controller_get_time_remaining ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_);
	_tmp2_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp3_ = _tmp2_;
	start_time = break_timer_daemon_timer_break_timer_break_controller_get_current_duration ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp3_);
	_tmp4_ = break_timer_common_natural_time_get_instance ();
	_tmp5_ = _tmp4_;
	_tmp7_ = break_timer_common_natural_time_get_countdown_for_seconds_with_start (_tmp5_, time_remaining, start_time, &_tmp6_);
	countdown_value = _tmp6_;
	countdown_text = _tmp7_;
	_tmp8_ = g_strdup_printf (ngettext ("There is %s remaining in your break", "There are %s remaining in your break", (gulong) countdown_value), countdown_text);
	body_text = _tmp8_;
	_tmp9_ = g_notification_new (_ ("Break interrupted"));
	notification = _tmp9_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	break_timer_daemon_rest_break_rest_break_view_add_notification_actions (self, notification);
	self->priv->last_break_notification_time = break_timer_common_time_unit_get_real_time_seconds ();
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.finished");
	break_timer_daemon_ui_fragment_show_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.active", notification);
	_g_object_unref0 (notification);
	_g_free0 (body_text);
	_g_free0 (countdown_text);
}

static void
break_timer_daemon_rest_break_rest_break_view_show_overdue_notification (BreakTimerDaemonRestBreakRestBreakView* self)
{
	gint delay_value = 0;
	gint64 now = 0LL;
	gint time_since_start = 0;
	gchar* delay_text = NULL;
	BreakTimerCommonNaturalTime* _tmp0_;
	BreakTimerCommonNaturalTime* _tmp1_;
	gint _tmp2_ = 0;
	gchar* _tmp3_;
	gchar* body_text = NULL;
	gchar* _tmp4_;
	GNotification* notification = NULL;
	GNotification* _tmp5_;
	g_return_if_fail (self != NULL);
	now = break_timer_common_time_unit_get_real_time_seconds ();
	time_since_start = (gint) (now - self->priv->original_start_time);
	_tmp0_ = break_timer_common_natural_time_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp3_ = break_timer_common_natural_time_get_simplest_label_for_seconds (_tmp1_, time_since_start, &_tmp2_);
	delay_value = _tmp2_;
	delay_text = _tmp3_;
	_tmp4_ = g_strdup_printf (ngettext ("You were due to take a break %s ago", "You were due to take a break %s ago", (gulong) delay_value), delay_text);
	body_text = _tmp4_;
	_tmp5_ = g_notification_new (_ ("Overdue break"));
	notification = _tmp5_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	break_timer_daemon_rest_break_rest_break_view_add_notification_actions (self, notification);
	self->priv->last_break_notification_time = break_timer_common_time_unit_get_real_time_seconds ();
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.finished");
	break_timer_daemon_ui_fragment_show_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.active", notification);
	_g_object_unref0 (notification);
	_g_free0 (body_text);
	_g_free0 (delay_text);
}

static void
break_timer_daemon_rest_break_rest_break_view_show_finished_notification (BreakTimerDaemonRestBreakRestBreakView* self)
{
	gchar* body_text = NULL;
	gchar* _tmp0_;
	GNotification* notification = NULL;
	GNotification* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Your break time has ended"));
	body_text = _tmp0_;
	_tmp1_ = g_notification_new (_ ("Break is over"));
	notification = _tmp1_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_NORMAL);
	g_notification_set_default_action (notification, "app.show-break-info");
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.active");
	break_timer_daemon_ui_fragment_show_transient_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.finished", notification);
	break_timer_daemon_ui_fragment_play_sound_from_id ((BreakTimerDaemonUIFragment*) self, "complete");
	_g_object_unref0 (notification);
	_g_free0 (body_text);
}

static void
break_timer_daemon_rest_break_rest_break_view_add_notification_actions (BreakTimerDaemonRestBreakRestBreakView* self,
                                                                        GNotification* notification)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_notification_add_button (notification, _ ("Remind me later"), "app.dismiss-break::restbreak");
	g_notification_add_button (notification, _ ("What should I do?"), "app.show-break-info");
	g_notification_set_default_action (notification, "app.show-break-info");
}

static gint
break_timer_daemon_rest_break_rest_break_view_seconds_since_last_break_notification (BreakTimerDaemonRestBreakRestBreakView* self)
{
	gint64 now = 0LL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	now = break_timer_common_time_unit_get_real_time_seconds ();
	if (self->priv->last_break_notification_time > ((gint64) 0)) {
		result = (gint) (now - self->priv->last_break_notification_time);
		return result;
	} else {
		result = 0;
		return result;
	}
}

static void
_break_timer_daemon_rest_break_rest_break_view_counting_cb_break_timer_daemon_timer_break_timer_break_controller_counting (BreakTimerDaemonTimerBreakTimerBreakController* _sender,
                                                                                                                           gint lap_time,
                                                                                                                           gint total_time,
                                                                                                                           gpointer self)
{
	break_timer_daemon_rest_break_rest_break_view_counting_cb ((BreakTimerDaemonRestBreakRestBreakView*) self, lap_time, total_time);
}

static void
_break_timer_daemon_rest_break_rest_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed (BreakTimerDaemonTimerBreakTimerBreakController* _sender,
                                                                                                                         gint lap_time,
                                                                                                                         gint total_time,
                                                                                                                         gpointer self)
{
	break_timer_daemon_rest_break_rest_break_view_delayed_cb ((BreakTimerDaemonRestBreakRestBreakView*) self, lap_time, total_time);
}

static void
_break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb_break_timer_daemon_rest_break_rest_break_controller_current_duration_changed (BreakTimerDaemonRestBreakRestBreakController* _sender,
                                                                                                                                                         gpointer self)
{
	break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb ((BreakTimerDaemonRestBreakRestBreakView*) self);
}

static void
break_timer_daemon_rest_break_rest_break_view_focused_and_activated_cb (BreakTimerDaemonRestBreakRestBreakView* self)
{
	BreakTimerDaemonRestBreakRestBreakController* _tmp0_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp2_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp3_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp4_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp5_;
	g_return_if_fail (self != NULL);
	self->priv->human_is_resting = FALSE;
	if (!self->priv->was_skipped) {
		self->priv->original_start_time = break_timer_common_time_unit_get_real_time_seconds ();
		break_timer_daemon_rest_break_rest_break_view_show_start_notification (self);
	} else {
		break_timer_daemon_rest_break_rest_break_view_show_overdue_notification (self);
	}
	_tmp0_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_, "counting", (GCallback) _break_timer_daemon_rest_break_rest_break_view_counting_cb_break_timer_daemon_timer_break_timer_break_controller_counting, self, 0);
	_tmp2_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp3_, "delayed", (GCallback) _break_timer_daemon_rest_break_rest_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed, self, 0);
	_tmp4_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "current-duration-changed", (GCallback) _break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb_break_timer_daemon_rest_break_rest_break_controller_current_duration_changed, self, 0);
}

static void
break_timer_daemon_rest_break_rest_break_view_lost_ui_focus_cb (BreakTimerDaemonRestBreakRestBreakView* self)
{
	BreakTimerDaemonRestBreakRestBreakController* _tmp0_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
	guint _tmp2_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp3_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp4_;
	guint _tmp5_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp6_;
	BreakTimerDaemonRestBreakRestBreakController* _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("counting", BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _break_timer_daemon_rest_break_rest_break_view_counting_cb_break_timer_daemon_timer_break_timer_break_controller_counting, self);
	_tmp3_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("delayed", BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _break_timer_daemon_rest_break_rest_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed, self);
	_tmp6_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
	_tmp7_ = _tmp6_;
	g_signal_parse_name ("current-duration-changed", BREAK_TIMER_DAEMON_REST_BREAK_TYPE_REST_BREAK_CONTROLLER, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb_break_timer_daemon_rest_break_rest_break_controller_current_duration_changed, self);
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.active");
}

static void
break_timer_daemon_rest_break_rest_break_view_finished_cb (BreakTimerDaemonRestBreakRestBreakView* self,
                                                           BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                           gboolean was_active)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->was_skipped = reason == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SKIPPED;
	if (was_active) {
		_tmp0_ = reason == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SATISFIED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		break_timer_daemon_rest_break_rest_break_view_show_finished_notification (self);
	} else {
		break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "restbreak.active");
	}
}

static void
break_timer_daemon_rest_break_rest_break_view_counting_cb (BreakTimerDaemonRestBreakRestBreakView* self,
                                                           gint lap_time,
                                                           gint total_time)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->human_is_resting = lap_time > 20;
	if (self->priv->human_is_resting) {
		BreakTimerDaemonRestBreakRestBreakController* _tmp1_;
		BreakTimerDaemonRestBreakRestBreakController* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = break_timer_daemon_rest_break_rest_break_view_get_rest_break (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = break_timer_daemon_rest_break_rest_break_controller_get_lock_screen_enabled (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		break_timer_daemon_ui_fragment_lock_screen ((BreakTimerDaemonUIFragment*) self);
	}
}

static void
break_timer_daemon_rest_break_rest_break_view_delayed_cb (BreakTimerDaemonRestBreakRestBreakView* self,
                                                          gint lap_time,
                                                          gint total_time)
{
	g_return_if_fail (self != NULL);
	if (self->priv->human_is_resting) {
		break_timer_daemon_rest_break_rest_break_view_show_interrupted_notification (self);
	} else {
		if (break_timer_daemon_rest_break_rest_break_view_seconds_since_last_break_notification (self) > 60) {
			break_timer_daemon_rest_break_rest_break_view_show_overdue_notification (self);
		}
	}
	self->priv->human_is_resting = FALSE;
}

static void
break_timer_daemon_rest_break_rest_break_view_current_duration_changed_cb (BreakTimerDaemonRestBreakRestBreakView* self)
{
	g_return_if_fail (self != NULL);
}

BreakTimerDaemonRestBreakRestBreakController*
break_timer_daemon_rest_break_rest_break_view_get_rest_break (BreakTimerDaemonRestBreakRestBreakView* self)
{
	BreakTimerDaemonRestBreakRestBreakController* result;
	BreakTimerDaemonBreakBreakController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((BreakTimerDaemonBreakBreakView*) self)->break_controller;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BREAK_TIMER_DAEMON_REST_BREAK_TYPE_REST_BREAK_CONTROLLER, BreakTimerDaemonRestBreakRestBreakController);
	return result;
}

static BreakTimerDaemonUtilFocusPriority
break_timer_daemon_rest_break_rest_break_view_real_get_focus_priority (BreakTimerDaemonUIFragment* base)
{
	BreakTimerDaemonUtilFocusPriority result;
	BreakTimerDaemonRestBreakRestBreakView* self;
	self = (BreakTimerDaemonRestBreakRestBreakView*) base;
	result = self->priv->_focus_priority;
	return result;
}

static gchar**
break_timer_daemon_rest_break_rest_break_view_real_get_notification_ids (BreakTimerDaemonUIFragment* base,
                                                                         gint* result_length1)
{
	gchar** result;
	BreakTimerDaemonRestBreakRestBreakView* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (BreakTimerDaemonRestBreakRestBreakView*) base;
	_tmp0_ = self->priv->_notification_ids;
	_tmp0__length1 = self->priv->_notification_ids_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
break_timer_daemon_rest_break_rest_break_view_class_init (BreakTimerDaemonRestBreakRestBreakViewClass * klass,
                                                          gpointer klass_data)
{
	break_timer_daemon_rest_break_rest_break_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonRestBreakRestBreakView_private_offset);
	((BreakTimerDaemonBreakBreakViewClass *) klass)->get_status_message = (gchar* (*) (BreakTimerDaemonBreakBreakView*)) break_timer_daemon_rest_break_rest_break_view_real_get_status_message;
	((BreakTimerDaemonBreakBreakViewClass *) klass)->dismiss_break = (void (*) (BreakTimerDaemonBreakBreakView*)) break_timer_daemon_rest_break_rest_break_view_real_dismiss_break;
	BREAK_TIMER_DAEMON_UI_FRAGMENT_CLASS (klass)->get_focus_priority = (BreakTimerDaemonUtilFocusPriority (*) (BreakTimerDaemonUIFragment*)) break_timer_daemon_rest_break_rest_break_view_real_get_focus_priority;
	BREAK_TIMER_DAEMON_UI_FRAGMENT_CLASS (klass)->get_notification_ids = (gchar** (*) (BreakTimerDaemonUIFragment*, gint*)) break_timer_daemon_rest_break_rest_break_view_real_get_notification_ids;
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_daemon_rest_break_rest_break_view_get_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_rest_break_rest_break_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_REST_BREAK_PROPERTY, break_timer_daemon_rest_break_rest_break_view_properties[BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_REST_BREAK_PROPERTY] = g_param_spec_object ("rest-break", "rest-break", "rest-break", BREAK_TIMER_DAEMON_REST_BREAK_TYPE_REST_BREAK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY, break_timer_daemon_rest_break_rest_break_view_properties[BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY] = g_param_spec_enum ("focus-priority", "focus-priority", "focus-priority", BREAK_TIMER_DAEMON_UTIL_TYPE_FOCUS_PRIORITY, BREAK_TIMER_DAEMON_UTIL_FOCUS_PRIORITY_HIGH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY, break_timer_daemon_rest_break_rest_break_view_properties[BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY] = g_param_spec_boxed ("notification-ids", "notification-ids", "notification-ids", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
break_timer_daemon_rest_break_rest_break_view_instance_init (BreakTimerDaemonRestBreakRestBreakView * self,
                                                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	self->priv = break_timer_daemon_rest_break_rest_break_view_get_instance_private (self);
	self->priv->_focus_priority = BREAK_TIMER_DAEMON_UTIL_FOCUS_PRIORITY_HIGH;
	_tmp0_ = g_strdup ("restbreak.active");
	_tmp1_ = g_strdup ("restbreak.finished");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->_notification_ids = _tmp2_;
	self->priv->_notification_ids_length1 = 2;
	self->priv->__notification_ids_size_ = self->priv->_notification_ids_length1;
	self->priv->original_start_time = (gint64) 0;
	self->priv->was_skipped = FALSE;
	self->priv->human_is_resting = FALSE;
	self->priv->last_break_notification_time = (gint64) 0;
}

static void
break_timer_daemon_rest_break_rest_break_view_finalize (GObject * obj)
{
	BreakTimerDaemonRestBreakRestBreakView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_REST_BREAK_TYPE_REST_BREAK_VIEW, BreakTimerDaemonRestBreakRestBreakView);
	self->priv->_notification_ids = (_vala_array_free (self->priv->_notification_ids, self->priv->_notification_ids_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (break_timer_daemon_rest_break_rest_break_view_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_rest_break_rest_break_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonRestBreakRestBreakViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_rest_break_rest_break_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonRestBreakRestBreakView), 0, (GInstanceInitFunc) break_timer_daemon_rest_break_rest_break_view_instance_init, NULL };
	GType break_timer_daemon_rest_break_rest_break_view_type_id;
	break_timer_daemon_rest_break_rest_break_view_type_id = g_type_register_static (BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_VIEW, "BreakTimerDaemonRestBreakRestBreakView", &g_define_type_info, 0);
	BreakTimerDaemonRestBreakRestBreakView_private_offset = g_type_add_instance_private (break_timer_daemon_rest_break_rest_break_view_type_id, sizeof (BreakTimerDaemonRestBreakRestBreakViewPrivate));
	return break_timer_daemon_rest_break_rest_break_view_type_id;
}

GType
break_timer_daemon_rest_break_rest_break_view_get_type (void)
{
	static volatile gsize break_timer_daemon_rest_break_rest_break_view_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_rest_break_rest_break_view_type_id__once)) {
		GType break_timer_daemon_rest_break_rest_break_view_type_id;
		break_timer_daemon_rest_break_rest_break_view_type_id = break_timer_daemon_rest_break_rest_break_view_get_type_once ();
		g_once_init_leave (&break_timer_daemon_rest_break_rest_break_view_type_id__once, break_timer_daemon_rest_break_rest_break_view_type_id);
	}
	return break_timer_daemon_rest_break_rest_break_view_type_id__once;
}

static void
_vala_break_timer_daemon_rest_break_rest_break_view_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec)
{
	BreakTimerDaemonRestBreakRestBreakView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_REST_BREAK_TYPE_REST_BREAK_VIEW, BreakTimerDaemonRestBreakRestBreakView);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_REST_BREAK_PROPERTY:
		g_value_set_object (value, break_timer_daemon_rest_break_rest_break_view_get_rest_break (self));
		break;
		case BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY:
		g_value_set_enum (value, break_timer_daemon_ui_fragment_get_focus_priority ((BreakTimerDaemonUIFragment*) self));
		break;
		case BREAK_TIMER_DAEMON_REST_BREAK_REST_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, break_timer_daemon_ui_fragment_get_notification_ids ((BreakTimerDaemonUIFragment*) self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

