// Generated Code - DO NOT EDIT !!
// generated by 'emugen'


#include <string.h>
#include "renderControl_opcodes.h"

#include "renderControl_dec.h"


#include "ProtocolUtils.h"

#include "ChecksumCalculatorThreadInfo.h"

#include "host-common/logging.h"

#include <stdio.h>

namespace gfxstream {

typedef unsigned int tsize_t; // Target "size_t", which is 32-bit for now. It may or may not be the same as host's size_t when emugen is compiled.

#ifdef CHECK_GL_ERRORS
#  define SET_LASTCALL(name)  sprintf(lastCall, #name)
#else
#  define SET_LASTCALL(name)
#endif
size_t renderControl_decoder_context_t::decode(void *buf, size_t len, IOStream *stream, ChecksumCalculator* checksumCalc) {
	if (len < 8) return 0;
#ifdef CHECK_GL_ERRORS
	char lastCall[256] = {0};
#endif
	unsigned char *ptr = (unsigned char *)buf;
	const unsigned char* const end = (const unsigned char*)buf + len;
	while (end - ptr >= 8) {
		uint32_t opcode = *(uint32_t *)ptr;
		uint32_t packetLen = *(uint32_t *)(ptr + 4);
		if (end - ptr < packetLen) return ptr - (unsigned char*)buf;
        // Do this on every iteration, as some commands may change the checksum
        // calculation parameters.
        const size_t checksumSize = checksumCalc->checksumByteSize();
        const bool useChecksum = checksumSize > 0;
		switch(opcode) {
		case OP_rcGetRendererVersion: {
			android::base::beginTrace("rcGetRendererVersion decode");
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8, ptr + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetRendererVersion: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(GLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetRendererVersion()", stream);
			*(GLint *)(&tmpBuf[0]) = 			this->rcGetRendererVersion();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetRendererVersion");
			android::base::endTrace();
			break;
		}
		case OP_rcGetEGLVersion: {
			android::base::beginTrace("rcGetEGLVersion decode");
			uint32_t size_major __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_minor __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetEGLVersion: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_major;
			totalTmpSize += size_minor;
			totalTmpSize += sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_major(&tmpBuf[0], size_major);
			OutputBuffer outptr_minor(&tmpBuf[0 + size_major], size_minor);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetEGLVersion(major:%p(%u) minor:%p(%u) )", stream, (EGLint*)(outptr_major.get()), size_major, (EGLint*)(outptr_minor.get()), size_minor);
			*(EGLint *)(&tmpBuf[0 + size_major + size_minor]) = 			this->rcGetEGLVersion((EGLint*)(outptr_major.get()), (EGLint*)(outptr_minor.get()));
			outptr_major.flush();
			outptr_minor.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetEGLVersion");
			android::base::endTrace();
			break;
		}
		case OP_rcQueryEGLString: {
			android::base::beginTrace("rcQueryEGLString decode");
			EGLenum var_name = Unpack<EGLenum,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			EGLint var_bufferSize = Unpack<EGLint,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcQueryEGLString: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_buffer;
			totalTmpSize += sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_buffer(&tmpBuf[0], size_buffer);
			DECODER_DEBUG_LOG("renderControl(%p): rcQueryEGLString(name:0x%08x buffer:%p(%u) bufferSize:0x%08x )", stream, var_name, (void*)(outptr_buffer.get()), size_buffer, var_bufferSize);
			*(EGLint *)(&tmpBuf[0 + size_buffer]) = 			this->rcQueryEGLString(var_name, (void*)(outptr_buffer.get()), var_bufferSize);
			outptr_buffer.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcQueryEGLString");
			android::base::endTrace();
			break;
		}
		case OP_rcGetGLString: {
			android::base::beginTrace("rcGetGLString decode");
			EGLenum var_name = Unpack<EGLenum,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			EGLint var_bufferSize = Unpack<EGLint,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetGLString: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_buffer;
			totalTmpSize += sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_buffer(&tmpBuf[0], size_buffer);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetGLString(name:0x%08x buffer:%p(%u) bufferSize:0x%08x )", stream, var_name, (void*)(outptr_buffer.get()), size_buffer, var_bufferSize);
			*(EGLint *)(&tmpBuf[0 + size_buffer]) = 			this->rcGetGLString(var_name, (void*)(outptr_buffer.get()), var_bufferSize);
			outptr_buffer.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetGLString");
			android::base::endTrace();
			break;
		}
		case OP_rcGetNumConfigs: {
			android::base::beginTrace("rcGetNumConfigs decode");
			uint32_t size_numAttribs __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetNumConfigs: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_numAttribs;
			totalTmpSize += sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_numAttribs(&tmpBuf[0], size_numAttribs);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetNumConfigs(numAttribs:%p(%u) )", stream, (uint32_t*)(outptr_numAttribs.get()), size_numAttribs);
			*(EGLint *)(&tmpBuf[0 + size_numAttribs]) = 			this->rcGetNumConfigs((uint32_t*)(outptr_numAttribs.get()));
			outptr_numAttribs.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetNumConfigs");
			android::base::endTrace();
			break;
		}
		case OP_rcGetConfigs: {
			android::base::beginTrace("rcGetConfigs decode");
			uint32_t var_bufSize = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetConfigs: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_buffer;
			totalTmpSize += sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_buffer(&tmpBuf[0], size_buffer);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetConfigs(bufSize:0x%08x buffer:%p(%u) )", stream, var_bufSize, (GLuint*)(outptr_buffer.get()), size_buffer);
			*(EGLint *)(&tmpBuf[0 + size_buffer]) = 			this->rcGetConfigs(var_bufSize, (GLuint*)(outptr_buffer.get()));
			outptr_buffer.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetConfigs");
			android::base::endTrace();
			break;
		}
		case OP_rcChooseConfig: {
			android::base::beginTrace("rcChooseConfig decode");
			uint32_t size_attribs __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8);
			InputBuffer inptr_attribs(ptr + 8 + 4, size_attribs);
			uint32_t var_attribs_size = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + size_attribs);
			uint32_t size_configs __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + size_attribs + 4);
			uint32_t var_configs_size = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + size_attribs + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + size_attribs + 4 + 4 + 4, ptr + 8 + 4 + size_attribs + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcChooseConfig: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_configs;
			totalTmpSize += sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_configs(&tmpBuf[0], size_configs);
			DECODER_DEBUG_LOG("renderControl(%p): rcChooseConfig(attribs:%p(%u) attribs_size:0x%08x configs:%p(%u) configs_size:0x%08x )", stream, (EGLint*)(inptr_attribs.get()), size_attribs, var_attribs_size, (uint32_t*)(outptr_configs.get()), size_configs, var_configs_size);
			*(EGLint *)(&tmpBuf[0 + size_configs]) = 			this->rcChooseConfig((EGLint*)(inptr_attribs.get()), var_attribs_size, size_configs == 0 ? nullptr : (uint32_t*)(outptr_configs.get()), var_configs_size);
			outptr_configs.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcChooseConfig");
			android::base::endTrace();
			break;
		}
		case OP_rcGetFBParam: {
			android::base::beginTrace("rcGetFBParam decode");
			EGLint var_param = Unpack<EGLint,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetFBParam: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetFBParam(param:0x%08x )", stream, var_param);
			*(EGLint *)(&tmpBuf[0]) = 			this->rcGetFBParam(var_param);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetFBParam");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateContext: {
			android::base::beginTrace("rcCreateContext decode");
			uint32_t var_config = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_share = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			uint32_t var_glVersion = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateContext: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateContext(config:0x%08x share:0x%08x glVersion:0x%08x )", stream, var_config, var_share, var_glVersion);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateContext(var_config, var_share, var_glVersion);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateContext");
			android::base::endTrace();
			break;
		}
		case OP_rcDestroyContext: {
			android::base::beginTrace("rcDestroyContext decode");
			uint32_t var_context = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcDestroyContext: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcDestroyContext(context:0x%08x )", stream, var_context);
			this->rcDestroyContext(var_context);
			SET_LASTCALL("rcDestroyContext");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateWindowSurface: {
			android::base::beginTrace("rcCreateWindowSurface decode");
			uint32_t var_config = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_width = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			uint32_t var_height = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateWindowSurface: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateWindowSurface(config:0x%08x width:0x%08x height:0x%08x )", stream, var_config, var_width, var_height);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateWindowSurface(var_config, var_width, var_height);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateWindowSurface");
			android::base::endTrace();
			break;
		}
		case OP_rcDestroyWindowSurface: {
			android::base::beginTrace("rcDestroyWindowSurface decode");
			uint32_t var_windowSurface = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcDestroyWindowSurface: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcDestroyWindowSurface(windowSurface:0x%08x )", stream, var_windowSurface);
			this->rcDestroyWindowSurface(var_windowSurface);
			SET_LASTCALL("rcDestroyWindowSurface");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateColorBuffer: {
			android::base::beginTrace("rcCreateColorBuffer decode");
			uint32_t var_width = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_height = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			GLenum var_internalFormat = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateColorBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateColorBuffer(width:0x%08x height:0x%08x internalFormat:0x%08x )", stream, var_width, var_height, var_internalFormat);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateColorBuffer(var_width, var_height, var_internalFormat);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcOpenColorBuffer: {
			android::base::beginTrace("rcOpenColorBuffer decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcOpenColorBuffer: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcOpenColorBuffer(colorbuffer:0x%08x )", stream, var_colorbuffer);
			this->rcOpenColorBuffer(var_colorbuffer);
			SET_LASTCALL("rcOpenColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcCloseColorBuffer: {
			android::base::beginTrace("rcCloseColorBuffer decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCloseColorBuffer: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcCloseColorBuffer(colorbuffer:0x%08x )", stream, var_colorbuffer);
			this->rcCloseColorBuffer(var_colorbuffer);
			SET_LASTCALL("rcCloseColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcSetWindowColorBuffer: {
			android::base::beginTrace("rcSetWindowColorBuffer decode");
			uint32_t var_windowSurface = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetWindowColorBuffer: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcSetWindowColorBuffer(windowSurface:0x%08x colorBuffer:0x%08x )", stream, var_windowSurface, var_colorBuffer);
			this->rcSetWindowColorBuffer(var_windowSurface, var_colorBuffer);
			SET_LASTCALL("rcSetWindowColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcFlushWindowColorBuffer: {
			android::base::beginTrace("rcFlushWindowColorBuffer decode");
			uint32_t var_windowSurface = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcFlushWindowColorBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcFlushWindowColorBuffer(windowSurface:0x%08x )", stream, var_windowSurface);
			*(int *)(&tmpBuf[0]) = 			this->rcFlushWindowColorBuffer(var_windowSurface);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcFlushWindowColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcMakeCurrent: {
			android::base::beginTrace("rcMakeCurrent decode");
			uint32_t var_context = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_drawSurf = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			uint32_t var_readSurf = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcMakeCurrent: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcMakeCurrent(context:0x%08x drawSurf:0x%08x readSurf:0x%08x )", stream, var_context, var_drawSurf, var_readSurf);
			*(EGLint *)(&tmpBuf[0]) = 			this->rcMakeCurrent(var_context, var_drawSurf, var_readSurf);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcMakeCurrent");
			android::base::endTrace();
			break;
		}
		case OP_rcFBPost: {
			android::base::beginTrace("rcFBPost decode");
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcFBPost: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcFBPost(colorBuffer:0x%08x )", stream, var_colorBuffer);
			this->rcFBPost(var_colorBuffer);
			SET_LASTCALL("rcFBPost");
			android::base::endTrace();
			break;
		}
		case OP_rcFBSetSwapInterval: {
			android::base::beginTrace("rcFBSetSwapInterval decode");
			EGLint var_interval = Unpack<EGLint,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcFBSetSwapInterval: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcFBSetSwapInterval(interval:0x%08x )", stream, var_interval);
			this->rcFBSetSwapInterval(var_interval);
			SET_LASTCALL("rcFBSetSwapInterval");
			android::base::endTrace();
			break;
		}
		case OP_rcBindTexture: {
			android::base::beginTrace("rcBindTexture decode");
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcBindTexture: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcBindTexture(colorBuffer:0x%08x )", stream, var_colorBuffer);
			this->rcBindTexture(var_colorBuffer);
			SET_LASTCALL("rcBindTexture");
			android::base::endTrace();
			break;
		}
		case OP_rcBindRenderbuffer: {
			android::base::beginTrace("rcBindRenderbuffer decode");
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcBindRenderbuffer: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcBindRenderbuffer(colorBuffer:0x%08x )", stream, var_colorBuffer);
			this->rcBindRenderbuffer(var_colorBuffer);
			SET_LASTCALL("rcBindRenderbuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcColorBufferCacheFlush: {
			android::base::beginTrace("rcColorBufferCacheFlush decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			EGLint var_postCount = Unpack<EGLint,uint32_t>(ptr + 8 + 4);
			int var_forRead = Unpack<int,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcColorBufferCacheFlush: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcColorBufferCacheFlush(colorbuffer:0x%08x postCount:0x%08x forRead:%d )", stream, var_colorbuffer, var_postCount, var_forRead);
			*(EGLint *)(&tmpBuf[0]) = 			this->rcColorBufferCacheFlush(var_colorbuffer, var_postCount, var_forRead);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcColorBufferCacheFlush");
			android::base::endTrace();
			break;
		}
		case OP_rcReadColorBuffer: {
			android::base::beginTrace("rcReadColorBuffer decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			GLint var_width = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4);
			GLint var_height = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			GLenum var_format = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4);
			GLenum var_type = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4);
			uint32_t size_pixels __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcReadColorBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_pixels;
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_pixels(&tmpBuf[0], size_pixels);
			DECODER_DEBUG_LOG("renderControl(%p): rcReadColorBuffer(colorbuffer:0x%08x x:0x%08x y:0x%08x width:0x%08x height:0x%08x format:0x%08x type:0x%08x pixels:%p(%u) )", stream, var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, (void*)(outptr_pixels.get()), size_pixels);
			this->rcReadColorBuffer(var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, (void*)(outptr_pixels.get()));
			outptr_pixels.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcReadColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcUpdateColorBuffer: {
			android::base::beginTrace("rcUpdateColorBuffer decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			GLint var_width = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4);
			GLint var_height = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			GLenum var_format = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4);
			GLenum var_type = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4);
			uint32_t size_pixels __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4);
			InputBuffer inptr_pixels(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4, size_pixels);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + size_pixels, ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + size_pixels, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcUpdateColorBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcUpdateColorBuffer(colorbuffer:0x%08x x:0x%08x y:0x%08x width:0x%08x height:0x%08x format:0x%08x type:0x%08x pixels:%p(%u) )", stream, var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, (void*)(inptr_pixels.get()), size_pixels);
			*(int *)(&tmpBuf[0]) = 			this->rcUpdateColorBuffer(var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, (void*)(inptr_pixels.get()));
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcUpdateColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcOpenColorBuffer2: {
			android::base::beginTrace("rcOpenColorBuffer2 decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcOpenColorBuffer2: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcOpenColorBuffer2(colorbuffer:0x%08x )", stream, var_colorbuffer);
			*(int *)(&tmpBuf[0]) = 			this->rcOpenColorBuffer2(var_colorbuffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcOpenColorBuffer2");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateClientImage: {
			android::base::beginTrace("rcCreateClientImage decode");
			uint32_t var_context = Unpack<uint32_t,uint32_t>(ptr + 8);
			EGLenum var_target = Unpack<EGLenum,uint32_t>(ptr + 8 + 4);
			GLuint var_buffer = Unpack<GLuint,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateClientImage: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateClientImage(context:0x%08x target:0x%08x buffer:0x%08x )", stream, var_context, var_target, var_buffer);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateClientImage(var_context, var_target, var_buffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateClientImage");
			android::base::endTrace();
			break;
		}
		case OP_rcDestroyClientImage: {
			android::base::beginTrace("rcDestroyClientImage decode");
			uint32_t var_image = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcDestroyClientImage: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcDestroyClientImage(image:0x%08x )", stream, var_image);
			*(int *)(&tmpBuf[0]) = 			this->rcDestroyClientImage(var_image);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcDestroyClientImage");
			android::base::endTrace();
			break;
		}
		case OP_rcSelectChecksumHelper: {
			android::base::beginTrace("rcSelectChecksumHelper decode");
			uint32_t var_newProtocol = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_reserved = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSelectChecksumHelper: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcSelectChecksumHelper(newProtocol:0x%08x reserved:0x%08x )", stream, var_newProtocol, var_reserved);
			this->rcSelectChecksumHelper(var_newProtocol, var_reserved);
			SET_LASTCALL("rcSelectChecksumHelper");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateSyncKHR: {
			android::base::beginTrace("rcCreateSyncKHR decode");
			EGLenum var_type = Unpack<EGLenum,uint32_t>(ptr + 8);
			uint32_t size_attribs __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			InputBuffer inptr_attribs(ptr + 8 + 4 + 4, size_attribs);
			uint32_t var_num_attribs = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + size_attribs);
			int var_destroy_when_signaled = Unpack<int,uint32_t>(ptr + 8 + 4 + 4 + size_attribs + 4);
			uint32_t size_glsync_out __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + size_attribs + 4 + 4);
			uint32_t size_syncthread_out __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + size_attribs + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + size_attribs + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + size_attribs + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateSyncKHR: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_glsync_out;
			totalTmpSize += size_syncthread_out;
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_glsync_out(&tmpBuf[0], size_glsync_out);
			OutputBuffer outptr_syncthread_out(&tmpBuf[0 + size_glsync_out], size_syncthread_out);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateSyncKHR(type:0x%08x attribs:%p(%u) num_attribs:0x%08x destroy_when_signaled:%d glsync_out:%p(%u) syncthread_out:%p(%u) )", stream, var_type, (EGLint*)(inptr_attribs.get()), size_attribs, var_num_attribs, var_destroy_when_signaled, (uint64_t*)(outptr_glsync_out.get()), size_glsync_out, (uint64_t*)(outptr_syncthread_out.get()), size_syncthread_out);
			this->rcCreateSyncKHR(var_type, (EGLint*)(inptr_attribs.get()), var_num_attribs, var_destroy_when_signaled, (uint64_t*)(outptr_glsync_out.get()), (uint64_t*)(outptr_syncthread_out.get()));
			outptr_glsync_out.flush();
			outptr_syncthread_out.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateSyncKHR");
			android::base::endTrace();
			break;
		}
		case OP_rcClientWaitSyncKHR: {
			android::base::beginTrace("rcClientWaitSyncKHR decode");
			uint64_t var_sync = Unpack<uint64_t,uint64_t>(ptr + 8);
			EGLint var_flags = Unpack<EGLint,uint32_t>(ptr + 8 + 8);
			uint64_t var_timeout = Unpack<uint64_t,uint64_t>(ptr + 8 + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8 + 4 + 8, ptr + 8 + 8 + 4 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcClientWaitSyncKHR: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(EGLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcClientWaitSyncKHR(sync:0x%016lx flags:0x%08x timeout:0x%016lx )", stream, var_sync, var_flags, var_timeout);
			*(EGLint *)(&tmpBuf[0]) = 			this->rcClientWaitSyncKHR(var_sync, var_flags, var_timeout);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcClientWaitSyncKHR");
			android::base::endTrace();
			break;
		}
		case OP_rcFlushWindowColorBufferAsync: {
			android::base::beginTrace("rcFlushWindowColorBufferAsync decode");
			uint32_t var_windowSurface = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcFlushWindowColorBufferAsync: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcFlushWindowColorBufferAsync(windowSurface:0x%08x )", stream, var_windowSurface);
			this->rcFlushWindowColorBufferAsync(var_windowSurface);
			SET_LASTCALL("rcFlushWindowColorBufferAsync");
			android::base::endTrace();
			break;
		}
		case OP_rcDestroySyncKHR: {
			android::base::beginTrace("rcDestroySyncKHR decode");
			uint64_t var_sync = Unpack<uint64_t,uint64_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8, ptr + 8 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcDestroySyncKHR: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcDestroySyncKHR(sync:0x%016lx )", stream, var_sync);
			*(int *)(&tmpBuf[0]) = 			this->rcDestroySyncKHR(var_sync);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcDestroySyncKHR");
			android::base::endTrace();
			break;
		}
		case OP_rcSetPuid: {
			android::base::beginTrace("rcSetPuid decode");
			uint64_t var_puid = Unpack<uint64_t,uint64_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8, ptr + 8 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetPuid: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcSetPuid(puid:0x%016lx )", stream, var_puid);
			this->rcSetPuid(var_puid);
			SET_LASTCALL("rcSetPuid");
			android::base::endTrace();
			break;
		}
		case OP_rcUpdateColorBufferDMA: {
			android::base::beginTrace("rcUpdateColorBufferDMA decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			GLint var_width = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4);
			GLint var_height = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			GLenum var_format = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4);
			GLenum var_type = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4);
			uint64_t var_pixels_guest_paddr = Unpack<uint64_t,uint64_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4);
			void* var_pixels = stream->getDmaForReading(var_pixels_guest_paddr);
			uint32_t size_pixels __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8);
			uint32_t var_pixels_size = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcUpdateColorBufferDMA: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcUpdateColorBufferDMA(colorbuffer:0x%08x x:0x%08x y:0x%08x width:0x%08x height:0x%08x format:0x%08x type:0x%08x pixels:%p(%u) pixels_size:0x%08x )", stream, var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, var_pixels, var_pixels_size);
			*(int *)(&tmpBuf[0]) = 			this->rcUpdateColorBufferDMA(var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, var_pixels, var_pixels_size);
			stream->unlockDma(var_pixels_guest_paddr);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcUpdateColorBufferDMA");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateColorBufferDMA: {
			android::base::beginTrace("rcCreateColorBufferDMA decode");
			uint32_t var_width = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_height = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			GLenum var_internalFormat = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4);
			int var_frameworkFormat = Unpack<int,uint32_t>(ptr + 8 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateColorBufferDMA: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateColorBufferDMA(width:0x%08x height:0x%08x internalFormat:0x%08x frameworkFormat:%d )", stream, var_width, var_height, var_internalFormat, var_frameworkFormat);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateColorBufferDMA(var_width, var_height, var_internalFormat, var_frameworkFormat);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateColorBufferDMA");
			android::base::endTrace();
			break;
		}
		case OP_rcWaitSyncKHR: {
			android::base::beginTrace("rcWaitSyncKHR decode");
			uint64_t var_sync = Unpack<uint64_t,uint64_t>(ptr + 8);
			EGLint var_flags = Unpack<EGLint,uint32_t>(ptr + 8 + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8 + 4, ptr + 8 + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcWaitSyncKHR: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcWaitSyncKHR(sync:0x%016lx flags:0x%08x )", stream, var_sync, var_flags);
			this->rcWaitSyncKHR(var_sync, var_flags);
			SET_LASTCALL("rcWaitSyncKHR");
			android::base::endTrace();
			break;
		}
		case OP_rcCompose: {
			android::base::beginTrace("rcCompose decode");
			uint32_t var_bufferSize = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			InputBuffer inptr_buffer(ptr + 8 + 4 + 4, size_buffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + size_buffer, ptr + 8 + 4 + 4 + size_buffer, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCompose: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(GLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCompose(bufferSize:0x%08x buffer:%p(%u) )", stream, var_bufferSize, (void*)(inptr_buffer.get()), size_buffer);
			*(GLint *)(&tmpBuf[0]) = 			this->rcCompose(var_bufferSize, (void*)(inptr_buffer.get()));
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCompose");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateDisplay: {
			android::base::beginTrace("rcCreateDisplay decode");
			uint32_t size_displayId __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateDisplay: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_displayId;
			totalTmpSize += sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_displayId(&tmpBuf[0], size_displayId);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateDisplay(displayId:%p(%u) )", stream, (uint32_t*)(outptr_displayId.get()), size_displayId);
			*(int *)(&tmpBuf[0 + size_displayId]) = 			this->rcCreateDisplay((uint32_t*)(outptr_displayId.get()));
			outptr_displayId.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateDisplay");
			android::base::endTrace();
			break;
		}
		case OP_rcDestroyDisplay: {
			android::base::beginTrace("rcDestroyDisplay decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcDestroyDisplay: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcDestroyDisplay(displayId:0x%08x )", stream, var_displayId);
			*(int *)(&tmpBuf[0]) = 			this->rcDestroyDisplay(var_displayId);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcDestroyDisplay");
			android::base::endTrace();
			break;
		}
		case OP_rcSetDisplayColorBuffer: {
			android::base::beginTrace("rcSetDisplayColorBuffer decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetDisplayColorBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcSetDisplayColorBuffer(displayId:0x%08x colorBuffer:0x%08x )", stream, var_displayId, var_colorBuffer);
			*(int *)(&tmpBuf[0]) = 			this->rcSetDisplayColorBuffer(var_displayId, var_colorBuffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcSetDisplayColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcGetDisplayColorBuffer: {
			android::base::beginTrace("rcGetDisplayColorBuffer decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_colorBuffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetDisplayColorBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_colorBuffer;
			totalTmpSize += sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_colorBuffer(&tmpBuf[0], size_colorBuffer);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetDisplayColorBuffer(displayId:0x%08x colorBuffer:%p(%u) )", stream, var_displayId, (uint32_t*)(outptr_colorBuffer.get()), size_colorBuffer);
			*(int *)(&tmpBuf[0 + size_colorBuffer]) = 			this->rcGetDisplayColorBuffer(var_displayId, (uint32_t*)(outptr_colorBuffer.get()));
			outptr_colorBuffer.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetDisplayColorBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcGetColorBufferDisplay: {
			android::base::beginTrace("rcGetColorBufferDisplay decode");
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_displayId __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetColorBufferDisplay: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_displayId;
			totalTmpSize += sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_displayId(&tmpBuf[0], size_displayId);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetColorBufferDisplay(colorBuffer:0x%08x displayId:%p(%u) )", stream, var_colorBuffer, (uint32_t*)(outptr_displayId.get()), size_displayId);
			*(int *)(&tmpBuf[0 + size_displayId]) = 			this->rcGetColorBufferDisplay(var_colorBuffer, (uint32_t*)(outptr_displayId.get()));
			outptr_displayId.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetColorBufferDisplay");
			android::base::endTrace();
			break;
		}
		case OP_rcGetDisplayPose: {
			android::base::beginTrace("rcGetDisplayPose decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_x __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			uint32_t size_y __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4);
			uint32_t size_w __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4);
			uint32_t size_h __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetDisplayPose: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_x;
			totalTmpSize += size_y;
			totalTmpSize += size_w;
			totalTmpSize += size_h;
			totalTmpSize += sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_x(&tmpBuf[0], size_x);
			OutputBuffer outptr_y(&tmpBuf[0 + size_x], size_y);
			OutputBuffer outptr_w(&tmpBuf[0 + size_x + size_y], size_w);
			OutputBuffer outptr_h(&tmpBuf[0 + size_x + size_y + size_w], size_h);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetDisplayPose(displayId:0x%08x x:%p(%u) y:%p(%u) w:%p(%u) h:%p(%u) )", stream, var_displayId, (GLint*)(outptr_x.get()), size_x, (GLint*)(outptr_y.get()), size_y, (uint32_t*)(outptr_w.get()), size_w, (uint32_t*)(outptr_h.get()), size_h);
			*(int *)(&tmpBuf[0 + size_x + size_y + size_w + size_h]) = 			this->rcGetDisplayPose(var_displayId, (GLint*)(outptr_x.get()), (GLint*)(outptr_y.get()), (uint32_t*)(outptr_w.get()), (uint32_t*)(outptr_h.get()));
			outptr_x.flush();
			outptr_y.flush();
			outptr_w.flush();
			outptr_h.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetDisplayPose");
			android::base::endTrace();
			break;
		}
		case OP_rcSetDisplayPose: {
			android::base::beginTrace("rcSetDisplayPose decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			uint32_t var_w = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4);
			uint32_t var_h = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetDisplayPose: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcSetDisplayPose(displayId:0x%08x x:0x%08x y:0x%08x w:0x%08x h:0x%08x )", stream, var_displayId, var_x, var_y, var_w, var_h);
			*(int *)(&tmpBuf[0]) = 			this->rcSetDisplayPose(var_displayId, var_x, var_y, var_w, var_h);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcSetDisplayPose");
			android::base::endTrace();
			break;
		}
		case OP_rcSetColorBufferVulkanMode: {
			android::base::beginTrace("rcSetColorBufferVulkanMode decode");
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_mode = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetColorBufferVulkanMode: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(GLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcSetColorBufferVulkanMode(colorBuffer:0x%08x mode:0x%08x )", stream, var_colorBuffer, var_mode);
			*(GLint *)(&tmpBuf[0]) = 			this->rcSetColorBufferVulkanMode(var_colorBuffer, var_mode);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcSetColorBufferVulkanMode");
			android::base::endTrace();
			break;
		}
		case OP_rcReadColorBufferYUV: {
			android::base::beginTrace("rcReadColorBufferYUV decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			GLint var_width = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4);
			GLint var_height = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			uint32_t size_pixels __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4);
			uint32_t var_pixels_size = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcReadColorBufferYUV: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_pixels;
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_pixels(&tmpBuf[0], size_pixels);
			DECODER_DEBUG_LOG("renderControl(%p): rcReadColorBufferYUV(colorbuffer:0x%08x x:0x%08x y:0x%08x width:0x%08x height:0x%08x pixels:%p(%u) pixels_size:0x%08x )", stream, var_colorbuffer, var_x, var_y, var_width, var_height, (void*)(outptr_pixels.get()), size_pixels, var_pixels_size);
			this->rcReadColorBufferYUV(var_colorbuffer, var_x, var_y, var_width, var_height, (void*)(outptr_pixels.get()), var_pixels_size);
			outptr_pixels.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcReadColorBufferYUV");
			android::base::endTrace();
			break;
		}
		case OP_rcIsSyncSignaled: {
			android::base::beginTrace("rcIsSyncSignaled decode");
			uint64_t var_sync = Unpack<uint64_t,uint64_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8, ptr + 8 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcIsSyncSignaled: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcIsSyncSignaled(sync:0x%016lx )", stream, var_sync);
			*(int *)(&tmpBuf[0]) = 			this->rcIsSyncSignaled(var_sync);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcIsSyncSignaled");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateColorBufferWithHandle: {
			android::base::beginTrace("rcCreateColorBufferWithHandle decode");
			uint32_t var_width = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_height = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			GLenum var_internalFormat = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4);
			uint32_t var_handle = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateColorBufferWithHandle: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateColorBufferWithHandle(width:0x%08x height:0x%08x internalFormat:0x%08x handle:0x%08x )", stream, var_width, var_height, var_internalFormat, var_handle);
			this->rcCreateColorBufferWithHandle(var_width, var_height, var_internalFormat, var_handle);
			SET_LASTCALL("rcCreateColorBufferWithHandle");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateBuffer: {
			android::base::beginTrace("rcCreateBuffer decode");
			uint32_t var_size = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateBuffer: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateBuffer(size:0x%08x )", stream, var_size);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateBuffer(var_size);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcCloseBuffer: {
			android::base::beginTrace("rcCloseBuffer decode");
			uint32_t var_buffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCloseBuffer: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcCloseBuffer(buffer:0x%08x )", stream, var_buffer);
			this->rcCloseBuffer(var_buffer);
			SET_LASTCALL("rcCloseBuffer");
			android::base::endTrace();
			break;
		}
		case OP_rcSetColorBufferVulkanMode2: {
			android::base::beginTrace("rcSetColorBufferVulkanMode2 decode");
			uint32_t var_colorBuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_mode = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			uint32_t var_memoryProperty = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetColorBufferVulkanMode2: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(GLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcSetColorBufferVulkanMode2(colorBuffer:0x%08x mode:0x%08x memoryProperty:0x%08x )", stream, var_colorBuffer, var_mode, var_memoryProperty);
			*(GLint *)(&tmpBuf[0]) = 			this->rcSetColorBufferVulkanMode2(var_colorBuffer, var_mode, var_memoryProperty);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcSetColorBufferVulkanMode2");
			android::base::endTrace();
			break;
		}
		case OP_rcMapGpaToBufferHandle: {
			android::base::beginTrace("rcMapGpaToBufferHandle decode");
			uint32_t var_bufferHandle = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint64_t var_gpa = Unpack<uint64_t,uint64_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 8, ptr + 8 + 4 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcMapGpaToBufferHandle: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcMapGpaToBufferHandle(bufferHandle:0x%08x gpa:0x%016lx )", stream, var_bufferHandle, var_gpa);
			*(int *)(&tmpBuf[0]) = 			this->rcMapGpaToBufferHandle(var_bufferHandle, var_gpa);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcMapGpaToBufferHandle");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateBuffer2: {
			android::base::beginTrace("rcCreateBuffer2 decode");
			uint64_t var_size = Unpack<uint64_t,uint64_t>(ptr + 8);
			uint32_t var_memoryProperty = Unpack<uint32_t,uint32_t>(ptr + 8 + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8 + 4, ptr + 8 + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateBuffer2: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(uint32_t);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateBuffer2(size:0x%016lx memoryProperty:0x%08x )", stream, var_size, var_memoryProperty);
			*(uint32_t *)(&tmpBuf[0]) = 			this->rcCreateBuffer2(var_size, var_memoryProperty);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateBuffer2");
			android::base::endTrace();
			break;
		}
		case OP_rcMapGpaToBufferHandle2: {
			android::base::beginTrace("rcMapGpaToBufferHandle2 decode");
			uint32_t var_bufferHandle = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint64_t var_gpa = Unpack<uint64_t,uint64_t>(ptr + 8 + 4);
			uint64_t var_size = Unpack<uint64_t,uint64_t>(ptr + 8 + 4 + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 8 + 8, ptr + 8 + 4 + 8 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcMapGpaToBufferHandle2: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcMapGpaToBufferHandle2(bufferHandle:0x%08x gpa:0x%016lx size:0x%016lx )", stream, var_bufferHandle, var_gpa, var_size);
			*(int *)(&tmpBuf[0]) = 			this->rcMapGpaToBufferHandle2(var_bufferHandle, var_gpa, var_size);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcMapGpaToBufferHandle2");
			android::base::endTrace();
			break;
		}
		case OP_rcFlushWindowColorBufferAsyncWithFrameNumber: {
			android::base::beginTrace("rcFlushWindowColorBufferAsyncWithFrameNumber decode");
			uint32_t var_windowSurface = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_frameNumber = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcFlushWindowColorBufferAsyncWithFrameNumber: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcFlushWindowColorBufferAsyncWithFrameNumber(windowSurface:0x%08x frameNumber:0x%08x )", stream, var_windowSurface, var_frameNumber);
			this->rcFlushWindowColorBufferAsyncWithFrameNumber(var_windowSurface, var_frameNumber);
			SET_LASTCALL("rcFlushWindowColorBufferAsyncWithFrameNumber");
			android::base::endTrace();
			break;
		}
		case OP_rcSetTracingForPuid: {
			android::base::beginTrace("rcSetTracingForPuid decode");
			uint64_t var_puid = Unpack<uint64_t,uint64_t>(ptr + 8);
			uint32_t var_enable = Unpack<uint32_t,uint32_t>(ptr + 8 + 8);
			uint64_t var_guestTime = Unpack<uint64_t,uint64_t>(ptr + 8 + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8 + 4 + 8, ptr + 8 + 8 + 4 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetTracingForPuid: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcSetTracingForPuid(puid:0x%016lx enable:0x%08x guestTime:0x%016lx )", stream, var_puid, var_enable, var_guestTime);
			this->rcSetTracingForPuid(var_puid, var_enable, var_guestTime);
			SET_LASTCALL("rcSetTracingForPuid");
			android::base::endTrace();
			break;
		}
		case OP_rcMakeCurrentAsync: {
			android::base::beginTrace("rcMakeCurrentAsync decode");
			uint32_t var_context = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t var_drawSurf = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			uint32_t var_readSurf = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcMakeCurrentAsync: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcMakeCurrentAsync(context:0x%08x drawSurf:0x%08x readSurf:0x%08x )", stream, var_context, var_drawSurf, var_readSurf);
			this->rcMakeCurrentAsync(var_context, var_drawSurf, var_readSurf);
			SET_LASTCALL("rcMakeCurrentAsync");
			android::base::endTrace();
			break;
		}
		case OP_rcComposeAsync: {
			android::base::beginTrace("rcComposeAsync decode");
			uint32_t var_bufferSize = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			InputBuffer inptr_buffer(ptr + 8 + 4 + 4, size_buffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + size_buffer, ptr + 8 + 4 + 4 + size_buffer, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcComposeAsync: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcComposeAsync(bufferSize:0x%08x buffer:%p(%u) )", stream, var_bufferSize, (void*)(inptr_buffer.get()), size_buffer);
			this->rcComposeAsync(var_bufferSize, (void*)(inptr_buffer.get()));
			SET_LASTCALL("rcComposeAsync");
			android::base::endTrace();
			break;
		}
		case OP_rcDestroySyncKHRAsync: {
			android::base::beginTrace("rcDestroySyncKHRAsync decode");
			uint64_t var_sync = Unpack<uint64_t,uint64_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 8, ptr + 8 + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcDestroySyncKHRAsync: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcDestroySyncKHRAsync(sync:0x%016lx )", stream, var_sync);
			this->rcDestroySyncKHRAsync(var_sync);
			SET_LASTCALL("rcDestroySyncKHRAsync");
			android::base::endTrace();
			break;
		}
		case OP_rcComposeWithoutPost: {
			android::base::beginTrace("rcComposeWithoutPost decode");
			uint32_t var_bufferSize = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			InputBuffer inptr_buffer(ptr + 8 + 4 + 4, size_buffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + size_buffer, ptr + 8 + 4 + 4 + size_buffer, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcComposeWithoutPost: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(GLint);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcComposeWithoutPost(bufferSize:0x%08x buffer:%p(%u) )", stream, var_bufferSize, (void*)(inptr_buffer.get()), size_buffer);
			*(GLint *)(&tmpBuf[0]) = 			this->rcComposeWithoutPost(var_bufferSize, (void*)(inptr_buffer.get()));
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcComposeWithoutPost");
			android::base::endTrace();
			break;
		}
		case OP_rcComposeAsyncWithoutPost: {
			android::base::beginTrace("rcComposeAsyncWithoutPost decode");
			uint32_t var_bufferSize = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			InputBuffer inptr_buffer(ptr + 8 + 4 + 4, size_buffer);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + size_buffer, ptr + 8 + 4 + 4 + size_buffer, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcComposeAsyncWithoutPost: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcComposeAsyncWithoutPost(bufferSize:0x%08x buffer:%p(%u) )", stream, var_bufferSize, (void*)(inptr_buffer.get()), size_buffer);
			this->rcComposeAsyncWithoutPost(var_bufferSize, (void*)(inptr_buffer.get()));
			SET_LASTCALL("rcComposeAsyncWithoutPost");
			android::base::endTrace();
			break;
		}
		case OP_rcCreateDisplayById: {
			android::base::beginTrace("rcCreateDisplayById decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4, ptr + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcCreateDisplayById: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcCreateDisplayById(displayId:0x%08x )", stream, var_displayId);
			*(int *)(&tmpBuf[0]) = 			this->rcCreateDisplayById(var_displayId);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcCreateDisplayById");
			android::base::endTrace();
			break;
		}
		case OP_rcSetDisplayPoseDpi: {
			android::base::beginTrace("rcSetDisplayPoseDpi decode");
			uint32_t var_displayId = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			uint32_t var_w = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4);
			uint32_t var_h = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			uint32_t var_dpi = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetDisplayPoseDpi: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcSetDisplayPoseDpi(displayId:0x%08x x:0x%08x y:0x%08x w:0x%08x h:0x%08x dpi:0x%08x )", stream, var_displayId, var_x, var_y, var_w, var_h, var_dpi);
			*(int *)(&tmpBuf[0]) = 			this->rcSetDisplayPoseDpi(var_displayId, var_x, var_y, var_w, var_h, var_dpi);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcSetDisplayPoseDpi");
			android::base::endTrace();
			break;
		}
		case OP_rcReadColorBufferDMA: {
			android::base::beginTrace("rcReadColorBufferDMA decode");
			uint32_t var_colorbuffer = Unpack<uint32_t,uint32_t>(ptr + 8);
			GLint var_x = Unpack<GLint,uint32_t>(ptr + 8 + 4);
			GLint var_y = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4);
			GLint var_width = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4);
			GLint var_height = Unpack<GLint,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4);
			GLenum var_format = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4);
			GLenum var_type = Unpack<GLenum,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4);
			uint64_t var_pixels_guest_paddr = Unpack<uint64_t,uint64_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4);
			void* var_pixels = stream->getDmaForReading(var_pixels_guest_paddr);
			uint32_t size_pixels __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8);
			uint32_t var_pixels_size = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8 + 4, ptr + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 8 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcReadColorBufferDMA: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcReadColorBufferDMA(colorbuffer:0x%08x x:0x%08x y:0x%08x width:0x%08x height:0x%08x format:0x%08x type:0x%08x pixels:%p(%u) pixels_size:0x%08x )", stream, var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, var_pixels, var_pixels_size);
			*(int *)(&tmpBuf[0]) = 			this->rcReadColorBufferDMA(var_colorbuffer, var_x, var_y, var_width, var_height, var_format, var_type, var_pixels, var_pixels_size);
			stream->unlockDma(var_pixels_guest_paddr);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcReadColorBufferDMA");
			android::base::endTrace();
			break;
		}
		case OP_rcGetFBDisplayConfigsCount: {
			android::base::beginTrace("rcGetFBDisplayConfigsCount decode");
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8, ptr + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetFBDisplayConfigsCount: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetFBDisplayConfigsCount()", stream);
			*(int *)(&tmpBuf[0]) = 			this->rcGetFBDisplayConfigsCount();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetFBDisplayConfigsCount");
			android::base::endTrace();
			break;
		}
		case OP_rcGetFBDisplayConfigsParam: {
			android::base::beginTrace("rcGetFBDisplayConfigsParam decode");
			int var_configId = Unpack<int,uint32_t>(ptr + 8);
			EGLint var_param = Unpack<EGLint,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetFBDisplayConfigsParam: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetFBDisplayConfigsParam(configId:%d param:0x%08x )", stream, var_configId, var_param);
			*(int *)(&tmpBuf[0]) = 			this->rcGetFBDisplayConfigsParam(var_configId, var_param);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetFBDisplayConfigsParam");
			android::base::endTrace();
			break;
		}
		case OP_rcGetFBDisplayActiveConfig: {
			android::base::beginTrace("rcGetFBDisplayActiveConfig decode");
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8, ptr + 8, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetFBDisplayActiveConfig: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetFBDisplayActiveConfig()", stream);
			*(int *)(&tmpBuf[0]) = 			this->rcGetFBDisplayActiveConfig();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetFBDisplayActiveConfig");
			android::base::endTrace();
			break;
		}
		case OP_rcSetProcessMetadata: {
			android::base::beginTrace("rcSetProcessMetadata decode");
			uint32_t size_key __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8);
			InputBuffer inptr_key(ptr + 8 + 4, size_key);
			uint32_t size_valuePtr __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + size_key);
			InputBuffer inptr_valuePtr(ptr + 8 + 4 + size_key + 4, size_valuePtr);
			uint32_t var_valueSize = Unpack<uint32_t,uint32_t>(ptr + 8 + 4 + size_key + 4 + size_valuePtr);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + size_key + 4 + size_valuePtr + 4, ptr + 8 + 4 + size_key + 4 + size_valuePtr + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcSetProcessMetadata: GL checksumCalculator failure\n");
			}
			DECODER_DEBUG_LOG("renderControl(%p): rcSetProcessMetadata(key:%p(%u) valuePtr:%p(%u) valueSize:0x%08x )", stream, (char*)(inptr_key.get()), size_key, (RenderControlByte*)(inptr_valuePtr.get()), size_valuePtr, var_valueSize);
			this->rcSetProcessMetadata((char*)(inptr_key.get()), (RenderControlByte*)(inptr_valuePtr.get()), var_valueSize);
			SET_LASTCALL("rcSetProcessMetadata");
			android::base::endTrace();
			break;
		}
		case OP_rcGetHostExtensionsString: {
			android::base::beginTrace("rcGetHostExtensionsString decode");
			uint32_t var_bufferSize = Unpack<uint32_t,uint32_t>(ptr + 8);
			uint32_t size_buffer __attribute__((unused)) = Unpack<uint32_t,uint32_t>(ptr + 8 + 4);
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::validOrDie(checksumCalc, ptr, 8 + 4 + 4, ptr + 8 + 4 + 4, checksumSize,
					"renderControl_decoder_context_t::decode, OP_rcGetHostExtensionsString: GL checksumCalculator failure\n");
			}
			size_t totalTmpSize = size_buffer;
			totalTmpSize += sizeof(int);
			totalTmpSize += checksumSize;
			unsigned char *tmpBuf = stream->alloc(totalTmpSize);
			OutputBuffer outptr_buffer(&tmpBuf[0], size_buffer);
			DECODER_DEBUG_LOG("renderControl(%p): rcGetHostExtensionsString(bufferSize:0x%08x buffer:%p(%u) )", stream, var_bufferSize, (void*)(outptr_buffer.get()), size_buffer);
			*(int *)(&tmpBuf[0 + size_buffer]) = 			this->rcGetHostExtensionsString(var_bufferSize, (void*)(outptr_buffer.get()));
			outptr_buffer.flush();
			if (useChecksum) {
				ChecksumCalculatorThreadInfo::writeChecksum(checksumCalc, &tmpBuf[0], totalTmpSize - checksumSize, &tmpBuf[totalTmpSize - checksumSize], checksumSize);
			}
			stream->flush();
			SET_LASTCALL("rcGetHostExtensionsString");
			android::base::endTrace();
			break;
		}
		default:
			return ptr - (unsigned char*)buf;
		} //switch
		ptr += packetLen;
	} // while
	return ptr - (unsigned char*)buf;
}
}  // namespace gfxstream

