//go:build linux || openbsd

package analyze

import (
	"os"
	"syscall"
	"time"
)

const devBSize = 512

func setPlatformSpecificAttrs(file *File, f os.FileInfo) {
	if stat, ok := f.Sys().(*syscall.Stat_t); ok {
		file.Usage = stat.Blocks * devBSize
		file.Mtime = time.Unix(int64(stat.Mtim.Sec), int64(stat.Mtim.Nsec))

		if stat.Nlink > 1 {
			file.Mli = stat.Ino
		}
	}
}

func setDirPlatformSpecificAttrs(dir *Dir, path string) {
	var stat syscall.Stat_t
	if err := syscall.Stat(path, &stat); err != nil {
		return
	}

	dir.Mtime = time.Unix(int64(stat.Mtim.Sec), int64(stat.Mtim.Nsec))
}

// getSyscallStats extracts usage and inode info from os.FileInfo using syscall
func getSyscallStats(info os.FileInfo) (usage int64, mli uint64) {
	if stat, ok := info.Sys().(*syscall.Stat_t); ok {
		usage = stat.Blocks * 512 // 512-byte blocks
		if stat.Nlink > 1 {
			mli = stat.Ino
		}
	} else {
		usage = info.Size()
	}
	return
}
