/* WindowClone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022-2025 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include "gala.h"
#include <glib-object.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/meta-window-actor.h>
#include <meta/workspace.h>
#include <meta/display.h>
#include <meta/meta-workspace-manager.h>
#include <meta/prefs.h>
#include <meta/common.h>
#include <meta/meta-plugin.h>
#include <graphene-gobject.h>
#include <gio/gio.h>
#include <meta/meta-background-group.h>
#include <stdlib.h>
#include <string.h>

#define GALA_WINDOW_CLONE_WINDOW_ICON_SIZE 64
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE 12
#define GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION 200
#define GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN 60
#define GALA_WINDOW_CLONE_CLOSE_TRANSLATION 600
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_BORDER_RADIUS 16
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY ((guint8) 204)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
typedef struct _GalaWindowClonePrivate GalaWindowClonePrivate;

#define GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE (gala_window_clone_active_shape_get_type ())
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))

typedef struct _GalaWindowCloneActiveShape GalaWindowCloneActiveShape;
typedef struct _GalaWindowCloneActiveShapeClass GalaWindowCloneActiveShapeClass;

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;
enum  {
	GALA_WINDOW_CLONE_0_PROPERTY,
	GALA_WINDOW_CLONE_ACTOR_PROPERTY,
	GALA_WINDOW_CLONE_WM_PROPERTY,
	GALA_WINDOW_CLONE_WINDOW_PROPERTY,
	GALA_WINDOW_CLONE_SLOT_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_PROPERTY,
	GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY,
	GALA_WINDOW_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_properties[GALA_WINDOW_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))
typedef struct _Block56Data Block56Data;

#define GALA_TYPE_WINDOW_DRAG_PROVIDER (gala_window_drag_provider_get_type ())
#define GALA_WINDOW_DRAG_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_DRAG_PROVIDER, GalaWindowDragProvider))
#define GALA_WINDOW_DRAG_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_DRAG_PROVIDER, GalaWindowDragProviderClass))
#define GALA_IS_WINDOW_DRAG_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_DRAG_PROVIDER))
#define GALA_IS_WINDOW_DRAG_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_DRAG_PROVIDER))
#define GALA_WINDOW_DRAG_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_DRAG_PROVIDER, GalaWindowDragProviderClass))

typedef struct _GalaWindowDragProvider GalaWindowDragProvider;
typedef struct _GalaWindowDragProviderClass GalaWindowDragProviderClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _Block57Data Block57Data;
typedef struct _GalaWindowCloneActiveShapePrivate GalaWindowCloneActiveShapePrivate;
enum  {
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_0_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_active_shape_properties[GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES];
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);
enum  {
	GALA_WINDOW_CLONE_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL,
	GALA_WINDOW_CLONE_NUM_SIGNALS
};
static guint gala_window_clone_signals[GALA_WINDOW_CLONE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaWindowClone {
	GalaActorTarget parent_instance;
	GalaWindowClonePrivate * priv;
};

struct _GalaWindowCloneClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWindowClonePrivate {
	GalaWindowManager* _wm;
	MetaWindow* _window;
	MtkRectangle* _slot;
	gboolean _overview_mode;
	gfloat _monitor_scale;
	GalaDragDropAction* drag_action;
	ClutterClone* clone;
	GalaShadowEffect* shadow_effect;
	ClutterClone* drag_handle;
	gulong check_confirm_dialog_cb;
	gboolean in_slot_animation;
	ClutterActor* clone_container;
	GalaCloseButton* close_button;
	GalaWindowCloneActiveShape* active_shape;
	ClutterActor* window_icon;
	GalaTooltip* window_title;
	GalaGestureController* gesture_controller;
};

struct _Block56Data {
	int _ref_count_;
	GalaWindowClone* self;
	MetaWindow* new_window;
};

struct _Block57Data {
	int _ref_count_;
	GalaWindowClone* self;
	gulong handler;
};

struct _GalaWindowCloneActiveShape {
	ClutterActor parent_instance;
	GalaWindowCloneActiveShapePrivate * priv;
};

struct _GalaWindowCloneActiveShapeClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowCloneActiveShapePrivate {
	gfloat _monitor_scale;
};

static gint GalaWindowClone_private_offset;
static gpointer gala_window_clone_parent_class = NULL;
static gint GalaWindowCloneActiveShape_private_offset;
static gpointer gala_window_clone_active_shape_parent_class = NULL;
static GalaRootTargetIface * gala_window_clone_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
static GType gala_window_clone_active_shape_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneActiveShape, g_object_unref)
VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
static void gala_window_clone_unmanaged (GalaWindowClone* self);
static void _gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                         gpointer self);
static void gala_window_clone_check_shadow_requirements (GalaWindowClone* self);
static void _gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void gala_window_clone_update_targets (GalaWindowClone* self);
static void _gala_window_clone_update_targets_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _gala_window_clone_update_targets_meta_window_position_changed (MetaWindow* _sender,
                                                                     gpointer self);
static void gala_window_clone_finish_drag (GalaWindowClone* self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        gfloat monitor_scale,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              gfloat monitor_scale,
                                              gboolean overview_mode);
static void gala_window_clone_reallocate (GalaWindowClone* self);
VALA_EXTERN gfloat gala_window_clone_get_monitor_scale (GalaWindowClone* self);
VALA_EXTERN gboolean gala_window_clone_get_overview_mode (GalaWindowClone* self);
static void gala_window_clone_load_clone (GalaWindowClone* self,
                                   MetaWindowActor* actor);
VALA_EXTERN void gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                           guint8 value);
static gboolean gala_window_clone_should_fade (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MtkRectangle* rect,
                                  gboolean animate);
static void gala_window_clone_set_slot (GalaWindowClone* self,
                                 MtkRectangle* value);
VALA_EXTERN MtkRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
static void gala_window_clone_real_start_progress (GalaActorTarget* base,
                                            GalaGestureAction action);
static void gala_window_clone_update_hover_widgets (GalaWindowClone* self,
                                             gboolean* animating);
static void gala_window_clone_real_update_progress (GalaActorTarget* base,
                                             GalaGestureAction action,
                                             gdouble progress);
static void gala_window_clone_real_end_progress (GalaActorTarget* base,
                                          GalaGestureAction action);
static void gala_window_clone_close_window (GalaWindowClone* self,
                                     guint32 timestamp);
static void gala_window_clone_real_allocate (ClutterActor* base,
                                      ClutterActorBox* box);
VALA_EXTERN void gala_internal_utils_actor_box_from_rect (gfloat x,
                                              gfloat y,
                                              gfloat width,
                                              gfloat height,
                                              ClutterActorBox* result);
VALA_EXTERN GalaWindowManager* gala_window_clone_get_wm (GalaWindowClone* self);
static gboolean gala_window_clone_is_close_button_on_left (void);
static gboolean gala_window_clone_real_button_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static void gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                             gint monitor,
                                             MetaWindow* new_window);
static void _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static gboolean __lambda38_ (Block56Data* _data56_);
static gboolean ___lambda38__gsource_func (gpointer self);
static void gala_window_clone_actor_clicked (GalaWindowClone* self,
                                      guint32 button,
                                      ClutterInputDeviceType device_type);
static ClutterActor* gala_window_clone_drag_begin (GalaWindowClone* self,
                                            gfloat click_x,
                                            gfloat click_y);
static void gala_window_clone_destination_crossed (GalaWindowClone* self,
                                            ClutterActor* destination,
                                            gboolean hovered);
VALA_EXTERN GType gala_window_drag_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowDragProvider, g_object_unref)
VALA_EXTERN guint gala_window_drag_provider_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GalaWindowDragProvider* gala_window_drag_provider_get_instance (void);
 G_GNUC_INTERNAL void gala_window_drag_provider_notify_enter (GalaWindowDragProvider* self,
                                             guint64 window_id);
 G_GNUC_INTERNAL void gala_window_drag_provider_notify_leave (GalaWindowDragProvider* self);
static void gala_window_clone_destination_motion (GalaWindowClone* self,
                                           ClutterActor* destination,
                                           gfloat x,
                                           gfloat y);
 G_GNUC_INTERNAL void gala_window_drag_provider_notify_motion (GalaWindowDragProvider* self,
                                              gfloat x,
                                              gfloat y);
static void gala_window_clone_drag_end (GalaWindowClone* self,
                                 ClutterActor* destination);
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
 G_GNUC_INTERNAL void gala_window_drag_provider_notify_dropped (GalaWindowDragProvider* self);
static void gala_window_clone_drag_canceled (GalaWindowClone* self);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static void ___lambda65_ (Block57Data* _data57_);
static void ____lambda65__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                        gpointer self);
static void gala_window_clone_set_wm (GalaWindowClone* self,
                               GalaWindowManager* value);
static void gala_window_clone_set_window (GalaWindowClone* self,
                                   MetaWindow* value);
static gboolean _mtk_rectangle_equal (const MtkRectangle * s1,
                               const MtkRectangle * s2);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
static void gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                          gboolean value);
VALA_EXTERN void gala_window_clone_set_monitor_scale (GalaWindowClone* self,
                                          gfloat value);
VALA_EXTERN guint8 gala_window_clone_get_shadow_opacity (GalaWindowClone* self);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_new (gfloat monitor_scale);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_construct (GType object_type,
                                                                      gfloat monitor_scale);
static gfloat gala_window_clone_active_shape_get_monitor_scale (GalaWindowCloneActiveShape* self);
static void gala_window_clone_active_shape_set_monitor_scale (GalaWindowCloneActiveShape* self,
                                                       gfloat value);
static GObject * gala_window_clone_active_shape_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static gboolean _gala_window_clone_active_shape___lambda37_ (GalaWindowCloneActiveShape* self,
                                                      GBinding* binding,
                                                      GValue* from_value,
                                                      GValue* to_value);
static gboolean __gala_window_clone_active_shape___lambda37__gbinding_transform_func (GBinding* binding,
                                                                               GValue* from_value,
                                                                               GValue* to_value,
                                                                               gpointer self);
static void gala_window_clone_active_shape_finalize (GObject * obj);
static GType gala_window_clone_active_shape_get_type_once (void);
static void _vala_gala_window_clone_active_shape_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_gala_window_clone_active_shape_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static GObject * gala_window_clone_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_window_clone___lambda66_ (GalaWindowClone* self);
static void __gala_window_clone___lambda66__meta_window_size_changed (MetaWindow* _sender,
                                                               gpointer self);
static void _gala_window_clone____lambda67_ (GalaWindowClone* self,
                                      ClutterClickAction* action,
                                      ClutterActor* actor);
static void __gala_window_clone____lambda67__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                    ClutterActor* actor,
                                                                    gpointer self);
static ClutterActor* _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                              gfloat x,
                                                                              gfloat y,
                                                                              gpointer self);
static void _gala_window_clone_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                       ClutterActor* destination,
                                                                                       gboolean hovered,
                                                                                       gpointer self);
static void _gala_window_clone_destination_motion_gala_drag_drop_action_destination_motion (GalaDragDropAction* _sender,
                                                                                     ClutterActor* destination,
                                                                                     gfloat x,
                                                                                     gfloat y,
                                                                                     gpointer self);
static void _gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self);
static void _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                           gpointer self);
static void _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                           guint32 button,
                                                                           ClutterInputDeviceType device_type,
                                                                           gpointer self);
VALA_EXTERN GalaTooltip* gala_tooltip_new (gfloat monitor_scale);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type,
                                     gfloat monitor_scale);
static void _gala_window_clone_close_window_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                  guint32 timestamp,
                                                                  gpointer self);
static void _gala_window_clone___lambda68_ (GalaWindowClone* self);
static void __gala_window_clone___lambda68__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _gala_window_clone_reallocate_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                                GalaInternalUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify);
static void _gala_window_clone_load_clone_gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                                    gpointer self);
static void _gala_window_clone___lambda69_ (GalaWindowClone* self);
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text);
static void __gala_window_clone___lambda69__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _gala_window_clone___lambda70_ (GalaWindowClone* self);
static void __gala_window_clone___lambda70__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void gala_window_clone_finalize (GObject * obj);
static GType gala_window_clone_get_type_once (void);
static void _vala_gala_window_clone_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_window_clone_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_window_clone_get_instance_private (GalaWindowClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowClone_private_offset);
}

static void
_gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                    gpointer self)
{
	gala_window_clone_unmanaged ((GalaWindowClone*) self);
}

static void
_gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	gala_window_clone_check_shadow_requirements ((GalaWindowClone*) self);
}

static void
_gala_window_clone_update_targets_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	gala_window_clone_update_targets ((GalaWindowClone*) self);
}

static void
_gala_window_clone_update_targets_meta_window_position_changed (MetaWindow* _sender,
                                                                gpointer self)
{
	gala_window_clone_update_targets ((GalaWindowClone*) self);
}

static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

GalaWindowClone*
gala_window_clone_construct (GType object_type,
                             GalaWindowManager* wm,
                             MetaWindow* window,
                             gfloat monitor_scale,
                             gboolean overview_mode)
{
	GalaWindowClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowClone*) g_object_new (object_type, "wm", wm, "window", window, "monitor-scale", monitor_scale, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowClone*
gala_window_clone_new (GalaWindowManager* wm,
                       MetaWindow* window,
                       gfloat monitor_scale,
                       gboolean overview_mode)
{
	return gala_window_clone_construct (GALA_TYPE_WINDOW_CLONE, wm, window, monitor_scale, overview_mode);
}

static void
gala_window_clone_reallocate (GalaWindowClone* self)
{
	MetaWindow* _tmp0_;
	gfloat _tmp1_;
	gboolean _tmp2_;
	GalaWindowIcon* _tmp3_ = NULL;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	GalaTooltip* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = self->priv->_monitor_scale;
	_tmp2_ = self->priv->_overview_mode;
	_tmp3_ = gala_window_icon_new (_tmp0_, GALA_WINDOW_CLONE_WINDOW_ICON_SIZE, (gint) round ((gdouble) _tmp1_));
	g_object_set ((ClutterActor*) _tmp3_, "visible", !_tmp2_, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->window_icon);
	self->priv->window_icon = (ClutterActor*) _tmp3_;
	_tmp4_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp4_, (guint) 0);
	_tmp5_ = self->priv->window_icon;
	clutter_actor_set_pivot_point (_tmp5_, 0.5f, 0.5f);
	_tmp6_ = self->priv->window_icon;
	clutter_actor_add_child ((ClutterActor*) self, _tmp6_);
	_tmp7_ = self->priv->window_icon;
	_tmp8_ = self->priv->window_title;
	clutter_actor_set_child_below_sibling ((ClutterActor*) self, _tmp7_, (ClutterActor*) _tmp8_);
}

/**
     * Waits for the texture of a new Meta.WindowActor to be available
     * and makes a close of it. If it was already was assigned a slot
     * at this point it will animate to it. Otherwise it will just place
     * itself at the location of the original window. Also adds the shadow
     * effect and makes sure the shadow is updated on size changes.
     */
static void
gala_window_clone_load_clone (GalaWindowClone* self,
                              MetaWindowActor* actor)
{
	gboolean _tmp0_;
	ClutterClone* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterClone* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->_overview_mode;
	if (_tmp0_) {
		clutter_actor_hide ((ClutterActor*) actor);
	}
	_tmp1_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) actor);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = _tmp1_;
	_tmp2_ = self->priv->clone_container;
	_tmp3_ = self->priv->clone;
	clutter_actor_add_child (_tmp2_, (ClutterActor*) _tmp3_);
	gala_window_clone_check_shadow_requirements (self);
}

static void
gala_window_clone_check_shadow_requirements (GalaWindowClone* self)
{
	ClutterClone* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->_window;
	g_object_get (_tmp2_, "fullscreen", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		MetaWindow* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->_window;
		g_object_get (_tmp6_, "maximized-horizontally", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			MetaWindow* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = self->priv->_window;
			g_object_get (_tmp9_, "maximized-vertically", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		GalaShadowEffect* _tmp12_;
		_tmp12_ = self->priv->shadow_effect;
		if (_tmp12_ == NULL) {
			gfloat _tmp13_;
			GalaShadowEffect* _tmp14_;
			ClutterClone* _tmp15_;
			GalaShadowEffect* _tmp16_;
			_tmp13_ = self->priv->_monitor_scale;
			_tmp14_ = gala_shadow_effect_new ("window", _tmp13_);
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = _tmp14_;
			gala_window_clone_set_shadow_opacity (self, (guint8) 0);
			_tmp15_ = self->priv->clone;
			_tmp16_ = self->priv->shadow_effect;
			clutter_actor_add_effect_with_name ((ClutterActor*) _tmp15_, "shadow", (ClutterEffect*) _tmp16_);
		}
	} else {
		GalaShadowEffect* _tmp17_;
		_tmp17_ = self->priv->shadow_effect;
		if (_tmp17_ != NULL) {
			ClutterClone* _tmp18_;
			GalaShadowEffect* _tmp19_;
			_tmp18_ = self->priv->clone;
			_tmp19_ = self->priv->shadow_effect;
			clutter_actor_remove_effect ((ClutterActor*) _tmp18_, (ClutterEffect*) _tmp19_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = NULL;
		}
	}
}

/**
     * If we are in overview mode, we may display windows from workspaces other than
     * the current one. To ease their appearance we have to fade them in.
     */
static gboolean
gala_window_clone_should_fade (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->_overview_mode;
	if (_tmp2_) {
		MetaWindow* _tmp3_;
		MetaWorkspace* _tmp4_;
		MetaWindow* _tmp5_;
		MetaDisplay* _tmp6_;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		_tmp3_ = self->priv->_window;
		_tmp4_ = meta_window_get_workspace (_tmp3_);
		_tmp5_ = self->priv->_window;
		_tmp6_ = meta_window_get_display (_tmp5_);
		_tmp7_ = meta_display_get_workspace_manager (_tmp6_);
		_tmp8_ = meta_workspace_manager_get_active_workspace (_tmp7_);
		_tmp1_ = _tmp4_ != _tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaWindow* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->_window;
		g_object_get (_tmp9_, "minimized", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Animate the window to the given slot
     */
void
gala_window_clone_take_slot (GalaWindowClone* self,
                             MtkRectangle* rect,
                             gboolean animate)
{
	MtkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	gala_window_clone_set_slot (self, &_tmp0_);
	if (animate) {
		clutter_actor_save_easing_state ((ClutterActor*) self);
		clutter_actor_set_easing_duration ((ClutterActor*) self, gala_utils_get_animation_duration ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION));
		clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	}
	gala_window_clone_update_targets (self);
	if (animate) {
		clutter_actor_restore_easing_state ((ClutterActor*) self);
	}
}

static void
gala_window_clone_update_targets (GalaWindowClone* self)
{
	MtkRectangle* _tmp0_;
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	MtkRectangle monitor_geometry = {0};
	MetaWindow* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWindow* _tmp6_;
	MtkRectangle _tmp7_ = {0};
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	GValue _tmp10_ = {0};
	MtkRectangle* _tmp11_;
	GValue _tmp12_ = {0};
	GalaPropertyTarget* _tmp13_;
	GalaPropertyTarget* _tmp14_;
	MtkRectangle _tmp15_;
	MtkRectangle _tmp16_;
	GValue _tmp17_ = {0};
	MtkRectangle* _tmp18_;
	GValue _tmp19_ = {0};
	GalaPropertyTarget* _tmp20_;
	GalaPropertyTarget* _tmp21_;
	MtkRectangle _tmp22_;
	GValue _tmp23_ = {0};
	MtkRectangle* _tmp24_;
	GValue _tmp25_ = {0};
	GalaPropertyTarget* _tmp26_;
	GalaPropertyTarget* _tmp27_;
	MtkRectangle _tmp28_;
	GValue _tmp29_ = {0};
	MtkRectangle* _tmp30_;
	GValue _tmp31_ = {0};
	GalaPropertyTarget* _tmp32_;
	GalaPropertyTarget* _tmp33_;
	GValue _tmp34_ = {0};
	GValue _tmp35_ = {0};
	GalaPropertyTarget* _tmp36_;
	GalaPropertyTarget* _tmp37_;
	ClutterActor* _tmp42_;
	GValue _tmp43_ = {0};
	GValue _tmp44_ = {0};
	GalaPropertyTarget* _tmp45_;
	GalaPropertyTarget* _tmp46_;
	GalaTooltip* _tmp47_;
	GValue _tmp48_ = {0};
	GValue _tmp49_ = {0};
	GalaPropertyTarget* _tmp50_;
	GalaPropertyTarget* _tmp51_;
	g_return_if_fail (self != NULL);
	gala_actor_target_remove_all_targets ((GalaActorTarget*) self);
	_tmp0_ = self->priv->_slot;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp1_, &_tmp2_);
	window_rect = _tmp2_;
	_tmp3_ = self->priv->_window;
	_tmp4_ = meta_window_get_display (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_window;
	meta_display_get_monitor_geometry (_tmp5_, meta_window_get_monitor (_tmp6_), &_tmp7_);
	monitor_geometry = _tmp7_;
	_tmp8_ = window_rect;
	_tmp9_ = monitor_geometry;
	g_value_init (&_tmp10_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp10_, (gfloat) (_tmp8_.x - _tmp9_.x));
	_tmp11_ = self->priv->_slot;
	g_value_init (&_tmp12_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp12_, (gfloat) (*_tmp11_).x);
	_tmp13_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "x", G_TYPE_FLOAT, &_tmp10_, &_tmp12_);
	_tmp14_ = _tmp13_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	_tmp15_ = window_rect;
	_tmp16_ = monitor_geometry;
	g_value_init (&_tmp17_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp17_, (gfloat) (_tmp15_.y - _tmp16_.y));
	_tmp18_ = self->priv->_slot;
	g_value_init (&_tmp19_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp19_, (gfloat) (*_tmp18_).y);
	_tmp20_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "y", G_TYPE_FLOAT, &_tmp17_, &_tmp19_);
	_tmp21_ = _tmp20_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	_tmp22_ = window_rect;
	g_value_init (&_tmp23_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp23_, (gfloat) _tmp22_.width);
	_tmp24_ = self->priv->_slot;
	g_value_init (&_tmp25_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp25_, (gfloat) (*_tmp24_).width);
	_tmp26_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "width", G_TYPE_FLOAT, &_tmp23_, &_tmp25_);
	_tmp27_ = _tmp26_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	G_IS_VALUE (&_tmp23_) ? (g_value_unset (&_tmp23_), NULL) : NULL;
	_tmp28_ = window_rect;
	g_value_init (&_tmp29_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp29_, (gfloat) _tmp28_.height);
	_tmp30_ = self->priv->_slot;
	g_value_init (&_tmp31_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp31_, (gfloat) (*_tmp30_).height);
	_tmp32_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "height", G_TYPE_FLOAT, &_tmp29_, &_tmp31_);
	_tmp33_ = _tmp32_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	G_IS_VALUE (&_tmp31_) ? (g_value_unset (&_tmp31_), NULL) : NULL;
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
	g_value_init (&_tmp34_, G_TYPE_UCHAR);
	g_value_set_uchar (&_tmp34_, (guint8) 0U);
	g_value_init (&_tmp35_, G_TYPE_UCHAR);
	g_value_set_uchar (&_tmp35_, (guint8) 255U);
	_tmp36_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "shadow-opacity", G_TYPE_UCHAR, &_tmp34_, &_tmp35_);
	_tmp37_ = _tmp36_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	G_IS_VALUE (&_tmp35_) ? (g_value_unset (&_tmp35_), NULL) : NULL;
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
	if (gala_window_clone_should_fade (self)) {
		GValue _tmp38_ = {0};
		GValue _tmp39_ = {0};
		GalaPropertyTarget* _tmp40_;
		GalaPropertyTarget* _tmp41_;
		g_value_init (&_tmp38_, G_TYPE_UCHAR);
		g_value_set_uchar (&_tmp38_, (guint8) 0U);
		g_value_init (&_tmp39_, G_TYPE_UCHAR);
		g_value_set_uchar (&_tmp39_, (guint8) 255U);
		_tmp40_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "opacity", G_TYPE_UCHAR, &_tmp38_, &_tmp39_);
		_tmp41_ = _tmp40_;
		gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp41_);
		_g_object_unref0 (_tmp41_);
		G_IS_VALUE (&_tmp39_) ? (g_value_unset (&_tmp39_), NULL) : NULL;
		G_IS_VALUE (&_tmp38_) ? (g_value_unset (&_tmp38_), NULL) : NULL;
	}
	_tmp42_ = self->priv->window_icon;
	g_value_init (&_tmp43_, G_TYPE_UINT);
	g_value_set_uint (&_tmp43_, 0U);
	g_value_init (&_tmp44_, G_TYPE_UINT);
	g_value_set_uint (&_tmp44_, 255U);
	_tmp45_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) _tmp42_, "opacity", G_TYPE_UINT, &_tmp43_, &_tmp44_);
	_tmp46_ = _tmp45_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	G_IS_VALUE (&_tmp44_) ? (g_value_unset (&_tmp44_), NULL) : NULL;
	G_IS_VALUE (&_tmp43_) ? (g_value_unset (&_tmp43_), NULL) : NULL;
	_tmp47_ = self->priv->window_title;
	g_value_init (&_tmp48_, G_TYPE_UINT);
	g_value_set_uint (&_tmp48_, 0U);
	g_value_init (&_tmp49_, G_TYPE_UINT);
	g_value_set_uint (&_tmp49_, 255U);
	_tmp50_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) _tmp47_, "opacity", G_TYPE_UINT, &_tmp48_, &_tmp49_);
	_tmp51_ = _tmp50_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	G_IS_VALUE (&_tmp49_) ? (g_value_unset (&_tmp49_), NULL) : NULL;
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
}

static void
gala_window_clone_real_start_progress (GalaActorTarget* base,
                                       GalaGestureAction action)
{
	GalaWindowClone * self;
	gboolean _tmp0_;
	self = (GalaWindowClone*) base;
	_tmp0_ = TRUE;
	gala_window_clone_update_hover_widgets (self, &_tmp0_);
}

static void
gala_window_clone_real_update_progress (GalaActorTarget* base,
                                        GalaGestureAction action,
                                        gdouble progress)
{
	GalaWindowClone * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gfloat target_translation_y = 0.0F;
	gfloat _tmp3_;
	guint target_opacity = 0U;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	GalaTooltip* _tmp8_;
	GalaTooltip* _tmp9_;
	GalaCloseButton* _tmp10_;
	GalaCloseButton* _tmp11_;
	self = (GalaWindowClone*) base;
	if (action != GALA_GESTURE_ACTION_CUSTOM) {
		_tmp1_ = TRUE;
	} else {
		MtkRectangle* _tmp2_;
		_tmp2_ = self->priv->_slot;
		_tmp1_ = _tmp2_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !meta_prefs_get_gnome_animations ();
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_monitor_scale;
	target_translation_y = (gfloat) (((-GALA_WINDOW_CLONE_CLOSE_TRANSLATION) * _tmp3_) * progress);
	target_opacity = (guint) (255 * (1 - progress));
	_tmp4_ = self->priv->clone_container;
	g_object_set (_tmp4_, "translation-y", target_translation_y, NULL);
	_tmp5_ = self->priv->clone_container;
	clutter_actor_set_opacity (_tmp5_, target_opacity);
	_tmp6_ = self->priv->window_icon;
	g_object_set (_tmp6_, "translation-y", target_translation_y, NULL);
	_tmp7_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp7_, target_opacity);
	_tmp8_ = self->priv->window_title;
	g_object_set ((ClutterActor*) _tmp8_, "translation-y", target_translation_y, NULL);
	_tmp9_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp9_, target_opacity);
	_tmp10_ = self->priv->close_button;
	g_object_set ((ClutterActor*) _tmp10_, "translation-y", target_translation_y, NULL);
	_tmp11_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp11_, target_opacity);
}

static void
gala_window_clone_real_end_progress (GalaActorTarget* base,
                                     GalaGestureAction action)
{
	GalaWindowClone * self;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (GalaWindowClone*) base;
	_tmp0_ = FALSE;
	gala_window_clone_update_hover_widgets (self, &_tmp0_);
	if (action == GALA_GESTURE_ACTION_CUSTOM) {
		_tmp2_ = gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_CUSTOM) > 0.5;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = meta_prefs_get_gnome_animations ();
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gala_window_clone_close_window (self, (guint32) META_CURRENT_TIME);
	}
}

static void
gala_window_clone_real_allocate (ClutterActor* base,
                                 ClutterActorBox* box)
{
	GalaWindowClone * self;
	ClutterActorBox _tmp0_;
	MtkRectangle input_rect = {0};
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	MtkRectangle outer_rect = {0};
	MetaWindow* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	gfloat clone_scale_factor = 0.0F;
	gfloat _tmp5_;
	gfloat _tmp6_;
	MtkRectangle _tmp7_;
	gfloat clone_x = 0.0F;
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	gfloat clone_y = 0.0F;
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	ClutterActorBox clone_container_alloc = {0};
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	ClutterActorBox _tmp14_ = {0};
	ClutterActor* _tmp15_;
	ClutterActorBox _tmp16_;
	gboolean _tmp17_ = FALSE;
	ClutterClone* _tmp18_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp24_;
	MetaDisplay* _tmp25_;
	ClutterClone* _tmp26_;
	gfloat clone_width = 0.0F;
	gfloat clone_height = 0.0F;
	ClutterClone* _tmp27_;
	gfloat _tmp28_ = 0.0F;
	gfloat _tmp29_ = 0.0F;
	ClutterActorBox clone_alloc = {0};
	ClutterActorBox _tmp30_ = {0};
	ClutterClone* _tmp31_;
	ClutterActorBox _tmp32_;
	ClutterActorBox shape_alloc = {0};
	ClutterActorBox _tmp33_ = {0};
	GalaWindowCloneActiveShape* _tmp34_;
	ClutterActorBox _tmp35_;
	gfloat close_button_width = 0.0F;
	gfloat close_button_height = 0.0F;
	GalaCloseButton* _tmp36_;
	gfloat _tmp37_ = 0.0F;
	gfloat _tmp38_ = 0.0F;
	gfloat _tmp39_ = 0.0F;
	gfloat close_button_x = 0.0F;
	ClutterActorBox close_button_alloc = {0};
	ClutterActorBox _tmp40_ = {0};
	GalaCloseButton* _tmp41_;
	ClutterActorBox _tmp42_;
	gfloat window_icon_width = 0.0F;
	gfloat window_icon_height = 0.0F;
	ClutterActor* _tmp43_;
	gfloat _tmp44_ = 0.0F;
	gfloat _tmp45_ = 0.0F;
	gfloat window_icon_x = 0.0F;
	gfloat window_icon_y = 0.0F;
	ClutterActorBox window_icon_alloc = {0};
	ClutterActorBox _tmp46_ = {0};
	ClutterActor* _tmp47_;
	ClutterActorBox _tmp48_;
	graphene_rect_t rect = {0};
	graphene_rect_t _tmp49_ = {0};
	gint monitor_index = 0;
	MetaDisplay* _tmp50_;
	graphene_rect_t _tmp51_;
	MtkRectangle _tmp52_ = {0};
	gfloat monitor_scale = 0.0F;
	MetaDisplay* _tmp53_;
	gfloat window_title_max_width = 0.0F;
	gfloat window_title_height = 0.0F;
	gfloat window_title_nat_width = 0.0F;
	GalaTooltip* _tmp54_;
	gfloat _tmp55_ = 0.0F;
	gfloat _tmp56_ = 0.0F;
	gfloat window_title_width = 0.0F;
	gfloat window_title_x = 0.0F;
	gfloat _tmp57_ = 0.0F;
	ClutterActor* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	gfloat window_title_y = 0.0F;
	ClutterActorBox window_title_alloc = {0};
	ClutterActorBox _tmp61_ = {0};
	GalaTooltip* _tmp62_;
	ClutterActorBox _tmp63_;
	self = (GalaWindowClone*) base;
	g_return_if_fail (box != NULL);
	_tmp0_ = *box;
	CLUTTER_ACTOR_CLASS (gala_window_clone_parent_class)->allocate ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_ACTOR_TARGET, GalaActorTarget), (const ClutterActorBox *) (&_tmp0_));
	_tmp1_ = self->priv->_window;
	meta_window_get_buffer_rect (_tmp1_, &_tmp2_);
	input_rect = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp3_, &_tmp4_);
	outer_rect = _tmp4_;
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = outer_rect;
	clone_scale_factor = _tmp6_ / _tmp7_.width;
	_tmp8_ = input_rect;
	_tmp9_ = outer_rect;
	clone_x = (_tmp8_.x - _tmp9_.x) * clone_scale_factor;
	_tmp10_ = input_rect;
	_tmp11_ = outer_rect;
	clone_y = (_tmp10_.y - _tmp11_.y) * clone_scale_factor;
	_tmp12_ = input_rect;
	_tmp13_ = input_rect;
	gala_internal_utils_actor_box_from_rect (clone_x, clone_y, _tmp12_.width * clone_scale_factor, _tmp13_.height * clone_scale_factor, &_tmp14_);
	clone_container_alloc = _tmp14_;
	_tmp15_ = self->priv->clone_container;
	_tmp16_ = clone_container_alloc;
	clutter_actor_allocate (_tmp15_, (const ClutterActorBox *) (&_tmp16_));
	_tmp18_ = self->priv->clone;
	if (_tmp18_ == NULL) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp19_ = FALSE;
		GalaDragDropAction* _tmp20_;
		_tmp20_ = self->priv->drag_action;
		if (_tmp20_ != NULL) {
			GalaDragDropAction* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = self->priv->drag_action;
			_tmp22_ = gala_drag_drop_action_get_dragging (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp19_ = _tmp23_;
		} else {
			_tmp19_ = FALSE;
		}
		_tmp17_ = _tmp19_;
	}
	if (_tmp17_) {
		return;
	}
	_tmp24_ = self->priv->_wm;
	_tmp25_ = meta_plugin_get_display ((MetaPlugin*) _tmp24_);
	display = _tmp25_;
	_tmp26_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp26_, (gdouble) clone_scale_factor, (gdouble) clone_scale_factor);
	_tmp27_ = self->priv->clone;
	clutter_actor_get_preferred_size ((ClutterActor*) _tmp27_, NULL, NULL, &_tmp28_, &_tmp29_);
	clone_width = _tmp28_;
	clone_height = _tmp29_;
	gala_internal_utils_actor_box_from_rect ((gfloat) 0, (gfloat) 0, clone_width, clone_height, &_tmp30_);
	clone_alloc = _tmp30_;
	_tmp31_ = self->priv->clone;
	_tmp32_ = clone_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp31_, (const ClutterActorBox *) (&_tmp32_));
	_tmp33_.x1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp33_.y1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp33_.x2 = clutter_actor_box_get_width (box) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	_tmp33_.y2 = clutter_actor_box_get_height (box) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	shape_alloc = _tmp33_;
	clutter_actor_box_clamp_to_pixel (&shape_alloc);
	_tmp34_ = self->priv->active_shape;
	_tmp35_ = shape_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp34_, (const ClutterActorBox *) (&_tmp35_));
	_tmp36_ = self->priv->close_button;
	clutter_actor_get_preferred_size ((ClutterActor*) _tmp36_, NULL, NULL, &_tmp37_, &_tmp38_);
	close_button_width = _tmp37_;
	close_button_height = _tmp38_;
	if (gala_window_clone_is_close_button_on_left ()) {
		_tmp39_ = (-close_button_width) * 0.5f;
	} else {
		_tmp39_ = clutter_actor_box_get_width (box) - (close_button_width * 0.5f);
	}
	close_button_x = _tmp39_;
	gala_internal_utils_actor_box_from_rect (close_button_x, (-close_button_height) * 0.33f, close_button_width, close_button_height, &_tmp40_);
	close_button_alloc = _tmp40_;
	_tmp41_ = self->priv->close_button;
	_tmp42_ = close_button_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp41_, (const ClutterActorBox *) (&_tmp42_));
	_tmp43_ = self->priv->window_icon;
	clutter_actor_get_preferred_size (_tmp43_, NULL, NULL, &_tmp44_, &_tmp45_);
	window_icon_width = _tmp44_;
	window_icon_height = _tmp45_;
	window_icon_x = (clutter_actor_box_get_width (box) - window_icon_width) / 2;
	window_icon_y = clutter_actor_box_get_height (box) - (window_icon_height * 0.75f);
	gala_internal_utils_actor_box_from_rect (window_icon_x, window_icon_y, window_icon_width, window_icon_height, &_tmp46_);
	window_icon_alloc = _tmp46_;
	_tmp47_ = self->priv->window_icon;
	_tmp48_ = window_icon_alloc;
	clutter_actor_allocate (_tmp47_, (const ClutterActorBox *) (&_tmp48_));
	clutter_actor_get_transformed_extents ((ClutterActor*) self, &_tmp49_);
	rect = _tmp49_;
	_tmp50_ = display;
	_tmp51_ = rect;
	mtk_rectangle_from_graphene_rect (&_tmp51_, MTK_ROUNDING_STRATEGY_ROUND, &_tmp52_);
	monitor_index = meta_display_get_monitor_index_for_rect (_tmp50_, &_tmp52_);
	_tmp53_ = display;
	monitor_scale = meta_display_get_monitor_scale (_tmp53_, monitor_index);
	window_title_max_width = clutter_actor_box_get_width (box) - gala_utils_scale_to_int (GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN, monitor_scale);
	_tmp54_ = self->priv->window_title;
	clutter_actor_get_preferred_size ((ClutterActor*) _tmp54_, NULL, NULL, &_tmp55_, &_tmp56_);
	window_title_nat_width = _tmp55_;
	window_title_height = _tmp56_;
	window_title_width = CLAMP (window_title_nat_width, (gfloat) 0, window_title_max_width);
	window_title_x = (clutter_actor_box_get_width (box) - window_title_width) / 2;
	_tmp58_ = self->priv->window_icon;
	g_object_get (_tmp58_, "visible", &_tmp59_, NULL);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		_tmp57_ = window_icon_y;
	} else {
		_tmp57_ = clutter_actor_box_get_height (box);
	}
	window_title_y = (_tmp57_ - (window_title_height / 2)) - gala_utils_scale_to_int (18, monitor_scale);
	gala_internal_utils_actor_box_from_rect (window_title_x, window_title_y, window_title_width, window_title_height, &_tmp61_);
	window_title_alloc = _tmp61_;
	_tmp62_ = self->priv->window_title;
	_tmp63_ = window_title_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp62_, (const ClutterActorBox *) (&_tmp63_));
}

static gboolean
gala_window_clone_real_button_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowClone * self;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = CLUTTER_EVENT_STOP;
	return result;
}

static void
gala_window_clone_update_hover_widgets (GalaWindowClone* self,
                                        gboolean* animating)
{
	guint duration = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean show = FALSE;
	GalaCloseButton* _tmp7_;
	GalaCloseButton* _tmp8_;
	GalaCloseButton* _tmp9_;
	gint _tmp10_ = 0;
	GalaCloseButton* _tmp11_;
	GalaCloseButton* _tmp12_;
	g_return_if_fail (self != NULL);
	if (animating != NULL) {
		self->priv->in_slot_animation = *animating;
	}
	duration = gala_utils_get_animation_duration ((guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	g_object_get ((ClutterActor*) self, "has-pointer", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		GalaCloseButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->close_button;
		g_object_get ((ClutterActor*) _tmp4_, "has-pointer", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		_tmp0_ = !self->priv->in_slot_animation;
	} else {
		_tmp0_ = FALSE;
	}
	show = _tmp0_;
	_tmp7_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp7_);
	_tmp8_ = self->priv->close_button;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp8_, CLUTTER_LINEAR);
	_tmp9_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp9_, duration);
	if (show) {
		_tmp10_ = 255;
	} else {
		_tmp10_ = 0;
	}
	_tmp11_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp11_, (guint) _tmp10_);
	_tmp12_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp12_);
}

/**
     * Send the window the delete signal and listen for new windows to be added
     * to the window's workspace, in which case we check if the new window is a
     * dialog of the window we were going to delete. If that's the case, we request
     * to select our window.
     */
static void
_gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                             gint object,
                                                                             MetaWindow* p0,
                                                                             gpointer self)
{
	gala_window_clone_check_confirm_dialog ((GalaWindowClone*) self, object, p0);
}

static void
gala_window_clone_close_window (GalaWindowClone* self,
                                guint32 timestamp)
{
	MetaDisplay* display = NULL;
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	gulong _tmp2_;
	MetaWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = g_signal_connect_object (display, "window-entered-monitor", (GCallback) _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor, self, 0);
	self->priv->check_confirm_dialog_cb = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_delete (_tmp3_, timestamp);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block56Data*
block56_data_ref (Block56Data* _data56_)
{
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}

static void
block56_data_unref (void * _userdata_)
{
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data56_->self;
		_g_object_unref0 (_data56_->new_window);
		_g_object_unref0 (self);
		g_slice_free (Block56Data, _data56_);
	}
}

static gboolean
__lambda38_ (Block56Data* _data56_)
{
	GalaWindowClone* self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	gboolean result;
	self = _data56_->self;
	_tmp0_ = meta_window_get_transient_for (_data56_->new_window);
	_tmp1_ = self->priv->_window;
	if (_tmp0_ == _tmp1_) {
		GalaGestureController* _tmp2_;
		MetaWindow* _tmp3_;
		MetaDisplay* _tmp4_;
		_tmp2_ = self->priv->gesture_controller;
		gala_gesture_controller_goto (_tmp2_, 0.0);
		g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
		_tmp3_ = self->priv->_window;
		_tmp4_ = meta_window_get_display (_tmp3_);
		g_signal_handler_disconnect (_tmp4_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
	return result;
}

static void
gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                        gint monitor,
                                        MetaWindow* new_window)
{
	Block56Data* _data56_;
	MetaWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_window != NULL);
	_data56_ = g_slice_new0 (Block56Data);
	_data56_->_ref_count_ = 1;
	_data56_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (new_window);
	_g_object_unref0 (_data56_->new_window);
	_data56_->new_window = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda38__gsource_func, block56_data_ref (_data56_), block56_data_unref);
	block56_data_unref (_data56_);
	_data56_ = NULL;
}

/**
     * The window unmanaged by the compositor, so we need to destroy ourselves too.
     */
static void
gala_window_clone_unmanaged (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	GalaDragDropAction* _tmp1_;
	ClutterClone* _tmp6_;
	g_return_if_fail (self != NULL);
	clutter_actor_remove_all_transitions ((ClutterActor*) self);
	_tmp1_ = self->priv->drag_action;
	if (_tmp1_ != NULL) {
		GalaDragDropAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->drag_action;
		_tmp3_ = gala_drag_drop_action_get_dragging (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaDragDropAction* _tmp5_;
		_tmp5_ = self->priv->drag_action;
		gala_drag_drop_action_cancel (_tmp5_);
	}
	_tmp6_ = self->priv->clone;
	if (_tmp6_ != NULL) {
		ClutterClone* _tmp7_;
		_tmp7_ = self->priv->clone;
		clutter_actor_destroy ((ClutterActor*) _tmp7_);
	}
	if (self->priv->check_confirm_dialog_cb != ((gulong) 0)) {
		MetaWindow* _tmp8_;
		MetaDisplay* _tmp9_;
		_tmp8_ = self->priv->_window;
		_tmp9_ = meta_window_get_display (_tmp8_);
		g_signal_handler_disconnect (_tmp9_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
}

static void
gala_window_clone_actor_clicked (GalaWindowClone* self,
                                 guint32 button,
                                 ClutterInputDeviceType device_type)
{
	g_return_if_fail (self != NULL);
	if (button == CLUTTER_BUTTON_PRIMARY) {
		g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
	} else {
		gboolean _tmp0_ = FALSE;
		if (button == CLUTTER_BUTTON_MIDDLE) {
			_tmp0_ = device_type == CLUTTER_POINTER_DEVICE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GalaWindowManager* _tmp1_;
			MetaDisplay* _tmp2_;
			_tmp1_ = self->priv->_wm;
			_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
			gala_window_clone_close_window (self, meta_display_get_current_time (_tmp2_));
		}
	}
}

/**
     * A drag action has been initiated on us, we scale ourselves to a smaller scale and
     * provide a clone of ourselves as drag handle so that it can move freely.
     */
static ClutterActor*
gala_window_clone_drag_begin (GalaWindowClone* self,
                              gfloat click_x,
                              gfloat click_y)
{
	ClutterClone* _tmp0_;
	GalaWindowCloneActiveShape* _tmp1_;
	gfloat scale = 0.0F;
	ClutterActor* _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	ClutterClone* _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	guint duration = 0U;
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	ClutterClone* _tmp8_;
	gfloat _tmp9_ = 0.0F;
	gfloat _tmp10_ = 0.0F;
	ClutterClone* _tmp11_;
	ClutterClone* _tmp12_;
	ClutterClone* _tmp13_;
	ClutterClone* _tmp14_;
	ClutterClone* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	ClutterClone* _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	ClutterClone* _tmp21_;
	ClutterClone* _tmp22_;
	ClutterClone* _tmp23_;
	gfloat _tmp24_ = 0.0F;
	gfloat _tmp25_ = 0.0F;
	ClutterActor* _tmp26_;
	ClutterActor* _tmp27_;
	ClutterActor* _tmp28_;
	ClutterActor* _tmp29_;
	ClutterActor* _tmp30_;
	gfloat _tmp31_;
	gfloat _tmp32_;
	ClutterActor* _tmp33_;
	gfloat _tmp34_;
	gfloat _tmp35_;
	ClutterActor* _tmp36_;
	GalaCloseButton* _tmp37_;
	GalaTooltip* _tmp38_;
	GalaWindowManager* _tmp39_;
	MetaDisplay* _tmp40_;
	ClutterClone* _tmp41_;
	ClutterClone* _tmp42_;
	ClutterStage* _tmp43_;
	ClutterClone* _tmp44_;
	ClutterClone* _tmp45_;
	ClutterActor* _tmp46_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->drag_handle;
	_vala_return_val_if_fail (_tmp0_ == NULL, "drag_handle == null", NULL);
	_tmp1_ = self->priv->active_shape;
	clutter_actor_hide ((ClutterActor*) _tmp1_);
	_tmp2_ = self->priv->window_icon;
	_tmp3_ = clutter_actor_get_width (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->clone;
	_tmp6_ = clutter_actor_get_width ((ClutterActor*) _tmp5_);
	_tmp7_ = _tmp6_;
	scale = _tmp4_ / _tmp7_;
	duration = gala_utils_get_animation_duration ((guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	_tmp8_ = self->priv->clone;
	clutter_actor_get_transformed_position ((ClutterActor*) _tmp8_, &_tmp9_, &_tmp10_);
	abs_x = _tmp9_;
	abs_y = _tmp10_;
	_tmp11_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp11_);
	_tmp12_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp12_, duration);
	_tmp13_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp13_, CLUTTER_EASE_IN_CUBIC);
	_tmp14_ = self->priv->clone;
	_tmp15_ = self->priv->clone;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->clone;
	_tmp19_ = clutter_actor_get_height ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp14_, (click_x - abs_x) / _tmp17_, (click_y - abs_y) / _tmp20_);
	_tmp21_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp21_, (gdouble) scale, (gdouble) scale);
	_tmp22_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp22_, (guint) 0);
	_tmp23_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp23_);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp24_, &_tmp25_);
	abs_x = _tmp24_;
	abs_y = _tmp25_;
	_tmp26_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp26_);
	_tmp27_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp27_, duration);
	_tmp28_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp28_, CLUTTER_EASE_IN_OUT_CUBIC);
	_tmp29_ = self->priv->window_icon;
	_tmp30_ = self->priv->window_icon;
	_tmp31_ = clutter_actor_get_width (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->window_icon;
	_tmp34_ = clutter_actor_get_height (_tmp33_);
	_tmp35_ = _tmp34_;
	clutter_actor_set_position (_tmp29_, (click_x - abs_x) - (_tmp32_ / 2), (click_y - abs_y) - (_tmp35_ / 2));
	_tmp36_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp36_);
	_tmp37_ = self->priv->close_button;
	g_object_set ((ClutterActor*) _tmp37_, "visible", FALSE, NULL);
	_tmp38_ = self->priv->window_title;
	g_object_set ((ClutterActor*) _tmp38_, "visible", FALSE, NULL);
	_tmp39_ = self->priv->_wm;
	_tmp40_ = meta_plugin_get_display ((MetaPlugin*) _tmp39_);
	meta_display_set_cursor (_tmp40_, META_CURSOR_DND_IN_DRAG);
	_tmp41_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) self);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->drag_handle);
	self->priv->drag_handle = _tmp41_;
	_tmp42_ = self->priv->drag_handle;
	clutter_actor_set_position ((ClutterActor*) _tmp42_, abs_x, abs_y);
	_tmp43_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) self);
	_tmp44_ = self->priv->drag_handle;
	clutter_actor_add_child ((ClutterActor*) _tmp43_, (ClutterActor*) _tmp44_);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	_tmp45_ = self->priv->drag_handle;
	_tmp46_ = _g_object_ref0 ((ClutterActor*) _tmp45_);
	result = _tmp46_;
	return result;
}

static void
gala_window_clone_destination_crossed (GalaWindowClone* self,
                                       ClutterActor* destination,
                                       gboolean hovered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (destination, meta_window_actor_get_type ())) {
		return;
	}
	if (hovered) {
		GalaWindowDragProvider* _tmp0_;
		GalaWindowDragProvider* _tmp1_;
		MetaWindow* _tmp2_;
		_tmp0_ = gala_window_drag_provider_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->_window;
		gala_window_drag_provider_notify_enter (_tmp1_, meta_window_get_id (_tmp2_));
		_g_object_unref0 (_tmp1_);
	} else {
		GalaWindowDragProvider* _tmp3_;
		GalaWindowDragProvider* _tmp4_;
		_tmp3_ = gala_window_drag_provider_get_instance ();
		_tmp4_ = _tmp3_;
		gala_window_drag_provider_notify_leave (_tmp4_);
		_g_object_unref0 (_tmp4_);
	}
}

static void
gala_window_clone_destination_motion (GalaWindowClone* self,
                                      ClutterActor* destination,
                                      gfloat x,
                                      gfloat y)
{
	GalaWindowDragProvider* _tmp0_;
	GalaWindowDragProvider* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = gala_window_drag_provider_get_instance ();
	_tmp1_ = _tmp0_;
	gala_window_drag_provider_notify_motion (_tmp1_, x, y);
	_g_object_unref0 (_tmp1_);
}

/**
     * Depending on the destination we have different ways to find the correct destination.
     * After we found one we destroy ourselves so the dragged clone immediately disappears,
     * otherwise we cancel the drag and animate back to our old place.
     */
static void
gala_window_clone_drag_end (GalaWindowClone* self,
                            ClutterActor* destination)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowCloneActiveShape* _tmp2_;
	MetaDisplay* _tmp3_;
	gboolean did_move = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->active_shape;
	clutter_actor_show ((ClutterActor*) _tmp2_);
	_tmp3_ = display;
	meta_display_set_cursor (_tmp3_, META_CURSOR_DEFAULT);
	did_move = FALSE;
	if (GALA_IS_FRAMED_BACKGROUND (destination)) {
		gint primary = 0;
		MetaDisplay* _tmp4_;
		gboolean _tmp5_ = FALSE;
		MetaWorkspace* workspace = NULL;
		ClutterActor* _tmp8_;
		MetaWorkspace* _tmp9_;
		MetaWorkspace* _tmp10_;
		MetaWorkspace* _tmp11_;
		MetaWorkspace* _tmp12_;
		MetaWindow* _tmp13_;
		MetaWorkspace* _tmp14_;
		_tmp4_ = display;
		primary = meta_display_get_primary_monitor (_tmp4_);
		if (meta_prefs_get_workspaces_only_on_primary ()) {
			MetaWindow* _tmp6_;
			_tmp6_ = self->priv->_window;
			_tmp5_ = meta_window_get_monitor (_tmp6_) != primary;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			MetaWindow* _tmp7_;
			_tmp7_ = self->priv->_window;
			meta_window_move_to_monitor (_tmp7_, primary);
			did_move = TRUE;
		}
		_tmp8_ = clutter_actor_get_parent (destination);
		_tmp9_ = gala_workspace_clone_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone));
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		workspace = _tmp11_;
		_tmp12_ = workspace;
		_tmp13_ = self->priv->_window;
		_tmp14_ = meta_window_get_workspace (_tmp13_);
		if (_tmp12_ != _tmp14_) {
			MetaWindow* _tmp15_;
			MetaWorkspace* _tmp16_;
			_tmp15_ = self->priv->_window;
			_tmp16_ = workspace;
			meta_window_change_workspace (_tmp15_, _tmp16_);
			did_move = TRUE;
		}
		_g_object_unref0 (workspace);
	} else {
		if (GALA_IS_MONITOR_CLONE (destination)) {
			gint monitor = 0;
			gint _tmp17_;
			gint _tmp18_;
			MetaWindow* _tmp19_;
			_tmp17_ = gala_monitor_clone_get_monitor (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone));
			_tmp18_ = _tmp17_;
			monitor = _tmp18_;
			_tmp19_ = self->priv->_window;
			if (meta_window_get_monitor (_tmp19_) != monitor) {
				MetaWindow* _tmp20_;
				_tmp20_ = self->priv->_window;
				meta_window_move_to_monitor (_tmp20_, monitor);
				did_move = TRUE;
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (destination, meta_window_actor_get_type ())) {
				GalaWindowDragProvider* _tmp21_;
				GalaWindowDragProvider* _tmp22_;
				_tmp21_ = gala_window_drag_provider_get_instance ();
				_tmp22_ = _tmp21_;
				gala_window_drag_provider_notify_dropped (_tmp22_);
				_g_object_unref0 (_tmp22_);
			}
		}
	}
	if (did_move) {
		gala_window_clone_finish_drag (self);
	} else {
		gala_window_clone_drag_canceled (self);
	}
}

/**
     * Animate back to our previous position with a bouncing animation.
     */
static Block57Data*
block57_data_ref (Block57Data* _data57_)
{
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}

static void
block57_data_unref (void * _userdata_)
{
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data57_->self;
		_g_object_unref0 (self);
		g_slice_free (Block57Data, _data57_);
	}
}

static void
___lambda65_ (Block57Data* _data57_)
{
	GalaWindowClone* self;
	ClutterClone* _tmp0_;
	self = _data57_->self;
	_tmp0_ = self->priv->drag_handle;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data57_->handler);
	gala_window_clone_finish_drag (self);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
}

static void
____lambda65__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                   gpointer self)
{
	___lambda65_ (self);
}

static void
gala_window_clone_drag_canceled (GalaWindowClone* self)
{
	guint duration = 0U;
	gfloat target_x = 0.0F;
	gfloat target_y = 0.0F;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	ClutterClone* _tmp2_;
	ClutterClone* _tmp3_;
	ClutterClone* _tmp4_;
	ClutterClone* _tmp5_;
	ClutterClone* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	ClutterClone* _tmp9_;
	ClutterClone* _tmp10_;
	ClutterClone* _tmp11_;
	ClutterClone* _tmp12_;
	ClutterClone* _tmp13_;
	GalaCloseButton* _tmp14_;
	GalaTooltip* _tmp15_;
	GalaWindowManager* _tmp16_;
	MetaDisplay* _tmp17_;
	g_return_if_fail (self != NULL);
	duration = gala_utils_get_animation_duration ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp0_, &_tmp1_);
	target_x = _tmp0_;
	target_y = _tmp1_;
	_tmp2_ = self->priv->drag_handle;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->drag_handle;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp3_, duration);
	_tmp4_ = self->priv->drag_handle;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp4_, CLUTTER_EASE_OUT_QUAD);
	_tmp5_ = self->priv->drag_handle;
	clutter_actor_set_position ((ClutterActor*) _tmp5_, target_x, target_y);
	_tmp6_ = self->priv->drag_handle;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp6_);
	_tmp7_ = self->priv->clone;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp7_, 0.0f, 0.0f);
	_tmp8_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp8_);
	_tmp9_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp9_, duration);
	_tmp10_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp10_, CLUTTER_EASE_OUT_QUAD);
	_tmp11_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp11_, (gdouble) 1, (gdouble) 1);
	_tmp12_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp12_, (guint) 255);
	_tmp13_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp13_);
	_tmp14_ = self->priv->close_button;
	g_object_set ((ClutterActor*) _tmp14_, "visible", TRUE, NULL);
	_tmp15_ = self->priv->window_title;
	g_object_set ((ClutterActor*) _tmp15_, "visible", TRUE, NULL);
	_tmp16_ = self->priv->_wm;
	_tmp17_ = meta_plugin_get_display ((MetaPlugin*) _tmp16_);
	meta_display_set_cursor (_tmp17_, META_CURSOR_DEFAULT);
	if (duration > ((guint) 0)) {
		Block57Data* _data57_;
		ClutterClone* _tmp18_;
		gulong _tmp19_;
		_data57_ = g_slice_new0 (Block57Data);
		_data57_->_ref_count_ = 1;
		_data57_->self = g_object_ref (self);
		_data57_->handler = (gulong) 0;
		_tmp18_ = self->priv->drag_handle;
		_tmp19_ = g_signal_connect_data ((ClutterActor*) _tmp18_, "transitions-completed", (GCallback) ____lambda65__clutter_actor_transitions_completed, block57_data_ref (_data57_), (GClosureNotify) block57_data_unref, 0);
		_data57_->handler = _tmp19_;
		block57_data_unref (_data57_);
		_data57_ = NULL;
	} else {
		gala_window_clone_finish_drag (self);
		g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	}
}

static void
gala_window_clone_finish_drag (GalaWindowClone* self)
{
	ClutterClone* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drag_handle;
	if (_tmp0_ != NULL) {
		ClutterClone* _tmp1_;
		ClutterStage* _tmp2_;
		ClutterClone* _tmp3_;
		_tmp1_ = self->priv->drag_handle;
		_tmp2_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) _tmp1_);
		_tmp3_ = self->priv->drag_handle;
		clutter_actor_remove_child ((ClutterActor*) _tmp2_, (ClutterActor*) _tmp3_);
		_g_object_unref0 (self->priv->drag_handle);
		self->priv->drag_handle = NULL;
	}
}

static gboolean
gala_window_clone_is_close_button_on_left (void)
{
	MetaButtonLayout layout = {0};
	MetaButtonLayout _tmp0_ = {0};
	MetaButtonLayout _tmp1_;
	gboolean result;
	meta_prefs_get_button_layout (&_tmp0_);
	layout = _tmp0_;
	_tmp1_ = layout;
	{
		MetaButtonFunction* button_function_collection = NULL;
		gint button_function_collection_length1 = 0;
		gint _button_function_collection_size_ = 0;
		gint button_function_it = 0;
		button_function_collection = _tmp1_.left_buttons;
		button_function_collection_length1 = 4;
		for (button_function_it = 0; button_function_it < button_function_collection_length1; button_function_it = button_function_it + 1) {
			MetaButtonFunction button_function = 0;
			button_function = button_function_collection[button_function_it];
			{
				if (button_function == META_BUTTON_FUNCTION_CLOSE) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static ClutterActor*
gala_window_clone_real_get_actor (GalaRootTarget* base)
{
	ClutterActor* result;
	GalaWindowClone* self;
	self = (GalaWindowClone*) base;
	result = (ClutterActor*) self;
	return result;
}

GalaWindowManager*
gala_window_clone_get_wm (GalaWindowClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_wm (GalaWindowClone* self,
                          GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WM_PROPERTY]);
	}
}

MetaWindow*
gala_window_clone_get_window (GalaWindowClone* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_window (GalaWindowClone* self,
                              MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY]);
	}
}

MtkRectangle*
gala_window_clone_get_slot (GalaWindowClone* self)
{
	MtkRectangle* result;
	MtkRectangle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_slot;
	result = _tmp0_;
	return result;
}

static gboolean
_mtk_rectangle_equal (const MtkRectangle * s1,
                      const MtkRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

static void
gala_window_clone_set_slot (GalaWindowClone* self,
                            MtkRectangle* value)
{
	MtkRectangle* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_slot (self);
	if (_mtk_rectangle_equal (value, old_value) != TRUE) {
		MtkRectangle* _tmp0_;
		_tmp0_ = __vala_MtkRectangle_copy0 (value);
		__vala_MtkRectangle_free0 (self->priv->_slot);
		self->priv->_slot = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY]);
	}
}

void
gala_window_clone_set_active (GalaWindowClone* self,
                              gboolean value)
{
	GalaWindowCloneActiveShape* _tmp0_;
	GalaWindowCloneActiveShape* _tmp1_;
	gint _tmp2_ = 0;
	GalaWindowCloneActiveShape* _tmp3_;
	GalaWindowCloneActiveShape* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_shape;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->active_shape;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, gala_utils_get_animation_duration ((guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION));
	if (value) {
		_tmp2_ = 255;
	} else {
		_tmp2_ = 0;
	}
	_tmp3_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp3_, (guint) _tmp2_);
	_tmp4_ = self->priv->active_shape;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY]);
}

gboolean
gala_window_clone_get_overview_mode (GalaWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY]);
	}
}

gfloat
gala_window_clone_get_monitor_scale (GalaWindowClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_window_clone_set_monitor_scale (GalaWindowClone* self,
                                     gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY]);
	}
}

guint8
gala_window_clone_get_shadow_opacity (GalaWindowClone* self)
{
	guint8 result;
	guint8 _tmp0_ = 0U;
	GalaShadowEffect* _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->shadow_effect;
	if (_tmp1_ != NULL) {
		GalaShadowEffect* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		_tmp2_ = self->priv->shadow_effect;
		_tmp3_ = gala_shadow_effect_get_shadow_opacity (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = (guint8) 255;
	}
	result = _tmp0_;
	return result;
}

void
gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                      guint8 value)
{
	GalaShadowEffect* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shadow_effect;
	if (_tmp0_ != NULL) {
		GalaShadowEffect* _tmp1_;
		_tmp1_ = self->priv->shadow_effect;
		gala_shadow_effect_set_shadow_opacity (_tmp1_, value);
		clutter_actor_queue_redraw ((ClutterActor*) self);
	}
}

static inline gpointer
gala_window_clone_active_shape_get_instance_private (GalaWindowCloneActiveShape* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowCloneActiveShape_private_offset);
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_construct (GType object_type,
                                          gfloat monitor_scale)
{
	GalaWindowCloneActiveShape * self = NULL;
	self = (GalaWindowCloneActiveShape*) g_object_new (object_type, "monitor-scale", monitor_scale, NULL);
	return self;
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_new (gfloat monitor_scale)
{
	return gala_window_clone_active_shape_construct (GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, monitor_scale);
}

static gfloat
gala_window_clone_active_shape_get_monitor_scale (GalaWindowCloneActiveShape* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

static void
gala_window_clone_active_shape_set_monitor_scale (GalaWindowCloneActiveShape* self,
                                                  gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_active_shape_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_active_shape_properties[GALA_WINDOW_CLONE_ACTIVE_SHAPE_MONITOR_SCALE_PROPERTY]);
	}
}

static gboolean
_gala_window_clone_active_shape___lambda37_ (GalaWindowCloneActiveShape* self,
                                             GBinding* binding,
                                             GValue* from_value,
                                             GValue* to_value)
{
	ClutterColor new_color = {0};
	GValue _tmp0_;
	ClutterColor* _tmp1_;
	ClutterColor _tmp2_ = {0};
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	g_return_val_if_fail (to_value != NULL, FALSE);
	_tmp0_ = *from_value;
	_tmp1_ = g_value_get_boxed (&_tmp0_);
	new_color = (G_VALUE_HOLDS (&_tmp0_, clutter_color_get_type ()) && _tmp1_) ? (*_tmp1_) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp2_);
	new_color.alpha = GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY;
	g_value_set_boxed (to_value, &new_color);
	result = TRUE;
	return result;
}

static gboolean
__gala_window_clone_active_shape___lambda37__gbinding_transform_func (GBinding* binding,
                                                                      GValue* from_value,
                                                                      GValue* to_value,
                                                                      gpointer self)
{
	gboolean result;
	result = _gala_window_clone_active_shape___lambda37_ ((GalaWindowCloneActiveShape*) self, binding, from_value, to_value);
	return result;
}

static GObject *
gala_window_clone_active_shape_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowCloneActiveShape * self;
	GalaRoundedCornersEffect* rounded_corners_effect = NULL;
	gfloat _tmp0_;
	GalaRoundedCornersEffect* _tmp1_;
	GalaRoundedCornersEffect* _tmp2_;
	GalaRoundedCornersEffect* _tmp3_;
	GalaDrawingStyleManager* style_manager = NULL;
	GalaDrawingStyleManager* _tmp4_;
	GalaDrawingStyleManager* _tmp5_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_active_shape_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	_tmp0_ = self->priv->_monitor_scale;
	_tmp1_ = gala_rounded_corners_effect_new ((gfloat) GALA_WINDOW_CLONE_ACTIVE_SHAPE_BORDER_RADIUS, _tmp0_);
	g_object_ref_sink (_tmp1_);
	rounded_corners_effect = _tmp1_;
	_tmp2_ = rounded_corners_effect;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp2_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = rounded_corners_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp3_);
	_tmp4_ = gala_drawing_style_manager_get_instance ();
	style_manager = _tmp4_;
	_tmp5_ = style_manager;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "theme-accent-color", (GObject*) self, "background-color", G_BINDING_SYNC_CREATE, (GClosure*) ((__gala_window_clone_active_shape___lambda37__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __gala_window_clone_active_shape___lambda37__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (rounded_corners_effect);
	return obj;
}

static void
gala_window_clone_active_shape_class_init (GalaWindowCloneActiveShapeClass * klass,
                                           gpointer klass_data)
{
	gala_window_clone_active_shape_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowCloneActiveShape_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_active_shape_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_active_shape_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_active_shape_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_active_shape_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_ACTIVE_SHAPE_MONITOR_SCALE_PROPERTY, gala_window_clone_active_shape_properties[GALA_WINDOW_CLONE_ACTIVE_SHAPE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_window_clone_active_shape_instance_init (GalaWindowCloneActiveShape * self,
                                              gpointer klass)
{
	self->priv = gala_window_clone_active_shape_get_instance_private (self);
}

static void
gala_window_clone_active_shape_finalize (GObject * obj)
{
	GalaWindowCloneActiveShape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	G_OBJECT_CLASS (gala_window_clone_active_shape_parent_class)->finalize (obj);
}

/**
     * Border to show around the selected window when using keyboard navigation.
     */
 G_GNUC_NO_INLINE static GType
gala_window_clone_active_shape_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneActiveShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_active_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneActiveShape), 0, (GInstanceInitFunc) gala_window_clone_active_shape_instance_init, NULL };
	GType gala_window_clone_active_shape_type_id;
	gala_window_clone_active_shape_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowCloneActiveShape", &g_define_type_info, 0);
	GalaWindowCloneActiveShape_private_offset = g_type_add_instance_private (gala_window_clone_active_shape_type_id, sizeof (GalaWindowCloneActiveShapePrivate));
	return gala_window_clone_active_shape_type_id;
}

static GType
gala_window_clone_active_shape_get_type (void)
{
	static gsize gala_window_clone_active_shape_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_active_shape_type_id__once)) {
		GType gala_window_clone_active_shape_type_id;
		gala_window_clone_active_shape_type_id = gala_window_clone_active_shape_get_type_once ();
		g_once_init_leave (&gala_window_clone_active_shape_type_id__once, gala_window_clone_active_shape_type_id);
	}
	return gala_window_clone_active_shape_type_id__once;
}

static void
_vala_gala_window_clone_active_shape_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GalaWindowCloneActiveShape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	switch (property_id) {
		case GALA_WINDOW_CLONE_ACTIVE_SHAPE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_clone_active_shape_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_active_shape_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GalaWindowCloneActiveShape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	switch (property_id) {
		case GALA_WINDOW_CLONE_ACTIVE_SHAPE_MONITOR_SCALE_PROPERTY:
		gala_window_clone_active_shape_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_gala_window_clone___lambda66_ (GalaWindowClone* self)
{
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
}

static void
__gala_window_clone___lambda66__meta_window_size_changed (MetaWindow* _sender,
                                                          gpointer self)
{
	_gala_window_clone___lambda66_ ((GalaWindowClone*) self);
}

static void
_gala_window_clone____lambda67_ (GalaWindowClone* self,
                                 ClutterClickAction* action,
                                 ClutterActor* actor)
{
	g_return_if_fail (action != NULL);
	g_return_if_fail (actor != NULL);
	gala_window_clone_actor_clicked (self, (guint32) clutter_click_action_get_button (action), CLUTTER_POINTER_DEVICE);
}

static void
__gala_window_clone____lambda67__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self)
{
	_gala_window_clone____lambda67_ ((GalaWindowClone*) self, _sender, actor);
}

static ClutterActor*
_gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                gfloat x,
                                                                gfloat y,
                                                                gpointer self)
{
	ClutterActor* result;
	result = gala_window_clone_drag_begin ((GalaWindowClone*) self, x, y);
	return result;
}

static void
_gala_window_clone_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                  ClutterActor* destination,
                                                                                  gboolean hovered,
                                                                                  gpointer self)
{
	gala_window_clone_destination_crossed ((GalaWindowClone*) self, destination, hovered);
}

static void
_gala_window_clone_destination_motion_gala_drag_drop_action_destination_motion (GalaDragDropAction* _sender,
                                                                                ClutterActor* destination,
                                                                                gfloat x,
                                                                                gfloat y,
                                                                                gpointer self)
{
	gala_window_clone_destination_motion ((GalaWindowClone*) self, destination, x, y);
}

static void
_gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                            ClutterActor* actor,
                                                            gpointer self)
{
	gala_window_clone_drag_end ((GalaWindowClone*) self, actor);
}

static void
_gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                      gpointer self)
{
	gala_window_clone_drag_canceled ((GalaWindowClone*) self);
}

static void
_gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                      guint32 button,
                                                                      ClutterInputDeviceType device_type,
                                                                      gpointer self)
{
	gala_window_clone_actor_clicked ((GalaWindowClone*) self, button, device_type);
}

static void
_gala_window_clone_close_window_gala_close_button_triggered (GalaCloseButton* _sender,
                                                             guint32 timestamp,
                                                             gpointer self)
{
	gala_window_clone_close_window ((GalaWindowClone*) self, timestamp);
}

static void
_gala_window_clone___lambda68_ (GalaWindowClone* self)
{
	gala_window_clone_update_hover_widgets (self, NULL);
}

static void
__gala_window_clone___lambda68__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_window_clone___lambda68_ ((GalaWindowClone*) self);
}

static void
_gala_window_clone_reallocate_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	gala_window_clone_reallocate ((GalaWindowClone*) self);
}

static void
_gala_window_clone_load_clone_gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                               gpointer self)
{
	gala_window_clone_load_clone ((GalaWindowClone*) self, window_actor);
}

static void
_gala_window_clone___lambda69_ (GalaWindowClone* self)
{
	const gchar* _tmp0_ = NULL;
	MetaWindow* _tmp1_;
	const gchar* _tmp2_;
	GalaTooltip* _tmp3_;
	_tmp1_ = self->priv->_window;
	_tmp2_ = meta_window_get_title (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp3_ = self->priv->window_title;
	gala_tooltip_set_text (_tmp3_, _tmp0_);
}

static void
__gala_window_clone___lambda69__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_window_clone___lambda69_ ((GalaWindowClone*) self);
}

static void
_gala_window_clone___lambda70_ (GalaWindowClone* self)
{
	gala_window_clone_update_hover_widgets (self, NULL);
}

static void
__gala_window_clone___lambda70__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_window_clone___lambda70_ ((GalaWindowClone*) self);
}

static GObject *
gala_window_clone_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowClone * self;
	GalaWindowManager* _tmp0_;
	GalaGestureController* _tmp1_;
	GalaGestureController* _tmp2_;
	GalaGestureController* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	MetaWindow* _tmp10_;
	gboolean _tmp11_;
	gfloat _tmp23_;
	GalaWindowCloneActiveShape* _tmp24_ = NULL;
	GalaWindowCloneActiveShape* _tmp25_;
	graphene_point_t _tmp26_ = {0};
	ClutterActor* _tmp27_ = NULL;
	gfloat _tmp28_;
	GalaTooltip* _tmp29_;
	GalaTooltip* _tmp30_;
	gfloat _tmp31_;
	GalaCloseButton* _tmp32_ = NULL;
	GalaCloseButton* _tmp33_;
	GalaCloseButton* _tmp34_;
	GalaCloseButton* _tmp35_;
	GalaWindowCloneActiveShape* _tmp36_;
	ClutterActor* _tmp37_;
	GalaTooltip* _tmp38_;
	GalaCloseButton* _tmp39_;
	MetaWindow* _tmp40_;
	MetaWindow* _tmp41_;
	const gchar* _tmp42_ = NULL;
	MetaWindow* _tmp43_;
	const gchar* _tmp44_;
	GalaTooltip* _tmp45_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_CUSTOM, _tmp0_, GALA_GESTURE_CONTROLLER_GROUP_NONE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp1_;
	_tmp2_ = self->priv->gesture_controller;
	gala_gesture_controller_enable_scroll (_tmp2_, (ClutterActor*) self, CLUTTER_ORIENTATION_VERTICAL);
	_tmp3_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp3_);
	_tmp4_ = self->priv->_window;
	g_signal_connect_object (_tmp4_, "unmanaged", (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self, 0);
	_tmp5_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::fullscreen", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp6_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::maximized-horizontally", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp7_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::maximized-vertically", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp8_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::minimized", (GCallback) _gala_window_clone_update_targets_g_object_notify, self, 0);
	_tmp9_ = self->priv->_window;
	g_signal_connect_object (_tmp9_, "position-changed", (GCallback) _gala_window_clone_update_targets_meta_window_position_changed, self, 0);
	_tmp10_ = self->priv->_window;
	g_signal_connect_object (_tmp10_, "size-changed", (GCallback) __gala_window_clone___lambda66__meta_window_size_changed, self, 0);
	_tmp11_ = self->priv->_overview_mode;
	if (_tmp11_) {
		ClutterClickAction* click_action = NULL;
		ClutterClickAction* _tmp12_;
		ClutterClickAction* _tmp13_;
		ClutterClickAction* _tmp14_;
		_tmp12_ = (ClutterClickAction*) clutter_click_action_new ();
		g_object_ref_sink (_tmp12_);
		click_action = _tmp12_;
		_tmp13_ = click_action;
		g_signal_connect_object (_tmp13_, "clicked", (GCallback) __gala_window_clone____lambda67__clutter_click_action_clicked, self, 0);
		_tmp14_ = click_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp14_);
		_g_object_unref0 (click_action);
	} else {
		GalaDragDropAction* _tmp15_;
		GalaDragDropAction* _tmp16_;
		GalaDragDropAction* _tmp17_;
		GalaDragDropAction* _tmp18_;
		GalaDragDropAction* _tmp19_;
		GalaDragDropAction* _tmp20_;
		GalaDragDropAction* _tmp21_;
		GalaDragDropAction* _tmp22_;
		_tmp15_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "multitaskingview-window");
		g_object_ref_sink (_tmp15_);
		_g_object_unref0 (self->priv->drag_action);
		self->priv->drag_action = _tmp15_;
		_tmp16_ = self->priv->drag_action;
		g_signal_connect_object (_tmp16_, "drag-begin", (GCallback) _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
		_tmp17_ = self->priv->drag_action;
		g_signal_connect_object (_tmp17_, "destination-crossed", (GCallback) _gala_window_clone_destination_crossed_gala_drag_drop_action_destination_crossed, self, 0);
		_tmp18_ = self->priv->drag_action;
		g_signal_connect_object (_tmp18_, "destination-motion", (GCallback) _gala_window_clone_destination_motion_gala_drag_drop_action_destination_motion, self, 0);
		_tmp19_ = self->priv->drag_action;
		g_signal_connect_object (_tmp19_, "drag-end", (GCallback) _gala_window_clone_drag_end_gala_drag_drop_action_drag_end, self, 0);
		_tmp20_ = self->priv->drag_action;
		g_signal_connect_object (_tmp20_, "drag-canceled", (GCallback) _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
		_tmp21_ = self->priv->drag_action;
		g_signal_connect_object (_tmp21_, "actor-clicked", (GCallback) _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked, self, 0);
		_tmp22_ = self->priv->drag_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp22_);
	}
	_tmp23_ = self->priv->_monitor_scale;
	_tmp24_ = gala_window_clone_active_shape_new (_tmp23_);
	clutter_actor_set_opacity ((ClutterActor*) _tmp24_, (guint) 0);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->active_shape);
	self->priv->active_shape = _tmp24_;
	_tmp25_ = self->priv->active_shape;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp25_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp26_.x = 0.5f;
	_tmp26_.y = 0.5f;
	_tmp27_ = clutter_actor_new ();
	g_object_set (_tmp27_, "pivot-point", &_tmp26_, NULL);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->clone_container);
	self->priv->clone_container = _tmp27_;
	_tmp28_ = self->priv->_monitor_scale;
	_tmp29_ = gala_tooltip_new (_tmp28_);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->window_title);
	self->priv->window_title = _tmp29_;
	_tmp30_ = self->priv->window_title;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp30_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp31_ = self->priv->_monitor_scale;
	_tmp32_ = gala_close_button_new (_tmp31_);
	clutter_actor_set_opacity ((ClutterActor*) _tmp32_, (guint) 0);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp32_;
	_tmp33_ = self->priv->close_button;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp33_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->close_button;
	g_signal_connect_object (_tmp34_, "triggered", (GCallback) _gala_window_clone_close_window_gala_close_button_triggered, self, 0);
	_tmp35_ = self->priv->close_button;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::has-pointer", (GCallback) __gala_window_clone___lambda68__g_object_notify, self, 0);
	_tmp36_ = self->priv->active_shape;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp36_);
	_tmp37_ = self->priv->clone_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp37_);
	_tmp38_ = self->priv->window_title;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp38_);
	_tmp39_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp39_);
	g_signal_connect_object ((GObject*) self, "notify::monitor-scale", (GCallback) _gala_window_clone_reallocate_g_object_notify, self, 0);
	gala_window_clone_reallocate (self);
	_tmp40_ = self->priv->_window;
	gala_internal_utils_wait_for_window_actor (_tmp40_, _gala_window_clone_load_clone_gala_internal_utils_window_actor_ready_callback, g_object_ref (self), g_object_unref);
	_tmp41_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp41_, "notify::title", (GCallback) __gala_window_clone___lambda69__g_object_notify, self, 0);
	_tmp43_ = self->priv->_window;
	_tmp44_ = meta_window_get_title (_tmp43_);
	_tmp42_ = _tmp44_;
	if (_tmp42_ == NULL) {
		_tmp42_ = "";
	}
	_tmp45_ = self->priv->window_title;
	gala_tooltip_set_text (_tmp45_, _tmp42_);
	g_signal_connect_object ((GObject*) self, "notify::has-pointer", (GCallback) __gala_window_clone___lambda70__g_object_notify, self, 0);
	return obj;
}

static void
gala_window_clone_class_init (GalaWindowCloneClass * klass,
                              gpointer klass_data)
{
	gala_window_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowClone_private_offset);
	((GalaActorTargetClass *) klass)->start_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_window_clone_real_start_progress;
	((GalaActorTargetClass *) klass)->update_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_window_clone_real_update_progress;
	((GalaActorTargetClass *) klass)->end_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_window_clone_real_end_progress;
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, const ClutterActorBox *)) gala_window_clone_real_allocate;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_ACTOR_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WM_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WINDOW_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The currently assigned slot of the window in the tiling layout. May be null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SLOT_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY] = g_param_spec_boxed ("slot", "slot", "slot", mtk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * When active fades a white border around the window in. Used for the visually
	     * indicating the WindowCloneContainer's current_window.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_ACTIVE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	     * The window was selected. The MultitaskingView should consider activating
	     * the window and closing the view.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * The window was moved or resized and a relayout of the tiling layout may
	     * be sensible right now.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL] = g_signal_new ("request-reposition", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                   gpointer iface_data)
{
	gala_window_clone_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_actor = gala_window_clone_real_get_actor;
}

static void
gala_window_clone_instance_init (GalaWindowClone * self,
                                 gpointer klass)
{
	self->priv = gala_window_clone_get_instance_private (self);
	self->priv->_slot = NULL;
	self->priv->drag_action = NULL;
	self->priv->clone = NULL;
	self->priv->shadow_effect = NULL;
	self->priv->drag_handle = NULL;
	self->priv->check_confirm_dialog_cb = (gulong) 0;
	self->priv->in_slot_animation = FALSE;
}

static void
gala_window_clone_finalize (GObject * obj)
{
	GalaWindowClone * self;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	MetaWindow* _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	MetaWindow* _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	MetaWindow* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	MetaWindow* _tmp11_;
	guint _tmp12_;
	GQuark _tmp13_;
	MetaWindow* _tmp14_;
	guint _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	_tmp0_ = self->priv->_window;
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self);
	_tmp2_ = self->priv->_window;
	g_signal_parse_name ("notify::fullscreen", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp5_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-horizontally", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp8_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-vertically", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp11_ = self->priv->_window;
	g_signal_parse_name ("notify::minimized", G_TYPE_OBJECT, &_tmp12_, &_tmp13_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, _tmp13_, NULL, (GCallback) _gala_window_clone_update_targets_g_object_notify, self);
	_tmp14_ = self->priv->_window;
	g_signal_parse_name ("position-changed", meta_window_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _gala_window_clone_update_targets_meta_window_position_changed, self);
	gala_window_clone_finish_drag (self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_window);
	__vala_MtkRectangle_free0 (self->priv->_slot);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->drag_handle);
	_g_object_unref0 (self->priv->clone_container);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->active_shape);
	_g_object_unref0 (self->priv->window_icon);
	_g_object_unref0 (self->priv->window_title);
	_g_object_unref0 (self->priv->gesture_controller);
	G_OBJECT_CLASS (gala_window_clone_parent_class)->finalize (obj);
}

/**
 * A container for a clone of the texture of a MetaWindow, a WindowIcon, a Tooltip with the title,
 * a close button and a shadow. Used together with the WindowCloneContainer.
 */
 G_GNUC_NO_INLINE static GType
gala_window_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowClone), 0, (GInstanceInitFunc) gala_window_clone_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_window_clone_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_clone_type_id;
	gala_window_clone_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWindowClone", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_clone_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaWindowClone_private_offset = g_type_add_instance_private (gala_window_clone_type_id, sizeof (GalaWindowClonePrivate));
	return gala_window_clone_type_id;
}

GType
gala_window_clone_get_type (void)
{
	static gsize gala_window_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_type_id__once)) {
		GType gala_window_clone_type_id;
		gala_window_clone_type_id = gala_window_clone_get_type_once ();
		g_once_init_leave (&gala_window_clone_type_id__once, gala_window_clone_type_id);
	}
	return gala_window_clone_type_id__once;
}

static void
_vala_gala_window_clone_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_ACTOR_PROPERTY:
		g_value_set_object (value, gala_root_target_get_actor ((GalaRootTarget*) self));
		break;
		case GALA_WINDOW_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_wm (self));
		break;
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_window (self));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		{
			MtkRectangle* boxed;
			boxed = gala_window_clone_get_slot (self);
			g_value_set_boxed (value, boxed);
		}
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_get_overview_mode (self));
		break;
		case GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_clone_get_monitor_scale (self));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_window_clone_get_shadow_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WM_PROPERTY:
		gala_window_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		gala_window_clone_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		gala_window_clone_set_slot (self, g_value_get_boxed (value));
		break;
		case GALA_WINDOW_CLONE_ACTIVE_PROPERTY:
		gala_window_clone_set_active (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_set_overview_mode (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY:
		gala_window_clone_set_monitor_scale (self, g_value_get_float (value));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		gala_window_clone_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

