const char FreeCADTest[] ="#***************************************************************************\n"
"#*   Copyright (c) 2002 Jürgen Riegel <juergen.riegel@web.de>              *\n"
"#*                                                                         *\n"
"#*   This file is part of the FreeCAD CAx development system.              *\n"
"#*                                                                         *\n"
"#*   This program is free software; you can redistribute it and/or modify  *\n"
"#*   it under the terms of the GNU Lesser General Public License (LGPL)    *\n"
"#*   as published by the Free Software Foundation; either version 2 of     *\n"
"#*   the License, or (at your option) any later version.                   *\n"
"#*   for detail see the LICENCE text file.                                 *\n"
"#*                                                                         *\n"
"#*   FreeCAD is distributed in the hope that it will be useful,            *\n"
"#*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
"#*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
"#*   GNU Lesser General Public License for more details.                   *\n"
"#*                                                                         *\n"
"#*   You should have received a copy of the GNU Library General Public     *\n"
"#*   License along with FreeCAD; if not, write to the Free Software        *\n"
"#*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *\n"
"#*   USA                                                                   *\n"
"#*                                                                         *\n"
"#***************************************************************************/\n"
"\n"
"# FreeCAD test module\n"
"#\n"
"# Testing the function of the base system and run\n"
"# (if existing) the test function of the modules\n"
"\n"
"\n"
"\n"
"Log (\"FreeCAD test running...\\n\\n\")\n"
"\n"
"import sys\n"
"\n"
"import FreeCAD\n"
"import TestApp\n"
"\n"
"testCase = FreeCAD.ConfigGet(\"TestCase\")\n"
"\n"
"testResult = TestApp.TestText(testCase)\n"
"\n"
"Log (\"FreeCAD test done\\n\")\n"
"\n"
"sys.exit(0 if testResult.wasSuccessful() else 1)\n"
;


