/* scorebox.c generated by valac 0.56.18, the Vala compiler
 * generated from scorebox.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Four-in-a-row.

   Copyright © 2018 Jacob Humphrey

   GNOME Four-in-a-row is free software: you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Four-in-a-row is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Four-in-a-row.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCOREBOX (scorebox_get_type ())
#define SCOREBOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOX, Scorebox))
#define SCOREBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOX, ScoreboxClass))
#define IS_SCOREBOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOX))
#define IS_SCOREBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOX))
#define SCOREBOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOX, ScoreboxClass))

typedef struct _Scorebox Scorebox;
typedef struct _ScoreboxClass ScoreboxClass;
typedef struct _ScoreboxPrivate ScoreboxPrivate;

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;
typedef enum  {
	PLAYER_NOBODY,
	PLAYER_HUMAN,
	PLAYER_OPPONENT
} Player;

#define TYPE_PLAYER (player_get_type ())
enum  {
	SCOREBOX_0_PROPERTY,
	SCOREBOX_THEME_MANAGER_PROPERTY,
	SCOREBOX_NUM_PROPERTIES
};
static GParamSpec* scorebox_properties[SCOREBOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FOUR_IN_AROW (four_in_arow_get_type ())
#define FOUR_IN_AROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOUR_IN_AROW, FourInARow))
#define FOUR_IN_AROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOUR_IN_AROW, FourInARowClass))
#define IS_FOUR_IN_AROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOUR_IN_AROW))
#define IS_FOUR_IN_AROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOUR_IN_AROW))
#define FOUR_IN_AROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOUR_IN_AROW, FourInARowClass))

typedef struct _FourInARow FourInARow;
typedef struct _FourInARowClass FourInARowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Scorebox {
	GtkDialog parent_instance;
	ScoreboxPrivate * priv;
};

struct _ScoreboxClass {
	GtkDialogClass parent_class;
};

struct _ScoreboxPrivate {
	ThemeManager* _theme_manager;
	GtkLabel* label_name_top;
	GtkLabel* label_score_top;
	GtkLabel* label_name_mid;
	GtkLabel* label_score_mid;
	GtkLabel* label_score_end;
	gboolean one_player_game;
	Player last_winner;
	guint* scores;
	gint scores_length1;
	gint _scores_size_;
};

static gint Scorebox_private_offset;
static gpointer scorebox_parent_class = NULL;

VALA_EXTERN GType scorebox_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scorebox, g_object_unref)
VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType four_in_arow_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FourInARow, g_object_unref)
VALA_EXTERN Scorebox* scorebox_new (GtkWindow* parent,
                        FourInARow* application,
                        ThemeManager* theme_manager);
VALA_EXTERN Scorebox* scorebox_construct (GType object_type,
                              GtkWindow* parent,
                              FourInARow* application,
                              ThemeManager* theme_manager);
static void scorebox_update (Scorebox* self);
static ThemeManager* scorebox_get_theme_manager (Scorebox* self);
VALA_EXTERN gchar* theme_manager_get_player (ThemeManager* self,
                                 Player who,
                                 gboolean with_colon);
static gboolean scorebox_real_delete_event (GtkWidget* base,
                                     GdkEventAny* event);
VALA_EXTERN void scorebox_new_match (Scorebox* self,
                         gboolean _one_player_game);
VALA_EXTERN void scorebox_give_up (Scorebox* self,
                       Player player);
VALA_EXTERN void scorebox_win (Scorebox* self,
                   Player player);
VALA_EXTERN void scorebox_unwin (Scorebox* self);
VALA_EXTERN gboolean scorebox_is_first_game (Scorebox* self);
static void scorebox_set_theme_manager (Scorebox* self,
                                 ThemeManager* value);
static GObject * scorebox_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties);
static void _scorebox_update_theme_manager_theme_changed (ThemeManager* _sender,
                                                   gpointer self);
static void scorebox_finalize (GObject * obj);
static GType scorebox_get_type_once (void);
static void _vala_scorebox_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_scorebox_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

static inline gpointer
scorebox_get_instance_private (Scorebox* self)
{
	return G_STRUCT_MEMBER_P (self, Scorebox_private_offset);
}

Scorebox*
scorebox_construct (GType object_type,
                    GtkWindow* parent,
                    FourInARow* application,
                    ThemeManager* theme_manager)
{
	Scorebox * self = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (theme_manager != NULL, NULL);
	self = (Scorebox*) g_object_new (object_type, "title", _ ("Scores"), "use-header-bar", 1, "destroy-with-parent", TRUE, "resizable", FALSE, "application", application, "transient-for", parent, "modal", TRUE, "theme-manager", theme_manager, NULL);
	return self;
}

Scorebox*
scorebox_new (GtkWindow* parent,
              FourInARow* application,
              ThemeManager* theme_manager)
{
	return scorebox_construct (TYPE_SCOREBOX, parent, application, theme_manager);
}

static void
scorebox_update (Scorebox* self)
{
	GtkLabel* _tmp68_;
	guint* _tmp69_;
	gint _tmp69__length1;
	guint _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	g_return_if_fail (self != NULL);
	if (self->priv->one_player_game) {
		guint* _tmp0_;
		gint _tmp0__length1;
		guint _tmp1_;
		guint* _tmp2_;
		gint _tmp2__length1;
		guint _tmp3_;
		_tmp0_ = self->priv->scores;
		_tmp0__length1 = self->priv->scores_length1;
		_tmp1_ = _tmp0_[PLAYER_HUMAN];
		_tmp2_ = self->priv->scores;
		_tmp2__length1 = self->priv->scores_length1;
		_tmp3_ = _tmp2_[PLAYER_OPPONENT];
		if (_tmp1_ >= _tmp3_) {
			GtkLabel* _tmp4_;
			GtkLabel* _tmp5_;
			GtkLabel* _tmp6_;
			guint* _tmp7_;
			gint _tmp7__length1;
			guint _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GtkLabel* _tmp11_;
			guint* _tmp12_;
			gint _tmp12__length1;
			guint _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp4_ = self->priv->label_name_top;
			gtk_label_set_text (_tmp4_, _ ("You:"));
			_tmp5_ = self->priv->label_name_mid;
			gtk_label_set_text (_tmp5_, _ ("Me:"));
			_tmp6_ = self->priv->label_score_top;
			_tmp7_ = self->priv->scores;
			_tmp7__length1 = self->priv->scores_length1;
			_tmp8_ = _tmp7_[PLAYER_HUMAN];
			_tmp9_ = g_strdup_printf ("%u", _tmp8_);
			_tmp10_ = _tmp9_;
			gtk_label_set_label (_tmp6_, _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = self->priv->label_score_mid;
			_tmp12_ = self->priv->scores;
			_tmp12__length1 = self->priv->scores_length1;
			_tmp13_ = _tmp12_[PLAYER_OPPONENT];
			_tmp14_ = g_strdup_printf ("%u", _tmp13_);
			_tmp15_ = _tmp14_;
			gtk_label_set_label (_tmp11_, _tmp15_);
			_g_free0 (_tmp15_);
		} else {
			GtkLabel* _tmp16_;
			GtkLabel* _tmp17_;
			GtkLabel* _tmp18_;
			guint* _tmp19_;
			gint _tmp19__length1;
			guint _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GtkLabel* _tmp23_;
			guint* _tmp24_;
			gint _tmp24__length1;
			guint _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp16_ = self->priv->label_name_top;
			gtk_label_set_text (_tmp16_, _ ("Me:"));
			_tmp17_ = self->priv->label_name_mid;
			gtk_label_set_text (_tmp17_, _ ("You:"));
			_tmp18_ = self->priv->label_score_top;
			_tmp19_ = self->priv->scores;
			_tmp19__length1 = self->priv->scores_length1;
			_tmp20_ = _tmp19_[PLAYER_OPPONENT];
			_tmp21_ = g_strdup_printf ("%u", _tmp20_);
			_tmp22_ = _tmp21_;
			gtk_label_set_label (_tmp18_, _tmp22_);
			_g_free0 (_tmp22_);
			_tmp23_ = self->priv->label_score_mid;
			_tmp24_ = self->priv->scores;
			_tmp24__length1 = self->priv->scores_length1;
			_tmp25_ = _tmp24_[PLAYER_HUMAN];
			_tmp26_ = g_strdup_printf ("%u", _tmp25_);
			_tmp27_ = _tmp26_;
			gtk_label_set_label (_tmp23_, _tmp27_);
			_g_free0 (_tmp27_);
		}
	} else {
		guint* _tmp28_;
		gint _tmp28__length1;
		guint _tmp29_;
		guint* _tmp30_;
		gint _tmp30__length1;
		guint _tmp31_;
		_tmp28_ = self->priv->scores;
		_tmp28__length1 = self->priv->scores_length1;
		_tmp29_ = _tmp28_[PLAYER_HUMAN];
		_tmp30_ = self->priv->scores;
		_tmp30__length1 = self->priv->scores_length1;
		_tmp31_ = _tmp30_[PLAYER_OPPONENT];
		if (_tmp29_ >= _tmp31_) {
			GtkLabel* _tmp32_;
			ThemeManager* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			GtkLabel* _tmp36_;
			ThemeManager* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			GtkLabel* _tmp40_;
			guint* _tmp41_;
			gint _tmp41__length1;
			guint _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			GtkLabel* _tmp45_;
			guint* _tmp46_;
			gint _tmp46__length1;
			guint _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp32_ = self->priv->label_name_top;
			_tmp33_ = self->priv->_theme_manager;
			_tmp34_ = theme_manager_get_player (_tmp33_, PLAYER_HUMAN, TRUE);
			_tmp35_ = _tmp34_;
			gtk_label_set_label (_tmp32_, _tmp35_);
			_g_free0 (_tmp35_);
			_tmp36_ = self->priv->label_name_mid;
			_tmp37_ = self->priv->_theme_manager;
			_tmp38_ = theme_manager_get_player (_tmp37_, PLAYER_OPPONENT, TRUE);
			_tmp39_ = _tmp38_;
			gtk_label_set_label (_tmp36_, _tmp39_);
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->label_score_top;
			_tmp41_ = self->priv->scores;
			_tmp41__length1 = self->priv->scores_length1;
			_tmp42_ = _tmp41_[PLAYER_HUMAN];
			_tmp43_ = g_strdup_printf ("%u", _tmp42_);
			_tmp44_ = _tmp43_;
			gtk_label_set_label (_tmp40_, _tmp44_);
			_g_free0 (_tmp44_);
			_tmp45_ = self->priv->label_score_mid;
			_tmp46_ = self->priv->scores;
			_tmp46__length1 = self->priv->scores_length1;
			_tmp47_ = _tmp46_[PLAYER_OPPONENT];
			_tmp48_ = g_strdup_printf ("%u", _tmp47_);
			_tmp49_ = _tmp48_;
			gtk_label_set_label (_tmp45_, _tmp49_);
			_g_free0 (_tmp49_);
		} else {
			GtkLabel* _tmp50_;
			ThemeManager* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			GtkLabel* _tmp54_;
			ThemeManager* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			GtkLabel* _tmp58_;
			guint* _tmp59_;
			gint _tmp59__length1;
			guint _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			GtkLabel* _tmp63_;
			guint* _tmp64_;
			gint _tmp64__length1;
			guint _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp50_ = self->priv->label_name_top;
			_tmp51_ = self->priv->_theme_manager;
			_tmp52_ = theme_manager_get_player (_tmp51_, PLAYER_OPPONENT, TRUE);
			_tmp53_ = _tmp52_;
			gtk_label_set_label (_tmp50_, _tmp53_);
			_g_free0 (_tmp53_);
			_tmp54_ = self->priv->label_name_mid;
			_tmp55_ = self->priv->_theme_manager;
			_tmp56_ = theme_manager_get_player (_tmp55_, PLAYER_HUMAN, TRUE);
			_tmp57_ = _tmp56_;
			gtk_label_set_label (_tmp54_, _tmp57_);
			_g_free0 (_tmp57_);
			_tmp58_ = self->priv->label_score_top;
			_tmp59_ = self->priv->scores;
			_tmp59__length1 = self->priv->scores_length1;
			_tmp60_ = _tmp59_[PLAYER_OPPONENT];
			_tmp61_ = g_strdup_printf ("%u", _tmp60_);
			_tmp62_ = _tmp61_;
			gtk_label_set_label (_tmp58_, _tmp62_);
			_g_free0 (_tmp62_);
			_tmp63_ = self->priv->label_score_mid;
			_tmp64_ = self->priv->scores;
			_tmp64__length1 = self->priv->scores_length1;
			_tmp65_ = _tmp64_[PLAYER_HUMAN];
			_tmp66_ = g_strdup_printf ("%u", _tmp65_);
			_tmp67_ = _tmp66_;
			gtk_label_set_label (_tmp63_, _tmp67_);
			_g_free0 (_tmp67_);
		}
	}
	_tmp68_ = self->priv->label_score_end;
	_tmp69_ = self->priv->scores;
	_tmp69__length1 = self->priv->scores_length1;
	_tmp70_ = _tmp69_[PLAYER_NOBODY];
	_tmp71_ = g_strdup_printf ("%u", _tmp70_);
	_tmp72_ = _tmp71_;
	gtk_label_set_label (_tmp68_, _tmp72_);
	_g_free0 (_tmp72_);
}

static gboolean
scorebox_real_delete_event (GtkWidget* base,
                            GdkEventAny* event)
{
	Scorebox * self;
	gboolean result;
	self = (Scorebox*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self);
	result = TRUE;
	return result;
}

void
scorebox_new_match (Scorebox* self,
                    gboolean _one_player_game)
{
	guint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (guint, 3);
	_tmp0_[0] = (guint) 0;
	_tmp0_[1] = (guint) 0;
	_tmp0_[2] = (guint) 0;
	self->priv->scores = (g_free (self->priv->scores), NULL);
	self->priv->scores = _tmp0_;
	self->priv->scores_length1 = 3;
	self->priv->_scores_size_ = self->priv->scores_length1;
	self->priv->last_winner = PLAYER_NOBODY;
	self->priv->one_player_game = _one_player_game;
	scorebox_update (self);
}

void
scorebox_give_up (Scorebox* self,
                  Player player)
{
	g_return_if_fail (self != NULL);
	if (player == PLAYER_HUMAN) {
		guint* _tmp0_;
		gint _tmp0__length1;
		guint _tmp1_;
		_tmp0_ = self->priv->scores;
		_tmp0__length1 = self->priv->scores_length1;
		_tmp1_ = _tmp0_[PLAYER_OPPONENT];
		_tmp0_[PLAYER_OPPONENT] = _tmp1_ + 1;
	} else {
		if (player == PLAYER_OPPONENT) {
			guint* _tmp2_;
			gint _tmp2__length1;
			guint _tmp3_;
			_tmp2_ = self->priv->scores;
			_tmp2__length1 = self->priv->scores_length1;
			_tmp3_ = _tmp2_[PLAYER_HUMAN];
			_tmp2_[PLAYER_HUMAN] = _tmp3_ + 1;
		} else {
			g_assert_not_reached ();
		}
	}
	scorebox_update (self);
}

void
scorebox_win (Scorebox* self,
              Player player)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores;
	_tmp0__length1 = self->priv->scores_length1;
	_tmp1_ = _tmp0_[player];
	_tmp0_[player] = _tmp1_ + 1;
	self->priv->last_winner = player;
	scorebox_update (self);
}

void
scorebox_unwin (Scorebox* self)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores;
	_tmp0__length1 = self->priv->scores_length1;
	_tmp1_ = _tmp0_[self->priv->last_winner];
	_tmp0_[self->priv->last_winner] = _tmp1_ - 1;
	self->priv->last_winner = PLAYER_NOBODY;
	scorebox_update (self);
}

gboolean
scorebox_is_first_game (Scorebox* self)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	guint _tmp1_;
	guint* _tmp2_;
	gint _tmp2__length1;
	guint _tmp3_;
	guint* _tmp4_;
	gint _tmp4__length1;
	guint _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->scores;
	_tmp0__length1 = self->priv->scores_length1;
	_tmp1_ = _tmp0_[PLAYER_HUMAN];
	_tmp2_ = self->priv->scores;
	_tmp2__length1 = self->priv->scores_length1;
	_tmp3_ = _tmp2_[PLAYER_OPPONENT];
	_tmp4_ = self->priv->scores;
	_tmp4__length1 = self->priv->scores_length1;
	_tmp5_ = _tmp4_[PLAYER_NOBODY];
	result = ((_tmp1_ + _tmp3_) + _tmp5_) == ((guint) 0);
	return result;
}

static ThemeManager*
scorebox_get_theme_manager (Scorebox* self)
{
	ThemeManager* result;
	ThemeManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_manager;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scorebox_set_theme_manager (Scorebox* self,
                            ThemeManager* value)
{
	ThemeManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_theme_manager);
	self->priv->_theme_manager = _tmp0_;
}

static void
_scorebox_update_theme_manager_theme_changed (ThemeManager* _sender,
                                              gpointer self)
{
	scorebox_update ((Scorebox*) self);
}

static GObject *
scorebox_constructor (GType type,
                      guint n_construct_properties,
                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Scorebox * self;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkLabel* _tmp5_;
	GtkGrid* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkGrid* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkGrid* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkGrid* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* label_name_end = NULL;
	GtkLabel* _tmp21_;
	GtkGrid* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkBox* _tmp30_;
	GtkGrid* _tmp31_;
	ThemeManager* _tmp32_;
	parent_class = G_OBJECT_CLASS (scorebox_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOX, Scorebox);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	_tmp1_ = grid;
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	_tmp2_ = grid;
	gtk_grid_set_row_spacing (_tmp2_, 2);
	_tmp3_ = grid;
	gtk_grid_set_column_spacing (_tmp3_, 6);
	_tmp4_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 10);
	_tmp5_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->label_name_top);
	self->priv->label_name_top = _tmp5_;
	_tmp6_ = grid;
	_tmp7_ = self->priv->label_name_top;
	gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	_tmp8_ = self->priv->label_name_top;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->label_score_top);
	self->priv->label_score_top = _tmp9_;
	_tmp10_ = grid;
	_tmp11_ = self->priv->label_score_top;
	gtk_grid_attach (_tmp10_, (GtkWidget*) _tmp11_, 1, 0, 1, 1);
	_tmp12_ = self->priv->label_score_top;
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_END);
	_tmp13_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->label_name_mid);
	self->priv->label_name_mid = _tmp13_;
	_tmp14_ = grid;
	_tmp15_ = self->priv->label_name_mid;
	gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 0, 1, 1, 1);
	_tmp16_ = self->priv->label_name_mid;
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	_tmp17_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->label_score_mid);
	self->priv->label_score_mid = _tmp17_;
	_tmp18_ = grid;
	_tmp19_ = self->priv->label_score_mid;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 1, 1, 1, 1);
	_tmp20_ = self->priv->label_score_mid;
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_END);
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("Drawn:"));
	g_object_ref_sink (_tmp21_);
	label_name_end = _tmp21_;
	_tmp22_ = grid;
	_tmp23_ = label_name_end;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 2, 1, 1);
	_tmp24_ = label_name_end;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
	_tmp25_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->label_score_end);
	self->priv->label_score_end = _tmp25_;
	_tmp26_ = grid;
	_tmp27_ = self->priv->label_score_end;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 1, 2, 1, 1);
	_tmp28_ = self->priv->label_score_end;
	gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_END);
	_tmp29_ = grid;
	gtk_widget_show_all ((GtkWidget*) _tmp29_);
	_tmp30_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp31_ = grid;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
	_tmp32_ = self->priv->_theme_manager;
	g_signal_connect_object (_tmp32_, "theme-changed", (GCallback) _scorebox_update_theme_manager_theme_changed, self, 0);
	_g_object_unref0 (label_name_end);
	_g_object_unref0 (grid);
	return obj;
}

static void
scorebox_class_init (ScoreboxClass * klass,
                     gpointer klass_data)
{
	scorebox_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Scorebox_private_offset);
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) scorebox_real_delete_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_scorebox_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scorebox_set_property;
	G_OBJECT_CLASS (klass)->constructor = scorebox_constructor;
	G_OBJECT_CLASS (klass)->finalize = scorebox_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCOREBOX_THEME_MANAGER_PROPERTY, scorebox_properties[SCOREBOX_THEME_MANAGER_PROPERTY] = g_param_spec_object ("theme-manager", "theme-manager", "theme-manager", TYPE_THEME_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
scorebox_instance_init (Scorebox * self,
                        gpointer klass)
{
	guint* _tmp0_;
	self->priv = scorebox_get_instance_private (self);
	self->priv->one_player_game = FALSE;
	self->priv->last_winner = PLAYER_NOBODY;
	_tmp0_ = g_new0 (guint, 3);
	_tmp0_[0] = (guint) 0;
	_tmp0_[1] = (guint) 0;
	_tmp0_[2] = (guint) 0;
	self->priv->scores = _tmp0_;
	self->priv->scores_length1 = 3;
	self->priv->_scores_size_ = self->priv->scores_length1;
}

static void
scorebox_finalize (GObject * obj)
{
	Scorebox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOX, Scorebox);
	_g_object_unref0 (self->priv->_theme_manager);
	_g_object_unref0 (self->priv->label_name_top);
	_g_object_unref0 (self->priv->label_score_top);
	_g_object_unref0 (self->priv->label_name_mid);
	_g_object_unref0 (self->priv->label_score_mid);
	_g_object_unref0 (self->priv->label_score_end);
	self->priv->scores = (g_free (self->priv->scores), NULL);
	G_OBJECT_CLASS (scorebox_parent_class)->finalize (obj);
}

static GType
scorebox_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScoreboxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scorebox_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scorebox), 0, (GInstanceInitFunc) scorebox_instance_init, NULL };
	GType scorebox_type_id;
	scorebox_type_id = g_type_register_static (gtk_dialog_get_type (), "Scorebox", &g_define_type_info, 0);
	Scorebox_private_offset = g_type_add_instance_private (scorebox_type_id, sizeof (ScoreboxPrivate));
	return scorebox_type_id;
}

GType
scorebox_get_type (void)
{
	static volatile gsize scorebox_type_id__once = 0;
	if (g_once_init_enter (&scorebox_type_id__once)) {
		GType scorebox_type_id;
		scorebox_type_id = scorebox_get_type_once ();
		g_once_init_leave (&scorebox_type_id__once, scorebox_type_id);
	}
	return scorebox_type_id__once;
}

static void
_vala_scorebox_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Scorebox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCOREBOX, Scorebox);
	switch (property_id) {
		case SCOREBOX_THEME_MANAGER_PROPERTY:
		g_value_set_object (value, scorebox_get_theme_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scorebox_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Scorebox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCOREBOX, Scorebox);
	switch (property_id) {
		case SCOREBOX_THEME_MANAGER_PROPERTY:
		scorebox_set_theme_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

