/* four-in-a-row.c generated by valac 0.56.18, the Vala compiler
 * generated from four-in-a-row.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Four-in-a-row.

   Copyright © 2018 Jacob Humphrey
   Copyright © 2019 Arnaud Bonatti

   GNOME Four-in-a-row is free software: you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Four-in-a-row is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Four-in-a-row.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gsound.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define FOUR_IN_AROW_PROGRAM_NAME _ ("Four-in-a-row")
#define FOUR_IN_AROW_SPEED_BLINK ((guint) 150)
#define FOUR_IN_AROW_SPEED_MOVE ((guint) 35)
#define FOUR_IN_AROW_SPEED_DROP ((guint) 20)
#define FOUR_IN_AROW_COMPUTER_INITIAL_DELAY ((guint) 1200)
#define FOUR_IN_AROW_COMPUTER_MOVE_DELAY ((guint) 600)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FOUR_IN_AROW (four_in_arow_get_type ())
#define FOUR_IN_AROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOUR_IN_AROW, FourInARow))
#define FOUR_IN_AROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOUR_IN_AROW, FourInARowClass))
#define IS_FOUR_IN_AROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOUR_IN_AROW))
#define IS_FOUR_IN_AROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOUR_IN_AROW))
#define FOUR_IN_AROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOUR_IN_AROW, FourInARowClass))

typedef struct _FourInARow FourInARow;
typedef struct _FourInARowClass FourInARowClass;
typedef struct _FourInARowPrivate FourInARowPrivate;
typedef enum  {
	PLAYER_NOBODY,
	PLAYER_HUMAN,
	PLAYER_OPPONENT
} Player;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;
typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_MEDIUM,
	DIFFICULTY_HARD
} Difficulty;

#define TYPE_DIFFICULTY (difficulty_get_type ())

#define TYPE_SCOREBOX (scorebox_get_type ())
#define SCOREBOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOX, Scorebox))
#define SCOREBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOX, ScoreboxClass))
#define IS_SCOREBOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOX))
#define IS_SCOREBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOX))
#define SCOREBOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOX, ScoreboxClass))

typedef struct _Scorebox Scorebox;
typedef struct _ScoreboxClass ScoreboxClass;

#define TYPE_GAME_BOARD_VIEW (game_board_view_get_type ())
#define GAME_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_BOARD_VIEW, GameBoardView))
#define GAME_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_BOARD_VIEW, GameBoardViewClass))
#define IS_GAME_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_BOARD_VIEW))
#define IS_GAME_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_BOARD_VIEW))
#define GAME_BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_BOARD_VIEW, GameBoardViewClass))

typedef struct _GameBoardView GameBoardView;
typedef struct _GameBoardViewClass GameBoardViewClass;

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_NEW_GAME_SCREEN (new_game_screen_get_type ())
#define NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreen))
#define NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))
#define IS_NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_GAME_SCREEN))
#define IS_NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_GAME_SCREEN))
#define NEW_GAME_SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))

typedef struct _NewGameScreen NewGameScreen;
typedef struct _NewGameScreenClass NewGameScreenClass;

#define TYPE_HISTORY_BUTTON (history_button_get_type ())
#define HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_BUTTON, HistoryButton))
#define HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_BUTTON, HistoryButtonClass))
#define IS_HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_BUTTON))
#define IS_HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_BUTTON))
#define HISTORY_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_BUTTON, HistoryButtonClass))

typedef struct _HistoryButton HistoryButton;
typedef struct _HistoryButtonClass HistoryButtonClass;

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;
typedef enum  {
	FOUR_IN_AROW_SOUND_CONTEXT_STATE_INITIAL,
	FOUR_IN_AROW_SOUND_CONTEXT_STATE_WORKING,
	FOUR_IN_AROW_SOUND_CONTEXT_STATE_ERRORED
} FourInARowSoundContextState;

#define FOUR_IN_AROW_TYPE_SOUND_CONTEXT_STATE (four_in_arow_sound_context_state_get_type ())
enum  {
	FOUR_IN_AROW_0_PROPERTY,
	FOUR_IN_AROW_KEYPRESS_DROP_PROPERTY,
	FOUR_IN_AROW_KEYPRESS_RIGHT_PROPERTY,
	FOUR_IN_AROW_KEYPRESS_LEFT_PROPERTY,
	FOUR_IN_AROW_SOUND_ON_PROPERTY,
	FOUR_IN_AROW_NUM_PROPERTIES
};
static GParamSpec* four_in_arow_properties[FOUR_IN_AROW_NUM_PROPERTIES];
typedef enum  {
	FOUR_IN_AROW_ANIM_ID_NONE,
	FOUR_IN_AROW_ANIM_ID_MOVE,
	FOUR_IN_AROW_ANIM_ID_DROP,
	FOUR_IN_AROW_ANIM_ID_BLINK,
	FOUR_IN_AROW_ANIM_ID_HINT
} FourInARowAnimID;

#define FOUR_IN_AROW_TYPE_ANIM_ID (four_in_arow_anim_id_get_type ())
typedef enum  {
	FOUR_IN_AROW_SOUND_ID_DROP,
	FOUR_IN_AROW_SOUND_ID_I_WIN,
	FOUR_IN_AROW_SOUND_ID_YOU_WIN,
	FOUR_IN_AROW_SOUND_ID_PLAYER_WIN,
	FOUR_IN_AROW_SOUND_ID_DRAWN_GAME,
	FOUR_IN_AROW_SOUND_ID_COLUMN_FULL
} FourInARowSoundID;

#define FOUR_IN_AROW_TYPE_SOUND_ID (four_in_arow_sound_id_get_type ())
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 1
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define FOUR_IN_AROW_TYPE_ANIMATE (four_in_arow_animate_get_type ())
#define FOUR_IN_AROW_ANIMATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOUR_IN_AROW_TYPE_ANIMATE, FourInARowAnimate))
#define FOUR_IN_AROW_ANIMATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOUR_IN_AROW_TYPE_ANIMATE, FourInARowAnimateClass))
#define FOUR_IN_AROW_IS_ANIMATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOUR_IN_AROW_TYPE_ANIMATE))
#define FOUR_IN_AROW_IS_ANIMATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOUR_IN_AROW_TYPE_ANIMATE))
#define FOUR_IN_AROW_ANIMATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOUR_IN_AROW_TYPE_ANIMATE, FourInARowAnimateClass))

typedef struct _FourInARowAnimate FourInARowAnimate;
typedef struct _FourInARowAnimateClass FourInARowAnimateClass;
#define _four_in_arow_animate_unref0(var) ((var == NULL) ? NULL : (var = (four_in_arow_animate_unref (var), NULL)))

#define FOUR_IN_AROW_TYPE_NEXT_MOVE (four_in_arow_next_move_get_type ())
#define FOUR_IN_AROW_NEXT_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOUR_IN_AROW_TYPE_NEXT_MOVE, FourInARowNextMove))
#define FOUR_IN_AROW_NEXT_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOUR_IN_AROW_TYPE_NEXT_MOVE, FourInARowNextMoveClass))
#define FOUR_IN_AROW_IS_NEXT_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOUR_IN_AROW_TYPE_NEXT_MOVE))
#define FOUR_IN_AROW_IS_NEXT_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOUR_IN_AROW_TYPE_NEXT_MOVE))
#define FOUR_IN_AROW_NEXT_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOUR_IN_AROW_TYPE_NEXT_MOVE, FourInARowNextMoveClass))

typedef struct _FourInARowNextMove FourInARowNextMove;
typedef struct _FourInARowNextMoveClass FourInARowNextMoveClass;
#define _four_in_arow_next_move_unref0(var) ((var == NULL) ? NULL : (var = (four_in_arow_next_move_unref (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FourInARowNextMovePrivate FourInARowNextMovePrivate;
typedef struct _FourInARowParamSpecNextMove FourInARowParamSpecNextMove;
typedef struct _FourInARowAnimatePrivate FourInARowAnimatePrivate;
typedef struct _FourInARowParamSpecAnimate FourInARowParamSpecAnimate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FourInARow {
	GtkApplication parent_instance;
	FourInARowPrivate * priv;
};

struct _FourInARowClass {
	GtkApplicationClass parent_class;
};

struct _FourInARowPrivate {
	GSettings* settings;
	gboolean gameover;
	Player player;
	Player winner;
	Player last_first_player;
	Board* game_board;
	gboolean one_player_game;
	Difficulty ai_level;
	guint playgame_timeout;
	Scorebox* scorebox;
	GameBoardView* game_board_view;
	GameWindow* window;
	NewGameScreen* new_game_screen;
	HistoryButton* history_button_1;
	HistoryButton* history_button_2;
	gchar* vstr;
	guint8 moves;
	guint8 column;
	guint8 column_moveto;
	guint8 row;
	guint8 row_dropto;
	guint8* blink_lines;
	gint blink_lines_length1;
	gint blink_lines_length2;
	guint8 blink_line;
	Player blink_t;
	guint8 blink_n;
	gboolean blink_on;
	guint timeout;
	gint _keypress_drop;
	gint _keypress_right;
	gint _keypress_left;
	gboolean _sound_on;
	ThemeManager* theme_manager;
	GSimpleAction* game_type_action;
	GSimpleAction* next_round_action;
	GtkEventControllerKey* window_key_controller;
	GtkEventControllerKey* board_key_controller;
	GSoundContext* sound_context;
	FourInARowSoundContextState sound_context_state;
	GMenu* game_menu;
	GMenu* round_section;
};

struct _FourInARowNextMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FourInARowNextMovePrivate * priv;
};

struct _FourInARowNextMoveClass {
	GTypeClass parent_class;
	void (*finalize) (FourInARowNextMove *self);
};

struct _FourInARowNextMovePrivate {
	guint8 c;
	FourInARow* application;
};

struct _FourInARowParamSpecNextMove {
	GParamSpec parent_instance;
};

struct _FourInARowAnimate {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FourInARowAnimatePrivate * priv;
};

struct _FourInARowAnimateClass {
	GTypeClass parent_class;
	void (*finalize) (FourInARowAnimate *self);
};

struct _FourInARowAnimatePrivate {
	guint8 c;
	FourInARow* application;
	guint8 blink_n_times;
};

struct _FourInARowParamSpecAnimate {
	GParamSpec parent_instance;
};

static gint FourInARow_private_offset;
static gpointer four_in_arow_parent_class = NULL;
static gchar* four_in_arow_level;
static gint four_in_arow_size;
static gint four_in_arow_target;
static FourInARowAnimID four_in_arow_anim;
static FourInARowAnimID four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_NONE;
static gchar* four_in_arow_level = NULL;
static gint four_in_arow_size = 7;
static gint four_in_arow_target = 4;
static gboolean* four_in_arow_sound;
static gboolean* four_in_arow_sound = NULL;
static gint FourInARowNextMove_private_offset;
static gpointer four_in_arow_next_move_parent_class = NULL;
static gint FourInARowAnimate_private_offset;
static gpointer four_in_arow_animate_parent_class = NULL;

VALA_EXTERN GType four_in_arow_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FourInARow, g_object_unref)
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, g_object_unref)
VALA_EXTERN GType difficulty_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scorebox_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scorebox, g_object_unref)
VALA_EXTERN GType game_board_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameBoardView, g_object_unref)
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType new_game_screen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NewGameScreen, g_object_unref)
VALA_EXTERN GType history_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryButton, g_object_unref)
VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
static GType four_in_arow_sound_context_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType four_in_arow_anim_id_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType four_in_arow_sound_id_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void four_in_arow_change_game_type (FourInARow* self,
                                    GSimpleAction* action,
                                    GVariant* gvariant);
static void _four_in_arow_change_game_type_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self);
static inline void four_in_arow_on_next_round (FourInARow* self);
static void _four_in_arow_on_next_round_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static inline void four_in_arow_on_give_up (FourInARow* self);
static void _four_in_arow_on_give_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static inline void four_in_arow_on_game_scores (FourInARow* self);
static void _four_in_arow_on_game_scores_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static inline void four_in_arow_on_game_exit (FourInARow* self);
static void _four_in_arow_on_game_exit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static inline void four_in_arow_on_help_contents (FourInARow* self);
static void _four_in_arow_on_help_contents_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static inline void four_in_arow_on_help_about (FourInARow* self);
static void _four_in_arow_on_help_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static gint four_in_arow_main (gchar** args,
                        gint args_length1);
static FourInARow* four_in_arow_new (void);
static FourInARow* four_in_arow_construct (GType object_type);
static gint four_in_arow_real_handle_local_options (GApplication* base,
                                             GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void four_in_arow_real_startup (GApplication* base);
static inline void four_in_arow_add_actions (FourInARow* self);
static void four_in_arow_create_window (FourInARow* self);
VALA_EXTERN Board* board_new (guint8 size,
                  guint8 line);
VALA_EXTERN Board* board_construct (GType object_type,
                        guint8 size,
                        guint8 line);
static void four_in_arow_clear_board (FourInARow* self);
static inline void four_in_arow_init_sound (FourInARow* self);
VALA_EXTERN ThemeManager* theme_manager_new (guint8 size);
VALA_EXTERN ThemeManager* theme_manager_construct (GType object_type,
                                       guint8 size);
VALA_EXTERN NewGameScreen* new_game_screen_new (void);
VALA_EXTERN NewGameScreen* new_game_screen_construct (GType object_type);
VALA_EXTERN GameBoardView* game_board_view_new (Board* game_board,
                                    ThemeManager* theme_manager);
VALA_EXTERN GameBoardView* game_board_view_construct (GType object_type,
                                          Board* game_board,
                                          ThemeManager* theme_manager);
VALA_EXTERN gchar** theme_manager_get_themes (ThemeManager* self,
                                  gint* result_length1);
static inline void four_in_arow_generate_game_menu (FourInARow* self);
VALA_EXTERN HistoryButton* history_button_new (GMenu** menu,
                                   ThemeManager* theme_manager);
VALA_EXTERN HistoryButton* history_button_construct (GType object_type,
                                         GMenu** menu,
                                         ThemeManager* theme_manager);
VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* _view,
                             GMenu* app_menu,
                             GtkWidget* _game_widget_1,
                             GtkWidget* game_widget_2);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* _view,
                                   GMenu* app_menu,
                                   GtkWidget* _game_widget_1,
                                   GtkWidget* game_widget_2);
VALA_EXTERN Scorebox* scorebox_new (GtkWindow* parent,
                        FourInARow* application,
                        ThemeManager* theme_manager);
VALA_EXTERN Scorebox* scorebox_construct (GType object_type,
                              GtkWindow* parent,
                              FourInARow* application,
                              ThemeManager* theme_manager);
static void four_in_arow_prompt_player (FourInARow* self);
static void _four_in_arow_prompt_player_g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self);
static inline void four_in_arow_monitor_settings (FourInARow* self);
static inline gboolean four_in_arow_column_clicked_cb (FourInARow* self,
                                         guint8 column);
static gboolean _four_in_arow_column_clicked_cb_game_board_view_column_clicked (GameBoardView* _sender,
                                                                         guint8 column,
                                                                         gpointer self);
static inline void four_in_arow_init_keyboard (FourInARow* self);
static inline void four_in_arow_on_game_new (FourInARow* self);
static void _four_in_arow_on_game_new_game_window_play (GameWindow* _sender,
                                                 gpointer self);
static inline void four_in_arow_on_game_undo (FourInARow* self);
static void _four_in_arow_on_game_undo_game_window_undo (GameWindow* _sender,
                                                  gpointer self);
static inline void four_in_arow_on_game_hint (FourInARow* self);
static void _four_in_arow_on_game_hint_game_window_hint (GameWindow* _sender,
                                                  gpointer self);
VALA_EXTERN void game_window_allow_hint (GameWindow* self,
                             gboolean allow);
VALA_EXTERN void game_window_allow_undo (GameWindow* self,
                             gboolean allow);
VALA_EXTERN void four_in_arow_game_reset (FourInARow* self,
                              gboolean reload_settings);
static void __lambda9_ (FourInARow* self);
static void ___lambda9__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda10_ (FourInARow* self);
VALA_EXTERN void new_game_screen_update_sensitivity (NewGameScreen* self,
                                         gboolean new_sensitivity);
static void ___lambda10__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void four_in_arow_real_activate (GApplication* base);
static void four_in_arow_stop_anim (FourInARow* self);
static void four_in_arow_set_gameover (FourInARow* self,
                                gboolean new_value);
VALA_EXTERN void scorebox_new_match (Scorebox* self,
                         gboolean _one_player_game);
static void four_in_arow_switch_players (FourInARow* self);
static void four_in_arow_set_status_message (FourInARow* self,
                                      const gchar* message);
static void four_in_arow_move_cursor (FourInARow* self,
                               guint8 c);
static gboolean four_in_arow_is_player_human (FourInARow* self);
static gboolean ___lambda7_ (FourInARow* self);
VALA_EXTERN guint8 ai_playgame (guint8 size,
                    Difficulty level,
                    const gchar* vstr,
                    guint8 line);
static void four_in_arow_process_move (FourInARow* self,
                                guint8 c);
static gboolean ____lambda7__gsource_func (gpointer self);
static void four_in_arow_blink_winner (FourInARow* self,
                                guint8 n);
VALA_EXTERN gboolean board_is_line_at (Board* self,
                           Player tile,
                           guint8 row,
                           guint8 col,
                           guint8** lines,
                           gint* lines_length1,
                           gint* lines_length2);
static gpointer four_in_arow_animate_ref (gpointer instance);
static void four_in_arow_animate_unref (gpointer instance);
static GParamSpec* four_in_arow_param_spec_animate (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED ;
static void four_in_arow_value_set_animate (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED ;
static void four_in_arow_value_take_animate (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer four_in_arow_value_get_animate (const GValue* value) G_GNUC_UNUSED ;
static GType four_in_arow_animate_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FourInARowAnimate, four_in_arow_animate_unref)
static FourInARowAnimate* four_in_arow_animate_new (guint8 c,
                                             FourInARow* application,
                                             guint8 blink_n_times);
static FourInARowAnimate* four_in_arow_animate_construct (GType object_type,
                                                   guint8 c,
                                                   FourInARow* application,
                                                   guint8 blink_n_times);
static gboolean four_in_arow_animate_exec (FourInARowAnimate* self);
static gboolean _four_in_arow_animate_exec_gsource_func (gpointer self);
static inline void four_in_arow_draw_line (FourInARow* self,
                             guint8 _r1,
                             guint8 _c1,
                             guint8 _r2,
                             guint8 _c2,
                             Player owner);
VALA_EXTERN void board_set (Board* self,
                guint8 x,
                guint8 y,
                Player tile);
VALA_EXTERN void game_board_view_draw_tile (GameBoardView* self,
                                gint row,
                                gint col);
static void four_in_arow_update_round_section (FourInARow* self,
                                        gboolean menu_init);
VALA_EXTERN gboolean scorebox_is_first_game (Scorebox* self);
VALA_EXTERN void history_button_set_player (HistoryButton* self,
                                Player player);
VALA_EXTERN gchar* theme_manager_get_player_win (ThemeManager* self,
                                     Player who);
VALA_EXTERN gchar* theme_manager_get_player_turn (ThemeManager* self,
                                      Player who);
static void four_in_arow_swap_player (FourInARow* self);
static void four_in_arow_process_move3 (FourInARow* self,
                                 guint8 c);
static void four_in_arow_play_sound (FourInARow* self,
                              FourInARowSoundID id);
static inline void four_in_arow_check_game_state (FourInARow* self);
VALA_EXTERN void scorebox_win (Scorebox* self,
                   Player player);
static gboolean ____lambda8_ (FourInARow* self);
static gpointer four_in_arow_next_move_ref (gpointer instance);
static void four_in_arow_next_move_unref (gpointer instance);
static GParamSpec* four_in_arow_param_spec_next_move (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags) G_GNUC_UNUSED ;
static void four_in_arow_value_set_next_move (GValue* value,
                                       gpointer v_object) G_GNUC_UNUSED ;
static void four_in_arow_value_take_next_move (GValue* value,
                                        gpointer v_object) G_GNUC_UNUSED ;
static gpointer four_in_arow_value_get_next_move (const GValue* value) G_GNUC_UNUSED ;
static GType four_in_arow_next_move_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FourInARowNextMove, four_in_arow_next_move_unref)
static FourInARowNextMove* four_in_arow_next_move_new (guint8 c,
                                                FourInARow* application);
static FourInARowNextMove* four_in_arow_next_move_construct (GType object_type,
                                                      guint8 c,
                                                      FourInARow* application);
static gboolean four_in_arow_next_move_exec (FourInARowNextMove* self);
static gboolean _four_in_arow_next_move_exec_gsource_func (gpointer self);
static gboolean _____lambda8__gsource_func (gpointer self);
static void four_in_arow_process_move2 (FourInARow* self,
                                 guint8 c);
VALA_EXTERN guint8 board_first_empty_row (Board* self,
                              guint8 col);
static inline void four_in_arow_drop (FourInARow* self);
static inline void four_in_arow_move (FourInARow* self,
                        guint8 c);
VALA_EXTERN void game_window_set_subtitle (GameWindow* self,
                               const gchar* subtitle);
VALA_EXTERN void board_clear (Board* self);
static inline void four_in_arow_blink_tile (FourInARow* self,
                              guint8 row,
                              guint8 col,
                              Player tile,
                              guint8 n);
VALA_EXTERN Player board_get (Board* self,
                  guint8 x,
                  guint8 y);
VALA_EXTERN void scorebox_unwin (Scorebox* self);
static inline gboolean four_in_arow_on_window_key_pressed (FourInARow* self,
                                             GtkEventControllerKey* _window_key_controller,
                                             guint keyval,
                                             guint keycode,
                                             GdkModifierType state);
static gboolean _four_in_arow_on_window_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                   guint keyval,
                                                                                   guint keycode,
                                                                                   GdkModifierType state,
                                                                                   gpointer self);
static inline gboolean four_in_arow_on_board_key_pressed (FourInARow* self,
                                            GtkEventControllerKey* _board_key_controller,
                                            guint keyval,
                                            guint keycode,
                                            GdkModifierType state);
static gboolean _four_in_arow_on_board_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                  guint keyval,
                                                                                  guint keycode,
                                                                                  GdkModifierType state,
                                                                                  gpointer self);
VALA_EXTERN void game_window_close_hamburger (GameWindow* self);
static inline void four_in_arow_toggle_game_menu (FourInARow* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static gint four_in_arow_get_keypress_left (FourInARow* self);
static gint four_in_arow_get_keypress_right (FourInARow* self);
static gint four_in_arow_get_keypress_drop (FourInARow* self);
static gboolean four_in_arow_get_sound_on (FourInARow* self);
static void four_in_arow_do_play_sound (FourInARowSoundID id,
                                 GSoundContext* sound_context);
VALA_EXTERN void scorebox_give_up (Scorebox* self,
                       Player player);
VALA_EXTERN gboolean game_window_new_game_screen_visible (GameWindow* self);
VALA_EXTERN gboolean game_window_get_is_extra_thin (GameWindow* self);
VALA_EXTERN void four_in_arow_set_keypress_drop (FourInARow* self,
                                     gint value);
VALA_EXTERN void four_in_arow_set_keypress_right (FourInARow* self,
                                      gint value);
VALA_EXTERN void four_in_arow_set_keypress_left (FourInARow* self,
                                     gint value);
VALA_EXTERN void four_in_arow_set_sound_on (FourInARow* self,
                                gboolean value);
static void four_in_arow_next_move_finalize (FourInARowNextMove * obj);
static GType four_in_arow_next_move_get_type_once (void);
static void four_in_arow_animate_finalize (FourInARowAnimate * obj);
static GType four_in_arow_animate_get_type_once (void);
static void four_in_arow_finalize (GObject * obj);
static GType four_in_arow_get_type_once (void);
static void _vala_four_in_arow_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_four_in_arow_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry FOUR_IN_AROW_option_entries[7] = {{"level", 'l', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING, &four_in_arow_level, N_ ("Set the level of the computer’s AI"), N_ ("LEVEL")}, {"mute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn off the sound"), NULL}, {"size", 's', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &four_in_arow_size, N_ ("Size of the board"), N_ ("SIZE")}, {"target", 't', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &four_in_arow_target, N_ ("Length of a winning line"), N_ ("TARGET")}, {"unmute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn on the sound"), NULL}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {0}};
static const GActionEntry FOUR_IN_AROW_app_entries[7] = {{"game-type", NULL, "s", "'dark'", _four_in_arow_change_game_type_gsimple_action_change_state_callback}, {"next-round", _four_in_arow_on_next_round_gsimple_action_activate_callback}, {"give-up", _four_in_arow_on_give_up_gsimple_action_activate_callback}, {"scores", _four_in_arow_on_game_scores_gsimple_action_activate_callback}, {"quit", _four_in_arow_on_game_exit_gsimple_action_activate_callback}, {"help", _four_in_arow_on_help_contents_gsimple_action_activate_callback}, {"about", _four_in_arow_on_help_about_gsimple_action_activate_callback}};

static inline gpointer
four_in_arow_get_instance_private (FourInARow* self)
{
	return G_STRUCT_MEMBER_P (self, FourInARow_private_offset);
}

static GType
four_in_arow_anim_id_get_type_once (void)
{
	static const GEnumValue values[] = {{FOUR_IN_AROW_ANIM_ID_NONE, "FOUR_IN_AROW_ANIM_ID_NONE", "none"}, {FOUR_IN_AROW_ANIM_ID_MOVE, "FOUR_IN_AROW_ANIM_ID_MOVE", "move"}, {FOUR_IN_AROW_ANIM_ID_DROP, "FOUR_IN_AROW_ANIM_ID_DROP", "drop"}, {FOUR_IN_AROW_ANIM_ID_BLINK, "FOUR_IN_AROW_ANIM_ID_BLINK", "blink"}, {FOUR_IN_AROW_ANIM_ID_HINT, "FOUR_IN_AROW_ANIM_ID_HINT", "hint"}, {0, NULL, NULL}};
	GType four_in_arow_anim_id_type_id;
	four_in_arow_anim_id_type_id = g_enum_register_static ("FourInARowAnimID", values);
	return four_in_arow_anim_id_type_id;
}

static GType
four_in_arow_anim_id_get_type (void)
{
	static volatile gsize four_in_arow_anim_id_type_id__once = 0;
	if (g_once_init_enter (&four_in_arow_anim_id_type_id__once)) {
		GType four_in_arow_anim_id_type_id;
		four_in_arow_anim_id_type_id = four_in_arow_anim_id_get_type_once ();
		g_once_init_leave (&four_in_arow_anim_id_type_id__once, four_in_arow_anim_id_type_id);
	}
	return four_in_arow_anim_id_type_id__once;
}

static GType
four_in_arow_sound_id_get_type_once (void)
{
	static const GEnumValue values[] = {{FOUR_IN_AROW_SOUND_ID_DROP, "FOUR_IN_AROW_SOUND_ID_DROP", "drop"}, {FOUR_IN_AROW_SOUND_ID_I_WIN, "FOUR_IN_AROW_SOUND_ID_I_WIN", "i-win"}, {FOUR_IN_AROW_SOUND_ID_YOU_WIN, "FOUR_IN_AROW_SOUND_ID_YOU_WIN", "you-win"}, {FOUR_IN_AROW_SOUND_ID_PLAYER_WIN, "FOUR_IN_AROW_SOUND_ID_PLAYER_WIN", "player-win"}, {FOUR_IN_AROW_SOUND_ID_DRAWN_GAME, "FOUR_IN_AROW_SOUND_ID_DRAWN_GAME", "drawn-game"}, {FOUR_IN_AROW_SOUND_ID_COLUMN_FULL, "FOUR_IN_AROW_SOUND_ID_COLUMN_FULL", "column-full"}, {0, NULL, NULL}};
	GType four_in_arow_sound_id_type_id;
	four_in_arow_sound_id_type_id = g_enum_register_static ("FourInARowSoundID", values);
	return four_in_arow_sound_id_type_id;
}

static GType
four_in_arow_sound_id_get_type (void)
{
	static volatile gsize four_in_arow_sound_id_type_id__once = 0;
	if (g_once_init_enter (&four_in_arow_sound_id_type_id__once)) {
		GType four_in_arow_sound_id_type_id;
		four_in_arow_sound_id_type_id = four_in_arow_sound_id_get_type_once ();
		g_once_init_leave (&four_in_arow_sound_id_type_id__once, four_in_arow_sound_id_type_id);
	}
	return four_in_arow_sound_id_type_id__once;
}

static GType
four_in_arow_sound_context_state_get_type_once (void)
{
	static const GEnumValue values[] = {{FOUR_IN_AROW_SOUND_CONTEXT_STATE_INITIAL, "FOUR_IN_AROW_SOUND_CONTEXT_STATE_INITIAL", "initial"}, {FOUR_IN_AROW_SOUND_CONTEXT_STATE_WORKING, "FOUR_IN_AROW_SOUND_CONTEXT_STATE_WORKING", "working"}, {FOUR_IN_AROW_SOUND_CONTEXT_STATE_ERRORED, "FOUR_IN_AROW_SOUND_CONTEXT_STATE_ERRORED", "errored"}, {0, NULL, NULL}};
	GType four_in_arow_sound_context_state_type_id;
	four_in_arow_sound_context_state_type_id = g_enum_register_static ("FourInARowSoundContextState", values);
	return four_in_arow_sound_context_state_type_id;
}

static GType
four_in_arow_sound_context_state_get_type (void)
{
	static volatile gsize four_in_arow_sound_context_state_type_id__once = 0;
	if (g_once_init_enter (&four_in_arow_sound_context_state_type_id__once)) {
		GType four_in_arow_sound_context_state_type_id;
		four_in_arow_sound_context_state_type_id = four_in_arow_sound_context_state_get_type_once ();
		g_once_init_leave (&four_in_arow_sound_context_state_type_id__once, four_in_arow_sound_context_state_type_id);
	}
	return four_in_arow_sound_context_state_type_id__once;
}

static void
_four_in_arow_change_game_type_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                     GVariant* value,
                                                                     gpointer self)
{
	four_in_arow_change_game_type ((FourInARow*) self, action, value);
}

static void
_four_in_arow_on_next_round_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	four_in_arow_on_next_round ((FourInARow*) self);
}

static void
_four_in_arow_on_give_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	four_in_arow_on_give_up ((FourInARow*) self);
}

static void
_four_in_arow_on_game_scores_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	four_in_arow_on_game_scores ((FourInARow*) self);
}

static void
_four_in_arow_on_game_exit_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	four_in_arow_on_game_exit ((FourInARow*) self);
}

static void
_four_in_arow_on_help_contents_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	four_in_arow_on_help_contents ((FourInARow*) self);
}

static void
_four_in_arow_on_help_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	four_in_arow_on_help_about ((FourInARow*) self);
}

static gint
four_in_arow_main (gchar** args,
                   gint args_length1)
{
	FourInARow* _tmp0_;
	FourInARow* _tmp1_;
	gint _tmp2_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (FOUR_IN_AROW_PROGRAM_NAME);
	g_set_prgname ("org.gnome.Four-in-a-row");
	gtk_window_set_default_icon_name ("org.gnome.Four-in-a-row");
	_tmp0_ = four_in_arow_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return four_in_arow_main (argv, argc);
}

static FourInARow*
four_in_arow_construct (GType object_type)
{
	FourInARow * self = NULL;
	self = (FourInARow*) g_object_new (object_type, "application-id", "org.gnome.Four-in-a-row", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, FOUR_IN_AROW_option_entries);
	return self;
}

static FourInARow*
four_in_arow_new (void)
{
	return four_in_arow_construct (TYPE_FOUR_IN_AROW);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint
four_in_arow_real_handle_local_options (GApplication* base,
                                        GVariantDict* options)
{
	FourInARow * self;
	gint result;
	self = (FourInARow*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%1$s %2$s\n", "four-in-a-row", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (four_in_arow_size < 4) {
		FILE* _tmp1_;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "%s\n", _ ("Size must be at least 4."));
		result = EXIT_FAILURE;
		return result;
	}
	if (four_in_arow_size > 16) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%s\n", _ ("Size must not be more than 16."));
		result = EXIT_FAILURE;
		return result;
	}
	if (four_in_arow_target < 3) {
		FILE* _tmp3_;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "%s\n", _ ("Lines must be at least 3 tiles."));
		result = EXIT_FAILURE;
		return result;
	}
	if (four_in_arow_target > (four_in_arow_size - 1)) {
		FILE* _tmp4_;
		_tmp4_ = stderr;
		fprintf (_tmp4_, "%s\n", _ ("Lines cannot be longer than board height or width."));
		result = EXIT_FAILURE;
		return result;
	}
	if (g_variant_dict_contains (options, "mute")) {
		gboolean _tmp5_;
		gboolean* _tmp6_;
		_tmp5_ = FALSE;
		_tmp6_ = __bool_dup0 (&_tmp5_);
		_g_free0 (four_in_arow_sound);
		four_in_arow_sound = _tmp6_;
	} else {
		if (g_variant_dict_contains (options, "unmute")) {
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp7_ = TRUE;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (four_in_arow_sound);
			four_in_arow_sound = _tmp8_;
		}
	}
	result = -1;
	return result;
}

static void
four_in_arow_real_startup (GApplication* base)
{
	FourInARow * self;
	gboolean _tmp0_ = FALSE;
	gboolean* _tmp1_;
	self = (FourInARow*) base;
	G_APPLICATION_CLASS (four_in_arow_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp1_ = four_in_arow_sound;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = four_in_arow_level;
		_tmp0_ = _tmp2_ != NULL;
	}
	if (_tmp0_) {
		GSettings* _tmp3_;
		gboolean* _tmp4_;
		const gchar* _tmp7_;
		GSettings* _tmp16_;
		_tmp3_ = self->priv->settings;
		g_settings_delay (_tmp3_);
		_tmp4_ = four_in_arow_sound;
		if (_tmp4_ != NULL) {
			GSettings* _tmp5_;
			gboolean* _tmp6_;
			_tmp5_ = self->priv->settings;
			_tmp6_ = four_in_arow_sound;
			g_settings_set_boolean (_tmp5_, "sound", (gboolean) (*_tmp6_));
		}
		_tmp7_ = four_in_arow_level;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GQuark _tmp11_ = 0U;
			static GQuark _tmp10_label0 = 0;
			static GQuark _tmp10_label1 = 0;
			static GQuark _tmp10_label2 = 0;
			static GQuark _tmp10_label3 = 0;
			static GQuark _tmp10_label4 = 0;
			static GQuark _tmp10_label5 = 0;
			static GQuark _tmp10_label6 = 0;
			static GQuark _tmp10_label7 = 0;
			static GQuark _tmp10_label8 = 0;
			_tmp8_ = four_in_arow_level;
			_tmp9_ = (const gchar*) _tmp8_;
			_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
			if (((_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("1")))) || (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("easy"))))) || (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("one"))))) {
				switch (0) {
					default:
					{
						GSettings* _tmp12_;
						_tmp12_ = self->priv->settings;
						g_settings_set_int (_tmp12_, "opponent", 1);
						break;
					}
				}
			} else if (((_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("2")))) || (_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("medium"))))) || (_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("two"))))) {
				switch (0) {
					default:
					{
						GSettings* _tmp13_;
						_tmp13_ = self->priv->settings;
						g_settings_set_int (_tmp13_, "opponent", 2);
						break;
					}
				}
			} else if (((_tmp11_ == ((0 != _tmp10_label6) ? _tmp10_label6 : (_tmp10_label6 = g_quark_from_static_string ("3")))) || (_tmp11_ == ((0 != _tmp10_label7) ? _tmp10_label7 : (_tmp10_label7 = g_quark_from_static_string ("hard"))))) || (_tmp11_ == ((0 != _tmp10_label8) ? _tmp10_label8 : (_tmp10_label8 = g_quark_from_static_string ("three"))))) {
				switch (0) {
					default:
					{
						GSettings* _tmp14_;
						_tmp14_ = self->priv->settings;
						g_settings_set_int (_tmp14_, "opponent", 3);
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						FILE* _tmp15_;
						_tmp15_ = stderr;
						fprintf (_tmp15_, "%s\n", _ ("Level should be 1 (easy), 2 (medium) or 3 (hard). Settings unchanged."));
						break;
					}
				}
			}
		}
		_tmp16_ = self->priv->settings;
		g_settings_apply (_tmp16_);
	}
	four_in_arow_add_actions (self);
}

static void
_four_in_arow_prompt_player_g_settings_changed (GSettings* _sender,
                                                const gchar* key,
                                                gpointer self)
{
	four_in_arow_prompt_player ((FourInARow*) self);
}

static gboolean
_four_in_arow_column_clicked_cb_game_board_view_column_clicked (GameBoardView* _sender,
                                                                guint8 column,
                                                                gpointer self)
{
	gboolean result;
	result = four_in_arow_column_clicked_cb ((FourInARow*) self, column);
	return result;
}

static void
_four_in_arow_on_game_new_game_window_play (GameWindow* _sender,
                                            gpointer self)
{
	four_in_arow_on_game_new ((FourInARow*) self);
}

static void
_four_in_arow_on_game_undo_game_window_undo (GameWindow* _sender,
                                             gpointer self)
{
	four_in_arow_on_game_undo ((FourInARow*) self);
}

static void
_four_in_arow_on_game_hint_game_window_hint (GameWindow* _sender,
                                             gpointer self)
{
	four_in_arow_on_game_hint ((FourInARow*) self);
}

static void
four_in_arow_create_window (FourInARow* self)
{
	Board* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	ThemeManager* _tmp6_;
	GSettings* _tmp7_;
	ThemeManager* _tmp8_;
	NewGameScreen* _tmp9_;
	NewGameScreen* _tmp10_;
	Board* _tmp11_;
	ThemeManager* _tmp12_;
	GameBoardView* _tmp13_;
	GameBoardView* _tmp14_;
	GMenu* app_menu = NULL;
	GMenu* _tmp15_;
	GMenu* appearance_menu = NULL;
	GMenu* _tmp16_;
	gchar** themes = NULL;
	ThemeManager* _tmp17_;
	gint _tmp18_ = 0;
	gchar** _tmp19_;
	gint themes_length1;
	gint _themes_size_;
	GMenu* _tmp30_;
	GMenu* section = NULL;
	GMenu* _tmp31_;
	GMenu* _tmp32_;
	GMenu* _tmp33_;
	GMenu* _tmp34_;
	GMenu* _tmp35_;
	GMenu* _tmp36_;
	GMenu* _tmp37_;
	GMenu* _tmp38_;
	GMenu* _tmp39_;
	GMenu* _tmp40_;
	GMenu* _tmp41_;
	GMenu* _tmp42_;
	GMenu* _tmp43_;
	GMenu* _tmp44_;
	GMenu* _tmp45_;
	ThemeManager* _tmp46_;
	HistoryButton* _tmp47_;
	ThemeManager* _tmp48_;
	HistoryButton* _tmp49_;
	NewGameScreen* _tmp50_;
	GameBoardView* _tmp51_;
	GMenu* _tmp52_;
	HistoryButton* _tmp53_;
	HistoryButton* _tmp54_;
	GameWindow* _tmp55_;
	GameWindow* _tmp56_;
	ThemeManager* _tmp57_;
	Scorebox* _tmp58_;
	GSettings* _tmp59_;
	GameBoardView* _tmp60_;
	GameWindow* _tmp61_;
	GameWindow* _tmp62_;
	GameWindow* _tmp63_;
	GameWindow* _tmp64_;
	GameWindow* _tmp65_;
	GameWindow* _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = board_new ((guint8) four_in_arow_size, (guint8) four_in_arow_target);
	_g_object_unref0 (self->priv->game_board);
	self->priv->game_board = _tmp0_;
	four_in_arow_clear_board (self);
	_tmp1_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp1_, "sound")) {
		four_in_arow_init_sound (self);
	}
	_tmp2_ = self->priv->settings;
	g_settings_bind (_tmp2_, "key-drop", (GObject*) self, "keypress-drop", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp3_ = self->priv->settings;
	g_settings_bind (_tmp3_, "key-right", (GObject*) self, "keypress-right", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp4_ = self->priv->settings;
	g_settings_bind (_tmp4_, "key-left", (GObject*) self, "keypress-left", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp5_ = self->priv->settings;
	g_settings_bind (_tmp5_, "sound", (GObject*) self, "sound-on", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp6_ = theme_manager_new ((guint8) four_in_arow_size);
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp6_;
	_tmp7_ = self->priv->settings;
	_tmp8_ = self->priv->theme_manager;
	g_settings_bind (_tmp7_, "theme-id", (GObject*) _tmp8_, "theme-id", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp9_ = new_game_screen_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp9_;
	_tmp10_ = self->priv->new_game_screen;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->game_board;
	_tmp12_ = self->priv->theme_manager;
	_tmp13_ = game_board_view_new (_tmp11_, _tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->game_board_view);
	self->priv->game_board_view = _tmp13_;
	_tmp14_ = self->priv->game_board_view;
	gtk_widget_show ((GtkWidget*) _tmp14_);
	_tmp15_ = g_menu_new ();
	app_menu = _tmp15_;
	_tmp16_ = g_menu_new ();
	appearance_menu = _tmp16_;
	_tmp17_ = self->priv->theme_manager;
	_tmp19_ = theme_manager_get_themes (_tmp17_, &_tmp18_);
	themes = _tmp19_;
	themes_length1 = _tmp18_;
	_themes_size_ = themes_length1;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gchar** _tmp22_;
				gint _tmp22__length1;
				GMenu* _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				if (!_tmp20_) {
					guint8 _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = themes;
				_tmp22__length1 = themes_length1;
				if (!(((gint) i) < _tmp22__length1)) {
					break;
				}
				_tmp23_ = appearance_menu;
				_tmp24_ = themes;
				_tmp24__length1 = themes_length1;
				_tmp25_ = _tmp24_[i];
				_tmp26_ = g_strdup_printf ("%hhu", i);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat ("app.theme-id(", _tmp27_, ")", NULL);
				_tmp29_ = _tmp28_;
				g_menu_append (_tmp23_, _tmp25_, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp30_ = appearance_menu;
	g_menu_freeze (_tmp30_);
	_tmp31_ = g_menu_new ();
	section = _tmp31_;
	_tmp32_ = section;
	_tmp33_ = appearance_menu;
	g_menu_append_submenu (_tmp32_, _ ("A_ppearance"), (GMenuModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, g_menu_get_type (), GMenu));
	_tmp34_ = section;
	g_menu_append (_tmp34_, _ ("_Sound"), "app.sound");
	_tmp35_ = section;
	g_menu_freeze (_tmp35_);
	_tmp36_ = app_menu;
	_tmp37_ = section;
	g_menu_append_section (_tmp36_, NULL, (GMenuModel*) _tmp37_);
	_tmp38_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp38_;
	_tmp39_ = section;
	g_menu_append (_tmp39_, _ ("_Keyboard Shortcuts"), "win.show-help-overlay");
	_tmp40_ = section;
	g_menu_append (_tmp40_, _ ("_Help"), "app.help");
	_tmp41_ = section;
	g_menu_append (_tmp41_, _ ("_About Four-in-a-row"), "app.about");
	_tmp42_ = section;
	g_menu_freeze (_tmp42_);
	_tmp43_ = app_menu;
	_tmp44_ = section;
	g_menu_append_section (_tmp43_, NULL, (GMenuModel*) _tmp44_);
	_tmp45_ = app_menu;
	g_menu_freeze (_tmp45_);
	four_in_arow_generate_game_menu (self);
	_tmp46_ = self->priv->theme_manager;
	_tmp47_ = history_button_new (&self->priv->game_menu, _tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->history_button_1);
	self->priv->history_button_1 = _tmp47_;
	_tmp48_ = self->priv->theme_manager;
	_tmp49_ = history_button_new (&self->priv->game_menu, _tmp48_);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->history_button_2);
	self->priv->history_button_2 = _tmp49_;
	_tmp50_ = self->priv->new_game_screen;
	_tmp51_ = self->priv->game_board_view;
	_tmp52_ = app_menu;
	_tmp53_ = self->priv->history_button_1;
	_tmp54_ = self->priv->history_button_2;
	_tmp55_ = game_window_new ("/org/gnome/Four-in-a-row/ui/four-in-a-row.css", FOUR_IN_AROW_PROGRAM_NAME, TRUE, GAME_WINDOW_FLAGS_SHOW_START_BUTTON, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp51_, _tmp52_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_menu_button_get_type (), GtkMenuButton), (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_menu_button_get_type (), GtkMenuButton));
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp55_;
	_tmp56_ = self->priv->window;
	_tmp57_ = self->priv->theme_manager;
	_tmp58_ = scorebox_new ((GtkWindow*) _tmp56_, self, _tmp57_);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->scorebox);
	self->priv->scorebox = _tmp58_;
	_tmp59_ = self->priv->settings;
	g_signal_connect_object (_tmp59_, "changed::theme-id", (GCallback) _four_in_arow_prompt_player_g_settings_changed, self, 0);
	four_in_arow_monitor_settings (self);
	_tmp60_ = self->priv->game_board_view;
	g_signal_connect_object (_tmp60_, "column-clicked", (GCallback) _four_in_arow_column_clicked_cb_game_board_view_column_clicked, self, 0);
	four_in_arow_init_keyboard (self);
	_tmp61_ = self->priv->window;
	g_signal_connect_object (_tmp61_, "play", (GCallback) _four_in_arow_on_game_new_game_window_play, self, 0);
	_tmp62_ = self->priv->window;
	g_signal_connect_object (_tmp62_, "undo", (GCallback) _four_in_arow_on_game_undo_game_window_undo, self, 0);
	_tmp63_ = self->priv->window;
	g_signal_connect_object (_tmp63_, "hint", (GCallback) _four_in_arow_on_game_hint_game_window_hint, self, 0);
	_tmp64_ = self->priv->window;
	game_window_allow_hint (_tmp64_, FALSE);
	_tmp65_ = self->priv->window;
	game_window_allow_undo (_tmp65_, FALSE);
	four_in_arow_prompt_player (self);
	four_in_arow_game_reset (self, TRUE);
	_tmp66_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp66_);
	_g_object_unref0 (section);
	themes = (_vala_array_free (themes, themes_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (appearance_menu);
	_g_object_unref0 (app_menu);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
four_in_arow_add_actions (FourInARow* self)
{
	GSettings* _tmp0_;
	GAction* _tmp1_;
	GAction* _tmp2_;
	GSettings* _tmp3_;
	GAction* _tmp4_;
	GAction* _tmp5_;
	GSettings* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	GSettings* _tmp9_;
	GAction* _tmp10_;
	GAction* _tmp11_;
	GSettings* _tmp12_;
	GAction* _tmp13_;
	GAction* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	GAction* _tmp36_;
	GSimpleAction* _tmp37_;
	GAction* _tmp38_;
	GSimpleAction* _tmp39_;
	GSimpleAction* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_create_action (_tmp0_, "sound");
	_tmp2_ = _tmp1_;
	g_action_map_add_action ((GActionMap*) self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_create_action (_tmp3_, "theme-id");
	_tmp5_ = _tmp4_;
	g_action_map_add_action ((GActionMap*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_create_action (_tmp6_, "num-players");
	_tmp8_ = _tmp7_;
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_create_action (_tmp9_, "first-player");
	_tmp11_ = _tmp10_;
	g_action_map_add_action ((GActionMap*) self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = g_settings_create_action (_tmp12_, "opponent");
	_tmp14_ = _tmp13_;
	g_action_map_add_action ((GActionMap*) self, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = g_strdup ("<Primary>n");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.new-game", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Shift><Primary>n");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.start-game", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("<Primary>q");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("<Primary>h");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.hint", _tmp26_);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_strdup ("<Primary>z");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.undo", _tmp29_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = g_strdup ("Escape");
	_tmp31_ = g_new0 (gchar*, 1 + 1);
	_tmp31_[0] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.back", _tmp32_);
	_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = g_strdup ("F10");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.toggle-hamburger", _tmp35_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	g_action_map_add_action_entries ((GActionMap*) self, FOUR_IN_AROW_app_entries, (gint) G_N_ELEMENTS (FOUR_IN_AROW_app_entries), self);
	_tmp36_ = g_action_map_lookup_action ((GActionMap*) self, "game-type");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->game_type_action);
	self->priv->game_type_action = _tmp37_;
	_tmp38_ = g_action_map_lookup_action ((GActionMap*) self, "next-round");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->next_round_action);
	self->priv->next_round_action = _tmp39_;
	_tmp40_ = self->priv->next_round_action;
	g_simple_action_set_enabled (_tmp40_, FALSE);
}

static void
__lambda9_ (FourInARow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	_tmp0_ = self->priv->settings;
	if (g_settings_get_int (_tmp0_, "num-players") == 2) {
		return;
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "first-player");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "human") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GSimpleAction* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		_tmp5_ = self->priv->game_type_action;
		_tmp6_ = g_variant_new_string ("human");
		g_variant_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		g_simple_action_set_state (_tmp5_, _tmp7_);
		_g_variant_unref0 (_tmp7_);
	} else {
		GSimpleAction* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		_tmp8_ = self->priv->game_type_action;
		_tmp9_ = g_variant_new_string ("computer");
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_simple_action_set_state (_tmp8_, _tmp10_);
		_g_variant_unref0 (_tmp10_);
	}
}

static void
___lambda9__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda9_ ((FourInARow*) self);
}

static void
__lambda10_ (FourInARow* self)
{
	gboolean solo = FALSE;
	GSettings* _tmp0_;
	NewGameScreen* _tmp1_;
	_tmp0_ = self->priv->settings;
	solo = g_settings_get_int (_tmp0_, "num-players") == 1;
	_tmp1_ = self->priv->new_game_screen;
	new_game_screen_update_sensitivity (_tmp1_, solo);
	if (solo) {
		NewGameScreen* _tmp2_;
		GSettings* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = self->priv->new_game_screen;
		new_game_screen_update_sensitivity (_tmp2_, TRUE);
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_string (_tmp3_, "first-player");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strcmp0 (_tmp5_, "human") == 0;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			GSimpleAction* _tmp7_;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			_tmp7_ = self->priv->game_type_action;
			_tmp8_ = g_variant_new_string ("human");
			g_variant_ref_sink (_tmp8_);
			_tmp9_ = _tmp8_;
			g_simple_action_set_state (_tmp7_, _tmp9_);
			_g_variant_unref0 (_tmp9_);
			self->priv->last_first_player = PLAYER_HUMAN;
		} else {
			GSimpleAction* _tmp10_;
			GVariant* _tmp11_;
			GVariant* _tmp12_;
			_tmp10_ = self->priv->game_type_action;
			_tmp11_ = g_variant_new_string ("computer");
			g_variant_ref_sink (_tmp11_);
			_tmp12_ = _tmp11_;
			g_simple_action_set_state (_tmp10_, _tmp12_);
			_g_variant_unref0 (_tmp12_);
			self->priv->last_first_player = PLAYER_OPPONENT;
		}
	} else {
		NewGameScreen* _tmp13_;
		GSimpleAction* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		_tmp13_ = self->priv->new_game_screen;
		new_game_screen_update_sensitivity (_tmp13_, FALSE);
		_tmp14_ = self->priv->game_type_action;
		_tmp15_ = g_variant_new_string ("two");
		g_variant_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		g_simple_action_set_state (_tmp14_, _tmp16_);
		_g_variant_unref0 (_tmp16_);
		self->priv->last_first_player = PLAYER_NOBODY;
	}
}

static void
___lambda10__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda10_ ((FourInARow*) self);
}

static inline void
four_in_arow_monitor_settings (FourInARow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gboolean solo = FALSE;
	GSettings* _tmp2_;
	NewGameScreen* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_signal_connect_object (_tmp0_, "changed::first-player", (GCallback) ___lambda9__g_settings_changed, self, 0);
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed::num-players", (GCallback) ___lambda10__g_settings_changed, self, 0);
	_tmp2_ = self->priv->settings;
	solo = g_settings_get_int (_tmp2_, "num-players") == 1;
	_tmp3_ = self->priv->new_game_screen;
	new_game_screen_update_sensitivity (_tmp3_, solo);
	if (solo) {
		NewGameScreen* _tmp4_;
		GSettings* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp4_ = self->priv->new_game_screen;
		new_game_screen_update_sensitivity (_tmp4_, TRUE);
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "first-player");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 (_tmp7_, "human") == 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			GSimpleAction* _tmp9_;
			GVariant* _tmp10_;
			GVariant* _tmp11_;
			_tmp9_ = self->priv->game_type_action;
			_tmp10_ = g_variant_new_string ("human");
			g_variant_ref_sink (_tmp10_);
			_tmp11_ = _tmp10_;
			g_simple_action_set_state (_tmp9_, _tmp11_);
			_g_variant_unref0 (_tmp11_);
			self->priv->last_first_player = PLAYER_HUMAN;
		} else {
			GSimpleAction* _tmp12_;
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			_tmp12_ = self->priv->game_type_action;
			_tmp13_ = g_variant_new_string ("computer");
			g_variant_ref_sink (_tmp13_);
			_tmp14_ = _tmp13_;
			g_simple_action_set_state (_tmp12_, _tmp14_);
			_g_variant_unref0 (_tmp14_);
			self->priv->last_first_player = PLAYER_OPPONENT;
		}
	} else {
		NewGameScreen* _tmp15_;
		GSimpleAction* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		_tmp15_ = self->priv->new_game_screen;
		new_game_screen_update_sensitivity (_tmp15_, FALSE);
		_tmp16_ = self->priv->game_type_action;
		_tmp17_ = g_variant_new_string ("two");
		g_variant_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		g_simple_action_set_state (_tmp16_, _tmp18_);
		_g_variant_unref0 (_tmp18_);
		self->priv->last_first_player = PLAYER_NOBODY;
	}
}

static void
four_in_arow_real_activate (GApplication* base)
{
	FourInARow * self;
	GtkWindow* _tmp0_;
	GameWindow* _tmp1_;
	self = (FourInARow*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		four_in_arow_create_window (self);
	}
	_tmp1_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static gboolean
___lambda7_ (FourInARow* self)
{
	guint8 c = 0U;
	const gchar* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->vstr;
	c = ai_playgame ((guint8) four_in_arow_size, self->priv->ai_level, _tmp0_, (guint8) four_in_arow_target);
	if (((gint) c) >= four_in_arow_size) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	four_in_arow_process_move (self, c);
	self->priv->playgame_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda7_ ((FourInARow*) self);
	return result;
}

void
four_in_arow_game_reset (FourInARow* self,
                         gboolean reload_settings)
{
	GameWindow* _tmp0_;
	GameWindow* _tmp1_;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	GameBoardView* _tmp14_;
	g_return_if_fail (self != NULL);
	four_in_arow_stop_anim (self);
	if (self->priv->playgame_timeout != ((guint) 0)) {
		g_source_remove (self->priv->playgame_timeout);
		self->priv->playgame_timeout = (guint) 0;
	}
	_tmp0_ = self->priv->window;
	game_window_allow_undo (_tmp0_, FALSE);
	_tmp1_ = self->priv->window;
	game_window_allow_hint (_tmp1_, FALSE);
	four_in_arow_set_gameover (self, FALSE);
	if (reload_settings) {
		GSettings* _tmp2_;
		Scorebox* _tmp3_;
		_tmp2_ = self->priv->settings;
		self->priv->one_player_game = g_settings_get_int (_tmp2_, "num-players") == 1;
		_tmp3_ = self->priv->scorebox;
		scorebox_new_match (_tmp3_, self->priv->one_player_game);
		if (self->priv->one_player_game) {
			Player _tmp4_ = 0;
			GSettings* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			const gchar* _tmp9_ = NULL;
			GSettings* _tmp10_;
			GSettings* _tmp11_;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_string (_tmp5_, "first-player");
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "computer") == 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				_tmp4_ = PLAYER_OPPONENT;
			} else {
				_tmp4_ = PLAYER_HUMAN;
			}
			self->priv->player = _tmp4_;
			if (self->priv->player == PLAYER_HUMAN) {
				_tmp9_ = "computer";
			} else {
				_tmp9_ = "human";
			}
			_tmp10_ = self->priv->settings;
			g_settings_set_string (_tmp10_, "first-player", _tmp9_);
			_tmp11_ = self->priv->settings;
			switch (g_settings_get_int (_tmp11_, "opponent")) {
				case 1:
				{
					self->priv->ai_level = DIFFICULTY_EASY;
					break;
				}
				case 2:
				{
					self->priv->ai_level = DIFFICULTY_MEDIUM;
					break;
				}
				case 3:
				{
					self->priv->ai_level = DIFFICULTY_HARD;
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
		} else {
			four_in_arow_switch_players (self);
		}
	} else {
		four_in_arow_switch_players (self);
	}
	self->priv->winner = PLAYER_NOBODY;
	if ((four_in_arow_size % 2) == 0) {
		_tmp13_ = gtk_get_locale_direction () == GTK_TEXT_DIR_LTR;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = (((guint8) four_in_arow_size) / 2) - 1;
	} else {
		_tmp12_ = ((guint8) four_in_arow_size) / 2;
	}
	self->priv->column = (guint8) _tmp12_;
	self->priv->column_moveto = self->priv->column;
	self->priv->row = (guint8) 0;
	self->priv->row_dropto = (guint8) 0;
	four_in_arow_clear_board (self);
	four_in_arow_set_status_message (self, NULL);
	_tmp14_ = self->priv->game_board_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp14_);
	four_in_arow_move_cursor (self, self->priv->column);
	four_in_arow_prompt_player (self);
	if (!four_in_arow_is_player_human (self)) {
		self->priv->playgame_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_COMPUTER_INITIAL_DELAY, ____lambda7__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
four_in_arow_switch_players (FourInARow* self)
{
	g_return_if_fail (self != NULL);
	switch (self->priv->last_first_player) {
		case PLAYER_HUMAN:
		{
			self->priv->player = PLAYER_OPPONENT;
			break;
		}
		case PLAYER_OPPONENT:
		case PLAYER_NOBODY:
		{
			self->priv->player = PLAYER_HUMAN;
			break;
		}
		default:
		break;
	}
	self->priv->last_first_player = self->priv->player;
}

static gboolean
_four_in_arow_animate_exec_gsource_func (gpointer self)
{
	gboolean result;
	result = four_in_arow_animate_exec ((FourInARowAnimate*) self);
	return result;
}

static void
four_in_arow_blink_winner (FourInARow* self,
                           guint8 n)
{
	Board* _tmp0_;
	guint8* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->winner == PLAYER_NOBODY) {
		return;
	}
	self->priv->blink_t = self->priv->winner;
	_tmp0_ = self->priv->game_board;
	_tmp4_ = board_is_line_at (_tmp0_, self->priv->winner, self->priv->row, self->priv->column, &_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->blink_lines = (g_free (self->priv->blink_lines), NULL);
	self->priv->blink_lines = _tmp1_;
	self->priv->blink_lines_length1 = _tmp2_;
	self->priv->blink_lines_length2 = _tmp3_;
	if (_tmp4_) {
		FourInARowAnimate* temp = NULL;
		FourInARowAnimate* _tmp5_;
		FourInARowAnimate* _tmp6_;
		four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_BLINK;
		self->priv->blink_on = FALSE;
		self->priv->blink_n = (guint8) (2 * n);
		self->priv->blink_line = (guint8) 0;
		_tmp5_ = four_in_arow_animate_new ((guint8) 0, self, (guint8) (2 * n));
		temp = _tmp5_;
		_tmp6_ = temp;
		self->priv->timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_BLINK, _four_in_arow_animate_exec_gsource_func, four_in_arow_animate_ref (_tmp6_), four_in_arow_animate_unref);
		while (TRUE) {
			if (!(self->priv->timeout != ((guint) 0))) {
				break;
			}
			gtk_main_iteration ();
		}
		_four_in_arow_animate_unref0 (temp);
	}
}

static inline void
four_in_arow_draw_line (FourInARow* self,
                        guint8 _r1,
                        guint8 _c1,
                        guint8 _r2,
                        guint8 _c2,
                        Player owner)
{
	gboolean done = FALSE;
	gint8 d_row = 0;
	gint8 d_col = 0;
	gint8 r1 = 0;
	gint8 c1 = 0;
	gint8 r2 = 0;
	gint8 c2 = 0;
	g_return_if_fail (self != NULL);
	done = FALSE;
	r1 = (gint8) _r1;
	c1 = (gint8) _c1;
	r2 = (gint8) _r2;
	c2 = (gint8) _c2;
	if (r1 < r2) {
		d_row = (gint8) 1;
	} else {
		if (r1 > r2) {
			d_row = (gint8) -1;
		} else {
			d_row = (gint8) 0;
		}
	}
	if (c1 < c2) {
		d_col = (gint8) 1;
	} else {
		if (c1 > c2) {
			d_col = (gint8) -1;
		} else {
			d_col = (gint8) 0;
		}
	}
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			Board* _tmp2_;
			GameBoardView* _tmp3_;
			if (!_tmp0_) {
				if (!(!done)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			if (r1 == r2) {
				_tmp1_ = c1 == c2;
			} else {
				_tmp1_ = FALSE;
			}
			done = _tmp1_;
			_tmp2_ = self->priv->game_board;
			board_set (_tmp2_, (guint8) r1, (guint8) c1, owner);
			_tmp3_ = self->priv->game_board_view;
			game_board_view_draw_tile (_tmp3_, (gint) r1, (gint) c1);
			if (r1 != r2) {
				r1 += d_row;
			}
			if (c1 != c2) {
				c1 += d_col;
			}
		}
	}
}

static void
four_in_arow_prompt_player (FourInARow* self)
{
	gboolean human = FALSE;
	gboolean _tmp0_ = FALSE;
	GameWindow* _tmp1_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	human = four_in_arow_is_player_human (self);
	if (human) {
		_tmp0_ = !self->priv->gameover;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp1_ = self->priv->window;
	game_window_allow_hint (_tmp1_, _tmp0_);
	four_in_arow_update_round_section (self, FALSE);
	if (self->priv->one_player_game) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		GameWindow* _tmp5_;
		if (human) {
			_tmp3_ = ((gint) self->priv->moves) > 1;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gboolean _tmp4_ = FALSE;
			if (!human) {
				_tmp4_ = self->priv->gameover;
			} else {
				_tmp4_ = FALSE;
			}
			_tmp2_ = _tmp4_;
		}
		_tmp5_ = self->priv->window;
		game_window_allow_undo (_tmp5_, _tmp2_);
	} else {
		GameWindow* _tmp6_;
		_tmp6_ = self->priv->window;
		game_window_allow_undo (_tmp6_, ((gint) self->priv->moves) > 0);
	}
	if (self->priv->gameover) {
		_tmp7_ = self->priv->winner == PLAYER_NOBODY;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		Scorebox* _tmp8_;
		HistoryButton* _tmp9_;
		HistoryButton* _tmp10_;
		_tmp8_ = self->priv->scorebox;
		if (scorebox_is_first_game (_tmp8_)) {
			four_in_arow_set_status_message (self, NULL);
		} else {
			four_in_arow_set_status_message (self, _ ("It’s a draw!"));
		}
		_tmp9_ = self->priv->history_button_1;
		history_button_set_player (_tmp9_, PLAYER_NOBODY);
		_tmp10_ = self->priv->history_button_2;
		history_button_set_player (_tmp10_, PLAYER_NOBODY);
		return;
	}
	if (self->priv->one_player_game) {
		if (self->priv->gameover) {
			HistoryButton* _tmp11_;
			HistoryButton* _tmp12_;
			_tmp11_ = self->priv->history_button_1;
			history_button_set_player (_tmp11_, PLAYER_NOBODY);
			_tmp12_ = self->priv->history_button_2;
			history_button_set_player (_tmp12_, PLAYER_NOBODY);
			if (human) {
				four_in_arow_set_status_message (self, _ ("You win!"));
			} else {
				four_in_arow_set_status_message (self, _ ("I win!"));
			}
		} else {
			if (human) {
				HistoryButton* _tmp13_;
				HistoryButton* _tmp14_;
				_tmp13_ = self->priv->history_button_1;
				history_button_set_player (_tmp13_, PLAYER_HUMAN);
				_tmp14_ = self->priv->history_button_2;
				history_button_set_player (_tmp14_, PLAYER_HUMAN);
				four_in_arow_set_status_message (self, _ ("Your Turn"));
			} else {
				HistoryButton* _tmp15_;
				HistoryButton* _tmp16_;
				_tmp15_ = self->priv->history_button_1;
				history_button_set_player (_tmp15_, PLAYER_OPPONENT);
				_tmp16_ = self->priv->history_button_2;
				history_button_set_player (_tmp16_, PLAYER_OPPONENT);
				four_in_arow_set_status_message (self, _ ("I’m Thinking…"));
			}
		}
	} else {
		gchar* who = NULL;
		const gchar* _tmp26_;
		if (self->priv->gameover) {
			HistoryButton* _tmp17_;
			HistoryButton* _tmp18_;
			ThemeManager* _tmp19_;
			gchar* _tmp20_;
			_tmp17_ = self->priv->history_button_1;
			history_button_set_player (_tmp17_, PLAYER_NOBODY);
			_tmp18_ = self->priv->history_button_2;
			history_button_set_player (_tmp18_, PLAYER_NOBODY);
			_tmp19_ = self->priv->theme_manager;
			_tmp20_ = theme_manager_get_player_win (_tmp19_, self->priv->player);
			_g_free0 (who);
			who = _tmp20_;
		} else {
			Player _tmp21_ = 0;
			Player current_player = 0;
			HistoryButton* _tmp22_;
			HistoryButton* _tmp23_;
			ThemeManager* _tmp24_;
			gchar* _tmp25_;
			if (self->priv->player == PLAYER_HUMAN) {
				_tmp21_ = PLAYER_HUMAN;
			} else {
				_tmp21_ = PLAYER_OPPONENT;
			}
			current_player = _tmp21_;
			_tmp22_ = self->priv->history_button_1;
			history_button_set_player (_tmp22_, current_player);
			_tmp23_ = self->priv->history_button_2;
			history_button_set_player (_tmp23_, current_player);
			_tmp24_ = self->priv->theme_manager;
			_tmp25_ = theme_manager_get_player_turn (_tmp24_, current_player);
			_g_free0 (who);
			who = _tmp25_;
		}
		_tmp26_ = who;
		four_in_arow_set_status_message (self, _ (_tmp26_));
		_g_free0 (who);
	}
}

static void
four_in_arow_swap_player (FourInARow* self)
{
	Player _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	if (self->priv->player == PLAYER_HUMAN) {
		_tmp0_ = PLAYER_OPPONENT;
	} else {
		_tmp0_ = PLAYER_HUMAN;
	}
	self->priv->player = _tmp0_;
	four_in_arow_move_cursor (self, (guint8) 3);
	four_in_arow_prompt_player (self);
}

static gboolean
_four_in_arow_next_move_exec_gsource_func (gpointer self)
{
	gboolean result;
	result = four_in_arow_next_move_exec ((FourInARowNextMove*) self);
	return result;
}

static gboolean
____lambda8_ (FourInARow* self)
{
	guint8 col = 0U;
	const gchar* _tmp0_;
	FourInARowNextMove* nm = NULL;
	FourInARowNextMove* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->vstr;
	col = ai_playgame ((guint8) four_in_arow_size, self->priv->ai_level, _tmp0_, (guint8) four_in_arow_target);
	if (((gint) col) >= four_in_arow_size) {
		four_in_arow_set_gameover (self, TRUE);
	}
	_tmp1_ = four_in_arow_next_move_new (col, self);
	nm = _tmp1_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_DROP, _four_in_arow_next_move_exec_gsource_func, four_in_arow_next_move_ref (nm), four_in_arow_next_move_unref);
	self->priv->playgame_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	_four_in_arow_next_move_unref0 (nm);
	return result;
}

static gboolean
_____lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda8_ ((FourInARow*) self);
	return result;
}

static void
four_in_arow_process_move3 (FourInARow* self,
                            guint8 c)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint8 _tmp4_;
	g_return_if_fail (self != NULL);
	four_in_arow_play_sound (self, FOUR_IN_AROW_SOUND_ID_DROP);
	_tmp0_ = self->priv->vstr;
	_tmp1_ = g_strdup_printf ("%i", c + 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp0_, _tmp2_, NULL);
	_g_free0 (self->priv->vstr);
	self->priv->vstr = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->moves;
	self->priv->moves = _tmp4_ + 1;
	four_in_arow_check_game_state (self);
	if (self->priv->gameover) {
		Scorebox* _tmp5_;
		_tmp5_ = self->priv->scorebox;
		scorebox_win (_tmp5_, self->priv->winner);
		four_in_arow_prompt_player (self);
		if (self->priv->winner != PLAYER_NOBODY) {
			four_in_arow_blink_winner (self, (guint8) 3);
		}
	} else {
		four_in_arow_swap_player (self);
		if (!four_in_arow_is_player_human (self)) {
			self->priv->playgame_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_COMPUTER_MOVE_DELAY, _____lambda8__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}

static inline void
four_in_arow_check_game_state (FourInARow* self)
{
	Board* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_board;
	if (board_is_line_at (_tmp0_, self->priv->player, self->priv->row, self->priv->column, NULL, (gint) 0, (gint) 0)) {
		GameWindow* _tmp2_;
		four_in_arow_set_gameover (self, TRUE);
		self->priv->winner = self->priv->player;
		if (self->priv->one_player_game) {
			FourInARowSoundID _tmp1_ = 0;
			if (four_in_arow_is_player_human (self)) {
				_tmp1_ = FOUR_IN_AROW_SOUND_ID_YOU_WIN;
			} else {
				_tmp1_ = FOUR_IN_AROW_SOUND_ID_I_WIN;
			}
			four_in_arow_play_sound (self, _tmp1_);
		} else {
			four_in_arow_play_sound (self, FOUR_IN_AROW_SOUND_ID_PLAYER_WIN);
		}
		_tmp2_ = self->priv->window;
		game_window_allow_hint (_tmp2_, FALSE);
	} else {
		if (((gint) self->priv->moves) == ((four_in_arow_size - 1) * four_in_arow_size)) {
			four_in_arow_set_gameover (self, TRUE);
			self->priv->winner = PLAYER_NOBODY;
			four_in_arow_play_sound (self, FOUR_IN_AROW_SOUND_ID_DRAWN_GAME);
		}
	}
}

static gboolean
four_in_arow_is_player_human (FourInARow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->one_player_game) {
		result = self->priv->player == PLAYER_HUMAN;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

static void
four_in_arow_process_move2 (FourInARow* self,
                            guint8 c)
{
	guint8 r = 0U;
	Board* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_board;
	r = board_first_empty_row (_tmp0_, c);
	if (((gint) r) != 0) {
		FourInARowAnimate* temp = NULL;
		FourInARowAnimate* _tmp1_;
		FourInARowAnimate* _tmp2_;
		self->priv->row = (guint8) 0;
		self->priv->row_dropto = r;
		four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_DROP;
		_tmp1_ = four_in_arow_animate_new (c, self, (guint8) 0);
		temp = _tmp1_;
		_tmp2_ = temp;
		self->priv->timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_DROP, _four_in_arow_animate_exec_gsource_func, four_in_arow_animate_ref (_tmp2_), four_in_arow_animate_unref);
		_four_in_arow_animate_unref0 (temp);
	} else {
		four_in_arow_play_sound (self, FOUR_IN_AROW_SOUND_ID_COLUMN_FULL);
	}
}

static void
four_in_arow_process_move (FourInARow* self,
                           guint8 c)
{
	FourInARowAnimate* temp = NULL;
	FourInARowAnimate* _tmp2_;
	FourInARowAnimate* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout != ((guint) 0)) {
		FourInARowAnimate* temp = NULL;
		FourInARowAnimate* _tmp0_;
		FourInARowAnimate* _tmp1_;
		_tmp0_ = four_in_arow_animate_new (c, self, (guint8) 0);
		temp = _tmp0_;
		_tmp1_ = temp;
		g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_DROP, _four_in_arow_animate_exec_gsource_func, four_in_arow_animate_ref (_tmp1_), four_in_arow_animate_unref);
		_four_in_arow_animate_unref0 (temp);
		return;
	}
	self->priv->column_moveto = c;
	four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_MOVE;
	_tmp2_ = four_in_arow_animate_new (c, self, (guint8) 0);
	temp = _tmp2_;
	_tmp3_ = temp;
	self->priv->timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_DROP, _four_in_arow_animate_exec_gsource_func, four_in_arow_animate_ref (_tmp3_), four_in_arow_animate_unref);
	_four_in_arow_animate_unref0 (temp);
}

static inline void
four_in_arow_drop (FourInARow* self)
{
	Player _tmp0_ = 0;
	Player tile = 0;
	Board* _tmp1_;
	GameBoardView* _tmp2_;
	guint8 _tmp3_;
	Board* _tmp4_;
	GameBoardView* _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->player == PLAYER_HUMAN) {
		_tmp0_ = PLAYER_HUMAN;
	} else {
		_tmp0_ = PLAYER_OPPONENT;
	}
	tile = _tmp0_;
	_tmp1_ = self->priv->game_board;
	board_set (_tmp1_, self->priv->row, self->priv->column, PLAYER_NOBODY);
	_tmp2_ = self->priv->game_board_view;
	game_board_view_draw_tile (_tmp2_, (gint) self->priv->row, (gint) self->priv->column);
	_tmp3_ = self->priv->row;
	self->priv->row = _tmp3_ + 1;
	_tmp4_ = self->priv->game_board;
	board_set (_tmp4_, self->priv->row, self->priv->column, tile);
	_tmp5_ = self->priv->game_board_view;
	game_board_view_draw_tile (_tmp5_, (gint) self->priv->row, (gint) self->priv->column);
}

static inline void
four_in_arow_move (FourInARow* self,
                   guint8 c)
{
	Board* _tmp0_;
	GameBoardView* _tmp1_;
	Player _tmp2_ = 0;
	Board* _tmp3_;
	GameBoardView* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_board;
	board_set (_tmp0_, (guint8) 0, self->priv->column, PLAYER_NOBODY);
	_tmp1_ = self->priv->game_board_view;
	game_board_view_draw_tile (_tmp1_, 0, (gint) self->priv->column);
	self->priv->column = c;
	if (self->priv->player == PLAYER_HUMAN) {
		_tmp2_ = PLAYER_HUMAN;
	} else {
		_tmp2_ = PLAYER_OPPONENT;
	}
	_tmp3_ = self->priv->game_board;
	board_set (_tmp3_, (guint8) 0, c, _tmp2_);
	_tmp4_ = self->priv->game_board_view;
	game_board_view_draw_tile (_tmp4_, 0, (gint) c);
}

static void
four_in_arow_move_cursor (FourInARow* self,
                          guint8 c)
{
	g_return_if_fail (self != NULL);
	four_in_arow_move (self, c);
	self->priv->column_moveto = c;
	self->priv->column = self->priv->column_moveto;
	self->priv->row_dropto = (guint8) 0;
	self->priv->row = self->priv->row_dropto;
}

static void
four_in_arow_set_status_message (FourInARow* self,
                                 const gchar* message)
{
	GameWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_set_subtitle (_tmp0_, message);
}

static void
four_in_arow_stop_anim (FourInARow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout == ((guint) 0)) {
		return;
	}
	four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_NONE;
	g_source_remove (self->priv->timeout);
	self->priv->timeout = (guint) 0;
}

static void
four_in_arow_clear_board (FourInARow* self)
{
	Board* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_board;
	board_clear (_tmp0_);
	self->priv->moves = (guint8) 0;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->vstr);
	self->priv->vstr = _tmp1_;
}

static inline void
four_in_arow_blink_tile (FourInARow* self,
                         guint8 row,
                         guint8 col,
                         Player tile,
                         guint8 n)
{
	guint8* _tmp0_;
	FourInARowAnimate* temp = NULL;
	FourInARowAnimate* _tmp1_;
	FourInARowAnimate* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout != ((guint) 0)) {
		return;
	}
	_tmp0_ = g_new0 (guint8, 1 * 4);
	_tmp0_[0] = row;
	_tmp0_[1] = col;
	_tmp0_[2] = row;
	_tmp0_[3] = col;
	self->priv->blink_lines = (g_free (self->priv->blink_lines), NULL);
	self->priv->blink_lines = _tmp0_;
	self->priv->blink_lines_length1 = 1;
	self->priv->blink_lines_length2 = 4;
	self->priv->blink_line = (guint8) 0;
	self->priv->blink_t = tile;
	self->priv->blink_n = (guint8) (2 * n);
	self->priv->blink_on = FALSE;
	four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_BLINK;
	_tmp1_ = four_in_arow_animate_new ((guint8) 0, self, (guint8) (2 * n));
	temp = _tmp1_;
	_tmp2_ = temp;
	self->priv->timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_BLINK, _four_in_arow_animate_exec_gsource_func, four_in_arow_animate_ref (_tmp2_), four_in_arow_animate_unref);
	_four_in_arow_animate_unref0 (temp);
}

static inline void
four_in_arow_on_game_new (FourInARow* self)
{
	g_return_if_fail (self != NULL);
	four_in_arow_stop_anim (self);
	four_in_arow_game_reset (self, TRUE);
}

static inline void
four_in_arow_on_game_hint (FourInARow* self)
{
	GameWindow* _tmp0_;
	GameWindow* _tmp1_;
	guint8 c = 0U;
	const gchar* _tmp2_;
	FourInARowAnimate* temp = NULL;
	FourInARowAnimate* _tmp3_;
	FourInARowAnimate* _tmp4_;
	Board* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout != ((guint) 0)) {
		return;
	}
	if (self->priv->gameover) {
		return;
	}
	_tmp0_ = self->priv->window;
	game_window_allow_hint (_tmp0_, FALSE);
	_tmp1_ = self->priv->window;
	game_window_allow_undo (_tmp1_, FALSE);
	four_in_arow_set_status_message (self, _ ("I’m Thinking…"));
	_tmp2_ = self->priv->vstr;
	c = ai_playgame ((guint8) four_in_arow_size, DIFFICULTY_HARD, _tmp2_, (guint8) four_in_arow_target);
	if (((gint) c) >= four_in_arow_size) {
		g_assert_not_reached ();
	}
	self->priv->column_moveto = c;
	while (TRUE) {
		if (!(self->priv->timeout != ((guint) 0))) {
			break;
		}
		gtk_main_iteration ();
	}
	four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_HINT;
	_tmp3_ = four_in_arow_animate_new ((guint8) 0, self, (guint8) 0);
	temp = _tmp3_;
	_tmp4_ = temp;
	self->priv->timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, FOUR_IN_AROW_SPEED_MOVE, _four_in_arow_animate_exec_gsource_func, four_in_arow_animate_ref (_tmp4_), four_in_arow_animate_unref);
	_tmp5_ = self->priv->game_board;
	four_in_arow_blink_tile (self, (guint8) 0, c, board_get (_tmp5_, (guint8) 0, c), (guint8) 3);
	_tmp6_ = g_strdup_printf (_ ("Hint: Column %d"), c + 1);
	_tmp7_ = _tmp6_;
	four_in_arow_set_status_message (self, _tmp7_);
	_g_free0 (_tmp7_);
	if (((gint) self->priv->moves) <= 0) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		if (((gint) self->priv->moves) == 1) {
			_tmp9_ = four_in_arow_is_player_human (self);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp8_ = _tmp9_;
	}
	if (_tmp8_) {
		GameWindow* _tmp10_;
		_tmp10_ = self->priv->window;
		game_window_allow_undo (_tmp10_, FALSE);
	} else {
		GameWindow* _tmp11_;
		_tmp11_ = self->priv->window;
		game_window_allow_undo (_tmp11_, TRUE);
	}
	_four_in_arow_animate_unref0 (temp);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static inline void
four_in_arow_on_game_undo (FourInARow* self)
{
	guint8 _tmp0_;
	guint8 c = 0U;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint8 _tmp4_;
	guint8 r = 0U;
	Board* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	Board* _tmp9_;
	GameBoardView* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout != ((guint) 0)) {
		return;
	}
	_tmp0_ = self->priv->moves;
	self->priv->moves = _tmp0_ - 1;
	_tmp1_ = self->priv->vstr;
	_tmp2_ = g_strdup_printf ("%c", string_get (_tmp1_, (glong) self->priv->moves));
	_tmp3_ = _tmp2_;
	_tmp4_ = (guint8) (((guint8) atoi (_tmp3_)) - 1);
	_g_free0 (_tmp3_);
	c = _tmp4_;
	_tmp5_ = self->priv->game_board;
	r = (guint8) (board_first_empty_row (_tmp5_, c) + 1);
	_tmp6_ = self->priv->vstr;
	_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) self->priv->moves);
	_g_free0 (self->priv->vstr);
	self->priv->vstr = _tmp7_;
	if (self->priv->gameover) {
		Scorebox* _tmp8_;
		_tmp8_ = self->priv->scorebox;
		scorebox_unwin (_tmp8_);
		four_in_arow_set_gameover (self, FALSE);
		four_in_arow_prompt_player (self);
	} else {
		four_in_arow_swap_player (self);
	}
	four_in_arow_move_cursor (self, c);
	_tmp9_ = self->priv->game_board;
	board_set (_tmp9_, r, c, PLAYER_NOBODY);
	_tmp10_ = self->priv->game_board_view;
	game_board_view_draw_tile (_tmp10_, (gint) r, (gint) c);
	if (self->priv->one_player_game) {
		_tmp12_ = !four_in_arow_is_player_human (self);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = ((gint) self->priv->moves) > 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		guint8 _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		Board* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		Board* _tmp20_;
		GameBoardView* _tmp21_;
		_tmp13_ = self->priv->moves;
		self->priv->moves = _tmp13_ - 1;
		_tmp14_ = self->priv->vstr;
		_tmp15_ = g_strdup_printf ("%c", string_get (_tmp14_, (glong) self->priv->moves));
		_tmp16_ = _tmp15_;
		c = (guint8) (((guint8) atoi (_tmp16_)) - 1);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->game_board;
		r = (guint8) (board_first_empty_row (_tmp17_, c) + 1);
		_tmp18_ = self->priv->vstr;
		_tmp19_ = string_slice (_tmp18_, (glong) 0, (glong) self->priv->moves);
		_g_free0 (self->priv->vstr);
		self->priv->vstr = _tmp19_;
		four_in_arow_swap_player (self);
		four_in_arow_move_cursor (self, c);
		_tmp20_ = self->priv->game_board;
		board_set (_tmp20_, r, c, PLAYER_NOBODY);
		_tmp21_ = self->priv->game_board_view;
		game_board_view_draw_tile (_tmp21_, (gint) r, (gint) c);
	}
}

static void
four_in_arow_change_game_type (FourInARow* self,
                               GSimpleAction* action,
                               GVariant* gvariant)
{
	gchar* type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) gvariant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp6_;
				NewGameScreen* _tmp7_;
				GSettings* _tmp8_;
				_tmp6_ = self->priv->settings;
				g_settings_set_int (_tmp6_, "num-players", 1);
				_tmp7_ = self->priv->new_game_screen;
				new_game_screen_update_sensitivity (_tmp7_, TRUE);
				_tmp8_ = self->priv->settings;
				g_settings_set_string (_tmp8_, "first-player", "human");
				_g_free0 (type);
				return;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("computer")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp9_;
				NewGameScreen* _tmp10_;
				GSettings* _tmp11_;
				_tmp9_ = self->priv->settings;
				g_settings_set_int (_tmp9_, "num-players", 1);
				_tmp10_ = self->priv->new_game_screen;
				new_game_screen_update_sensitivity (_tmp10_, TRUE);
				_tmp11_ = self->priv->settings;
				g_settings_set_string (_tmp11_, "first-player", "computer");
				_g_free0 (type);
				return;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("two")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp12_;
				NewGameScreen* _tmp13_;
				_tmp12_ = self->priv->settings;
				g_settings_set_int (_tmp12_, "num-players", 2);
				_tmp13_ = self->priv->new_game_screen;
				new_game_screen_update_sensitivity (_tmp13_, FALSE);
				_g_free0 (type);
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static void
four_in_arow_set_gameover (FourInARow* self,
                           gboolean new_value)
{
	GSimpleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->gameover = new_value;
	_tmp0_ = self->priv->next_round_action;
	g_simple_action_set_enabled (_tmp0_, new_value);
}

static inline void
four_in_arow_on_game_scores (FourInARow* self)
{
	Scorebox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scorebox;
	gtk_window_present ((GtkWindow*) _tmp0_);
	return;
}

static inline void
four_in_arow_on_game_exit (FourInARow* self)
{
	g_return_if_fail (self != NULL);
	four_in_arow_stop_anim (self);
	g_application_quit ((GApplication*) self);
}

static gboolean
_four_in_arow_on_window_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                          guint keyval,
                                                                          guint keycode,
                                                                          GdkModifierType state,
                                                                          gpointer self)
{
	gboolean result;
	result = four_in_arow_on_window_key_pressed ((FourInARow*) self, _sender, keyval, keycode, state);
	return result;
}

static gboolean
_four_in_arow_on_board_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                         guint keyval,
                                                                         guint keycode,
                                                                         GdkModifierType state,
                                                                         gpointer self)
{
	gboolean result;
	result = four_in_arow_on_board_key_pressed ((FourInARow*) self, _sender, keyval, keycode, state);
	return result;
}

static inline void
four_in_arow_init_keyboard (FourInARow* self)
{
	GameWindow* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	GtkEventControllerKey* _tmp2_;
	GtkEventControllerKey* _tmp3_;
	GameBoardView* _tmp4_;
	GtkEventControllerKey* _tmp5_;
	GtkEventControllerKey* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->window_key_controller);
	self->priv->window_key_controller = _tmp1_;
	_tmp2_ = self->priv->window_key_controller;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp2_, GTK_PHASE_CAPTURE);
	_tmp3_ = self->priv->window_key_controller;
	g_signal_connect_object (_tmp3_, "key-pressed", (GCallback) _four_in_arow_on_window_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp4_ = self->priv->game_board_view;
	_tmp5_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp4_);
	_g_object_unref0 (self->priv->board_key_controller);
	self->priv->board_key_controller = _tmp5_;
	_tmp6_ = self->priv->board_key_controller;
	g_signal_connect_object (_tmp6_, "key-pressed", (GCallback) _four_in_arow_on_board_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static inline gboolean
four_in_arow_on_window_key_pressed (FourInARow* self,
                                    GtkEventControllerKey* _window_key_controller,
                                    guint keyval,
                                    guint keycode,
                                    GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_window_key_controller != NULL, FALSE);
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp2_;
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "F1") == 0) {
		GameWindow* _tmp4_;
		HistoryButton* _tmp5_;
		HistoryButton* _tmp6_;
		_tmp4_ = self->priv->window;
		game_window_close_hamburger (_tmp4_);
		_tmp5_ = self->priv->history_button_1;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
		_tmp6_ = self->priv->history_button_2;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, FALSE);
		if ((state & GDK_CONTROL_MASK) != 0) {
			result = FALSE;
			_g_free0 (name);
			return result;
		}
		if ((state & GDK_SHIFT_MASK) != 0) {
			four_in_arow_on_help_about (self);
			result = TRUE;
			_g_free0 (name);
			return result;
		}
		four_in_arow_on_help_contents (self);
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	_tmp7_ = name;
	if (g_strcmp0 (_tmp7_, "F10") == 0) {
		if ((state & GDK_CONTROL_MASK) != 0) {
			four_in_arow_toggle_game_menu (self);
			result = TRUE;
			_g_free0 (name);
			return result;
		}
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static inline gboolean
four_in_arow_on_board_key_pressed (FourInARow* self,
                                   GtkEventControllerKey* _board_key_controller,
                                   guint keyval,
                                   guint keycode,
                                   GdkModifierType state)
{
	GdkEvent* event = NULL;
	GdkEvent* _tmp0_;
	gboolean is_modifier = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEvent* _tmp2_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* key = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_board_key_controller != NULL, FALSE);
	_tmp0_ = gtk_get_current_event ();
	event = _tmp0_;
	_tmp2_ = event;
	if (_tmp2_ != NULL) {
		GdkEvent* _tmp3_;
		_tmp3_ = event;
		_tmp1_ = ((GdkEvent*) _tmp3_)->type == GDK_KEY_PRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkEvent* _tmp4_;
		_tmp4_ = event;
		is_modifier = ((GdkEventKey*) ((GdkEvent*) _tmp4_))->is_modifier == ((guint) 1);
	} else {
		is_modifier = FALSE;
	}
	_tmp6_ = gdk_keyval_name (keyval);
	_tmp5_ = _tmp6_;
	if (_tmp5_ == NULL) {
		_tmp5_ = "";
	}
	_tmp7_ = g_strdup ((const gchar*) _tmp5_);
	key = _tmp7_;
	_tmp10_ = key;
	if (g_strcmp0 (_tmp10_, "") == 0) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = key;
		_tmp9_ = g_strcmp0 (_tmp11_, "Tab") == 0;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = is_modifier;
	}
	if (_tmp8_) {
		result = FALSE;
		_g_free0 (key);
		__vala_GdkEvent_free0 (event);
		return result;
	}
	if (self->priv->timeout != ((guint) 0)) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		if (!self->priv->gameover) {
			_tmp13_ = !four_in_arow_is_player_human (self);
		} else {
			_tmp13_ = FALSE;
		}
		_tmp12_ = _tmp13_;
	}
	if (_tmp12_) {
		result = TRUE;
		_g_free0 (key);
		__vala_GdkEvent_free0 (event);
		return result;
	}
	if (self->priv->gameover) {
		four_in_arow_blink_winner (self, (guint8) 2);
		result = TRUE;
		_g_free0 (key);
		__vala_GdkEvent_free0 (event);
		return result;
	}
	_tmp15_ = key;
	if (g_strcmp0 (_tmp15_, "Left") == 0) {
		_tmp14_ = TRUE;
	} else {
		gint _tmp16_;
		_tmp16_ = self->priv->_keypress_left;
		_tmp14_ = keyval == ((guint) _tmp16_);
	}
	if (_tmp14_) {
		guint8 _tmp17_;
		if (((gint) self->priv->column) == 0) {
			result = TRUE;
			_g_free0 (key);
			__vala_GdkEvent_free0 (event);
			return result;
		}
		_tmp17_ = self->priv->column_moveto;
		self->priv->column_moveto = _tmp17_ - 1;
		four_in_arow_move_cursor (self, self->priv->column_moveto);
	} else {
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		_tmp19_ = key;
		if (g_strcmp0 (_tmp19_, "Right") == 0) {
			_tmp18_ = TRUE;
		} else {
			gint _tmp20_;
			_tmp20_ = self->priv->_keypress_right;
			_tmp18_ = keyval == ((guint) _tmp20_);
		}
		if (_tmp18_) {
			guint8 _tmp21_;
			if (((gint) self->priv->column) >= (four_in_arow_size - 1)) {
				result = TRUE;
				_g_free0 (key);
				__vala_GdkEvent_free0 (event);
				return result;
			}
			_tmp21_ = self->priv->column_moveto;
			self->priv->column_moveto = _tmp21_ + 1;
			four_in_arow_move_cursor (self, self->priv->column_moveto);
		} else {
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			const gchar* _tmp26_;
			_tmp26_ = key;
			if (g_strcmp0 (_tmp26_, "space") == 0) {
				_tmp25_ = TRUE;
			} else {
				const gchar* _tmp27_;
				_tmp27_ = key;
				_tmp25_ = g_strcmp0 (_tmp27_, "Return") == 0;
			}
			if (_tmp25_) {
				_tmp24_ = TRUE;
			} else {
				const gchar* _tmp28_;
				_tmp28_ = key;
				_tmp24_ = g_strcmp0 (_tmp28_, "KP_Enter") == 0;
			}
			if (_tmp24_) {
				_tmp23_ = TRUE;
			} else {
				const gchar* _tmp29_;
				_tmp29_ = key;
				_tmp23_ = g_strcmp0 (_tmp29_, "Down") == 0;
			}
			if (_tmp23_) {
				_tmp22_ = TRUE;
			} else {
				gint _tmp30_;
				_tmp30_ = self->priv->_keypress_drop;
				_tmp22_ = keyval == ((guint) _tmp30_);
			}
			if (_tmp22_) {
				four_in_arow_process_move (self, self->priv->column);
			} else {
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp36_ = FALSE;
				const gchar* _tmp37_;
				_tmp37_ = key;
				if (g_strcmp0 (_tmp37_, "1") == 0) {
					_tmp36_ = TRUE;
				} else {
					const gchar* _tmp38_;
					_tmp38_ = key;
					_tmp36_ = g_strcmp0 (_tmp38_, "2") == 0;
				}
				if (_tmp36_) {
					_tmp35_ = TRUE;
				} else {
					const gchar* _tmp39_;
					_tmp39_ = key;
					_tmp35_ = g_strcmp0 (_tmp39_, "3") == 0;
				}
				if (_tmp35_) {
					_tmp34_ = TRUE;
				} else {
					const gchar* _tmp40_;
					_tmp40_ = key;
					_tmp34_ = g_strcmp0 (_tmp40_, "4") == 0;
				}
				if (_tmp34_) {
					_tmp33_ = TRUE;
				} else {
					const gchar* _tmp41_;
					_tmp41_ = key;
					_tmp33_ = g_strcmp0 (_tmp41_, "5") == 0;
				}
				if (_tmp33_) {
					_tmp32_ = TRUE;
				} else {
					const gchar* _tmp42_;
					_tmp42_ = key;
					_tmp32_ = g_strcmp0 (_tmp42_, "6") == 0;
				}
				if (_tmp32_) {
					_tmp31_ = TRUE;
				} else {
					const gchar* _tmp43_;
					_tmp43_ = key;
					_tmp31_ = g_strcmp0 (_tmp43_, "7") == 0;
				}
				if (_tmp31_) {
					const gchar* _tmp44_;
					_tmp44_ = key;
					four_in_arow_process_move (self, (guint8) (((guint8) atoi (_tmp44_)) - 1));
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (key);
	__vala_GdkEvent_free0 (event);
	return result;
}

static inline gboolean
four_in_arow_column_clicked_cb (FourInARow* self,
                                guint8 column)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->gameover) {
		_tmp0_ = self->priv->timeout == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		four_in_arow_blink_winner (self, (guint8) 2);
	} else {
		gboolean _tmp1_ = FALSE;
		if (four_in_arow_is_player_human (self)) {
			_tmp1_ = self->priv->timeout == ((guint) 0);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			four_in_arow_process_move (self, column);
		}
	}
	result = TRUE;
	return result;
}

static inline void
four_in_arow_on_help_about (FourInARow* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint artists_length1;
	gint _artists_size_;
	gchar** documenters = NULL;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint documenters_length1;
	gint _documenters_size_;
	gchar* copyright = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GameWindow* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strconcat (_ ("Tim Musson"), " <trmusson@ihug.co.nz>", NULL);
	_tmp1_ = g_strconcat (_ ("David Neary"), " <bolsh@gimp.org>", NULL);
	_tmp2_ = g_strconcat (_ ("Nikhar Agrawal"), " <nikharagrawal2006@gmail.com>", NULL);
	_tmp3_ = g_strconcat (_ ("Jacob Humphrey"), " <jacob.ryan.humphrey@gmail.com>", NULL);
	_tmp4_ = g_strconcat (_ ("Arnaud Bonatti"), " <arnaud.bonatti@gmail.com>", NULL);
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	authors = _tmp5_;
	authors_length1 = 5;
	_authors_size_ = authors_length1;
	_tmp6_ = g_strdup (_ ("Alan Horkan"));
	_tmp7_ = g_strdup (_ ("Anatol Drlicek"));
	_tmp8_ = g_strdup (_ ("Based on the Faenza icon theme by Matthieu James"));
	_tmp9_ = g_new0 (gchar*, 3 + 1);
	_tmp9_[0] = _tmp6_;
	_tmp9_[1] = _tmp7_;
	_tmp9_[2] = _tmp8_;
	artists = _tmp9_;
	artists_length1 = 3;
	_artists_size_ = artists_length1;
	_tmp10_ = g_strdup (_ ("Timothy Musson"));
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	documenters = _tmp11_;
	documenters_length1 = 1;
	_documenters_size_ = documenters_length1;
	_tmp12_ = g_strconcat (_ ("Copyright \xc2\xa9 1999-2008 – Tim Musson and David Neary"), "\n", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, _ ("Copyright \xc2\xa9 2014 – Michael Catanzaro"), NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, _ ("Copyright \xc2\xa9 2018 – Jacob Humphrey"), NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "\n", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2019, (guint) 2020);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	copyright = _tmp25_;
	_tmp26_ = self->priv->window;
	gtk_show_about_dialog ((GtkWindow*) _tmp26_, "name", FOUR_IN_AROW_PROGRAM_NAME, "version", VERSION, "copyright", copyright, "license-type", GTK_LICENSE_GPL_3_0, "comments", _ ("Connect four in a row to win"), "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _ ("translator-credits"), "logo-icon-name", "org.gnome.Four-in-a-row", "website", "https://wiki.gnome.org/Apps/Four-in-a-row", NULL);
	_g_free0 (copyright);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static inline void
four_in_arow_on_help_contents (FourInARow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GameWindow* _tmp0_;
		_tmp0_ = self->priv->window;
		gtk_show_uri_on_window ((GtkWindow*) _tmp0_, "help:four-in-a-row", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("four-in-a-row.vala:1210: Failed to show help: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline void
four_in_arow_init_sound (FourInARow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GSoundContext* _tmp0_ = NULL;
		GSoundContext* _tmp1_;
		GSoundContext* _tmp2_;
		_tmp1_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->sound_context);
		self->priv->sound_context = _tmp2_;
		self->priv->sound_context_state = FOUR_IN_AROW_SOUND_CONTEXT_STATE_WORKING;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("four-in-a-row.vala:1245: %s", _tmp4_);
		self->priv->sound_context_state = FOUR_IN_AROW_SOUND_CONTEXT_STATE_ERRORED;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
four_in_arow_play_sound (FourInARow* self,
                         FourInARowSoundID id)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sound_on;
	if (_tmp0_) {
		if (self->priv->sound_context_state == FOUR_IN_AROW_SOUND_CONTEXT_STATE_INITIAL) {
			four_in_arow_init_sound (self);
		}
		if (self->priv->sound_context_state == FOUR_IN_AROW_SOUND_CONTEXT_STATE_WORKING) {
			GSoundContext* _tmp1_;
			_tmp1_ = self->priv->sound_context;
			four_in_arow_do_play_sound (id, _tmp1_);
		}
	}
}

static void
four_in_arow_do_play_sound (FourInARowSoundID id,
                            GSoundContext* sound_context)
{
	gchar* name = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* path = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (sound_context != NULL);
	switch (id) {
		case FOUR_IN_AROW_SOUND_ID_DROP:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("slide");
			_g_free0 (name);
			name = _tmp0_;
			break;
		}
		case FOUR_IN_AROW_SOUND_ID_I_WIN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("reverse");
			_g_free0 (name);
			name = _tmp1_;
			break;
		}
		case FOUR_IN_AROW_SOUND_ID_YOU_WIN:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("bonus");
			_g_free0 (name);
			name = _tmp2_;
			break;
		}
		case FOUR_IN_AROW_SOUND_ID_PLAYER_WIN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("bonus");
			_g_free0 (name);
			name = _tmp3_;
			break;
		}
		case FOUR_IN_AROW_SOUND_ID_DRAWN_GAME:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("reverse");
			_g_free0 (name);
			name = _tmp4_;
			break;
		}
		case FOUR_IN_AROW_SOUND_ID_COLUMN_FULL:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("bad");
			_g_free0 (name);
			name = _tmp5_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp6_ = name;
	_tmp7_ = g_strconcat (_tmp6_, ".ogg", NULL);
	_g_free0 (name);
	name = _tmp7_;
	_tmp8_ = name;
	_tmp9_ = g_build_filename (SOUND_DIRECTORY, _tmp8_, NULL);
	path = _tmp9_;
	{
		const gchar* _tmp10_;
		_tmp10_ = name;
		gsound_context_play_simple (sound_context, NULL, &_inner_error0_, GSOUND_ATTR_MEDIA_NAME, _tmp10_, GSOUND_ATTR_MEDIA_FILENAME, path, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("four-in-a-row.vala:1283: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
	_g_free0 (name);
}

static inline void
four_in_arow_generate_game_menu (FourInARow* self)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("_Undo last move"), "ui.undo");
	g_menu_append (section, _ ("_Hint"), "ui.hint");
	g_menu_freeze (section);
	_tmp1_ = self->priv->game_menu;
	g_menu_append_section (_tmp1_, NULL, (GMenuModel*) section);
	four_in_arow_update_round_section (self, TRUE);
	_tmp2_ = self->priv->game_menu;
	_tmp3_ = self->priv->round_section;
	g_menu_append_section (_tmp2_, NULL, (GMenuModel*) _tmp3_);
	_g_object_unref0 (section);
}

static void
four_in_arow_update_round_section (FourInARow* self,
                                   gboolean menu_init)
{
	GMenu* _tmp0_;
	gboolean _tmp3_ = FALSE;
	GMenu* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->round_section;
	g_menu_remove_all (_tmp0_);
	if (self->priv->gameover) {
		GMenu* _tmp1_;
		_tmp1_ = self->priv->round_section;
		g_menu_append (_tmp1_, _ ("Next _Round"), "app.next-round");
	} else {
		GMenu* _tmp2_;
		_tmp2_ = self->priv->round_section;
		g_menu_append (_tmp2_, _ ("_Give Up"), "app.give-up");
	}
	if (menu_init) {
		_tmp3_ = TRUE;
	} else {
		Scorebox* _tmp4_;
		_tmp4_ = self->priv->scorebox;
		_tmp3_ = scorebox_is_first_game (_tmp4_);
	}
	if (_tmp3_) {
		return;
	}
	_tmp5_ = self->priv->round_section;
	g_menu_append (_tmp5_, _ ("_Scores"), "app.scores");
}

static inline void
four_in_arow_on_give_up (FourInARow* self)
{
	Scorebox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scorebox;
	scorebox_give_up (_tmp0_, self->priv->player);
	four_in_arow_game_reset (self, FALSE);
}

static inline void
four_in_arow_on_next_round (FourInARow* self)
{
	g_return_if_fail (self != NULL);
	four_in_arow_game_reset (self, FALSE);
}

static inline void
four_in_arow_toggle_game_menu (FourInARow* self)
{
	GameWindow* _tmp0_;
	GameWindow* _tmp1_;
	GameWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (game_window_new_game_screen_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->window;
	game_window_close_hamburger (_tmp1_);
	_tmp2_ = self->priv->window;
	_tmp3_ = game_window_get_is_extra_thin (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		HistoryButton* _tmp5_;
		HistoryButton* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = self->priv->history_button_2;
		_tmp6_ = self->priv->history_button_2;
		_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
		_tmp8_ = _tmp7_;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, !_tmp8_);
	} else {
		HistoryButton* _tmp9_;
		HistoryButton* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp9_ = self->priv->history_button_1;
		_tmp10_ = self->priv->history_button_1;
		_tmp11_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp10_);
		_tmp12_ = _tmp11_;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp9_, !_tmp12_);
	}
}

static gint
four_in_arow_get_keypress_drop (FourInARow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_keypress_drop;
	return result;
}

void
four_in_arow_set_keypress_drop (FourInARow* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_keypress_drop = value;
}

static gint
four_in_arow_get_keypress_right (FourInARow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_keypress_right;
	return result;
}

void
four_in_arow_set_keypress_right (FourInARow* self,
                                 gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_keypress_right = value;
}

static gint
four_in_arow_get_keypress_left (FourInARow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_keypress_left;
	return result;
}

void
four_in_arow_set_keypress_left (FourInARow* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_keypress_left = value;
}

static gboolean
four_in_arow_get_sound_on (FourInARow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sound_on;
	return result;
}

void
four_in_arow_set_sound_on (FourInARow* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_sound_on = value;
}

static inline gpointer
four_in_arow_next_move_get_instance_private (FourInARowNextMove* self)
{
	return G_STRUCT_MEMBER_P (self, FourInARowNextMove_private_offset);
}

static FourInARowNextMove*
four_in_arow_next_move_construct (GType object_type,
                                  guint8 c,
                                  FourInARow* application)
{
	FourInARowNextMove* self = NULL;
	FourInARow* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (FourInARowNextMove*) g_type_create_instance (object_type);
	self->priv->c = c;
	_tmp0_ = _g_object_ref0 (application);
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp0_;
	return self;
}

static FourInARowNextMove*
four_in_arow_next_move_new (guint8 c,
                            FourInARow* application)
{
	return four_in_arow_next_move_construct (FOUR_IN_AROW_TYPE_NEXT_MOVE, c, application);
}

static gboolean
four_in_arow_next_move_exec (FourInARowNextMove* self)
{
	FourInARow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->application;
	four_in_arow_process_move (_tmp0_, self->priv->c);
	result = FALSE;
	return result;
}

static void
four_in_arow_value_next_move_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
four_in_arow_value_next_move_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		four_in_arow_next_move_unref (value->data[0].v_pointer);
	}
}

static void
four_in_arow_value_next_move_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = four_in_arow_next_move_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
four_in_arow_value_next_move_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
four_in_arow_value_next_move_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FourInARowNextMove * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = four_in_arow_next_move_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
four_in_arow_value_next_move_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	FourInARowNextMove ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = four_in_arow_next_move_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
four_in_arow_param_spec_next_move (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	FourInARowParamSpecNextMove* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOUR_IN_AROW_TYPE_NEXT_MOVE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
four_in_arow_value_get_next_move (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOUR_IN_AROW_TYPE_NEXT_MOVE), NULL);
	return value->data[0].v_pointer;
}

static void
four_in_arow_value_set_next_move (GValue* value,
                                  gpointer v_object)
{
	FourInARowNextMove * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOUR_IN_AROW_TYPE_NEXT_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOUR_IN_AROW_TYPE_NEXT_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		four_in_arow_next_move_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		four_in_arow_next_move_unref (old);
	}
}

static void
four_in_arow_value_take_next_move (GValue* value,
                                   gpointer v_object)
{
	FourInARowNextMove * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOUR_IN_AROW_TYPE_NEXT_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOUR_IN_AROW_TYPE_NEXT_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		four_in_arow_next_move_unref (old);
	}
}

static void
four_in_arow_next_move_class_init (FourInARowNextMoveClass * klass,
                                   gpointer klass_data)
{
	four_in_arow_next_move_parent_class = g_type_class_peek_parent (klass);
	((FourInARowNextMoveClass *) klass)->finalize = four_in_arow_next_move_finalize;
	g_type_class_adjust_private_offset (klass, &FourInARowNextMove_private_offset);
}

static void
four_in_arow_next_move_instance_init (FourInARowNextMove * self,
                                      gpointer klass)
{
	self->priv = four_in_arow_next_move_get_instance_private (self);
	self->ref_count = 1;
}

static void
four_in_arow_next_move_finalize (FourInARowNextMove * obj)
{
	FourInARowNextMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOUR_IN_AROW_TYPE_NEXT_MOVE, FourInARowNextMove);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->application);
}

static GType
four_in_arow_next_move_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { four_in_arow_value_next_move_init, four_in_arow_value_next_move_free_value, four_in_arow_value_next_move_copy_value, four_in_arow_value_next_move_peek_pointer, "p", four_in_arow_value_next_move_collect_value, "p", four_in_arow_value_next_move_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FourInARowNextMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) four_in_arow_next_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FourInARowNextMove), 0, (GInstanceInitFunc) four_in_arow_next_move_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType four_in_arow_next_move_type_id;
	four_in_arow_next_move_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FourInARowNextMove", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FourInARowNextMove_private_offset = g_type_add_instance_private (four_in_arow_next_move_type_id, sizeof (FourInARowNextMovePrivate));
	return four_in_arow_next_move_type_id;
}

static GType
four_in_arow_next_move_get_type (void)
{
	static volatile gsize four_in_arow_next_move_type_id__once = 0;
	if (g_once_init_enter (&four_in_arow_next_move_type_id__once)) {
		GType four_in_arow_next_move_type_id;
		four_in_arow_next_move_type_id = four_in_arow_next_move_get_type_once ();
		g_once_init_leave (&four_in_arow_next_move_type_id__once, four_in_arow_next_move_type_id);
	}
	return four_in_arow_next_move_type_id__once;
}

static gpointer
four_in_arow_next_move_ref (gpointer instance)
{
	FourInARowNextMove * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
four_in_arow_next_move_unref (gpointer instance)
{
	FourInARowNextMove * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOUR_IN_AROW_NEXT_MOVE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
four_in_arow_animate_get_instance_private (FourInARowAnimate* self)
{
	return G_STRUCT_MEMBER_P (self, FourInARowAnimate_private_offset);
}

static FourInARowAnimate*
four_in_arow_animate_construct (GType object_type,
                                guint8 c,
                                FourInARow* application,
                                guint8 blink_n_times)
{
	FourInARowAnimate* self = NULL;
	FourInARow* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (FourInARowAnimate*) g_type_create_instance (object_type);
	self->priv->c = c;
	_tmp0_ = _g_object_ref0 (application);
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp0_;
	self->priv->blink_n_times = blink_n_times;
	return self;
}

static FourInARowAnimate*
four_in_arow_animate_new (guint8 c,
                          FourInARow* application,
                          guint8 blink_n_times)
{
	return four_in_arow_animate_construct (FOUR_IN_AROW_TYPE_ANIMATE, c, application, blink_n_times);
}

static gboolean
four_in_arow_animate_exec (FourInARowAnimate* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (four_in_arow_anim) {
		case FOUR_IN_AROW_ANIM_ID_NONE:
		{
			result = FALSE;
			return result;
		}
		case FOUR_IN_AROW_ANIM_ID_HINT:
		case FOUR_IN_AROW_ANIM_ID_MOVE:
		{
			FourInARow* _tmp0_;
			FourInARow* _tmp1_;
			_tmp0_ = self->priv->application;
			_tmp1_ = self->priv->application;
			if (_tmp0_->priv->column < _tmp1_->priv->column_moveto) {
				FourInARow* _tmp2_;
				FourInARow* _tmp3_;
				_tmp2_ = self->priv->application;
				_tmp3_ = self->priv->application;
				four_in_arow_move (_tmp2_, (guint8) (_tmp3_->priv->column + 1));
			} else {
				FourInARow* _tmp4_;
				FourInARow* _tmp5_;
				_tmp4_ = self->priv->application;
				_tmp5_ = self->priv->application;
				if (_tmp4_->priv->column > _tmp5_->priv->column_moveto) {
					FourInARow* _tmp6_;
					FourInARow* _tmp7_;
					_tmp6_ = self->priv->application;
					_tmp7_ = self->priv->application;
					four_in_arow_move (_tmp6_, (guint8) (_tmp7_->priv->column - 1));
				} else {
					FourInARow* _tmp8_;
					_tmp8_ = self->priv->application;
					_tmp8_->priv->timeout = (guint) 0;
					if (four_in_arow_anim == FOUR_IN_AROW_ANIM_ID_MOVE) {
						FourInARow* _tmp9_;
						four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_NONE;
						_tmp9_ = self->priv->application;
						four_in_arow_process_move2 (_tmp9_, self->priv->c);
					} else {
						four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_NONE;
					}
					result = FALSE;
					return result;
				}
			}
			result = TRUE;
			return result;
		}
		case FOUR_IN_AROW_ANIM_ID_DROP:
		{
			FourInARow* _tmp10_;
			FourInARow* _tmp11_;
			_tmp10_ = self->priv->application;
			_tmp11_ = self->priv->application;
			if (_tmp10_->priv->row < _tmp11_->priv->row_dropto) {
				FourInARow* _tmp12_;
				_tmp12_ = self->priv->application;
				four_in_arow_drop (_tmp12_);
			} else {
				FourInARow* _tmp13_;
				FourInARow* _tmp14_;
				four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_NONE;
				_tmp13_ = self->priv->application;
				_tmp13_->priv->timeout = (guint) 0;
				_tmp14_ = self->priv->application;
				four_in_arow_process_move3 (_tmp14_, self->priv->c);
				result = FALSE;
				return result;
			}
			result = TRUE;
			return result;
		}
		case FOUR_IN_AROW_ANIM_ID_BLINK:
		{
			Player _tmp15_ = 0;
			FourInARow* _tmp16_;
			FourInARow* _tmp18_;
			FourInARow* _tmp19_;
			guint8* _tmp20_;
			gint _tmp20__length1;
			gint _tmp20__length2;
			FourInARow* _tmp21_;
			guint8 _tmp22_;
			FourInARow* _tmp23_;
			guint8* _tmp24_;
			gint _tmp24__length1;
			gint _tmp24__length2;
			FourInARow* _tmp25_;
			guint8 _tmp26_;
			FourInARow* _tmp27_;
			guint8* _tmp28_;
			gint _tmp28__length1;
			gint _tmp28__length2;
			FourInARow* _tmp29_;
			guint8 _tmp30_;
			FourInARow* _tmp31_;
			guint8* _tmp32_;
			gint _tmp32__length1;
			gint _tmp32__length2;
			FourInARow* _tmp33_;
			guint8 _tmp34_;
			FourInARow* _tmp35_;
			guint8 _tmp36_;
			gboolean _tmp37_ = FALSE;
			FourInARow* _tmp38_;
			FourInARow* _tmp49_;
			FourInARow* _tmp50_;
			_tmp16_ = self->priv->application;
			if (_tmp16_->priv->blink_on) {
				FourInARow* _tmp17_;
				_tmp17_ = self->priv->application;
				_tmp15_ = _tmp17_->priv->blink_t;
			} else {
				_tmp15_ = PLAYER_NOBODY;
			}
			_tmp18_ = self->priv->application;
			_tmp19_ = self->priv->application;
			_tmp20_ = _tmp19_->priv->blink_lines;
			_tmp20__length1 = _tmp19_->priv->blink_lines_length1;
			_tmp20__length2 = _tmp19_->priv->blink_lines_length2;
			_tmp21_ = self->priv->application;
			_tmp22_ = _tmp20_[(_tmp21_->priv->blink_line * _tmp20__length2) + 0];
			_tmp23_ = self->priv->application;
			_tmp24_ = _tmp23_->priv->blink_lines;
			_tmp24__length1 = _tmp23_->priv->blink_lines_length1;
			_tmp24__length2 = _tmp23_->priv->blink_lines_length2;
			_tmp25_ = self->priv->application;
			_tmp26_ = _tmp24_[(_tmp25_->priv->blink_line * _tmp24__length2) + 1];
			_tmp27_ = self->priv->application;
			_tmp28_ = _tmp27_->priv->blink_lines;
			_tmp28__length1 = _tmp27_->priv->blink_lines_length1;
			_tmp28__length2 = _tmp27_->priv->blink_lines_length2;
			_tmp29_ = self->priv->application;
			_tmp30_ = _tmp28_[(_tmp29_->priv->blink_line * _tmp28__length2) + 2];
			_tmp31_ = self->priv->application;
			_tmp32_ = _tmp31_->priv->blink_lines;
			_tmp32__length1 = _tmp31_->priv->blink_lines_length1;
			_tmp32__length2 = _tmp31_->priv->blink_lines_length2;
			_tmp33_ = self->priv->application;
			_tmp34_ = _tmp32_[(_tmp33_->priv->blink_line * _tmp32__length2) + 3];
			four_in_arow_draw_line (_tmp18_, _tmp22_, _tmp26_, _tmp30_, _tmp34_, _tmp15_);
			_tmp35_ = self->priv->application;
			_tmp36_ = _tmp35_->priv->blink_n;
			_tmp35_->priv->blink_n = _tmp36_ - 1;
			_tmp38_ = self->priv->application;
			if (((gint) _tmp38_->priv->blink_n) == 0) {
				FourInARow* _tmp39_;
				_tmp39_ = self->priv->application;
				_tmp37_ = _tmp39_->priv->blink_on;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				FourInARow* _tmp40_;
				FourInARow* _tmp41_;
				guint8* _tmp42_;
				gint _tmp42__length1;
				gint _tmp42__length2;
				gint _tmp43_;
				_tmp40_ = self->priv->application;
				_tmp41_ = self->priv->application;
				_tmp42_ = _tmp41_->priv->blink_lines;
				_tmp42__length1 = _tmp41_->priv->blink_lines_length1;
				_tmp42__length2 = _tmp41_->priv->blink_lines_length2;
				_tmp43_ = _tmp42__length1;
				if (((gint) _tmp40_->priv->blink_line) >= (_tmp43_ - 1)) {
					FourInARow* _tmp44_;
					four_in_arow_anim = FOUR_IN_AROW_ANIM_ID_NONE;
					_tmp44_ = self->priv->application;
					_tmp44_->priv->timeout = (guint) 0;
					result = FALSE;
					return result;
				} else {
					FourInARow* _tmp45_;
					guint8 _tmp46_;
					FourInARow* _tmp47_;
					FourInARow* _tmp48_;
					_tmp45_ = self->priv->application;
					_tmp46_ = _tmp45_->priv->blink_line;
					_tmp45_->priv->blink_line = _tmp46_ + 1;
					_tmp47_ = self->priv->application;
					_tmp48_ = self->priv->application;
					_tmp48_->priv->blink_n = _tmp48_->priv->blink_n + self->priv->blink_n_times;
				}
			}
			_tmp49_ = self->priv->application;
			_tmp50_ = self->priv->application;
			_tmp49_->priv->blink_on = !_tmp50_->priv->blink_on;
			result = TRUE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
four_in_arow_value_animate_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
four_in_arow_value_animate_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		four_in_arow_animate_unref (value->data[0].v_pointer);
	}
}

static void
four_in_arow_value_animate_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = four_in_arow_animate_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
four_in_arow_value_animate_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
four_in_arow_value_animate_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FourInARowAnimate * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = four_in_arow_animate_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
four_in_arow_value_animate_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	FourInARowAnimate ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = four_in_arow_animate_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
four_in_arow_param_spec_animate (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	FourInARowParamSpecAnimate* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOUR_IN_AROW_TYPE_ANIMATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
four_in_arow_value_get_animate (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOUR_IN_AROW_TYPE_ANIMATE), NULL);
	return value->data[0].v_pointer;
}

static void
four_in_arow_value_set_animate (GValue* value,
                                gpointer v_object)
{
	FourInARowAnimate * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOUR_IN_AROW_TYPE_ANIMATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOUR_IN_AROW_TYPE_ANIMATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		four_in_arow_animate_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		four_in_arow_animate_unref (old);
	}
}

static void
four_in_arow_value_take_animate (GValue* value,
                                 gpointer v_object)
{
	FourInARowAnimate * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOUR_IN_AROW_TYPE_ANIMATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOUR_IN_AROW_TYPE_ANIMATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		four_in_arow_animate_unref (old);
	}
}

static void
four_in_arow_animate_class_init (FourInARowAnimateClass * klass,
                                 gpointer klass_data)
{
	four_in_arow_animate_parent_class = g_type_class_peek_parent (klass);
	((FourInARowAnimateClass *) klass)->finalize = four_in_arow_animate_finalize;
	g_type_class_adjust_private_offset (klass, &FourInARowAnimate_private_offset);
}

static void
four_in_arow_animate_instance_init (FourInARowAnimate * self,
                                    gpointer klass)
{
	self->priv = four_in_arow_animate_get_instance_private (self);
	self->ref_count = 1;
}

static void
four_in_arow_animate_finalize (FourInARowAnimate * obj)
{
	FourInARowAnimate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOUR_IN_AROW_TYPE_ANIMATE, FourInARowAnimate);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->application);
}

static GType
four_in_arow_animate_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { four_in_arow_value_animate_init, four_in_arow_value_animate_free_value, four_in_arow_value_animate_copy_value, four_in_arow_value_animate_peek_pointer, "p", four_in_arow_value_animate_collect_value, "p", four_in_arow_value_animate_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FourInARowAnimateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) four_in_arow_animate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FourInARowAnimate), 0, (GInstanceInitFunc) four_in_arow_animate_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType four_in_arow_animate_type_id;
	four_in_arow_animate_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FourInARowAnimate", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FourInARowAnimate_private_offset = g_type_add_instance_private (four_in_arow_animate_type_id, sizeof (FourInARowAnimatePrivate));
	return four_in_arow_animate_type_id;
}

static GType
four_in_arow_animate_get_type (void)
{
	static volatile gsize four_in_arow_animate_type_id__once = 0;
	if (g_once_init_enter (&four_in_arow_animate_type_id__once)) {
		GType four_in_arow_animate_type_id;
		four_in_arow_animate_type_id = four_in_arow_animate_get_type_once ();
		g_once_init_leave (&four_in_arow_animate_type_id__once, four_in_arow_animate_type_id);
	}
	return four_in_arow_animate_type_id__once;
}

static gpointer
four_in_arow_animate_ref (gpointer instance)
{
	FourInARowAnimate * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
four_in_arow_animate_unref (gpointer instance)
{
	FourInARowAnimate * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOUR_IN_AROW_ANIMATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
four_in_arow_class_init (FourInARowClass * klass,
                         gpointer klass_data)
{
	four_in_arow_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FourInARow_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) four_in_arow_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) four_in_arow_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) four_in_arow_real_activate;
	G_OBJECT_CLASS (klass)->get_property = _vala_four_in_arow_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_four_in_arow_set_property;
	G_OBJECT_CLASS (klass)->finalize = four_in_arow_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOUR_IN_AROW_KEYPRESS_DROP_PROPERTY, four_in_arow_properties[FOUR_IN_AROW_KEYPRESS_DROP_PROPERTY] = g_param_spec_int ("keypress-drop", "keypress-drop", "keypress-drop", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOUR_IN_AROW_KEYPRESS_RIGHT_PROPERTY, four_in_arow_properties[FOUR_IN_AROW_KEYPRESS_RIGHT_PROPERTY] = g_param_spec_int ("keypress-right", "keypress-right", "keypress-right", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOUR_IN_AROW_KEYPRESS_LEFT_PROPERTY, four_in_arow_properties[FOUR_IN_AROW_KEYPRESS_LEFT_PROPERTY] = g_param_spec_int ("keypress-left", "keypress-left", "keypress-left", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOUR_IN_AROW_SOUND_ON_PROPERTY, four_in_arow_properties[FOUR_IN_AROW_SOUND_ON_PROPERTY] = g_param_spec_boolean ("sound-on", "sound-on", "sound-on", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
four_in_arow_instance_init (FourInARow * self,
                            gpointer klass)
{
	GSettings* _tmp0_;
	guint8* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	self->priv = four_in_arow_get_instance_private (self);
	_tmp0_ = g_settings_new ("org.gnome.Four-in-a-row");
	self->priv->settings = _tmp0_;
	self->priv->gameover = TRUE;
	self->priv->player = PLAYER_NOBODY;
	self->priv->winner = PLAYER_NOBODY;
	self->priv->last_first_player = PLAYER_NOBODY;
	self->priv->playgame_timeout = (guint) 0;
	_tmp1_ = g_new0 (guint8, 1 * 0);
	self->priv->blink_lines = _tmp1_;
	self->priv->blink_lines_length1 = 1;
	self->priv->blink_lines_length2 = 0;
	self->priv->blink_line = (guint8) 0;
	self->priv->blink_t = PLAYER_NOBODY;
	self->priv->blink_n = (guint8) 0;
	self->priv->blink_on = FALSE;
	self->priv->timeout = (guint) 0;
	self->priv->sound_context_state = FOUR_IN_AROW_SOUND_CONTEXT_STATE_INITIAL;
	_tmp2_ = g_menu_new ();
	self->priv->game_menu = _tmp2_;
	_tmp3_ = g_menu_new ();
	self->priv->round_section = _tmp3_;
}

static void
four_in_arow_finalize (GObject * obj)
{
	FourInARow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FOUR_IN_AROW, FourInARow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game_board);
	_g_object_unref0 (self->priv->scorebox);
	_g_object_unref0 (self->priv->game_board_view);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->history_button_1);
	_g_object_unref0 (self->priv->history_button_2);
	_g_free0 (self->priv->vstr);
	self->priv->blink_lines = (g_free (self->priv->blink_lines), NULL);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->game_type_action);
	_g_object_unref0 (self->priv->next_round_action);
	_g_object_unref0 (self->priv->window_key_controller);
	_g_object_unref0 (self->priv->board_key_controller);
	_g_object_unref0 (self->priv->sound_context);
	_g_object_unref0 (self->priv->game_menu);
	_g_object_unref0 (self->priv->round_section);
	G_OBJECT_CLASS (four_in_arow_parent_class)->finalize (obj);
}

static GType
four_in_arow_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FourInARowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) four_in_arow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FourInARow), 0, (GInstanceInitFunc) four_in_arow_instance_init, NULL };
	GType four_in_arow_type_id;
	four_in_arow_type_id = g_type_register_static (gtk_application_get_type (), "FourInARow", &g_define_type_info, 0);
	FourInARow_private_offset = g_type_add_instance_private (four_in_arow_type_id, sizeof (FourInARowPrivate));
	return four_in_arow_type_id;
}

GType
four_in_arow_get_type (void)
{
	static volatile gsize four_in_arow_type_id__once = 0;
	if (g_once_init_enter (&four_in_arow_type_id__once)) {
		GType four_in_arow_type_id;
		four_in_arow_type_id = four_in_arow_get_type_once ();
		g_once_init_leave (&four_in_arow_type_id__once, four_in_arow_type_id);
	}
	return four_in_arow_type_id__once;
}

static void
_vala_four_in_arow_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	FourInARow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FOUR_IN_AROW, FourInARow);
	switch (property_id) {
		case FOUR_IN_AROW_KEYPRESS_DROP_PROPERTY:
		g_value_set_int (value, four_in_arow_get_keypress_drop (self));
		break;
		case FOUR_IN_AROW_KEYPRESS_RIGHT_PROPERTY:
		g_value_set_int (value, four_in_arow_get_keypress_right (self));
		break;
		case FOUR_IN_AROW_KEYPRESS_LEFT_PROPERTY:
		g_value_set_int (value, four_in_arow_get_keypress_left (self));
		break;
		case FOUR_IN_AROW_SOUND_ON_PROPERTY:
		g_value_set_boolean (value, four_in_arow_get_sound_on (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_four_in_arow_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	FourInARow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FOUR_IN_AROW, FourInARow);
	switch (property_id) {
		case FOUR_IN_AROW_KEYPRESS_DROP_PROPERTY:
		four_in_arow_set_keypress_drop (self, g_value_get_int (value));
		break;
		case FOUR_IN_AROW_KEYPRESS_RIGHT_PROPERTY:
		four_in_arow_set_keypress_right (self, g_value_get_int (value));
		break;
		case FOUR_IN_AROW_KEYPRESS_LEFT_PROPERTY:
		four_in_arow_set_keypress_left (self, g_value_get_int (value));
		break;
		case FOUR_IN_AROW_SOUND_ON_PROPERTY:
		four_in_arow_set_sound_on (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

