/* This file was automatically generated.  Do not edit! */
#undef INTERFACE
int fossil_any_has_fork(int rcvid);
typedef struct UrlData UrlData;
void transport_global_shutdown(UrlData *pUrlData);
void transport_close(UrlData *pUrlData);
char *db_timespan_name(double rSpan);
void db_end_transaction(int rollbackFlag);
char *fossil_strdup(const char *zOrig);
char *human_readable_age(double rAge);
int fossil_force_newline(void);
void db_set(const char *zName,const char *zValue,int globalFlag);
void fossil_warning(const char *zFormat,...);
double db_double(double rDflt,const char *zSql,...);
int db_is_writeable(const char *zName);
typedef struct Blob Blob;
int http_exchange(Blob *pSend,Blob *pReply,int mHttpFlags,int maxRedirect,const char *zAltMimetype);
#define HTTP_VERBOSE     0x00004     /* HTTP status messages */
#define HTTP_NOCOMPRESS  0x00010     /* Omit payload compression */
#define HTTP_USE_LOGIN   0x00001     /* Add a login card to the sync message */
void db_lset(const char *zName,const char *zValue);
const char *configure_next_name(int iMask);
const char *configure_first_name(int iMask);
void db_record_repository_filename(const char *zName);
void db_begin_transaction_real(const char *zStartFile,int iStartLine);
#define db_begin_transaction()    db_begin_transaction_real(__FILE__,__LINE__)
const char *public_url(void);
void content_enable_dephantomize(int onoff);
char *db_lget(const char *zName,const char *zDefault);
int db_lget_int(const char *zName,int dflt);
void socket_global_init(void);
void transport_stats(i64 *pnSent,i64 *pnRcvd,int resetFlag);
int fossil_fileno(FILE *p);
int fossil_isatty(int fd);
int client_sync(unsigned syncFlags,unsigned configRcvMask,unsigned configSendMask,const char *zAltPCode,int *pnRcvd);
#define SYNC_XVERBOSE       0x20000    /* Extra verbose.  Network traffic */
#define SYNC_SHARE_LINKS    0x10000    /* Request alternate repo links */
#define SYNC_ALLURL         0x08000    /* The --all flag - sync to all URLs */
#define SYNC_NOHTTPCOMPRESS 0x04000    /* Do not compression HTTP messages */
#define SYNC_CKIN_LOCK      0x02000    /* Lock the current check-in */
#define SYNC_IFABLE         0x01000    /* Inability to sync is not fatal */
#define SYNC_UV_DRYRUN      0x00800    /* Do not actually exchange files */
#define SYNC_UV_TRACE       0x00400    /* Describe UV activities */
#define SYNC_UV_REVERT      0x00200    /* Copy server unversioned to client */
#define SYNC_UNVERSIONED    0x00100    /* Sync unversioned content */
#define SYNC_FROMPARENT     0x00040    /* Pull from the parent project */
#define SYNC_RESYNC         0x00020    /* --verily */
#define SYNC_VERBOSE        0x00010    /* Extra diagnostics */
#define SYNC_PRIVATE        0x00008    /* Also transfer private content */
#define SYNC_CLONE          0x00004    /* clone the repository */
#define SYNC_PULL           0x00002    /* pull content server to client */
#define SYNC_PUSH           0x00001    /* push content client to server */
#define INTERFACE 0
char *cgi_extract_content(void);
#include <stdlib.h>
#define ExtFILE    0  /* Always follow symlinks */
sqlite3_int64 blob_read_from_file(Blob *pBlob,const char *zFilename,int eFType);
#if defined(FOSSIL_ENABLE_TCL)
#include "tcl.h"
#endif
#if defined(FOSSIL_ENABLE_JSON)
#include "cson_amalgamation.h"
#include "json_detail.h"
#endif
#if defined(HAVE_BACKTRACE)
#include <execinfo.h>
#endif
void usage(const char *zFormat);
void verify_all_options(void);
const char *find_option(const char *zLong,const char *zShort,int hasArg);
void db_find_and_open_repository(int bFlags,int nArgUsed);
void cmd_test_xfer(void);
void configure_rebuild(void);
#define db_commit_transaction()   db_end_transaction(0)
void fossil_free(void *p);
void fossil_free(void *);
#define MC_PERMIT_HOOKS   1  /*  permit hooks to execute    */
int manifest_crosslink_end(int flags);
void hook_expecting_more_artifacts(int N);
const char *cgi_parameter(const char *zName,const char *zDefault);
#define P(x)          cgi_parameter((x),0)
typedef struct Th_Interp Th_Interp;
#if defined(TH_MEMDEBUG)
void Th_DbgFree(Th_Interp *,void *);
#endif
#define Th_SysFree(I,P)       fossil_free((P))
#if defined(TH_MEMDEBUG)
#  define Th_Free(I,P)        Th_DbgFree((I),(P))
#endif
#if !(defined(TH_MEMDEBUG))
#  define Th_Free(I,P)        Th_SysFree((I),(P))
#endif
void blobarray_reset(Blob *aBlob,int n);
int is_a_leaf(int rid);
const char *unversioned_content_hash(int debugFlag);
#define MANIFEST_NUMERIC_TIME 125909
#define MANIFEST_NUMERIC_DATE 20241106
#define RELEASE_VERSION_NUMBER 22500
#define BLOB_SEEK_CUR 2
int blob_seek(Blob *p,int offset,int whence);
#define CONFIGSET_ALL       0x0007ff     /* Everything */
void configure_receive(const char *zName,Blob *pContent,int groupMask);
int configure_send_group(Blob *pOut,int groupMask,sqlite3_int64 iStart);
#define CONFIGSET_ADDR      0x000040     /* The CONCEALED table */
#define CONFIGSET_SCRIBER   0x000200     /* Email subscribers */
#define CONFIGSET_USER      0x000020     /* The USER table */
int configure_name_to_mask(const char *z,int notFoundIsFatal);
int blob_eq_str(Blob *pBlob,const char *z,int n);
NORETURN void fossil_fatal(const char *zFormat,...);
void content_make_private(int rid);
void fossil_print(const char *zFormat,...);
int blob_tokenize(Blob *pIn,Blob *aToken,int nToken);
int blob_line(Blob *pFrom,Blob *pTo);
#define TH_ERROR    1
void manifest_crosslink_begin(void);
void db_begin_write_real(const char *zStartFile,int iStartLine);
#define db_begin_write()          db_begin_write_real(__FILE__,__LINE__)
int db_get_int(const char *zName,int dflt);
Blob *cgi_output_blob(void);
int db_schema_is_outofdate(void);
void cgi_set_content_type(const char *zType);
void blobarray_zero(Blob *aBlob,int n);
void cgi_check_for_malice(void);
void login_check_credentials(void);
void login_set_anon_nobody_capabilities(void);
NORETURN void fossil_redirect_home(void);
#define PD(x,y)       cgi_parameter((x),(y))
void page_xfer(void);
void url_unparse(UrlData *p);
void db_protect_pop(void);
#define PROTECT_CONFIG     0x02  /* CONFIG and GLOBAL_CONFIG tables */
void db_unprotect(unsigned flags);
#define URL_OMIT_USER        0x0020  /* Omit the user name from URL */
void url_parse_local(const char *zUrl,unsigned int urlFlags,UrlData *pUrlData);
struct UrlData {
  int isFile;           /* True if a "file:" url */
  int isHttps;          /* True if a "https:" url */
  int isSsh;            /* True if an "ssh:" url */
  int isAlias;          /* Input URL was an alias */
  char *name;           /* Hostname for http: or filename for file: */
  char *hostname;       /* The HOST: parameter on http headers */
  const char *protocol; /* "http" or "https" or "ssh" or "file" */
  int port;             /* TCP port number for http: or https: */
  int dfltPort;         /* The default port for the given protocol */
  char *path;           /* Pathname for http: */
  char *user;           /* User id for http: */
  char *passwd;         /* Password for http: */
  char *canonical;      /* Canonical representation of the URL */
  char *proxyAuth;      /* Proxy-Authorizer: string */
  char *fossil;         /* The fossil query parameter on ssh: */
  char *pwConfig;       /* CONFIG table entry that gave us the password */
  unsigned flags;       /* Boolean flags controlling URL processing */
  int useProxy;         /* Used to remember that a proxy is in use */
  int proxyOrigPort;       /* Tunneled port number for https through proxy */
  char *proxyUrlPath;      /* Remember path when proxy is use */
  char *proxyUrlCanonical; /* Remember canonical path when proxy is use */
};
int xfer_run_common_script(void);
const char *Th_GetResult(Th_Interp *,int *);
void fossil_error(int iPriority,const char *zFormat,...);
int Th_Eval(Th_Interp *interp,int iFrame,const char *zProg,int nProg);
void Th_Store(const char *zName,const char *zValue);
typedef unsigned int u32;
#define TH_INIT_NONE        ((u32)0x00000000) /* No flags. */
#define TH_INIT_DEFAULT     (TH_INIT_NONE)      /* Default flags. */
void Th_FossilInit(u32 flags);
#define TH_OK       0
int xfer_run_script(const char *zScript,const char *zUuidOrList,int bIsList);
#define db_rollback_transaction() db_end_transaction(1)
int db_transaction_nesting_depth(void);
void cgi_reset_content(void);
const char *xfer_ticket_code(void);
const char *xfer_commit_code(void);
const char *xfer_push_code(void);
char *db_get(const char *zName,const char *zDefault);
const char *xfer_common_code(void);
void cgi_printf(const char *zFormat,...);
void unversioned_schema(void);
int db_table_exists(const char *zDb,const char *zTable);
char *blob_sql_text(Blob *p);
void blob_append_sql(Blob *pBlob,const char *zFormat,...);
#define MC_NONE           0  /*  default handling           */
int content_put(Blob *pBlob);
int md5sum_blob(const Blob *pIn,Blob *pCksum);
void create_cluster(void);
char *mprintf(const char *zFormat,...);
void login_set_capabilities(const char *zCap,unsigned flags);
char *sha1_shared_secret(const char *zPw,const char *zLogin,const char *zProjCode);
int blob_constant_time_cmp(Blob *pA,Blob *pB);
int sha1sum_blob(const Blob *pIn,Blob *pCksum);
void blob_copy(Blob *pTo,Blob *pFrom);
typedef struct Stmt Stmt;
void db_ephemeral_blob(Stmt *pStmt,int N,Blob *pBlob);
int db_get_boolean(const char *zName,int dflt);
int fossil_strcmp(const char *zA,const char *zB);
void defossilize(char *z);
char *blob_terminate(Blob *p);
#define HNAME_ERROR  0      /* Not a valid hash */
int blob_tail(Blob *pFrom,Blob *pTo);
void db_column_blob(Stmt *pStmt,int N,Blob *pBlob);
i64 db_column_int64(Stmt *pStmt,int N);
const char *db_column_raw(Stmt *pStmt,int N);
int db_column_bytes(Stmt *pStmt,int N);
const char *db_column_text(Stmt *pStmt,int N);
int blob_compare(const Blob *pA,const Blob *pB);
#define HNAME_LEN_SHA1   40
int db_exists(const char *zSql,...);
int blob_uncompress(Blob *pIn,Blob *pOut);
void db_blob(Blob *pResult,const char *zSql,...);
void blob_append(Blob *pBlob,const char *aData,int nData);
int blob_delta_create(Blob *pOriginal,Blob *pTarget,Blob *pDelta);
char *db_text(const char *zDefault,const char *zSql,...);
int content_is_private(int rid);
int db_int(int iDflt,const char *zSql,...);
void db_unset(const char *zName,int globalFlag);
int db_finalize(Stmt *pStmt);
int db_bind_int64(Stmt *pStmt,const char *zParamName,i64 iValue);
int db_bind_blob(Stmt *pStmt,const char *zParamName,Blob *pBlob);
void blob_compress(Blob *pIn,Blob *pOut);
int db_prepare(Stmt *pStmt,const char *zFormat,...);
int unversioned_status(const char *zName,sqlite3_int64 mtime,const char *zHash);
void content_rcvid_init(const char *zSrc);
void blob_init(Blob *pBlob,const char *zData,int size);
# define blob_eq(B,S) \
     ((B)->nUsed==sizeof(S"")-1 && memcmp((B)->aData,S,sizeof(S)-1)==0)
int blob_is_int64(Blob *pBlob,sqlite3_int64 *pValue);
int blob_is_filename(Blob *pBlob);
int blob_is_reset(Blob *pBlob);
#define MC_NO_ERRORS      2  /*  do not issue errors for a bad parse */
int manifest_crosslink(int rid,Blob *pContent,int flags);
#define blob_buffer(X)  ((X)->aData)
int hname_verify_hash(Blob *pContent,const char *zHash,int nHash);
int blob_delta_apply(Blob *pOriginal,Blob *pDelta,Blob *pTarget);
void content_make_public(int rid);
int db_multi_exec(const char *zSql,...);
int content_get(int rid,Blob *pBlob);
#define blob_size(X)  ((X)->nUsed)
void Th_AppendToList(char **pzList,int *pnList,const char *zElem,int nElem);
int content_put_ex(Blob *pBlob,const char *zUuid,int srcId,int nBlob,int isPrivate);
typedef struct Global Global;
struct Blob {
  unsigned int nUsed;            /* Number of bytes used in aData[] */
  unsigned int nAlloc;           /* Number of bytes allocated for aData[] */
  unsigned int iCursor;          /* Next character of input to parse */
  unsigned int blobFlags;        /* One or more BLOBFLAG_* bits */
  char *aData;                   /* Where the information is stored */
  void (*xRealloc)(Blob*, unsigned int); /* Function to reallocate the buffer */
};
typedef struct FossilUserPerms FossilUserPerms;
struct FossilUserPerms {
  char Setup;            /* s: use Setup screens on web interface */
  char Admin;            /* a: administrative permission */
  char Password;         /* p: change password */
  char Query;            /* q: create new reports */
  char Write;            /* i: xfer inbound. check-in */
  char Read;             /* o: xfer outbound. check-out */
  char Hyperlink;        /* h: enable the display of hyperlinks */
  char Clone;            /* g: clone */
  char RdWiki;           /* j: view wiki via web */
  char NewWiki;          /* f: create new wiki via web */
  char ApndWiki;         /* m: append to wiki via web */
  char WrWiki;           /* k: edit wiki via web */
  char ModWiki;          /* l: approve and publish wiki content (Moderator) */
  char RdTkt;            /* r: view tickets via web */
  char NewTkt;           /* n: create new tickets */
  char ApndTkt;          /* c: append to tickets via the web */
  char WrTkt;            /* w: make changes to tickets via web */
  char ModTkt;           /* q: approve and publish ticket changes (Moderator) */
  char Attach;           /* b: add attachments */
  char TktFmt;           /* t: create new ticket report formats */
  char RdAddr;           /* e: read email addresses or other private data */
  char Zip;              /* z: download zipped artifact via /zip URL */
  char Private;          /* x: can send and receive private content */
  char WrUnver;          /* y: can push unversioned content */
  char RdForum;          /* 2: Read forum posts */
  char WrForum;          /* 3: Create new forum posts */
  char WrTForum;         /* 4: Post to forums not subject to moderation */
  char ModForum;         /* 5: Moderate (approve or reject) forum posts */
  char AdminForum;       /* 6: Grant capability 4 to other users */
  char EmailAlert;       /* 7: Sign up for email notifications */
  char Announce;         /* A: Send announcements */
  char Chat;             /* C: read or write the chatroom */
  char Debug;            /* D: show extra Fossil debugging features */
  /* These last two are included to block infinite recursion */
  char XReader;          /* u: Inherit all privileges of "reader" */
  char XDeveloper;       /* v: Inherit all privileges of "developer" */
};
#if defined(FOSSIL_ENABLE_TCL)
typedef struct TclContext TclContext;
struct TclContext {
  int argc;              /* Number of original (expanded) arguments. */
  char **argv;           /* Full copy of the original (expanded) arguments. */
  void *hLibrary;        /* The Tcl library module handle. */
  void *xFindExecutable; /* See tcl_FindExecutableProc in th_tcl.c. */
  void *xCreateInterp;   /* See tcl_CreateInterpProc in th_tcl.c. */
  void *xDeleteInterp;   /* See tcl_DeleteInterpProc in th_tcl.c. */
  void *xFinalize;       /* See tcl_FinalizeProc in th_tcl.c. */
  Tcl_Interp *interp;    /* The on-demand created Tcl interpreter. */
  int useObjProc;        /* Non-zero if an objProc can be called directly. */
  int useTip285;         /* Non-zero if TIP #285 is available. */
  char *setup;           /* The optional Tcl setup script. */
  void *xPreEval;        /* Optional, called before Tcl_Eval*(). */
  void *pPreContext;     /* Optional, provided to xPreEval(). */
  void *xPostEval;       /* Optional, called after Tcl_Eval*(). */
  void *pPostContext;    /* Optional, provided to xPostEval(). */
};
#endif
#define MX_AUX  5
struct Global {
  int argc; char **argv;  /* Command-line arguments to the program */
  char **argvOrig;        /* Original g.argv prior to removing options */
  char *nameOfExe;        /* Full path of executable. */
  const char *zErrlog;    /* Log errors to this file, if not NULL */
  const char *zPhase;     /* Phase of operation, for use by the error log
                          ** and for deriving $canonical_page TH1 variable */
  int isConst;            /* True if the output is unchanging & cacheable */
  const char *zVfsName;   /* The VFS to use for database connections */
  sqlite3 *db;            /* The connection to the databases */
  sqlite3 *dbConfig;      /* Separate connection for global_config table */
  char *zAuxSchema;       /* Main repository aux-schema */
  int dbIgnoreErrors;     /* Ignore database errors if true */
  char *zConfigDbName;    /* Path of the config database. NULL if not open */
  sqlite3_int64 now;      /* Seconds since 1970 */
  int repositoryOpen;     /* True if the main repository database is open */
  unsigned iRepoDataVers;  /* Initial data version for repository database */
  char *zRepositoryOption; /* Most recent cached repository option value */
  char *zRepositoryName;  /* Name of the repository database file */
  char *zLocalDbName;     /* Name of the local database file */
  char *zOpenRevision;    /* Check-in version to use during database open */
  const char *zCmdName;   /* Name of the Fossil command currently running */
  int localOpen;          /* True if the local database is open */
  char *zLocalRoot;       /* The directory holding the  local database */
  int minPrefix;          /* Number of digits needed for a distinct hash */
  int eHashPolicy;        /* Current hash policy.  One of HPOLICY_* */
  int fSqlTrace;          /* True if --sqltrace flag is present */
  int fSqlStats;          /* True if --sqltrace or --sqlstats are present */
  int fSqlPrint;          /* True if --sqlprint flag is present */
  int fCgiTrace;          /* True if --cgitrace is enabled */
  int fQuiet;             /* True if -quiet flag is present */
  int fJail;              /* True if running with a chroot jail */
  int fHttpTrace;         /* Trace outbound HTTP requests */
  int fAnyTrace;          /* Any kind of tracing */
  int fAllowACME;         /* Deliver files from .well-known */
  char *zHttpAuth;        /* HTTP Authorization user:pass information */
  int fSystemTrace;       /* Trace calls to fossil_system(), --systemtrace */
  int fSshTrace;          /* Trace the SSH setup traffic */
  int fSshClient;         /* HTTP client flags for SSH client */
  int fNoHttpCompress;    /* Do not compress HTTP traffic (for debugging) */
  char *zSshCmd;          /* SSH command string */
  const char *zHttpCmd;   /* External program to do HTTP requests */
  int fNoSync;            /* Do not do an autosync ever.  --nosync */
  int fIPv4;              /* Use only IPv4, not IPv6. --ipv4 */
  char *zPath;            /* Name of webpage being served (may be NULL) */
  char *zExtra;           /* Extra path information past the webpage name */
  char *zBaseURL;         /* Full text of the URL being served */
  char *zHttpsURL;        /* zBaseURL translated to https: */
  char *zTop;             /* Parent directory of zPath */
  int nExtraURL;          /* Extra bytes added to SCRIPT_NAME */
  const char *zExtRoot;   /* Document root for the /ext sub-website */
  const char *zContentType;  /* The content type of the input HTTP request */
  int iErrPriority;       /* Priority of current error message */
  char *zErrMsg;          /* Text of an error message */
  int sslNotAvailable;    /* SSL is not available.  Do not redirect to https: */
  Blob cgiIn;             /* Input to an xfer www method */
  int cgiOutput;          /* 0: command-line 1: CGI. 2: after CGI */
  int xferPanic;          /* Write error messages in XFER protocol */
  int fullHttpReply;      /* True for full HTTP reply.  False for CGI reply */
  Th_Interp *interp;      /* The TH1 interpreter */
  char *th1Setup;         /* The TH1 post-creation setup script, if any */
  int th1Flags;           /* The TH1 integration state flags */
  FILE *httpIn;           /* Accept HTTP input from here */
  FILE *httpOut;          /* Send HTTP output here */
  int httpUseSSL;         /* True to use an SSL codec for HTTP traffic */
  void *httpSSLConn;      /* The SSL connection */
  int xlinkClusterOnly;   /* Set when cloning.  Only process clusters */
  int fTimeFormat;        /* 1 for UTC.  2 for localtime.  0 not yet selected */
  int *aCommitFile;       /* Array of files to be committed */
  int markPrivate;        /* All new artifacts are private if true */
  char *ckinLockFail;     /* Check-in lock failure received from server */
  int clockSkewSeen;      /* True if clocks on client and server out of sync */
  int wikiFlags;          /* Wiki conversion flags applied to %W */
  char isHTTP;            /* True if server/CGI modes, else assume CLI. */
  char jsHref;            /* If true, set href= using javascript, not HTML */
  Blob httpHeader;        /* Complete text of the HTTP request header */
  UrlData url;            /* Information about current URL */
  const char *zLogin;     /* Login name.  NULL or "" if not logged in. */
  const char *zCkoutAlias;   /* doc/ uses this branch as an alias for "ckout" */
  const char *zMainMenuFile; /* --mainmenu FILE from server/ui/cgi */
  const char *zSSLIdentity;  /* Value of --ssl-identity option, filename of
                             ** SSL client identity */
  const char *zCgiFile;      /* Name of the CGI file */
  const char *zReqType;      /* Type of request: "HTTP", "CGI", "SCGI" */
#if USE_SEE
  const char *zPidKey;    /* Saved value of the --usepidkey option.  Only
                           * applicable when using SEE on Windows or Linux. */
#endif
  int useLocalauth;       /* No login required if from 127.0.0.1 */
  int noPswd;             /* Logged in without password (on 127.0.0.1) */
  int userUid;            /* Integer user id */
  int isHuman;            /* True if access by a human, not a spider or bot */
  int comFmtFlags;        /* Zero or more "COMMENT_PRINT_*" bit flags, should be
                          ** accessed through get_comment_format(). */
  const char *zSockName;  /* Name of the unix-domain socket file */
  const char *zSockMode;  /* File permissions for unix-domain socket */
  const char *zSockOwner; /* Owner, or owner:group for unix-domain socket */

  /* Information used to populate the RCVFROM table */
  int rcvid;              /* The rcvid.  0 if not yet defined. */
  char *zIpAddr;          /* The remote IP address */
  char *zNonce;           /* The nonce used for login */

  /* permissions available to current user */
  struct FossilUserPerms perm;

  /* permissions available to current user or to "anonymous".
  ** This is the logical union of perm permissions above with
  ** the value that perm would take if g.zLogin were "anonymous". */
  struct FossilUserPerms anon;

#ifdef FOSSIL_ENABLE_TCL
  /* all Tcl related context necessary for integration */
  struct TclContext tcl;
#endif

  /* For defense against Cross-site Request Forgery attacks */
  char zCsrfToken[16];    /* Value of the anti-CSRF token */
  int okCsrf;             /* -1:  unsafe
                          **  0:  unknown
                          **  1:  same origin
                          **  2:  same origin + is POST
                          **  3:  same origin, POST, valid csrf token */

  int parseCnt[10];       /* Counts of artifacts parsed */
  FILE *fDebug;           /* Write debug information here, if the file exists */
#ifdef FOSSIL_ENABLE_TH1_HOOKS
  int fNoThHook;          /* Disable all TH1 command/webpage hooks */
#endif
  int thTrace;            /* True to enable TH1 debugging output */
  Blob thLog;             /* Text of the TH1 debugging output */

  int isHome;             /* True if rendering the "home" page */

  /* Storage for the aux() and/or option() SQL function arguments */
  int nAux;                    /* Number of distinct aux() or option() values */
  const char *azAuxName[MX_AUX]; /* Name of each aux() or option() value */
  char *azAuxParam[MX_AUX];      /* Param of each aux() or option() value */
  const char *azAuxVal[MX_AUX];  /* Value of each aux() or option() value */
  const char **azAuxOpt[MX_AUX]; /* Options of each option() value */
  int anAuxCols[MX_AUX];         /* Number of columns for option() values */
  int allowSymlinks;             /* Cached "allow-symlinks" option */
  int mainTimerId;               /* Set to fossil_timer_start() */
  int nPendingRequest;           /* # of HTTP requests in "fossil server" */
  int nRequest;                  /* Total # of HTTP request */
  int bAvoidDeltaManifests;      /* Avoid using delta manifests if true */
#ifdef FOSSIL_ENABLE_JSON
  struct FossilJsonBits {
    int isJsonMode;            /* True if running in JSON mode, else
                                  false. This changes how errors are
                                  reported. In JSON mode we try to
                                  always output JSON-form error
                                  responses and always (in CGI mode)
                                  exit() with code 0 to avoid an HTTP
                                  500 error.
                               */
    int preserveRc;            /* Do not convert error codes into 0.
                                * This is primarily intended for use
                                * by the test suite. */
    int resultCode;            /* used for passing back specific codes
                               ** from /json callbacks. */
    int errorDetailParanoia;   /* 0=full error codes, 1=%10, 2=%100, 3=%1000 */
    cson_output_opt outOpt;    /* formatting options for JSON mode. */
    cson_value *authToken;     /* authentication token */
    const char *jsonp;         /* Name of JSONP function wrapper. */
    unsigned char dispatchDepth /* Tells JSON command dispatching
                                   which argument we are currently
                                   working on. For this purpose, arg#0
                                   is the "json" path/CLI arg.
                                */;
    struct {                   /* "garbage collector" */
      cson_value *v;
      cson_array *a;
    } gc;
    struct {                   /* JSON POST data. */
      cson_value *v;
      cson_array *a;
      int offset;              /* Tells us which PATH_INFO/CLI args
                                  part holds the "json" command, so
                                  that we can account for sub-repos
                                  and path prefixes.  This is handled
                                  differently for CLI and CGI modes.
                               */
      const char *commandStr   /*"command" request param.*/;
    } cmd;
    struct {                   /* JSON POST data. */
      cson_value *v;
      cson_object *o;
    } post;
    struct {                   /* GET/COOKIE params in JSON mode. */
      cson_value *v;
      cson_object *o;
    } param;
    struct {
      cson_value *v;
      cson_object *o;
    } reqPayload;              /* request payload object (if any) */
    cson_array *warnings;      /* response warnings */
    int timerId;               /* fetched from fossil_timer_start() */
  } json;
#endif /* FOSSIL_ENABLE_JSON */
  int ftntsIssues[4];     /* Counts for misref, strayed, joined, overnested */
  int diffCnt[3];         /* Counts for DIFF_NUMSTAT: files, ins, del */
};
extern Global g;
void blob_reset(Blob *pBlob);
int uuid_is_shunned(const char *zUuid);
int blob_extract(Blob *pFrom,int N,Blob *pTo);
void blob_zero(Blob *pBlob);
void blob_appendf(Blob *pBlob,const char *zFormat,...);
int blob_is_int(Blob *pBlob,int *pValue);
int blob_is_hname(Blob *pBlob);
int db_bind_text(Stmt *pStmt,const char *zParamName,const char *zValue);
int db_bind_int(Stmt *pStmt,const char *zParamName,int iValue);
char *blob_str(Blob *p);
int content_new(const char *zUuid,int isPrivate);
int db_reset(Stmt *pStmt);
int db_column_int(Stmt *pStmt,int N);
int db_step(Stmt *pStmt);
int db_bind_str(Stmt *pStmt,const char *zParamName,Blob *pBlob);
int db_static_prepare(Stmt *pStmt,const char *zFormat,...);
struct Stmt {
  Blob sql;               /* The SQL for this statement */
  sqlite3_stmt *pStmt;    /* The results of sqlite3_prepare_v2() */
  Stmt *pNext, *pPrev;    /* List of all unfinalized statements */
  int nStep;              /* Number of sqlite3_step() calls */
  int rc;                 /* Error from db_vprepare() */
};
