//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef ServiceWorkerOpArgs_h
#define ServiceWorkerOpArgs_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/ServiceWorkerBinding.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/dom/ClientIPCTypes.h"
#include "mozilla/dom/DOMTypes.h"
#include "mozilla/dom/FetchTypes.h"
#include "mozilla/net/NeckoChannelParams.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerCheckScriptEvaluationOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerCheckScriptEvaluationOpArgs final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerCheckScriptEvaluationOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerCheckScriptEvaluationOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerCheckScriptEvaluationOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerUpdateStateOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerUpdateStateOpArgs final
{
private:
    typedef ::mozilla::dom::ServiceWorkerState ServiceWorkerState;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerUpdateStateOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerUpdateStateOpArgs(const ServiceWorkerState& _state) :
        state_(_state)
    {
    }

    MOZ_IMPLICIT ServiceWorkerUpdateStateOpArgs(ServiceWorkerState&& _state) :
        state_(std::move(_state))
    {
    }

    ServiceWorkerState&
    state()
    {
        return state_;
    }
    const ServiceWorkerState&
    state() const
    {
        return state_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ServiceWorkerState> state_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerUpdateStateOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerUpdateStateOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerTerminateWorkerOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerTerminateWorkerOpArgs final
{
private:
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerTerminateWorkerOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerTerminateWorkerOpArgs(const uint32_t& _shutdownStateId) :
        shutdownStateId_(_shutdownStateId)
    {
    }

    MOZ_IMPLICIT ServiceWorkerTerminateWorkerOpArgs(uint32_t&& _shutdownStateId) :
        shutdownStateId_(std::move(_shutdownStateId))
    {
    }

    uint32_t&
    shutdownStateId()
    {
        return shutdownStateId_;
    }
    const uint32_t&
    shutdownStateId() const
    {
        return shutdownStateId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<uint32_t> shutdownStateId_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerTerminateWorkerOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerTerminateWorkerOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerLifeCycleEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerLifeCycleEventOpArgs final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerLifeCycleEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerLifeCycleEventOpArgs(const nsString& _eventName) :
        eventName_(_eventName)
    {
    }

    MOZ_IMPLICIT ServiceWorkerLifeCycleEventOpArgs(nsString&& _eventName) :
        eventName_(std::move(_eventName))
    {
    }

    nsString&
    eventName()
    {
        return eventName_;
    }
    const nsString&
    eventName() const
    {
        return eventName_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> eventName_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerLifeCycleEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerLifeCycleEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerCookieChangeEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerCookieChangeEventOpArgs final
{
private:
    typedef ::mozilla::net::CookieStruct CookieStruct;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerCookieChangeEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerCookieChangeEventOpArgs(
            const CookieStruct& _cookie,
            const bool& _deleted) :
        cookie_(_cookie),
        deleted_(_deleted)
    {
    }

    MOZ_IMPLICIT ServiceWorkerCookieChangeEventOpArgs(
            CookieStruct&& _cookie,
            bool&& _deleted) :
        cookie_(std::move(_cookie)),
        deleted_(std::move(_deleted))
    {
    }

    CookieStruct&
    cookie()
    {
        return cookie_;
    }
    const CookieStruct&
    cookie() const
    {
        return cookie_;
    }

    bool&
    deleted()
    {
        return deleted_;
    }
    const bool&
    deleted() const
    {
        return deleted_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CookieStruct> cookie_;
    ::mozilla::ipc::IPDLStructMember<bool> deleted_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerCookieChangeEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerCookieChangeEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OptionalPushData|
//
namespace mozilla {
namespace dom {
class OptionalPushData final
{
public:
    enum Type {
        T__None,
        Tvoid_t = 1,
        TArrayOfuint8_t,
        T__Last = TArrayOfuint8_t
    };

private:
    typedef ::mozilla::void_t void_t;
    typedef ::uint8_t uint8_t;
    typedef void_t void_t__tdef;
    typedef nsTArray<uint8_t> ArrayOfuint8_t__tdef;

    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }
    nsTArray<uint8_t>*
    ptr_ArrayOfuint8_t()
    {
        return (&(mVArrayOfuint8_t));
    }
    const nsTArray<uint8_t>*
    constptr_ArrayOfuint8_t() const
    {
        return (&(mVArrayOfuint8_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OptionalPushData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OptionalPushData(const void_t& aOther);

    MOZ_IMPLICIT OptionalPushData(void_t&& aOther);

    MOZ_IMPLICIT OptionalPushData(const nsTArray<uint8_t>& aOther);

    MOZ_IMPLICIT OptionalPushData(nsTArray<uint8_t>&& aOther);

    MOZ_IMPLICIT OptionalPushData(const OptionalPushData& aOther);

    MOZ_IMPLICIT OptionalPushData(OptionalPushData&& aOther);

    ~OptionalPushData();

    Type
    type() const
    {
        return mType;
    }

    OptionalPushData&
    operator=(const void_t& aRhs);

    OptionalPushData&
    operator=(void_t&& aRhs);

    OptionalPushData&
    operator=(const nsTArray<uint8_t>& aRhs);

    OptionalPushData&
    operator=(nsTArray<uint8_t>&& aRhs);

    OptionalPushData&
    operator=(const OptionalPushData& aRhs);

    OptionalPushData&
    operator=(OptionalPushData&& aRhs);

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

    nsTArray<uint8_t>&
    get_ArrayOfuint8_t()
    {
        AssertSanity(TArrayOfuint8_t);
        return (*(ptr_ArrayOfuint8_t()));
    }
    const nsTArray<uint8_t>&
    get_ArrayOfuint8_t() const
    {
        AssertSanity(TArrayOfuint8_t);
        return (*(constptr_ArrayOfuint8_t()));
    }
    operator nsTArray<uint8_t>&()
    {
        return get_ArrayOfuint8_t();
    }
    operator const nsTArray<uint8_t>&() const
    {
        return get_ArrayOfuint8_t();
    }

private:
    union {
        void_t mVvoid_t;
        nsTArray<uint8_t> mVArrayOfuint8_t;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::OptionalPushData>
{
    typedef ::mozilla::dom::OptionalPushData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerPushEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerPushEventOpArgs final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::dom::OptionalPushData OptionalPushData;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerPushEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerPushEventOpArgs(
            const nsString& _messageId,
            const OptionalPushData& _data) :
        messageId_(_messageId),
        data_(_data)
    {
    }

    MOZ_IMPLICIT ServiceWorkerPushEventOpArgs(
            nsString&& _messageId,
            OptionalPushData&& _data) :
        messageId_(std::move(_messageId)),
        data_(std::move(_data))
    {
    }

    nsString&
    messageId()
    {
        return messageId_;
    }
    const nsString&
    messageId() const
    {
        return messageId_;
    }

    OptionalPushData&
    data()
    {
        return data_;
    }
    const OptionalPushData&
    data() const
    {
        return data_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> messageId_;
    ::mozilla::ipc::IPDLStructMember<OptionalPushData> data_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerPushEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerPushEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct PushSubscriptionData|
//
namespace mozilla {
namespace dom {
class PushSubscriptionData final
{
private:
    typedef ::nsString nsString;
    typedef ::uint8_t uint8_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    PushSubscriptionData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT PushSubscriptionData(
            const nsString& _endpoint,
            const nsTArray<uint8_t>& _rawP256dhKey,
            const nsTArray<uint8_t>& _authSecret,
            const nsTArray<uint8_t>& _appServerKey) :
        endpoint_(_endpoint),
        rawP256dhKey_(_rawP256dhKey),
        authSecret_(_authSecret),
        appServerKey_(_appServerKey)
    {
    }

    MOZ_IMPLICIT PushSubscriptionData(
            nsString&& _endpoint,
            nsTArray<uint8_t>&& _rawP256dhKey,
            nsTArray<uint8_t>&& _authSecret,
            nsTArray<uint8_t>&& _appServerKey) :
        endpoint_(std::move(_endpoint)),
        rawP256dhKey_(std::move(_rawP256dhKey)),
        authSecret_(std::move(_authSecret)),
        appServerKey_(std::move(_appServerKey))
    {
    }

    nsString&
    endpoint()
    {
        return endpoint_;
    }
    const nsString&
    endpoint() const
    {
        return endpoint_;
    }

    nsTArray<uint8_t>&
    rawP256dhKey()
    {
        return rawP256dhKey_;
    }
    const nsTArray<uint8_t>&
    rawP256dhKey() const
    {
        return rawP256dhKey_;
    }

    nsTArray<uint8_t>&
    authSecret()
    {
        return authSecret_;
    }
    const nsTArray<uint8_t>&
    authSecret() const
    {
        return authSecret_;
    }

    nsTArray<uint8_t>&
    appServerKey()
    {
        return appServerKey_;
    }
    const nsTArray<uint8_t>&
    appServerKey() const
    {
        return appServerKey_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> endpoint_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<uint8_t>> rawP256dhKey_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<uint8_t>> authSecret_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<uint8_t>> appServerKey_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::PushSubscriptionData>
{
    typedef ::mozilla::dom::PushSubscriptionData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerPushSubscriptionChangeEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerPushSubscriptionChangeEventOpArgs final
{
private:
    typedef ::mozilla::dom::PushSubscriptionData PushSubscriptionData;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerPushSubscriptionChangeEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerPushSubscriptionChangeEventOpArgs(const mozilla::Maybe<PushSubscriptionData>& _oldSubscription) :
        oldSubscription_(_oldSubscription)
    {
    }

    MOZ_IMPLICIT ServiceWorkerPushSubscriptionChangeEventOpArgs(mozilla::Maybe<PushSubscriptionData>&& _oldSubscription) :
        oldSubscription_(std::move(_oldSubscription))
    {
    }

    mozilla::Maybe<PushSubscriptionData>&
    oldSubscription()
    {
        return oldSubscription_;
    }
    const mozilla::Maybe<PushSubscriptionData>&
    oldSubscription() const
    {
        return oldSubscription_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PushSubscriptionData>> oldSubscription_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerPushSubscriptionChangeEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerPushSubscriptionChangeEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerNotificationClickEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerNotificationClickEventOpArgs final
{
private:
    typedef ::mozilla::dom::IPCNotification IPCNotification;
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerNotificationClickEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerNotificationClickEventOpArgs(
            const IPCNotification& _notification,
            const nsString& _action) :
        notification_(_notification),
        action_(_action)
    {
    }

    MOZ_IMPLICIT ServiceWorkerNotificationClickEventOpArgs(
            IPCNotification&& _notification,
            nsString&& _action) :
        notification_(std::move(_notification)),
        action_(std::move(_action))
    {
    }

    IPCNotification&
    notification()
    {
        return notification_;
    }
    const IPCNotification&
    notification() const
    {
        return notification_;
    }

    nsString&
    action()
    {
        return action_;
    }
    const nsString&
    action() const
    {
        return action_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCNotification> notification_;
    ::mozilla::ipc::IPDLStructMember<nsString> action_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerNotificationClickEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerNotificationClickEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerNotificationCloseEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerNotificationCloseEventOpArgs final
{
private:
    typedef ::mozilla::dom::IPCNotification IPCNotification;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerNotificationCloseEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerNotificationCloseEventOpArgs(const IPCNotification& _notification) :
        notification_(_notification)
    {
    }

    MOZ_IMPLICIT ServiceWorkerNotificationCloseEventOpArgs(IPCNotification&& _notification) :
        notification_(std::move(_notification))
    {
    }

    IPCNotification&
    notification()
    {
        return notification_;
    }
    const IPCNotification&
    notification() const
    {
        return notification_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCNotification> notification_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerNotificationCloseEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerNotificationCloseEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ServiceWorkerNotificationEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerNotificationEventOpArgs final
{
public:
    enum Type {
        T__None,
        TServiceWorkerNotificationClickEventOpArgs = 1,
        TServiceWorkerNotificationCloseEventOpArgs,
        T__Last = TServiceWorkerNotificationCloseEventOpArgs
    };

private:
    typedef ::mozilla::dom::ServiceWorkerNotificationClickEventOpArgs ServiceWorkerNotificationClickEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerNotificationCloseEventOpArgs ServiceWorkerNotificationCloseEventOpArgs;
    typedef ServiceWorkerNotificationClickEventOpArgs ServiceWorkerNotificationClickEventOpArgs__tdef;
    typedef ServiceWorkerNotificationCloseEventOpArgs ServiceWorkerNotificationCloseEventOpArgs__tdef;

    ServiceWorkerNotificationClickEventOpArgs*
    ptr_ServiceWorkerNotificationClickEventOpArgs()
    {
        return (&(mVServiceWorkerNotificationClickEventOpArgs));
    }
    const ServiceWorkerNotificationClickEventOpArgs*
    constptr_ServiceWorkerNotificationClickEventOpArgs() const
    {
        return (&(mVServiceWorkerNotificationClickEventOpArgs));
    }
    ServiceWorkerNotificationCloseEventOpArgs*
    ptr_ServiceWorkerNotificationCloseEventOpArgs()
    {
        return (&(mVServiceWorkerNotificationCloseEventOpArgs));
    }
    const ServiceWorkerNotificationCloseEventOpArgs*
    constptr_ServiceWorkerNotificationCloseEventOpArgs() const
    {
        return (&(mVServiceWorkerNotificationCloseEventOpArgs));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs(const ServiceWorkerNotificationClickEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs(ServiceWorkerNotificationClickEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs(const ServiceWorkerNotificationCloseEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs(ServiceWorkerNotificationCloseEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs(const ServiceWorkerNotificationEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerNotificationEventOpArgs(ServiceWorkerNotificationEventOpArgs&& aOther);

    ~ServiceWorkerNotificationEventOpArgs();

    Type
    type() const
    {
        return mType;
    }

    ServiceWorkerNotificationEventOpArgs&
    operator=(const ServiceWorkerNotificationClickEventOpArgs& aRhs);

    ServiceWorkerNotificationEventOpArgs&
    operator=(ServiceWorkerNotificationClickEventOpArgs&& aRhs);

    ServiceWorkerNotificationEventOpArgs&
    operator=(const ServiceWorkerNotificationCloseEventOpArgs& aRhs);

    ServiceWorkerNotificationEventOpArgs&
    operator=(ServiceWorkerNotificationCloseEventOpArgs&& aRhs);

    ServiceWorkerNotificationEventOpArgs&
    operator=(const ServiceWorkerNotificationEventOpArgs& aRhs);

    ServiceWorkerNotificationEventOpArgs&
    operator=(ServiceWorkerNotificationEventOpArgs&& aRhs);

    ServiceWorkerNotificationClickEventOpArgs&
    get_ServiceWorkerNotificationClickEventOpArgs()
    {
        AssertSanity(TServiceWorkerNotificationClickEventOpArgs);
        return (*(ptr_ServiceWorkerNotificationClickEventOpArgs()));
    }
    const ServiceWorkerNotificationClickEventOpArgs&
    get_ServiceWorkerNotificationClickEventOpArgs() const
    {
        AssertSanity(TServiceWorkerNotificationClickEventOpArgs);
        return (*(constptr_ServiceWorkerNotificationClickEventOpArgs()));
    }
    operator ServiceWorkerNotificationClickEventOpArgs&()
    {
        return get_ServiceWorkerNotificationClickEventOpArgs();
    }
    operator const ServiceWorkerNotificationClickEventOpArgs&() const
    {
        return get_ServiceWorkerNotificationClickEventOpArgs();
    }

    ServiceWorkerNotificationCloseEventOpArgs&
    get_ServiceWorkerNotificationCloseEventOpArgs()
    {
        AssertSanity(TServiceWorkerNotificationCloseEventOpArgs);
        return (*(ptr_ServiceWorkerNotificationCloseEventOpArgs()));
    }
    const ServiceWorkerNotificationCloseEventOpArgs&
    get_ServiceWorkerNotificationCloseEventOpArgs() const
    {
        AssertSanity(TServiceWorkerNotificationCloseEventOpArgs);
        return (*(constptr_ServiceWorkerNotificationCloseEventOpArgs()));
    }
    operator ServiceWorkerNotificationCloseEventOpArgs&()
    {
        return get_ServiceWorkerNotificationCloseEventOpArgs();
    }
    operator const ServiceWorkerNotificationCloseEventOpArgs&() const
    {
        return get_ServiceWorkerNotificationCloseEventOpArgs();
    }

private:
    union {
        ServiceWorkerNotificationClickEventOpArgs mVServiceWorkerNotificationClickEventOpArgs;
        ServiceWorkerNotificationCloseEventOpArgs mVServiceWorkerNotificationCloseEventOpArgs;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerNotificationEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerNotificationEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerExtensionAPIEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerExtensionAPIEventOpArgs final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerExtensionAPIEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerExtensionAPIEventOpArgs(
            const nsString& _apiNamespace,
            const nsString& _apiEventName) :
        apiNamespace_(_apiNamespace),
        apiEventName_(_apiEventName)
    {
    }

    MOZ_IMPLICIT ServiceWorkerExtensionAPIEventOpArgs(
            nsString&& _apiNamespace,
            nsString&& _apiEventName) :
        apiNamespace_(std::move(_apiNamespace)),
        apiEventName_(std::move(_apiEventName))
    {
    }

    nsString&
    apiNamespace()
    {
        return apiNamespace_;
    }
    const nsString&
    apiNamespace() const
    {
        return apiNamespace_;
    }

    nsString&
    apiEventName()
    {
        return apiEventName_;
    }
    const nsString&
    apiEventName() const
    {
        return apiEventName_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> apiNamespace_;
    ::mozilla::ipc::IPDLStructMember<nsString> apiEventName_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerExtensionAPIEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerExtensionAPIEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerMessageEventOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerMessageEventOpArgs final
{
private:
    typedef ::mozilla::dom::PostMessageSource PostMessageSource;
    typedef ::mozilla::dom::ipc::StructuredCloneData StructuredCloneData;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerMessageEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerMessageEventOpArgs(
            const PostMessageSource& _source,
            StructuredCloneData* _clonedData) :
        source_(_source),
        clonedData_(_clonedData)
    {
    }

    MOZ_IMPLICIT ServiceWorkerMessageEventOpArgs(
            PostMessageSource&& _source,
            RefPtr<StructuredCloneData>&& _clonedData) :
        source_(std::move(_source)),
        clonedData_(std::move(_clonedData))
    {
    }

    PostMessageSource&
    source()
    {
        return source_;
    }
    const PostMessageSource&
    source() const
    {
        return source_;
    }

    RefPtr<StructuredCloneData>&
    clonedData()
    {
        return clonedData_;
    }
    StructuredCloneData*
    clonedData() const
    {
        return clonedData_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PostMessageSource> source_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<StructuredCloneData>> clonedData_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerMessageEventOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerMessageEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerFetchEventOpArgsCommon|
//
namespace mozilla {
namespace dom {
class ServiceWorkerFetchEventOpArgsCommon final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::IPCInternalRequest IPCInternalRequest;
    typedef ::nsString nsString;
    typedef ::nsresult nsresult;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerFetchEventOpArgsCommon() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerFetchEventOpArgsCommon(
            const nsCString& _workerScriptSpec,
            const IPCInternalRequest& _internalRequest,
            const nsString& _clientId,
            const nsString& _resultingClientId,
            const bool& _isNonSubresourceRequest,
            const bool& _preloadNavigation,
            const nsresult& _testingInjectCancellation) :
        workerScriptSpec_(_workerScriptSpec),
        internalRequest_(_internalRequest),
        clientId_(_clientId),
        resultingClientId_(_resultingClientId),
        isNonSubresourceRequest_(_isNonSubresourceRequest),
        preloadNavigation_(_preloadNavigation),
        testingInjectCancellation_(_testingInjectCancellation)
    {
    }

    MOZ_IMPLICIT ServiceWorkerFetchEventOpArgsCommon(
            nsCString&& _workerScriptSpec,
            IPCInternalRequest&& _internalRequest,
            nsString&& _clientId,
            nsString&& _resultingClientId,
            bool&& _isNonSubresourceRequest,
            bool&& _preloadNavigation,
            nsresult&& _testingInjectCancellation) :
        workerScriptSpec_(std::move(_workerScriptSpec)),
        internalRequest_(std::move(_internalRequest)),
        clientId_(std::move(_clientId)),
        resultingClientId_(std::move(_resultingClientId)),
        isNonSubresourceRequest_(std::move(_isNonSubresourceRequest)),
        preloadNavigation_(std::move(_preloadNavigation)),
        testingInjectCancellation_(std::move(_testingInjectCancellation))
    {
    }

    nsCString&
    workerScriptSpec()
    {
        return workerScriptSpec_;
    }
    const nsCString&
    workerScriptSpec() const
    {
        return workerScriptSpec_;
    }

    IPCInternalRequest&
    internalRequest()
    {
        return internalRequest_;
    }
    const IPCInternalRequest&
    internalRequest() const
    {
        return internalRequest_;
    }

    nsString&
    clientId()
    {
        return clientId_;
    }
    const nsString&
    clientId() const
    {
        return clientId_;
    }

    nsString&
    resultingClientId()
    {
        return resultingClientId_;
    }
    const nsString&
    resultingClientId() const
    {
        return resultingClientId_;
    }

    bool&
    isNonSubresourceRequest()
    {
        return isNonSubresourceRequest_;
    }
    const bool&
    isNonSubresourceRequest() const
    {
        return isNonSubresourceRequest_;
    }

    bool&
    preloadNavigation()
    {
        return preloadNavigation_;
    }
    const bool&
    preloadNavigation() const
    {
        return preloadNavigation_;
    }

    nsresult&
    testingInjectCancellation()
    {
        return testingInjectCancellation_;
    }
    const nsresult&
    testingInjectCancellation() const
    {
        return testingInjectCancellation_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> workerScriptSpec_;
    ::mozilla::ipc::IPDLStructMember<IPCInternalRequest> internalRequest_;
    ::mozilla::ipc::IPDLStructMember<nsString> clientId_;
    ::mozilla::ipc::IPDLStructMember<nsString> resultingClientId_;
    ::mozilla::ipc::IPDLStructMember<bool> isNonSubresourceRequest_;
    ::mozilla::ipc::IPDLStructMember<bool> preloadNavigation_;
    ::mozilla::ipc::IPDLStructMember<nsresult> testingInjectCancellation_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerFetchEventOpArgsCommon>
{
    typedef ::mozilla::dom::ServiceWorkerFetchEventOpArgsCommon paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentToParentServiceWorkerFetchEventOpArgs|
//
namespace mozilla {
namespace dom {
class ParentToParentServiceWorkerFetchEventOpArgs final
{
private:
    typedef ::mozilla::dom::ServiceWorkerFetchEventOpArgsCommon ServiceWorkerFetchEventOpArgsCommon;
    typedef ::mozilla::dom::ParentToParentInternalResponse ParentToParentInternalResponse;
    typedef ::mozilla::dom::ResponseTiming ResponseTiming;
    typedef ::mozilla::dom::ResponseEndArgs ResponseEndArgs;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentToParentServiceWorkerFetchEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentToParentServiceWorkerFetchEventOpArgs(
            const ServiceWorkerFetchEventOpArgsCommon& _common,
            const mozilla::Maybe<ParentToParentInternalResponse>& _preloadResponse,
            const mozilla::Maybe<ResponseTiming>& _preloadResponseTiming,
            const mozilla::Maybe<ResponseEndArgs>& _preloadResponseEndArgs) :
        common_(_common),
        preloadResponse_(_preloadResponse),
        preloadResponseTiming_(_preloadResponseTiming),
        preloadResponseEndArgs_(_preloadResponseEndArgs)
    {
    }

    MOZ_IMPLICIT ParentToParentServiceWorkerFetchEventOpArgs(
            ServiceWorkerFetchEventOpArgsCommon&& _common,
            mozilla::Maybe<ParentToParentInternalResponse>&& _preloadResponse,
            mozilla::Maybe<ResponseTiming>&& _preloadResponseTiming,
            mozilla::Maybe<ResponseEndArgs>&& _preloadResponseEndArgs) :
        common_(std::move(_common)),
        preloadResponse_(std::move(_preloadResponse)),
        preloadResponseTiming_(std::move(_preloadResponseTiming)),
        preloadResponseEndArgs_(std::move(_preloadResponseEndArgs))
    {
    }

    ServiceWorkerFetchEventOpArgsCommon&
    common()
    {
        return common_;
    }
    const ServiceWorkerFetchEventOpArgsCommon&
    common() const
    {
        return common_;
    }

    mozilla::Maybe<ParentToParentInternalResponse>&
    preloadResponse()
    {
        return preloadResponse_;
    }
    const mozilla::Maybe<ParentToParentInternalResponse>&
    preloadResponse() const
    {
        return preloadResponse_;
    }

    mozilla::Maybe<ResponseTiming>&
    preloadResponseTiming()
    {
        return preloadResponseTiming_;
    }
    const mozilla::Maybe<ResponseTiming>&
    preloadResponseTiming() const
    {
        return preloadResponseTiming_;
    }

    mozilla::Maybe<ResponseEndArgs>&
    preloadResponseEndArgs()
    {
        return preloadResponseEndArgs_;
    }
    const mozilla::Maybe<ResponseEndArgs>&
    preloadResponseEndArgs() const
    {
        return preloadResponseEndArgs_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ServiceWorkerFetchEventOpArgsCommon> common_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ParentToParentInternalResponse>> preloadResponse_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ResponseTiming>> preloadResponseTiming_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ResponseEndArgs>> preloadResponseEndArgs_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToParentServiceWorkerFetchEventOpArgs>
{
    typedef ::mozilla::dom::ParentToParentServiceWorkerFetchEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentToChildServiceWorkerFetchEventOpArgs|
//
namespace mozilla {
namespace dom {
class ParentToChildServiceWorkerFetchEventOpArgs final
{
private:
    typedef ::mozilla::dom::ServiceWorkerFetchEventOpArgsCommon ServiceWorkerFetchEventOpArgsCommon;
    typedef ::mozilla::dom::ParentToChildInternalResponse ParentToChildInternalResponse;
    typedef ::mozilla::dom::ResponseTiming ResponseTiming;
    typedef ::mozilla::dom::ResponseEndArgs ResponseEndArgs;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentToChildServiceWorkerFetchEventOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentToChildServiceWorkerFetchEventOpArgs(
            const ServiceWorkerFetchEventOpArgsCommon& _common,
            const mozilla::Maybe<ParentToChildInternalResponse>& _preloadResponse,
            const mozilla::Maybe<ResponseTiming>& _preloadResponseTiming,
            const mozilla::Maybe<ResponseEndArgs>& _preloadResponseEndArgs) :
        common_(_common),
        preloadResponse_(_preloadResponse),
        preloadResponseTiming_(_preloadResponseTiming),
        preloadResponseEndArgs_(_preloadResponseEndArgs)
    {
    }

    MOZ_IMPLICIT ParentToChildServiceWorkerFetchEventOpArgs(
            ServiceWorkerFetchEventOpArgsCommon&& _common,
            mozilla::Maybe<ParentToChildInternalResponse>&& _preloadResponse,
            mozilla::Maybe<ResponseTiming>&& _preloadResponseTiming,
            mozilla::Maybe<ResponseEndArgs>&& _preloadResponseEndArgs) :
        common_(std::move(_common)),
        preloadResponse_(std::move(_preloadResponse)),
        preloadResponseTiming_(std::move(_preloadResponseTiming)),
        preloadResponseEndArgs_(std::move(_preloadResponseEndArgs))
    {
    }

    ServiceWorkerFetchEventOpArgsCommon&
    common()
    {
        return common_;
    }
    const ServiceWorkerFetchEventOpArgsCommon&
    common() const
    {
        return common_;
    }

    mozilla::Maybe<ParentToChildInternalResponse>&
    preloadResponse()
    {
        return preloadResponse_;
    }
    const mozilla::Maybe<ParentToChildInternalResponse>&
    preloadResponse() const
    {
        return preloadResponse_;
    }

    mozilla::Maybe<ResponseTiming>&
    preloadResponseTiming()
    {
        return preloadResponseTiming_;
    }
    const mozilla::Maybe<ResponseTiming>&
    preloadResponseTiming() const
    {
        return preloadResponseTiming_;
    }

    mozilla::Maybe<ResponseEndArgs>&
    preloadResponseEndArgs()
    {
        return preloadResponseEndArgs_;
    }
    const mozilla::Maybe<ResponseEndArgs>&
    preloadResponseEndArgs() const
    {
        return preloadResponseEndArgs_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ServiceWorkerFetchEventOpArgsCommon> common_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ParentToChildInternalResponse>> preloadResponse_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ResponseTiming>> preloadResponseTiming_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ResponseEndArgs>> preloadResponseEndArgs_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToChildServiceWorkerFetchEventOpArgs>
{
    typedef ::mozilla::dom::ParentToChildServiceWorkerFetchEventOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs(const bool& _onContentBlockingAllowList) :
        onContentBlockingAllowList_(_onContentBlockingAllowList)
    {
    }

    MOZ_IMPLICIT ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs(bool&& _onContentBlockingAllowList) :
        onContentBlockingAllowList_(std::move(_onContentBlockingAllowList))
    {
    }

    bool&
    onContentBlockingAllowList()
    {
        return onContentBlockingAllowList_;
    }
    const bool&
    onContentBlockingAllowList() const
    {
        return onContentBlockingAllowList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> onContentBlockingAllowList_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ServiceWorkerOpArgs|
//
namespace mozilla {
namespace dom {
class ServiceWorkerOpArgs final
{
public:
    enum Type {
        T__None,
        TServiceWorkerCheckScriptEvaluationOpArgs = 1,
        TServiceWorkerUpdateStateOpArgs,
        TServiceWorkerTerminateWorkerOpArgs,
        TServiceWorkerLifeCycleEventOpArgs,
        TServiceWorkerCookieChangeEventOpArgs,
        TServiceWorkerPushEventOpArgs,
        TServiceWorkerPushSubscriptionChangeEventOpArgs,
        TServiceWorkerNotificationEventOpArgs,
        TServiceWorkerMessageEventOpArgs,
        TServiceWorkerExtensionAPIEventOpArgs,
        TParentToChildServiceWorkerFetchEventOpArgs,
        TServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs,
        T__Last = TServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs
    };

private:
    typedef ::mozilla::dom::ServiceWorkerCheckScriptEvaluationOpArgs ServiceWorkerCheckScriptEvaluationOpArgs;
    typedef ::mozilla::dom::ServiceWorkerUpdateStateOpArgs ServiceWorkerUpdateStateOpArgs;
    typedef ::mozilla::dom::ServiceWorkerTerminateWorkerOpArgs ServiceWorkerTerminateWorkerOpArgs;
    typedef ::mozilla::dom::ServiceWorkerLifeCycleEventOpArgs ServiceWorkerLifeCycleEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerCookieChangeEventOpArgs ServiceWorkerCookieChangeEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerPushEventOpArgs ServiceWorkerPushEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerPushSubscriptionChangeEventOpArgs ServiceWorkerPushSubscriptionChangeEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerNotificationEventOpArgs ServiceWorkerNotificationEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerMessageEventOpArgs ServiceWorkerMessageEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerExtensionAPIEventOpArgs ServiceWorkerExtensionAPIEventOpArgs;
    typedef ::mozilla::dom::ParentToChildServiceWorkerFetchEventOpArgs ParentToChildServiceWorkerFetchEventOpArgs;
    typedef ::mozilla::dom::ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs;
    typedef ServiceWorkerCheckScriptEvaluationOpArgs ServiceWorkerCheckScriptEvaluationOpArgs__tdef;
    typedef ServiceWorkerUpdateStateOpArgs ServiceWorkerUpdateStateOpArgs__tdef;
    typedef ServiceWorkerTerminateWorkerOpArgs ServiceWorkerTerminateWorkerOpArgs__tdef;
    typedef ServiceWorkerLifeCycleEventOpArgs ServiceWorkerLifeCycleEventOpArgs__tdef;
    typedef ServiceWorkerCookieChangeEventOpArgs ServiceWorkerCookieChangeEventOpArgs__tdef;
    typedef ServiceWorkerPushEventOpArgs ServiceWorkerPushEventOpArgs__tdef;
    typedef ServiceWorkerPushSubscriptionChangeEventOpArgs ServiceWorkerPushSubscriptionChangeEventOpArgs__tdef;
    typedef ServiceWorkerNotificationEventOpArgs ServiceWorkerNotificationEventOpArgs__tdef;
    typedef ServiceWorkerMessageEventOpArgs ServiceWorkerMessageEventOpArgs__tdef;
    typedef ServiceWorkerExtensionAPIEventOpArgs ServiceWorkerExtensionAPIEventOpArgs__tdef;
    typedef ParentToChildServiceWorkerFetchEventOpArgs ParentToChildServiceWorkerFetchEventOpArgs__tdef;
    typedef ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs__tdef;

    ServiceWorkerCheckScriptEvaluationOpArgs*
    ptr_ServiceWorkerCheckScriptEvaluationOpArgs()
    {
        return (&(mVServiceWorkerCheckScriptEvaluationOpArgs));
    }
    const ServiceWorkerCheckScriptEvaluationOpArgs*
    constptr_ServiceWorkerCheckScriptEvaluationOpArgs() const
    {
        return (&(mVServiceWorkerCheckScriptEvaluationOpArgs));
    }
    ServiceWorkerUpdateStateOpArgs*
    ptr_ServiceWorkerUpdateStateOpArgs()
    {
        return (&(mVServiceWorkerUpdateStateOpArgs));
    }
    const ServiceWorkerUpdateStateOpArgs*
    constptr_ServiceWorkerUpdateStateOpArgs() const
    {
        return (&(mVServiceWorkerUpdateStateOpArgs));
    }
    ServiceWorkerTerminateWorkerOpArgs*
    ptr_ServiceWorkerTerminateWorkerOpArgs()
    {
        return (&(mVServiceWorkerTerminateWorkerOpArgs));
    }
    const ServiceWorkerTerminateWorkerOpArgs*
    constptr_ServiceWorkerTerminateWorkerOpArgs() const
    {
        return (&(mVServiceWorkerTerminateWorkerOpArgs));
    }
    ServiceWorkerLifeCycleEventOpArgs*
    ptr_ServiceWorkerLifeCycleEventOpArgs()
    {
        return (&(mVServiceWorkerLifeCycleEventOpArgs));
    }
    const ServiceWorkerLifeCycleEventOpArgs*
    constptr_ServiceWorkerLifeCycleEventOpArgs() const
    {
        return (&(mVServiceWorkerLifeCycleEventOpArgs));
    }
    ServiceWorkerCookieChangeEventOpArgs*
    ptr_ServiceWorkerCookieChangeEventOpArgs()
    {
        return (&(mVServiceWorkerCookieChangeEventOpArgs));
    }
    const ServiceWorkerCookieChangeEventOpArgs*
    constptr_ServiceWorkerCookieChangeEventOpArgs() const
    {
        return (&(mVServiceWorkerCookieChangeEventOpArgs));
    }
    ServiceWorkerPushEventOpArgs*
    ptr_ServiceWorkerPushEventOpArgs()
    {
        return (&(mVServiceWorkerPushEventOpArgs));
    }
    const ServiceWorkerPushEventOpArgs*
    constptr_ServiceWorkerPushEventOpArgs() const
    {
        return (&(mVServiceWorkerPushEventOpArgs));
    }
    ServiceWorkerPushSubscriptionChangeEventOpArgs*
    ptr_ServiceWorkerPushSubscriptionChangeEventOpArgs()
    {
        return (&(mVServiceWorkerPushSubscriptionChangeEventOpArgs));
    }
    const ServiceWorkerPushSubscriptionChangeEventOpArgs*
    constptr_ServiceWorkerPushSubscriptionChangeEventOpArgs() const
    {
        return (&(mVServiceWorkerPushSubscriptionChangeEventOpArgs));
    }
    ServiceWorkerNotificationEventOpArgs*
    ptr_ServiceWorkerNotificationEventOpArgs()
    {
        return (&(mVServiceWorkerNotificationEventOpArgs));
    }
    const ServiceWorkerNotificationEventOpArgs*
    constptr_ServiceWorkerNotificationEventOpArgs() const
    {
        return (&(mVServiceWorkerNotificationEventOpArgs));
    }
    ServiceWorkerMessageEventOpArgs*
    ptr_ServiceWorkerMessageEventOpArgs()
    {
        return (&(mVServiceWorkerMessageEventOpArgs));
    }
    const ServiceWorkerMessageEventOpArgs*
    constptr_ServiceWorkerMessageEventOpArgs() const
    {
        return (&(mVServiceWorkerMessageEventOpArgs));
    }
    ServiceWorkerExtensionAPIEventOpArgs*
    ptr_ServiceWorkerExtensionAPIEventOpArgs()
    {
        return (&(mVServiceWorkerExtensionAPIEventOpArgs));
    }
    const ServiceWorkerExtensionAPIEventOpArgs*
    constptr_ServiceWorkerExtensionAPIEventOpArgs() const
    {
        return (&(mVServiceWorkerExtensionAPIEventOpArgs));
    }
    ParentToChildServiceWorkerFetchEventOpArgs*
    ptr_ParentToChildServiceWorkerFetchEventOpArgs()
    {
        return (&(mVParentToChildServiceWorkerFetchEventOpArgs));
    }
    const ParentToChildServiceWorkerFetchEventOpArgs*
    constptr_ParentToChildServiceWorkerFetchEventOpArgs() const
    {
        return (&(mVParentToChildServiceWorkerFetchEventOpArgs));
    }
    ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs*
    ptr_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs()
    {
        return (&(mVServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs));
    }
    const ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs*
    constptr_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs() const
    {
        return (&(mVServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ServiceWorkerOpArgs() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerCheckScriptEvaluationOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerCheckScriptEvaluationOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerUpdateStateOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerUpdateStateOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerTerminateWorkerOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerTerminateWorkerOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerLifeCycleEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerLifeCycleEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerCookieChangeEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerCookieChangeEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerPushEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerPushEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerPushSubscriptionChangeEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerPushSubscriptionChangeEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerNotificationEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerNotificationEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerMessageEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerMessageEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerExtensionAPIEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerExtensionAPIEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ParentToChildServiceWorkerFetchEventOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ParentToChildServiceWorkerFetchEventOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(const ServiceWorkerOpArgs& aOther);

    MOZ_IMPLICIT ServiceWorkerOpArgs(ServiceWorkerOpArgs&& aOther);

    ~ServiceWorkerOpArgs();

    Type
    type() const
    {
        return mType;
    }

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerCheckScriptEvaluationOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerCheckScriptEvaluationOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerUpdateStateOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerUpdateStateOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerTerminateWorkerOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerTerminateWorkerOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerLifeCycleEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerLifeCycleEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerCookieChangeEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerCookieChangeEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerPushEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerPushEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerPushSubscriptionChangeEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerPushSubscriptionChangeEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerNotificationEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerNotificationEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerMessageEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerMessageEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerExtensionAPIEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerExtensionAPIEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ParentToChildServiceWorkerFetchEventOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ParentToChildServiceWorkerFetchEventOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs&& aRhs);

    ServiceWorkerOpArgs&
    operator=(const ServiceWorkerOpArgs& aRhs);

    ServiceWorkerOpArgs&
    operator=(ServiceWorkerOpArgs&& aRhs);

    ServiceWorkerCheckScriptEvaluationOpArgs&
    get_ServiceWorkerCheckScriptEvaluationOpArgs()
    {
        AssertSanity(TServiceWorkerCheckScriptEvaluationOpArgs);
        return (*(ptr_ServiceWorkerCheckScriptEvaluationOpArgs()));
    }
    const ServiceWorkerCheckScriptEvaluationOpArgs&
    get_ServiceWorkerCheckScriptEvaluationOpArgs() const
    {
        AssertSanity(TServiceWorkerCheckScriptEvaluationOpArgs);
        return (*(constptr_ServiceWorkerCheckScriptEvaluationOpArgs()));
    }
    operator ServiceWorkerCheckScriptEvaluationOpArgs&()
    {
        return get_ServiceWorkerCheckScriptEvaluationOpArgs();
    }
    operator const ServiceWorkerCheckScriptEvaluationOpArgs&() const
    {
        return get_ServiceWorkerCheckScriptEvaluationOpArgs();
    }

    ServiceWorkerUpdateStateOpArgs&
    get_ServiceWorkerUpdateStateOpArgs()
    {
        AssertSanity(TServiceWorkerUpdateStateOpArgs);
        return (*(ptr_ServiceWorkerUpdateStateOpArgs()));
    }
    const ServiceWorkerUpdateStateOpArgs&
    get_ServiceWorkerUpdateStateOpArgs() const
    {
        AssertSanity(TServiceWorkerUpdateStateOpArgs);
        return (*(constptr_ServiceWorkerUpdateStateOpArgs()));
    }
    operator ServiceWorkerUpdateStateOpArgs&()
    {
        return get_ServiceWorkerUpdateStateOpArgs();
    }
    operator const ServiceWorkerUpdateStateOpArgs&() const
    {
        return get_ServiceWorkerUpdateStateOpArgs();
    }

    ServiceWorkerTerminateWorkerOpArgs&
    get_ServiceWorkerTerminateWorkerOpArgs()
    {
        AssertSanity(TServiceWorkerTerminateWorkerOpArgs);
        return (*(ptr_ServiceWorkerTerminateWorkerOpArgs()));
    }
    const ServiceWorkerTerminateWorkerOpArgs&
    get_ServiceWorkerTerminateWorkerOpArgs() const
    {
        AssertSanity(TServiceWorkerTerminateWorkerOpArgs);
        return (*(constptr_ServiceWorkerTerminateWorkerOpArgs()));
    }
    operator ServiceWorkerTerminateWorkerOpArgs&()
    {
        return get_ServiceWorkerTerminateWorkerOpArgs();
    }
    operator const ServiceWorkerTerminateWorkerOpArgs&() const
    {
        return get_ServiceWorkerTerminateWorkerOpArgs();
    }

    ServiceWorkerLifeCycleEventOpArgs&
    get_ServiceWorkerLifeCycleEventOpArgs()
    {
        AssertSanity(TServiceWorkerLifeCycleEventOpArgs);
        return (*(ptr_ServiceWorkerLifeCycleEventOpArgs()));
    }
    const ServiceWorkerLifeCycleEventOpArgs&
    get_ServiceWorkerLifeCycleEventOpArgs() const
    {
        AssertSanity(TServiceWorkerLifeCycleEventOpArgs);
        return (*(constptr_ServiceWorkerLifeCycleEventOpArgs()));
    }
    operator ServiceWorkerLifeCycleEventOpArgs&()
    {
        return get_ServiceWorkerLifeCycleEventOpArgs();
    }
    operator const ServiceWorkerLifeCycleEventOpArgs&() const
    {
        return get_ServiceWorkerLifeCycleEventOpArgs();
    }

    ServiceWorkerCookieChangeEventOpArgs&
    get_ServiceWorkerCookieChangeEventOpArgs()
    {
        AssertSanity(TServiceWorkerCookieChangeEventOpArgs);
        return (*(ptr_ServiceWorkerCookieChangeEventOpArgs()));
    }
    const ServiceWorkerCookieChangeEventOpArgs&
    get_ServiceWorkerCookieChangeEventOpArgs() const
    {
        AssertSanity(TServiceWorkerCookieChangeEventOpArgs);
        return (*(constptr_ServiceWorkerCookieChangeEventOpArgs()));
    }
    operator ServiceWorkerCookieChangeEventOpArgs&()
    {
        return get_ServiceWorkerCookieChangeEventOpArgs();
    }
    operator const ServiceWorkerCookieChangeEventOpArgs&() const
    {
        return get_ServiceWorkerCookieChangeEventOpArgs();
    }

    ServiceWorkerPushEventOpArgs&
    get_ServiceWorkerPushEventOpArgs()
    {
        AssertSanity(TServiceWorkerPushEventOpArgs);
        return (*(ptr_ServiceWorkerPushEventOpArgs()));
    }
    const ServiceWorkerPushEventOpArgs&
    get_ServiceWorkerPushEventOpArgs() const
    {
        AssertSanity(TServiceWorkerPushEventOpArgs);
        return (*(constptr_ServiceWorkerPushEventOpArgs()));
    }
    operator ServiceWorkerPushEventOpArgs&()
    {
        return get_ServiceWorkerPushEventOpArgs();
    }
    operator const ServiceWorkerPushEventOpArgs&() const
    {
        return get_ServiceWorkerPushEventOpArgs();
    }

    ServiceWorkerPushSubscriptionChangeEventOpArgs&
    get_ServiceWorkerPushSubscriptionChangeEventOpArgs()
    {
        AssertSanity(TServiceWorkerPushSubscriptionChangeEventOpArgs);
        return (*(ptr_ServiceWorkerPushSubscriptionChangeEventOpArgs()));
    }
    const ServiceWorkerPushSubscriptionChangeEventOpArgs&
    get_ServiceWorkerPushSubscriptionChangeEventOpArgs() const
    {
        AssertSanity(TServiceWorkerPushSubscriptionChangeEventOpArgs);
        return (*(constptr_ServiceWorkerPushSubscriptionChangeEventOpArgs()));
    }
    operator ServiceWorkerPushSubscriptionChangeEventOpArgs&()
    {
        return get_ServiceWorkerPushSubscriptionChangeEventOpArgs();
    }
    operator const ServiceWorkerPushSubscriptionChangeEventOpArgs&() const
    {
        return get_ServiceWorkerPushSubscriptionChangeEventOpArgs();
    }

    ServiceWorkerNotificationEventOpArgs&
    get_ServiceWorkerNotificationEventOpArgs()
    {
        AssertSanity(TServiceWorkerNotificationEventOpArgs);
        return (*(ptr_ServiceWorkerNotificationEventOpArgs()));
    }
    const ServiceWorkerNotificationEventOpArgs&
    get_ServiceWorkerNotificationEventOpArgs() const
    {
        AssertSanity(TServiceWorkerNotificationEventOpArgs);
        return (*(constptr_ServiceWorkerNotificationEventOpArgs()));
    }
    operator ServiceWorkerNotificationEventOpArgs&()
    {
        return get_ServiceWorkerNotificationEventOpArgs();
    }
    operator const ServiceWorkerNotificationEventOpArgs&() const
    {
        return get_ServiceWorkerNotificationEventOpArgs();
    }

    ServiceWorkerMessageEventOpArgs&
    get_ServiceWorkerMessageEventOpArgs()
    {
        AssertSanity(TServiceWorkerMessageEventOpArgs);
        return (*(ptr_ServiceWorkerMessageEventOpArgs()));
    }
    const ServiceWorkerMessageEventOpArgs&
    get_ServiceWorkerMessageEventOpArgs() const
    {
        AssertSanity(TServiceWorkerMessageEventOpArgs);
        return (*(constptr_ServiceWorkerMessageEventOpArgs()));
    }
    operator ServiceWorkerMessageEventOpArgs&()
    {
        return get_ServiceWorkerMessageEventOpArgs();
    }
    operator const ServiceWorkerMessageEventOpArgs&() const
    {
        return get_ServiceWorkerMessageEventOpArgs();
    }

    ServiceWorkerExtensionAPIEventOpArgs&
    get_ServiceWorkerExtensionAPIEventOpArgs()
    {
        AssertSanity(TServiceWorkerExtensionAPIEventOpArgs);
        return (*(ptr_ServiceWorkerExtensionAPIEventOpArgs()));
    }
    const ServiceWorkerExtensionAPIEventOpArgs&
    get_ServiceWorkerExtensionAPIEventOpArgs() const
    {
        AssertSanity(TServiceWorkerExtensionAPIEventOpArgs);
        return (*(constptr_ServiceWorkerExtensionAPIEventOpArgs()));
    }
    operator ServiceWorkerExtensionAPIEventOpArgs&()
    {
        return get_ServiceWorkerExtensionAPIEventOpArgs();
    }
    operator const ServiceWorkerExtensionAPIEventOpArgs&() const
    {
        return get_ServiceWorkerExtensionAPIEventOpArgs();
    }

    ParentToChildServiceWorkerFetchEventOpArgs&
    get_ParentToChildServiceWorkerFetchEventOpArgs()
    {
        AssertSanity(TParentToChildServiceWorkerFetchEventOpArgs);
        return (*(ptr_ParentToChildServiceWorkerFetchEventOpArgs()));
    }
    const ParentToChildServiceWorkerFetchEventOpArgs&
    get_ParentToChildServiceWorkerFetchEventOpArgs() const
    {
        AssertSanity(TParentToChildServiceWorkerFetchEventOpArgs);
        return (*(constptr_ParentToChildServiceWorkerFetchEventOpArgs()));
    }
    operator ParentToChildServiceWorkerFetchEventOpArgs&()
    {
        return get_ParentToChildServiceWorkerFetchEventOpArgs();
    }
    operator const ParentToChildServiceWorkerFetchEventOpArgs&() const
    {
        return get_ParentToChildServiceWorkerFetchEventOpArgs();
    }

    ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs&
    get_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs()
    {
        AssertSanity(TServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs);
        return (*(ptr_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs()));
    }
    const ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs&
    get_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs() const
    {
        AssertSanity(TServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs);
        return (*(constptr_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs()));
    }
    operator ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs&()
    {
        return get_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs();
    }
    operator const ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs&() const
    {
        return get_ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs();
    }

private:
    union {
        ServiceWorkerCheckScriptEvaluationOpArgs mVServiceWorkerCheckScriptEvaluationOpArgs;
        ServiceWorkerUpdateStateOpArgs mVServiceWorkerUpdateStateOpArgs;
        ServiceWorkerTerminateWorkerOpArgs mVServiceWorkerTerminateWorkerOpArgs;
        ServiceWorkerLifeCycleEventOpArgs mVServiceWorkerLifeCycleEventOpArgs;
        ServiceWorkerCookieChangeEventOpArgs mVServiceWorkerCookieChangeEventOpArgs;
        ServiceWorkerPushEventOpArgs mVServiceWorkerPushEventOpArgs;
        ServiceWorkerPushSubscriptionChangeEventOpArgs mVServiceWorkerPushSubscriptionChangeEventOpArgs;
        ServiceWorkerNotificationEventOpArgs mVServiceWorkerNotificationEventOpArgs;
        ServiceWorkerMessageEventOpArgs mVServiceWorkerMessageEventOpArgs;
        ServiceWorkerExtensionAPIEventOpArgs mVServiceWorkerExtensionAPIEventOpArgs;
        ParentToChildServiceWorkerFetchEventOpArgs mVParentToChildServiceWorkerFetchEventOpArgs;
        ServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs mVServiceWorkerUpdateIsOnContentBlockingAllowListOpArgs;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerOpArgs>
{
    typedef ::mozilla::dom::ServiceWorkerOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FetchEventRespondWithClosure|
//
namespace mozilla {
namespace dom {
class FetchEventRespondWithClosure final
{
private:
    typedef ::nsCString nsCString;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FetchEventRespondWithClosure() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FetchEventRespondWithClosure(
            const nsCString& _respondWithScriptSpec,
            const uint32_t& _respondWithLineNumber,
            const uint32_t& _respondWithColumnNumber) :
        respondWithScriptSpec_(_respondWithScriptSpec),
        respondWithLineNumber_(_respondWithLineNumber),
        respondWithColumnNumber_(_respondWithColumnNumber)
    {
    }

    MOZ_IMPLICIT FetchEventRespondWithClosure(
            nsCString&& _respondWithScriptSpec,
            uint32_t&& _respondWithLineNumber,
            uint32_t&& _respondWithColumnNumber) :
        respondWithScriptSpec_(std::move(_respondWithScriptSpec)),
        respondWithLineNumber_(std::move(_respondWithLineNumber)),
        respondWithColumnNumber_(std::move(_respondWithColumnNumber))
    {
    }

    nsCString&
    respondWithScriptSpec()
    {
        return respondWithScriptSpec_;
    }
    const nsCString&
    respondWithScriptSpec() const
    {
        return respondWithScriptSpec_;
    }

    uint32_t&
    respondWithLineNumber()
    {
        return respondWithLineNumber_;
    }
    const uint32_t&
    respondWithLineNumber() const
    {
        return respondWithLineNumber_;
    }

    uint32_t&
    respondWithColumnNumber()
    {
        return respondWithColumnNumber_;
    }
    const uint32_t&
    respondWithColumnNumber() const
    {
        return respondWithColumnNumber_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsCString> respondWithScriptSpec_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> respondWithLineNumber_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> respondWithColumnNumber_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FetchEventRespondWithClosure>
{
    typedef ::mozilla::dom::FetchEventRespondWithClosure paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FetchEventTimeStamps|
//
namespace mozilla {
namespace dom {
class FetchEventTimeStamps final
{
private:
    typedef ::mozilla::TimeStamp TimeStamp;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FetchEventTimeStamps() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FetchEventTimeStamps(
            const TimeStamp& _fetchHandlerStart,
            const TimeStamp& _fetchHandlerFinish) :
        fetchHandlerStart_(_fetchHandlerStart),
        fetchHandlerFinish_(_fetchHandlerFinish)
    {
    }

    MOZ_IMPLICIT FetchEventTimeStamps(
            TimeStamp&& _fetchHandlerStart,
            TimeStamp&& _fetchHandlerFinish) :
        fetchHandlerStart_(std::move(_fetchHandlerStart)),
        fetchHandlerFinish_(std::move(_fetchHandlerFinish))
    {
    }

    TimeStamp&
    fetchHandlerStart()
    {
        return fetchHandlerStart_;
    }
    const TimeStamp&
    fetchHandlerStart() const
    {
        return fetchHandlerStart_;
    }

    TimeStamp&
    fetchHandlerFinish()
    {
        return fetchHandlerFinish_;
    }
    const TimeStamp&
    fetchHandlerFinish() const
    {
        return fetchHandlerFinish_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<TimeStamp> fetchHandlerStart_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> fetchHandlerFinish_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FetchEventTimeStamps>
{
    typedef ::mozilla::dom::FetchEventTimeStamps paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ChildToParentSynthesizeResponseArgs|
//
namespace mozilla {
namespace dom {
class ChildToParentSynthesizeResponseArgs final
{
private:
    typedef ::mozilla::dom::ChildToParentInternalResponse ChildToParentInternalResponse;
    typedef ::mozilla::dom::FetchEventRespondWithClosure FetchEventRespondWithClosure;
    typedef ::mozilla::dom::FetchEventTimeStamps FetchEventTimeStamps;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ChildToParentSynthesizeResponseArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ChildToParentSynthesizeResponseArgs(
            const ChildToParentInternalResponse& _internalResponse,
            const FetchEventRespondWithClosure& _closure,
            const FetchEventTimeStamps& _timeStamps) :
        internalResponse_(_internalResponse),
        closure_(_closure),
        timeStamps_(_timeStamps)
    {
    }

    MOZ_IMPLICIT ChildToParentSynthesizeResponseArgs(
            ChildToParentInternalResponse&& _internalResponse,
            FetchEventRespondWithClosure&& _closure,
            FetchEventTimeStamps&& _timeStamps) :
        internalResponse_(std::move(_internalResponse)),
        closure_(std::move(_closure)),
        timeStamps_(std::move(_timeStamps))
    {
    }

    ChildToParentInternalResponse&
    internalResponse()
    {
        return internalResponse_;
    }
    const ChildToParentInternalResponse&
    internalResponse() const
    {
        return internalResponse_;
    }

    FetchEventRespondWithClosure&
    closure()
    {
        return closure_;
    }
    const FetchEventRespondWithClosure&
    closure() const
    {
        return closure_;
    }

    FetchEventTimeStamps&
    timeStamps()
    {
        return timeStamps_;
    }
    const FetchEventTimeStamps&
    timeStamps() const
    {
        return timeStamps_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ChildToParentInternalResponse> internalResponse_;
    ::mozilla::ipc::IPDLStructMember<FetchEventRespondWithClosure> closure_;
    ::mozilla::ipc::IPDLStructMember<FetchEventTimeStamps> timeStamps_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ChildToParentSynthesizeResponseArgs>
{
    typedef ::mozilla::dom::ChildToParentSynthesizeResponseArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentToParentSynthesizeResponseArgs|
//
namespace mozilla {
namespace dom {
class ParentToParentSynthesizeResponseArgs final
{
private:
    typedef ::mozilla::dom::ParentToParentInternalResponse ParentToParentInternalResponse;
    typedef ::mozilla::dom::FetchEventRespondWithClosure FetchEventRespondWithClosure;
    typedef ::mozilla::dom::FetchEventTimeStamps FetchEventTimeStamps;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentToParentSynthesizeResponseArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentToParentSynthesizeResponseArgs(
            const ParentToParentInternalResponse& _internalResponse,
            const FetchEventRespondWithClosure& _closure,
            const FetchEventTimeStamps& _timeStamps) :
        internalResponse_(_internalResponse),
        closure_(_closure),
        timeStamps_(_timeStamps)
    {
    }

    MOZ_IMPLICIT ParentToParentSynthesizeResponseArgs(
            ParentToParentInternalResponse&& _internalResponse,
            FetchEventRespondWithClosure&& _closure,
            FetchEventTimeStamps&& _timeStamps) :
        internalResponse_(std::move(_internalResponse)),
        closure_(std::move(_closure)),
        timeStamps_(std::move(_timeStamps))
    {
    }

    ParentToParentInternalResponse&
    internalResponse()
    {
        return internalResponse_;
    }
    const ParentToParentInternalResponse&
    internalResponse() const
    {
        return internalResponse_;
    }

    FetchEventRespondWithClosure&
    closure()
    {
        return closure_;
    }
    const FetchEventRespondWithClosure&
    closure() const
    {
        return closure_;
    }

    FetchEventTimeStamps&
    timeStamps()
    {
        return timeStamps_;
    }
    const FetchEventTimeStamps&
    timeStamps() const
    {
        return timeStamps_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ParentToParentInternalResponse> internalResponse_;
    ::mozilla::ipc::IPDLStructMember<FetchEventRespondWithClosure> closure_;
    ::mozilla::ipc::IPDLStructMember<FetchEventTimeStamps> timeStamps_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToParentSynthesizeResponseArgs>
{
    typedef ::mozilla::dom::ParentToParentSynthesizeResponseArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ResetInterceptionArgs|
//
namespace mozilla {
namespace dom {
class ResetInterceptionArgs final
{
private:
    typedef ::mozilla::dom::FetchEventTimeStamps FetchEventTimeStamps;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ResetInterceptionArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ResetInterceptionArgs(const FetchEventTimeStamps& _timeStamps) :
        timeStamps_(_timeStamps)
    {
    }

    MOZ_IMPLICIT ResetInterceptionArgs(FetchEventTimeStamps&& _timeStamps) :
        timeStamps_(std::move(_timeStamps))
    {
    }

    FetchEventTimeStamps&
    timeStamps()
    {
        return timeStamps_;
    }
    const FetchEventTimeStamps&
    timeStamps() const
    {
        return timeStamps_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FetchEventTimeStamps> timeStamps_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ResetInterceptionArgs>
{
    typedef ::mozilla::dom::ResetInterceptionArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CancelInterceptionArgs|
//
namespace mozilla {
namespace dom {
class CancelInterceptionArgs final
{
private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::FetchEventTimeStamps FetchEventTimeStamps;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CancelInterceptionArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CancelInterceptionArgs(
            const nsresult& _status,
            const FetchEventTimeStamps& _timeStamps) :
        status_(_status),
        timeStamps_(_timeStamps)
    {
    }

    MOZ_IMPLICIT CancelInterceptionArgs(
            nsresult&& _status,
            FetchEventTimeStamps&& _timeStamps) :
        status_(std::move(_status)),
        timeStamps_(std::move(_timeStamps))
    {
    }

    nsresult&
    status()
    {
        return status_;
    }
    const nsresult&
    status() const
    {
        return status_;
    }

    FetchEventTimeStamps&
    timeStamps()
    {
        return timeStamps_;
    }
    const FetchEventTimeStamps&
    timeStamps() const
    {
        return timeStamps_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsresult> status_;
    ::mozilla::ipc::IPDLStructMember<FetchEventTimeStamps> timeStamps_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::CancelInterceptionArgs>
{
    typedef ::mozilla::dom::CancelInterceptionArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ChildToParentFetchEventRespondWithResult|
//
namespace mozilla {
namespace dom {
class ChildToParentFetchEventRespondWithResult final
{
public:
    enum Type {
        T__None,
        TChildToParentSynthesizeResponseArgs = 1,
        TResetInterceptionArgs,
        TCancelInterceptionArgs,
        T__Last = TCancelInterceptionArgs
    };

private:
    typedef ::mozilla::dom::ChildToParentSynthesizeResponseArgs ChildToParentSynthesizeResponseArgs;
    typedef ::mozilla::dom::ResetInterceptionArgs ResetInterceptionArgs;
    typedef ::mozilla::dom::CancelInterceptionArgs CancelInterceptionArgs;
    typedef ChildToParentSynthesizeResponseArgs ChildToParentSynthesizeResponseArgs__tdef;
    typedef ResetInterceptionArgs ResetInterceptionArgs__tdef;
    typedef CancelInterceptionArgs CancelInterceptionArgs__tdef;

    ChildToParentSynthesizeResponseArgs*
    ptr_ChildToParentSynthesizeResponseArgs()
    {
        return (&(mVChildToParentSynthesizeResponseArgs));
    }
    const ChildToParentSynthesizeResponseArgs*
    constptr_ChildToParentSynthesizeResponseArgs() const
    {
        return (&(mVChildToParentSynthesizeResponseArgs));
    }
    ResetInterceptionArgs*
    ptr_ResetInterceptionArgs()
    {
        return (&(mVResetInterceptionArgs));
    }
    const ResetInterceptionArgs*
    constptr_ResetInterceptionArgs() const
    {
        return (&(mVResetInterceptionArgs));
    }
    CancelInterceptionArgs*
    ptr_CancelInterceptionArgs()
    {
        return (&(mVCancelInterceptionArgs));
    }
    const CancelInterceptionArgs*
    constptr_CancelInterceptionArgs() const
    {
        return (&(mVCancelInterceptionArgs));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(const ChildToParentSynthesizeResponseArgs& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(ChildToParentSynthesizeResponseArgs&& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(const ResetInterceptionArgs& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(ResetInterceptionArgs&& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(const CancelInterceptionArgs& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(CancelInterceptionArgs&& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(const ChildToParentFetchEventRespondWithResult& aOther);

    MOZ_IMPLICIT ChildToParentFetchEventRespondWithResult(ChildToParentFetchEventRespondWithResult&& aOther);

    ~ChildToParentFetchEventRespondWithResult();

    Type
    type() const
    {
        return mType;
    }

    ChildToParentFetchEventRespondWithResult&
    operator=(const ChildToParentSynthesizeResponseArgs& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(ChildToParentSynthesizeResponseArgs&& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(const ResetInterceptionArgs& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(ResetInterceptionArgs&& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(const CancelInterceptionArgs& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(CancelInterceptionArgs&& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(const ChildToParentFetchEventRespondWithResult& aRhs);

    ChildToParentFetchEventRespondWithResult&
    operator=(ChildToParentFetchEventRespondWithResult&& aRhs);

    ChildToParentSynthesizeResponseArgs&
    get_ChildToParentSynthesizeResponseArgs()
    {
        AssertSanity(TChildToParentSynthesizeResponseArgs);
        return (*(ptr_ChildToParentSynthesizeResponseArgs()));
    }
    const ChildToParentSynthesizeResponseArgs&
    get_ChildToParentSynthesizeResponseArgs() const
    {
        AssertSanity(TChildToParentSynthesizeResponseArgs);
        return (*(constptr_ChildToParentSynthesizeResponseArgs()));
    }
    operator ChildToParentSynthesizeResponseArgs&()
    {
        return get_ChildToParentSynthesizeResponseArgs();
    }
    operator const ChildToParentSynthesizeResponseArgs&() const
    {
        return get_ChildToParentSynthesizeResponseArgs();
    }

    ResetInterceptionArgs&
    get_ResetInterceptionArgs()
    {
        AssertSanity(TResetInterceptionArgs);
        return (*(ptr_ResetInterceptionArgs()));
    }
    const ResetInterceptionArgs&
    get_ResetInterceptionArgs() const
    {
        AssertSanity(TResetInterceptionArgs);
        return (*(constptr_ResetInterceptionArgs()));
    }
    operator ResetInterceptionArgs&()
    {
        return get_ResetInterceptionArgs();
    }
    operator const ResetInterceptionArgs&() const
    {
        return get_ResetInterceptionArgs();
    }

    CancelInterceptionArgs&
    get_CancelInterceptionArgs()
    {
        AssertSanity(TCancelInterceptionArgs);
        return (*(ptr_CancelInterceptionArgs()));
    }
    const CancelInterceptionArgs&
    get_CancelInterceptionArgs() const
    {
        AssertSanity(TCancelInterceptionArgs);
        return (*(constptr_CancelInterceptionArgs()));
    }
    operator CancelInterceptionArgs&()
    {
        return get_CancelInterceptionArgs();
    }
    operator const CancelInterceptionArgs&() const
    {
        return get_CancelInterceptionArgs();
    }

private:
    union {
        ChildToParentSynthesizeResponseArgs mVChildToParentSynthesizeResponseArgs;
        ResetInterceptionArgs mVResetInterceptionArgs;
        CancelInterceptionArgs mVCancelInterceptionArgs;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ChildToParentFetchEventRespondWithResult>
{
    typedef ::mozilla::dom::ChildToParentFetchEventRespondWithResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ParentToParentFetchEventRespondWithResult|
//
namespace mozilla {
namespace dom {
class ParentToParentFetchEventRespondWithResult final
{
public:
    enum Type {
        T__None,
        TParentToParentSynthesizeResponseArgs = 1,
        TResetInterceptionArgs,
        TCancelInterceptionArgs,
        T__Last = TCancelInterceptionArgs
    };

private:
    typedef ::mozilla::dom::ParentToParentSynthesizeResponseArgs ParentToParentSynthesizeResponseArgs;
    typedef ::mozilla::dom::ResetInterceptionArgs ResetInterceptionArgs;
    typedef ::mozilla::dom::CancelInterceptionArgs CancelInterceptionArgs;
    typedef ParentToParentSynthesizeResponseArgs ParentToParentSynthesizeResponseArgs__tdef;
    typedef ResetInterceptionArgs ResetInterceptionArgs__tdef;
    typedef CancelInterceptionArgs CancelInterceptionArgs__tdef;

    ParentToParentSynthesizeResponseArgs*
    ptr_ParentToParentSynthesizeResponseArgs()
    {
        return (&(mVParentToParentSynthesizeResponseArgs));
    }
    const ParentToParentSynthesizeResponseArgs*
    constptr_ParentToParentSynthesizeResponseArgs() const
    {
        return (&(mVParentToParentSynthesizeResponseArgs));
    }
    ResetInterceptionArgs*
    ptr_ResetInterceptionArgs()
    {
        return (&(mVResetInterceptionArgs));
    }
    const ResetInterceptionArgs*
    constptr_ResetInterceptionArgs() const
    {
        return (&(mVResetInterceptionArgs));
    }
    CancelInterceptionArgs*
    ptr_CancelInterceptionArgs()
    {
        return (&(mVCancelInterceptionArgs));
    }
    const CancelInterceptionArgs*
    constptr_CancelInterceptionArgs() const
    {
        return (&(mVCancelInterceptionArgs));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(const ParentToParentSynthesizeResponseArgs& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(ParentToParentSynthesizeResponseArgs&& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(const ResetInterceptionArgs& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(ResetInterceptionArgs&& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(const CancelInterceptionArgs& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(CancelInterceptionArgs&& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(const ParentToParentFetchEventRespondWithResult& aOther);

    MOZ_IMPLICIT ParentToParentFetchEventRespondWithResult(ParentToParentFetchEventRespondWithResult&& aOther);

    ~ParentToParentFetchEventRespondWithResult();

    Type
    type() const
    {
        return mType;
    }

    ParentToParentFetchEventRespondWithResult&
    operator=(const ParentToParentSynthesizeResponseArgs& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(ParentToParentSynthesizeResponseArgs&& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(const ResetInterceptionArgs& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(ResetInterceptionArgs&& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(const CancelInterceptionArgs& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(CancelInterceptionArgs&& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(const ParentToParentFetchEventRespondWithResult& aRhs);

    ParentToParentFetchEventRespondWithResult&
    operator=(ParentToParentFetchEventRespondWithResult&& aRhs);

    ParentToParentSynthesizeResponseArgs&
    get_ParentToParentSynthesizeResponseArgs()
    {
        AssertSanity(TParentToParentSynthesizeResponseArgs);
        return (*(ptr_ParentToParentSynthesizeResponseArgs()));
    }
    const ParentToParentSynthesizeResponseArgs&
    get_ParentToParentSynthesizeResponseArgs() const
    {
        AssertSanity(TParentToParentSynthesizeResponseArgs);
        return (*(constptr_ParentToParentSynthesizeResponseArgs()));
    }
    operator ParentToParentSynthesizeResponseArgs&()
    {
        return get_ParentToParentSynthesizeResponseArgs();
    }
    operator const ParentToParentSynthesizeResponseArgs&() const
    {
        return get_ParentToParentSynthesizeResponseArgs();
    }

    ResetInterceptionArgs&
    get_ResetInterceptionArgs()
    {
        AssertSanity(TResetInterceptionArgs);
        return (*(ptr_ResetInterceptionArgs()));
    }
    const ResetInterceptionArgs&
    get_ResetInterceptionArgs() const
    {
        AssertSanity(TResetInterceptionArgs);
        return (*(constptr_ResetInterceptionArgs()));
    }
    operator ResetInterceptionArgs&()
    {
        return get_ResetInterceptionArgs();
    }
    operator const ResetInterceptionArgs&() const
    {
        return get_ResetInterceptionArgs();
    }

    CancelInterceptionArgs&
    get_CancelInterceptionArgs()
    {
        AssertSanity(TCancelInterceptionArgs);
        return (*(ptr_CancelInterceptionArgs()));
    }
    const CancelInterceptionArgs&
    get_CancelInterceptionArgs() const
    {
        AssertSanity(TCancelInterceptionArgs);
        return (*(constptr_CancelInterceptionArgs()));
    }
    operator CancelInterceptionArgs&()
    {
        return get_CancelInterceptionArgs();
    }
    operator const CancelInterceptionArgs&() const
    {
        return get_CancelInterceptionArgs();
    }

private:
    union {
        ParentToParentSynthesizeResponseArgs mVParentToParentSynthesizeResponseArgs;
        ResetInterceptionArgs mVResetInterceptionArgs;
        CancelInterceptionArgs mVCancelInterceptionArgs;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToParentFetchEventRespondWithResult>
{
    typedef ::mozilla::dom::ParentToParentFetchEventRespondWithResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerCheckScriptEvaluationOpResult|
//
namespace mozilla {
namespace dom {
class ServiceWorkerCheckScriptEvaluationOpResult final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerCheckScriptEvaluationOpResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerCheckScriptEvaluationOpResult(
            const bool& _workerScriptExecutedSuccessfully,
            const bool& _fetchHandlerWasAdded) :
        workerScriptExecutedSuccessfully_(_workerScriptExecutedSuccessfully),
        fetchHandlerWasAdded_(_fetchHandlerWasAdded)
    {
    }

    MOZ_IMPLICIT ServiceWorkerCheckScriptEvaluationOpResult(
            bool&& _workerScriptExecutedSuccessfully,
            bool&& _fetchHandlerWasAdded) :
        workerScriptExecutedSuccessfully_(std::move(_workerScriptExecutedSuccessfully)),
        fetchHandlerWasAdded_(std::move(_fetchHandlerWasAdded))
    {
    }

    bool&
    workerScriptExecutedSuccessfully()
    {
        return workerScriptExecutedSuccessfully_;
    }
    const bool&
    workerScriptExecutedSuccessfully() const
    {
        return workerScriptExecutedSuccessfully_;
    }

    bool&
    fetchHandlerWasAdded()
    {
        return fetchHandlerWasAdded_;
    }
    const bool&
    fetchHandlerWasAdded() const
    {
        return fetchHandlerWasAdded_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> workerScriptExecutedSuccessfully_;
    ::mozilla::ipc::IPDLStructMember<bool> fetchHandlerWasAdded_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerCheckScriptEvaluationOpResult>
{
    typedef ::mozilla::dom::ServiceWorkerCheckScriptEvaluationOpResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerFetchEventOpResult|
//
namespace mozilla {
namespace dom {
class ServiceWorkerFetchEventOpResult final
{
private:
    typedef ::nsresult nsresult;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerFetchEventOpResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerFetchEventOpResult(const nsresult& _rv) :
        rv_(_rv)
    {
    }

    MOZ_IMPLICIT ServiceWorkerFetchEventOpResult(nsresult&& _rv) :
        rv_(std::move(_rv))
    {
    }

    nsresult&
    rv()
    {
        return rv_;
    }
    const nsresult&
    rv() const
    {
        return rv_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsresult> rv_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerFetchEventOpResult>
{
    typedef ::mozilla::dom::ServiceWorkerFetchEventOpResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerExtensionAPIEventOpResult|
//
namespace mozilla {
namespace dom {
class ServiceWorkerExtensionAPIEventOpResult final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerExtensionAPIEventOpResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerExtensionAPIEventOpResult(const bool& _extensionAPIEventListenerWasAdded) :
        extensionAPIEventListenerWasAdded_(_extensionAPIEventListenerWasAdded)
    {
    }

    MOZ_IMPLICIT ServiceWorkerExtensionAPIEventOpResult(bool&& _extensionAPIEventListenerWasAdded) :
        extensionAPIEventListenerWasAdded_(std::move(_extensionAPIEventListenerWasAdded))
    {
    }

    bool&
    extensionAPIEventListenerWasAdded()
    {
        return extensionAPIEventListenerWasAdded_;
    }
    const bool&
    extensionAPIEventListenerWasAdded() const
    {
        return extensionAPIEventListenerWasAdded_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> extensionAPIEventListenerWasAdded_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerExtensionAPIEventOpResult>
{
    typedef ::mozilla::dom::ServiceWorkerExtensionAPIEventOpResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ServiceWorkerOpResult|
//
namespace mozilla {
namespace dom {
class ServiceWorkerOpResult final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TServiceWorkerCheckScriptEvaluationOpResult,
        TServiceWorkerFetchEventOpResult,
        TServiceWorkerExtensionAPIEventOpResult,
        T__Last = TServiceWorkerExtensionAPIEventOpResult
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::ServiceWorkerCheckScriptEvaluationOpResult ServiceWorkerCheckScriptEvaluationOpResult;
    typedef ::mozilla::dom::ServiceWorkerFetchEventOpResult ServiceWorkerFetchEventOpResult;
    typedef ::mozilla::dom::ServiceWorkerExtensionAPIEventOpResult ServiceWorkerExtensionAPIEventOpResult;
    typedef nsresult nsresult__tdef;
    typedef ServiceWorkerCheckScriptEvaluationOpResult ServiceWorkerCheckScriptEvaluationOpResult__tdef;
    typedef ServiceWorkerFetchEventOpResult ServiceWorkerFetchEventOpResult__tdef;
    typedef ServiceWorkerExtensionAPIEventOpResult ServiceWorkerExtensionAPIEventOpResult__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    ServiceWorkerCheckScriptEvaluationOpResult*
    ptr_ServiceWorkerCheckScriptEvaluationOpResult()
    {
        return (&(mVServiceWorkerCheckScriptEvaluationOpResult));
    }
    const ServiceWorkerCheckScriptEvaluationOpResult*
    constptr_ServiceWorkerCheckScriptEvaluationOpResult() const
    {
        return (&(mVServiceWorkerCheckScriptEvaluationOpResult));
    }
    ServiceWorkerFetchEventOpResult*
    ptr_ServiceWorkerFetchEventOpResult()
    {
        return (&(mVServiceWorkerFetchEventOpResult));
    }
    const ServiceWorkerFetchEventOpResult*
    constptr_ServiceWorkerFetchEventOpResult() const
    {
        return (&(mVServiceWorkerFetchEventOpResult));
    }
    ServiceWorkerExtensionAPIEventOpResult*
    ptr_ServiceWorkerExtensionAPIEventOpResult()
    {
        return (&(mVServiceWorkerExtensionAPIEventOpResult));
    }
    const ServiceWorkerExtensionAPIEventOpResult*
    constptr_ServiceWorkerExtensionAPIEventOpResult() const
    {
        return (&(mVServiceWorkerExtensionAPIEventOpResult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ServiceWorkerOpResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ServiceWorkerOpResult(const nsresult& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(nsresult&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(const ServiceWorkerCheckScriptEvaluationOpResult& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(ServiceWorkerCheckScriptEvaluationOpResult&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(const ServiceWorkerFetchEventOpResult& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(ServiceWorkerFetchEventOpResult&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(const ServiceWorkerExtensionAPIEventOpResult& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(ServiceWorkerExtensionAPIEventOpResult&& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(const ServiceWorkerOpResult& aOther);

    MOZ_IMPLICIT ServiceWorkerOpResult(ServiceWorkerOpResult&& aOther);

    ~ServiceWorkerOpResult();

    Type
    type() const
    {
        return mType;
    }

    ServiceWorkerOpResult&
    operator=(const nsresult& aRhs);

    ServiceWorkerOpResult&
    operator=(nsresult&& aRhs);

    ServiceWorkerOpResult&
    operator=(const ServiceWorkerCheckScriptEvaluationOpResult& aRhs);

    ServiceWorkerOpResult&
    operator=(ServiceWorkerCheckScriptEvaluationOpResult&& aRhs);

    ServiceWorkerOpResult&
    operator=(const ServiceWorkerFetchEventOpResult& aRhs);

    ServiceWorkerOpResult&
    operator=(ServiceWorkerFetchEventOpResult&& aRhs);

    ServiceWorkerOpResult&
    operator=(const ServiceWorkerExtensionAPIEventOpResult& aRhs);

    ServiceWorkerOpResult&
    operator=(ServiceWorkerExtensionAPIEventOpResult&& aRhs);

    ServiceWorkerOpResult&
    operator=(const ServiceWorkerOpResult& aRhs);

    ServiceWorkerOpResult&
    operator=(ServiceWorkerOpResult&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    ServiceWorkerCheckScriptEvaluationOpResult&
    get_ServiceWorkerCheckScriptEvaluationOpResult()
    {
        AssertSanity(TServiceWorkerCheckScriptEvaluationOpResult);
        return (*(ptr_ServiceWorkerCheckScriptEvaluationOpResult()));
    }
    const ServiceWorkerCheckScriptEvaluationOpResult&
    get_ServiceWorkerCheckScriptEvaluationOpResult() const
    {
        AssertSanity(TServiceWorkerCheckScriptEvaluationOpResult);
        return (*(constptr_ServiceWorkerCheckScriptEvaluationOpResult()));
    }
    operator ServiceWorkerCheckScriptEvaluationOpResult&()
    {
        return get_ServiceWorkerCheckScriptEvaluationOpResult();
    }
    operator const ServiceWorkerCheckScriptEvaluationOpResult&() const
    {
        return get_ServiceWorkerCheckScriptEvaluationOpResult();
    }

    ServiceWorkerFetchEventOpResult&
    get_ServiceWorkerFetchEventOpResult()
    {
        AssertSanity(TServiceWorkerFetchEventOpResult);
        return (*(ptr_ServiceWorkerFetchEventOpResult()));
    }
    const ServiceWorkerFetchEventOpResult&
    get_ServiceWorkerFetchEventOpResult() const
    {
        AssertSanity(TServiceWorkerFetchEventOpResult);
        return (*(constptr_ServiceWorkerFetchEventOpResult()));
    }
    operator ServiceWorkerFetchEventOpResult&()
    {
        return get_ServiceWorkerFetchEventOpResult();
    }
    operator const ServiceWorkerFetchEventOpResult&() const
    {
        return get_ServiceWorkerFetchEventOpResult();
    }

    ServiceWorkerExtensionAPIEventOpResult&
    get_ServiceWorkerExtensionAPIEventOpResult()
    {
        AssertSanity(TServiceWorkerExtensionAPIEventOpResult);
        return (*(ptr_ServiceWorkerExtensionAPIEventOpResult()));
    }
    const ServiceWorkerExtensionAPIEventOpResult&
    get_ServiceWorkerExtensionAPIEventOpResult() const
    {
        AssertSanity(TServiceWorkerExtensionAPIEventOpResult);
        return (*(constptr_ServiceWorkerExtensionAPIEventOpResult()));
    }
    operator ServiceWorkerExtensionAPIEventOpResult&()
    {
        return get_ServiceWorkerExtensionAPIEventOpResult();
    }
    operator const ServiceWorkerExtensionAPIEventOpResult&() const
    {
        return get_ServiceWorkerExtensionAPIEventOpResult();
    }

private:
    union {
        nsresult mVnsresult;
        ServiceWorkerCheckScriptEvaluationOpResult mVServiceWorkerCheckScriptEvaluationOpResult;
        ServiceWorkerFetchEventOpResult mVServiceWorkerFetchEventOpResult;
        ServiceWorkerExtensionAPIEventOpResult mVServiceWorkerExtensionAPIEventOpResult;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerOpResult>
{
    typedef ::mozilla::dom::ServiceWorkerOpResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef ServiceWorkerOpArgs_h
