//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gfx/PVRLayerParent.h"
#include "VRLayerChild.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"

#include "mozilla/gfx/PVRManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gfx {


MOZ_IMPLICIT PVRLayerParent::PVRLayerParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PVRLayerParent);
}

PVRLayerParent::~PVRLayerParent()
{
    MOZ_COUNT_DTOR(PVRLayerParent);
}

auto PVRLayerParent::ActorAlloc() -> void
{
}

auto PVRLayerParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PVRLayerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PVRLayerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PVRLayerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PVRLayerParent::Manager() const -> PVRManagerParent*
{
    return static_cast<PVRManagerParent*>(IProtocol::Manager());
}

auto PVRLayerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PVRLayerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PVRLayerParent::Send__delete__(PVRLayerParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PVRLayer::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PVRLayer", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVRLayerParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVRLayer::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PVRLayerParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PVRLayerParent::OnMessageReceived(const Message& msg__) -> PVRLayerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PVRLayer::Msg_SubmitFrame__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRLayer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRLayerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRLayer::Msg_SubmitFrame", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTexture = IPC::ReadParam<SurfaceDescriptor>((&(reader__)));
            if (!maybe__aTexture) {
                FatalError("Error deserializing 'SurfaceDescriptor'");
                return MsgValueError;

            }
            auto& aTexture = *maybe__aTexture;
            // Sentinel = 'aTexture'
            if ((!(((&(reader__)))->ReadSentinel(243925843)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SurfaceDescriptor'");
                return MsgValueError;
            }
            auto maybe__aFrameId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aFrameId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aFrameId = *maybe__aFrameId;
            // Sentinel = 'aFrameId'
            if ((!(((&(reader__)))->ReadSentinel(224658170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aLeftEyeRect = IPC::ReadParam<Rect>((&(reader__)));
            if (!maybe__aLeftEyeRect) {
                FatalError("Error deserializing 'Rect'");
                return MsgValueError;

            }
            auto& aLeftEyeRect = *maybe__aLeftEyeRect;
            // Sentinel = 'aLeftEyeRect'
            if ((!(((&(reader__)))->ReadSentinel(493290654)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Rect'");
                return MsgValueError;
            }
            auto maybe__aRightEyeRect = IPC::ReadParam<Rect>((&(reader__)));
            if (!maybe__aRightEyeRect) {
                FatalError("Error deserializing 'Rect'");
                return MsgValueError;

            }
            auto& aRightEyeRect = *maybe__aRightEyeRect;
            // Sentinel = 'aRightEyeRect'
            if ((!(((&(reader__)))->ReadSentinel(587597073)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Rect'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSubmitFrame(std::move(aTexture), std::move(aFrameId), std::move(aLeftEyeRect), std::move(aRightEyeRect));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVRLayer::Msg_Destroy__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVRLayer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVRLayerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVRLayer::Msg_Destroy", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDestroy();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVRLayer::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PVRLayerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PVRLayerParent::Result
{
    return MsgNotKnown;
}



} // namespace gfx
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gfx::PVRLayerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PVRLayer'
    (aWriter)->WriteSentinel(208995062);
}

auto ParamTraits<::mozilla::gfx::PVRLayerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PVRLayer actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PVRLayer'
    if ((!((aReader)->ReadSentinel(208995062)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PVRLayer actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PVRLayerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PVRLayer)");

        return {};
    }
    return static_cast<::mozilla::gfx::PVRLayerParent*>(actor);
}

} // namespace IPC
