//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/layers/PCompositorBridgeParent.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/gfx/2D.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorBridgeParent.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/LayersTypes.h"
#include "mozilla/layers/ScrollableLayerGuid.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "nsPoint.h"
#include "nsRect.h"

#include "mozilla/layers/PAPZParent.h"
#include "mozilla/layers/PAPZCTreeManagerParent.h"
#include "mozilla/dom/PBrowserParent.h"
#include "mozilla/layers/PCompositorManagerParent.h"
#include "mozilla/widget/PCompositorWidgetParent.h"
#include "mozilla/layers/PTextureParent.h"
#include "mozilla/layers/PWebRenderBridgeParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace layers {


auto PCompositorBridgeParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCompositorBridgeParent::RecvPCompositorWidgetConstructor(
        PCompositorWidgetParent* actor,
        const CompositorWidgetInitData& aInitData) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCompositorBridgeParent::RecvPAPZConstructor(
        PAPZParent* actor,
        const LayersId& layersId) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCompositorBridgeParent::RecvPAPZCTreeManagerConstructor(
        PAPZCTreeManagerParent* actor,
        const LayersId& layersId) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCompositorBridgeParent::RecvPTextureConstructor(
        PTextureParent* actor,
        const SurfaceDescriptor& aSharedData,
        ReadLockDescriptor&& aReadLock,
        const LayersBackend& aBackend,
        const TextureFlags& aTextureFlags,
        const LayersId& id,
        const uint64_t& aSerial,
        const MaybeExternalImageId& aExternalImageId) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCompositorBridgeParent::RecvPWebRenderBridgeConstructor(
        PWebRenderBridgeParent* actor,
        const PipelineId& pipelineId,
        const LayoutDeviceIntSize& aSize,
        const WindowKind& aKind) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PCompositorBridgeParent::PCompositorBridgeParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCompositorBridgeParent);
}

PCompositorBridgeParent::~PCompositorBridgeParent()
{
    MOZ_COUNT_DTOR(PCompositorBridgeParent);
}

auto PCompositorBridgeParent::ActorAlloc() -> void
{
    AddRef();
}

auto PCompositorBridgeParent::ActorDealloc() -> void
{
    Release();
}

auto PCompositorBridgeParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCompositorBridgeParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCompositorBridgeParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCompositorBridgeParent::Manager() const -> PCompositorManagerParent*
{
    return static_cast<PCompositorManagerParent*>(IProtocol::Manager());
}

auto PCompositorBridgeParent::ManagedPAPZParent(nsTArray<PAPZParent*>& aArr) const -> void
{
    mManagedPAPZParent.ToArray(aArr);
}

auto PCompositorBridgeParent::ManagedPAPZParent() const -> const ManagedContainer<PAPZParent>&
{
    return mManagedPAPZParent;
}

auto PCompositorBridgeParent::ManagedPAPZCTreeManagerParent(nsTArray<PAPZCTreeManagerParent*>& aArr) const -> void
{
    mManagedPAPZCTreeManagerParent.ToArray(aArr);
}

auto PCompositorBridgeParent::ManagedPAPZCTreeManagerParent() const -> const ManagedContainer<PAPZCTreeManagerParent>&
{
    return mManagedPAPZCTreeManagerParent;
}

auto PCompositorBridgeParent::ManagedPTextureParent(nsTArray<PTextureParent*>& aArr) const -> void
{
    mManagedPTextureParent.ToArray(aArr);
}

auto PCompositorBridgeParent::ManagedPTextureParent() const -> const ManagedContainer<PTextureParent>&
{
    return mManagedPTextureParent;
}

auto PCompositorBridgeParent::ManagedPCompositorWidgetParent(nsTArray<PCompositorWidgetParent*>& aArr) const -> void
{
    mManagedPCompositorWidgetParent.ToArray(aArr);
}

auto PCompositorBridgeParent::ManagedPCompositorWidgetParent() const -> const ManagedContainer<PCompositorWidgetParent>&
{
    return mManagedPCompositorWidgetParent;
}

auto PCompositorBridgeParent::ManagedPWebRenderBridgeParent(nsTArray<PWebRenderBridgeParent*>& aArr) const -> void
{
    mManagedPWebRenderBridgeParent.ToArray(aArr);
}

auto PCompositorBridgeParent::ManagedPWebRenderBridgeParent() const -> const ManagedContainer<PWebRenderBridgeParent>&
{
    return mManagedPWebRenderBridgeParent;
}

auto PCompositorBridgeParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PAPZMsgStart,
        PAPZCTreeManagerMsgStart,
        PTextureMsgStart,
        PCompositorWidgetMsgStart,
        PWebRenderBridgeMsgStart
    };
    return sIds;
}

auto PCompositorBridgeParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PAPZMsgStart:
        return (&(mManagedPAPZParent));
    case PAPZCTreeManagerMsgStart:
        return (&(mManagedPAPZCTreeManagerParent));
    case PTextureMsgStart:
        return (&(mManagedPTextureParent));
    case PCompositorWidgetMsgStart:
        return (&(mManagedPCompositorWidgetParent));
    case PWebRenderBridgeMsgStart:
        return (&(mManagedPWebRenderBridgeParent));
    default:
        return nullptr;
    }
}

auto PCompositorBridgeParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCompositorBridgeParent::OpenPAPZEndpoint(PAPZParent* aActor) -> ManagedEndpoint<PAPZChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAPZParent actor");
        return ManagedEndpoint<PAPZChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAPZParent actor");
        return ManagedEndpoint<PAPZChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAPZChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeParent::BindPAPZEndpoint(
        ManagedEndpoint<PAPZParent> aEndpoint,
        PAPZParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeParent::OpenPAPZCTreeManagerEndpoint(PAPZCTreeManagerParent* aActor) -> ManagedEndpoint<PAPZCTreeManagerChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAPZCTreeManagerParent actor");
        return ManagedEndpoint<PAPZCTreeManagerChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAPZCTreeManagerParent actor");
        return ManagedEndpoint<PAPZCTreeManagerChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAPZCTreeManagerChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeParent::BindPAPZCTreeManagerEndpoint(
        ManagedEndpoint<PAPZCTreeManagerParent> aEndpoint,
        PAPZCTreeManagerParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeParent::OpenPTextureEndpoint(PTextureParent* aActor) -> ManagedEndpoint<PTextureChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTextureParent actor");
        return ManagedEndpoint<PTextureChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTextureParent actor");
        return ManagedEndpoint<PTextureChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTextureChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeParent::BindPTextureEndpoint(
        ManagedEndpoint<PTextureParent> aEndpoint,
        PTextureParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeParent::OpenPCompositorWidgetEndpoint(PCompositorWidgetParent* aActor) -> ManagedEndpoint<PCompositorWidgetChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCompositorWidgetParent actor");
        return ManagedEndpoint<PCompositorWidgetChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCompositorWidgetParent actor");
        return ManagedEndpoint<PCompositorWidgetChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCompositorWidgetChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeParent::BindPCompositorWidgetEndpoint(
        ManagedEndpoint<PCompositorWidgetParent> aEndpoint,
        PCompositorWidgetParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeParent::OpenPWebRenderBridgeEndpoint(PWebRenderBridgeParent* aActor) -> ManagedEndpoint<PWebRenderBridgeChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebRenderBridgeParent actor");
        return ManagedEndpoint<PWebRenderBridgeChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebRenderBridgeParent actor");
        return ManagedEndpoint<PWebRenderBridgeChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebRenderBridgeChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeParent::BindPWebRenderBridgeEndpoint(
        ManagedEndpoint<PWebRenderBridgeParent> aEndpoint,
        PWebRenderBridgeParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeParent::SendDidComposite(
        const LayersId& id,
        mozilla::Span<TransactionId const> transactionId,
        const TimeStamp& compositeStart,
        const TimeStamp& compositeEnd) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_DidComposite(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), transactionId);
    // Sentinel = 'transactionId'
    ((&(writer__)))->WriteSentinel(642319700);
    IPC::WriteParam((&(writer__)), compositeStart);
    // Sentinel = 'compositeStart'
    ((&(writer__)))->WriteSentinel(740558306);
    IPC::WriteParam((&(writer__)), compositeEnd);
    // Sentinel = 'compositeEnd'
    ((&(writer__)))->WriteSentinel(547423467);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_DidComposite", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeParent::SendNotifyFrameStats(mozilla::Span<FrameStats const> aFrameStats) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_NotifyFrameStats(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aFrameStats);
    // Sentinel = 'aFrameStats'
    ((&(writer__)))->WriteSentinel(423756892);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyFrameStats", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeParent::SendParentAsyncMessages(mozilla::Span<AsyncParentMessageData const> aMessages) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_ParentAsyncMessages(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aMessages);
    // Sentinel = 'aMessages'
    ((&(writer__)))->WriteSentinel(293864346);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ParentAsyncMessages", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeParent::SendObserveLayersUpdate(
        const LayersId& aLayersId,
        const bool& aActive) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_ObserveLayersUpdate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aLayersId);
    // Sentinel = 'aLayersId'
    ((&(writer__)))->WriteSentinel(291439487);
    IPC::WriteParam((&(writer__)), aActive);
    // Sentinel = 'aActive'
    ((&(writer__)))->WriteSentinel(176095934);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ObserveLayersUpdate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeParent::SendCompositorOptionsChanged(
        const LayersId& id,
        const CompositorOptions& newOptions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_CompositorOptionsChanged(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), newOptions);
    // Sentinel = 'newOptions'
    ((&(writer__)))->WriteSentinel(384304183);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_CompositorOptionsChanged", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeParent::SendNotifyJankedAnimations(
        const LayersId& id,
        mozilla::Span<uint64_t const> aJankedAnimations) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_NotifyJankedAnimations(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), aJankedAnimations);
    // Sentinel = 'aJankedAnimations'
    ((&(writer__)))->WriteSentinel(985728706);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyJankedAnimations", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PAPZMsgStart:
        static_cast<CompositorBridgeParentBase*>(this)->DeallocPAPZParent(static_cast<PAPZParent*>(aListener));
        return;
    case PAPZCTreeManagerMsgStart:
        static_cast<CompositorBridgeParentBase*>(this)->DeallocPAPZCTreeManagerParent(static_cast<PAPZCTreeManagerParent*>(aListener));
        return;
    case PTextureMsgStart:
        static_cast<CompositorBridgeParentBase*>(this)->DeallocPTextureParent(static_cast<PTextureParent*>(aListener));
        return;
    case PWebRenderBridgeMsgStart:
        static_cast<CompositorBridgeParentBase*>(this)->DeallocPWebRenderBridgeParent(static_cast<PWebRenderBridgeParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PCompositorBridgeParent::OnMessageReceived(const Message& msg__) -> PCompositorBridgeParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCompositorBridge::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_PCompositorWidgetConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PCompositorWidgetConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aInitData = IPC::ReadParam<CompositorWidgetInitData>((&(reader__)));
            if (!maybe__aInitData) {
                FatalError("Error deserializing 'CompositorWidgetInitData'");
                return MsgValueError;

            }
            auto& aInitData = *maybe__aInitData;
            // Sentinel = 'aInitData'
            if ((!(((&(reader__)))->ReadSentinel(284296048)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositorWidgetInitData'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            RefPtr<PCompositorWidgetParent> actor = (static_cast<CompositorBridgeParentBase*>(this))->AllocPCompositorWidgetParent(aInitData);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvPCompositorWidgetConstructor(actor, std::move(aInitData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_PAPZConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PAPZConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__layersId = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__layersId) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& layersId = *maybe__layersId;
            // Sentinel = 'layersId'
            if ((!(((&(reader__)))->ReadSentinel(250938174)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            PAPZParent* actor = (static_cast<CompositorBridgeParentBase*>(this))->AllocPAPZParent(layersId);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvPAPZConstructor(std::move(actor), std::move(layersId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_PAPZCTreeManagerConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PAPZCTreeManagerConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__layersId = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__layersId) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& layersId = *maybe__layersId;
            // Sentinel = 'layersId'
            if ((!(((&(reader__)))->ReadSentinel(250938174)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            PAPZCTreeManagerParent* actor = (static_cast<CompositorBridgeParentBase*>(this))->AllocPAPZCTreeManagerParent(layersId);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvPAPZCTreeManagerConstructor(std::move(actor), std::move(layersId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_ResumeAsync__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ResumeAsync", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvResumeAsync();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_AdoptChild__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_AdoptChild", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvAdoptChild(std::move(id));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_NotifyMemoryPressure__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyMemoryPressure", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvNotifyMemoryPressure();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_FlushRenderingAsync__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_FlushRenderingAsync", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aReasons = IPC::ReadParam<RenderReasons>((&(reader__)));
            if (!maybe__aReasons) {
                FatalError("Error deserializing 'RenderReasons'");
                return MsgValueError;

            }
            auto& aReasons = *maybe__aReasons;
            // Sentinel = 'aReasons'
            if ((!(((&(reader__)))->ReadSentinel(234423101)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RenderReasons'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvFlushRenderingAsync(std::move(aReasons));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_ForcePresent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ForcePresent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aReasons = IPC::ReadParam<RenderReasons>((&(reader__)));
            if (!maybe__aReasons) {
                FatalError("Error deserializing 'RenderReasons'");
                return MsgValueError;

            }
            auto& aReasons = *maybe__aReasons;
            // Sentinel = 'aReasons'
            if ((!(((&(reader__)))->ReadSentinel(234423101)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RenderReasons'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvForcePresent(std::move(aReasons));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_PTextureConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PTextureConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aSharedData = IPC::ReadParam<SurfaceDescriptor>((&(reader__)));
            if (!maybe__aSharedData) {
                FatalError("Error deserializing 'SurfaceDescriptor'");
                return MsgValueError;

            }
            auto& aSharedData = *maybe__aSharedData;
            // Sentinel = 'aSharedData'
            if ((!(((&(reader__)))->ReadSentinel(420480051)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SurfaceDescriptor'");
                return MsgValueError;
            }
            auto maybe__aReadLock = IPC::ReadParam<ReadLockDescriptor>((&(reader__)));
            if (!maybe__aReadLock) {
                FatalError("Error deserializing 'ReadLockDescriptor'");
                return MsgValueError;

            }
            auto& aReadLock = *maybe__aReadLock;
            // Sentinel = 'aReadLock'
            if ((!(((&(reader__)))->ReadSentinel(279774055)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ReadLockDescriptor'");
                return MsgValueError;
            }
            auto maybe__aBackend = IPC::ReadParam<LayersBackend>((&(reader__)));
            if (!maybe__aBackend) {
                FatalError("Error deserializing 'LayersBackend'");
                return MsgValueError;

            }
            auto& aBackend = *maybe__aBackend;
            // Sentinel = 'aBackend'
            if ((!(((&(reader__)))->ReadSentinel(221119242)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersBackend'");
                return MsgValueError;
            }
            auto maybe__aTextureFlags = IPC::ReadParam<TextureFlags>((&(reader__)));
            if (!maybe__aTextureFlags) {
                FatalError("Error deserializing 'TextureFlags'");
                return MsgValueError;

            }
            auto& aTextureFlags = *maybe__aTextureFlags;
            // Sentinel = 'aTextureFlags'
            if ((!(((&(reader__)))->ReadSentinel(614139200)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TextureFlags'");
                return MsgValueError;
            }
            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            auto maybe__aSerial = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aSerial) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aSerial = *maybe__aSerial;
            // Sentinel = 'aSerial'
            if ((!(((&(reader__)))->ReadSentinel(181011138)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aExternalImageId = IPC::ReadParam<MaybeExternalImageId>((&(reader__)));
            if (!maybe__aExternalImageId) {
                FatalError("Error deserializing 'MaybeExternalImageId'");
                return MsgValueError;

            }
            auto& aExternalImageId = *maybe__aExternalImageId;
            // Sentinel = 'aExternalImageId'
            if ((!(((&(reader__)))->ReadSentinel(898172469)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MaybeExternalImageId'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            PTextureParent* actor = (static_cast<CompositorBridgeParentBase*>(this))->AllocPTextureParent(aSharedData, aReadLock, aBackend, aTextureFlags, id, aSerial, aExternalImageId);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvPTextureConstructor(std::move(actor), std::move(aSharedData), std::move(aReadLock), std::move(aBackend), std::move(aTextureFlags), std::move(id), std::move(aSerial), std::move(aExternalImageId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_PWebRenderBridgeConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PWebRenderBridgeConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__pipelineId = IPC::ReadParam<PipelineId>((&(reader__)));
            if (!maybe__pipelineId) {
                FatalError("Error deserializing 'PipelineId'");
                return MsgValueError;

            }
            auto& pipelineId = *maybe__pipelineId;
            // Sentinel = 'pipelineId'
            if ((!(((&(reader__)))->ReadSentinel(382731268)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PipelineId'");
                return MsgValueError;
            }
            auto maybe__aSize = IPC::ReadParam<LayoutDeviceIntSize>((&(reader__)));
            if (!maybe__aSize) {
                FatalError("Error deserializing 'LayoutDeviceIntSize'");
                return MsgValueError;

            }
            auto& aSize = *maybe__aSize;
            // Sentinel = 'aSize'
            if ((!(((&(reader__)))->ReadSentinel(97124861)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayoutDeviceIntSize'");
                return MsgValueError;
            }
            auto maybe__aKind = IPC::ReadParam<WindowKind>((&(reader__)));
            if (!maybe__aKind) {
                FatalError("Error deserializing 'WindowKind'");
                return MsgValueError;

            }
            auto& aKind = *maybe__aKind;
            // Sentinel = 'aKind'
            if ((!(((&(reader__)))->ReadSentinel(93389288)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WindowKind'");
                return MsgValueError;
            }
            reader__.EndRead();
            // Ensure the ID which was sent to us is valid, and reserve a spot
            // in the table for the new actor before we bother to alloc it.
            if (!ToplevelProtocol()->TryReserve(actorid__)) {
                NS_WARNING("Failed to reserve ActorId for constructor");
                return MsgValueError;
            }

            PWebRenderBridgeParent* actor = (static_cast<CompositorBridgeParentBase*>(this))->AllocPWebRenderBridgeParent(pipelineId, aSize, aKind);

            if (!actor) {
                NS_WARNING("Alloc function returned null");
                // Clean up the reservation taken above if this fails, to avoid
                // leaving zombie entries in the map.
                ToplevelProtocol()->ClearReservation(actorid__);
                return MsgValueError;
            }

            // NOTE: SetManagerAndRegister unconditionally consumes the
            // reservation taken by TryReserve, so we don't need to clear it on
            // failure.
            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to set manager for constructor");
                return MsgValueError;
            }
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvPWebRenderBridgeConstructor(std::move(actor), std::move(pipelineId), std::move(aSize), std::move(aKind));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_BeginRecording__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_BeginRecording", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aRecordingStart = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__aRecordingStart) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& aRecordingStart = *maybe__aRecordingStart;
            // Sentinel = 'aRecordingStart'
            if ((!(((&(reader__)))->ReadSentinel(794428941)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PCompositorBridge::Reply_BeginRecording(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            BeginRecordingResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'success'
                    ((&(writer__)))->WriteSentinel(200082170);

                    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PCompositorBridgeParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvBeginRecording(std::move(aRecordingStart), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_EndRecording__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_EndRecording", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PCompositorBridge::Reply_EndRecording(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            EndRecordingResolver resolver = [resolver__ = std::move(resolver__)](mozilla::Maybe<FrameRecording>&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'recording'
                    ((&(writer__)))->WriteSentinel(315229118);

                    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PCompositorBridgeParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvEndRecording(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_RequestFxrOutput__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_RequestFxrOutput", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvRequestFxrOutput();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_DynamicToolbarOffsetChanged__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_DynamicToolbarOffsetChanged", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aOffset = *maybe__aOffset;
            // Sentinel = 'aOffset'
            if ((!(((&(reader__)))->ReadSentinel(179634889)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvDynamicToolbarOffsetChanged(std::move(aOffset));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCompositorBridgeParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCompositorBridgeParent::Result
{
    switch (msg__.type()) {
    case PCompositorBridge::Msg_Initialize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_Initialize", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__rootLayerTreeId = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__rootLayerTreeId) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& rootLayerTreeId = *maybe__rootLayerTreeId;
            // Sentinel = 'rootLayerTreeId'
            if ((!(((&(reader__)))->ReadSentinel(828507647)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvInitialize(std::move(rootLayerTreeId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_Initialize(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_WillClose__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_WillClose", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvWillClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_WillClose(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_Pause__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_Pause", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvPause();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_Pause(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_Resume__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_Resume", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvResume();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_Resume(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_NotifyChildCreated__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyChildCreated", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            CompositorOptions compositorOptions{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvNotifyChildCreated(std::move(id), (&(compositorOptions)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_NotifyChildCreated(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), compositorOptions);
            // Sentinel = 'compositorOptions'
            ((&(writer__)))->WriteSentinel(1089275708);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_MapAndNotifyChildCreated__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_MapAndNotifyChildCreated", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            auto maybe__owner = IPC::ReadParam<ProcessId>((&(reader__)));
            if (!maybe__owner) {
                FatalError("Error deserializing 'ProcessId'");
                return MsgValueError;

            }
            auto& owner = *maybe__owner;
            // Sentinel = 'owner'
            if ((!(((&(reader__)))->ReadSentinel(110232108)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ProcessId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            CompositorOptions compositorOptions{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvMapAndNotifyChildCreated(std::move(id), std::move(owner), (&(compositorOptions)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_MapAndNotifyChildCreated(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), compositorOptions);
            // Sentinel = 'compositorOptions'
            ((&(writer__)))->WriteSentinel(1089275708);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_NotifyChildRecreated__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyChildRecreated", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            CompositorOptions compositorOptions{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvNotifyChildRecreated(std::move(id), (&(compositorOptions)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_NotifyChildRecreated(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), compositorOptions);
            // Sentinel = 'compositorOptions'
            ((&(writer__)))->WriteSentinel(1089275708);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_FlushRendering__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_FlushRendering", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aReasons = IPC::ReadParam<RenderReasons>((&(reader__)));
            if (!maybe__aReasons) {
                FatalError("Error deserializing 'RenderReasons'");
                return MsgValueError;

            }
            auto& aReasons = *maybe__aReasons;
            // Sentinel = 'aReasons'
            if ((!(((&(reader__)))->ReadSentinel(234423101)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RenderReasons'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvFlushRendering(std::move(aReasons));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_FlushRendering(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_WaitOnTransactionProcessed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_WaitOnTransactionProcessed", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvWaitOnTransactionProcessed();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_WaitOnTransactionProcessed(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_StartFrameTimeRecording__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_StartFrameTimeRecording", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__bufferSize = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__bufferSize) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& bufferSize = *maybe__bufferSize;
            // Sentinel = 'bufferSize'
            if ((!(((&(reader__)))->ReadSentinel(376243222)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            uint32_t startIndex{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvStartFrameTimeRecording(std::move(bufferSize), (&(startIndex)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_StartFrameTimeRecording(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), startIndex);
            // Sentinel = 'startIndex'
            ((&(writer__)))->WriteSentinel(386728999);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_StopFrameTimeRecording__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_StopFrameTimeRecording", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__startIndex = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__startIndex) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& startIndex = *maybe__startIndex;
            // Sentinel = 'startIndex'
            if ((!(((&(reader__)))->ReadSentinel(386728999)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            nsTArray<float> intervals{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvStopFrameTimeRecording(std::move(startIndex), (&(intervals)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_StopFrameTimeRecording(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), intervals);
            // Sentinel = 'intervals'
            ((&(writer__)))->WriteSentinel(322175961);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_SyncWithCompositor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_SyncWithCompositor", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvSyncWithCompositor();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_SyncWithCompositor(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_CheckAndClearWRDidRasterize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_CheckAndClearWRDidRasterize", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            bool didRasterize{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvCheckAndClearWRDidRasterize(std::move(id), (&(didRasterize)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_CheckAndClearWRDidRasterize(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), didRasterize);
            // Sentinel = 'didRasterize'
            ((&(writer__)))->WriteSentinel(524485867);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_CheckContentOnlyTDR__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_CheckContentOnlyTDR", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__sequenceNum = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__sequenceNum) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& sequenceNum = *maybe__sequenceNum;
            // Sentinel = 'sequenceNum'
            if ((!(((&(reader__)))->ReadSentinel(464127114)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            bool isContentOnlyTDR{};
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeParentBase*>(this))->RecvCheckContentOnlyTDR(std::move(sequenceNum), (&(isContentOnlyTDR)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCompositorBridge::Reply_CheckContentOnlyTDR(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), isContentOnlyTDR);
            // Sentinel = 'isContentOnlyTDR'
            ((&(writer__)))->WriteSentinel(919668292);
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace layers
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::layers::PCompositorBridgeParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCompositorBridge'
    (aWriter)->WriteSentinel(1013581517);
}

auto ParamTraits<::mozilla::layers::PCompositorBridgeParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCompositorBridge actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCompositorBridge'
    if ((!((aReader)->ReadSentinel(1013581517)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCompositorBridge actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCompositorBridgeMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCompositorBridge)");

        return {};
    }
    return static_cast<::mozilla::layers::PCompositorBridgeParent*>(actor);
}

} // namespace IPC
