/* THIS FILE IS AUTOGENERATED FROM Window.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AnimationFrameProviderBinding.h"
#include "AtomList.h"
#include "Crypto.h"
#include "Event.h"
#include "EventHandlerBinding.h"
#include "EventTargetBinding.h"
#include "FunctionBinding.h"
#include "ImageBitmapBinding.h"
#include "MainThreadUtils.h"
#include "MessagePortBinding.h"
#include "Navigation.h"
#include "Navigator.h"
#include "RequestBinding.h"
#include "WindowBinding.h"
#include "WindowOrWorkerGlobalScopeBinding.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "cache/CacheStorage.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/String.h"
#include "js/experimental/JitInfo.h"
#include "js/shadow/Object.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/BasePrincipal.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/UseCounter.h"
#include "mozilla/dom/BarProps.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Blob.h"
#include "mozilla/dom/BrowsingContext.h"
#include "mozilla/dom/CanvasRenderingContext2D.h"
#include "mozilla/dom/ChromeMessageBroadcaster.h"
#include "mozilla/dom/CookieStore.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/DocumentPictureInPicture.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/External.h"
#include "mozilla/dom/HTMLCanvasElement.h"
#include "mozilla/dom/HTMLImageElement.h"
#include "mozilla/dom/HTMLVideoElement.h"
#include "mozilla/dom/IDBFactory.h"
#include "mozilla/dom/IdleDeadline.h"
#include "mozilla/dom/ImageBitmap.h"
#include "mozilla/dom/ImageData.h"
#include "mozilla/dom/IntlUtils.h"
#include "mozilla/dom/Location.h"
#include "mozilla/dom/MediaQueryList.h"
#include "mozilla/dom/Navigation.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/OffscreenCanvas.h"
#include "mozilla/dom/Performance.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/Request.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/SVGImageElement.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/Selection.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/SpeechSynthesis.h"
#include "mozilla/dom/Storage.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TrustedScript.h"
#include "mozilla/dom/TrustedTypePolicyFactory.h"
#include "mozilla/dom/VideoFrame.h"
#include "mozilla/dom/VisualViewport.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/WebTaskScheduler.h"
#include "mozilla/dom/WindowGlobalChild.h"
#include "mozilla/dom/WindowProxyHolder.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "mozilla/dom/cache/CacheStorage.h"
#include "mozilla/glean/bindings/Glean.h"
#include "mozilla/glean/bindings/GleanPings.h"
#include "nsContentUtils.h"
#include "nsDOMCSSDeclaration.h"
#include "nsGenericHTMLElement.h"
#include "nsGlobalWindowInner.h"
#include "nsHistory.h"
#include "nsIBrowserDOMWindow.h"
#include "nsICSSDeclaration.h"
#include "nsIControllers.h"
#include "nsIDOMWindowUtils.h"
#include "nsIDocShell.h"
#include "nsIPrincipal.h"
#include "nsIPrintSettings.h"
#include "nsIWebProgressListener.h"
#include "nsJSPrincipals.h"
#include "nsJSUtils.h"
#include "nsScreen.h"
#include "nsWindowRoot.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<ScrollBehavior>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ScrollBehavior aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<ScrollBehavior>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<ScrollBehavior>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<ScrollBehavior>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningEventOrUndefined& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsEvent()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsEvent(), "mEvent", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningEventOrUndefined& aUnion)
{
  aUnion.Uninit();
}


bool
EventOrUndefined::TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::Event>& memberSlot = RawSetAsEvent();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Event, mozilla::dom::Event>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyEvent();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
EventOrUndefined::TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToEvent(cx, value, tryNext, passedToJSImpl);
}









bool
EventOrUndefined::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  if (value.isUndefined()) {
    SetUndefined();
  } else {
    bool done = false, failed = false, tryNext;
    if (value.isObject()) {
      done = (failed = !TrySetToEvent(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
    if (failed) {
      return false;
    }
    if (!done) {
      cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Event");
      return false;
    }
  }
  return true;
}

bool
EventOrUndefined::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
EventOrUndefined::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eEvent: {
      if (!GetOrCreateDOMReflector(cx, mValue.mEvent.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUndefined: {
      rval.setUndefined();
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningEventOrUndefined::OwningEventOrUndefined(OwningEventOrUndefined&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eEvent: {
      mType = eEvent;
      mValue.mEvent.SetValue(std::move(aOther.mValue.mEvent.Value()));
      break;
    }
    case eUndefined: {
      MOZ_ASSERT(mType == eUninitialized);
      mType = eUndefined;
      break;
    }
  }
}



bool
OwningEventOrUndefined::TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::Event>& memberSlot = RawSetAsEvent();
    static_assert(IsRefcounted<mozilla::dom::Event>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Event, mozilla::dom::Event>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyEvent();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningEventOrUndefined::TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToEvent(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::Event>&
OwningEventOrUndefined::RawSetAsEvent()
{
  if (mType == eEvent) {
    return mValue.mEvent.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eEvent;
  return mValue.mEvent.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::Event>&
OwningEventOrUndefined::SetAsEvent()
{
  if (mType == eEvent) {
    return mValue.mEvent.Value();
  }
  Uninit();
  mType = eEvent;
  return mValue.mEvent.SetValue();
}


void
OwningEventOrUndefined::DestroyEvent()
{
  MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
  mValue.mEvent.Destroy();
  mType = eUninitialized;
}





bool
OwningEventOrUndefined::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  if (value.isUndefined()) {
    SetUndefined();
  } else {
    bool done = false, failed = false, tryNext;
    if (value.isObject()) {
      done = (failed = !TrySetToEvent(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
    if (failed) {
      return false;
    }
    if (!done) {
      cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Event");
      return false;
    }
  }
  return true;
}

bool
OwningEventOrUndefined::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningEventOrUndefined::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eEvent: {
      DestroyEvent();
      break;
    }
    case eUndefined: {
      break;
    }
  }
}

bool
OwningEventOrUndefined::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eEvent: {
      if (!GetOrCreateDOMReflector(cx, mValue.mEvent.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUndefined: {
      rval.setUndefined();
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningEventOrUndefined&
OwningEventOrUndefined::operator=(OwningEventOrUndefined&& aOther)
{
  this->~OwningEventOrUndefined();
  new (this) OwningEventOrUndefined (std::move(aOther));
  return *this;
}


OwningEventOrUndefined&
OwningEventOrUndefined::operator=(const OwningEventOrUndefined& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eEvent: {
      SetAsEvent() = aOther.GetAsEvent();
      break;
    }
    case eUndefined: {
      MOZ_ASSERT(mType == eUninitialized);
      mType = eUndefined;
      break;
    }
  }
  return *this;
}


MOZ_CAN_RUN_SCRIPT void
IdleRequestCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, IdleDeadline& deadline, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, deadline, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}




IdleRequestOptions::IdleRequestOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
IdleRequestOptions::InitIds(JSContext* cx, IdleRequestOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->timeout_id.init(cx, "timeout")) {
    return false;
  }
  return true;
}

bool
IdleRequestOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  IdleRequestOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<IdleRequestOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->timeout_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTimeout.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'timeout' member of IdleRequestOptions", &(mTimeout.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
IdleRequestOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
IdleRequestOptions::TraceDictionary(JSTracer* trc)
{
}

IdleRequestOptions&
IdleRequestOptions::operator=(const IdleRequestOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mTimeout.Reset();
  if (aOther.mTimeout.WasPassed()) {
    mTimeout.Construct(aOther.mTimeout.Value());
  }
  return *this;
}


void
PromiseDocumentFlushedCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  JS::Rooted<JS::Value> rvalDecl(cx);
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunreachable-code-return"
#endif // __clang__
  if ((false) && !CallerSubsumes(rval)) {
    cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("return value of PromiseDocumentFlushedCallback");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
  rvalDecl = rval;
  aRetVal.set(rvalDecl);
}




ScrollOptions::ScrollOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
ScrollOptions::InitIds(JSContext* cx, ScrollOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->behavior_id.init(cx, "behavior")) {
    return false;
  }
  return true;
}

bool
ScrollOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  ScrollOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<ScrollOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->behavior_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ScrollBehavior>::Values,
                                                                         "ScrollBehavior", "'behavior' member of ScrollOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mBehavior = static_cast<ScrollBehavior>(index);
    }
  } else {
    mBehavior = ScrollBehavior::Auto;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
ScrollOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
ScrollOptions::TraceDictionary(JSTracer* trc)
{
}

ScrollOptions&
ScrollOptions::operator=(const ScrollOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mBehavior = aOther.mBehavior;
  return *this;
}



SizeToContentConstraints::SizeToContentConstraints()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SizeToContentConstraints::InitIds(JSContext* cx, SizeToContentConstraintsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->prefWidth_id.init(cx, "prefWidth") ||
      !atomsCache->maxWidth_id.init(cx, "maxWidth") ||
      !atomsCache->maxHeight_id.init(cx, "maxHeight")) {
    return false;
  }
  return true;
}

bool
SizeToContentConstraints::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SizeToContentConstraintsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SizeToContentConstraintsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxHeight_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'maxHeight' member of SizeToContentConstraints", &mMaxHeight)) {
      return false;
    }
  } else {
    mMaxHeight = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxWidth_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'maxWidth' member of SizeToContentConstraints", &mMaxWidth)) {
      return false;
    }
  } else {
    mMaxWidth = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->prefWidth_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'prefWidth' member of SizeToContentConstraints", &mPrefWidth)) {
      return false;
    }
  } else {
    mPrefWidth = 0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SizeToContentConstraints::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SizeToContentConstraints::TraceDictionary(JSTracer* trc)
{
}

SizeToContentConstraints&
SizeToContentConstraints::operator=(const SizeToContentConstraints& aOther)
{
  DictionaryBase::operator=(aOther);
  mMaxHeight = aOther.mMaxHeight;
  mMaxWidth = aOther.mMaxWidth;
  mPrefWidth = aOther.mPrefWidth;
  return *this;
}



SynthesizeEventData::SynthesizeEventData()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SynthesizeEventData::InitIds(JSContext* cx, SynthesizeEventDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->identifier_id.init(cx, "identifier")) {
    return false;
  }
  return true;
}

bool
SynthesizeEventData::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SynthesizeEventDataAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SynthesizeEventDataAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->identifier_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'identifier' member of SynthesizeEventData", &mIdentifier)) {
      return false;
    }
  } else {
    mIdentifier = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SynthesizeEventData::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SynthesizeEventData::TraceDictionary(JSTracer* trc)
{
}

SynthesizeEventData&
SynthesizeEventData::operator=(const SynthesizeEventData& aOther)
{
  DictionaryBase::operator=(aOther);
  mIdentifier = aOther.mIdentifier;
  return *this;
}



SynthesizeEventOptions::SynthesizeEventOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SynthesizeEventOptions::InitIds(JSContext* cx, SynthesizeEventOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->toWindow_id.init(cx, "toWindow") ||
      !atomsCache->isDOMEventSynthesized_id.init(cx, "isDOMEventSynthesized") ||
      !atomsCache->isAsyncEnabled_id.init(cx, "isAsyncEnabled")) {
    return false;
  }
  return true;
}

bool
SynthesizeEventOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SynthesizeEventOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SynthesizeEventOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->isAsyncEnabled_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'isAsyncEnabled' member of SynthesizeEventOptions", &mIsAsyncEnabled)) {
      return false;
    }
  } else {
    mIsAsyncEnabled = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->isDOMEventSynthesized_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'isDOMEventSynthesized' member of SynthesizeEventOptions", &mIsDOMEventSynthesized)) {
      return false;
    }
  } else {
    mIsDOMEventSynthesized = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->toWindow_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'toWindow' member of SynthesizeEventOptions", &mToWindow)) {
      return false;
    }
  } else {
    mToWindow = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SynthesizeEventOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SynthesizeEventOptions::TraceDictionary(JSTracer* trc)
{
}

SynthesizeEventOptions&
SynthesizeEventOptions::operator=(const SynthesizeEventOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mIsAsyncEnabled = aOther.mIsAsyncEnabled;
  mIsDOMEventSynthesized = aOther.mIsDOMEventSynthesized;
  mToWindow = aOther.mToWindow;
  return *this;
}



WindowPostMessageOptions::WindowPostMessageOptions()
  : StructuredSerializeOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
WindowPostMessageOptions::InitIds(JSContext* cx, WindowPostMessageOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->targetOrigin_id.init(cx, "targetOrigin")) {
    return false;
  }
  return true;
}

bool
WindowPostMessageOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  WindowPostMessageOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<WindowPostMessageOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!StructuredSerializeOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->targetOrigin_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mTargetOrigin)) {
      return false;
    }
    if (!NormalizeUSVString(mTargetOrigin)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    mTargetOrigin.AssignLiteral(u"/");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
WindowPostMessageOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
WindowPostMessageOptions::TraceDictionary(JSTracer* trc)
{
  StructuredSerializeOptions::TraceDictionary(trc);
}



ScrollToOptions::ScrollToOptions()
  : ScrollOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
ScrollToOptions::InitIds(JSContext* cx, ScrollToOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->top_id.init(cx, "top") ||
      !atomsCache->left_id.init(cx, "left")) {
    return false;
  }
  return true;
}

bool
ScrollToOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  ScrollToOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<ScrollToOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!ScrollOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->left_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mLeft.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'left' member of ScrollToOptions", &(mLeft.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->top_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTop.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'top' member of ScrollToOptions", &(mTop.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
ScrollToOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
ScrollToOptions::TraceDictionary(JSTracer* trc)
{
  ScrollOptions::TraceDictionary(trc);
}

ScrollToOptions&
ScrollToOptions::operator=(const ScrollToOptions& aOther)
{
  ScrollOptions::operator=(aOther);
  mLeft.Reset();
  if (aOther.mLeft.WasPassed()) {
    mLeft.Construct(aOther.mLeft.Value());
  }
  mTop.Reset();
  if (aOther.mTop.WasPassed()) {
    mTop.Construct(aOther.mTop.Value());
  }
  return *this;
}



SynthesizeMouseEventData::SynthesizeMouseEventData()
  : SynthesizeEventData(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SynthesizeMouseEventData::InitIds(JSContext* cx, SynthesizeMouseEventDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->pressure_id.init(cx, "pressure") ||
      !atomsCache->modifiers_id.init(cx, "modifiers") ||
      !atomsCache->inputSource_id.init(cx, "inputSource") ||
      !atomsCache->clickCount_id.init(cx, "clickCount") ||
      !atomsCache->buttons_id.init(cx, "buttons") ||
      !atomsCache->button_id.init(cx, "button")) {
    return false;
  }
  return true;
}

bool
SynthesizeMouseEventData::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SynthesizeMouseEventDataAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SynthesizeMouseEventDataAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!SynthesizeEventData::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->button_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'button' member of SynthesizeMouseEventData", &mButton)) {
      return false;
    }
  } else {
    mButton = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->buttons_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mButtons.Construct();
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'buttons' member of SynthesizeMouseEventData", &(mButtons.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->clickCount_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mClickCount.Construct();
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'clickCount' member of SynthesizeMouseEventData", &(mClickCount.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->inputSource_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int16_t, eDefault>(cx, temp.ref(), "'inputSource' member of SynthesizeMouseEventData", &mInputSource)) {
      return false;
    }
  } else {
    mInputSource = 1;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->modifiers_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'modifiers' member of SynthesizeMouseEventData", &mModifiers)) {
      return false;
    }
  } else {
    mModifiers = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->pressure_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'pressure' member of SynthesizeMouseEventData", &mPressure)) {
      return false;
    } else if (!std::isfinite(mPressure)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'pressure' member of SynthesizeMouseEventData");
      return false;
    }
  } else {
    mPressure = 0.0F;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SynthesizeMouseEventData::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SynthesizeMouseEventData::TraceDictionary(JSTracer* trc)
{
  SynthesizeEventData::TraceDictionary(trc);
}

SynthesizeMouseEventData&
SynthesizeMouseEventData::operator=(const SynthesizeMouseEventData& aOther)
{
  SynthesizeEventData::operator=(aOther);
  mButton = aOther.mButton;
  mButtons.Reset();
  if (aOther.mButtons.WasPassed()) {
    mButtons.Construct(aOther.mButtons.Value());
  }
  mClickCount.Reset();
  if (aOther.mClickCount.WasPassed()) {
    mClickCount.Construct(aOther.mClickCount.Value());
  }
  mInputSource = aOther.mInputSource;
  mModifiers = aOther.mModifiers;
  mPressure = aOther.mPressure;
  return *this;
}



SynthesizeMouseEventOptions::SynthesizeMouseEventOptions()
  : SynthesizeEventOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SynthesizeMouseEventOptions::InitIds(JSContext* cx, SynthesizeMouseEventOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->isWidgetEventSynthesized_id.init(cx, "isWidgetEventSynthesized") ||
      !atomsCache->ignoreRootScrollFrame_id.init(cx, "ignoreRootScrollFrame")) {
    return false;
  }
  return true;
}

bool
SynthesizeMouseEventOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SynthesizeMouseEventOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SynthesizeMouseEventOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!SynthesizeEventOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->ignoreRootScrollFrame_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'ignoreRootScrollFrame' member of SynthesizeMouseEventOptions", &mIgnoreRootScrollFrame)) {
      return false;
    }
  } else {
    mIgnoreRootScrollFrame = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->isWidgetEventSynthesized_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'isWidgetEventSynthesized' member of SynthesizeMouseEventOptions", &mIsWidgetEventSynthesized)) {
      return false;
    }
  } else {
    mIsWidgetEventSynthesized = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SynthesizeMouseEventOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SynthesizeMouseEventOptions::TraceDictionary(JSTracer* trc)
{
  SynthesizeEventOptions::TraceDictionary(trc);
}

SynthesizeMouseEventOptions&
SynthesizeMouseEventOptions::operator=(const SynthesizeMouseEventOptions& aOther)
{
  SynthesizeEventOptions::operator=(aOther);
  mIgnoreRootScrollFrame = aOther.mIgnoreRootScrollFrame;
  mIsWidgetEventSynthesized = aOther.mIsWidgetEventSynthesized;
  return *this;
}



SynthesizeTouchEventData::SynthesizeTouchEventData()
  : SynthesizeEventData(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SynthesizeTouchEventData::InitIds(JSContext* cx, SynthesizeTouchEventDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->twist_id.init(cx, "twist") ||
      !atomsCache->tiltY_id.init(cx, "tiltY") ||
      !atomsCache->tiltX_id.init(cx, "tiltX") ||
      !atomsCache->rotationAngle_id.init(cx, "rotationAngle") ||
      !atomsCache->radiiY_id.init(cx, "radiiY") ||
      !atomsCache->radiiX_id.init(cx, "radiiX") ||
      !atomsCache->pressure_id.init(cx, "pressure") ||
      !atomsCache->offsetY_id.init(cx, "offsetY") ||
      !atomsCache->offsetX_id.init(cx, "offsetX") ||
      !atomsCache->azimuthAngle_id.init(cx, "azimuthAngle") ||
      !atomsCache->altitudeAngle_id.init(cx, "altitudeAngle")) {
    return false;
  }
  return true;
}

bool
SynthesizeTouchEventData::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SynthesizeTouchEventDataAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SynthesizeTouchEventDataAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!SynthesizeEventData::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->altitudeAngle_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAltitudeAngle.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'altitudeAngle' member of SynthesizeTouchEventData", &(mAltitudeAngle.Value()))) {
      return false;
    } else if (!std::isfinite((mAltitudeAngle.Value()))) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'altitudeAngle' member of SynthesizeTouchEventData");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->azimuthAngle_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAzimuthAngle.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'azimuthAngle' member of SynthesizeTouchEventData", &(mAzimuthAngle.Value()))) {
      return false;
    } else if (!std::isfinite((mAzimuthAngle.Value()))) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'azimuthAngle' member of SynthesizeTouchEventData");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->offsetX_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'offsetX' member of SynthesizeTouchEventData", &mOffsetX)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'offsetX' member of SynthesizeTouchEventData");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->offsetY_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'offsetY' member of SynthesizeTouchEventData", &mOffsetY)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'offsetY' member of SynthesizeTouchEventData");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->pressure_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'pressure' member of SynthesizeTouchEventData", &mPressure)) {
      return false;
    } else if (!std::isfinite(mPressure)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'pressure' member of SynthesizeTouchEventData");
      return false;
    }
  } else {
    mPressure = 1.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->radiiX_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'radiiX' member of SynthesizeTouchEventData", &mRadiiX)) {
      return false;
    }
  } else {
    mRadiiX = 1U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->radiiY_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'radiiY' member of SynthesizeTouchEventData", &mRadiiY)) {
      return false;
    }
  } else {
    mRadiiY = 1U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->rotationAngle_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'rotationAngle' member of SynthesizeTouchEventData", &mRotationAngle)) {
      return false;
    } else if (!std::isfinite(mRotationAngle)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'rotationAngle' member of SynthesizeTouchEventData");
      return false;
    }
  } else {
    mRotationAngle = 0.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->tiltX_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'tiltX' member of SynthesizeTouchEventData", &mTiltX)) {
      return false;
    }
  } else {
    mTiltX = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->tiltY_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'tiltY' member of SynthesizeTouchEventData", &mTiltY)) {
      return false;
    }
  } else {
    mTiltY = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->twist_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'twist' member of SynthesizeTouchEventData", &mTwist)) {
      return false;
    }
  } else {
    mTwist = 0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SynthesizeTouchEventData::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SynthesizeTouchEventData::TraceDictionary(JSTracer* trc)
{
  SynthesizeEventData::TraceDictionary(trc);
}

SynthesizeTouchEventData&
SynthesizeTouchEventData::operator=(const SynthesizeTouchEventData& aOther)
{
  SynthesizeEventData::operator=(aOther);
  mAltitudeAngle.Reset();
  if (aOther.mAltitudeAngle.WasPassed()) {
    mAltitudeAngle.Construct(aOther.mAltitudeAngle.Value());
  }
  mAzimuthAngle.Reset();
  if (aOther.mAzimuthAngle.WasPassed()) {
    mAzimuthAngle.Construct(aOther.mAzimuthAngle.Value());
  }
  mOffsetX = aOther.mOffsetX;
  mOffsetY = aOther.mOffsetY;
  mPressure = aOther.mPressure;
  mRadiiX = aOther.mRadiiX;
  mRadiiY = aOther.mRadiiY;
  mRotationAngle = aOther.mRotationAngle;
  mTiltX = aOther.mTiltX;
  mTiltY = aOther.mTiltY;
  mTwist = aOther.mTwist;
  return *this;
}



SynthesizeTouchEventOptions::SynthesizeTouchEventOptions()
  : SynthesizeEventOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SynthesizeTouchEventOptions::InitIds(JSContext* cx, SynthesizeTouchEventOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->isPen_id.init(cx, "isPen")) {
    return false;
  }
  return true;
}

bool
SynthesizeTouchEventOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SynthesizeTouchEventOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SynthesizeTouchEventOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!SynthesizeEventOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->isPen_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'isPen' member of SynthesizeTouchEventOptions", &mIsPen)) {
      return false;
    }
  } else {
    mIsPen = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SynthesizeTouchEventOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SynthesizeTouchEventOptions::TraceDictionary(JSTracer* trc)
{
  SynthesizeEventOptions::TraceDictionary(trc);
}

SynthesizeTouchEventOptions&
SynthesizeTouchEventOptions::operator=(const SynthesizeTouchEventOptions& aOther)
{
  SynthesizeEventOptions::operator=(aOther);
  mIsPen = aOther.mIsPen;
  return *this;
}


namespace Window_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<EventTarget_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

static bool
get_window(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "window", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      WindowProxyHolder result(MOZ_KnownLive(self)->Window());
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!WrapObject(cx, result, args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // Have to either root across the getter call or reget after.
  JS::Rooted<JSObject*> slotStorage(cx, js::UncheckedUnwrap(obj, /* stopAtWindowProxy = */ false));
  MOZ_ASSERT(IsDOMObject(slotStorage));
  const size_t slotIndex = (DOM_INSTANCE_RESERVED_SLOTS + 0);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapValue(cx, args.rval());
    }
  }

  WindowProxyHolder result(MOZ_KnownLive(self)->Window());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping
      if (!WrapObject(cx, result, args.rval())) {
        return false;
      }
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapValue(cx, args.rval());
}

static const JSJitInfo window_getterinfo = {
  { get_window },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  true, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 5, "There is no slot for us");

static bool
get_self(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "self", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      WindowProxyHolder result(MOZ_KnownLive(self)->Self());
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!WrapObject(cx, result, args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // Have to either root across the getter call or reget after.
  JS::Rooted<JSObject*> slotStorage(cx, js::UncheckedUnwrap(obj, /* stopAtWindowProxy = */ false));
  MOZ_ASSERT(IsDOMObject(slotStorage));
  const size_t slotIndex = (DOM_INSTANCE_RESERVED_SLOTS + 1);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapValue(cx, args.rval());
    }
  }

  WindowProxyHolder result(MOZ_KnownLive(self)->Self());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping
      if (!WrapObject(cx, result, args.rval())) {
        return false;
      }
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapValue(cx, args.rval());
}

MOZ_CAN_RUN_SCRIPT static bool
set_self(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "self", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "self", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo self_getterinfo = {
  { get_self },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  true, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 1)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 1) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 1) < 5, "There is no slot for us");
static const JSJitInfo self_setterinfo = {
  { (JSJitGetterOp)set_self },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static bool
get_document(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "document", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // Have to either root across the getter call or reget after.
  JS::Rooted<JSObject*> slotStorage(cx, js::UncheckedUnwrap(obj, /* stopAtWindowProxy = */ false));
  MOZ_ASSERT(IsDOMObject(slotStorage));
  const size_t slotIndex = (DOM_INSTANCE_RESERVED_SLOTS + 2);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapValue(cx, args.rval());
    }
  }

  auto result(StrongOrRawPtr<mozilla::dom::Document>(MOZ_KnownLive(self)->GetDocument()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping
      if (!result) {
        args.rval().setNull();
        break;
      }
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapValue(cx, args.rval());
}

static const JSJitInfo document_getterinfo = {
  { get_document },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  true, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 2)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 2) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 2) < 5, "There is no slot for us");

MOZ_CAN_RUN_SCRIPT static bool
get_name(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "name", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetName(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetName(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.name getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_name(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "name", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetName(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetName(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.name setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo name_getterinfo = {
  { get_name },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo name_setterinfo = {
  { (JSJitGetterOp)set_name },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_location(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "location", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      JS::Rooted<JSObject*> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Location(cx, &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Location(cx, &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.location getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeObjectToActiveJS(result);
      args.rval().setObject(*result);
      if (!MaybeWrapObjectValue(cx, args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Location>(MOZ_KnownLive(self)->Location()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_location(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "Window.location setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "location", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::Rooted<JS::Value> v(cx);
  if (!JS_GetProperty(cx, obj, "location", &v)) {
    return false;
  }

  if (!v.isObject()) {
    return cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Window.location");
  }

  JS::Rooted<JSObject*> targetObj(cx, &v.toObject());
  return JS_SetProperty(cx, targetObj, "href", args[0]);
}

static const JSJitInfo location_getterinfo = {
  { get_location },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo location_setterinfo = {
  { (JSJitGetterOp)set_location },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_history(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "history", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsHistory>(MOZ_KnownLive(self)->GetHistory(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.history getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo history_getterinfo = {
  { get_history },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_navigation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "navigation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Navigation>(MOZ_KnownLive(self)->Navigation()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_navigation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "navigation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "navigation", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo navigation_getterinfo = {
  { get_navigation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo navigation_setterinfo = {
  { (JSJitGetterOp)set_navigation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_customElements(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "customElements", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::CustomElementRegistry>(MOZ_KnownLive(self)->CustomElements()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo customElements_getterinfo = {
  { get_customElements },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_locationbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "locationbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::BarProp>(MOZ_KnownLive(self)->GetLocationbar(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.locationbar getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_locationbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "locationbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "locationbar", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo locationbar_getterinfo = {
  { get_locationbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo locationbar_setterinfo = {
  { (JSJitGetterOp)set_locationbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_menubar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "menubar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::BarProp>(MOZ_KnownLive(self)->GetMenubar(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.menubar getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_menubar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "menubar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "menubar", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo menubar_getterinfo = {
  { get_menubar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo menubar_setterinfo = {
  { (JSJitGetterOp)set_menubar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_personalbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "personalbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::BarProp>(MOZ_KnownLive(self)->GetPersonalbar(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.personalbar getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_personalbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "personalbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "personalbar", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo personalbar_getterinfo = {
  { get_personalbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo personalbar_setterinfo = {
  { (JSJitGetterOp)set_personalbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollbars(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollbars", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::BarProp>(MOZ_KnownLive(self)->GetScrollbars(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollbars getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollbars(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollbars", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "scrollbars", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo scrollbars_getterinfo = {
  { get_scrollbars },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollbars_setterinfo = {
  { (JSJitGetterOp)set_scrollbars },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_statusbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "statusbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::BarProp>(MOZ_KnownLive(self)->GetStatusbar(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.statusbar getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_statusbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "statusbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "statusbar", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo statusbar_getterinfo = {
  { get_statusbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo statusbar_setterinfo = {
  { (JSJitGetterOp)set_statusbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_toolbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "toolbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::BarProp>(MOZ_KnownLive(self)->GetToolbar(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.toolbar getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_toolbar(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "toolbar", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "toolbar", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo toolbar_getterinfo = {
  { get_toolbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo toolbar_setterinfo = {
  { (JSJitGetterOp)set_toolbar },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_status(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "status", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetStatus(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetStatus(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.status getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_status(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "status", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetStatus(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetStatus(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.status setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo status_getterinfo = {
  { get_status },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo status_setterinfo = {
  { (JSJitGetterOp)set_status },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
close(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "close", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  // CrossOriginThisPolicy::UnwrapThisObject stores a nsGlobalWindowInner::RemoteProxy in void_self
  // if obj is a proxy with a RemoteObjectProxy handler for the right type, or else it stores
  // a nsGlobalWindowInner. If we get here from the JIT (without going through UnwrapThisObject) we
  // know void_self contains a nsGlobalWindowInner; we don't have special cases in the JIT to deal
  // with remote object proxies.
  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      auto* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Close(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Close(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.close"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Close(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Close(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.close"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo close_methodinfo = {
  { (JSJitGetterOp)close },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_closed(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "closed", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      bool result(MOZ_KnownLive(self)->GetClosed(rv));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.closed getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->GetClosed(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.closed getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo closed_getterinfo = {
  { get_closed },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "stop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Stop(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Stop(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.stop"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stop_methodinfo = {
  { (JSJitGetterOp)stop },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
focus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "focus", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  // CrossOriginThisPolicy::UnwrapThisObject stores a nsGlobalWindowInner::RemoteProxy in void_self
  // if obj is a proxy with a RemoteObjectProxy handler for the right type, or else it stores
  // a nsGlobalWindowInner. If we get here from the JIT (without going through UnwrapThisObject) we
  // know void_self contains a nsGlobalWindowInner; we don't have special cases in the JIT to deal
  // with remote object proxies.
  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      auto* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Focus(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Focus(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.focus"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Focus(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Focus(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.focus"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo focus_methodinfo = {
  { (JSJitGetterOp)focus },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blur(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "blur", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  // CrossOriginThisPolicy::UnwrapThisObject stores a nsGlobalWindowInner::RemoteProxy in void_self
  // if obj is a proxy with a RemoteObjectProxy handler for the right type, or else it stores
  // a nsGlobalWindowInner. If we get here from the JIT (without going through UnwrapThisObject) we
  // know void_self contains a nsGlobalWindowInner; we don't have special cases in the JIT to deal
  // with remote object proxies.
  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      auto* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Blur(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Blur(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.blur"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Blur(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Blur(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.blur"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blur_methodinfo = {
  { (JSJitGetterOp)blur },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_event(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "event", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  OwningEventOrUndefined result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetEvent(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetEvent(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_event(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "event", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "event", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo event_getterinfo = {
  { get_event },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo event_setterinfo = {
  { (JSJitGetterOp)set_event },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_frames(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "frames", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      WindowProxyHolder result(MOZ_KnownLive(self)->GetFrames(rv));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.frames getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!WrapObject(cx, result, args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  WindowProxyHolder result(MOZ_KnownLive(self)->GetFrames(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.frames getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!WrapObject(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_frames(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "frames", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "frames", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo frames_getterinfo = {
  { get_frames },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo frames_setterinfo = {
  { (JSJitGetterOp)set_frames },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      uint32_t result(MOZ_KnownLive(self)->Length());
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setNumber(result);
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Length());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "length", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo length_getterinfo = {
  { get_length },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo length_setterinfo = {
  { (JSJitGetterOp)set_length },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_top(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "top", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->GetTop(rv));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.top getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (result.IsNull()) {
        args.rval().setNull();
        return true;
      }
      if (!WrapObject(cx, result.Value(), args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->GetTop(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.top getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result.Value(), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo top_getterinfo = {
  { get_top },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_opener(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "opener", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetOpener(cx, &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->GetOpener(cx, &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.opener getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetOpener(cx, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetOpener(cx, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.opener getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_opener(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "opener", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  JS::Rooted<JS::Value> arg0(cx);
  arg0 = args[0];
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOpener(cx, arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOpener(cx, arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.opener setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo opener_getterinfo = {
  { get_opener },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo opener_setterinfo = {
  { (JSJitGetterOp)set_opener },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_parent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "parent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      FastErrorResult rv;
      Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->GetParent(rv));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.parent getter"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (result.IsNull()) {
        args.rval().setNull();
        return true;
      }
      if (!WrapObject(cx, result.Value(), args.rval())) {
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->GetParent(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.parent getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result.Value(), args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_parent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "parent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "parent", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo parent_getterinfo = {
  { get_parent },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo parent_setterinfo = {
  { (JSJitGetterOp)set_parent },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_frameElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "frameElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  NonNull<nsIPrincipal> subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);

    subjectPrincipal = principal;
  }
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetFrameElement(MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.frameElement getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo frameElement_getterinfo = {
  { get_frameElement },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
open(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "open", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
    if (!NormalizeUSVString(arg0)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  binding_detail::FakeString<char16_t> arg1;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
      return false;
    }
  } else {
    arg1.AssignLiteral(u"");
  }
  binding_detail::FakeString<char16_t> arg2;
  if (args.hasDefined(2)) {
    if (!ConvertJSValueToString(cx, args[2], eEmpty, eStringify, arg2)) {
      return false;
    }
  } else {
    arg2.AssignLiteral(u"");
  }
  FastErrorResult rv;
  Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->Open(Constify(arg0), NonNullHelper(Constify(arg1)), NonNullHelper(Constify(arg2)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.open"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result.Value(), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo open_methodinfo = {
  { (JSJitGetterOp)open },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_navigator(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "navigator", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Navigator>(MOZ_KnownLive(self)->Navigator()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo navigator_getterinfo = {
  { get_navigator },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clientInformation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "clientInformation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Navigator>(MOZ_KnownLive(self)->Navigator()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_clientInformation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "clientInformation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "clientInformation", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo clientInformation_getterinfo = {
  { get_clientInformation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo clientInformation_setterinfo = {
  { (JSJitGetterOp)set_clientInformation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_external(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "external", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::External>(MOZ_KnownLive(self)->External()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_external(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "external", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "external", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo external_getterinfo = {
  { get_external },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo external_setterinfo = {
  { (JSJitGetterOp)set_external },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
alert(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.alert");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "alert", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      FastErrorResult rv;
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Alert(MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Alert(MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.alert"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      FastErrorResult rv;
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Alert(NonNullHelper(Constify(arg0)), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Alert(NonNullHelper(Constify(arg0)), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.alert"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo alert_methodinfo = {
  { (JSJitGetterOp)alert },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
confirm(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "confirm", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  FastErrorResult rv;
  NonNull<nsIPrincipal> subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);

    subjectPrincipal = principal;
  }
  bool result(MOZ_KnownLive(self)->Confirm(NonNullHelper(Constify(arg0)), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.confirm"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo confirm_methodinfo = {
  { (JSJitGetterOp)confirm },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
prompt(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "prompt", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  binding_detail::FakeString<char16_t> arg1;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
      return false;
    }
  } else {
    arg1.AssignLiteral(u"");
  }
  FastErrorResult rv;
  NonNull<nsIPrincipal> subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);

    subjectPrincipal = principal;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Prompt(NonNullHelper(Constify(arg0)), NonNullHelper(Constify(arg1)), result, MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Prompt(NonNullHelper(Constify(arg0)), NonNullHelper(Constify(arg1)), result, MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.prompt"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo prompt_methodinfo = {
  { (JSJitGetterOp)prompt },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
print(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "print", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Print(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Print(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.print"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo print_methodinfo = {
  { (JSJitGetterOp)print },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
printPreview(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.printPreview");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "printPreview", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  nsIPrintSettings* arg0;
  RefPtr<nsIPrintSettings> arg0_holder;
  if (args.hasDefined(0)) {
    if (args[0].isObject()) {
      JS::Rooted<JSObject*> source(cx, &args[0].toObject());
      if (NS_FAILED(UnwrapArg<nsIPrintSettings>(cx, source, getter_AddRefs(arg0_holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "nsIPrintSettings");
        return false;
      }
      MOZ_ASSERT(arg0_holder);
      arg0 = arg0_holder;
    } else if (args[0].isNullOrUndefined()) {
      arg0 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
      return false;
    }
  } else {
    arg0 = nullptr;
  }
  nsIWebProgressListener* arg1;
  RefPtr<nsIWebProgressListener> arg1_holder;
  if (args.hasDefined(1)) {
    if (args[1].isObject()) {
      JS::Rooted<JSObject*> source(cx, &args[1].toObject());
      if (NS_FAILED(UnwrapArg<nsIWebProgressListener>(cx, source, getter_AddRefs(arg1_holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "nsIWebProgressListener");
        return false;
      }
      MOZ_ASSERT(arg1_holder);
      arg1 = arg1_holder;
    } else if (args[1].isNullOrUndefined()) {
      arg1 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
      return false;
    }
  } else {
    arg1 = nullptr;
  }
  nsIDocShell* arg2;
  RefPtr<nsIDocShell> arg2_holder;
  if (args.hasDefined(2)) {
    if (args[2].isObject()) {
      JS::Rooted<JSObject*> source(cx, &args[2].toObject());
      if (NS_FAILED(UnwrapArg<nsIDocShell>(cx, source, getter_AddRefs(arg2_holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "nsIDocShell");
        return false;
      }
      MOZ_ASSERT(arg2_holder);
      arg2 = arg2_holder;
    } else if (args[2].isNullOrUndefined()) {
      arg2 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
      return false;
    }
  } else {
    arg2 = nullptr;
  }
  FastErrorResult rv;
  Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->PrintPreview(MOZ_KnownLive(Constify(arg0)), MOZ_KnownLive(Constify(arg1)), MOZ_KnownLive(Constify(arg2)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.printPreview"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result.Value(), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo printPreview_methodinfo = {
  { (JSJitGetterOp)printPreview },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
postMessage(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.postMessage");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "postMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  // CrossOriginThisPolicy::UnwrapThisObject stores a nsGlobalWindowInner::RemoteProxy in void_self
  // if obj is a proxy with a RemoteObjectProxy handler for the right type, or else it stores
  // a nsGlobalWindowInner. If we get here from the JIT (without going through UnwrapThisObject) we
  // know void_self contains a nsGlobalWindowInner; we don't have special cases in the JIT to deal
  // with remote object proxies.
  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      auto* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      unsigned argcount = std::min(args.length(), 3u);
      switch (argcount) {
        case 1: {
          JS::Rooted<JS::Value> arg0(cx);
          arg0 = args[0];
          RootedDictionary<binding_detail::FastWindowPostMessageOptions> arg1(cx);
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          FastErrorResult rv;
          NonNull<nsIPrincipal> subjectPrincipal;
          {
            JS::Realm* realm = js::GetContextRealm(cx);
            MOZ_ASSERT(realm);
            JSPrincipals* principals = JS::GetRealmPrincipals(realm);
            nsIPrincipal* principal = nsJSPrincipals::get(principals);

            subjectPrincipal = principal;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
          break;
        }
        case 2: {
          JS::Rooted<JS::Value> arg0(cx);
          arg0 = args[0];
          if (args[1].isNullOrUndefined()) {
            RootedDictionary<binding_detail::FastWindowPostMessageOptions> arg1(cx);
            if (!arg1.Init(cx, args[1], "Argument 2", false)) {
              return false;
            }
            FastErrorResult rv;
            NonNull<nsIPrincipal> subjectPrincipal;
            {
              JS::Realm* realm = js::GetContextRealm(cx);
              MOZ_ASSERT(realm);
              JSPrincipals* principals = JS::GetRealmPrincipals(realm);
              nsIPrincipal* principal = nsJSPrincipals::get(principals);

              subjectPrincipal = principal;
            }
            // NOTE: This assert does NOT call the function.
            static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
            MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
            if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
              return false;
            }
            MOZ_ASSERT(!JS_IsExceptionPending(cx));
            args.rval().setUndefined();
            return true;
          }
          if (args[1].isObject()) {
            do {
              RootedDictionary<binding_detail::FastWindowPostMessageOptions> arg1(cx);
              if (!arg1.Init(cx, args[1], "Argument 2", false)) {
                return false;
              }
              FastErrorResult rv;
              NonNull<nsIPrincipal> subjectPrincipal;
              {
                JS::Realm* realm = js::GetContextRealm(cx);
                MOZ_ASSERT(realm);
                JSPrincipals* principals = JS::GetRealmPrincipals(realm);
                nsIPrincipal* principal = nsJSPrincipals::get(principals);

                subjectPrincipal = principal;
              }
              // NOTE: This assert does NOT call the function.
              static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
              MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
              if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
                return false;
              }
              MOZ_ASSERT(!JS_IsExceptionPending(cx));
              args.rval().setUndefined();
              return true;
            } while (false);
          }
          binding_detail::FakeString<char16_t> arg1;
          if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
            return false;
          }
          binding_detail::AutoSequence<JSObject*> arg2;
          SequenceRooter<JSObject*> arg2_holder(cx, &arg2);
          if (args.hasDefined(2)) {
            if (args[2].isObject()) {
              JS::ForOfIterator iter(cx);
              if (!iter.init(args[2], JS::ForOfIterator::AllowNonIterable)) {
                return false;
              }
              if (!iter.valueIsIterable()) {
                cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
                return false;
              }
              binding_detail::AutoSequence<JSObject*> &arr = arg2;
              JS::Rooted<JS::Value> temp(cx);
              while (true) {
                bool done;
                if (!iter.next(&temp, &done)) {
                  return false;
                }
                if (done) {
                  break;
                }
                JSObject** slotPtr = arr.AppendElement(nullptr, mozilla::fallible);
                if (!slotPtr) {
                  JS_ReportOutOfMemory(cx);
                  return false;
                }
                JSObject*& slot = *slotPtr;
                if (temp.isObject()) {
                  slot = &temp.toObject();
                } else {
                  cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 3");
                  return false;
                }
              }
            } else {
              cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
              return false;
            }
          } else {
            /* arg2 array is already empty; nothing to do */
          }
          FastErrorResult rv;
          NonNull<nsIPrincipal> subjectPrincipal;
          {
            JS::Realm* realm = js::GetContextRealm(cx);
            MOZ_ASSERT(realm);
            JSPrincipals* principals = JS::GetRealmPrincipals(realm);
            nsIPrincipal* principal = nsJSPrincipals::get(principals);

            subjectPrincipal = principal;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
          break;
        }
        case 3: {
          JS::Rooted<JS::Value> arg0(cx);
          arg0 = args[0];
          binding_detail::FakeString<char16_t> arg1;
          if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
            return false;
          }
          binding_detail::AutoSequence<JSObject*> arg2;
          SequenceRooter<JSObject*> arg2_holder(cx, &arg2);
          if (args.hasDefined(2)) {
            if (args[2].isObject()) {
              JS::ForOfIterator iter(cx);
              if (!iter.init(args[2], JS::ForOfIterator::AllowNonIterable)) {
                return false;
              }
              if (!iter.valueIsIterable()) {
                cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
                return false;
              }
              binding_detail::AutoSequence<JSObject*> &arr = arg2;
              JS::Rooted<JS::Value> temp(cx);
              while (true) {
                bool done;
                if (!iter.next(&temp, &done)) {
                  return false;
                }
                if (done) {
                  break;
                }
                JSObject** slotPtr = arr.AppendElement(nullptr, mozilla::fallible);
                if (!slotPtr) {
                  JS_ReportOutOfMemory(cx);
                  return false;
                }
                JSObject*& slot = *slotPtr;
                if (temp.isObject()) {
                  slot = &temp.toObject();
                } else {
                  cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 3");
                  return false;
                }
              }
            } else {
              cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
              return false;
            }
          } else {
            /* arg2 array is already empty; nothing to do */
          }
          FastErrorResult rv;
          NonNull<nsIPrincipal> subjectPrincipal;
          {
            JS::Realm* realm = js::GetContextRealm(cx);
            MOZ_ASSERT(realm);
            JSPrincipals* principals = JS::GetRealmPrincipals(realm);
            nsIPrincipal* principal = nsJSPrincipals::get(principals);

            subjectPrincipal = principal;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
          break;
        }
        default: {
          // Using nsPrintfCString here would require including that
          // header.  Let's not worry about it.
          nsAutoCString argCountStr;
          argCountStr.AppendPrintf("%u", args.length());
          return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
        }
      }
      MOZ_CRASH("We have an always-returning default case");
      return false;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 1: {
      JS::Rooted<JS::Value> arg0(cx);
      arg0 = args[0];
      RootedDictionary<binding_detail::FastWindowPostMessageOptions> arg1(cx);
      if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
        return false;
      }
      FastErrorResult rv;
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      JS::Rooted<JS::Value> arg0(cx);
      arg0 = args[0];
      if (args[1].isNullOrUndefined()) {
        RootedDictionary<binding_detail::FastWindowPostMessageOptions> arg1(cx);
        if (!arg1.Init(cx, args[1], "Argument 2", false)) {
          return false;
        }
        FastErrorResult rv;
        NonNull<nsIPrincipal> subjectPrincipal;
        {
          JS::Realm* realm = js::GetContextRealm(cx);
          MOZ_ASSERT(realm);
          JSPrincipals* principals = JS::GetRealmPrincipals(realm);
          nsIPrincipal* principal = nsJSPrincipals::get(principals);

          subjectPrincipal = principal;
        }
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[1].isObject()) {
        do {
          RootedDictionary<binding_detail::FastWindowPostMessageOptions> arg1(cx);
          if (!arg1.Init(cx, args[1], "Argument 2", false)) {
            return false;
          }
          FastErrorResult rv;
          NonNull<nsIPrincipal> subjectPrincipal;
          {
            JS::Realm* realm = js::GetContextRealm(cx);
            MOZ_ASSERT(realm);
            JSPrincipals* principals = JS::GetRealmPrincipals(realm);
            nsIPrincipal* principal = nsJSPrincipals::get(principals);

            subjectPrincipal = principal;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, Constify(arg1), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      binding_detail::FakeString<char16_t> arg1;
      if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
        return false;
      }
      binding_detail::AutoSequence<JSObject*> arg2;
      SequenceRooter<JSObject*> arg2_holder(cx, &arg2);
      if (args.hasDefined(2)) {
        if (args[2].isObject()) {
          JS::ForOfIterator iter(cx);
          if (!iter.init(args[2], JS::ForOfIterator::AllowNonIterable)) {
            return false;
          }
          if (!iter.valueIsIterable()) {
            cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
            return false;
          }
          binding_detail::AutoSequence<JSObject*> &arr = arg2;
          JS::Rooted<JS::Value> temp(cx);
          while (true) {
            bool done;
            if (!iter.next(&temp, &done)) {
              return false;
            }
            if (done) {
              break;
            }
            JSObject** slotPtr = arr.AppendElement(nullptr, mozilla::fallible);
            if (!slotPtr) {
              JS_ReportOutOfMemory(cx);
              return false;
            }
            JSObject*& slot = *slotPtr;
            if (temp.isObject()) {
              slot = &temp.toObject();
            } else {
              cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 3");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
          return false;
        }
      } else {
        /* arg2 array is already empty; nothing to do */
      }
      FastErrorResult rv;
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 3: {
      JS::Rooted<JS::Value> arg0(cx);
      arg0 = args[0];
      binding_detail::FakeString<char16_t> arg1;
      if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
        return false;
      }
      binding_detail::AutoSequence<JSObject*> arg2;
      SequenceRooter<JSObject*> arg2_holder(cx, &arg2);
      if (args.hasDefined(2)) {
        if (args[2].isObject()) {
          JS::ForOfIterator iter(cx);
          if (!iter.init(args[2], JS::ForOfIterator::AllowNonIterable)) {
            return false;
          }
          if (!iter.valueIsIterable()) {
            cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
            return false;
          }
          binding_detail::AutoSequence<JSObject*> &arr = arg2;
          JS::Rooted<JS::Value> temp(cx);
          while (true) {
            bool done;
            if (!iter.next(&temp, &done)) {
              return false;
            }
            if (done) {
              break;
            }
            JSObject** slotPtr = arr.AppendElement(nullptr, mozilla::fallible);
            if (!slotPtr) {
              JS_ReportOutOfMemory(cx);
              return false;
            }
            JSObject*& slot = *slotPtr;
            if (temp.isObject()) {
              slot = &temp.toObject();
            } else {
              cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 3");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
          return false;
        }
      } else {
        /* arg2 array is already empty; nothing to do */
      }
      FastErrorResult rv;
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->PostMessageMoz(cx, arg0, NonNullHelper(Constify(arg1)), Constify(arg2), MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.postMessage"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo postMessage_methodinfo = {
  { (JSJitGetterOp)postMessage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
captureEvents(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "captureEvents", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CaptureEvents())>, "Should be returning void here");
  MOZ_KnownLive(self)->CaptureEvents();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo captureEvents_methodinfo = {
  { (JSJitGetterOp)captureEvents },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
releaseEvents(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "releaseEvents", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReleaseEvents())>, "Should be returning void here");
  MOZ_KnownLive(self)->ReleaseEvents();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo releaseEvents_methodinfo = {
  { (JSJitGetterOp)releaseEvents },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getSelection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getSelection", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Selection>(MOZ_KnownLive(self)->GetSelection(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.getSelection"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getSelection_methodinfo = {
  { (JSJitGetterOp)getSelection },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getComputedStyle(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.getComputedStyle");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getComputedStyle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.getComputedStyle", 1)) {
    return false;
  }
  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eNull, eNull, arg1)) {
      return false;
    }
  } else {
    arg1.AssignLiteral(u"");
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsDOMCSSDeclaration>(MOZ_KnownLive(self)->GetComputedStyle(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.getComputedStyle"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getComputedStyle_methodinfo = {
  { (JSJitGetterOp)getComputedStyle },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
matchMedia(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "matchMedia", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.matchMedia", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::MediaQueryList>(MOZ_KnownLive(self)->MatchMedia(Constify(arg0), nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.matchMedia"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo matchMedia_methodinfo = {
  { (JSJitGetterOp)matchMedia },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screen(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screen", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<nsScreen>(MOZ_KnownLive(self)->Screen()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_screen(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screen", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "screen", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo screen_getterinfo = {
  { get_screen },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo screen_setterinfo = {
  { (JSJitGetterOp)set_screen },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
moveTo(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "moveTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.moveTo", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MoveTo(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->MoveTo(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.moveTo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo moveTo_methodinfo = {
  { (JSJitGetterOp)moveTo },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
moveBy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "moveBy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.moveBy", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MoveBy(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->MoveBy(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.moveBy"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo moveBy_methodinfo = {
  { (JSJitGetterOp)moveBy },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
resizeTo(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "resizeTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.resizeTo", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ResizeTo(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ResizeTo(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.resizeTo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo resizeTo_methodinfo = {
  { (JSJitGetterOp)resizeTo },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
resizeBy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "resizeBy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.resizeBy", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ResizeBy(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ResizeBy(arg0, arg1, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.resizeBy"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo resizeBy_methodinfo = {
  { (JSJitGetterOp)resizeBy },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
moveResize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "moveResize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.moveResize", 4)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MoveResize(arg0, arg1, arg2, arg3, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->MoveResize(arg0, arg1, arg2, arg3, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.moveResize"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo moveResize_methodinfo = {
  { (JSJitGetterOp)moveResize },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_innerWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "innerWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetInnerWidth(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.innerWidth getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_innerWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "innerWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "innerWidth", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo innerWidth_getterinfo = {
  { get_innerWidth },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo innerWidth_setterinfo = {
  { (JSJitGetterOp)set_innerWidth },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_innerHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "innerHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetInnerHeight(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.innerHeight getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_innerHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "innerHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "innerHeight", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo innerHeight_getterinfo = {
  { get_innerHeight },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo innerHeight_setterinfo = {
  { (JSJitGetterOp)set_innerHeight },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scroll(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.scroll");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scroll", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      binding_detail::FastScrollToOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Scroll(Constify(arg0)))>, "Should be returning void here");
      MOZ_KnownLive(self)->Scroll(Constify(arg0));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Scroll(arg0, arg1))>, "Should be returning void here");
      MOZ_KnownLive(self)->Scroll(arg0, arg1);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo scroll_methodinfo = {
  { (JSJitGetterOp)scroll },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scrollTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.scrollTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      binding_detail::FastScrollToOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ScrollTo(Constify(arg0)))>, "Should be returning void here");
      MOZ_KnownLive(self)->ScrollTo(Constify(arg0));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ScrollTo(arg0, arg1))>, "Should be returning void here");
      MOZ_KnownLive(self)->ScrollTo(arg0, arg1);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo scrollTo_methodinfo = {
  { (JSJitGetterOp)scrollTo },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scrollBy(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.scrollBy");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollBy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      binding_detail::FastScrollToOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ScrollBy(Constify(arg0)))>, "Should be returning void here");
      MOZ_KnownLive(self)->ScrollBy(Constify(arg0));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ScrollBy(arg0, arg1))>, "Should be returning void here");
      MOZ_KnownLive(self)->ScrollBy(arg0, arg1);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo scrollBy_methodinfo = {
  { (JSJitGetterOp)scrollBy },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
mozScrollSnap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "mozScrollSnap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MozScrollSnap())>, "Should be returning void here");
  MOZ_KnownLive(self)->MozScrollSnap();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo mozScrollSnap_methodinfo = {
  { (JSJitGetterOp)mozScrollSnap },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetScrollX(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollX getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "scrollX", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo scrollX_getterinfo = {
  { get_scrollX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollX_setterinfo = {
  { (JSJitGetterOp)set_scrollX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pageXOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "pageXOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetPageXOffset(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.pageXOffset getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_pageXOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "pageXOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "pageXOffset", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo pageXOffset_getterinfo = {
  { get_pageXOffset },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pageXOffset_setterinfo = {
  { (JSJitGetterOp)set_pageXOffset },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetScrollY(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollY getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "scrollY", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo scrollY_getterinfo = {
  { get_scrollY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollY_setterinfo = {
  { (JSJitGetterOp)set_scrollY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pageYOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "pageYOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetPageYOffset(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.pageYOffset getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_pageYOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "pageYOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "pageYOffset", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo pageYOffset_getterinfo = {
  { get_pageYOffset },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pageYOffset_setterinfo = {
  { (JSJitGetterOp)set_pageYOffset },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screenLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenLeft", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetScreenLeft(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.screenLeft getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_screenLeft(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenLeft", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "screenLeft", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo screenLeft_getterinfo = {
  { get_screenLeft },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo screenLeft_setterinfo = {
  { (JSJitGetterOp)set_screenLeft },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screenTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenTop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetScreenTop(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.screenTop getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_screenTop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenTop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "screenTop", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo screenTop_getterinfo = {
  { get_screenTop },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo screenTop_setterinfo = {
  { (JSJitGetterOp)set_screenTop },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screenX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetScreenX(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.screenX getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_screenX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "screenX", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo screenX_getterinfo = {
  { get_screenX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo screenX_setterinfo = {
  { (JSJitGetterOp)set_screenX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screenY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetScreenY(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.screenY getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_screenY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "screenY", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo screenY_getterinfo = {
  { get_screenY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo screenY_setterinfo = {
  { (JSJitGetterOp)set_screenY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outerWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "outerWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetOuterWidth(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.outerWidth getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_outerWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "outerWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "outerWidth", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo outerWidth_getterinfo = {
  { get_outerWidth },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outerWidth_setterinfo = {
  { (JSJitGetterOp)set_outerWidth },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_outerHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "outerHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetOuterHeight(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.outerHeight getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_outerHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "outerHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "outerHeight", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo outerHeight_getterinfo = {
  { get_outerHeight },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo outerHeight_setterinfo = {
  { (JSJitGetterOp)set_outerHeight },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static bool
get_performance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "performance", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // Have to either root across the getter call or reget after.
  JS::Rooted<JSObject*> slotStorage(cx, js::UncheckedUnwrap(obj, /* stopAtWindowProxy = */ false));
  MOZ_ASSERT(IsDOMObject(slotStorage));
  const size_t slotIndex = (DOM_INSTANCE_RESERVED_SLOTS + 3);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapValue(cx, args.rval());
    }
  }

  auto result(StrongOrRawPtr<mozilla::dom::Performance>(MOZ_KnownLive(self)->GetPerformance()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping
      if (!result) {
        args.rval().setNull();
        break;
      }
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapValue(cx, args.rval());
}

MOZ_CAN_RUN_SCRIPT static bool
set_performance(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "performance", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "performance", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo performance_getterinfo = {
  { get_performance },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  true, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 3)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 3) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 3) < 5, "There is no slot for us");
static const JSJitInfo performance_setterinfo = {
  { (JSJitGetterOp)set_performance },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getDefaultComputedStyle(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.getDefaultComputedStyle");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getDefaultComputedStyle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.getDefaultComputedStyle", 1)) {
    return false;
  }
  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
      return false;
    }
  } else {
    arg1.AssignLiteral(u"");
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsICSSDeclaration>(MOZ_KnownLive(self)->GetDefaultComputedStyle(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.getDefaultComputedStyle"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getDefaultComputedStyle_methodinfo = {
  { (JSJitGetterOp)getDefaultComputedStyle },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scrollByLines(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.scrollByLines");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollByLines", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.scrollByLines", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  binding_detail::FastScrollOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ScrollByLines(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->ScrollByLines(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo scrollByLines_methodinfo = {
  { (JSJitGetterOp)scrollByLines },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scrollByPages(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.scrollByPages");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollByPages", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.scrollByPages", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  binding_detail::FastScrollOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ScrollByPages(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->ScrollByPages(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo scrollByPages_methodinfo = {
  { (JSJitGetterOp)scrollByPages },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sizeToContent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.sizeToContent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "sizeToContent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FastSizeToContentConstraints arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SizeToContent(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SizeToContent(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.sizeToContent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo sizeToContent_methodinfo = {
  { (JSJitGetterOp)sizeToContent },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_controllers(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "controllers", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsIControllers>(MOZ_KnownLive(self)->GetControllers(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.controllers getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!WrapObject(cx, result, &NS_GET_IID(nsIControllers), args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_controllers(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "controllers", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "controllers", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo controllers_getterinfo = {
  { get_controllers },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo controllers_setterinfo = {
  { (JSJitGetterOp)set_controllers },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_realFrameElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "realFrameElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetRealFrameElement(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.realFrameElement getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo realFrameElement_getterinfo = {
  { get_realFrameElement },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_docShell(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "docShell", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<nsIDocShell>(MOZ_KnownLive(self)->GetDocShell()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsIDocShell), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo docShell_getterinfo = {
  { get_docShell },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_browsingContext(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "browsingContext", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  if (IsRemoteObjectProxy(obj, prototypes::id::Window)) {
      nsGlobalWindowInner::RemoteProxy* self = static_cast<nsGlobalWindowInner::RemoteProxy*>(void_self);
      auto result(StrongOrRawPtr<mozilla::dom::BrowsingContext>(MOZ_KnownLive(self)->GetBrowsingContext()));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
  }
  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::BrowsingContext>(MOZ_KnownLive(self)->GetBrowsingContext()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo browsingContext_getterinfo = {
  { get_browsingContext },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mozInnerScreenX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "mozInnerScreenX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  float result(MOZ_KnownLive(self)->GetMozInnerScreenX(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.mozInnerScreenX getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo mozInnerScreenX_getterinfo = {
  { get_mozInnerScreenX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mozInnerScreenY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "mozInnerScreenY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  float result(MOZ_KnownLive(self)->GetMozInnerScreenY(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.mozInnerScreenY getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo mozInnerScreenY_getterinfo = {
  { get_mozInnerScreenY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_devicePixelRatio(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "devicePixelRatio", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetDevicePixelRatio(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.devicePixelRatio getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_devicePixelRatio(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "devicePixelRatio", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "devicePixelRatio", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo devicePixelRatio_getterinfo = {
  { get_devicePixelRatio },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo devicePixelRatio_setterinfo = {
  { (JSJitGetterOp)set_devicePixelRatio },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_desktopToDeviceScale(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "desktopToDeviceScale", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  double result(MOZ_KnownLive(self)->GetDesktopToDeviceScale(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.desktopToDeviceScale getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo desktopToDeviceScale_getterinfo = {
  { get_desktopToDeviceScale },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screenEdgeSlopX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenEdgeSlopX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  double result(MOZ_KnownLive(self)->ScreenEdgeSlopX());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo screenEdgeSlopX_getterinfo = {
  { get_screenEdgeSlopX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_screenEdgeSlopY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "screenEdgeSlopY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  double result(MOZ_KnownLive(self)->ScreenEdgeSlopY());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo screenEdgeSlopY_getterinfo = {
  { get_screenEdgeSlopY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMinX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollMinX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  int32_t result(MOZ_KnownLive(self)->GetScrollMinX(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollMinX getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo scrollMinX_getterinfo = {
  { get_scrollMinX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMinY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollMinY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  int32_t result(MOZ_KnownLive(self)->GetScrollMinY(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollMinY getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo scrollMinY_getterinfo = {
  { get_scrollMinY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMaxX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollMaxX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  int32_t result(MOZ_KnownLive(self)->GetScrollMaxX(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollMaxX getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMaxX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollMaxX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "scrollMaxX", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo scrollMaxX_getterinfo = {
  { get_scrollMaxX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMaxX_setterinfo = {
  { (JSJitGetterOp)set_scrollMaxX },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scrollMaxY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollMaxY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  int32_t result(MOZ_KnownLive(self)->GetScrollMaxY(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.scrollMaxY getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_scrollMaxY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scrollMaxY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "scrollMaxY", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo scrollMaxY_getterinfo = {
  { get_scrollMaxY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scrollMaxY_setterinfo = {
  { (JSJitGetterOp)set_scrollMaxY },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fullScreen(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "fullScreen", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eFullscreenAttribute);
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->GetFullScreen(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.fullScreen getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fullScreen(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "fullScreen", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eFullscreenAttribute);
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFullScreen(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFullScreen(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.fullScreen setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo fullScreen_getterinfo = {
  { get_fullScreen },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fullScreen_setterinfo = {
  { (JSJitGetterOp)set_fullScreen },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
updateCommands(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "updateCommands", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.updateCommands", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UpdateCommands(NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->UpdateCommands(NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo updateCommands_methodinfo = {
  { (JSJitGetterOp)updateCommands },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
find(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "find", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  bool arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = false;
  }
  bool arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = false;
  }
  bool arg5;
  if (args.hasDefined(5)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[5], "Argument 6", &arg5)) {
      return false;
    }
  } else {
    arg5 = false;
  }
  bool arg6;
  if (args.hasDefined(6)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[6], "Argument 7", &arg6)) {
      return false;
    }
  } else {
    arg6 = false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->Find(NonNullHelper(Constify(arg0)), arg1, arg2, arg3, arg4, arg5, arg6, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.find"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo find_methodinfo = {
  { (JSJitGetterOp)find },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondevicemotion(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondevicemotion", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndevicemotion());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondevicemotion(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondevicemotion", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndevicemotion(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndevicemotion(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondevicemotion_getterinfo = {
  { get_ondevicemotion },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondevicemotion_setterinfo = {
  { (JSJitGetterOp)set_ondevicemotion },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondeviceorientation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondeviceorientation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndeviceorientation());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondeviceorientation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondeviceorientation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndeviceorientation(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndeviceorientation(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondeviceorientation_getterinfo = {
  { get_ondeviceorientation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondeviceorientation_setterinfo = {
  { (JSJitGetterOp)set_ondeviceorientation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondeviceorientationabsolute(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondeviceorientationabsolute", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndeviceorientationabsolute());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondeviceorientationabsolute(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondeviceorientationabsolute", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndeviceorientationabsolute(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndeviceorientationabsolute(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondeviceorientationabsolute_getterinfo = {
  { get_ondeviceorientationabsolute },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondeviceorientationabsolute_setterinfo = {
  { (JSJitGetterOp)set_ondeviceorientationabsolute },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onuserproximity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onuserproximity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnuserproximity());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onuserproximity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onuserproximity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnuserproximity(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnuserproximity(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onuserproximity_getterinfo = {
  { get_onuserproximity },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onuserproximity_setterinfo = {
  { (JSJitGetterOp)set_onuserproximity },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondevicelight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondevicelight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndevicelight());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondevicelight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondevicelight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndevicelight(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndevicelight(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondevicelight_getterinfo = {
  { get_ondevicelight },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondevicelight_setterinfo = {
  { (JSJitGetterOp)set_ondevicelight },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
dump(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "dump", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.dump", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Dump(NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->Dump(NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo dump_methodinfo = {
  { (JSJitGetterOp)dump },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setResizable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "setResizable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.setResizable", 1)) {
    return false;
  }
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetResizable(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetResizable(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setResizable_methodinfo = {
  { (JSJitGetterOp)setResizable },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
openDialog(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "openDialog", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  binding_detail::FakeString<char16_t> arg1;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
      return false;
    }
  } else {
    arg1.AssignLiteral(u"");
  }
  binding_detail::FakeString<char16_t> arg2;
  if (args.hasDefined(2)) {
    if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
      return false;
    }
  } else {
    arg2.AssignLiteral(u"");
  }
  AutoSequence<JS::Value> arg3;
  SequenceRooter<JS::Value> arg3_holder(cx, &arg3);
  if (args.length() > 3) {
    if (!arg3.SetCapacity(args.length() - 3, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 3; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg3.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  Nullable<WindowProxyHolder> result(MOZ_KnownLive(self)->OpenDialog(cx, NonNullHelper(Constify(arg0)), NonNullHelper(Constify(arg1)), NonNullHelper(Constify(arg2)), Constify(arg3), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.openDialog"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result.Value(), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo openDialog_methodinfo = {
  { (JSJitGetterOp)openDialog },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_content(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "content", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetContent(cx, &result, SystemCallerGuarantee(), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetContent(cx, &result, SystemCallerGuarantee(), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.content getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
                JS::ExposeObjectToActiveJS(result);
              }
              args.rval().setObjectOrNull(result);
  if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_content(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "content", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "content", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo content_getterinfo = {
  { get_content },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo content_setterinfo = {
  { (JSJitGetterOp)set_content },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getInterface(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getInterface", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.getInterface", 1)) {
    return false;
  }
  JS::Rooted<JS::Value> arg0(cx);
  arg0 = args[0];
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetInterface(cx, arg0, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetInterface(cx, arg0, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.getInterface"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getInterface_methodinfo = {
  { (JSJitGetterOp)getInterface },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_windowRoot(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "windowRoot", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsWindowRoot>(MOZ_KnownLive(self)->GetWindowRoot(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.windowRoot getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo windowRoot_getterinfo = {
  { get_windowRoot },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
shouldReportForServiceWorkerScope(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "shouldReportForServiceWorkerScope", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.shouldReportForServiceWorkerScope", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  if (!NormalizeUSVString(arg0)) {
    JS_ReportOutOfMemory(cx);
    return false;
  }
  bool result(MOZ_KnownLive(self)->ShouldReportForServiceWorkerScope(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo shouldReportForServiceWorkerScope_methodinfo = {
  { (JSJitGetterOp)shouldReportForServiceWorkerScope },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_InstallTrigger(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "InstallTrigger", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eInstallTriggerDeprecated);
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetInstallTrigger(cx, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetInstallTrigger(cx, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
                JS::ExposeObjectToActiveJS(result);
              }
              args.rval().setObjectOrNull(result);
  if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_InstallTrigger(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "InstallTrigger", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "InstallTrigger", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo InstallTrigger_getterinfo = {
  { get_InstallTrigger },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo InstallTrigger_setterinfo = {
  { (JSJitGetterOp)set_InstallTrigger },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_windowUtils(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "windowUtils", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsIDOMWindowUtils>(MOZ_KnownLive(self)->GetWindowUtils(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.windowUtils getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!WrapObject(cx, result, &NS_GET_IID(nsIDOMWindowUtils), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo windowUtils_getterinfo = {
  { get_windowUtils },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
synthesizeMouseEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.synthesizeMouseEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "synthesizeMouseEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.synthesizeMouseEvent", 3)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  binding_detail::FastSynthesizeMouseEventData arg3;
  if (!arg3.Init(cx, (args.hasDefined(3)) ? args[3] : JS::NullHandleValue, "Argument 4", false)) {
    return false;
  }
  binding_detail::FastSynthesizeMouseEventOptions arg4;
  if (!arg4.Init(cx, (args.hasDefined(4)) ? args[4] : JS::NullHandleValue, "Argument 5", false)) {
    return false;
  }
  Optional<OwningNonNull<VoidFunction>> arg5;
  if (args.hasDefined(5)) {
    arg5.Construct();
    if (args[5].isObject()) {
      if (JS::IsCallable(&args[5].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[5].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg5.Value() = new VoidFunction(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 6");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 6");
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->SynthesizeMouseEvent(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), Constify(arg4), MOZ_KnownLive(NonNullHelper(Constify(arg5))), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.synthesizeMouseEvent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo synthesizeMouseEvent_methodinfo = {
  { (JSJitGetterOp)synthesizeMouseEvent },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
synthesizeTouchEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.synthesizeTouchEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "synthesizeTouchEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.synthesizeTouchEvent", 2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::AutoSequence<SynthesizeTouchEventData> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<SynthesizeTouchEventData> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      SynthesizeTouchEventData* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      SynthesizeTouchEventData& slot = *slotPtr;
      if (!slot.Init(cx, temp, "Element of argument 2", false)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  int32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0;
  }
  binding_detail::FastSynthesizeTouchEventOptions arg3;
  if (!arg3.Init(cx, (args.hasDefined(3)) ? args[3] : JS::NullHandleValue, "Argument 4", false)) {
    return false;
  }
  Optional<OwningNonNull<VoidFunction>> arg4;
  if (args.hasDefined(4)) {
    arg4.Construct();
    if (args[4].isObject()) {
      if (JS::IsCallable(&args[4].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[4].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg4.Value() = new VoidFunction(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 5");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 5");
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->SynthesizeTouchEvent(NonNullHelper(Constify(arg0)), Constify(arg1), arg2, Constify(arg3), MOZ_KnownLive(NonNullHelper(Constify(arg4))), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.synthesizeTouchEvent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo synthesizeTouchEvent_methodinfo = {
  { (JSJitGetterOp)synthesizeTouchEvent },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_windowGlobalChild(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "windowGlobalChild", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::WindowGlobalChild>(MOZ_KnownLive(self)->GetWindowGlobalChild()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo windowGlobalChild_getterinfo = {
  { get_windowGlobalChild },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clientPrincipal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "clientPrincipal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<nsIPrincipal>(MOZ_KnownLive(self)->GetClientPrincipal()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsIPrincipal), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo clientPrincipal_getterinfo = {
  { get_clientPrincipal },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isInFullScreenTransition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "isInFullScreenTransition", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->IsInFullScreenTransition());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isInFullScreenTransition_getterinfo = {
  { get_isInFullScreenTransition },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_windowState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "windowState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  uint16_t result(MOZ_KnownLive(self)->WindowState());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo windowState_getterinfo = {
  { get_windowState },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isFullyOccluded(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "isFullyOccluded", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->IsFullyOccluded());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isFullyOccluded_getterinfo = {
  { get_isFullyOccluded },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isCloaked(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "isCloaked", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->IsCloaked());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isCloaked_getterinfo = {
  { get_isCloaked },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_browserDOMWindow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "browserDOMWindow", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsIBrowserDOMWindow>(MOZ_KnownLive(self)->GetBrowserDOMWindow(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.browserDOMWindow getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsIBrowserDOMWindow), args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_browserDOMWindow(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "Window.browserDOMWindow setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "browserDOMWindow", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  nsIBrowserDOMWindow* arg0;
  RefPtr<nsIBrowserDOMWindow> arg0_holder;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapArg<nsIBrowserDOMWindow>(cx, source, getter_AddRefs(arg0_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned", "nsIBrowserDOMWindow");
      return false;
    }
    MOZ_ASSERT(arg0_holder);
    arg0 = arg0_holder;
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetBrowserDOMWindow(MOZ_KnownLive(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetBrowserDOMWindow(MOZ_KnownLive(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.browserDOMWindow setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo browserDOMWindow_getterinfo = {
  { get_browserDOMWindow },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo browserDOMWindow_setterinfo = {
  { (JSJitGetterOp)set_browserDOMWindow },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAttention(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getAttention", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAttention(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAttention(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.getAttention"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo getAttention_methodinfo = {
  { (JSJitGetterOp)getAttention },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAttentionWithCycleCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getAttentionWithCycleCount", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.getAttentionWithCycleCount", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAttentionWithCycleCount(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAttentionWithCycleCount(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.getAttentionWithCycleCount"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo getAttentionWithCycleCount_methodinfo = {
  { (JSJitGetterOp)getAttentionWithCycleCount },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setCursor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "setCursor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.setCursor", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetCursor(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetCursor(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.setCursor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setCursor_methodinfo = {
  { (JSJitGetterOp)setCursor },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
maximize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "maximize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Maximize())>, "Should be returning void here");
  MOZ_KnownLive(self)->Maximize();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo maximize_methodinfo = {
  { (JSJitGetterOp)maximize },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
minimize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "minimize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Minimize())>, "Should be returning void here");
  MOZ_KnownLive(self)->Minimize();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo minimize_methodinfo = {
  { (JSJitGetterOp)minimize },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
restore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "restore", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Restore())>, "Should be returning void here");
  MOZ_KnownLive(self)->Restore();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo restore_methodinfo = {
  { (JSJitGetterOp)restore },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getWorkspaceID(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getWorkspaceID", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetWorkspaceID(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetWorkspaceID(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getWorkspaceID_methodinfo = {
  { (JSJitGetterOp)getWorkspaceID },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
moveToWorkspace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "moveToWorkspace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.moveToWorkspace", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MoveToWorkspace(NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->MoveToWorkspace(NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo moveToWorkspace_methodinfo = {
  { (JSJitGetterOp)moveToWorkspace },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
notifyDefaultButtonLoaded(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.notifyDefaultButtonLoaded");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "notifyDefaultButtonLoaded", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.notifyDefaultButtonLoaded", 1)) {
    return false;
  }
  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NotifyDefaultButtonLoaded(MOZ_KnownLive(NonNullHelper(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->NotifyDefaultButtonLoaded(MOZ_KnownLive(NonNullHelper(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.notifyDefaultButtonLoaded"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo notifyDefaultButtonLoaded_methodinfo = {
  { (JSJitGetterOp)notifyDefaultButtonLoaded },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_messageManager(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "messageManager", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::ChromeMessageBroadcaster>(MOZ_KnownLive(self)->MessageManager()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo messageManager_getterinfo = {
  { get_messageManager },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getGroupMessageManager(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getGroupMessageManager", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.getGroupMessageManager", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::ChromeMessageBroadcaster>(MOZ_KnownLive(self)->GetGroupMessageManager(NonNullHelper(Constify(arg0)))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getGroupMessageManager_methodinfo = {
  { (JSJitGetterOp)getGroupMessageManager },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
promiseDocumentFlushed(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.promiseDocumentFlushed");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "promiseDocumentFlushed", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.promiseDocumentFlushed", 1)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastPromiseDocumentFlushedCallback>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastPromiseDocumentFlushedCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->PromiseDocumentFlushed(MOZ_KnownLive(NonNullHelper(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.promiseDocumentFlushed"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
promiseDocumentFlushed_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = promiseDocumentFlushed(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo promiseDocumentFlushed_methodinfo = {
  { (JSJitGetterOp)promiseDocumentFlushed_promiseWrapper },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isChromeWindow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "isChromeWindow", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->IsChromeWindow());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isChromeWindow_getterinfo = {
  { get_isChromeWindow },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_Glean(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "Glean", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::glean::Glean>(MOZ_KnownLive(self)->Glean()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo Glean_getterinfo = {
  { get_Glean },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_GleanPings(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "GleanPings", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::glean::GleanPings>(MOZ_KnownLive(self)->GleanPings()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo GleanPings_getterinfo = {
  { get_GleanPings },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onvrdisplayconnect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplayconnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnvrdisplayconnect());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onvrdisplayconnect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplayconnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnvrdisplayconnect(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnvrdisplayconnect(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onvrdisplayconnect_getterinfo = {
  { get_onvrdisplayconnect },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onvrdisplayconnect_setterinfo = {
  { (JSJitGetterOp)set_onvrdisplayconnect },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onvrdisplaydisconnect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplaydisconnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnvrdisplaydisconnect());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onvrdisplaydisconnect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplaydisconnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnvrdisplaydisconnect(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnvrdisplaydisconnect(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onvrdisplaydisconnect_getterinfo = {
  { get_onvrdisplaydisconnect },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onvrdisplaydisconnect_setterinfo = {
  { (JSJitGetterOp)set_onvrdisplaydisconnect },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onvrdisplayactivate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplayactivate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnvrdisplayactivate());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onvrdisplayactivate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplayactivate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnvrdisplayactivate(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnvrdisplayactivate(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onvrdisplayactivate_getterinfo = {
  { get_onvrdisplayactivate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onvrdisplayactivate_setterinfo = {
  { (JSJitGetterOp)set_onvrdisplayactivate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onvrdisplaydeactivate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplaydeactivate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnvrdisplaydeactivate());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onvrdisplaydeactivate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplaydeactivate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnvrdisplaydeactivate(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnvrdisplaydeactivate(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onvrdisplaydeactivate_getterinfo = {
  { get_onvrdisplaydeactivate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onvrdisplaydeactivate_setterinfo = {
  { (JSJitGetterOp)set_onvrdisplaydeactivate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onvrdisplaypresentchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplaypresentchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnvrdisplaypresentchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onvrdisplaypresentchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvrdisplaypresentchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnvrdisplaypresentchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnvrdisplaypresentchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onvrdisplaypresentchange_getterinfo = {
  { get_onvrdisplaypresentchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onvrdisplaypresentchange_setterinfo = {
  { (JSJitGetterOp)set_onvrdisplaypresentchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestIdleCallback(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.requestIdleCallback");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "requestIdleCallback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.requestIdleCallback", 1)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastIdleRequestCallback>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastIdleRequestCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FastIdleRequestOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  uint32_t result(MOZ_KnownLive(self)->RequestIdleCallback(cx, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.requestIdleCallback"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo requestIdleCallback_methodinfo = {
  { (JSJitGetterOp)requestIdleCallback },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
cancelIdleCallback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "cancelIdleCallback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.cancelIdleCallback", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CancelIdleCallback(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->CancelIdleCallback(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo cancelIdleCallback_methodinfo = {
  { (JSJitGetterOp)cancelIdleCallback },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getWebExposedLocales(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "getWebExposedLocales", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetWebExposedLocales(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetWebExposedLocales(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getWebExposedLocales_methodinfo = {
  { (JSJitGetterOp)getWebExposedLocales },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_intlUtils(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "intlUtils", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::IntlUtils>(MOZ_KnownLive(self)->GetIntlUtils(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.intlUtils getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo intlUtils_getterinfo = {
  { get_intlUtils },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_visualViewport(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "visualViewport", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::VisualViewport>(MOZ_KnownLive(self)->VisualViewport()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_visualViewport(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "visualViewport", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "visualViewport", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo visualViewport_getterinfo = {
  { get_visualViewport },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo visualViewport_setterinfo = {
  { (JSJitGetterOp)set_visualViewport },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setScrollMarks(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.setScrollMarks");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "setScrollMarks", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.setScrollMarks", 1)) {
    return false;
  }
  binding_detail::AutoSequence<uint32_t> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
      return false;
    }
    binding_detail::AutoSequence<uint32_t> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of argument 1", &slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetScrollMarks(Constify(arg0), arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetScrollMarks(Constify(arg0), arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setScrollMarks_methodinfo = {
  { (JSJitGetterOp)setScrollMarks },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_cookieStore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "cookieStore", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::CookieStore>(MOZ_KnownLive(self)->CookieStore()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo cookieStore_getterinfo = {
  { get_cookieStore },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_originAgentCluster(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "originAgentCluster", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->OriginAgentCluster());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo originAgentCluster_getterinfo = {
  { get_originAgentCluster },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_documentPictureInPicture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "documentPictureInPicture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::DocumentPictureInPicture>(MOZ_KnownLive(self)->DocumentPictureInPicture()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo documentPictureInPicture_getterinfo = {
  { get_documentPictureInPicture },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestAnimationFrame(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.requestAnimationFrame");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "requestAnimationFrame", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.requestAnimationFrame", 1)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastFrameRequestCallback>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastFrameRequestCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  uint32_t result(MOZ_KnownLive(self)->RequestAnimationFrame(MOZ_KnownLive(NonNullHelper(arg0)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.requestAnimationFrame"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo requestAnimationFrame_methodinfo = {
  { (JSJitGetterOp)requestAnimationFrame },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
cancelAnimationFrame(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "cancelAnimationFrame", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.cancelAnimationFrame", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CancelAnimationFrame(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CancelAnimationFrame(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.cancelAnimationFrame"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo cancelAnimationFrame_methodinfo = {
  { (JSJitGetterOp)cancelAnimationFrame },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_crypto(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "crypto", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Crypto>(MOZ_KnownLive(self)->GetCrypto(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.crypto getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo crypto_getterinfo = {
  { get_crypto },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onabort(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onabort", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnabort());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onabort(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onabort", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnabort(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnabort(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onabort_getterinfo = {
  { get_onabort },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onabort_setterinfo = {
  { (JSJitGetterOp)set_onabort },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onblur(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onblur", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnblur());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onblur(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onblur", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnblur(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnblur(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onblur_getterinfo = {
  { get_onblur },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onblur_setterinfo = {
  { (JSJitGetterOp)set_onblur },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onfocus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onfocus", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnfocus());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onfocus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onfocus", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnfocus(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnfocus(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onfocus_getterinfo = {
  { get_onfocus },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onfocus_setterinfo = {
  { (JSJitGetterOp)set_onfocus },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncancel());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncancel(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncancel(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncancel_getterinfo = {
  { get_oncancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncancel_setterinfo = {
  { (JSJitGetterOp)set_oncancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onauxclick(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onauxclick", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnauxclick());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onauxclick(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onauxclick", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnauxclick(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnauxclick(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onauxclick_getterinfo = {
  { get_onauxclick },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onauxclick_setterinfo = {
  { (JSJitGetterOp)set_onauxclick },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onbeforeinput(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforeinput", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnbeforeinput());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onbeforeinput(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforeinput", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnbeforeinput(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnbeforeinput(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onbeforeinput_getterinfo = {
  { get_onbeforeinput },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onbeforeinput_setterinfo = {
  { (JSJitGetterOp)set_onbeforeinput },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onbeforematch(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforematch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnbeforematch());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onbeforematch(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforematch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnbeforematch(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnbeforematch(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onbeforematch_getterinfo = {
  { get_onbeforematch },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onbeforematch_setterinfo = {
  { (JSJitGetterOp)set_onbeforematch },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onbeforetoggle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforetoggle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnbeforetoggle());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onbeforetoggle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforetoggle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnbeforetoggle(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnbeforetoggle(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onbeforetoggle_getterinfo = {
  { get_onbeforetoggle },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onbeforetoggle_setterinfo = {
  { (JSJitGetterOp)set_onbeforetoggle },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncanplay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncanplay", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncanplay());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncanplay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncanplay", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncanplay(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncanplay(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncanplay_getterinfo = {
  { get_oncanplay },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncanplay_setterinfo = {
  { (JSJitGetterOp)set_oncanplay },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncanplaythrough(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncanplaythrough", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncanplaythrough());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncanplaythrough(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncanplaythrough", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncanplaythrough(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncanplaythrough(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncanplaythrough_getterinfo = {
  { get_oncanplaythrough },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncanplaythrough_setterinfo = {
  { (JSJitGetterOp)set_oncanplaythrough },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onchange_getterinfo = {
  { get_onchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onchange_setterinfo = {
  { (JSJitGetterOp)set_onchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onclick(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onclick", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnclick());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onclick(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onclick", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnclick(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnclick(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onclick_getterinfo = {
  { get_onclick },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onclick_setterinfo = {
  { (JSJitGetterOp)set_onclick },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onclose(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onclose", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnclose());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onclose(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onclose", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnclose(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnclose(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onclose_getterinfo = {
  { get_onclose },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onclose_setterinfo = {
  { (JSJitGetterOp)set_onclose },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontentvisibilityautostatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontentvisibilityautostatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontentvisibilityautostatechange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontentvisibilityautostatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontentvisibilityautostatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontentvisibilityautostatechange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontentvisibilityautostatechange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontentvisibilityautostatechange_getterinfo = {
  { get_oncontentvisibilityautostatechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontentvisibilityautostatechange_setterinfo = {
  { (JSJitGetterOp)set_oncontentvisibilityautostatechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontextlost(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontextlost", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontextlost());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontextlost(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontextlost", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontextlost(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontextlost(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontextlost_getterinfo = {
  { get_oncontextlost },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontextlost_setterinfo = {
  { (JSJitGetterOp)set_oncontextlost },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontextmenu(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontextmenu", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontextmenu());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontextmenu(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontextmenu", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontextmenu(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontextmenu(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontextmenu_getterinfo = {
  { get_oncontextmenu },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontextmenu_setterinfo = {
  { (JSJitGetterOp)set_oncontextmenu },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncommand(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncommand", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncommand());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncommand(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncommand", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncommand(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncommand(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncommand_getterinfo = {
  { get_oncommand },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncommand_setterinfo = {
  { (JSJitGetterOp)set_oncommand },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontextrestored(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontextrestored", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontextrestored());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontextrestored(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncontextrestored", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontextrestored(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontextrestored(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontextrestored_getterinfo = {
  { get_oncontextrestored },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontextrestored_setterinfo = {
  { (JSJitGetterOp)set_oncontextrestored },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncopy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncopy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncopy());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncopy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncopy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncopy(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncopy(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncopy_getterinfo = {
  { get_oncopy },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncopy_setterinfo = {
  { (JSJitGetterOp)set_oncopy },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncuechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncuechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncuechange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncuechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncuechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncuechange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncuechange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncuechange_getterinfo = {
  { get_oncuechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncuechange_setterinfo = {
  { (JSJitGetterOp)set_oncuechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncut(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncut", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncut());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncut(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oncut", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncut(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncut(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncut_getterinfo = {
  { get_oncut },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncut_setterinfo = {
  { (JSJitGetterOp)set_oncut },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondblclick(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondblclick", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndblclick());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondblclick(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondblclick", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndblclick(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndblclick(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondblclick_getterinfo = {
  { get_ondblclick },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondblclick_setterinfo = {
  { (JSJitGetterOp)set_ondblclick },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondrag(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondrag", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndrag());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondrag(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondrag", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndrag(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndrag(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondrag_getterinfo = {
  { get_ondrag },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondrag_setterinfo = {
  { (JSJitGetterOp)set_ondrag },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondragend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndragend());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondragend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndragend(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndragend(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondragend_getterinfo = {
  { get_ondragend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondragend_setterinfo = {
  { (JSJitGetterOp)set_ondragend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondragenter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragenter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndragenter());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondragenter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragenter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndragenter(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndragenter(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondragenter_getterinfo = {
  { get_ondragenter },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondragenter_setterinfo = {
  { (JSJitGetterOp)set_ondragenter },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondragexit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragexit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndragexit());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondragexit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragexit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndragexit(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndragexit(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondragexit_getterinfo = {
  { get_ondragexit },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondragexit_setterinfo = {
  { (JSJitGetterOp)set_ondragexit },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondragleave(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragleave", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndragleave());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondragleave(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragleave", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndragleave(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndragleave(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondragleave_getterinfo = {
  { get_ondragleave },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondragleave_setterinfo = {
  { (JSJitGetterOp)set_ondragleave },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondragover(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragover", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndragover());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondragover(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragover", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndragover(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndragover(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondragover_getterinfo = {
  { get_ondragover },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondragover_setterinfo = {
  { (JSJitGetterOp)set_ondragover },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondragstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndragstart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondragstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondragstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndragstart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndragstart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondragstart_getterinfo = {
  { get_ondragstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondragstart_setterinfo = {
  { (JSJitGetterOp)set_ondragstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondrop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondrop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndrop());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondrop(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondrop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndrop(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndrop(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondrop_getterinfo = {
  { get_ondrop },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondrop_setterinfo = {
  { (JSJitGetterOp)set_ondrop },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondurationchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondurationchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndurationchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondurationchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ondurationchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndurationchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndurationchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondurationchange_getterinfo = {
  { get_ondurationchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondurationchange_setterinfo = {
  { (JSJitGetterOp)set_ondurationchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onemptied(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onemptied", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnemptied());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onemptied(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onemptied", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnemptied(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnemptied(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onemptied_getterinfo = {
  { get_onemptied },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onemptied_setterinfo = {
  { (JSJitGetterOp)set_onemptied },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onended(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onended", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnended());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onended(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onended", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnended(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnended(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onended_getterinfo = {
  { get_onended },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onended_setterinfo = {
  { (JSJitGetterOp)set_onended },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onformdata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onformdata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnformdata());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onformdata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onformdata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnformdata(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnformdata(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onformdata_getterinfo = {
  { get_onformdata },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onformdata_setterinfo = {
  { (JSJitGetterOp)set_onformdata },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oninput(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oninput", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOninput());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oninput(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oninput", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOninput(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOninput(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oninput_getterinfo = {
  { get_oninput },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oninput_setterinfo = {
  { (JSJitGetterOp)set_oninput },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oninvalid(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oninvalid", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOninvalid());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oninvalid(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "oninvalid", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOninvalid(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOninvalid(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oninvalid_getterinfo = {
  { get_oninvalid },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oninvalid_setterinfo = {
  { (JSJitGetterOp)set_oninvalid },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onkeydown(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onkeydown", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnkeydown());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onkeydown(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onkeydown", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnkeydown(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnkeydown(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onkeydown_getterinfo = {
  { get_onkeydown },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onkeydown_setterinfo = {
  { (JSJitGetterOp)set_onkeydown },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onkeypress(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onkeypress", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnkeypress());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onkeypress(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onkeypress", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnkeypress(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnkeypress(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onkeypress_getterinfo = {
  { get_onkeypress },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onkeypress_setterinfo = {
  { (JSJitGetterOp)set_onkeypress },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onkeyup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onkeyup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnkeyup());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onkeyup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onkeyup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnkeyup(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnkeyup(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onkeyup_getterinfo = {
  { get_onkeyup },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onkeyup_setterinfo = {
  { (JSJitGetterOp)set_onkeyup },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnload());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnload(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnload(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onload_getterinfo = {
  { get_onload },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onload_setterinfo = {
  { (JSJitGetterOp)set_onload },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onloadeddata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onloadeddata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnloadeddata());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onloadeddata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onloadeddata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnloadeddata(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnloadeddata(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onloadeddata_getterinfo = {
  { get_onloadeddata },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onloadeddata_setterinfo = {
  { (JSJitGetterOp)set_onloadeddata },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onloadedmetadata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onloadedmetadata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnloadedmetadata());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onloadedmetadata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onloadedmetadata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnloadedmetadata(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnloadedmetadata(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onloadedmetadata_getterinfo = {
  { get_onloadedmetadata },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onloadedmetadata_setterinfo = {
  { (JSJitGetterOp)set_onloadedmetadata },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onloadstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onloadstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnloadstart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onloadstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onloadstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnloadstart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnloadstart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onloadstart_getterinfo = {
  { get_onloadstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onloadstart_setterinfo = {
  { (JSJitGetterOp)set_onloadstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmousedown(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmousedown", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmousedown());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmousedown(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmousedown", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmousedown(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmousedown(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmousedown_getterinfo = {
  { get_onmousedown },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmousedown_setterinfo = {
  { (JSJitGetterOp)set_onmousedown },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmouseenter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseenter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmouseenter());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmouseenter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseenter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmouseenter(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmouseenter(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmouseenter_getterinfo = {
  { get_onmouseenter },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmouseenter_setterinfo = {
  { (JSJitGetterOp)set_onmouseenter },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmouseleave(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseleave", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmouseleave());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmouseleave(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseleave", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmouseleave(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmouseleave(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmouseleave_getterinfo = {
  { get_onmouseleave },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmouseleave_setterinfo = {
  { (JSJitGetterOp)set_onmouseleave },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmousemove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmousemove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmousemove());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmousemove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmousemove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmousemove(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmousemove(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmousemove_getterinfo = {
  { get_onmousemove },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmousemove_setterinfo = {
  { (JSJitGetterOp)set_onmousemove },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmouseout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseout", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmouseout());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmouseout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseout", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmouseout(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmouseout(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmouseout_getterinfo = {
  { get_onmouseout },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmouseout_setterinfo = {
  { (JSJitGetterOp)set_onmouseout },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmouseover(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseover", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmouseover());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmouseover(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseover", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmouseover(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmouseover(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmouseover_getterinfo = {
  { get_onmouseover },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmouseover_setterinfo = {
  { (JSJitGetterOp)set_onmouseover },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmouseup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmouseup());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmouseup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmouseup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmouseup(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmouseup(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmouseup_getterinfo = {
  { get_onmouseup },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmouseup_setterinfo = {
  { (JSJitGetterOp)set_onmouseup },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onwheel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwheel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnwheel());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onwheel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwheel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnwheel(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnwheel(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onwheel_getterinfo = {
  { get_onwheel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onwheel_setterinfo = {
  { (JSJitGetterOp)set_onwheel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpaste(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpaste", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpaste());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpaste(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpaste", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpaste(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpaste(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpaste_getterinfo = {
  { get_onpaste },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpaste_setterinfo = {
  { (JSJitGetterOp)set_onpaste },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpause(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpause", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpause());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpause(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpause", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpause(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpause(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpause_getterinfo = {
  { get_onpause },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpause_setterinfo = {
  { (JSJitGetterOp)set_onpause },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onplay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onplay", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnplay());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onplay(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onplay", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnplay(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnplay(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onplay_getterinfo = {
  { get_onplay },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onplay_setterinfo = {
  { (JSJitGetterOp)set_onplay },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onplaying(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onplaying", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnplaying());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onplaying(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onplaying", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnplaying(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnplaying(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onplaying_getterinfo = {
  { get_onplaying },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onplaying_setterinfo = {
  { (JSJitGetterOp)set_onplaying },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onprogress(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onprogress", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnprogress());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onprogress(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onprogress", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnprogress(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnprogress(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onprogress_getterinfo = {
  { get_onprogress },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onprogress_setterinfo = {
  { (JSJitGetterOp)set_onprogress },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onratechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onratechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnratechange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onratechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onratechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnratechange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnratechange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onratechange_getterinfo = {
  { get_onratechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onratechange_setterinfo = {
  { (JSJitGetterOp)set_onratechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onreset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onreset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnreset());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onreset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onreset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnreset(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnreset(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onreset_getterinfo = {
  { get_onreset },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onreset_setterinfo = {
  { (JSJitGetterOp)set_onreset },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onresize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onresize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnresize());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onresize(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onresize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnresize(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnresize(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onresize_getterinfo = {
  { get_onresize },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onresize_setterinfo = {
  { (JSJitGetterOp)set_onresize },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onscroll(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onscroll", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnscroll());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onscroll(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onscroll", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnscroll(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnscroll(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onscroll_getterinfo = {
  { get_onscroll },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onscroll_setterinfo = {
  { (JSJitGetterOp)set_onscroll },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onscrollend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onscrollend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnscrollend());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onscrollend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onscrollend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnscrollend(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnscrollend(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onscrollend_getterinfo = {
  { get_onscrollend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onscrollend_setterinfo = {
  { (JSJitGetterOp)set_onscrollend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onsecuritypolicyviolation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onsecuritypolicyviolation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnsecuritypolicyviolation());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onsecuritypolicyviolation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onsecuritypolicyviolation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnsecuritypolicyviolation(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnsecuritypolicyviolation(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onsecuritypolicyviolation_getterinfo = {
  { get_onsecuritypolicyviolation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onsecuritypolicyviolation_setterinfo = {
  { (JSJitGetterOp)set_onsecuritypolicyviolation },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onseeked(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onseeked", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnseeked());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onseeked(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onseeked", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnseeked(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnseeked(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onseeked_getterinfo = {
  { get_onseeked },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onseeked_setterinfo = {
  { (JSJitGetterOp)set_onseeked },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onseeking(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onseeking", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnseeking());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onseeking(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onseeking", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnseeking(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnseeking(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onseeking_getterinfo = {
  { get_onseeking },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onseeking_setterinfo = {
  { (JSJitGetterOp)set_onseeking },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onselect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onselect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnselect());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onselect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onselect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnselect(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnselect(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onselect_getterinfo = {
  { get_onselect },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onselect_setterinfo = {
  { (JSJitGetterOp)set_onselect },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onslotchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onslotchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnslotchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onslotchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onslotchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnslotchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnslotchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onslotchange_getterinfo = {
  { get_onslotchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onslotchange_setterinfo = {
  { (JSJitGetterOp)set_onslotchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onstalled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onstalled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnstalled());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onstalled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onstalled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnstalled(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnstalled(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onstalled_getterinfo = {
  { get_onstalled },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onstalled_setterinfo = {
  { (JSJitGetterOp)set_onstalled },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onsubmit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onsubmit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnsubmit());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onsubmit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onsubmit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnsubmit(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnsubmit(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onsubmit_getterinfo = {
  { get_onsubmit },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onsubmit_setterinfo = {
  { (JSJitGetterOp)set_onsubmit },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onsuspend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onsuspend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnsuspend());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onsuspend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onsuspend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnsuspend(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnsuspend(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onsuspend_getterinfo = {
  { get_onsuspend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onsuspend_setterinfo = {
  { (JSJitGetterOp)set_onsuspend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontimeupdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontimeupdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntimeupdate());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontimeupdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontimeupdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntimeupdate(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntimeupdate(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontimeupdate_getterinfo = {
  { get_ontimeupdate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontimeupdate_setterinfo = {
  { (JSJitGetterOp)set_ontimeupdate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onvolumechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvolumechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnvolumechange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onvolumechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onvolumechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnvolumechange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnvolumechange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onvolumechange_getterinfo = {
  { get_onvolumechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onvolumechange_setterinfo = {
  { (JSJitGetterOp)set_onvolumechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onwaiting(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwaiting", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnwaiting());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onwaiting(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwaiting", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnwaiting(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnwaiting(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onwaiting_getterinfo = {
  { get_onwaiting },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onwaiting_setterinfo = {
  { (JSJitGetterOp)set_onwaiting },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onselectstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onselectstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnselectstart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onselectstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onselectstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnselectstart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnselectstart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onselectstart_getterinfo = {
  { get_onselectstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onselectstart_setterinfo = {
  { (JSJitGetterOp)set_onselectstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onselectionchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onselectionchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnselectionchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onselectionchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onselectionchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnselectionchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnselectionchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onselectionchange_getterinfo = {
  { get_onselectionchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onselectionchange_setterinfo = {
  { (JSJitGetterOp)set_onselectionchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontoggle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontoggle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntoggle());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontoggle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontoggle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntoggle(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntoggle(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontoggle_getterinfo = {
  { get_ontoggle },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontoggle_setterinfo = {
  { (JSJitGetterOp)set_ontoggle },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointercancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointercancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointercancel());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointercancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointercancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointercancel(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointercancel(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointercancel_getterinfo = {
  { get_onpointercancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointercancel_setterinfo = {
  { (JSJitGetterOp)set_onpointercancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerdown(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerdown", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerdown());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerdown(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerdown", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerdown(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerdown(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerdown_getterinfo = {
  { get_onpointerdown },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerdown_setterinfo = {
  { (JSJitGetterOp)set_onpointerdown },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerup());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerup(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerup(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerup_getterinfo = {
  { get_onpointerup },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerup_setterinfo = {
  { (JSJitGetterOp)set_onpointerup },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointermove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointermove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointermove());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointermove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointermove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointermove(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointermove(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointermove_getterinfo = {
  { get_onpointermove },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointermove_setterinfo = {
  { (JSJitGetterOp)set_onpointermove },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerout", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerout());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerout", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerout(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerout(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerout_getterinfo = {
  { get_onpointerout },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerout_setterinfo = {
  { (JSJitGetterOp)set_onpointerout },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerover(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerover", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerover());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerover(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerover", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerover(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerover(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerover_getterinfo = {
  { get_onpointerover },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerover_setterinfo = {
  { (JSJitGetterOp)set_onpointerover },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerenter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerenter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerenter());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerenter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerenter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerenter(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerenter(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerenter_getterinfo = {
  { get_onpointerenter },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerenter_setterinfo = {
  { (JSJitGetterOp)set_onpointerenter },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerleave(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerleave", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerleave());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerleave(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerleave", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerleave(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerleave(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerleave_getterinfo = {
  { get_onpointerleave },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerleave_setterinfo = {
  { (JSJitGetterOp)set_onpointerleave },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpointerrawupdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerrawupdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpointerrawupdate());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpointerrawupdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpointerrawupdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpointerrawupdate(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpointerrawupdate(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpointerrawupdate_getterinfo = {
  { get_onpointerrawupdate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpointerrawupdate_setterinfo = {
  { (JSJitGetterOp)set_onpointerrawupdate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ongotpointercapture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ongotpointercapture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOngotpointercapture());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ongotpointercapture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ongotpointercapture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOngotpointercapture(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOngotpointercapture(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ongotpointercapture_getterinfo = {
  { get_ongotpointercapture },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ongotpointercapture_setterinfo = {
  { (JSJitGetterOp)set_ongotpointercapture },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onlostpointercapture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onlostpointercapture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnlostpointercapture());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onlostpointercapture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onlostpointercapture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnlostpointercapture(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnlostpointercapture(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onlostpointercapture_getterinfo = {
  { get_onlostpointercapture },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onlostpointercapture_setterinfo = {
  { (JSJitGetterOp)set_onlostpointercapture },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmozfullscreenchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmozfullscreenchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eMozfullscreenchangeDeprecatedPrefix);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmozfullscreenchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmozfullscreenchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmozfullscreenchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eMozfullscreenchangeDeprecatedPrefix);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmozfullscreenchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmozfullscreenchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmozfullscreenchange_getterinfo = {
  { get_onmozfullscreenchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmozfullscreenchange_setterinfo = {
  { (JSJitGetterOp)set_onmozfullscreenchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmozfullscreenerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmozfullscreenerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eMozfullscreenerrorDeprecatedPrefix);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmozfullscreenerror());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmozfullscreenerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmozfullscreenerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eMozfullscreenerrorDeprecatedPrefix);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmozfullscreenerror(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmozfullscreenerror(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmozfullscreenerror_getterinfo = {
  { get_onmozfullscreenerror },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmozfullscreenerror_setterinfo = {
  { (JSJitGetterOp)set_onmozfullscreenerror },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onanimationcancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationcancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnanimationcancel());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onanimationcancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationcancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnanimationcancel(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnanimationcancel(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onanimationcancel_getterinfo = {
  { get_onanimationcancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onanimationcancel_setterinfo = {
  { (JSJitGetterOp)set_onanimationcancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onanimationend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnanimationend());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onanimationend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnanimationend(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnanimationend(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onanimationend_getterinfo = {
  { get_onanimationend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onanimationend_setterinfo = {
  { (JSJitGetterOp)set_onanimationend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onanimationiteration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationiteration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnanimationiteration());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onanimationiteration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationiteration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnanimationiteration(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnanimationiteration(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onanimationiteration_getterinfo = {
  { get_onanimationiteration },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onanimationiteration_setterinfo = {
  { (JSJitGetterOp)set_onanimationiteration },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onanimationstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnanimationstart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onanimationstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onanimationstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnanimationstart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnanimationstart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onanimationstart_getterinfo = {
  { get_onanimationstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onanimationstart_setterinfo = {
  { (JSJitGetterOp)set_onanimationstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontransitioncancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitioncancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntransitioncancel());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontransitioncancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitioncancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntransitioncancel(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntransitioncancel(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontransitioncancel_getterinfo = {
  { get_ontransitioncancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontransitioncancel_setterinfo = {
  { (JSJitGetterOp)set_ontransitioncancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontransitionend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitionend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntransitionend());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontransitionend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitionend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntransitionend(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntransitionend(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontransitionend_getterinfo = {
  { get_ontransitionend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontransitionend_setterinfo = {
  { (JSJitGetterOp)set_ontransitionend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontransitionrun(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitionrun", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntransitionrun());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontransitionrun(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitionrun", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntransitionrun(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntransitionrun(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontransitionrun_getterinfo = {
  { get_ontransitionrun },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontransitionrun_setterinfo = {
  { (JSJitGetterOp)set_ontransitionrun },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontransitionstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitionstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntransitionstart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontransitionstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontransitionstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntransitionstart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntransitionstart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontransitionstart_getterinfo = {
  { get_ontransitionstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontransitionstart_setterinfo = {
  { (JSJitGetterOp)set_ontransitionstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onwebkitanimationend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkitanimationend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnwebkitAnimationEnd());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onwebkitanimationend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkitanimationend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnwebkitAnimationEnd(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnwebkitAnimationEnd(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onwebkitanimationend_getterinfo = {
  { get_onwebkitanimationend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onwebkitanimationend_setterinfo = {
  { (JSJitGetterOp)set_onwebkitanimationend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onwebkitanimationiteration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkitanimationiteration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnwebkitAnimationIteration());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onwebkitanimationiteration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkitanimationiteration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnwebkitAnimationIteration(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnwebkitAnimationIteration(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onwebkitanimationiteration_getterinfo = {
  { get_onwebkitanimationiteration },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onwebkitanimationiteration_setterinfo = {
  { (JSJitGetterOp)set_onwebkitanimationiteration },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onwebkitanimationstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkitanimationstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnwebkitAnimationStart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onwebkitanimationstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkitanimationstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnwebkitAnimationStart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnwebkitAnimationStart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onwebkitanimationstart_getterinfo = {
  { get_onwebkitanimationstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onwebkitanimationstart_setterinfo = {
  { (JSJitGetterOp)set_onwebkitanimationstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onwebkittransitionend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkittransitionend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnwebkitTransitionEnd());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onwebkittransitionend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onwebkittransitionend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnwebkitTransitionEnd(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnwebkitTransitionEnd(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onwebkittransitionend_getterinfo = {
  { get_onwebkittransitionend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onwebkittransitionend_setterinfo = {
  { (JSJitGetterOp)set_onwebkittransitionend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<OnErrorEventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnerror());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastOnErrorEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastOnErrorEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnerror(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnerror(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onerror_getterinfo = {
  { get_onerror },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onerror_setterinfo = {
  { (JSJitGetterOp)set_onerror },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_speechSynthesis(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "speechSynthesis", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::SpeechSynthesis>(MOZ_KnownLive(self)->GetSpeechSynthesis(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.speechSynthesis getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo speechSynthesis_getterinfo = {
  { get_speechSynthesis },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontouchstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntouchstart());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontouchstart(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchstart", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntouchstart(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntouchstart(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontouchstart_getterinfo = {
  { get_ontouchstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontouchstart_setterinfo = {
  { (JSJitGetterOp)set_ontouchstart },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontouchend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntouchend());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontouchend(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchend", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntouchend(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntouchend(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontouchend_getterinfo = {
  { get_ontouchend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontouchend_setterinfo = {
  { (JSJitGetterOp)set_ontouchend },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontouchmove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchmove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntouchmove());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontouchmove(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchmove", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntouchmove(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntouchmove(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontouchmove_getterinfo = {
  { get_ontouchmove },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontouchmove_setterinfo = {
  { (JSJitGetterOp)set_ontouchmove },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontouchcancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchcancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntouchcancel());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontouchcancel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ontouchcancel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntouchcancel(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntouchcancel(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontouchcancel_getterinfo = {
  { get_ontouchcancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontouchcancel_setterinfo = {
  { (JSJitGetterOp)set_ontouchcancel },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onafterprint(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onafterprint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnafterprint());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onafterprint(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onafterprint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnafterprint(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnafterprint(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onafterprint_getterinfo = {
  { get_onafterprint },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onafterprint_setterinfo = {
  { (JSJitGetterOp)set_onafterprint },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onbeforeprint(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforeprint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnbeforeprint());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onbeforeprint(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforeprint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnbeforeprint(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnbeforeprint(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onbeforeprint_getterinfo = {
  { get_onbeforeprint },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onbeforeprint_setterinfo = {
  { (JSJitGetterOp)set_onbeforeprint },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onbeforeunload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforeunload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<OnBeforeUnloadEventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnbeforeunload());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onbeforeunload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onbeforeunload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastOnBeforeUnloadEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastOnBeforeUnloadEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnbeforeunload(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnbeforeunload(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onbeforeunload_getterinfo = {
  { get_onbeforeunload },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onbeforeunload_setterinfo = {
  { (JSJitGetterOp)set_onbeforeunload },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onhashchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onhashchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnhashchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onhashchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onhashchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnhashchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnhashchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onhashchange_getterinfo = {
  { get_onhashchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onhashchange_setterinfo = {
  { (JSJitGetterOp)set_onhashchange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onlanguagechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onlanguagechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnlanguagechange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onlanguagechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onlanguagechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnlanguagechange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnlanguagechange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onlanguagechange_getterinfo = {
  { get_onlanguagechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onlanguagechange_setterinfo = {
  { (JSJitGetterOp)set_onlanguagechange },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmessage());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmessage(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmessage(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmessage_getterinfo = {
  { get_onmessage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmessage_setterinfo = {
  { (JSJitGetterOp)set_onmessage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmessageerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmessageerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmessageerror());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmessageerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onmessageerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmessageerror(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmessageerror(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmessageerror_getterinfo = {
  { get_onmessageerror },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmessageerror_setterinfo = {
  { (JSJitGetterOp)set_onmessageerror },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onoffline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onoffline", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnoffline());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onoffline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onoffline", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnoffline(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnoffline(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onoffline_getterinfo = {
  { get_onoffline },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onoffline_setterinfo = {
  { (JSJitGetterOp)set_onoffline },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ononline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ononline", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnonline());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ononline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ononline", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnonline(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnonline(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ononline_getterinfo = {
  { get_ononline },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ononline_setterinfo = {
  { (JSJitGetterOp)set_ononline },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpagehide(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpagehide", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpagehide());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpagehide(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpagehide", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpagehide(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpagehide(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpagehide_getterinfo = {
  { get_onpagehide },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpagehide_setterinfo = {
  { (JSJitGetterOp)set_onpagehide },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpagereveal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpagereveal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpagereveal());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpagereveal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpagereveal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpagereveal(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpagereveal(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpagereveal_getterinfo = {
  { get_onpagereveal },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpagereveal_setterinfo = {
  { (JSJitGetterOp)set_onpagereveal },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpageshow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpageshow", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpageshow());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpageshow(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpageshow", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpageshow(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpageshow(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpageshow_getterinfo = {
  { get_onpageshow },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpageshow_setterinfo = {
  { (JSJitGetterOp)set_onpageshow },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onpopstate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpopstate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnpopstate());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onpopstate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onpopstate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnpopstate(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnpopstate(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onpopstate_getterinfo = {
  { get_onpopstate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onpopstate_setterinfo = {
  { (JSJitGetterOp)set_onpopstate },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onrejectionhandled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onrejectionhandled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnrejectionhandled());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onrejectionhandled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onrejectionhandled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnrejectionhandled(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnrejectionhandled(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onrejectionhandled_getterinfo = {
  { get_onrejectionhandled },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onrejectionhandled_setterinfo = {
  { (JSJitGetterOp)set_onrejectionhandled },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onstorage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onstorage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnstorage());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onstorage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onstorage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnstorage(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnstorage(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onstorage_getterinfo = {
  { get_onstorage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onstorage_setterinfo = {
  { (JSJitGetterOp)set_onstorage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onunhandledrejection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onunhandledrejection", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnunhandledrejection());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onunhandledrejection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onunhandledrejection", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnunhandledrejection(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnunhandledrejection(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onunhandledrejection_getterinfo = {
  { get_onunhandledrejection },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onunhandledrejection_setterinfo = {
  { (JSJitGetterOp)set_onunhandledrejection },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onunload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onunload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnunload());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onunload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "onunload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnunload(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnunload(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onunload_getterinfo = {
  { get_onunload },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onunload_setterinfo = {
  { (JSJitGetterOp)set_onunload },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ongamepadconnected(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ongamepadconnected", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOngamepadconnected());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ongamepadconnected(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ongamepadconnected", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOngamepadconnected(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOngamepadconnected(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ongamepadconnected_getterinfo = {
  { get_ongamepadconnected },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ongamepadconnected_setterinfo = {
  { (JSJitGetterOp)set_ongamepadconnected },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ongamepaddisconnected(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ongamepaddisconnected", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOngamepaddisconnected());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ongamepaddisconnected(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "ongamepaddisconnected", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOngamepaddisconnected(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOngamepaddisconnected(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ongamepaddisconnected_getterinfo = {
  { get_ongamepaddisconnected },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ongamepaddisconnected_setterinfo = {
  { (JSJitGetterOp)set_ongamepaddisconnected },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_localStorage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "localStorage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Storage>(MOZ_KnownLive(self)->GetLocalStorage(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.localStorage getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo localStorage_getterinfo = {
  { get_localStorage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_origin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "origin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetOrigin(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetOrigin(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_origin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "origin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "origin", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo origin_getterinfo = {
  { get_origin },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo origin_setterinfo = {
  { (JSJitGetterOp)set_origin },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_crossOriginIsolated(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "crossOriginIsolated", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->CrossOriginIsolated());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo crossOriginIsolated_getterinfo = {
  { get_crossOriginIsolated },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
reportError(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "reportError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.reportError", 1)) {
    return false;
  }
  JS::Rooted<JS::Value> arg0(cx);
  arg0 = args[0];
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReportError(cx, arg0, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ReportError(cx, arg0, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.reportError"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo reportError_methodinfo = {
  { (JSJitGetterOp)reportError },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
btoa(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "btoa", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.btoa", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Btoa(NonNullHelper(Constify(arg0)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Btoa(NonNullHelper(Constify(arg0)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.btoa"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo btoa_methodinfo = {
  { (JSJitGetterOp)btoa },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
atob(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "atob", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.atob", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Atob(NonNullHelper(Constify(arg0)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Atob(NonNullHelper(Constify(arg0)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.atob"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo atob_methodinfo = {
  { (JSJitGetterOp)atob },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setTimeout(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.setTimeout");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "setTimeout", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.setTimeout", 1)) {
    return false;
  }
  FunctionOrTrustedScriptOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  int32_t arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = 0;
  }
  AutoSequence<JS::Value> arg2;
  SequenceRooter<JS::Value> arg2_holder(cx, &arg2);
  if (args.length() > 2) {
    if (!arg2.SetCapacity(args.length() - 2, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 2; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg2.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  int32_t result(MOZ_KnownLive(self)->SetTimeout(cx, Constify(arg0), arg1, Constify(arg2), MOZ_KnownLive(subjectPrincipal), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.setTimeout"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo setTimeout_methodinfo = {
  { (JSJitGetterOp)setTimeout },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearTimeout(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "clearTimeout", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  int32_t arg0;
  if (args.hasDefined(0)) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
      return false;
    }
  } else {
    arg0 = 0;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearTimeout(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearTimeout(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearTimeout_methodinfo = {
  { (JSJitGetterOp)clearTimeout },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setInterval(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.setInterval");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "setInterval", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.setInterval", 1)) {
    return false;
  }
  FunctionOrTrustedScriptOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  int32_t arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = 0;
  }
  AutoSequence<JS::Value> arg2;
  SequenceRooter<JS::Value> arg2_holder(cx, &arg2);
  if (args.length() > 2) {
    if (!arg2.SetCapacity(args.length() - 2, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 2; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg2.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  int32_t result(MOZ_KnownLive(self)->SetInterval(cx, Constify(arg0), arg1, Constify(arg2), MOZ_KnownLive(subjectPrincipal), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.setInterval"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo setInterval_methodinfo = {
  { (JSJitGetterOp)setInterval },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearInterval(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "clearInterval", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  int32_t arg0;
  if (args.hasDefined(0)) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
      return false;
    }
  } else {
    arg0 = 0;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearInterval(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearInterval(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearInterval_methodinfo = {
  { (JSJitGetterOp)clearInterval },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
queueMicrotask(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.queueMicrotask");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "queueMicrotask", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.queueMicrotask", 1)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastVoidFunction>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastVoidFunction(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->QueueMicrotask(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->QueueMicrotask(MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo queueMicrotask_methodinfo = {
  { (JSJitGetterOp)queueMicrotask },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createImageBitmap(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.createImageBitmap");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "createImageBitmap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  unsigned argcount = std::min(args.length(), 6u);
  switch (argcount) {
    case 1: {
      [[fallthrough]];
    }
    case 2: {
      HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      binding_detail::FastImageBitmapOptions arg1;
      if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CreateImageBitmap(Constify(arg0), Constify(arg1), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.createImageBitmap"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 5: {
      [[fallthrough]];
    }
    case 6: {
      HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      binding_detail::FastImageBitmapOptions arg5;
      if (!arg5.Init(cx, (args.hasDefined(5)) ? args[5] : JS::NullHandleValue, "Argument 6", false)) {
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CreateImageBitmap(Constify(arg0), arg1, arg2, arg3, arg4, Constify(arg5), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.createImageBitmap"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
createImageBitmap_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = createImageBitmap(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo createImageBitmap_methodinfo = {
  { (JSJitGetterOp)createImageBitmap_promiseWrapper },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
structuredClone(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.structuredClone");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "structuredClone", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.structuredClone", 1)) {
    return false;
  }
  JS::Rooted<JS::Value> arg0(cx);
  arg0 = args[0];
  RootedDictionary<binding_detail::FastStructuredSerializeOptions> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StructuredClone(cx, arg0, Constify(arg1), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->StructuredClone(cx, arg0, Constify(arg1), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.structuredClone"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo structuredClone_methodinfo = {
  { (JSJitGetterOp)structuredClone },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fetch(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Window.fetch");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "fetch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.fetch", 1)) {
    return false;
  }
  RequestOrUTF8String arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  RootedDictionary<binding_detail::FastRequestInit> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Fetch(Constify(arg0), Constify(arg1), nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.fetch"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
fetch_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = fetch(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo fetch_methodinfo = {
  { (JSJitGetterOp)fetch_promiseWrapper },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isSecureContext(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "isSecureContext", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  bool result(MOZ_KnownLive(self)->IsSecureContext());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isSecureContext_getterinfo = {
  { get_isSecureContext },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_indexedDB(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "indexedDB", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::IDBFactory>(MOZ_KnownLive(self)->GetIndexedDB(cx, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.indexedDB getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo indexedDB_getterinfo = {
  { get_indexedDB },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_caches(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "caches", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::cache::CacheStorage>(MOZ_KnownLive(self)->GetCaches(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.caches getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo caches_getterinfo = {
  { get_caches },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_scheduler(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scheduler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::WebTaskScheduler>(MOZ_KnownLive(self)->Scheduler()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_scheduler(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "scheduler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "scheduler", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo scheduler_getterinfo = {
  { get_scheduler },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo scheduler_setterinfo = {
  { (JSJitGetterOp)set_scheduler },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_trustedTypes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "trustedTypes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::TrustedTypePolicyFactory>(MOZ_KnownLive(self)->TrustedTypes()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo trustedTypes_getterinfo = {
  { get_trustedTypes },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isRFPTargetActive(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "isRFPTargetActive", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  if (!args.requireAtLeast(cx, "Window.isRFPTargetActive", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->IsRFPTargetActive(NonNullHelper(Constify(arg0)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.isRFPTargetActive"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isRFPTargetActive_methodinfo = {
  { (JSJitGetterOp)isRFPTargetActive },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_sessionStorage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Window", "sessionStorage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsGlobalWindowInner*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Storage>(MOZ_KnownLive(self)->GetSessionStorage(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Window.sessionStorage getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo sessionStorage_getterinfo = {
  { get_sessionStorage },
  { prototypes::id::Window },
  { PrototypeTraits<prototypes::id::Window>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  nsGlobalWindowInner* self = UnwrapPossiblyNotInitializedDOMObject<nsGlobalWindowInner>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    mozilla::dom::FinalizeGlobal(gcx, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<nsGlobalWindowInner>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("close", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&close_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stop", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stop_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("focus", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&focus_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blur", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blur_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("open", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&open_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("alert", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&alert_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("confirm", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&confirm_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("prompt", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&prompt_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("print", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&print_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("printPreview", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&printPreview_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("postMessage", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&postMessage_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("captureEvents", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&captureEvents_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("releaseEvents", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&releaseEvents_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getSelection", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getSelection_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getComputedStyle", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getComputedStyle_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("matchMedia", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&matchMedia_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("moveTo", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&moveTo_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("moveBy", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&moveBy_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("resizeTo", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&resizeTo_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("resizeBy", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&resizeBy_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scroll", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scroll_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scrollTo", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scrollTo_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scrollBy", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scrollBy_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getDefaultComputedStyle", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getDefaultComputedStyle_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scrollByLines", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scrollByLines_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scrollByPages", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scrollByPages_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("updateCommands", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&updateCommands_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("find", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&find_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dump", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&dump_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setResizable", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setResizable_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("getAttention", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAttention_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAttentionWithCycleCount", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAttentionWithCycleCount_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setCursor", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setCursor_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("maximize", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&maximize_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("minimize", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&minimize_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restore", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&restore_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getWorkspaceID", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getWorkspaceID_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("moveToWorkspace", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&moveToWorkspace_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("notifyDefaultButtonLoaded", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&notifyDefaultButtonLoaded_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getGroupMessageManager", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getGroupMessageManager_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("promiseDocumentFlushed", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&promiseDocumentFlushed_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("requestIdleCallback", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&requestIdleCallback_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cancelIdleCallback", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&cancelIdleCallback_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("getWebExposedLocales", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getWebExposedLocales_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("requestAnimationFrame", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&requestAnimationFrame_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cancelAnimationFrame", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&cancelAnimationFrame_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("reportError", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&reportError_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("btoa", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&btoa_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("atob", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&atob_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setTimeout", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setTimeout_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearTimeout", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearTimeout_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setInterval", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setInterval_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearInterval", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearInterval_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("queueMicrotask", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&queueMicrotask_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createImageBitmap", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&createImageBitmap_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("structuredClone", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&structuredClone_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fetch", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&fetch_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("isRFPTargetActive", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isRFPTargetActive_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sMethods_disablers10 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &nsContentUtils::IsCallerChromeOrFuzzingEnabled
};

static const PrefableDisablers sMethods_disablers33 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &nsGlobalWindowInner::IsPrivilegedChromeWindow
};

static const PrefableDisablers sMethods_disablers48 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &IsChromeOrUAWidget
};

static const PrefableDisablers sMethods_disablers64 = {
  WebIDLPrefIndex::privacy_fingerprintingProtection_testing, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { &sMethods_disablers10, &sMethods_specs[10] },
  { nullptr, &sMethods_specs[12] },
  { &sMethods_disablers33, &sMethods_specs[33] },
  { nullptr, &sMethods_specs[45] },
  { &sMethods_disablers48, &sMethods_specs[48] },
  { nullptr, &sMethods_specs[50] },
  { &sMethods_disablers64, &sMethods_specs[64] },
  { nullptr, nullptr }
};

static_assert(8 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(20 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("moveResize", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&moveResize_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("mozScrollSnap", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&mozScrollSnap_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sizeToContent", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sizeToContent_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("openDialog", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&openDialog_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getInterface", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getInterface_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("shouldReportForServiceWorkerScope", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&shouldReportForServiceWorkerScope_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("synthesizeMouseEvent", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&synthesizeMouseEvent_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("synthesizeTouchEvent", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&synthesizeTouchEvent_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setScrollMarks", (GenericMethod<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setScrollMarks_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(9 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("self", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &self_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &self_setterinfo),
  JSPropertySpec::nativeAccessors("name", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &name_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &name_setterinfo),
  JSPropertySpec::nativeAccessors("history", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &history_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("navigation", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &navigation_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &navigation_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("customElements", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &customElements_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("locationbar", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &locationbar_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &locationbar_setterinfo),
  JSPropertySpec::nativeAccessors("menubar", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &menubar_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &menubar_setterinfo),
  JSPropertySpec::nativeAccessors("personalbar", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &personalbar_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &personalbar_setterinfo),
  JSPropertySpec::nativeAccessors("scrollbars", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollbars_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &scrollbars_setterinfo),
  JSPropertySpec::nativeAccessors("statusbar", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &statusbar_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &statusbar_setterinfo),
  JSPropertySpec::nativeAccessors("toolbar", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &toolbar_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &toolbar_setterinfo),
  JSPropertySpec::nativeAccessors("status", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &status_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &status_setterinfo),
  JSPropertySpec::nativeAccessors("closed", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &closed_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("event", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &event_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &event_setterinfo),
  JSPropertySpec::nativeAccessors("frames", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &frames_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &frames_setterinfo),
  JSPropertySpec::nativeAccessors("length", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &length_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &length_setterinfo),
  JSPropertySpec::nativeAccessors("opener", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &opener_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &opener_setterinfo),
  JSPropertySpec::nativeAccessors("parent", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &parent_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &parent_setterinfo),
  JSPropertySpec::nativeAccessors("frameElement", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &frameElement_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("navigator", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &navigator_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("clientInformation", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &clientInformation_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &clientInformation_setterinfo),
  JSPropertySpec::nativeAccessors("external", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &external_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &external_setterinfo),
  JSPropertySpec::nativeAccessors("screen", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screen_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &screen_setterinfo),
  JSPropertySpec::nativeAccessors("innerWidth", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &innerWidth_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &innerWidth_setterinfo),
  JSPropertySpec::nativeAccessors("innerHeight", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &innerHeight_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &innerHeight_setterinfo),
  JSPropertySpec::nativeAccessors("scrollX", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollX_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &scrollX_setterinfo),
  JSPropertySpec::nativeAccessors("pageXOffset", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &pageXOffset_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &pageXOffset_setterinfo),
  JSPropertySpec::nativeAccessors("scrollY", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollY_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &scrollY_setterinfo),
  JSPropertySpec::nativeAccessors("pageYOffset", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &pageYOffset_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &pageYOffset_setterinfo),
  JSPropertySpec::nativeAccessors("screenLeft", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screenLeft_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &screenLeft_setterinfo),
  JSPropertySpec::nativeAccessors("screenTop", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screenTop_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &screenTop_setterinfo),
  JSPropertySpec::nativeAccessors("screenX", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screenX_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &screenX_setterinfo),
  JSPropertySpec::nativeAccessors("screenY", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screenY_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &screenY_setterinfo),
  JSPropertySpec::nativeAccessors("outerWidth", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &outerWidth_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &outerWidth_setterinfo),
  JSPropertySpec::nativeAccessors("outerHeight", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &outerHeight_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &outerHeight_setterinfo),
  JSPropertySpec::nativeAccessors("performance", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &performance_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &performance_setterinfo),
  JSPropertySpec::nativeAccessors("mozInnerScreenX", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &mozInnerScreenX_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("mozInnerScreenY", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &mozInnerScreenY_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("devicePixelRatio", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &devicePixelRatio_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &devicePixelRatio_setterinfo),
  JSPropertySpec::nativeAccessors("scrollMaxX", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollMaxX_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &scrollMaxX_setterinfo),
  JSPropertySpec::nativeAccessors("scrollMaxY", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollMaxY_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &scrollMaxY_setterinfo),
  JSPropertySpec::nativeAccessors("fullScreen", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &fullScreen_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &fullScreen_setterinfo),
  JSPropertySpec::nativeAccessors("ondevicemotion", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondevicemotion_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondevicemotion_setterinfo),
  JSPropertySpec::nativeAccessors("ondeviceorientation", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondeviceorientation_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondeviceorientation_setterinfo),
  JSPropertySpec::nativeAccessors("ondeviceorientationabsolute", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondeviceorientationabsolute_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondeviceorientationabsolute_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("onuserproximity", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onuserproximity_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onuserproximity_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("ondevicelight", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondevicelight_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondevicelight_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("InstallTrigger", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &InstallTrigger_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &InstallTrigger_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("windowState", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &windowState_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isFullyOccluded", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &isFullyOccluded_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isCloaked", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &isCloaked_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("browserDOMWindow", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &browserDOMWindow_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &browserDOMWindow_setterinfo),
  JSPropertySpec::nativeAccessors("messageManager", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &messageManager_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("isChromeWindow", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &isChromeWindow_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("Glean", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &Glean_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("GleanPings", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &GleanPings_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("onvrdisplayconnect", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onvrdisplayconnect_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onvrdisplayconnect_setterinfo),
  JSPropertySpec::nativeAccessors("onvrdisplaydisconnect", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onvrdisplaydisconnect_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onvrdisplaydisconnect_setterinfo),
  JSPropertySpec::nativeAccessors("onvrdisplayactivate", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onvrdisplayactivate_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onvrdisplayactivate_setterinfo),
  JSPropertySpec::nativeAccessors("onvrdisplaydeactivate", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onvrdisplaydeactivate_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onvrdisplaydeactivate_setterinfo),
  JSPropertySpec::nativeAccessors("onvrdisplaypresentchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onvrdisplaypresentchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onvrdisplaypresentchange_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("intlUtils", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &intlUtils_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("visualViewport", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &visualViewport_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &visualViewport_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("cookieStore", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &cookieStore_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("originAgentCluster", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &originAgentCluster_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("documentPictureInPicture", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &documentPictureInPicture_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("crypto", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &crypto_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("onabort", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onabort_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onabort_setterinfo),
  JSPropertySpec::nativeAccessors("onblur", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onblur_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onblur_setterinfo),
  JSPropertySpec::nativeAccessors("onfocus", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onfocus_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onfocus_setterinfo),
  JSPropertySpec::nativeAccessors("oncancel", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncancel_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncancel_setterinfo),
  JSPropertySpec::nativeAccessors("onauxclick", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onauxclick_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onauxclick_setterinfo),
  JSPropertySpec::nativeAccessors("onbeforeinput", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onbeforeinput_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onbeforeinput_setterinfo),
  JSPropertySpec::nativeAccessors("onbeforematch", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onbeforematch_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onbeforematch_setterinfo),
  JSPropertySpec::nativeAccessors("onbeforetoggle", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onbeforetoggle_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onbeforetoggle_setterinfo),
  JSPropertySpec::nativeAccessors("oncanplay", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncanplay_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncanplay_setterinfo),
  JSPropertySpec::nativeAccessors("oncanplaythrough", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncanplaythrough_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncanplaythrough_setterinfo),
  JSPropertySpec::nativeAccessors("onchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onchange_setterinfo),
  JSPropertySpec::nativeAccessors("onclick", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onclick_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onclick_setterinfo),
  JSPropertySpec::nativeAccessors("onclose", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onclose_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onclose_setterinfo),
  JSPropertySpec::nativeAccessors("oncontentvisibilityautostatechange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncontentvisibilityautostatechange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncontentvisibilityautostatechange_setterinfo),
  JSPropertySpec::nativeAccessors("oncontextlost", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncontextlost_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncontextlost_setterinfo),
  JSPropertySpec::nativeAccessors("oncontextmenu", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncontextmenu_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncontextmenu_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("oncommand", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncommand_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncommand_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("oncontextrestored", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncontextrestored_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncontextrestored_setterinfo),
  JSPropertySpec::nativeAccessors("oncopy", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncopy_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncopy_setterinfo),
  JSPropertySpec::nativeAccessors("oncuechange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncuechange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncuechange_setterinfo),
  JSPropertySpec::nativeAccessors("oncut", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oncut_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oncut_setterinfo),
  JSPropertySpec::nativeAccessors("ondblclick", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondblclick_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondblclick_setterinfo),
  JSPropertySpec::nativeAccessors("ondrag", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondrag_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondrag_setterinfo),
  JSPropertySpec::nativeAccessors("ondragend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondragend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondragend_setterinfo),
  JSPropertySpec::nativeAccessors("ondragenter", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondragenter_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondragenter_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("ondragexit", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondragexit_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondragexit_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("ondragleave", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondragleave_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondragleave_setterinfo),
  JSPropertySpec::nativeAccessors("ondragover", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondragover_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondragover_setterinfo),
  JSPropertySpec::nativeAccessors("ondragstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondragstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondragstart_setterinfo),
  JSPropertySpec::nativeAccessors("ondrop", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondrop_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondrop_setterinfo),
  JSPropertySpec::nativeAccessors("ondurationchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ondurationchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ondurationchange_setterinfo),
  JSPropertySpec::nativeAccessors("onemptied", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onemptied_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onemptied_setterinfo),
  JSPropertySpec::nativeAccessors("onended", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onended_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onended_setterinfo),
  JSPropertySpec::nativeAccessors("onformdata", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onformdata_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onformdata_setterinfo),
  JSPropertySpec::nativeAccessors("oninput", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oninput_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oninput_setterinfo),
  JSPropertySpec::nativeAccessors("oninvalid", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &oninvalid_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &oninvalid_setterinfo),
  JSPropertySpec::nativeAccessors("onkeydown", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onkeydown_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onkeydown_setterinfo),
  JSPropertySpec::nativeAccessors("onkeypress", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onkeypress_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onkeypress_setterinfo),
  JSPropertySpec::nativeAccessors("onkeyup", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onkeyup_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onkeyup_setterinfo),
  JSPropertySpec::nativeAccessors("onload", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onload_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onload_setterinfo),
  JSPropertySpec::nativeAccessors("onloadeddata", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onloadeddata_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onloadeddata_setterinfo),
  JSPropertySpec::nativeAccessors("onloadedmetadata", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onloadedmetadata_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onloadedmetadata_setterinfo),
  JSPropertySpec::nativeAccessors("onloadstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onloadstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onloadstart_setterinfo),
  JSPropertySpec::nativeAccessors("onmousedown", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmousedown_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmousedown_setterinfo),
  JSPropertySpec::nativeAccessors("onmouseenter", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectLenientThisPolicy, ThrowExceptions>, &onmouseenter_getterinfo, GenericSetter<MaybeCrossOriginObjectLenientThisPolicy>, &onmouseenter_setterinfo),
  JSPropertySpec::nativeAccessors("onmouseleave", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectLenientThisPolicy, ThrowExceptions>, &onmouseleave_getterinfo, GenericSetter<MaybeCrossOriginObjectLenientThisPolicy>, &onmouseleave_setterinfo),
  JSPropertySpec::nativeAccessors("onmousemove", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmousemove_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmousemove_setterinfo),
  JSPropertySpec::nativeAccessors("onmouseout", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmouseout_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmouseout_setterinfo),
  JSPropertySpec::nativeAccessors("onmouseover", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmouseover_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmouseover_setterinfo),
  JSPropertySpec::nativeAccessors("onmouseup", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmouseup_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmouseup_setterinfo),
  JSPropertySpec::nativeAccessors("onwheel", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onwheel_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onwheel_setterinfo),
  JSPropertySpec::nativeAccessors("onpaste", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpaste_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpaste_setterinfo),
  JSPropertySpec::nativeAccessors("onpause", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpause_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpause_setterinfo),
  JSPropertySpec::nativeAccessors("onplay", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onplay_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onplay_setterinfo),
  JSPropertySpec::nativeAccessors("onplaying", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onplaying_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onplaying_setterinfo),
  JSPropertySpec::nativeAccessors("onprogress", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onprogress_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onprogress_setterinfo),
  JSPropertySpec::nativeAccessors("onratechange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onratechange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onratechange_setterinfo),
  JSPropertySpec::nativeAccessors("onreset", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onreset_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onreset_setterinfo),
  JSPropertySpec::nativeAccessors("onresize", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onresize_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onresize_setterinfo),
  JSPropertySpec::nativeAccessors("onscroll", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onscroll_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onscroll_setterinfo),
  JSPropertySpec::nativeAccessors("onscrollend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onscrollend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onscrollend_setterinfo),
  JSPropertySpec::nativeAccessors("onsecuritypolicyviolation", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onsecuritypolicyviolation_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onsecuritypolicyviolation_setterinfo),
  JSPropertySpec::nativeAccessors("onseeked", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onseeked_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onseeked_setterinfo),
  JSPropertySpec::nativeAccessors("onseeking", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onseeking_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onseeking_setterinfo),
  JSPropertySpec::nativeAccessors("onselect", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onselect_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onselect_setterinfo),
  JSPropertySpec::nativeAccessors("onslotchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onslotchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onslotchange_setterinfo),
  JSPropertySpec::nativeAccessors("onstalled", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onstalled_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onstalled_setterinfo),
  JSPropertySpec::nativeAccessors("onsubmit", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onsubmit_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onsubmit_setterinfo),
  JSPropertySpec::nativeAccessors("onsuspend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onsuspend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onsuspend_setterinfo),
  JSPropertySpec::nativeAccessors("ontimeupdate", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontimeupdate_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontimeupdate_setterinfo),
  JSPropertySpec::nativeAccessors("onvolumechange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onvolumechange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onvolumechange_setterinfo),
  JSPropertySpec::nativeAccessors("onwaiting", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onwaiting_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onwaiting_setterinfo),
  JSPropertySpec::nativeAccessors("onselectstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onselectstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onselectstart_setterinfo),
  JSPropertySpec::nativeAccessors("onselectionchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onselectionchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onselectionchange_setterinfo),
  JSPropertySpec::nativeAccessors("ontoggle", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontoggle_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontoggle_setterinfo),
  JSPropertySpec::nativeAccessors("onpointercancel", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointercancel_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointercancel_setterinfo),
  JSPropertySpec::nativeAccessors("onpointerdown", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerdown_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerdown_setterinfo),
  JSPropertySpec::nativeAccessors("onpointerup", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerup_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerup_setterinfo),
  JSPropertySpec::nativeAccessors("onpointermove", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointermove_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointermove_setterinfo),
  JSPropertySpec::nativeAccessors("onpointerout", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerout_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerout_setterinfo),
  JSPropertySpec::nativeAccessors("onpointerover", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerover_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerover_setterinfo),
  JSPropertySpec::nativeAccessors("onpointerenter", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerenter_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerenter_setterinfo),
  JSPropertySpec::nativeAccessors("onpointerleave", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerleave_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerleave_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("onpointerrawupdate", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpointerrawupdate_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpointerrawupdate_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("ongotpointercapture", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ongotpointercapture_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ongotpointercapture_setterinfo),
  JSPropertySpec::nativeAccessors("onlostpointercapture", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onlostpointercapture_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onlostpointercapture_setterinfo),
  JSPropertySpec::nativeAccessors("onmozfullscreenchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmozfullscreenchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmozfullscreenchange_setterinfo),
  JSPropertySpec::nativeAccessors("onmozfullscreenerror", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmozfullscreenerror_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmozfullscreenerror_setterinfo),
  JSPropertySpec::nativeAccessors("onanimationcancel", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onanimationcancel_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onanimationcancel_setterinfo),
  JSPropertySpec::nativeAccessors("onanimationend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onanimationend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onanimationend_setterinfo),
  JSPropertySpec::nativeAccessors("onanimationiteration", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onanimationiteration_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onanimationiteration_setterinfo),
  JSPropertySpec::nativeAccessors("onanimationstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onanimationstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onanimationstart_setterinfo),
  JSPropertySpec::nativeAccessors("ontransitioncancel", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontransitioncancel_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontransitioncancel_setterinfo),
  JSPropertySpec::nativeAccessors("ontransitionend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontransitionend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontransitionend_setterinfo),
  JSPropertySpec::nativeAccessors("ontransitionrun", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontransitionrun_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontransitionrun_setterinfo),
  JSPropertySpec::nativeAccessors("ontransitionstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontransitionstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontransitionstart_setterinfo),
  JSPropertySpec::nativeAccessors("onwebkitanimationend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onwebkitanimationend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onwebkitanimationend_setterinfo),
  JSPropertySpec::nativeAccessors("onwebkitanimationiteration", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onwebkitanimationiteration_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onwebkitanimationiteration_setterinfo),
  JSPropertySpec::nativeAccessors("onwebkitanimationstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onwebkitanimationstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onwebkitanimationstart_setterinfo),
  JSPropertySpec::nativeAccessors("onwebkittransitionend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onwebkittransitionend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onwebkittransitionend_setterinfo),
  JSPropertySpec::nativeAccessors("onerror", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onerror_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onerror_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("speechSynthesis", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &speechSynthesis_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("ontouchstart", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontouchstart_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontouchstart_setterinfo),
  JSPropertySpec::nativeAccessors("ontouchend", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontouchend_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontouchend_setterinfo),
  JSPropertySpec::nativeAccessors("ontouchmove", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontouchmove_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontouchmove_setterinfo),
  JSPropertySpec::nativeAccessors("ontouchcancel", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ontouchcancel_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ontouchcancel_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("onafterprint", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onafterprint_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onafterprint_setterinfo),
  JSPropertySpec::nativeAccessors("onbeforeprint", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onbeforeprint_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onbeforeprint_setterinfo),
  JSPropertySpec::nativeAccessors("onbeforeunload", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onbeforeunload_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onbeforeunload_setterinfo),
  JSPropertySpec::nativeAccessors("onhashchange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onhashchange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onhashchange_setterinfo),
  JSPropertySpec::nativeAccessors("onlanguagechange", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onlanguagechange_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onlanguagechange_setterinfo),
  JSPropertySpec::nativeAccessors("onmessage", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmessage_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmessage_setterinfo),
  JSPropertySpec::nativeAccessors("onmessageerror", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onmessageerror_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onmessageerror_setterinfo),
  JSPropertySpec::nativeAccessors("onoffline", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onoffline_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onoffline_setterinfo),
  JSPropertySpec::nativeAccessors("ononline", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ononline_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ononline_setterinfo),
  JSPropertySpec::nativeAccessors("onpagehide", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpagehide_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpagehide_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("onpagereveal", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpagereveal_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpagereveal_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("onpageshow", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpageshow_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpageshow_setterinfo),
  JSPropertySpec::nativeAccessors("onpopstate", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onpopstate_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onpopstate_setterinfo),
  JSPropertySpec::nativeAccessors("onrejectionhandled", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onrejectionhandled_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onrejectionhandled_setterinfo),
  JSPropertySpec::nativeAccessors("onstorage", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onstorage_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onstorage_setterinfo),
  JSPropertySpec::nativeAccessors("onunhandledrejection", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onunhandledrejection_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onunhandledrejection_setterinfo),
  JSPropertySpec::nativeAccessors("onunload", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &onunload_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &onunload_setterinfo),
  JSPropertySpec::nativeAccessors("ongamepadconnected", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ongamepadconnected_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ongamepadconnected_setterinfo),
  JSPropertySpec::nativeAccessors("ongamepaddisconnected", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &ongamepaddisconnected_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &ongamepaddisconnected_setterinfo),
  JSPropertySpec::nativeAccessors("localStorage", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &localStorage_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("origin", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &origin_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &origin_setterinfo),
  JSPropertySpec::nativeAccessors("crossOriginIsolated", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &crossOriginIsolated_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isSecureContext", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &isSecureContext_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("indexedDB", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &indexedDB_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("caches", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &caches_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("scheduler", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scheduler_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &scheduler_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("trustedTypes", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &trustedTypes_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("sessionStorage", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &sessionStorage_getterinfo, nullptr, nullptr),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers4 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &Navigation::IsAPIEnabled
};

static const PrefableDisablers sAttributes_disablers48 = {
  WebIDLPrefIndex::device_sensors_proximity_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers50 = {
  WebIDLPrefIndex::device_sensors_ambientLight_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers52 = {
  WebIDLPrefIndex::extensions_InstallTrigger_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers54 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &nsGlobalWindowInner::IsPrivilegedChromeWindow
};

static const PrefableDisablers sAttributes_disablers60 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &IsChromeOrUAWidget
};

static const PrefableDisablers sAttributes_disablers62 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &GleanWebidlEnabled
};

static const PrefableDisablers sAttributes_disablers65 = {
  WebIDLPrefIndex::dom_vr_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers71 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &IsChromeOrUAWidget
};

static const PrefableDisablers sAttributes_disablers75 = {
  WebIDLPrefIndex::dom_cookieStore_enabled, 0, true, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers77 = {
  WebIDLPrefIndex::dom_origin_agent_cluster_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers79 = {
  WebIDLPrefIndex::dom_documentpip_enabled, 0, true, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers99 = {
  WebIDLPrefIndex::dom_element_commandfor_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers110 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &Event::IsDragExitEnabled
};

static const PrefableDisablers sAttributes_disablers170 = {
  WebIDLPrefIndex::dom_event_pointer_rawupdate_enabled, 0, true, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers190 = {
  WebIDLPrefIndex::media_webspeech_synth_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers192 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &nsGenericHTMLElement::LegacyTouchAPIEnabled
};

static const PrefableDisablers sAttributes_disablers208 = {
  WebIDLPrefIndex::dom_viewTransitions_cross_document_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers224 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &cache::CacheStorage::CachesEnabled
};

static const PrefableDisablers sAttributes_disablers226 = {
  WebIDLPrefIndex::dom_enable_web_task_scheduling, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers228 = {
  WebIDLPrefIndex::dom_security_trusted_types_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { &sAttributes_disablers4, &sAttributes_specs[4] },
  { nullptr, &sAttributes_specs[6] },
  { &sAttributes_disablers48, &sAttributes_specs[48] },
  { &sAttributes_disablers50, &sAttributes_specs[50] },
  { &sAttributes_disablers52, &sAttributes_specs[52] },
  { &sAttributes_disablers54, &sAttributes_specs[54] },
  { &sAttributes_disablers60, &sAttributes_specs[60] },
  { &sAttributes_disablers62, &sAttributes_specs[62] },
  { &sAttributes_disablers65, &sAttributes_specs[65] },
  { &sAttributes_disablers71, &sAttributes_specs[71] },
  { nullptr, &sAttributes_specs[73] },
  { &sAttributes_disablers75, &sAttributes_specs[75] },
  { &sAttributes_disablers77, &sAttributes_specs[77] },
  { &sAttributes_disablers79, &sAttributes_specs[79] },
  { nullptr, &sAttributes_specs[81] },
  { &sAttributes_disablers99, &sAttributes_specs[99] },
  { nullptr, &sAttributes_specs[101] },
  { &sAttributes_disablers110, &sAttributes_specs[110] },
  { nullptr, &sAttributes_specs[112] },
  { &sAttributes_disablers170, &sAttributes_specs[170] },
  { nullptr, &sAttributes_specs[172] },
  { &sAttributes_disablers190, &sAttributes_specs[190] },
  { &sAttributes_disablers192, &sAttributes_specs[192] },
  { nullptr, &sAttributes_specs[197] },
  { &sAttributes_disablers208, &sAttributes_specs[208] },
  { nullptr, &sAttributes_specs[210] },
  { &sAttributes_disablers224, &sAttributes_specs[224] },
  { &sAttributes_disablers226, &sAttributes_specs[226] },
  { &sAttributes_disablers228, &sAttributes_specs[228] },
  { nullptr, &sAttributes_specs[230] },
  { nullptr, nullptr }
};

static_assert(31 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(57 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("controllers", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &controllers_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &controllers_setterinfo),
  JSPropertySpec::nativeAccessors("realFrameElement", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &realFrameElement_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("docShell", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &docShell_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("browsingContext", JSPROP_ENUMERATE, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &browsingContext_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("desktopToDeviceScale", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &desktopToDeviceScale_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("screenEdgeSlopX", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screenEdgeSlopX_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("screenEdgeSlopY", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &screenEdgeSlopY_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("scrollMinX", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollMinX_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("scrollMinY", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &scrollMinY_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("content", 0, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &content_getterinfo, GenericSetter<MaybeCrossOriginObjectThisPolicy>, &content_setterinfo),
  JSPropertySpec::nativeAccessors("windowRoot", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &windowRoot_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("windowUtils", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &windowUtils_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("windowGlobalChild", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &windowGlobalChild_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("clientPrincipal", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &clientPrincipal_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isInFullScreenTransition", JSPROP_ENUMERATE, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &isInFullScreenTransition_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { nullptr, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(15 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("window", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &window_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("document", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<MaybeCrossOriginObjectThisPolicy, ThrowExceptions>, &document_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("location", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &location_getterinfo, GenericSetter<CrossOriginThisPolicy>, &location_setterinfo),
  JSPropertySpec::nativeAccessors("top", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &top_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "STATE_MAXIMIZED", JS::Int32Value(1) },
  { "STATE_MINIMIZED", JS::Int32Value(2) },
  { "STATE_NORMAL", JS::Int32Value(3) },
  { "STATE_FULLSCREEN", JS::Int32Value(4) },
  { 0, JS::UndefinedValue() }
};

static const PrefableDisablers sConstants_disablers0 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &nsGlobalWindowInner::IsPrivilegedChromeWindow
};

static const Prefable<const ConstantSpec> sConstants[] = {
  { &sConstants_disablers0, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[267];
static PropertyInfo sNativeProperties_propertyInfos[267];

static const NativePropertiesN<4> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  true,  2 /* sUnforgeableAttributes */,
  true,  3 /* sConstants */,
  -1,
  267,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[58] },
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[259] },
    { sConstants, &sNativeProperties_propertyInfos[263] }
  }
};
static_assert(267 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[24];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[24];

static const NativePropertiesN<2> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sChromeMethods */,
  true,  1 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  24,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[0] },
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[9] }
  }
};
static_assert(24 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

MOZ_CAN_RUN_SCRIPT static bool
ResolveOwnPropertyViaResolve(JSContext* cx, JS::Handle<JSObject*> wrapper, JS::Handle<JSObject*> obj, JS::Handle<jsid> id, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc)
{
  nsGlobalWindowInner* self;
  JS::Rooted<JS::Value> rootSelf(cx, JS::ObjectValue(*obj));
  {
    // Our JSContext should be in the right global to do unwrapping in.
    nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(&rootSelf, self, cx);
    if (NS_FAILED(rv)) {
      MOZ_CRASH("Unexpected object in 'ResolveOwnPropertyViaResolve' hook");
      return false;
    }
  }
  {
    // Since we're dealing with an Xray, do the resolve on the
    // underlying object first.  That gives it a chance to
    // define properties on the actual object as needed, and
    // then use the fact that it created the objects as a flag
    // to avoid re-resolving the properties if someone deletes
    // them.
    JSAutoRealm ar(cx, obj);
    JS_MarkCrossZoneId(cx, id);
    JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> objDesc(cx);
    if (!self->DoResolve(cx, obj, id, &objDesc)) {
      return false;
    }
    // If desc->value() is undefined, then the DoResolve call
    // has already defined the property on the object.  Don't
    // try to also define it.
    if (objDesc.isSome() &&
        !objDesc->value().isUndefined()) {
      JS::Rooted<JS::PropertyDescriptor> defineDesc(cx, *objDesc);
      if (!JS_DefinePropertyById(cx, obj, id, defineDesc)) {
        return false;
      }
    }
  }
  return self->DoResolve(cx, wrapper, id, desc);
}

MOZ_CAN_RUN_SCRIPT static bool
EnumerateOwnPropertiesViaGetOwnPropertyNames(JSContext* cx, JS::Handle<JSObject*> wrapper, JS::Handle<JSObject*> obj, JS::MutableHandleVector<jsid> props)
{
  nsGlobalWindowInner* self;
  JS::Rooted<JS::Value> rootSelf(cx, JS::ObjectValue(*obj));
  {
    // Our JSContext should be in the right global to do unwrapping in.
    nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(&rootSelf, self, cx);
    if (NS_FAILED(rv)) {
      MOZ_CRASH("Unexpected object in 'EnumerateOwnPropertiesViaGetOwnPropertyNames' hook");
      return false;
    }
  }
  FastErrorResult rv;
  // This wants all own props, not just enumerable ones.
  self->GetOwnPropertyNames(cx, props, false, rv);
  if (rv.MaybeSetPendingException(cx)) {
    return false;
  }
  return true;
}

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 4,
                                   &xpc::XrayExpandoObjectClassOps);

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  ResolveOwnPropertyViaResolve,
  EnumerateOwnPropertiesViaGetOwnPropertyNames,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::Window,
  constructors::id::Window,
  &sXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  EventTarget_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::Window>::Depth,
  prototypes::id::Window,
  true,
  0,
  "Window",
};

static bool
_resolve(JSContext* cx, JS::Handle<JSObject*> obj, JS::Handle<jsid> id, bool* resolvedp)
{
  if (!ResolveGlobal(cx, obj, id, resolvedp)) {
    return false;
  }
  if (*resolvedp) {
    return true;
  }

  nsGlobalWindowInner* self = UnwrapPossiblyNotInitializedDOMObject<nsGlobalWindowInner>(obj);
  JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
  if (!self->DoResolve(cx, obj, id, &desc)) {
    return false;
  }
  if (desc.isNothing()) {
    return true;
  }
  // If desc.value() is undefined, then the DoResolve call
  // has already defined it on the object.  Don't try to also
  // define it.
  MOZ_ASSERT(desc->isDataDescriptor());
  if (!desc->value().isUndefined()) {
    JS::Rooted<JS::PropertyDescriptor> defineDesc(cx, *desc);
    defineDesc.setResolving(true);
    if (!JS_DefinePropertyById(cx, obj, id, defineDesc)) {
      return false;
    }
  }
  *resolvedp = true;
  return true;
}

static bool
_mayResolve(const JSAtomState& names, jsid id, JSObject* maybeObj)
{
  if (MayResolveGlobal(names, id, maybeObj)) {
    return true;
  }

  return nsGlobalWindowInner::MayResolve(id);
}

MOZ_CAN_RUN_SCRIPT static bool
_newEnumerate(JSContext* cx, JS::Handle<JSObject*> obj, JS::MutableHandleVector<jsid> properties, bool enumerableOnly)
{
  if (!EnumerateGlobal(cx, obj, properties, enumerableOnly)) {
    return false;
  }

  nsGlobalWindowInner* self;
  JS::Rooted<JS::Value> rootSelf(cx, JS::ObjectValue(*obj));
  {
    // Our JSContext should be in the right global to do unwrapping in.
    nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(&rootSelf, self, cx);
    if (NS_FAILED(rv)) {
      MOZ_CRASH("Unexpected object in '_newEnumerate' hook");
      return false;
    }
  }
  FastErrorResult rv;
  self->GetOwnPropertyNames(cx, properties, enumerableOnly, rv);
  if (rv.MaybeSetPendingException(cx)) {
    return false;
  }
  return true;
}

static JSObject*
GetNamedPropertiesObject(JSContext* aCx)
{
  /* Make sure our global is sane.  Hopefully we can remove this sometime */
  JSObject* global = JS::CurrentGlobalOrNull(aCx);
  if (!(JS::GetClass(global)->flags & JSCLASS_DOM_GLOBAL)) {
    return nullptr;
  }

  /* Check to see whether the named properties object has already been created */
  ProtoAndIfaceCache& protoAndIfaceCache = *GetProtoAndIfaceCache(global);

  JS::Heap<JSObject*>& namedPropertiesObject = protoAndIfaceCache.EntrySlotOrCreate(namedpropertiesobjects::id::Window);
  if (!namedPropertiesObject) {
    JS::Rooted<JSObject*> parentProto(aCx, EventTarget_Binding::GetProtoObjectHandle(aCx));
    if (!parentProto) {
      return nullptr;
    }
    namedPropertiesObject = nsGlobalWindowInner::CreateNamedPropertiesObject(aCx, parentProto);
    DebugOnly<const DOMIfaceAndProtoJSClass*> clasp =
      DOMIfaceAndProtoJSClass::FromJSClass(JS::GetClass(namedPropertiesObject));
    MOZ_ASSERT(clasp->mType == eNamedPropertiesObject,
               "Expected nsGlobalWindowInner::CreateNamedPropertiesObject to return a named properties object");
    MOZ_ASSERT(clasp->mNativeHooks,
               "The named properties object for nsGlobalWindowInner should have NativePropertyHooks.");
    MOZ_ASSERT(!clasp->mNativeHooks->mIndexedOrNamedNativeProperties ||
               !clasp->mNativeHooks->mIndexedOrNamedNativeProperties->mResolveOwnProperty,
               "Shouldn't resolve the properties of the named properties object for nsGlobalWindowInner for Xrays.");
    MOZ_ASSERT(!clasp->mNativeHooks->mIndexedOrNamedNativeProperties ||
               !clasp->mNativeHooks->mIndexedOrNamedNativeProperties->mEnumerateOwnProperties,
               "Shouldn't enumerate the properties of the named properties object for nsGlobalWindowInner for Xrays.");
  }
  return namedPropertiesObject.get();
}

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "WindowPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eGlobalInterfacePrototype,
  prototypes::id::Window,
  PrototypeTraits<prototypes::id::Window>::Depth,
  &sNativePropertyHooks,
  GetNamedPropertiesObject
};

bool
CountMaybeMissingProperty(JS::Handle<JSObject*> proxy, JS::Handle<jsid> id)
{
  MOZ_ASSERT(StaticPrefs::dom_missing_prop_counters_enabled() && id.isAtom());
  Maybe<UseCounter> counter;
  {
    // Scope for our no-GC section, so we don't need to rely on SetUseCounter not GCing.
    JS::AutoCheckCannotGC nogc;
    JSLinearString* str = JS::AtomToLinearString(id.toAtom());
    // Don't waste time fetching the chars until we've done the length switch.
    switch (JS::GetLinearStringLength(str)) {
      case 3: {
        if (JS_LinearStringEqualsLiteral(str, "USB")) {
          counter.emplace(eUseCounter_Window_USB);
        }
        break;
      }
      case 5: {
        if (JS_LinearStringEqualsLiteral(str, "Touch")) {
          counter.emplace(eUseCounter_Window_Touch);
        }
        break;
      }
      case 6: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "Report")) {
              counter.emplace(eUseCounter_Window_Report);
            }
            break;
          }
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "Sensor")) {
              counter.emplace(eUseCounter_Window_Sensor);
            }
            break;
          }
          case 'c': {
            if (JS_LinearStringEqualsLiteral(str, "chrome")) {
              counter.emplace(eUseCounter_Window_chrome);
            }
            break;
          }
        }
        break;
      }
      case 7: {
        if (JS_LinearStringEqualsLiteral(str, "CSSSkew")) {
          counter.emplace(eUseCounter_Window_CSSSkew);
        }
        break;
      }
      case 8: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            switch (chars[4]) {
              case 'c': {
                if (JS_LinearStringEqualsLiteral(str, "CSSScale")) {
                  counter.emplace(eUseCounter_Window_CSSScale);
                }
                break;
              }
              case 'k': {
                switch (chars[7]) {
                  case 'X': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSSkewX")) {
                      counter.emplace(eUseCounter_Window_CSSSkewX);
                    }
                    break;
                  }
                  case 'Y': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSSkewY")) {
                      counter.emplace(eUseCounter_Window_CSSSkewY);
                    }
                    break;
                  }
                }
                break;
              }
            }
            break;
          }
          case 'D': {
            if (JS_LinearStringEqualsLiteral(str, "DOMError")) {
              counter.emplace(eUseCounter_Window_DOMError);
            }
            break;
          }
          case 'E': {
            if (JS_LinearStringEqualsLiteral(str, "External")) {
              counter.emplace(eUseCounter_Window_External);
            }
            break;
          }
          case 'K': {
            if (JS_LinearStringEqualsLiteral(str, "Keyboard")) {
              counter.emplace(eUseCounter_Window_Keyboard);
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MIDIPort")) {
              counter.emplace(eUseCounter_Window_MIDIPort);
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "RTCError")) {
              counter.emplace(eUseCounter_Window_RTCError);
            }
            break;
          }
          case 'W': {
            if (JS_LinearStringEqualsLiteral(str, "WakeLock")) {
              counter.emplace(eUseCounter_Window_WakeLock);
            }
            break;
          }
          case 'o': {
            switch (chars[2]) {
              case 'c': {
                if (JS_LinearStringEqualsLiteral(str, "oncancel")) {
                  counter.emplace(eUseCounter_Window_oncancel);
                }
                break;
              }
              case 's': {
                if (JS_LinearStringEqualsLiteral(str, "onsearch")) {
                  counter.emplace(eUseCounter_Window_onsearch);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 9: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "Bluetooth")) {
              counter.emplace(eUseCounter_Window_Bluetooth);
            }
            break;
          }
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "CSSRotate")) {
              counter.emplace(eUseCounter_Window_CSSRotate);
            }
            break;
          }
          case 'G': {
            if (JS_LinearStringEqualsLiteral(str, "Gyroscope")) {
              counter.emplace(eUseCounter_Window_Gyroscope);
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MIDIInput")) {
              counter.emplace(eUseCounter_Window_MIDIInput);
            }
            break;
          }
          case 'T': {
            switch (chars[1]) {
              case 'e': {
                if (JS_LinearStringEqualsLiteral(str, "TextEvent")) {
                  counter.emplace(eUseCounter_Window_TextEvent);
                }
                break;
              }
              case 'o': {
                if (JS_LinearStringEqualsLiteral(str, "TouchList")) {
                  counter.emplace(eUseCounter_Window_TouchList);
                }
                break;
              }
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBDevice")) {
              counter.emplace(eUseCounter_Window_USBDevice);
            }
            break;
          }
        }
        break;
      }
      case 10: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            switch (chars[7]) {
              case 'M': {
                switch (chars[8]) {
                  case 'a': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSMathMax")) {
                      counter.emplace(eUseCounter_Window_CSSMathMax);
                    }
                    break;
                  }
                  case 'i': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSMathMin")) {
                      counter.emplace(eUseCounter_Window_CSSMathMin);
                    }
                    break;
                  }
                }
                break;
              }
              case 'S': {
                if (JS_LinearStringEqualsLiteral(str, "CSSMathSum")) {
                  counter.emplace(eUseCounter_Window_CSSMathSum);
                }
                break;
              }
            }
            break;
          }
          case 'M': {
            switch (chars[4]) {
              case 'A': {
                if (JS_LinearStringEqualsLiteral(str, "MIDIAccess")) {
                  counter.emplace(eUseCounter_Window_MIDIAccess);
                }
                break;
              }
              case 'O': {
                if (JS_LinearStringEqualsLiteral(str, "MIDIOutput")) {
                  counter.emplace(eUseCounter_Window_MIDIOutput);
                }
                break;
              }
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "ReportBody")) {
              counter.emplace(eUseCounter_Window_ReportBody);
            }
            break;
          }
          case 'T': {
            if (JS_LinearStringEqualsLiteral(str, "TouchEvent")) {
              counter.emplace(eUseCounter_Window_TouchEvent);
            }
            break;
          }
          case 'V': {
            if (JS_LinearStringEqualsLiteral(str, "VideoFrame")) {
              counter.emplace(eUseCounter_Window_VideoFrame);
            }
            break;
          }
          case 's': {
            if (JS_LinearStringEqualsLiteral(str, "styleMedia")) {
              counter.emplace(eUseCounter_Window_styleMedia);
            }
            break;
          }
        }
        break;
      }
      case 11: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "SyncManager")) {
              counter.emplace(eUseCounter_Window_SyncManager);
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBEndpoint")) {
              counter.emplace(eUseCounter_Window_USBEndpoint);
            }
            break;
          }
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "orientation")) {
              counter.emplace(eUseCounter_Window_orientation);
            }
            break;
          }
        }
        break;
      }
      case 12: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            switch (chars[3]) {
              case 'M': {
                switch (chars[7]) {
                  case 'C': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSMathClamp")) {
                      counter.emplace(eUseCounter_Window_CSSMathClamp);
                    }
                    break;
                  }
                  case 'V': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSMathValue")) {
                      counter.emplace(eUseCounter_Window_CSSMathValue);
                    }
                    break;
                  }
                }
                break;
              }
              case 'T': {
                if (JS_LinearStringEqualsLiteral(str, "CSSTranslate")) {
                  counter.emplace(eUseCounter_Window_CSSTranslate);
                }
                break;
              }
              case 'U': {
                if (JS_LinearStringEqualsLiteral(str, "CSSUnitValue")) {
                  counter.emplace(eUseCounter_Window_CSSUnitValue);
                }
                break;
              }
            }
            break;
          }
          case 'I': {
            if (JS_LinearStringEqualsLiteral(str, "ImageCapture")) {
              counter.emplace(eUseCounter_Window_ImageCapture);
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MIDIInputMap")) {
              counter.emplace(eUseCounter_Window_MIDIInputMap);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "Presentation")) {
              counter.emplace(eUseCounter_Window_Presentation);
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBInterface")) {
              counter.emplace(eUseCounter_Window_USBInterface);
            }
            break;
          }
          case 'V': {
            switch (chars[5]) {
              case 'D': {
                if (JS_LinearStringEqualsLiteral(str, "VideoDecoder")) {
                  counter.emplace(eUseCounter_Window_VideoDecoder);
                }
                break;
              }
              case 'E': {
                if (JS_LinearStringEqualsLiteral(str, "VideoEncoder")) {
                  counter.emplace(eUseCounter_Window_VideoEncoder);
                }
                break;
              }
            }
            break;
          }
          case 'o': {
            switch (chars[1]) {
              case 'n': {
                if (JS_LinearStringEqualsLiteral(str, "onmousewheel")) {
                  counter.emplace(eUseCounter_Window_onmousewheel);
                }
                break;
              }
              case 'p': {
                if (JS_LinearStringEqualsLiteral(str, "openDatabase")) {
                  counter.emplace(eUseCounter_Window_openDatabase);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 13: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'A': {
            if (JS_LinearStringEqualsLiteral(str, "Accelerometer")) {
              counter.emplace(eUseCounter_Window_Accelerometer);
            }
            break;
          }
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothUUID")) {
              counter.emplace(eUseCounter_Window_BluetoothUUID);
            }
            break;
          }
          case 'C': {
            switch (chars[1]) {
              case 'S': {
                switch (chars[3]) {
                  case 'I': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSImageValue")) {
                      counter.emplace(eUseCounter_Window_CSSImageValue);
                    }
                    break;
                  }
                  case 'M': {
                    switch (chars[7]) {
                      case 'I': {
                        if (JS_LinearStringEqualsLiteral(str, "CSSMathInvert")) {
                          counter.emplace(eUseCounter_Window_CSSMathInvert);
                        }
                        break;
                      }
                      case 'N': {
                        if (JS_LinearStringEqualsLiteral(str, "CSSMathNegate")) {
                          counter.emplace(eUseCounter_Window_CSSMathNegate);
                        }
                        break;
                      }
                    }
                    break;
                  }
                  case 'S': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSStyleValue")) {
                      counter.emplace(eUseCounter_Window_CSSStyleValue);
                    }
                    break;
                  }
                }
                break;
              }
              case 'l': {
                if (JS_LinearStringEqualsLiteral(str, "ClipboardItem")) {
                  counter.emplace(eUseCounter_Window_ClipboardItem);
                }
                break;
              }
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MIDIOutputMap")) {
              counter.emplace(eUseCounter_Window_MIDIOutputMap);
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "RTCErrorEvent")) {
              counter.emplace(eUseCounter_Window_RTCErrorEvent);
            }
            break;
          }
          case 'd': {
            if (JS_LinearStringEqualsLiteral(str, "defaultStatus")) {
              counter.emplace(eUseCounter_Window_defaultStatus);
            }
            break;
          }
        }
        break;
      }
      case 14: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            switch (chars[3]) {
              case 'M': {
                if (JS_LinearStringEqualsLiteral(str, "CSSMathProduct")) {
                  counter.emplace(eUseCounter_Window_CSSMathProduct);
                }
                break;
              }
              case 'P': {
                if (JS_LinearStringEqualsLiteral(str, "CSSPerspective")) {
                  counter.emplace(eUseCounter_Window_CSSPerspective);
                }
                break;
              }
            }
            break;
          }
          case 'P': {
            switch (chars[7]) {
              case 'A': {
                if (JS_LinearStringEqualsLiteral(str, "PaymentAddress")) {
                  counter.emplace(eUseCounter_Window_PaymentAddress);
                }
                break;
              }
              case 'M': {
                if (JS_LinearStringEqualsLiteral(str, "PaymentManager")) {
                  counter.emplace(eUseCounter_Window_PaymentManager);
                }
                break;
              }
              case 'R': {
                if (JS_LinearStringEqualsLiteral(str, "PaymentRequest")) {
                  counter.emplace(eUseCounter_Window_PaymentRequest);
                }
                break;
              }
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "RemotePlayback")) {
              counter.emplace(eUseCounter_Window_RemotePlayback);
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "UserActivation")) {
              counter.emplace(eUseCounter_Window_UserActivation);
            }
            break;
          }
        }
        break;
      }
      case 15: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothDevice")) {
              counter.emplace(eUseCounter_Window_BluetoothDevice);
            }
            break;
          }
          case 'C': {
            switch (chars[3]) {
              case 'K': {
                if (JS_LinearStringEqualsLiteral(str, "CSSKeywordValue")) {
                  counter.emplace(eUseCounter_Window_CSSKeywordValue);
                }
                break;
              }
              case 'N': {
                switch (chars[10]) {
                  case 'A': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSNumericArray")) {
                      counter.emplace(eUseCounter_Window_CSSNumericArray);
                    }
                    break;
                  }
                  case 'V': {
                    if (JS_LinearStringEqualsLiteral(str, "CSSNumericValue")) {
                      counter.emplace(eUseCounter_Window_CSSNumericValue);
                    }
                    break;
                  }
                }
                break;
              }
              case 'P': {
                if (JS_LinearStringEqualsLiteral(str, "CSSPropertyRule")) {
                  counter.emplace(eUseCounter_Window_CSSPropertyRule);
                }
                break;
              }
            }
            break;
          }
          case 'I': {
            if (JS_LinearStringEqualsLiteral(str, "InputDeviceInfo")) {
              counter.emplace(eUseCounter_Window_InputDeviceInfo);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "PaymentResponse")) {
              counter.emplace(eUseCounter_Window_PaymentResponse);
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "RTCIceTransport")) {
              counter.emplace(eUseCounter_Window_RTCIceTransport);
            }
            break;
          }
          case 'V': {
            if (JS_LinearStringEqualsLiteral(str, "VideoColorSpace")) {
              counter.emplace(eUseCounter_Window_VideoColorSpace);
            }
            break;
          }
        }
        break;
      }
      case 16: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            switch (chars[3]) {
              case 'P': {
                if (JS_LinearStringEqualsLiteral(str, "CSSPositionValue")) {
                  counter.emplace(eUseCounter_Window_CSSPositionValue);
                }
                break;
              }
              case 'U': {
                if (JS_LinearStringEqualsLiteral(str, "CSSUnparsedValue")) {
                  counter.emplace(eUseCounter_Window_CSSUnparsedValue);
                }
                break;
              }
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MIDIMessageEvent")) {
              counter.emplace(eUseCounter_Window_MIDIMessageEvent);
            }
            break;
          }
          case 'S': {
            switch (chars[1]) {
              case 'e': {
                if (JS_LinearStringEqualsLiteral(str, "SensorErrorEvent")) {
                  counter.emplace(eUseCounter_Window_SensorErrorEvent);
                }
                break;
              }
              case 't': {
                if (JS_LinearStringEqualsLiteral(str, "StylePropertyMap")) {
                  counter.emplace(eUseCounter_Window_StylePropertyMap);
                }
                break;
              }
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBConfiguration")) {
              counter.emplace(eUseCounter_Window_USBConfiguration);
            }
            break;
          }
          case 'W': {
            if (JS_LinearStringEqualsLiteral(str, "WakeLockSentinel")) {
              counter.emplace(eUseCounter_Window_WakeLockSentinel);
            }
            break;
          }
        }
        break;
      }
      case 17: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "CSSTransformValue")) {
              counter.emplace(eUseCounter_Window_CSSTransformValue);
            }
            break;
          }
          case 'E': {
            if (JS_LinearStringEqualsLiteral(str, "EncodedVideoChunk")) {
              counter.emplace(eUseCounter_Window_EncodedVideoChunk);
            }
            break;
          }
          case 'H': {
            if (JS_LinearStringEqualsLiteral(str, "HTMLShadowElement")) {
              counter.emplace(eUseCounter_Window_HTMLShadowElement);
            }
            break;
          }
          case 'K': {
            if (JS_LinearStringEqualsLiteral(str, "KeyboardLayoutMap")) {
              counter.emplace(eUseCounter_Window_KeyboardLayoutMap);
            }
            break;
          }
          case 'O': {
            if (JS_LinearStringEqualsLiteral(str, "OrientationSensor")) {
              counter.emplace(eUseCounter_Window_OrientationSensor);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "PhotoCapabilities")) {
              counter.emplace(eUseCounter_Window_PhotoCapabilities);
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "ReportingObserver")) {
              counter.emplace(eUseCounter_Window_ReportingObserver);
            }
            break;
          }
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "SVGDiscardElement")) {
              counter.emplace(eUseCounter_Window_SVGDiscardElement);
            }
            break;
          }
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "onselectionchange")) {
              counter.emplace(eUseCounter_Window_onselectionchange);
            }
            break;
          }
          case 'w': {
            switch (chars[6]) {
              case 'M': {
                if (JS_LinearStringEqualsLiteral(str, "webkitMediaStream")) {
                  counter.emplace(eUseCounter_Window_webkitMediaStream);
                }
                break;
              }
              case 'S': {
                if (JS_LinearStringEqualsLiteral(str, "webkitStorageInfo")) {
                  counter.emplace(eUseCounter_Window_webkitStorageInfo);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 18: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "CSSMatrixComponent")) {
              counter.emplace(eUseCounter_Window_CSSMatrixComponent);
            }
            break;
          }
          case 'H': {
            if (JS_LinearStringEqualsLiteral(str, "HTMLContentElement")) {
              counter.emplace(eUseCounter_Window_HTMLContentElement);
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MediaSettingsRange")) {
              counter.emplace(eUseCounter_Window_MediaSettingsRange);
            }
            break;
          }
          case 'N': {
            if (JS_LinearStringEqualsLiteral(str, "NetworkInformation")) {
              counter.emplace(eUseCounter_Window_NetworkInformation);
            }
            break;
          }
          case 'P': {
            switch (chars[2]) {
              case 's': {
                if (JS_LinearStringEqualsLiteral(str, "PasswordCredential")) {
                  counter.emplace(eUseCounter_Window_PasswordCredential);
                }
                break;
              }
              case 'y': {
                if (JS_LinearStringEqualsLiteral(str, "PaymentInstruments")) {
                  counter.emplace(eUseCounter_Window_PaymentInstruments);
                }
                break;
              }
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBConnectionEvent")) {
              counter.emplace(eUseCounter_Window_USBConnectionEvent);
            }
            break;
          }
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "offscreenBuffering")) {
              counter.emplace(eUseCounter_Window_offscreenBuffering);
            }
            break;
          }
        }
        break;
      }
      case 19: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'F': {
            if (JS_LinearStringEqualsLiteral(str, "FederatedCredential")) {
              counter.emplace(eUseCounter_Window_FederatedCredential);
            }
            break;
          }
          case 'M': {
            if (JS_LinearStringEqualsLiteral(str, "MIDIConnectionEvent")) {
              counter.emplace(eUseCounter_Window_MIDIConnectionEvent);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "PresentationRequest")) {
              counter.emplace(eUseCounter_Window_PresentationRequest);
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBInTransferResult")) {
              counter.emplace(eUseCounter_Window_USBInTransferResult);
            }
            break;
          }
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "onorientationchange")) {
              counter.emplace(eUseCounter_Window_onorientationchange);
            }
            break;
          }
          case 'w': {
            if (JS_LinearStringEqualsLiteral(str, "webkitSpeechGrammar")) {
              counter.emplace(eUseCounter_Window_webkitSpeechGrammar);
            }
            break;
          }
        }
        break;
      }
      case 20: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'O': {
            if (JS_LinearStringEqualsLiteral(str, "OverconstrainedError")) {
              counter.emplace(eUseCounter_Window_OverconstrainedError);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "PresentationReceiver")) {
              counter.emplace(eUseCounter_Window_PresentationReceiver);
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBOutTransferResult")) {
              counter.emplace(eUseCounter_Window_USBOutTransferResult);
            }
            break;
          }
        }
        break;
      }
      case 21: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BackgroundFetchRecord")) {
              counter.emplace(eUseCounter_Window_BackgroundFetchRecord);
            }
            break;
          }
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "CSSTransformComponent")) {
              counter.emplace(eUseCounter_Window_CSSTransformComponent);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "PictureInPictureEvent")) {
              counter.emplace(eUseCounter_Window_PictureInPictureEvent);
            }
            break;
          }
          case 'T': {
            if (JS_LinearStringEqualsLiteral(str, "TaskAttributionTiming")) {
              counter.emplace(eUseCounter_Window_TaskAttributionTiming);
            }
            break;
          }
          case 'U': {
            if (JS_LinearStringEqualsLiteral(str, "USBAlternateInterface")) {
              counter.emplace(eUseCounter_Window_USBAlternateInterface);
            }
            break;
          }
          case 'o': {
            if (JS_LinearStringEqualsLiteral(str, "onbeforeinstallprompt")) {
              counter.emplace(eUseCounter_Window_onbeforeinstallprompt);
            }
            break;
          }
        }
        break;
      }
      case 22: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BackgroundFetchManager")) {
              counter.emplace(eUseCounter_Window_BackgroundFetchManager);
            }
            break;
          }
          case 'P': {
            switch (chars[1]) {
              case 'i': {
                if (JS_LinearStringEqualsLiteral(str, "PictureInPictureWindow")) {
                  counter.emplace(eUseCounter_Window_PictureInPictureWindow);
                }
                break;
              }
              case 'r': {
                if (JS_LinearStringEqualsLiteral(str, "PresentationConnection")) {
                  counter.emplace(eUseCounter_Window_PresentationConnection);
                }
                break;
              }
            }
            break;
          }
          case 'W': {
            if (JS_LinearStringEqualsLiteral(str, "WebKitMutationObserver")) {
              counter.emplace(eUseCounter_Window_WebKitMutationObserver);
            }
            break;
          }
        }
        break;
      }
      case 23: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'I': {
            if (JS_LinearStringEqualsLiteral(str, "InputDeviceCapabilities")) {
              counter.emplace(eUseCounter_Window_InputDeviceCapabilities);
            }
            break;
          }
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "SpeechRecognitionResult")) {
              counter.emplace(eUseCounter_Window_SpeechRecognitionResult);
            }
            break;
          }
          case 'w': {
            switch (chars[6]) {
              case 'R': {
                switch (chars[7]) {
                  case 'T': {
                    if (JS_LinearStringEqualsLiteral(str, "webkitRTCPeerConnection")) {
                      counter.emplace(eUseCounter_Window_webkitRTCPeerConnection);
                    }
                    break;
                  }
                  case 'e': {
                    if (JS_LinearStringEqualsLiteral(str, "webkitRequestFileSystem")) {
                      counter.emplace(eUseCounter_Window_webkitRequestFileSystem);
                    }
                    break;
                  }
                }
                break;
              }
              case 'S': {
                switch (chars[12]) {
                  case 'G': {
                    if (JS_LinearStringEqualsLiteral(str, "webkitSpeechGrammarList")) {
                      counter.emplace(eUseCounter_Window_webkitSpeechGrammarList);
                    }
                    break;
                  }
                  case 'R': {
                    if (JS_LinearStringEqualsLiteral(str, "webkitSpeechRecognition")) {
                      counter.emplace(eUseCounter_Window_webkitSpeechRecognition);
                    }
                    break;
                  }
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 24: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BeforeInstallPromptEvent")) {
              counter.emplace(eUseCounter_Window_BeforeInstallPromptEvent);
            }
            break;
          }
          case 'L': {
            if (JS_LinearStringEqualsLiteral(str, "LinearAccelerationSensor")) {
              counter.emplace(eUseCounter_Window_LinearAccelerationSensor);
            }
            break;
          }
          case 'P': {
            switch (chars[1]) {
              case 'a': {
                if (JS_LinearStringEqualsLiteral(str, "PaymentMethodChangeEvent")) {
                  counter.emplace(eUseCounter_Window_PaymentMethodChangeEvent);
                }
                break;
              }
              case 'r': {
                if (JS_LinearStringEqualsLiteral(str, "PresentationAvailability")) {
                  counter.emplace(eUseCounter_Window_PresentationAvailability);
                }
                break;
              }
            }
            break;
          }
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "StylePropertyMapReadOnly")) {
              counter.emplace(eUseCounter_Window_StylePropertyMapReadOnly);
            }
            break;
          }
        }
        break;
      }
      case 25: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'A': {
            if (JS_LinearStringEqualsLiteral(str, "AbsoluteOrientationSensor")) {
              counter.emplace(eUseCounter_Window_AbsoluteOrientationSensor);
            }
            break;
          }
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothRemoteGATTServer")) {
              counter.emplace(eUseCounter_Window_BluetoothRemoteGATTServer);
            }
            break;
          }
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "CSSVariableReferenceValue")) {
              counter.emplace(eUseCounter_Window_CSSVariableReferenceValue);
            }
            break;
          }
          case 'P': {
            switch (chars[1]) {
              case 'a': {
                if (JS_LinearStringEqualsLiteral(str, "PaymentRequestUpdateEvent")) {
                  counter.emplace(eUseCounter_Window_PaymentRequestUpdateEvent);
                }
                break;
              }
              case 'e': {
                if (JS_LinearStringEqualsLiteral(str, "PerformanceLongTaskTiming")) {
                  counter.emplace(eUseCounter_Window_PerformanceLongTaskTiming);
                }
                break;
              }
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "RelativeOrientationSensor")) {
              counter.emplace(eUseCounter_Window_RelativeOrientationSensor);
            }
            break;
          }
        }
        break;
      }
      case 26: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothRemoteGATTService")) {
              counter.emplace(eUseCounter_Window_BluetoothRemoteGATTService);
            }
            break;
          }
          case 'E': {
            if (JS_LinearStringEqualsLiteral(str, "EnterPictureInPictureEvent")) {
              counter.emplace(eUseCounter_Window_EnterPictureInPictureEvent);
            }
            break;
          }
          case 'P': {
            if (JS_LinearStringEqualsLiteral(str, "PresentationConnectionList")) {
              counter.emplace(eUseCounter_Window_PresentationConnectionList);
            }
            break;
          }
          case 'w': {
            if (JS_LinearStringEqualsLiteral(str, "webkitCancelAnimationFrame")) {
              counter.emplace(eUseCounter_Window_webkitCancelAnimationFrame);
            }
            break;
          }
        }
        break;
      }
      case 27: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BackgroundFetchRegistration")) {
              counter.emplace(eUseCounter_Window_BackgroundFetchRegistration);
            }
            break;
          }
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "SpeechRecognitionResultList")) {
              counter.emplace(eUseCounter_Window_SpeechRecognitionResultList);
            }
            break;
          }
          case 'w': {
            if (JS_LinearStringEqualsLiteral(str, "webkitRequestAnimationFrame")) {
              counter.emplace(eUseCounter_Window_webkitRequestAnimationFrame);
            }
            break;
          }
        }
        break;
      }
      case 28: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'S': {
            if (JS_LinearStringEqualsLiteral(str, "SpeechRecognitionAlternative")) {
              counter.emplace(eUseCounter_Window_SpeechRecognitionAlternative);
            }
            break;
          }
          case 'w': {
            switch (chars[24]) {
              case 'r': {
                if (JS_LinearStringEqualsLiteral(str, "webkitSpeechRecognitionError")) {
                  counter.emplace(eUseCounter_Window_webkitSpeechRecognitionError);
                }
                break;
              }
              case 'v': {
                if (JS_LinearStringEqualsLiteral(str, "webkitSpeechRecognitionEvent")) {
                  counter.emplace(eUseCounter_Window_webkitSpeechRecognitionEvent);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 29: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'B': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothRemoteGATTDescriptor")) {
              counter.emplace(eUseCounter_Window_BluetoothRemoteGATTDescriptor);
            }
            break;
          }
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "CanvasCaptureMediaStreamTrack")) {
              counter.emplace(eUseCounter_Window_CanvasCaptureMediaStreamTrack);
            }
            break;
          }
          case 'D': {
            switch (chars[17]) {
              case 'A': {
                if (JS_LinearStringEqualsLiteral(str, "DeviceMotionEventAcceleration")) {
                  counter.emplace(eUseCounter_Window_DeviceMotionEventAcceleration);
                }
                break;
              }
              case 'R': {
                if (JS_LinearStringEqualsLiteral(str, "DeviceMotionEventRotationRate")) {
                  counter.emplace(eUseCounter_Window_DeviceMotionEventRotationRate);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 30: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "RTCPeerConnectionIceErrorEvent")) {
              counter.emplace(eUseCounter_Window_RTCPeerConnectionIceErrorEvent);
            }
            break;
          }
          case 'U': {
            switch (chars[24]) {
              case 'P': {
                if (JS_LinearStringEqualsLiteral(str, "USBIsochronousInTransferPacket")) {
                  counter.emplace(eUseCounter_Window_USBIsochronousInTransferPacket);
                }
                break;
              }
              case 'R': {
                if (JS_LinearStringEqualsLiteral(str, "USBIsochronousInTransferResult")) {
                  counter.emplace(eUseCounter_Window_USBIsochronousInTransferResult);
                }
                break;
              }
            }
            break;
          }
        }
        break;
      }
      case 31: {
        StringIdChars chars(nogc, str);
        switch (chars[0]) {
          case 'U': {
            switch (chars[25]) {
              case 'P': {
                if (JS_LinearStringEqualsLiteral(str, "USBIsochronousOutTransferPacket")) {
                  counter.emplace(eUseCounter_Window_USBIsochronousOutTransferPacket);
                }
                break;
              }
              case 'R': {
                if (JS_LinearStringEqualsLiteral(str, "USBIsochronousOutTransferResult")) {
                  counter.emplace(eUseCounter_Window_USBIsochronousOutTransferResult);
                }
                break;
              }
            }
            break;
          }
          case 'w': {
            if (JS_LinearStringEqualsLiteral(str, "webkitResolveLocalFileSystemURL")) {
              counter.emplace(eUseCounter_Window_webkitResolveLocalFileSystemURL);
            }
            break;
          }
        }
        break;
      }
      case 32: {
        if (JS_LinearStringEqualsLiteral(str, "PresentationConnectionCloseEvent")) {
          counter.emplace(eUseCounter_Window_PresentationConnectionCloseEvent);
        }
        break;
      }
      case 33: {
        StringIdChars chars(nogc, str);
        switch (chars[9]) {
          case 'C': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothCharacteristicProperties")) {
              counter.emplace(eUseCounter_Window_BluetoothCharacteristicProperties);
            }
            break;
          }
          case 'R': {
            if (JS_LinearStringEqualsLiteral(str, "BluetoothRemoteGATTCharacteristic")) {
              counter.emplace(eUseCounter_Window_BluetoothRemoteGATTCharacteristic);
            }
            break;
          }
        }
        break;
      }
      case 36: {
        if (JS_LinearStringEqualsLiteral(str, "PresentationConnectionAvailableEvent")) {
          counter.emplace(eUseCounter_Window_PresentationConnectionAvailableEvent);
        }
        break;
      }
    }
  }
  if (counter) {
    SetUseCounter(proxy, *counter);
    return true;
  }

  return false;
}

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  _newEnumerate, /* newEnumerate */
  _resolve, /* resolve */
  _mayResolve, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  JS_GlobalObjectTraceHook, /* trace */
};

static const DOMJSClass sClass = {
  { "Window",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_DOM_GLOBAL | JSCLASS_GLOBAL_FLAGS_WITH_SLOTS(DOM_GLOBAL_SLOTS),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<nsGlobalWindowInner>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::Window, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, nsGlobalWindowInner>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<nsGlobalWindowInner>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<nsGlobalWindowInner>::Get(),
  nullptr,
  nullptr
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(JSCLASS_GLOBAL_APPLICATION_SLOTS >= 5,
              "Must have enough reserved slots.");

static bool
UpdateMemberSlots(JSContext* aCx, JS::Handle<JSObject*> aWrapper, nsGlobalWindowInner* aObject)
{
  JS::Rooted<JS::Value> temp(aCx);
  JSJitGetterCallArgs args(&temp);

  static_assert((DOM_INSTANCE_RESERVED_SLOTS + 2) < JS::shadow::Object::MAX_FIXED_SLOTS,
                "Not enough fixed slots to fit 'Window.document.  Ion's visitGetDOMMemberV/visitGetDOMMemberT assume StoreInSlot things are all in fixed slots.");
  if (!get_document(aCx, aWrapper, aObject, args)) {
    return false;
  }
  // Getter handled setting our reserved slots

  static_assert((DOM_INSTANCE_RESERVED_SLOTS + 3) < JS::shadow::Object::MAX_FIXED_SLOTS,
                "Not enough fixed slots to fit 'Window.performance.  Ion's visitGetDOMMemberV/visitGetDOMMemberT assume StoreInSlot things are all in fixed slots.");
  if (!get_performance(aCx, aWrapper, aObject, args)) {
    return false;
  }
  // Getter handled setting our reserved slots

  return true;
}

bool
Wrap(JSContext* aCx, nsGlobalWindowInner* aObject, nsWrapperCache* aCache, JS::RealmOptions& aOptions, JSPrincipals* aPrincipal, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(std::is_same_v<decltype(aObject), nsGlobalWindowInner*>);
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  if (!CreateGlobal<nsGlobalWindowInner, GetProtoObjectHandle>(aCx,
                                   aObject,
                                   aCache,
                                   sClass.ToJSClass(),
                                   aOptions,
                                   aPrincipal,
                                   aReflector)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }

  // aReflector is a new global, so has a new realm.  Enter it
  // before doing anything with it.
  JSAutoRealm ar(aCx, aReflector);

  if (!DefineProperties(aCx, aReflector, sNativeProperties.Upcast(), nsContentUtils::ThreadsafeIsSystemCaller(aCx) ? sChromeOnlyNativeProperties.Upcast() : nullptr)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, aReflector, sUnforgeableAttributes)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }

  if (!UpdateMemberSlots(aCx, aReflector, aObject)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }

  return true;
}

bool
ClearCachedDocumentValue(JSContext* aCx, nsGlobalWindowInner* aObject)
{
  JS::Rooted<JSObject*> obj(aCx);
  obj = aObject->GetWrapper();
  if (!obj) {
    return true;
  }
  JS::Rooted<JS::Value> oldValue(aCx, JS::GetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 2)));
  JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 2), JS::UndefinedValue());
  ClearXrayExpandoSlots(JS::RootingContext::get(aCx), obj, (DOM_EXPANDO_RESERVED_SLOTS + 2));
  JS::Rooted<JS::Value> temp(aCx);
  JSJitGetterCallArgs args(&temp);
  JSAutoRealm ar(aCx, obj);
  if (!get_document(aCx, obj, aObject, args)) {
    JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 2), oldValue);
    return false;
  }
  return true;
}

bool
ClearCachedPerformanceValue(JSContext* aCx, nsGlobalWindowInner* aObject)
{
  JS::Rooted<JSObject*> obj(aCx);
  obj = aObject->GetWrapper();
  if (!obj) {
    return true;
  }
  JS::Rooted<JS::Value> oldValue(aCx, JS::GetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 3)));
  JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 3), JS::UndefinedValue());
  ClearXrayExpandoSlots(JS::RootingContext::get(aCx), obj, (DOM_EXPANDO_RESERVED_SLOTS + 3));
  JS::Rooted<JS::Value> temp(aCx);
  JSJitGetterCallArgs args(&temp);
  JSAutoRealm ar(aCx, obj);
  if (!get_performance(aCx, obj, aObject, args)) {
    JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 3), oldValue);
    return false;
  }
  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::Window);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::Window);

  JS::Rooted<JSObject*> parentProto(aCx, GetNamedPropertiesObject(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(EventTarget_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "Window",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              true,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  {
    bool succeeded;
    if (!JS_SetImmutablePrototype(aCx, proto, &succeeded)) {
      *protoCache = nullptr;
      if (interfaceCache) {
        *interfaceCache = nullptr;
      }
      return;
    }

    MOZ_ASSERT(succeeded,
               "making a fresh prototype object's [[Prototype]] "
               "immutable can internally fail, but it should "
               "never be unsuccessful");
  }
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::Window,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::Window,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

static const JSPropertySpec sCrossOriginAttributes[] = {
    JSPropertySpec::nativeAccessors("window", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &window_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("self", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &self_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("location", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &location_getterinfo, GenericSetter<CrossOriginThisPolicy>, &location_setterinfo),
    JSPropertySpec::nativeAccessors("closed", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &closed_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("frames", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &frames_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("length", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &length_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("top", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &top_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("opener", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &opener_getterinfo, nullptr, nullptr),
    JSPropertySpec::nativeAccessors("parent", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &parent_getterinfo, nullptr, nullptr),
    JS_PS_END
};
static const JSFunctionSpec sCrossOriginMethods[] = {
    JS_FNSPEC("close", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&close_methodinfo), 0, JSPROP_READONLY, nullptr),
    JS_FNSPEC("focus", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&focus_methodinfo), 0, JSPROP_READONLY, nullptr),
    JS_FNSPEC("blur", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blur_methodinfo), 0, JSPROP_READONLY, nullptr),
    JS_FNSPEC("postMessage", (GenericMethod<CrossOriginThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&postMessage_methodinfo), 1, JSPROP_READONLY, nullptr),
    JS_FS_END
};
static const JSPropertySpec sChromeOnlyCrossOriginAttributes[] = {
    JSPropertySpec::nativeAccessors("browsingContext", 0, GenericGetter<CrossOriginThisPolicy, ThrowExceptions>, &browsingContext_getterinfo, nullptr, nullptr),
    JS_PS_END
};
const CrossOriginProperties sCrossOriginProperties = {
  sCrossOriginAttributes,
  sCrossOriginMethods,
  sChromeOnlyCrossOriginAttributes,
  nullptr
};

} // namespace Window_Binding



} // namespace dom


} // namespace mozilla
