// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGleanMetrics_h
#define mozilla_GleanGleanMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace fog {
  /**
   * generated from fog.failed_idle_registration
   * True if we failed to register with the idle service. Absent otherwise.
   * Means IPC probably isn't working well.
   * Child-process data will likely be absent, or incomplete.
   */
  constexpr impl::BooleanMetric failed_idle_registration(4903);

  /**
   * generated from fog.initializations
   * Time the FOG initializations take.
   */
  constexpr impl::TimingDistributionMetric initializations(4904);

  /**
   * generated from fog.inits_during_shutdown
   * Counts the number of times init had to be called during shutdown.
   * Should never have a value for any session long enough to grow idle.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> inits_during_shutdown(4905);

  /**
   * generated from fog.max_pings_per_minute
   * Value of the configurable rate limit, in pings per minute, for Glean pings as set at init.
   */
  constexpr impl::QuantityMetric max_pings_per_minute(4906);

  /**
   * generated from fog.subdir_entry_err
   */
  enum class SubdirEntryErrLabel: uint16_t {
    eDb = 0,
    eEvents = 1,
    ePendingPings = 2,
    e__Other__,
  };
  /**
   * How many dir entries per data subdirectory errored while reporting fog.data_diretory_info.
   * (Potentially because they were removed between `read_dir` and the iteration).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SubdirEntryErrLabel> subdir_entry_err(4907);

  /**
   * generated from fog.subdir_entry_metadata_err
   */
  enum class SubdirEntryMetadataErrLabel: uint16_t {
    eDb = 0,
    eEvents = 1,
    ePendingPings = 2,
    e__Other__,
  };
  /**
   * How many dir entries per data subdirectory errored while retrieving their metadata
   * while reporting fog.data_diretory_info.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SubdirEntryMetadataErrLabel> subdir_entry_metadata_err(4908);

  /**
   * generated from fog.subdir_err
   */
  enum class SubdirErrLabel: uint16_t {
    eDb = 0,
    eEvents = 1,
    ePendingPings = 2,
    e__Other__,
  };
  /**
   * Which data subdirectories suffered an err between is_dir and read_dir
   * while reporting fog.data_diretory_info.
   * (Potentially because they were removed in the interim).
   */
  constexpr impl::Labeled<impl::BooleanMetric, SubdirErrLabel> subdir_err(4909);
}

namespace fog_ipc {
  /**
   * generated from fog.ipc.buffer_sizes
   * The number and size of the IPC buffers being received over FOG IPC.
   */
  constexpr impl::MemoryDistributionMetric buffer_sizes(4910);

  /**
   * generated from fog.ipc.flush_durations
   * The length of time between asking the child processes for their
   * IPC buffers and all of them being received by the parent.
   */
  constexpr impl::TimingDistributionMetric flush_durations(4911);

  /**
   * generated from fog.ipc.flush_failures
   * The number of times we failed to flush all non-parent-process data,
   * throwing even partial results into the trash.
   * If this number is high, we might consider writing custom `MozPromise`-
   * handling code instead of using `MozPromise::All`.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> flush_failures(4912);

  /**
   * generated from fog.ipc.replay_failures
   * The number of times the ipc buffer failed to be replayed in the
   * parent process.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> replay_failures(4913);

  /**
   * generated from fog.ipc.shutdown_registration_failures
   * The number of times we tried to register shutdown flush routines for
   * content child processes, and failed (probably because there was no main
   * thread).
   * As a result there may be data loss from content child processes.
   * Large or rising number of clients experiencing this indicates we should
   * perhaps refactor content child shutdown in FOG to try harder to register
   * flush operations.
   * Will likely be obsoleted by bug 1641989.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> shutdown_registration_failures(4914);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGleanMetrics_h
