// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanExtensionsMetrics_h
#define mozilla_GleanExtensionsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace extensions_button {
  /**
   * generated from extensions_button.open_via_app_menu
   */
  struct OpenViaAppMenuExtra {
    mozilla::Maybe<bool> isExtensionsButtonVisible;
    mozilla::Maybe<bool> isExtensionsPanelEmpty;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isExtensionsButtonVisible) {
        extraKeys.AppendElement()->AssignASCII("is_extensions_button_visible");
        extraValues.AppendElement()->AssignASCII(isExtensionsButtonVisible.value() ? "true" : "false");
      }
      if (isExtensionsPanelEmpty) {
        extraKeys.AppendElement()->AssignASCII("is_extensions_panel_empty");
        extraValues.AppendElement()->AssignASCII(isExtensionsPanelEmpty.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When the user prefers the Extensions Button to be hidden, the default
   * "Extensions and Themes" item in the Application Menu is replaced with an
   * "Extensions" item, which serves as an alternative trigger for the
   * Extensions Button.
   * 
   * This event records when the user clicks on this "Extensions" menu item.
   */
  constexpr impl::EventMetric<OpenViaAppMenuExtra> open_via_app_menu(352);

  /**
   * generated from extensions_button.prefers_hidden_button
   * Records whether the user prefers the Extensions Button to be hidden. Corresponds to the inverse value of the `exceptions.unifiedExtensions.button.always_visible` pref.
   */
  constexpr impl::BooleanMetric prefers_hidden_button(353);

  /**
   * generated from extensions_button.temporarily_unhidden
   */
  enum class TemporarilyUnhiddenLabel: uint16_t {
    eCustomize = 0,
    eAddonInstallDoorhanger = 1,
    eExtensionControlledSetting = 2,
    eExtensionPermissionPrompt = 3,
    eExtensionsPanelShowing = 4,
    eExtensionBrowserActionPopup = 5,
    eAttentionBlocklist = 6,
    eAttentionPermissionDenied = 7,
    e__Other__,
  };
  /**
   * Counts how often the hidden Extensions Button is temporarily shown. There are multiple possible triggers for showing the extensions button, only the first that would trigger the transition from hidden to shown is going to be counted. For example, if the button is shown because the "attention" dot is shown, and a permission prompt is shown, then we only count the trigger for the attention dot, not the permission prompt.
   * customize is when the user entered Customize Mode, which causes the Extensions Button to show unconditionally until the user exits the mode.
   * addon_install_doorhanger covers notifications related to add-on installations, including blocked installations, add-on download progress, and failed installations. Permission prompts are NOT part of this, but covered by extension_permission_prompt. A typical installation flow triggers both addon_install_doorhanger and extension_permission_prompt.
   * extension_controlled_setting is when a notification is anchored to the Extensions Button that notifies the user of an extension-triggered change (new tab page, home page, first use of tabs.hide()). This is shown on first use of the relevant feature after the installation of an extension.
   * browser_action_open_popup is when the browserAction popup is opened. This is usually user-triggered (shortcut, context menu) or via the `action.openPopup()` API.
   * extension_permission_prompt is when an extension permission prompt is shown. This does not distinguish between install-time permission prompts, permission prompts on update or optional permission prompts at runtime.
   * extensions_panel_showing is when the Extensions Panel is being shown, for example via the Extensions appmenu item.
   * attention_blocklist is when the browser wants to draw attention to the fact that one of the add-ons has been blocklisted.
   * attention_permission_denied is when the browser wants to draw attention to the fact that one of the extensions was denied access to the page in the currently displayed tab. The access request is not a strong signal: a MV3 extension with content scripts whose permissions have been revoked by the user could trigger such an attention request on all websites.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TemporarilyUnhiddenLabel> temporarily_unhidden(354);

  /**
   * generated from extensions_button.toggle_visibility
   */
  struct ToggleVisibilityExtra {
    mozilla::Maybe<bool> isCustomizing;
    mozilla::Maybe<bool> isExtensionsPanelEmpty;
    mozilla::Maybe<bool> isTemporarilyShown;
    mozilla::Maybe<bool> shouldHide;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isCustomizing) {
        extraKeys.AppendElement()->AssignASCII("is_customizing");
        extraValues.AppendElement()->AssignASCII(isCustomizing.value() ? "true" : "false");
      }
      if (isExtensionsPanelEmpty) {
        extraKeys.AppendElement()->AssignASCII("is_extensions_panel_empty");
        extraValues.AppendElement()->AssignASCII(isExtensionsPanelEmpty.value() ? "true" : "false");
      }
      if (isTemporarilyShown) {
        extraKeys.AppendElement()->AssignASCII("is_temporarily_shown");
        extraValues.AppendElement()->AssignASCII(isTemporarilyShown.value() ? "true" : "false");
      }
      if (shouldHide) {
        extraKeys.AppendElement()->AssignASCII("should_hide");
        extraValues.AppendElement()->AssignASCII(shouldHide.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When a user changes the preferred visibility of the Extensions Button,
   * through the "Remove from Toolbar" or "Always Show in Toolbar" menu items.
   */
  constexpr impl::EventMetric<ToggleVisibilityExtra> toggle_visibility(355);
}

namespace extensions {
  /**
   * generated from extensions.allow_execute_script_in_moz_extension
   * Corresponds to the value of `extensions.webextensions.allow_executeScript_in_moz_extension` pref.
   */
  constexpr impl::BooleanMetric allow_execute_script_in_moz_extension(4793);

  /**
   * generated from extensions.match_moz_extension_document
   */
  struct MatchMozExtensionDocumentExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<bool> isTopLevelFrame;
    mozilla::Maybe<bool> restricted;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (isTopLevelFrame) {
        extraKeys.AppendElement()->AssignASCII("is_top_level_frame");
        extraValues.AppendElement()->AssignASCII(isTopLevelFrame.value() ? "true" : "false");
      }
      if (restricted) {
        extraKeys.AppendElement()->AssignASCII("restricted");
        extraValues.AppendElement()->AssignASCII(restricted.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Telemetry event reporting add-ons ids of the add-ons that have been matching extension pages (and either hit the restriction or being allowed to match the extension page based on the value of the related pref).
   */
  constexpr impl::EventMetric<MatchMozExtensionDocumentExtra> match_moz_extension_document(4794);

  /**
   * generated from extensions.process_event
   */
  enum class ProcessEventLabel: uint16_t {
    eCrashedBg = 0,
    eCrashedFg = 1,
    eCreatedBg = 2,
    eCreatedFg = 3,
    eCrashedOverThresholdBg = 4,
    eCrashedOverThresholdFg = 5,
    e__Other__,
  };
  /**
   * Counters for how many times the extension process has crashed or been created.
   * The labels with "_fg" / "_bg" suffixes are only recorded in Android builds,
   * while the "created" and "crashed" labels are recorded on both Desktop and Android
   * builds.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ProcessEventLabel> process_event(4795);

  /**
   * generated from extensions.startup_cache_load_time
   * Time to load and deserialize the extensions startupCache data.
   */
  constexpr impl::TimespanMetric startup_cache_load_time(4796);

  /**
   * generated from extensions.startup_cache_read_errors
   * The number of times an unexpected error has been raised while reading
   * the extensions StartupCache file.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> startup_cache_read_errors(4797);

  /**
   * generated from extensions.startup_cache_write_bytelength
   * The amount of bytes written to the extensions StartupCache file.
   */
  constexpr impl::QuantityMetric startup_cache_write_bytelength(4798);

  /**
   * generated from extensions.use_remote_policy
   * Corresponds to the value of `WebExtensionPolicy.useRemoteWebExtensions`.
   */
  constexpr impl::BooleanMetric use_remote_policy(4799);

  /**
   * generated from extensions.use_remote_pref
   * Corresponds to the value of `extensions.webextensions.remote` pref.
   */
  constexpr impl::BooleanMetric use_remote_pref(4800);
}

namespace extensions_apis_dnr {
  /**
   * generated from extensions.apis.dnr.evaluate_rules_count_max
   * Max amount of DNR rules being evaluated.
   */
  constexpr impl::QuantityMetric evaluate_rules_count_max(4801);

  /**
   * generated from extensions.apis.dnr.evaluate_rules_time
   * Amount of time it takes to evaluate DNR rules for one network request.
   */
  constexpr impl::TimingDistributionMetric evaluate_rules_time(4802);

  /**
   * generated from extensions.apis.dnr.startup_cache_entries
   */
  enum class StartupCacheEntriesLabel: uint16_t {
    eHit = 0,
    eMiss = 1,
    e__Other__,
  };
  /**
   * Counters for startup cache data hits or misses on initializating
   * DNR rules for extensions loaded on application startup.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, StartupCacheEntriesLabel> startup_cache_entries(4803);

  /**
   * generated from extensions.apis.dnr.startup_cache_read_size
   * Amount of data read from the DNR startup cache file.
   */
  constexpr impl::MemoryDistributionMetric startup_cache_read_size(4804);

  /**
   * generated from extensions.apis.dnr.startup_cache_read_time
   * Amount of time it takes to read data into the DNR startup cache file.
   */
  constexpr impl::TimingDistributionMetric startup_cache_read_time(4805);

  /**
   * generated from extensions.apis.dnr.startup_cache_write_size
   * Amount of data written to the DNR startup cache file.
   */
  constexpr impl::MemoryDistributionMetric startup_cache_write_size(4806);

  /**
   * generated from extensions.apis.dnr.startup_cache_write_time
   * Amount of time it takes to write data into the DNR startup cache file.
   */
  constexpr impl::TimingDistributionMetric startup_cache_write_time(4807);

  /**
   * generated from extensions.apis.dnr.validate_rules_time
   * Amount of time it takes to validate DNR rules of individual ruleset
   * when dynamic or static rulesets have been loaded from disk.
   */
  constexpr impl::TimingDistributionMetric validate_rules_time(4808);
}

namespace extensions_counters {
  /**
   * generated from extensions.counters.browser_action_preload_result
   */
  enum class BrowserActionPreloadResultLabel: uint16_t {
    ePopupshown = 0,
    eClearafterhover = 1,
    eClearaftermousedown = 2,
    e__Other__,
  };
  /**
   * Number of times an event page hit the idle timeout and results in one of the labels.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BrowserActionPreloadResultLabel> browser_action_preload_result(4809);

  /**
   * generated from extensions.counters.browser_action_preload_result_by_addonid
   * The number of times a browserAction popup is preloaded and results in one of the categories, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram WEBEXT_BROWSERACTION_POPUP_PRELOAD_RESULT_COUNT_BY_ADDONID.
   */
  constexpr impl::DualLabeledCounterMetric browser_action_preload_result_by_addonid(4810);

  /**
   * generated from extensions.counters.event_page_idle_result
   */
  enum class EventPageIdleResultLabel: uint16_t {
    eSuspend = 0,
    eResetOther = 1,
    eResetEvent = 2,
    eResetListeners = 3,
    eResetNativeapp = 4,
    eResetStreamfilter = 5,
    eResetParentapicall = 6,
    ePermissionsRequest = 7,
    eLaunchwebauthflow = 8,
    eDownloadsSaveas = 9,
    e__Other__,
  };
  /**
   * Number of times an event page hit the idle timeout and results in one of the labels.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EventPageIdleResultLabel> event_page_idle_result(4811);

  /**
   * generated from extensions.counters.event_page_idle_result_by_addonid
   * The number of times an event page hit the idle timeout and results in one of the categories, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram WEBEXT_EVENTPAGE_IDLE_RESULT_COUNT_BY_ADDONID.
   */
  constexpr impl::DualLabeledCounterMetric event_page_idle_result_by_addonid(4812);
}

namespace extensions_data {
  /**
   * generated from extensions.data.migrate_result
   */
  struct MigrateResultExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> backend;
    mozilla::Maybe<nsCString> dataMigrated;
    mozilla::Maybe<nsCString> errorName;
    mozilla::Maybe<nsCString> hasJsonfile;
    mozilla::Maybe<nsCString> hasOlddata;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (backend) {
        extraKeys.AppendElement()->AssignASCII("backend");
        extraValues.EmplaceBack(backend.value());
      }
      if (dataMigrated) {
        extraKeys.AppendElement()->AssignASCII("data_migrated");
        extraValues.EmplaceBack(dataMigrated.value());
      }
      if (errorName) {
        extraKeys.AppendElement()->AssignASCII("error_name");
        extraValues.EmplaceBack(errorName.value());
      }
      if (hasJsonfile) {
        extraKeys.AppendElement()->AssignASCII("has_jsonfile");
        extraValues.EmplaceBack(hasJsonfile.value());
      }
      if (hasOlddata) {
        extraKeys.AppendElement()->AssignASCII("has_olddata");
        extraValues.EmplaceBack(hasOlddata.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are sent when an extension is migrating its data to the new
   * IndexedDB backend.
   */
  constexpr impl::EventMetric<MigrateResultExtra> migrate_result(4813);

  /**
   * generated from extensions.data.migrate_result_count
   */
  enum class MigrateResultCountLabel: uint16_t {
    eSuccess = 0,
    eFailure = 1,
    e__Other__,
  };
  /**
   * The number of times a storage.local backend data migration has been completed and results in one of the categories.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram WEBEXT_STORAGE_LOCAL_IDB_MIGRATE_RESULT_COUNT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MigrateResultCountLabel> migrate_result_count(4814);

  /**
   * generated from extensions.data.storage_local_corrupted_reset
   */
  struct StorageLocalCorruptedResetExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<bool> afterReset;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<bool> resetDisabled;
    mozilla::Maybe<nsCString> resetErrorName;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (afterReset) {
        extraKeys.AppendElement()->AssignASCII("after_reset");
        extraValues.AppendElement()->AssignASCII(afterReset.value() ? "true" : "false");
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (resetDisabled) {
        extraKeys.AppendElement()->AssignASCII("reset_disabled");
        extraValues.AppendElement()->AssignASCII(resetDisabled.value() ? "true" : "false");
      }
      if (resetErrorName) {
        extraKeys.AppendElement()->AssignASCII("reset_error_name");
        extraValues.EmplaceBack(resetErrorName.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are collected when the underlying IndexedDB backend is detected
   * as corrupted and Firefox is resetting it to allow it to be recreated from
   * scratch.
   */
  constexpr impl::EventMetric<StorageLocalCorruptedResetExtra> storage_local_corrupted_reset(4815);

  /**
   * generated from extensions.data.storage_local_error
   */
  struct StorageLocalErrorExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> errorName;
    mozilla::Maybe<nsCString> method;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (errorName) {
        extraKeys.AppendElement()->AssignASCII("error_name");
        extraValues.EmplaceBack(errorName.value());
      }
      if (method) {
        extraKeys.AppendElement()->AssignASCII("method");
        extraValues.EmplaceBack(method.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are collected when an extension triggers an unexpected error
   * while running a storage.local API call (e.g. because of some underlying
   * QuotaManager and/or IndexedDB error).
   */
  constexpr impl::EventMetric<StorageLocalErrorExtra> storage_local_error(4816);

  /**
   * generated from extensions.data.sync_usage_quotas
   */
  struct SyncUsageQuotasExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> backend;
    mozilla::Maybe<uint32_t> itemsCount;
    mozilla::Maybe<uint32_t> itemsOverQuota;
    mozilla::Maybe<uint32_t> totalSizeBytes;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (backend) {
        extraKeys.AppendElement()->AssignASCII("backend");
        extraValues.EmplaceBack(backend.value());
      }
      if (itemsCount) {
        extraKeys.AppendElement()->AssignASCII("items_count");
        extraValues.AppendElement()->AppendInt(itemsCount.value());
      }
      if (itemsOverQuota) {
        extraKeys.AppendElement()->AssignASCII("items_over_quota");
        extraValues.AppendElement()->AppendInt(itemsOverQuota.value());
      }
      if (totalSizeBytes) {
        extraKeys.AppendElement()->AssignASCII("total_size_bytes");
        extraValues.AppendElement()->AppendInt(totalSizeBytes.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record the basic stat about usage, and are collected the
   * first time an extension uses the sync storage API during a session.
   */
  constexpr impl::EventMetric<SyncUsageQuotasExtra> sync_usage_quotas(4817);
}

namespace extensions_timing {
  /**
   * generated from extensions.timing.background_page_load
   * Amount of time it takes to load a WebExtensions background page, from when the
   * build function is called to when the page has finished processing the onload event.
   */
  constexpr impl::TimingDistributionMetric background_page_load(4818);

  /**
   * generated from extensions.timing.background_page_load_by_addonid
   * The amount of time it takes to load a WebExtensions background page, from when the build function is called to when the page has finished processing the onload event, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_BACKGROUND_PAGE_LOAD_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> background_page_load_by_addonid(4819);

  /**
   * generated from extensions.timing.browser_action_popup_open
   * Amount of time it takes for a BrowserAction popup to open.
   */
  constexpr impl::TimingDistributionMetric browser_action_popup_open(4820);

  /**
   * generated from extensions.timing.browser_action_popup_open_by_addonid
   * The amount of time it takes for a BrowserAction popup to open, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_BROWSERACTION_POPUP_OPEN_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> browser_action_popup_open_by_addonid(4821);

  /**
   * generated from extensions.timing.content_script_injection
   * Amount of time it takes for content scripts from a WebExtension to be injected into a window.
   */
  constexpr impl::TimingDistributionMetric content_script_injection(4822);

  /**
   * generated from extensions.timing.content_script_injection_by_addonid
   * The amount of time it takes for content scripts from a WebExtension to be injected into a window, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_CONTENT_SCRIPT_INJECTION_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> content_script_injection_by_addonid(4823);

  /**
   * generated from extensions.timing.event_page_running_time
   * Amount of time (keyed by addon id) that an event page has been running before being suspended,
   * or the entire addon shutdown.
   */
  constexpr impl::CustomDistributionMetric event_page_running_time(4824);

  /**
   * generated from extensions.timing.event_page_running_time_by_addonid
   * The amount of time (keyed by addon id) that an event page has been running before being suspended, or the entire addon shutdown.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_EVENTPAGE_RUNNING_TIME_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> event_page_running_time_by_addonid(4825);

  /**
   * generated from extensions.timing.extension_startup
   * Amount of time it takes for a WebExtension to start up, from when the
   * startup function is called to when the startup promise resolves.
   */
  constexpr impl::TimingDistributionMetric extension_startup(4826);

  /**
   * generated from extensions.timing.extension_startup_by_addonid
   * The amount of time it takes for a WebExtension to start up, from when the startup function is called to when the startup promise resolves, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_EXTENSION_STARTUP_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> extension_startup_by_addonid(4827);

  /**
   * generated from extensions.timing.page_action_popup_open
   * Amount of time it takes for a PageAction popup to open.
   */
  constexpr impl::TimingDistributionMetric page_action_popup_open(4828);

  /**
   * generated from extensions.timing.page_action_popup_open_by_addonid
   * The amount of time it takes for a PageAction popup to open, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_PAGEACTION_POPUP_OPEN_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> page_action_popup_open_by_addonid(4829);

  /**
   * generated from extensions.timing.storage_local_get_idb
   * Amount of time it takes to perform a get via storage.local using the IndexedDB backend.
   */
  constexpr impl::TimingDistributionMetric storage_local_get_idb(4830);

  /**
   * generated from extensions.timing.storage_local_get_idb_by_addonid
   * The amount of time it takes to perform a get via storage.local using the IndexedDB backend, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_STORAGE_LOCAL_IDB_GET_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> storage_local_get_idb_by_addonid(4831);

  /**
   * generated from extensions.timing.storage_local_set_idb
   * Amount of time it takes to perform a set via storage.local using the Indexed backend.
   */
  constexpr impl::TimingDistributionMetric storage_local_set_idb(4832);

  /**
   * generated from extensions.timing.storage_local_set_idb_by_addonid
   * The amount of time it takes to perform a set via storage.local using the IndexedDB backend, keyed by addon id.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBEXT_STORAGE_LOCAL_IDB_SET_MS_BY_ADDONID.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> storage_local_set_idb_by_addonid(4833);
}

} // namespace mozilla::glean

#endif // mozilla_GleanExtensionsMetrics_h
