/* THIS FILE IS AUTOGENERATED FROM ImageBitmap.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_IMAGEBITMAPBINDING_H_
#define DOM_IMAGEBITMAPBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
class CanvasRenderingContext2D;
struct ChannelPixelLayoutAtoms;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
struct ImageBitmapOptionsAtoms;
class ImageData;
struct NativePropertyHooks;
class OffscreenCanvas;
class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData;
class ProtoAndIfaceCache;
class SVGImageElement;
class VideoFrame;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class ImageBitmapFormat : uint8_t {
  RGBA32,
  BGRA32,
  RGB24,
  BGR24,
  GRAY8,
  YUV444P,
  YUV422P,
  YUV420P,
  YUV420SP_NV12,
  YUV420SP_NV21,
  HSV,
  Lab,
  DEPTH,
};

namespace binding_detail {
template <> struct EnumStrings<ImageBitmapFormat> {
  static constexpr nsLiteralCString Values[13] {
    "RGBA32"_ns,
    "BGRA32"_ns,
    "RGB24"_ns,
    "BGR24"_ns,
    "GRAY8"_ns,
    "YUV444P"_ns,
    "YUV422P"_ns,
    "YUV420P"_ns,
    "YUV420SP_NV12"_ns,
    "YUV420SP_NV21"_ns,
    "HSV"_ns,
    "Lab"_ns,
    "DEPTH"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ImageBitmapFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ChannelPixelLayoutDataType : uint8_t {
  Uint8,
  Int8,
  Uint16,
  Int16,
  Uint32,
  Int32,
  Float32,
  Float64,
};

namespace binding_detail {
template <> struct EnumStrings<ChannelPixelLayoutDataType> {
  static constexpr nsLiteralCString Values[8] {
    "uint8"_ns,
    "int8"_ns,
    "uint16"_ns,
    "int16"_ns,
    "uint32"_ns,
    "int32"_ns,
    "float32"_ns,
    "float64"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ChannelPixelLayoutDataType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ImageOrientation : uint8_t {
  None,
  FlipY,
  From_image,
};

namespace binding_detail {
template <> struct EnumStrings<ImageOrientation> {
  static constexpr nsLiteralCString Values[3] {
    "none"_ns,
    "flipY"_ns,
    "from-image"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ImageOrientation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PremultiplyAlpha : uint8_t {
  None,
  Premultiply,
  Default,
};

namespace binding_detail {
template <> struct EnumStrings<PremultiplyAlpha> {
  static constexpr nsLiteralCString Values[3] {
    "none"_ns,
    "premultiply"_ns,
    "default"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, PremultiplyAlpha aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ColorSpaceConversion : uint8_t {
  None,
  Default,
};

namespace binding_detail {
template <> struct EnumStrings<ColorSpaceConversion> {
  static constexpr nsLiteralCString Values[2] {
    "none"_ns,
    "default"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ColorSpaceConversion aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ResizeQuality : uint8_t {
  Pixelated,
  Low,
  Medium,
  High,
};

namespace binding_detail {
template <> struct EnumStrings<ResizeQuality> {
  static constexpr nsLiteralCString Values[4] {
    "pixelated"_ns,
    "low"_ns,
    "medium"_ns,
    "high"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ResizeQuality aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData& aUnion);


struct ChannelPixelLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ChannelPixelLayoutDataType mDataType;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSkip;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStride;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  ChannelPixelLayout();

  explicit inline ChannelPixelLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ChannelPixelLayout(ChannelPixelLayout&& aOther) = default;

  explicit inline ChannelPixelLayout(const ChannelPixelLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ChannelPixelLayout&
  operator=(const ChannelPixelLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, ChannelPixelLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastChannelPixelLayout : public ChannelPixelLayout
{
  inline FastChannelPixelLayout()
    : ChannelPixelLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eOffscreenCanvas,
    eImageBitmap,
    eVideoFrame,
    eBlob,
    eCanvasRenderingContext2D,
    eImageData
  };
public:
  enum class Type
  {
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eSVGImageElement = TypeOrUninit::eSVGImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eHTMLVideoElement = TypeOrUninit::eHTMLVideoElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas,
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eVideoFrame = TypeOrUninit::eVideoFrame,
    eBlob = TypeOrUninit::eBlob,
    eCanvasRenderingContext2D = TypeOrUninit::eCanvasRenderingContext2D,
    eImageData = TypeOrUninit::eImageData
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<NonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;
    UnionMember<NonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<NonNull<mozilla::dom::VideoFrame> > mVideoFrame;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<NonNull<mozilla::dom::CanvasRenderingContext2D> > mCanvasRenderingContext2D;
    UnionMember<NonNull<mozilla::dom::ImageData> > mImageData;

  };

  TypeOrUninit mType;
  Value mValue;

  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData&) = delete;
  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData& operator=(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData&) = delete;
public:
  explicit inline HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    Uninit();
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline mozilla::dom::HTMLImageElement&
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    Uninit();
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline mozilla::dom::SVGImageElement&
  GetAsSVGImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    Uninit();
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline mozilla::dom::HTMLVideoElement&
  GetAsHTMLVideoElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    Uninit();
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline mozilla::dom::ImageBitmap&
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::VideoFrame>&
  RawSetAsVideoFrame()
  {
    if (mType == eVideoFrame) {
      return mValue.mVideoFrame.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eVideoFrame;
    return mValue.mVideoFrame.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::VideoFrame>&
  SetAsVideoFrame()
  {
    if (mType == eVideoFrame) {
      return mValue.mVideoFrame.Value();
    }
    Uninit();
    mType = eVideoFrame;
    return mValue.mVideoFrame.SetValue();
  }

  inline bool
  IsVideoFrame() const
  {
    return mType == eVideoFrame;
  }

  inline NonNull<mozilla::dom::VideoFrame>&
  GetAsVideoFrame()
  {
    MOZ_RELEASE_ASSERT(IsVideoFrame(), "Wrong type!");
    return mValue.mVideoFrame.Value();
  }

  inline mozilla::dom::VideoFrame&
  GetAsVideoFrame() const
  {
    MOZ_RELEASE_ASSERT(IsVideoFrame(), "Wrong type!");
    return mValue.mVideoFrame.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  RawSetAsCanvasRenderingContext2D()
  {
    if (mType == eCanvasRenderingContext2D) {
      return mValue.mCanvasRenderingContext2D.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasRenderingContext2D;
    return mValue.mCanvasRenderingContext2D.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  SetAsCanvasRenderingContext2D()
  {
    if (mType == eCanvasRenderingContext2D) {
      return mValue.mCanvasRenderingContext2D.Value();
    }
    Uninit();
    mType = eCanvasRenderingContext2D;
    return mValue.mCanvasRenderingContext2D.SetValue();
  }

  inline bool
  IsCanvasRenderingContext2D() const
  {
    return mType == eCanvasRenderingContext2D;
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  GetAsCanvasRenderingContext2D()
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline mozilla::dom::CanvasRenderingContext2D&
  GetAsCanvasRenderingContext2D() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ImageData>&
  RawSetAsImageData()
  {
    if (mType == eImageData) {
      return mValue.mImageData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageData;
    return mValue.mImageData.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ImageData>&
  SetAsImageData()
  {
    if (mType == eImageData) {
      return mValue.mImageData.Value();
    }
    Uninit();
    mType = eImageData;
    return mValue.mImageData.SetValue();
  }

  inline bool
  IsImageData() const
  {
    return mType == eImageData;
  }

  inline NonNull<mozilla::dom::ImageData>&
  GetAsImageData()
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline mozilla::dom::ImageData&
  GetAsImageData() const
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLImageElement: {
        DestroyHTMLImageElement();
        break;
      }
      case eSVGImageElement: {
        DestroySVGImageElement();
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eHTMLVideoElement: {
        DestroyHTMLVideoElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
      case eImageBitmap: {
        DestroyImageBitmap();
        break;
      }
      case eVideoFrame: {
        DestroyVideoFrame();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eCanvasRenderingContext2D: {
        DestroyCanvasRenderingContext2D();
        break;
      }
      case eImageData: {
        DestroyImageData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    mValue.mHTMLImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    mValue.mSVGImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    mValue.mHTMLVideoElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    mValue.mImageBitmap.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToVideoFrame(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToVideoFrame(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyVideoFrame()
  {
    MOZ_RELEASE_ASSERT(IsVideoFrame(), "Wrong type!");
    mValue.mVideoFrame.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCanvasRenderingContext2D()
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    mValue.mCanvasRenderingContext2D.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToImageData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageData()
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    mValue.mImageData.Destroy();
    mType = eUninitialized;
  }
};


class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eOffscreenCanvas,
    eImageBitmap,
    eVideoFrame,
    eBlob,
    eCanvasRenderingContext2D,
    eImageData
  };
public:
  enum class Type
  {
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eSVGImageElement = TypeOrUninit::eSVGImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eHTMLVideoElement = TypeOrUninit::eHTMLVideoElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas,
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eVideoFrame = TypeOrUninit::eVideoFrame,
    eBlob = TypeOrUninit::eBlob,
    eCanvasRenderingContext2D = TypeOrUninit::eCanvasRenderingContext2D,
    eImageData = TypeOrUninit::eImageData
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<OwningNonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;
    UnionMember<OwningNonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<OwningNonNull<mozilla::dom::VideoFrame> > mVideoFrame;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<OwningNonNull<mozilla::dom::CanvasRenderingContext2D> > mCanvasRenderingContext2D;
    UnionMember<OwningNonNull<mozilla::dom::ImageData> > mImageData;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData()
    : mType(eUninitialized)
  {
  }

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData&& aOther);

  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement();

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement> const &
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement();

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement> const &
  GetAsSVGImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement();

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement> const &
  GetAsHTMLVideoElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap();

  [[nodiscard]] OwningNonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap();

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap> const &
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::VideoFrame>&
  RawSetAsVideoFrame();

  [[nodiscard]] OwningNonNull<mozilla::dom::VideoFrame>&
  SetAsVideoFrame();

  inline bool
  IsVideoFrame() const
  {
    return mType == eVideoFrame;
  }

  inline OwningNonNull<mozilla::dom::VideoFrame>&
  GetAsVideoFrame()
  {
    MOZ_RELEASE_ASSERT(IsVideoFrame(), "Wrong type!");
    return mValue.mVideoFrame.Value();
  }

  inline OwningNonNull<mozilla::dom::VideoFrame> const &
  GetAsVideoFrame() const
  {
    MOZ_RELEASE_ASSERT(IsVideoFrame(), "Wrong type!");
    return mValue.mVideoFrame.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  [[nodiscard]] OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  RawSetAsCanvasRenderingContext2D();

  [[nodiscard]] OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  SetAsCanvasRenderingContext2D();

  inline bool
  IsCanvasRenderingContext2D() const
  {
    return mType == eCanvasRenderingContext2D;
  }

  inline OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  GetAsCanvasRenderingContext2D()
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasRenderingContext2D> const &
  GetAsCanvasRenderingContext2D() const
  {
    MOZ_RELEASE_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::ImageData>&
  RawSetAsImageData();

  [[nodiscard]] OwningNonNull<mozilla::dom::ImageData>&
  SetAsImageData();

  inline bool
  IsImageData() const
  {
    return mType == eImageData;
  }

  inline OwningNonNull<mozilla::dom::ImageData>&
  GetAsImageData()
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageData> const &
  GetAsImageData() const
  {
    MOZ_RELEASE_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData&
  operator=(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData&
  operator=(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrameOrBlobOrCanvasRenderingContext2DOrImageData& aOther);

private:
  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLImageElement();

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySVGImageElement();

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLVideoElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageBitmap();

  bool
  TrySetToVideoFrame(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToVideoFrame(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyVideoFrame();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCanvasRenderingContext2D();

  bool
  TrySetToImageData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageData();
};


struct ImageBitmapOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ColorSpaceConversion mColorSpaceConversion;
  MOZ_INIT_OUTSIDE_CTOR ImageOrientation mImageOrientation;
  MOZ_INIT_OUTSIDE_CTOR PremultiplyAlpha mPremultiplyAlpha;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mResizeHeight;
  MOZ_INIT_OUTSIDE_CTOR ResizeQuality mResizeQuality;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mResizeWidth;

  ImageBitmapOptions();

  explicit inline ImageBitmapOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImageBitmapOptions(ImageBitmapOptions&& aOther) = default;

  explicit inline ImageBitmapOptions(const ImageBitmapOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ImageBitmapOptions&
  operator=(const ImageBitmapOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ImageBitmapOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastImageBitmapOptions : public ImageBitmapOptions
{
  inline FastImageBitmapOptions()
    : ImageBitmapOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ImageBitmap_Binding {

  typedef mozilla::dom::ImageBitmap NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::ImageBitmap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ImageBitmap,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ImageBitmap_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::ImageBitmapFormat>
{
  static constexpr dom::ImageBitmapFormat value = dom::ImageBitmapFormat::DEPTH;

  static_assert(static_cast<uint8_t>(dom::ImageBitmapFormat::RGBA32) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ImageBitmapFormat>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::ChannelPixelLayoutDataType>
{
  static constexpr dom::ChannelPixelLayoutDataType value = dom::ChannelPixelLayoutDataType::Float64;

  static_assert(static_cast<uint8_t>(dom::ChannelPixelLayoutDataType::Uint8) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ChannelPixelLayoutDataType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::ImageOrientation>
{
  static constexpr dom::ImageOrientation value = dom::ImageOrientation::From_image;

  static_assert(static_cast<uint8_t>(dom::ImageOrientation::None) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ImageOrientation>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::PremultiplyAlpha>
{
  static constexpr dom::PremultiplyAlpha value = dom::PremultiplyAlpha::Default;

  static_assert(static_cast<uint8_t>(dom::PremultiplyAlpha::None) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::PremultiplyAlpha>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::ColorSpaceConversion>
{
  static constexpr dom::ColorSpaceConversion value = dom::ColorSpaceConversion::Default;

  static_assert(static_cast<uint8_t>(dom::ColorSpaceConversion::None) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ColorSpaceConversion>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::ResizeQuality>
{
  static constexpr dom::ResizeQuality value = dom::ResizeQuality::High;

  static_assert(static_cast<uint8_t>(dom::ResizeQuality::Pixelated) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ResizeQuality>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_IMAGEBITMAPBINDING_H_
