#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentPictureInPicture = 3369,
  DocumentPictureInPictureEvent = 3394,
  DocumentTimeline = 3424,
  DocumentType = 3441,
  DominatorTree = 3454,
  DragEvent = 3468,
  DynamicsCompressorNode = 3478,
  EXT_blend_minmax = 3501,
  EXT_color_buffer_float = 3518,
  EXT_color_buffer_half_float = 3541,
  EXT_depth_clamp = 3569,
  EXT_disjoint_timer_query = 3585,
  EXT_float_blend = 3610,
  EXT_frag_depth = 3626,
  EXT_sRGB = 3641,
  EXT_shader_texture_lod = 3650,
  EXT_texture_compression_bptc = 3673,
  EXT_texture_compression_rgtc = 3702,
  EXT_texture_filter_anisotropic = 3731,
  EXT_texture_norm16 = 3762,
  Element = 3781,
  ElementInternals = 3789,
  EncodedAudioChunk = 3806,
  EncodedVideoChunk = 3824,
  ErrorEvent = 3842,
  Event = 3853,
  EventCallbackDebuggerNotification = 3859,
  EventCounts = 3893,
  EventSource = 3905,
  EventTarget = 3917,
  Exception = 3929,
  ExtendableCookieChangeEvent = 3939,
  ExtendableEvent = 3967,
  ExtendableMessageEvent = 3983,
  ExtensionAlarms = 4006,
  ExtensionBrowser = 4022,
  ExtensionBrowserSettings = 4039,
  ExtensionBrowserSettingsColorManagement = 4064,
  ExtensionDns = 4104,
  ExtensionEventManager = 4117,
  ExtensionMockAPI = 4139,
  ExtensionPort = 4156,
  ExtensionProxy = 4170,
  ExtensionRuntime = 4185,
  ExtensionScripting = 4202,
  ExtensionSetting = 4221,
  ExtensionTest = 4238,
  External = 4252,
  FeaturePolicy = 4261,
  FeaturePolicyViolationReportBody = 4275,
  FetchEvent = 4308,
  FetchObserver = 4319,
  File = 4333,
  FileList = 4338,
  FileReader = 4347,
  FileReaderSync = 4358,
  FileSystem = 4373,
  FileSystemDirectoryEntry = 4384,
  FileSystemDirectoryHandle = 4409,
  FileSystemDirectoryHandle_AsyncIterator = 4435,
  FileSystemDirectoryIterator = 4475,
  FileSystemDirectoryReader = 4503,
  FileSystemEntry = 4529,
  FileSystemFileEntry = 4545,
  FileSystemFileHandle = 4565,
  FileSystemHandle = 4586,
  FileSystemSyncAccessHandle = 4603,
  FileSystemWritableFileStream = 4630,
  Flex = 4659,
  FlexItemValues = 4664,
  FlexLineValues = 4679,
  FluentBundle = 4694,
  FluentBundleAsyncIterator = 4707,
  FluentBundleIterator = 4733,
  FluentPattern = 4754,
  FluentResource = 4768,
  FocusEvent = 4783,
  FontFace = 4794,
  FontFaceSet = 4803,
  FontFaceSetIterator = 4815,
  FontFaceSetLoadEvent = 4835,
  FormData = 4856,
  FormData_Iterator = 4865,
  FormDataEvent = 4883,
  FragmentDirective = 4897,
  FrameCrashedEvent = 4915,
  FrameLoader = 4933,
  GPU = 4945,
  GPUAdapter = 4949,
  GPUAdapterInfo = 4960,
  GPUBindGroup = 4975,
  GPUBindGroupLayout = 4988,
  GPUBuffer = 5007,
  GPUBufferUsage = 5017,
  GPUCanvasContext = 5032,
  GPUColorWrite = 5049,
  GPUCommandBuffer = 5063,
  GPUCommandEncoder = 5080,
  GPUCompilationInfo = 5098,
  GPUCompilationMessage = 5117,
  GPUComputePassEncoder = 5139,
  GPUComputePipeline = 5161,
  GPUDevice = 5180,
  GPUDeviceLostInfo = 5190,
  GPUError = 5208,
  GPUExternalTexture = 5217,
  GPUInternalError = 5236,
  GPUMapMode = 5253,
  GPUOutOfMemoryError = 5264,
  GPUPipelineError = 5284,
  GPUPipelineLayout = 5301,
  GPUQuerySet = 5319,
  GPUQueue = 5331,
  GPURenderBundle = 5340,
  GPURenderBundleEncoder = 5356,
  GPURenderPassEncoder = 5379,
  GPURenderPipeline = 5400,
  GPUSampler = 5418,
  GPUShaderModule = 5429,
  GPUShaderStage = 5445,
  GPUSupportedFeatures = 5460,
  GPUSupportedLimits = 5481,
  GPUTexture = 5500,
  GPUTextureUsage = 5511,
  GPUTextureView = 5527,
  GPUUncapturedErrorEvent = 5542,
  GPUValidationError = 5566,
  GainNode = 5585,
  Gamepad = 5594,
  GamepadAxisMoveEvent = 5602,
  GamepadButton = 5623,
  GamepadButtonEvent = 5637,
  GamepadEvent = 5656,
  GamepadHapticActuator = 5669,
  GamepadLightIndicator = 5691,
  GamepadPose = 5713,
  GamepadServiceTest = 5725,
  GamepadTouch = 5744,
  Geolocation = 5757,
  GeolocationCoordinates = 5769,
  GeolocationPosition = 5792,
  GeolocationPositionError = 5812,
  GetUserMediaRequest = 5837,
  GleanBoolean = 5857,
  GleanCategory = 5870,
  GleanCounter = 5884,
  GleanCustomDistribution = 5897,
  GleanDatetime = 5921,
  GleanDenominator = 5935,
  GleanDualLabeledCounter = 5952,
  GleanEvent = 5976,
  GleanImpl = 5987,
  GleanLabeled = 5997,
  GleanMemoryDistribution = 6010,
  GleanMetric = 6034,
  GleanNumerator = 6046,
  GleanObject = 6061,
  GleanPingsImpl = 6073,
  GleanQuantity = 6088,
  GleanRate = 6102,
  GleanString = 6112,
  GleanStringList = 6124,
  GleanText = 6140,
  GleanTimespan = 6150,
  GleanTimingDistribution = 6164,
  GleanUrl = 6188,
  GleanUuid = 6197,
  Grid = 6207,
  GridArea = 6212,
  GridDimension = 6221,
  GridLine = 6235,
  GridLines = 6244,
  GridTrack = 6254,
  GridTracks = 6264,
  HTMLAllCollection = 6275,
  HTMLAnchorElement = 6293,
  HTMLAreaElement = 6311,
  HTMLAudioElement = 6327,
  HTMLBRElement = 6344,
  HTMLBaseElement = 6358,
  HTMLBodyElement = 6374,
  HTMLButtonElement = 6390,
  HTMLCanvasElement = 6408,
  HTMLCollection = 6426,
  HTMLDListElement = 6441,
  HTMLDataElement = 6458,
  HTMLDataListElement = 6474,
  HTMLDetailsElement = 6494,
  HTMLDialogElement = 6513,
  HTMLDirectoryElement = 6531,
  HTMLDivElement = 6552,
  HTMLDocument = 6567,
  HTMLElement = 6580,
  HTMLEmbedElement = 6592,
  HTMLFieldSetElement = 6609,
  HTMLFontElement = 6629,
  HTMLFormControlsCollection = 6645,
  HTMLFormElement = 6672,
  HTMLFrameElement = 6688,
  HTMLFrameSetElement = 6705,
  HTMLHRElement = 6725,
  HTMLHeadElement = 6739,
  HTMLHeadingElement = 6755,
  HTMLHtmlElement = 6774,
  HTMLIFrameElement = 6790,
  HTMLImageElement = 6808,
  HTMLInputElement = 6825,
  HTMLLIElement = 6842,
  HTMLLabelElement = 6856,
  HTMLLegendElement = 6873,
  HTMLLinkElement = 6891,
  HTMLMapElement = 6907,
  HTMLMarqueeElement = 6922,
  HTMLMediaElement = 6941,
  HTMLMenuElement = 6958,
  HTMLMetaElement = 6974,
  HTMLMeterElement = 6990,
  HTMLModElement = 7007,
  HTMLOListElement = 7022,
  HTMLObjectElement = 7039,
  HTMLOptGroupElement = 7057,
  HTMLOptionElement = 7077,
  HTMLOptionsCollection = 7095,
  HTMLOutputElement = 7117,
  HTMLParagraphElement = 7135,
  HTMLParamElement = 7156,
  HTMLPictureElement = 7173,
  HTMLPreElement = 7192,
  HTMLProgressElement = 7207,
  HTMLQuoteElement = 7227,
  HTMLScriptElement = 7244,
  HTMLSelectElement = 7262,
  HTMLSlotElement = 7280,
  HTMLSourceElement = 7296,
  HTMLSpanElement = 7314,
  HTMLStyleElement = 7330,
  HTMLTableCaptionElement = 7347,
  HTMLTableCellElement = 7371,
  HTMLTableColElement = 7392,
  HTMLTableElement = 7412,
  HTMLTableRowElement = 7429,
  HTMLTableSectionElement = 7449,
  HTMLTemplateElement = 7473,
  HTMLTextAreaElement = 7493,
  HTMLTimeElement = 7513,
  HTMLTitleElement = 7529,
  HTMLTrackElement = 7546,
  HTMLUListElement = 7563,
  HTMLUnknownElement = 7580,
  HTMLVideoElement = 7599,
  HashChangeEvent = 7616,
  Headers = 7632,
  Headers_Iterator = 7640,
  HeapSnapshot = 7657,
  Highlight = 7670,
  HighlightRegistry = 7680,
  History = 7698,
  IDBCursor = 7706,
  IDBCursorWithValue = 7716,
  IDBDatabase = 7735,
  IDBFactory = 7747,
  IDBIndex = 7758,
  IDBKeyRange = 7767,
  IDBObjectStore = 7779,
  IDBOpenDBRequest = 7794,
  IDBRequest = 7811,
  IDBTransaction = 7822,
  IDBVersionChangeEvent = 7837,
  IIRFilterNode = 7859,
  IOUtils = 7873,
  IdentityCredential = 7881,
  IdentityProvider = 7900,
  IdleDeadline = 7917,
  Image = 7930,
  ImageBitmap = 7936,
  ImageBitmapRenderingContext = 7948,
  ImageCapture = 7976,
  ImageCaptureError = 7989,
  ImageCaptureErrorEvent = 8007,
  ImageData = 8030,
  ImageDecoder = 8040,
  ImageDocument = 8053,
  ImageTrack = 8067,
  ImageTrackList = 8078,
  InferenceSession = 8093,
  InputEvent = 8110,
  InspectorCSSParser = 8121,
  InspectorFontFace = 8140,
  InspectorUtils = 8158,
  IntersectionObserver = 8173,
  IntersectionObserverEntry = 8194,
  IntlUtils = 8220,
  JSActorTypeUtils = 8230,
  JSProcessActorChild = 8247,
  JSProcessActorParent = 8267,
  JSWindowActorChild = 8288,
  JSWindowActorParent = 8307,
  KeyEvent = 8327,
  KeyboardEvent = 8336,
  KeyframeEffect = 8350,
  L10nFileSource = 8365,
  L10nOverlays = 8380,
  L10nRegistry = 8393,
  LargestContentfulPaint = 8406,
  LegacyMozTCPSocket = 8429,
  LlamaRunner = 8448,
  Localization = 8460,
  Location = 8473,
  Lock = 8482,
  LockManager = 8487,
  MIDIAccess = 8499,
  MIDIConnectionEvent = 8510,
  MIDIInput = 8530,
  MIDIInputMap = 8540,
  MIDIMessageEvent = 8553,
  MIDIOutput = 8570,
  MIDIOutputMap = 8581,
  MIDIPort = 8595,
  MLS = 8604,
  MLSGroupView = 8608,
  MOZ_debug = 8621,
  MatchGlob = 8631,
  MatchPattern = 8641,
  MatchPatternSet = 8654,
  MathMLElement = 8670,
  MediaCapabilities = 8684,
  MediaControlService = 8702,
  MediaController = 8722,
  MediaDeviceInfo = 8738,
  MediaDevices = 8754,
  MediaElementAudioSourceNode = 8767,
  MediaEncryptedEvent = 8795,
  MediaError = 8815,
  MediaKeyError = 8826,
  MediaKeyMessageEvent = 8840,
  MediaKeySession = 8861,
  MediaKeyStatusMap = 8877,
  MediaKeyStatusMap_Iterator = 8895,
  MediaKeySystemAccess = 8922,
  MediaKeys = 8943,
  MediaList = 8953,
  MediaMetadata = 8963,
  MediaQueryList = 8977,
  MediaQueryListEvent = 8992,
  MediaRecorder = 9012,
  MediaRecorderErrorEvent = 9026,
  MediaSession = 9050,
  MediaSource = 9063,
  MediaStream = 9075,
  MediaStreamAudioDestinationNode = 9087,
  MediaStreamAudioSourceNode = 9119,
  MediaStreamError = 9146,
  MediaStreamEvent = 9163,
  MediaStreamTrack = 9180,
  MediaStreamTrackAudioSourceNode = 9197,
  MediaStreamTrackEvent = 9229,
  MerchantValidationEvent = 9251,
  MessageBroadcaster = 9275,
  MessageChannel = 9294,
  MessageEvent = 9309,
  MessageListenerManager = 9322,
  MessagePort = 9345,
  MessageSender = 9357,
  MimeType = 9371,
  MimeTypeArray = 9380,
  MouseEvent = 9394,
  MouseScrollEvent = 9405,
  MozCanvasPrintState = 9422,
  MozDocumentMatcher = 9442,
  MozDocumentObserver = 9461,
  MozQueryInterface = 9481,
  MozSharedMap = 9499,
  MozSharedMap_Iterator = 9512,
  MozSharedMapChangeEvent = 9534,
  MozStorageAsyncStatementParams = 9558,
  MozStorageStatementParams = 9589,
  MozStorageStatementRow = 9615,
  MozWritableSharedMap = 9638,
  MutationObserver = 9659,
  MutationRecord = 9676,
  NamedNodeMap = 9691,
  NavigateEvent = 9704,
  Navigation = 9718,
  NavigationActivation = 9729,
  NavigationCurrentEntryChangeEvent = 9750,
  NavigationDestination = 9784,
  NavigationHistoryEntry = 9806,
  NavigationPrecommitController = 9829,
  NavigationPreloadManager = 9859,
  NavigationTransition = 9884,
  Navigator = 9905,
  NavigatorLogin = 9915,
  NetworkInformation = 9930,
  Node = 9949,
  NodeFilter = 9954,
  NodeIterator = 9965,
  NodeList = 9978,
  Notification = 9987,
  NotificationEvent = 10000,
  NotifyPaintEvent = 10018,
  OES_draw_buffers_indexed = 10035,
  OES_element_index_uint = 10060,
  OES_fbo_render_mipmap = 10083,
  OES_standard_derivatives = 10105,
  OES_texture_float = 10130,
  OES_texture_float_linear = 10148,
  OES_texture_half_float = 10173,
  OES_texture_half_float_linear = 10196,
  OES_vertex_array_object = 10226,
  OVR_multiview2 = 10250,
  OfflineAudioCompletionEvent = 10265,
  OfflineAudioContext = 10293,
  OffscreenCanvas = 10313,
  OffscreenCanvasRenderingContext2D = 10329,
  Option = 10363,
  OscillatorNode = 10370,
  PageRevealEvent = 10385,
  PageSwapEvent = 10401,
  PageTransitionEvent = 10415,
  PaintRequest = 10435,
  PaintRequestList = 10448,
  PaintWorkletGlobalScope = 10465,
  PannerNode = 10489,
  ParentProcessMessageManager = 10500,
  Path2D = 10528,
  PathUtils = 10535,
  PaymentAddress = 10545,
  PaymentMethodChangeEvent = 10560,
  PaymentRequest = 10585,
  PaymentRequestUpdateEvent = 10600,
  PaymentResponse = 10626,
  PeerConnectionImpl = 10642,
  PeerConnectionObserver = 10661,
  Performance = 10684,
  PerformanceEntry = 10696,
  PerformanceEntryEvent = 10713,
  PerformanceEventTiming = 10735,
  PerformanceMark = 10758,
  PerformanceMeasure = 10774,
  PerformanceNavigation = 10793,
  PerformanceNavigationTiming = 10815,
  PerformanceObserver = 10843,
  PerformanceObserverEntryList = 10863,
  PerformancePaintTiming = 10892,
  PerformanceResourceTiming = 10915,
  PerformanceServerTiming = 10941,
  PerformanceTiming = 10965,
  PeriodicWave = 10983,
  PermissionStatus = 10996,
  Permissions = 11013,
  PlacesBookmark = 11025,
  PlacesBookmarkAddition = 11040,
  PlacesBookmarkChanged = 11063,
  PlacesBookmarkGuid = 11085,
  PlacesBookmarkKeyword = 11104,
  PlacesBookmarkMoved = 11126,
  PlacesBookmarkRemoved = 11146,
  PlacesBookmarkTags = 11168,
  PlacesBookmarkTime = 11187,
  PlacesBookmarkTitle = 11206,
  PlacesBookmarkUrl = 11226,
  PlacesEvent = 11244,
  PlacesEventCounts = 11256,
  PlacesFavicon = 11274,
  PlacesHistoryCleared = 11288,
  PlacesObservers = 11309,
  PlacesPurgeCaches = 11325,
  PlacesRanking = 11343,
  PlacesVisit = 11357,
  PlacesVisitRemoved = 11369,
  PlacesVisitTitle = 11388,
  PlacesWeakCallbackWrapper = 11405,
  Plugin = 11431,
  PluginArray = 11438,
  PluginCrashedEvent = 11450,
  PointerEvent = 11469,
  PopStateEvent = 11482,
  PopupBlockedEvent = 11496,
  PopupPositionedEvent = 11514,
  PositionStateEvent = 11535,
  PrecompiledScript = 11554,
  PrivateAttribution = 11572,
  ProcessMessageManager = 11591,
  ProcessingInstruction = 11613,
  ProgressEvent = 11635,
  PromiseDebugging = 11649,
  PromiseNativeHandler = 11666,
  PromiseRejectionEvent = 11687,
  PublicKeyCredential = 11709,
  PushEvent = 11729,
  PushManager = 11739,
  PushManagerImpl = 11751,
  PushMessageData = 11767,
  PushSubscription = 11783,
  PushSubscriptionChangeEvent = 11800,
  PushSubscriptionOptions = 11828,
  RTCCertificate = 11852,
  RTCDTMFSender = 11867,
  RTCDTMFToneChangeEvent = 11881,
  RTCDataChannel = 11904,
  RTCDataChannelEvent = 11919,
  RTCDtlsTransport = 11939,
  RTCEncodedAudioFrame = 11956,
  RTCEncodedVideoFrame = 11977,
  RTCIceCandidate = 11998,
  RTCIceTransport = 12014,
  RTCIdentityProviderRegistrar = 12030,
  RTCPeerConnection = 12059,
  RTCPeerConnectionIceEvent = 12077,
  RTCPeerConnectionStatic = 12103,
  RTCRtpReceiver = 12127,
  RTCRtpScriptTransform = 12142,
  RTCRtpScriptTransformer = 12164,
  RTCRtpSender = 12188,
  RTCRtpTransceiver = 12201,
  RTCSctpTransport = 12219,
  RTCSessionDescription = 12236,
  RTCStatsReport = 12258,
  RTCTrackEvent = 12273,
  RTCTransformEvent = 12287,
  RadioNodeList = 12305,
  Range = 12319,
  ReadableByteStreamController = 12325,
  ReadableStream = 12354,
  ReadableStream_AsyncIterator = 12369,
  ReadableStreamBYOBReader = 12398,
  ReadableStreamBYOBRequest = 12423,
  ReadableStreamDefaultController = 12449,
  ReadableStreamDefaultReader = 12481,
  RedirectBlockedEvent = 12509,
  Report = 12530,
  ReportBody = 12537,
  ReportingObserver = 12548,
  Request = 12566,
  ResizeObserver = 12574,
  ResizeObserverEntry = 12589,
  ResizeObserverSize = 12609,
  Response = 12628,
  SVGAElement = 12637,
  SVGAngle = 12649,
  SVGAnimateElement = 12658,
  SVGAnimateMotionElement = 12676,
  SVGAnimateTransformElement = 12700,
  SVGAnimatedAngle = 12727,
  SVGAnimatedBoolean = 12744,
  SVGAnimatedEnumeration = 12763,
  SVGAnimatedInteger = 12786,
  SVGAnimatedLength = 12805,
  SVGAnimatedLengthList = 12823,
  SVGAnimatedNumber = 12845,
  SVGAnimatedNumberList = 12863,
  SVGAnimatedPreserveAspectRatio = 12885,
  SVGAnimatedRect = 12916,
  SVGAnimatedString = 12932,
  SVGAnimatedTransformList = 12950,
  SVGAnimationElement = 12975,
  SVGCircleElement = 12995,
  SVGClipPathElement = 13012,
  SVGComponentTransferFunctionElement = 13031,
  SVGDefsElement = 13067,
  SVGDescElement = 13082,
  SVGElement = 13097,
  SVGEllipseElement = 13108,
  SVGFEBlendElement = 13126,
  SVGFEColorMatrixElement = 13144,
  SVGFEComponentTransferElement = 13168,
  SVGFECompositeElement = 13198,
  SVGFEConvolveMatrixElement = 13220,
  SVGFEDiffuseLightingElement = 13247,
  SVGFEDisplacementMapElement = 13275,
  SVGFEDistantLightElement = 13303,
  SVGFEDropShadowElement = 13328,
  SVGFEFloodElement = 13351,
  SVGFEFuncAElement = 13369,
  SVGFEFuncBElement = 13387,
  SVGFEFuncGElement = 13405,
  SVGFEFuncRElement = 13423,
  SVGFEGaussianBlurElement = 13441,
  SVGFEImageElement = 13466,
  SVGFEMergeElement = 13484,
  SVGFEMergeNodeElement = 13502,
  SVGFEMorphologyElement = 13524,
  SVGFEOffsetElement = 13547,
  SVGFEPointLightElement = 13566,
  SVGFESpecularLightingElement = 13589,
  SVGFESpotLightElement = 13618,
  SVGFETileElement = 13640,
  SVGFETurbulenceElement = 13657,
  SVGFilterElement = 13680,
  SVGForeignObjectElement = 13697,
  SVGGElement = 13721,
  SVGGeometryElement = 13733,
  SVGGradientElement = 13752,
  SVGGraphicsElement = 13771,
  SVGImageElement = 13790,
  SVGLength = 13806,
  SVGLengthList = 13816,
  SVGLineElement = 13830,
  SVGLinearGradientElement = 13845,
  SVGMPathElement = 13870,
  SVGMarkerElement = 13886,
  SVGMaskElement = 13903,
  SVGMatrix = 13918,
  SVGMetadataElement = 13928,
  SVGNumber = 13947,
  SVGNumberList = 13957,
  SVGPathElement = 13971,
  SVGPathSegment = 13986,
  SVGPatternElement = 14001,
  SVGPoint = 14019,
  SVGPointList = 14028,
  SVGPolygonElement = 14041,
  SVGPolylineElement = 14059,
  SVGPreserveAspectRatio = 14078,
  SVGRadialGradientElement = 14101,
  SVGRect = 14126,
  SVGRectElement = 14134,
  SVGSVGElement = 14149,
  SVGScriptElement = 14163,
  SVGSetElement = 14180,
  SVGStopElement = 14194,
  SVGStringList = 14209,
  SVGStyleElement = 14223,
  SVGSwitchElement = 14239,
  SVGSymbolElement = 14256,
  SVGTSpanElement = 14273,
  SVGTextContentElement = 14289,
  SVGTextElement = 14311,
  SVGTextPathElement = 14326,
  SVGTextPositioningElement = 14345,
  SVGTitleElement = 14371,
  SVGTransform = 14387,
  SVGTransformList = 14400,
  SVGUnitTypes = 14417,
  SVGUseElement = 14430,
  SVGViewElement = 14444,
  Sanitizer = 14459,
  Scheduler = 14469,
  Screen = 14479,
  ScreenLuminance = 14486,
  ScreenOrientation = 14502,
  ScriptProcessorNode = 14520,
  ScrollAreaEvent = 14540,
  SecurityPolicyViolationEvent = 14556,
  Selection = 14585,
  ServiceWorker = 14595,
  ServiceWorkerContainer = 14609,
  ServiceWorkerGlobalScope = 14632,
  ServiceWorkerRegistration = 14657,
  SessionStoreFormData = 14683,
  SessionStoreScrollData = 14704,
  SessionStoreUtils = 14727,
  ShadowRealmGlobalScope = 14745,
  ShadowRoot = 14768,
  SharedWorker = 14779,
  SharedWorkerGlobalScope = 14792,
  SimpleGestureEvent = 14816,
  SourceBuffer = 14835,
  SourceBufferList = 14848,
  SpeechGrammar = 14865,
  SpeechGrammarList = 14879,
  SpeechRecognition = 14897,
  SpeechRecognitionAlternative = 14915,
  SpeechRecognitionError = 14944,
  SpeechRecognitionEvent = 14967,
  SpeechRecognitionResult = 14990,
  SpeechRecognitionResultList = 15014,
  SpeechSynthesis = 15042,
  SpeechSynthesisErrorEvent = 15058,
  SpeechSynthesisEvent = 15084,
  SpeechSynthesisUtterance = 15105,
  SpeechSynthesisVoice = 15130,
  StaticRange = 15151,
  StereoPannerNode = 15163,
  Storage = 15180,
  StorageEvent = 15188,
  StorageManager = 15201,
  StreamFilter = 15216,
  StreamFilterDataEvent = 15229,
  StructuredCloneHolder = 15251,
  StructuredCloneTester = 15273,
  StylePropertyMap = 15295,
  StylePropertyMapReadOnly = 15312,
  StylePropertyMapReadOnly_Iterator = 15337,
  StyleSheet = 15371,
  StyleSheetApplicableStateChangeEvent = 15382,
  StyleSheetList = 15419,
  StyleSheetRemovedEvent = 15434,
  SubmitEvent = 15457,
  SubtleCrypto = 15469,
  SyncMessageSender = 15482,
  SyncReadFile = 15500,
  TCPServerSocket = 15513,
  TCPServerSocketEvent = 15529,
  TCPSocket = 15550,
  TCPSocketErrorEvent = 15560,
  TCPSocketEvent = 15580,
  TaskController = 15595,
  TaskPriorityChangeEvent = 15610,
  TaskSignal = 15634,
  Tensor = 15645,
  TestReportBody = 15652,
  TestReportGenerator = 15667,
  TestUtils = 15687,
  TestingDeprecatedInterface = 15697,
  Text = 15724,
  TextClause = 15729,
  TextDecoder = 15740,
  TextDecoderStream = 15752,
  TextEncoder = 15770,
  TextEncoderStream = 15782,
  TextEvent = 15800,
  TextMetrics = 15810,
  TextTrack = 15822,
  TextTrackCue = 15832,
  TextTrackCueList = 15845,
  TextTrackList = 15862,
  TimeEvent = 15876,
  TimeRanges = 15886,
  ToggleEvent = 15897,
  Touch = 15909,
  TouchEvent = 15915,
  TouchList = 15926,
  TrackEvent = 15936,
  TransformStream = 15947,
  TransformStreamDefaultController = 15963,
  TransitionEvent = 15996,
  TreeColumn = 16012,
  TreeColumns = 16023,
  TreeContentView = 16035,
  TreeWalker = 16051,
  TrustedHTML = 16062,
  TrustedScript = 16074,
  TrustedScriptURL = 16088,
  TrustedTypePolicy = 16105,
  TrustedTypePolicyFactory = 16123,
  UDPMessageEvent = 16148,
  UDPSocket = 16164,
  UIEvent = 16174,
  URL = 16182,
  URLPattern = 16186,
  URLSearchParams = 16197,
  URLSearchParams_Iterator = 16213,
  UniFFIPointer = 16238,
  UniFFIScaffolding = 16252,
  UserActivation = 16270,
  UserInteraction = 16285,
  UserProximityEvent = 16301,
  VRDisplay = 16320,
  VRDisplayCapabilities = 16330,
  VRDisplayEvent = 16352,
  VREyeParameters = 16367,
  VRFieldOfView = 16383,
  VRFrameData = 16397,
  VRMockController = 16409,
  VRMockDisplay = 16426,
  VRPose = 16440,
  VRServiceTest = 16447,
  VRStageParameters = 16461,
  VTTCue = 16479,
  VTTRegion = 16486,
  ValidityState = 16496,
  VideoColorSpace = 16510,
  VideoDecoder = 16526,
  VideoEncoder = 16539,
  VideoFrame = 16552,
  VideoPlaybackQuality = 16563,
  VideoTrack = 16584,
  VideoTrackList = 16595,
  ViewTransition = 16610,
  ViewTransitionTypeSet = 16625,
  VisualViewport = 16647,
  WEBGL_color_buffer_float = 16662,
  WEBGL_compressed_texture_astc = 16687,
  WEBGL_compressed_texture_etc = 16717,
  WEBGL_compressed_texture_etc1 = 16746,
  WEBGL_compressed_texture_pvrtc = 16776,
  WEBGL_compressed_texture_s3tc = 16807,
  WEBGL_compressed_texture_s3tc_srgb = 16837,
  WEBGL_debug_renderer_info = 16872,
  WEBGL_debug_shaders = 16898,
  WEBGL_depth_texture = 16918,
  WEBGL_draw_buffers = 16938,
  WEBGL_explicit_present = 16957,
  WEBGL_lose_context = 16980,
  WEBGL_provoking_vertex = 16999,
  WGSLLanguageFeatures = 17022,
  WakeLock = 17043,
  WakeLockSentinel = 17052,
  WaveShaperNode = 17069,
  WebExtensionContentScript = 17084,
  WebExtensionPolicy = 17110,
  WebGL2RenderingContext = 17129,
  WebGLActiveInfo = 17152,
  WebGLBuffer = 17168,
  WebGLContextEvent = 17180,
  WebGLFramebuffer = 17198,
  WebGLProgram = 17215,
  WebGLQuery = 17228,
  WebGLRenderbuffer = 17239,
  WebGLRenderingContext = 17257,
  WebGLSampler = 17279,
  WebGLShader = 17292,
  WebGLShaderPrecisionFormat = 17304,
  WebGLSync = 17331,
  WebGLTexture = 17341,
  WebGLTransformFeedback = 17354,
  WebGLUniformLocation = 17377,
  WebGLVertexArrayObject = 17398,
  WebKitCSSMatrix = 17421,
  WebSocket = 17437,
  WebTransport = 17447,
  WebTransportBidirectionalStream = 17460,
  WebTransportDatagramDuplexStream = 17492,
  WebTransportError = 17525,
  WebTransportReceiveStream = 17543,
  WebTransportSendStream = 17569,
  WebrtcGlobalInformation = 17592,
  WheelEvent = 17616,
  Window = 17627,
  WindowClient = 17634,
  WindowContext = 17647,
  WindowGlobalChild = 17661,
  WindowGlobalParent = 17679,
  WindowRoot = 17698,
  Worker = 17709,
  WorkerDebuggerGlobalScope = 17716,
  WorkerGlobalScope = 17742,
  WorkerLocation = 17760,
  WorkerNavigator = 17775,
  WorkerTestUtils = 17791,
  Worklet = 17807,
  WorkletGlobalScope = 17815,
  WritableStream = 17834,
  WritableStreamDefaultController = 17849,
  WritableStreamDefaultWriter = 17881,
  XMLDocument = 17909,
  XMLHttpRequest = 17921,
  XMLHttpRequestEventTarget = 17936,
  XMLHttpRequestUpload = 17962,
  XMLSerializer = 17983,
  XPathEvaluator = 17997,
  XPathExpression = 18012,
  XPathResult = 18028,
  XRBoundedReferenceSpace = 18040,
  XRFrame = 18064,
  XRInputSource = 18072,
  XRInputSourceArray = 18086,
  XRInputSourceEvent = 18105,
  XRInputSourcesChangeEvent = 18124,
  XRPose = 18150,
  XRReferenceSpace = 18157,
  XRReferenceSpaceEvent = 18174,
  XRRenderState = 18196,
  XRRigidTransform = 18210,
  XRSession = 18227,
  XRSessionEvent = 18237,
  XRSpace = 18252,
  XRSystem = 18260,
  XRView = 18269,
  XRViewerPose = 18276,
  XRViewport = 18289,
  XRWebGLLayer = 18300,
  XSLTProcessor = 18313,
  XULCommandEvent = 18327,
  XULElement = 18343,
  XULFrameElement = 18354,
  XULMenuElement = 18370,
  XULPopupElement = 18385,
  XULResizerElement = 18401,
  XULTextElement = 18419,
  XULTreeElement = 18434,
  console = 18449,
  webkitSpeechGrammar = 18457,
  webkitSpeechGrammarList = 18477,
  webkitSpeechRecognition = 18501,
  webkitURL = 18525,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
