/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_OUTPUT_ORDER_V1_SERVER_PROTOCOL_H
#define KDE_OUTPUT_ORDER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_output_order_v1 The kde_output_order_v1 protocol
 * @section page_ifaces_kde_output_order_v1 Interfaces
 * - @subpage page_iface_kde_output_order_v1 - announce order of outputs
 * @section page_copyright_kde_output_order_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2022 Xaver Hugl <xaver.hugl@gmail.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_output_order_v1;

#ifndef KDE_OUTPUT_ORDER_V1_INTERFACE
#define KDE_OUTPUT_ORDER_V1_INTERFACE
/**
 * @page page_iface_kde_output_order_v1 kde_output_order_v1
 * @section page_iface_kde_output_order_v1_desc Description
 *
 * Announce the order in which desktop environment components should be placed on outputs.
 * The compositor will send the list of outputs when the global is bound and whenever there is a change.
 * @section page_iface_kde_output_order_v1_api API
 * See @ref iface_kde_output_order_v1.
 */
/**
 * @defgroup iface_kde_output_order_v1 The kde_output_order_v1 interface
 *
 * Announce the order in which desktop environment components should be placed on outputs.
 * The compositor will send the list of outputs when the global is bound and whenever there is a change.
 */
extern const struct wl_interface kde_output_order_v1_interface;
#endif

/**
 * @ingroup iface_kde_output_order_v1
 * @struct kde_output_order_v1_interface
 */
struct kde_output_order_v1_interface {
	/**
	 * Destroy the output order notifier.
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define KDE_OUTPUT_ORDER_V1_OUTPUT 0
#define KDE_OUTPUT_ORDER_V1_DONE 1

/**
 * @ingroup iface_kde_output_order_v1
 */
#define KDE_OUTPUT_ORDER_V1_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_order_v1
 */
#define KDE_OUTPUT_ORDER_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_kde_output_order_v1
 */
#define KDE_OUTPUT_ORDER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_kde_output_order_v1
 * Sends an output event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output_name the name of the output
 */
static inline void
kde_output_order_v1_send_output(struct wl_resource *resource_, const char *output_name)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_ORDER_V1_OUTPUT, output_name);
}

/**
 * @ingroup iface_kde_output_order_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_order_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_ORDER_V1_DONE);
}

#ifdef  __cplusplus
}
#endif

#endif
