/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#include "src/io/timestamp_db_tables.h"

namespace DbInfoTbl {
	static const QString tabName("_db_info");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"entry_name", DB_TEXT}, /* NOT_NULL */
	{"entry_json", DB_TEXT}
	/*
	 * PRIMARY KEY (id),
	 * UNIQUE (entry_name)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"entry_name", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT uq_entry_name UNIQUE (entry_name)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"entry_name", {DB_TEXT, ""}},
	{"entry_json", {DB_TEXT, ""}}
	};
} /* namespace DbInfoTbl */
SQLiteTbl TimestampDbTables::_dbInfoTbl(DbInfoTbl::tabName,
    DbInfoTbl::knownAttrs, DbInfoTbl::attrProps, DbInfoTbl::colConstraints,
    DbInfoTbl::tblConstraint);

namespace IdentificationTbl {
	static const QString tabName("identification");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"test_env", DB_INTEGER}, /* NOT NULL */
	{"message_id", DB_INTEGER}, /* NOT NULL */
	{"dm_delivery_time", DB_DATETIME} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * UNIQUE (test_env, message_id),
	 * CHECK (test_env IN (0, 1))
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"test_env", "NOT NULL"},
	    {"message_id", "NOT NULL"},
	    {"dm_delivery_time", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT uq_test_env_message_id UNIQUE (test_env, message_id),\n"
	    "        CONSTRAINT ck_test_env CHECK (test_env IN (0, 1))"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"test_env", {DB_INTEGER, ""}},
	{"message_id", {DB_INTEGER, ""}},
	{"dm_delivery_time", {DB_DATETIME, ""}}
	};

} /* namespace IdentificationTbl */
SQLiteTbl TimestampDbTables::identificationTbl(IdentificationTbl::tabName,
    IdentificationTbl::knownAttrs, IdentificationTbl::attrProps,
    IdentificationTbl::colConstraints, IdentificationTbl::tblConstraint);

namespace AccountTbl {
	static const QString tabName("accounts");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"test_env", DB_INTEGER}, /* NOT NULL */
	{"username", DB_TEXT} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * UNIQUE (test_env, username),
	 * CHECK (test_env IN (0, 1))
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"test_env", "NOT NULL"},
	    {"username", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT uq_test_env_username UNIQUE (test_env, username),\n"
	    "        CONSTRAINT ck_test_env CHECK (test_env IN (0, 1))"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"test_env", {DB_INTEGER, ""}},
	{"username", {DB_TEXT, ""}}
	};
} /* namespace AccountTbl */
SQLiteTbl TimestampDbTables::accountTbl(AccountTbl::tabName,
    AccountTbl::knownAttrs, AccountTbl::attrProps,
    AccountTbl::colConstraints, AccountTbl::tblConstraint);

namespace IdentifAccountAffinityTbl {
	static const QString tabName("identification_account_affinity");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"identif_ref_id", DB_INTEGER}, /* NOT NULL */
	{"account_ref_id", DB_INTEGER} /* NOT NULL */
	/*
	 * FOREIGN KEY(identif_ref_id) REFERENCES identification ("id"),
	 * FOREIGN KEY(account_ref_id) REFERENCES accounts ("id"),
	 * UNIQUE (identif_ref_id, account_ref_id)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"identif_ref_id", "NOT NULL"},
	    {"account_ref_id", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT fk_identif_ref_id FOREIGN KEY (identif_ref_id) REFERENCES identification (id) ON DELETE CASCADE,\n"
	    "        CONSTRAINT fk_account_ref_id FOREIGN KEY (account_ref_id) REFERENCES accounts (id) ON DELETE CASCADE,\n"
	    "        CONSTRAINT uq_identif_ref_id_account_ref_id UNIQUE (identif_ref_id, account_ref_id)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"identif_ref_id", {DB_INTEGER, ""}},
	{"account_ref_id", {DB_INTEGER, ""}}
	};
}; /* namespace IdentifAccountAffinityTbl */
SQLiteTbl TimestampDbTables::identifAccountAffinityTbl(IdentifAccountAffinityTbl::tabName,
    IdentifAccountAffinityTbl::knownAttrs, IdentifAccountAffinityTbl::attrProps,
    IdentifAccountAffinityTbl::colConstraints, IdentifAccountAffinityTbl::tblConstraint);

namespace MessagesTbl {
	static const QString tabName("messages");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"identif_id", DB_INTEGER}, /* NOT NULL */
	{"tst_valid_to", DB_DATETIME} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * FOREIGN KEY(identif_id) REFERENCES identification ("id"),
	 * UNIQUE (identif_id)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"identif_id", "NOT NULL"},
	    {"tst_valid_to", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT fk_identif_id FOREIGN KEY (identif_id) REFERENCES identification (id) ON DELETE CASCADE,\n"
	    "        CONSTRAINT uq_identif_id UNIQUE (identif_id)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"identif_id", {DB_INTEGER, ""}},
	{"tst_valid_to", {DB_DATETIME, ""}}
	};
} /* namespace MessagesTbl */
SQLiteTbl TimestampDbTables::messagesTbl(MessagesTbl::tabName,
    MessagesTbl::knownAttrs, MessagesTbl::attrProps,
    MessagesTbl::colConstraints, MessagesTbl::tblConstraint);

namespace SupMessagesTbl {
	static const QString tabName("supplementary_message_data");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"ref_id", DB_INTEGER}, /* NOT NULL */
	{"custom_data", DB_TEXT} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * FOREIGN KEY(ref_id) REFERENCES messages ("id"),
	 * UNIQUE (ref_id)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"ref_id", "NOT NULL"},
	    {"custom_data", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT fk_identif_id FOREIGN KEY (ref_id) REFERENCES messages (id) ON DELETE CASCADE,\n"
	    "        CONSTRAINT uq_identif_id UNIQUE (ref_id)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"ref_id", {DB_INTEGER, ""}},
	{"custom_data", {DB_TEXT, ""}}
	};
} /* namespace SupMessagesTbl */
SQLiteTbl TimestampDbTables::supMsgDataTbl(SupMessagesTbl::tabName,
    SupMessagesTbl::knownAttrs, SupMessagesTbl::attrProps,
    SupMessagesTbl::colConstraints, SupMessagesTbl::tblConstraint);

namespace DelInfosTbl {
	static const QString tabName("delivery_infos");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"identif_id", DB_INTEGER}, /* NOT NULL */
	{"tst_valid_to", DB_DATETIME} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * FOREIGN KEY(identif_id) REFERENCES identification ("id"),
	 * UNIQUE (identif_id)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"identif_id", "NOT NULL"},
	    {"tst_valid_to", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT fk_identif_id FOREIGN KEY (identif_id) REFERENCES identification (id) ON DELETE CASCADE,\n"
	    "        CONSTRAINT uq_identif_id UNIQUE (identif_id)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"identif_id", {DB_INTEGER, ""}},
	{"tst_valid_to", {DB_DATETIME, ""}}
	};
} /* namespace DelInfosTbl */
SQLiteTbl TimestampDbTables::delInfosTbl(DelInfosTbl::tabName,
    DelInfosTbl::knownAttrs, DelInfosTbl::attrProps,
    DelInfosTbl::colConstraints, DelInfosTbl::tblConstraint);

namespace SupDelInfosTbl {
	static const QString tabName("supplementary_delivery_info_data");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"ref_id", DB_INTEGER}, /* NOT NULL */
	{"custom_data", DB_TEXT} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * FOREIGN KEY(ref_id) REFERENCES delivery_infos ("id"),
	 * UNIQUE (ref_id)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"ref_id", "NOT NULL"},
	    {"custom_data", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT fk_identif_id FOREIGN KEY (ref_id) REFERENCES delivery_infos (id) ON DELETE CASCADE,\n"
	    "        CONSTRAINT uq_identif_id UNIQUE (ref_id)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"ref_id", {DB_INTEGER, ""}},
	{"custom_data", {DB_TEXT, ""}}
	};
} /* namespace SupDelInfosTbl */
SQLiteTbl TimestampDbTables::supDelInfoDataTbl(SupDelInfosTbl::tabName,
    SupDelInfosTbl::knownAttrs, SupDelInfosTbl::attrProps,
    SupDelInfosTbl::colConstraints, SupDelInfosTbl::tblConstraint);
