// Code generated by op-codegen - DO NOT EDIT

package onepassword

import (
	"context"
	"encoding/json"

	"github.com/1password/onepassword-sdk-go/internal"
)

type ItemsFilesAPI interface {
	// Attach files to Items
	Attach(ctx context.Context, item Item, fileParams FileCreateParams) (Item, error)

	// Read file content from the Item
	Read(ctx context.Context, vaultID string, itemID string, attr FileAttributes) ([]byte, error)

	// Delete a field file from Item using the section and field IDs
	Delete(ctx context.Context, item Item, sectionID string, fieldID string) (Item, error)

	// Replace the document file within a document item
	ReplaceDocument(ctx context.Context, item Item, docParams DocumentCreateParams) (Item, error)
}

type ItemsFilesSource struct {
	internal.InnerClient
}

func NewItemsFilesSource(inner internal.InnerClient) ItemsFilesAPI {
	return &ItemsFilesSource{InnerClient: inner}
}

// Attach files to Items
func (i ItemsFilesSource) Attach(ctx context.Context, item Item, fileParams FileCreateParams) (Item, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsFilesAttach", map[string]interface{}{
		"item":        item,
		"file_params": fileParams,
	})
	if err != nil {
		return Item{}, err
	}
	var result Item
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return Item{}, err
	}
	return result, nil
}

// Read file content from the Item
func (i ItemsFilesSource) Read(ctx context.Context, vaultID string, itemID string, attr FileAttributes) ([]byte, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsFilesRead", map[string]interface{}{
		"vault_id": vaultID,
		"item_id":  itemID,
		"attr":     attr,
	})
	if err != nil {
		return nil, err
	}
	var result []byte
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return nil, err
	}
	return result, nil
}

// Delete a field file from Item using the section and field IDs
func (i ItemsFilesSource) Delete(ctx context.Context, item Item, sectionID string, fieldID string) (Item, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsFilesDelete", map[string]interface{}{
		"item":       item,
		"section_id": sectionID,
		"field_id":   fieldID,
	})
	if err != nil {
		return Item{}, err
	}
	var result Item
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return Item{}, err
	}
	return result, nil
}

// Replace the document file within a document item
func (i ItemsFilesSource) ReplaceDocument(ctx context.Context, item Item, docParams DocumentCreateParams) (Item, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsFilesReplaceDocument", map[string]interface{}{
		"item":       item,
		"doc_params": docParams,
	})
	if err != nil {
		return Item{}, err
	}
	var result Item
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return Item{}, err
	}
	return result, nil
}
