#ifndef HEADER_CURL_IMPERSONATE_H
#define HEADER_CURL_IMPERSONATE_H

#define IMPERSONATE_MAX_HEADERS 32

/*
 * curl-impersonate: Options to be set for each supported target browser.
 */
struct impersonate_opts {
  const char *target;
  const char *alias;
  int httpversion;
  int ssl_version;
  const char *ciphers;
  /* Elliptic curves (TLS extension 10).
   * Passed to CURLOPT_SSL_EC_CURVES */
  const char *curves;
  /* Signature hash algorithms (TLS extension 13).
   * Passed to CURLOPT_SSL_SIG_HASH_ALGS */
  const char *sig_hash_algs;
  /* Enable TLS NPN extension. */
  bool npn;
  /* Enable TLS ALPN extension. */
  bool alpn;
  /* Enable TLS ALPS extension. */
  bool alps;
  /* Enable TLS session ticket extension. */
  bool tls_session_ticket;
  /* TLS certificate compression algorithms.
   * (TLS extension 27) */
  const char *cert_compression;
  const char *http_headers[IMPERSONATE_MAX_HEADERS];
  const char *http2_pseudo_headers_order;
  const char *http2_settings;
  int http2_window_update;
  const char *http2_streams;
  const char *http3_pseudo_headers_order;
  const char *http3_settings;
  const char *quic_transport_parameters;
  bool tls_permute_extensions;
  bool tls_use_new_alps_codepoint;
  bool tls_signed_cert_timestamps;
  const char *ech;
  const char *tls_extension_order;
  const char *http3_tls_extension_order;
  const char *tls_delegated_credentials;
  int tls_record_size_limit;
  int tls_key_shares_limit;  // for firefox key_shares extension
  bool tls_grease;
  int http2_stream_weight;
  int http2_stream_exclusive;
  bool http2_no_priority;  // disable http2 priority in header frame
  bool proxy_credential_no_reuse;  // do not reuse TLS sessions or connections from different proxy credentials
  bool split_cookies;  // split cookies into one Cookie header per pair
  const char *form_boundary;

  /* Other TLS options will come here in the future once they are
   * configurable through curl_easy_setopt() */
};

/*
 * curl-impersonate: Global array of supported browsers and their
 * impersonation options.
 */
extern const struct impersonate_opts impersonations[];
extern const size_t num_impersonations;

#endif /* HEADER_CURL_IMPERSONATE_H */
