/* Translations.c generated by valac 0.56.17, the Vala compiler
 * generated from Translations.vala, do not modify */

/*
 * Copyright (C) 2011-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_TRANSLATIONS (contractor_translations_get_type ())
#define CONTRACTOR_TRANSLATIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_TRANSLATIONS, ContractorTranslations))
#define CONTRACTOR_TRANSLATIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_TRANSLATIONS, ContractorTranslationsClass))
#define CONTRACTOR_IS_TRANSLATIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_TRANSLATIONS))
#define CONTRACTOR_IS_TRANSLATIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_TRANSLATIONS))
#define CONTRACTOR_TRANSLATIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_TRANSLATIONS, ContractorTranslationsClass))

typedef struct _ContractorTranslations ContractorTranslations;
typedef struct _ContractorTranslationsClass ContractorTranslationsClass;
typedef struct _ContractorTranslationsPrivate ContractorTranslationsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ContractorParamSpecTranslations ContractorParamSpecTranslations;

struct _ContractorTranslations {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContractorTranslationsPrivate * priv;
};

struct _ContractorTranslationsClass {
	GTypeClass parent_class;
	void (*finalize) (ContractorTranslations *self);
};

struct _ContractorParamSpecTranslations {
	GParamSpec parent_instance;
};

static gpointer contractor_translations_parent_class = NULL;
static GeeHashSet* contractor_translations_domains;
static GeeHashSet* contractor_translations_domains = NULL;

VALA_EXTERN gpointer contractor_translations_ref (gpointer instance);
VALA_EXTERN void contractor_translations_unref (gpointer instance);
VALA_EXTERN GParamSpec* contractor_param_spec_translations (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void contractor_value_set_translations (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void contractor_value_take_translations (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer contractor_value_get_translations (const GValue* value);
VALA_EXTERN GType contractor_translations_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorTranslations, contractor_translations_unref)
VALA_EXTERN void contractor_translations_init (void);
VALA_EXTERN gchar* contractor_translations_get_string (const gchar* domain,
                                           const gchar* to_translate);
static void contractor_translations_add_domain (const gchar* domain);
VALA_EXTERN ContractorTranslations* contractor_translations_new (void);
VALA_EXTERN ContractorTranslations* contractor_translations_construct (GType object_type);
static void contractor_translations_finalize (ContractorTranslations * obj);
static GType contractor_translations_get_type_once (void);

void
contractor_translations_init (void)
{
	GeeHashSet* _tmp0_;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (contractor_translations_domains);
	contractor_translations_domains = _tmp0_;
	setlocale (LC_ALL, "");
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
contractor_translations_get_string (const gchar* domain,
                                    const gchar* to_translate)
{
	gchar* translated = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (to_translate != NULL, NULL);
	contractor_translations_add_domain (domain);
	_tmp0_ = g_strdup (g_dgettext (domain, to_translate));
	translated = _tmp0_;
	_tmp1_ = string_replace (translated, "_", "");
	result = _tmp1_;
	_g_free0 (translated);
	return result;
}

static void
contractor_translations_add_domain (const gchar* domain)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (domain != NULL);
	_tmp0_ = contractor_translations_domains;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, domain)) {
		return;
	}
	_tmp1_ = contractor_translations_domains;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, domain);
	textdomain (domain);
}

ContractorTranslations*
contractor_translations_construct (GType object_type)
{
	ContractorTranslations* self = NULL;
	self = (ContractorTranslations*) g_type_create_instance (object_type);
	return self;
}

ContractorTranslations*
contractor_translations_new (void)
{
	return contractor_translations_construct (CONTRACTOR_TYPE_TRANSLATIONS);
}

static void
contractor_value_translations_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
contractor_value_translations_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		contractor_translations_unref (value->data[0].v_pointer);
	}
}

static void
contractor_value_translations_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contractor_translations_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
contractor_value_translations_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
contractor_value_translations_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ContractorTranslations * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contractor_translations_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
contractor_value_translations_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	ContractorTranslations ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contractor_translations_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
contractor_param_spec_translations (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ContractorParamSpecTranslations* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTRACTOR_TYPE_TRANSLATIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
contractor_value_get_translations (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTRACTOR_TYPE_TRANSLATIONS), NULL);
	return value->data[0].v_pointer;
}

void
contractor_value_set_translations (GValue* value,
                                   gpointer v_object)
{
	ContractorTranslations * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTRACTOR_TYPE_TRANSLATIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTRACTOR_TYPE_TRANSLATIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contractor_translations_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contractor_translations_unref (old);
	}
}

void
contractor_value_take_translations (GValue* value,
                                    gpointer v_object)
{
	ContractorTranslations * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTRACTOR_TYPE_TRANSLATIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTRACTOR_TYPE_TRANSLATIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contractor_translations_unref (old);
	}
}

static void
contractor_translations_class_init (ContractorTranslationsClass * klass,
                                    gpointer klass_data)
{
	contractor_translations_parent_class = g_type_class_peek_parent (klass);
	((ContractorTranslationsClass *) klass)->finalize = contractor_translations_finalize;
}

static void
contractor_translations_instance_init (ContractorTranslations * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
contractor_translations_finalize (ContractorTranslations * obj)
{
	ContractorTranslations * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_TRANSLATIONS, ContractorTranslations);
	g_signal_handlers_destroy (self);
}

static GType
contractor_translations_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { contractor_value_translations_init, contractor_value_translations_free_value, contractor_value_translations_copy_value, contractor_value_translations_peek_pointer, "p", contractor_value_translations_collect_value, "p", contractor_value_translations_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ContractorTranslationsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_translations_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorTranslations), 0, (GInstanceInitFunc) contractor_translations_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType contractor_translations_type_id;
	contractor_translations_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContractorTranslations", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return contractor_translations_type_id;
}

GType
contractor_translations_get_type (void)
{
	static volatile gsize contractor_translations_type_id__once = 0;
	if (g_once_init_enter (&contractor_translations_type_id__once)) {
		GType contractor_translations_type_id;
		contractor_translations_type_id = contractor_translations_get_type_once ();
		g_once_init_leave (&contractor_translations_type_id__once, contractor_translations_type_id);
	}
	return contractor_translations_type_id__once;
}

gpointer
contractor_translations_ref (gpointer instance)
{
	ContractorTranslations * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
contractor_translations_unref (gpointer instance)
{
	ContractorTranslations * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTRACTOR_TRANSLATIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

