// Generated by mpgen from /build/bitcoin/src/bitcoin-30.2/src/ipc/capnp/mining.capnp

#ifndef CAPNP_MINING_CAPNP_PROXY_H
#define CAPNP_MINING_CAPNP_PROXY_H

#include <src/ipc/capnp/mining.capnp.h> // IWYU pragma: keep
#include "interfaces/mining.h" // IWYU pragma: export
#include <mp/proxy.h>

#if defined(__GNUC__)
#pragma GCC diagnostic push
#if !defined(__has_warning)
#pragma GCC diagnostic ignored "-Wsuggest-override"
#elif __has_warning("-Wsuggest-override")
#pragma GCC diagnostic ignored "-Wsuggest-override"
#endif
#endif
namespace mp {
template<>
struct ProxyMethod<ipc::capnp::messages::Mining::IsTestChainParams>
{
    static constexpr auto impl = &interfaces::Mining::isTestChain;
};

template<>
struct ProxyMethod<ipc::capnp::messages::Mining::IsInitialBlockDownloadParams>
{
    static constexpr auto impl = &interfaces::Mining::isInitialBlockDownload;
};

template<>
struct ProxyMethod<ipc::capnp::messages::Mining::GetTipParams>
{
    static constexpr auto impl = &interfaces::Mining::getTip;
};

template<>
struct ProxyMethod<ipc::capnp::messages::Mining::WaitTipChangedParams>
{
    static constexpr auto impl = &interfaces::Mining::waitTipChanged;
};

template<>
struct ProxyMethod<ipc::capnp::messages::Mining::CreateNewBlockParams>
{
    static constexpr auto impl = &interfaces::Mining::createNewBlock;
};

template<>
struct ProxyMethod<ipc::capnp::messages::Mining::CheckBlockParams>
{
    static constexpr auto impl = &interfaces::Mining::checkBlock;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetBlockHeaderParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getBlockHeader;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetBlockParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getBlock;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetTxFeesParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getTxFees;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetTxSigopsParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getTxSigops;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetCoinbaseTxParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getCoinbaseTx;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetCoinbaseCommitmentParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getCoinbaseCommitment;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetWitnessCommitmentIndexParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getWitnessCommitmentIndex;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::GetCoinbaseMerklePathParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::getCoinbaseMerklePath;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::SubmitSolutionParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::submitSolution;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::WaitNextParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::waitNext;
};

template<>
struct ProxyMethod<ipc::capnp::messages::BlockTemplate::InterruptWaitParams>
{
    static constexpr auto impl = &interfaces::BlockTemplate::interruptWait;
};

namespace mining_fields {
struct Context
{
    template<typename S> static auto get(S&& s) -> decltype(s.getContext()) { return s.getContext(); }
    template<typename S> static bool has(S&& s) { return s.hasContext(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setContext(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initContext(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantContext(); }
    template<typename S> static void setWant(S&& s) { s.setWantContext(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasContext(); }
    template<typename S> static void setHas(S&& s) { s.setHasContext(true); }
};
struct Result
{
    template<typename S> static auto get(S&& s) -> decltype(s.getResult()) { return s.getResult(); }
    template<typename S> static bool has(S&& s) { return s.hasResult(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setResult(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initResult(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantResult(); }
    template<typename S> static void setWant(S&& s) { s.setWantResult(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasResult(); }
    template<typename S> static void setHas(S&& s) { s.setHasResult(true); }
};
struct CurrentTip
{
    template<typename S> static auto get(S&& s) -> decltype(s.getCurrentTip()) { return s.getCurrentTip(); }
    template<typename S> static bool has(S&& s) { return s.hasCurrentTip(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setCurrentTip(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initCurrentTip(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantCurrentTip(); }
    template<typename S> static void setWant(S&& s) { s.setWantCurrentTip(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasCurrentTip(); }
    template<typename S> static void setHas(S&& s) { s.setHasCurrentTip(true); }
};
struct Timeout
{
    template<typename S> static auto get(S&& s) -> decltype(s.getTimeout()) { return s.getTimeout(); }
    template<typename S> static bool has(S&& s) { return s.hasTimeout(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setTimeout(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initTimeout(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantTimeout(); }
    template<typename S> static void setWant(S&& s) { s.setWantTimeout(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasTimeout(); }
    template<typename S> static void setHas(S&& s) { s.setHasTimeout(true); }
};
struct Options
{
    template<typename S> static auto get(S&& s) -> decltype(s.getOptions()) { return s.getOptions(); }
    template<typename S> static bool has(S&& s) { return s.hasOptions(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setOptions(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initOptions(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantOptions(); }
    template<typename S> static void setWant(S&& s) { s.setWantOptions(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasOptions(); }
    template<typename S> static void setHas(S&& s) { s.setHasOptions(true); }
};
struct Block
{
    template<typename S> static auto get(S&& s) -> decltype(s.getBlock()) { return s.getBlock(); }
    template<typename S> static bool has(S&& s) { return s.hasBlock(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setBlock(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initBlock(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantBlock(); }
    template<typename S> static void setWant(S&& s) { s.setWantBlock(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasBlock(); }
    template<typename S> static void setHas(S&& s) { s.setHasBlock(true); }
};
struct Reason
{
    template<typename S> static auto get(S&& s) -> decltype(s.getReason()) { return s.getReason(); }
    template<typename S> static bool has(S&& s) { return s.hasReason(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setReason(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initReason(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantReason(); }
    template<typename S> static void setWant(S&& s) { s.setWantReason(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasReason(); }
    template<typename S> static void setHas(S&& s) { s.setHasReason(true); }
};
struct Debug
{
    template<typename S> static auto get(S&& s) -> decltype(s.getDebug()) { return s.getDebug(); }
    template<typename S> static bool has(S&& s) { return s.hasDebug(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setDebug(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initDebug(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantDebug(); }
    template<typename S> static void setWant(S&& s) { s.setWantDebug(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasDebug(); }
    template<typename S> static void setHas(S&& s) { s.setHasDebug(true); }
};
struct Version
{
    template<typename S> static auto get(S&& s) -> decltype(s.getVersion()) { return s.getVersion(); }
    template<typename S> static bool has(S&& s) { return s.hasVersion(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setVersion(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initVersion(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantVersion(); }
    template<typename S> static void setWant(S&& s) { s.setWantVersion(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasVersion(); }
    template<typename S> static void setHas(S&& s) { s.setHasVersion(true); }
};
struct Timestamp
{
    template<typename S> static auto get(S&& s) -> decltype(s.getTimestamp()) { return s.getTimestamp(); }
    template<typename S> static bool has(S&& s) { return s.hasTimestamp(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setTimestamp(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initTimestamp(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantTimestamp(); }
    template<typename S> static void setWant(S&& s) { s.setWantTimestamp(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasTimestamp(); }
    template<typename S> static void setHas(S&& s) { s.setHasTimestamp(true); }
};
struct Nonce
{
    template<typename S> static auto get(S&& s) -> decltype(s.getNonce()) { return s.getNonce(); }
    template<typename S> static bool has(S&& s) { return s.hasNonce(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setNonce(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initNonce(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantNonce(); }
    template<typename S> static void setWant(S&& s) { s.setWantNonce(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasNonce(); }
    template<typename S> static void setHas(S&& s) { s.setHasNonce(true); }
};
struct Coinbase
{
    template<typename S> static auto get(S&& s) -> decltype(s.getCoinbase()) { return s.getCoinbase(); }
    template<typename S> static bool has(S&& s) { return s.hasCoinbase(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setCoinbase(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initCoinbase(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantCoinbase(); }
    template<typename S> static void setWant(S&& s) { s.setWantCoinbase(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasCoinbase(); }
    template<typename S> static void setHas(S&& s) { s.setHasCoinbase(true); }
};
struct UseMempool
{
    template<typename S> static auto get(S&& s) -> decltype(s.getUseMempool()) { return s.getUseMempool(); }
    template<typename S> static bool has(S&& s) { return s.hasUseMempool(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setUseMempool(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initUseMempool(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantUseMempool(); }
    template<typename S> static void setWant(S&& s) { s.setWantUseMempool(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasUseMempool(); }
    template<typename S> static void setHas(S&& s) { s.setHasUseMempool(true); }
};
struct BlockReservedWeight
{
    template<typename S> static auto get(S&& s) -> decltype(s.getBlockReservedWeight()) { return s.getBlockReservedWeight(); }
    template<typename S> static bool has(S&& s) { return s.hasBlockReservedWeight(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setBlockReservedWeight(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initBlockReservedWeight(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantBlockReservedWeight(); }
    template<typename S> static void setWant(S&& s) { s.setWantBlockReservedWeight(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasBlockReservedWeight(); }
    template<typename S> static void setHas(S&& s) { s.setHasBlockReservedWeight(true); }
};
struct CoinbaseOutputMaxAdditionalSigops
{
    template<typename S> static auto get(S&& s) -> decltype(s.getCoinbaseOutputMaxAdditionalSigops()) { return s.getCoinbaseOutputMaxAdditionalSigops(); }
    template<typename S> static bool has(S&& s) { return s.hasCoinbaseOutputMaxAdditionalSigops(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setCoinbaseOutputMaxAdditionalSigops(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initCoinbaseOutputMaxAdditionalSigops(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantCoinbaseOutputMaxAdditionalSigops(); }
    template<typename S> static void setWant(S&& s) { s.setWantCoinbaseOutputMaxAdditionalSigops(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasCoinbaseOutputMaxAdditionalSigops(); }
    template<typename S> static void setHas(S&& s) { s.setHasCoinbaseOutputMaxAdditionalSigops(true); }
};
struct FeeThreshold
{
    template<typename S> static auto get(S&& s) -> decltype(s.getFeeThreshold()) { return s.getFeeThreshold(); }
    template<typename S> static bool has(S&& s) { return s.hasFeeThreshold(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setFeeThreshold(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initFeeThreshold(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantFeeThreshold(); }
    template<typename S> static void setWant(S&& s) { s.setWantFeeThreshold(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasFeeThreshold(); }
    template<typename S> static void setHas(S&& s) { s.setHasFeeThreshold(true); }
};
struct CheckMerkleRoot
{
    template<typename S> static auto get(S&& s) -> decltype(s.getCheckMerkleRoot()) { return s.getCheckMerkleRoot(); }
    template<typename S> static bool has(S&& s) { return s.hasCheckMerkleRoot(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setCheckMerkleRoot(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initCheckMerkleRoot(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantCheckMerkleRoot(); }
    template<typename S> static void setWant(S&& s) { s.setWantCheckMerkleRoot(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasCheckMerkleRoot(); }
    template<typename S> static void setHas(S&& s) { s.setHasCheckMerkleRoot(true); }
};
struct CheckPow
{
    template<typename S> static auto get(S&& s) -> decltype(s.getCheckPow()) { return s.getCheckPow(); }
    template<typename S> static bool has(S&& s) { return s.hasCheckPow(); }
    template<typename S, typename A> static void set(S&& s, A&& a) { s.setCheckPow(std::forward<A>(a)); }
    template<typename S, typename... A> static decltype(auto) init(S&& s, A&&... a) { return s.initCheckPow(std::forward<A>(a)...); }
    template<typename S> static bool getWant(S&& s) { return s.getWantCheckPow(); }
    template<typename S> static void setWant(S&& s) { s.setWantCheckPow(true); }
    template<typename S> static bool getHas(S&& s) { return s.getHasCheckPow(); }
    template<typename S> static void setHas(S&& s) { s.setHasCheckPow(true); }
};
} // namespace mining_fields

template<>
struct ProxyClient<ipc::capnp::messages::Mining> final : public ProxyClientCustom<ipc::capnp::messages::Mining, interfaces::Mining>
{
public:
    using ProxyClientCustom::ProxyClientCustom;
    ~ProxyClient();
    using M0 = ProxyClientMethodTraits<ipc::capnp::messages::Mining::IsTestChainParams>;
    typename M0::Result isTestChain();
    using M1 = ProxyClientMethodTraits<ipc::capnp::messages::Mining::IsInitialBlockDownloadParams>;
    typename M1::Result isInitialBlockDownload();
    using M2 = ProxyClientMethodTraits<ipc::capnp::messages::Mining::GetTipParams>;
    typename M2::Result getTip();
    using M3 = ProxyClientMethodTraits<ipc::capnp::messages::Mining::WaitTipChangedParams>;
    typename M3::Result waitTipChanged(M3::Param<0> currentTip,M3::Param<1> timeout);
    using M4 = ProxyClientMethodTraits<ipc::capnp::messages::Mining::CreateNewBlockParams>;
    typename M4::Result createNewBlock(M4::Param<0> options);
    using M5 = ProxyClientMethodTraits<ipc::capnp::messages::Mining::CheckBlockParams>;
    typename M5::Result checkBlock(M5::Param<0> block,M5::Param<1> options,M5::Param<2> reason,M5::Param<3> debug);
};

template<>
struct ProxyServer<ipc::capnp::messages::Mining> : public ProxyServerCustom<ipc::capnp::messages::Mining, interfaces::Mining>
{
public:
    using ProxyServerCustom::ProxyServerCustom;
    ~ProxyServer();
    kj::Promise<void> isTestChain(IsTestChainContext call_context) override;
    kj::Promise<void> isInitialBlockDownload(IsInitialBlockDownloadContext call_context) override;
    kj::Promise<void> getTip(GetTipContext call_context) override;
    kj::Promise<void> waitTipChanged(WaitTipChangedContext call_context) override;
    kj::Promise<void> createNewBlock(CreateNewBlockContext call_context) override;
    kj::Promise<void> checkBlock(CheckBlockContext call_context) override;
};

template<>
struct ProxyType<interfaces::Mining>
{
    using Type = interfaces::Mining;
    using Message = ipc::capnp::messages::Mining;
    using Client = ProxyClient<Message>;
    using Server = ProxyServer<Message>;
};

template<>
struct ProxyClient<ipc::capnp::messages::BlockTemplate> final : public ProxyClientCustom<ipc::capnp::messages::BlockTemplate, interfaces::BlockTemplate>
{
public:
    using ProxyClientCustom::ProxyClientCustom;
    ~ProxyClient();
    using M0 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::DestroyParams>;
    static typename M0::Result destroy(Super& super);
    using M1 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetBlockHeaderParams>;
    typename M1::Result getBlockHeader();
    using M2 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetBlockParams>;
    typename M2::Result getBlock();
    using M3 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetTxFeesParams>;
    typename M3::Result getTxFees();
    using M4 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetTxSigopsParams>;
    typename M4::Result getTxSigops();
    using M5 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetCoinbaseTxParams>;
    typename M5::Result getCoinbaseTx();
    using M6 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetCoinbaseCommitmentParams>;
    typename M6::Result getCoinbaseCommitment();
    using M7 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetWitnessCommitmentIndexParams>;
    typename M7::Result getWitnessCommitmentIndex();
    using M8 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::GetCoinbaseMerklePathParams>;
    typename M8::Result getCoinbaseMerklePath();
    using M9 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::SubmitSolutionParams>;
    typename M9::Result submitSolution(M9::Param<0> version,M9::Param<1> timestamp,M9::Param<2> nonce,M9::Param<3> coinbase);
    using M10 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::WaitNextParams>;
    typename M10::Result waitNext(M10::Param<0> options);
    using M11 = ProxyClientMethodTraits<ipc::capnp::messages::BlockTemplate::InterruptWaitParams>;
    typename M11::Result interruptWait();
};

template<>
struct ProxyServer<ipc::capnp::messages::BlockTemplate> : public ProxyServerCustom<ipc::capnp::messages::BlockTemplate, interfaces::BlockTemplate>
{
public:
    using ProxyServerCustom::ProxyServerCustom;
    ~ProxyServer();
    kj::Promise<void> destroy(DestroyContext call_context) override;
    kj::Promise<void> getBlockHeader(GetBlockHeaderContext call_context) override;
    kj::Promise<void> getBlock(GetBlockContext call_context) override;
    kj::Promise<void> getTxFees(GetTxFeesContext call_context) override;
    kj::Promise<void> getTxSigops(GetTxSigopsContext call_context) override;
    kj::Promise<void> getCoinbaseTx(GetCoinbaseTxContext call_context) override;
    kj::Promise<void> getCoinbaseCommitment(GetCoinbaseCommitmentContext call_context) override;
    kj::Promise<void> getWitnessCommitmentIndex(GetWitnessCommitmentIndexContext call_context) override;
    kj::Promise<void> getCoinbaseMerklePath(GetCoinbaseMerklePathContext call_context) override;
    kj::Promise<void> submitSolution(SubmitSolutionContext call_context) override;
    kj::Promise<void> waitNext(WaitNextContext call_context) override;
    kj::Promise<void> interruptWait(InterruptWaitContext call_context) override;
};

template<>
struct ProxyType<interfaces::BlockTemplate>
{
    using Type = interfaces::BlockTemplate;
    using Message = ipc::capnp::messages::BlockTemplate;
    using Client = ProxyClient<Message>;
    using Server = ProxyServer<Message>;
};
template<>
struct ProxyStruct<ipc::capnp::messages::BlockCreateOptions>
{
    using Struct = ipc::capnp::messages::BlockCreateOptions;
    using UseMempoolAccessor = Accessor<mining_fields::UseMempool, FIELD_IN | FIELD_OUT>;
    using BlockReservedWeightAccessor = Accessor<mining_fields::BlockReservedWeight, FIELD_IN | FIELD_OUT>;
    using CoinbaseOutputMaxAdditionalSigopsAccessor = Accessor<mining_fields::CoinbaseOutputMaxAdditionalSigops, FIELD_IN | FIELD_OUT>;
    using Accessors = std::tuple<UseMempoolAccessor, BlockReservedWeightAccessor, CoinbaseOutputMaxAdditionalSigopsAccessor>;
    static constexpr size_t fields = 3;
};
template<>
struct ProxyStruct<ipc::capnp::messages::BlockWaitOptions>
{
    using Struct = ipc::capnp::messages::BlockWaitOptions;
    using TimeoutAccessor = Accessor<mining_fields::Timeout, FIELD_IN | FIELD_OUT>;
    using FeeThresholdAccessor = Accessor<mining_fields::FeeThreshold, FIELD_IN | FIELD_OUT>;
    using Accessors = std::tuple<TimeoutAccessor, FeeThresholdAccessor>;
    static constexpr size_t fields = 2;
};
template<>
struct ProxyStruct<ipc::capnp::messages::BlockCheckOptions>
{
    using Struct = ipc::capnp::messages::BlockCheckOptions;
    using CheckMerkleRootAccessor = Accessor<mining_fields::CheckMerkleRoot, FIELD_IN | FIELD_OUT>;
    using CheckPowAccessor = Accessor<mining_fields::CheckPow, FIELD_IN | FIELD_OUT>;
    using Accessors = std::tuple<CheckMerkleRootAccessor, CheckPowAccessor>;
    static constexpr size_t fields = 2;
};
} // namespace mp
#if defined(__GNUC__)
#pragma GCC diagnostic pop
#endif
#endif
