// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

type EncryptionAlgorithmType string

const (
	EncryptionAlgorithmTypeAES256 EncryptionAlgorithmType = "AES256"
	EncryptionAlgorithmTypeNone   EncryptionAlgorithmType = "None"
)

// PossibleEncryptionAlgorithmTypeValues returns the possible values for the EncryptionAlgorithmType const type.
func PossibleEncryptionAlgorithmTypeValues() []EncryptionAlgorithmType {
	return []EncryptionAlgorithmType{
		EncryptionAlgorithmTypeAES256,
		EncryptionAlgorithmTypeNone,
	}
}

type ExpiryOptions string

const (
	ExpiryOptionsAbsolute           ExpiryOptions = "Absolute"
	ExpiryOptionsNeverExpire        ExpiryOptions = "NeverExpire"
	ExpiryOptionsRelativeToCreation ExpiryOptions = "RelativeToCreation"
	ExpiryOptionsRelativeToNow      ExpiryOptions = "RelativeToNow"
)

// PossibleExpiryOptionsValues returns the possible values for the ExpiryOptions const type.
func PossibleExpiryOptionsValues() []ExpiryOptions {
	return []ExpiryOptions{
		ExpiryOptionsAbsolute,
		ExpiryOptionsNeverExpire,
		ExpiryOptionsRelativeToCreation,
		ExpiryOptionsRelativeToNow,
	}
}

type LeaseAction string

const (
	LeaseActionAcquire        LeaseAction = "acquire"
	LeaseActionAcquireRelease LeaseAction = "acquire-release"
	LeaseActionAutoRenew      LeaseAction = "auto-renew"
	LeaseActionRelease        LeaseAction = "release"
)

// PossibleLeaseActionValues returns the possible values for the LeaseAction const type.
func PossibleLeaseActionValues() []LeaseAction {
	return []LeaseAction{
		LeaseActionAcquire,
		LeaseActionAcquireRelease,
		LeaseActionAutoRenew,
		LeaseActionRelease,
	}
}

type ListBlobsIncludeItem string

const (
	ListBlobsIncludeItemCopy             ListBlobsIncludeItem = "copy"
	ListBlobsIncludeItemDeleted          ListBlobsIncludeItem = "deleted"
	ListBlobsIncludeItemMetadata         ListBlobsIncludeItem = "metadata"
	ListBlobsIncludeItemSnapshots        ListBlobsIncludeItem = "snapshots"
	ListBlobsIncludeItemTags             ListBlobsIncludeItem = "tags"
	ListBlobsIncludeItemUncommittedblobs ListBlobsIncludeItem = "uncommittedblobs"
	ListBlobsIncludeItemVersions         ListBlobsIncludeItem = "versions"
)

// PossibleListBlobsIncludeItemValues returns the possible values for the ListBlobsIncludeItem const type.
func PossibleListBlobsIncludeItemValues() []ListBlobsIncludeItem {
	return []ListBlobsIncludeItem{
		ListBlobsIncludeItemCopy,
		ListBlobsIncludeItemDeleted,
		ListBlobsIncludeItemMetadata,
		ListBlobsIncludeItemSnapshots,
		ListBlobsIncludeItemTags,
		ListBlobsIncludeItemUncommittedblobs,
		ListBlobsIncludeItemVersions,
	}
}

type PathExpiryOptions string

const (
	PathExpiryOptionsAbsolute           PathExpiryOptions = "Absolute"
	PathExpiryOptionsNeverExpire        PathExpiryOptions = "NeverExpire"
	PathExpiryOptionsRelativeToCreation PathExpiryOptions = "RelativeToCreation"
	PathExpiryOptionsRelativeToNow      PathExpiryOptions = "RelativeToNow"
)

// PossiblePathExpiryOptionsValues returns the possible values for the PathExpiryOptions const type.
func PossiblePathExpiryOptionsValues() []PathExpiryOptions {
	return []PathExpiryOptions{
		PathExpiryOptionsAbsolute,
		PathExpiryOptionsNeverExpire,
		PathExpiryOptionsRelativeToCreation,
		PathExpiryOptionsRelativeToNow,
	}
}

type PathGetPropertiesAction string

const (
	PathGetPropertiesActionGetAccessControl PathGetPropertiesAction = "getAccessControl"
	PathGetPropertiesActionGetStatus        PathGetPropertiesAction = "getStatus"
)

// PossiblePathGetPropertiesActionValues returns the possible values for the PathGetPropertiesAction const type.
func PossiblePathGetPropertiesActionValues() []PathGetPropertiesAction {
	return []PathGetPropertiesAction{
		PathGetPropertiesActionGetAccessControl,
		PathGetPropertiesActionGetStatus,
	}
}

type PathLeaseAction string

const (
	PathLeaseActionAcquire PathLeaseAction = "acquire"
	PathLeaseActionBreak   PathLeaseAction = "break"
	PathLeaseActionChange  PathLeaseAction = "change"
	PathLeaseActionRelease PathLeaseAction = "release"
	PathLeaseActionRenew   PathLeaseAction = "renew"
)

// PossiblePathLeaseActionValues returns the possible values for the PathLeaseAction const type.
func PossiblePathLeaseActionValues() []PathLeaseAction {
	return []PathLeaseAction{
		PathLeaseActionAcquire,
		PathLeaseActionBreak,
		PathLeaseActionChange,
		PathLeaseActionRelease,
		PathLeaseActionRenew,
	}
}

type PathRenameMode string

const (
	PathRenameModeLegacy PathRenameMode = "legacy"
	PathRenameModePosix  PathRenameMode = "posix"
)

// PossiblePathRenameModeValues returns the possible values for the PathRenameMode const type.
func PossiblePathRenameModeValues() []PathRenameMode {
	return []PathRenameMode{
		PathRenameModeLegacy,
		PathRenameModePosix,
	}
}

type PathResourceType string

const (
	PathResourceTypeDirectory PathResourceType = "directory"
	PathResourceTypeFile      PathResourceType = "file"
)

// PossiblePathResourceTypeValues returns the possible values for the PathResourceType const type.
func PossiblePathResourceTypeValues() []PathResourceType {
	return []PathResourceType{
		PathResourceTypeDirectory,
		PathResourceTypeFile,
	}
}

type PathSetAccessControlRecursiveMode string

const (
	PathSetAccessControlRecursiveModeModify PathSetAccessControlRecursiveMode = "modify"
	PathSetAccessControlRecursiveModeRemove PathSetAccessControlRecursiveMode = "remove"
	PathSetAccessControlRecursiveModeSet    PathSetAccessControlRecursiveMode = "set"
)

// PossiblePathSetAccessControlRecursiveModeValues returns the possible values for the PathSetAccessControlRecursiveMode const type.
func PossiblePathSetAccessControlRecursiveModeValues() []PathSetAccessControlRecursiveMode {
	return []PathSetAccessControlRecursiveMode{
		PathSetAccessControlRecursiveModeModify,
		PathSetAccessControlRecursiveModeRemove,
		PathSetAccessControlRecursiveModeSet,
	}
}

type PathUpdateAction string

const (
	PathUpdateActionAppend                    PathUpdateAction = "append"
	PathUpdateActionFlush                     PathUpdateAction = "flush"
	PathUpdateActionSetAccessControl          PathUpdateAction = "setAccessControl"
	PathUpdateActionSetAccessControlRecursive PathUpdateAction = "setAccessControlRecursive"
	PathUpdateActionSetProperties             PathUpdateAction = "setProperties"
)

// PossiblePathUpdateActionValues returns the possible values for the PathUpdateAction const type.
func PossiblePathUpdateActionValues() []PathUpdateAction {
	return []PathUpdateAction{
		PathUpdateActionAppend,
		PathUpdateActionFlush,
		PathUpdateActionSetAccessControl,
		PathUpdateActionSetAccessControlRecursive,
		PathUpdateActionSetProperties,
	}
}
