// ui/gfx/mojom/frame_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_FRAME_DATA_MOJOM_H_
#define UI_GFX_MOJOM_FRAME_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/frame_data.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/frame_data.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/frame_data.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/gfx/mojom/frame_data_mojom_traits.h"




namespace gfx::mojom {





class  FrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameData, T>::value>;
  using DataView = FrameDataDataView;
  using Data_ = internal::FrameData_Data;

  template <typename... Args>
  static FrameDataPtr New(Args&&... args) {
    return FrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameDataPtr From(const U& u) {
    return mojo::TypeConverter<FrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameData>::Convert(*this);
  }


  FrameData();

  FrameData(
      int64_t seq,
      int64_t swap_trace_id);


  ~FrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameDataPtr>
  FrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameData_UnserializedMessageContext<
            UserType, FrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameData_UnserializedMessageContext<
            UserType, FrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t seq;
  
  int64_t swap_trace_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
FrameDataPtr FrameData::Clone() const {
  return New(
      mojo::Clone(seq),
      mojo::Clone(swap_trace_id)
  );
}

template <typename T, FrameData::EnableIfSame<T>*>
bool FrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->seq, other_struct.seq))
    return false;
  if (!mojo::Equals(this->swap_trace_id, other_struct.swap_trace_id))
    return false;
  return true;
}

template <typename T, FrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.seq < rhs.seq)
    return true;
  if (rhs.seq < lhs.seq)
    return false;
  if (lhs.swap_trace_id < rhs.swap_trace_id)
    return true;
  if (rhs.swap_trace_id < lhs.swap_trace_id)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::FrameData::DataView,
                                         ::gfx::mojom::FrameDataPtr> {
  static bool IsNull(const ::gfx::mojom::FrameDataPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::FrameDataPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::FrameData::seq) seq(
      const ::gfx::mojom::FrameDataPtr& input) {
    return input->seq;
  }

  static decltype(::gfx::mojom::FrameData::swap_trace_id) swap_trace_id(
      const ::gfx::mojom::FrameDataPtr& input) {
    return input->swap_trace_id;
  }

  static bool Read(::gfx::mojom::FrameData::DataView input, ::gfx::mojom::FrameDataPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_FRAME_DATA_MOJOM_H_