// ui/gfx/mojom/ca_layer_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-params-data.h"
namespace gfx {
namespace mojom {

namespace internal {
// static
bool CALayerContent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CALayerContent_Data* object = static_cast<const CALayerContent_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CALayerContent_Tag::kCaContextId: {

      return true;
    }
    case CALayerContent_Tag::kIoSurfaceMachPort: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_io_surface_mach_port, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_io_surface_mach_port,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CALayerContent");
      return false;
    }
  }
}


// static
bool CALayerParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CALayerParams_Data* object =
      static_cast<const CALayerParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->content, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->content, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pixel_size, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pixel_size, validation_context))
    return false;

  return true;
}

CALayerParams_Data::CALayerParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx