// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-params-data.h"
namespace payments {
namespace mojom {

NOINLINE static const char* PaymentCredentialStorageStatusToStringHelper(PaymentCredentialStorageStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentCredentialStorageStatus::SUCCESS:
      return "SUCCESS";
    case PaymentCredentialStorageStatus::FAILED_TO_STORE_CREDENTIAL:
      return "FAILED_TO_STORE_CREDENTIAL";
    default:
      return nullptr;
  }
}

std::string PaymentCredentialStorageStatusToString(PaymentCredentialStorageStatus value) {
  const char *str = PaymentCredentialStorageStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentCredentialStorageStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentCredentialStorageStatus value) {
  return os << PaymentCredentialStorageStatusToString(value);
}

NOINLINE static const char* SecurePaymentConfirmationAvailabilityEnumToStringHelper(SecurePaymentConfirmationAvailabilityEnum value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SecurePaymentConfirmationAvailabilityEnum::kAvailable:
      return "kAvailable";
    case SecurePaymentConfirmationAvailabilityEnum::kUnavailableUnknownReason:
      return "kUnavailableUnknownReason";
    case SecurePaymentConfirmationAvailabilityEnum::kUnavailableFeatureNotEnabled:
      return "kUnavailableFeatureNotEnabled";
    case SecurePaymentConfirmationAvailabilityEnum::kUnavailableNoPermissionPolicy:
      return "kUnavailableNoPermissionPolicy";
    case SecurePaymentConfirmationAvailabilityEnum::kUnavailableNoUserVerifyingPlatformAuthenticator:
      return "kUnavailableNoUserVerifyingPlatformAuthenticator";
    default:
      return nullptr;
  }
}

std::string SecurePaymentConfirmationAvailabilityEnumToString(SecurePaymentConfirmationAvailabilityEnum value) {
  const char *str = SecurePaymentConfirmationAvailabilityEnumToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SecurePaymentConfirmationAvailabilityEnum value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SecurePaymentConfirmationAvailabilityEnum value) {
  return os << SecurePaymentConfirmationAvailabilityEnumToString(value);
}

namespace internal {


// static
bool SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params_Data* object =
      static_cast<const SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params_Data*>(data);

  return true;
}

SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params_Data::SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams_Data* object =
      static_cast<const SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::SecurePaymentConfirmationAvailabilityEnum_Data
        ::Validate(object->availability, validation_context))
    return false;

  return true;
}

SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams_Data::SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationService_StorePaymentCredential_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SecurePaymentConfirmationService_StorePaymentCredential_Params_Data* object =
      static_cast<const SecurePaymentConfirmationService_StorePaymentCredential_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credential_id, validation_context,
                                         &credential_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rp_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rp_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rp_id, validation_context,
                                         &rp_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  return true;
}

SecurePaymentConfirmationService_StorePaymentCredential_Params_Data::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data* object =
      static_cast<const SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::PaymentCredentialStorageStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationService_MakePaymentCredential_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SecurePaymentConfirmationService_MakePaymentCredential_Params_Data* object =
      static_cast<const SecurePaymentConfirmationService_MakePaymentCredential_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SecurePaymentConfirmationService_MakePaymentCredential_Params_Data::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data* object =
      static_cast<const SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::AuthenticatorStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dom_exception_details, validation_context))
    return false;

  return true;
}

SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentCredentialStorageStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentCredentialStorageStatus value) {
  return std::move(context).WriteString(::payments::mojom::PaymentCredentialStorageStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::SecurePaymentConfirmationAvailabilityEnum>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::SecurePaymentConfirmationAvailabilityEnum value) {
  return std::move(context).WriteString(::payments::mojom::SecurePaymentConfirmationAvailabilityEnumToString(value));
}

} // namespace perfetto