// third_party/blink/public/mojom/page_state/page_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class DEPRECATED_FileSystemFileDataView;

class FileDataView;

class RequestBodyDataView;

class HttpBodyDataView;

class ViewStateDataView;

class FrameStateDataView;

class PageStateDataView;

class ElementDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DEPRECATED_FileSystemFileDataView> {
  using Data = ::blink::mojom::internal::DEPRECATED_FileSystemFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileDataView> {
  using Data = ::blink::mojom::internal::File_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RequestBodyDataView> {
  using Data = ::blink::mojom::internal::RequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HttpBodyDataView> {
  using Data = ::blink::mojom::internal::HttpBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ViewStateDataView> {
  using Data = ::blink::mojom::internal::ViewState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FrameStateDataView> {
  using Data = ::blink::mojom::internal::FrameState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PageStateDataView> {
  using Data = ::blink::mojom::internal::PageState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ElementDataView> {
  using Data = ::blink::mojom::internal::Element_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ScrollRestorationType : int32_t {
  
  kAuto = 0,
  
  kManual = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ScrollRestorationType value);
inline bool IsKnownEnumValue(ScrollRestorationType value) {
  return internal::ScrollRestorationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ScrollRestorationType ToKnownEnumValue(ScrollRestorationType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ScrollRestorationType::kDefaultValue;
}


class DEPRECATED_FileSystemFileDataView {
 public:
  DEPRECATED_FileSystemFileDataView() = default;

  DEPRECATED_FileSystemFileDataView(
      internal::DEPRECATED_FileSystemFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesystemUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilesystemUrl(UserType* output) {
    
    auto* pointer = data_->filesystem_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModificationTime(UserType* output) {
    
    auto* pointer = data_->modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::DEPRECATED_FileSystemFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileDataView {
 public:
  FileDataView() = default;

  FileDataView(
      internal::File_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModificationTime(UserType* output) {
    
    auto* pointer = data_->modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::File_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestBodyDataView {
 public:
  RequestBodyDataView() = default;

  RequestBodyDataView(
      internal::RequestBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<ElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ElementDataView>>(
        pointer, output, message_);
  }
  int64_t identifier() const {
    return data_->identifier;
  }
  bool contains_sensitive_info() const {
    return data_->contains_sensitive_info;
  }
 private:
  internal::RequestBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpBodyDataView {
 public:
  HttpBodyDataView() = default;

  HttpBodyDataView(
      internal::HttpBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHttpContentTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpContentType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `http_content_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpContentType` instead "
    "of `ReadHttpContentType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->http_content_type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRequestBodyDataView(
      RequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::RequestBodyDataView, UserType>(),
    "Attempting to read the optional `request_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestBody` instead "
    "of `ReadRequestBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_body.Get();
    return mojo::internal::Deserialize<::blink::mojom::RequestBodyDataView>(
        pointer, output, message_);
  }
  bool contains_passwords() const {
    return data_->contains_passwords;
  }
 private:
  internal::HttpBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewStateDataView {
 public:
  ViewStateDataView() = default;

  ViewStateDataView(
      internal::ViewState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVisualViewportScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualViewportScrollOffset(UserType* output) {
    
    auto* pointer = data_->visual_viewport_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetScrollOffsetDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffset(UserType* output) {
    
    auto* pointer = data_->scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  double page_scale_factor() const {
    return data_->page_scale_factor;
  }
  inline void GetScrollAnchorSelectorDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollAnchorSelector(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `scroll_anchor_selector` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollAnchorSelector` instead "
    "of `ReadScrollAnchorSelector if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->scroll_anchor_selector.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetScrollAnchorOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollAnchorOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `scroll_anchor_offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollAnchorOffset` instead "
    "of `ReadScrollAnchorOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->scroll_anchor_offset.Get() : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  uint64_t scroll_anchor_simhash() const {
    if (data_->header_.version < 1)
      return uint64_t{};
    return data_->scroll_anchor_simhash;
  }
 private:
  internal::ViewState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameStateDataView {
 public:
  FrameStateDataView() = default;

  FrameStateDataView(
      internal::FrameState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlStringDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlString(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `url_string` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrlString` instead "
    "of `ReadUrlString if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_string.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `referrer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferrer` instead "
    "of `ReadReferrer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTargetDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTarget` instead "
    "of `ReadTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->target.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetStateObjectDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStateObject(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `state_object` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStateObject` instead "
    "of `ReadStateObject if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->state_object.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDocumentStateDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentState(UserType* output) {
    
    auto* pointer = data_->document_state.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollRestorationType(UserType* output) const {
    auto data_value = data_->scroll_restoration_type;
    return mojo::internal::Deserialize<::blink::mojom::ScrollRestorationType>(
        data_value, output);
  }
  ScrollRestorationType scroll_restoration_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollRestorationType>(data_->scroll_restoration_type));
  }
  inline void GetViewStateDataView(
      ViewStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewStateDataView, UserType>(),
    "Attempting to read the optional `view_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewState` instead "
    "of `ReadViewState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewStateDataView>(
        pointer, output, message_);
  }
  int64_t item_sequence_number() const {
    return data_->item_sequence_number;
  }
  int64_t document_sequence_number() const {
    return data_->document_sequence_number;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetHttpBodyDataView(
      HttpBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpBody(UserType* output) {
    
    auto* pointer = data_->http_body.Get();
    return mojo::internal::Deserialize<::blink::mojom::HttpBodyDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<FrameStateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FrameStateDataView>>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->initiator_origin.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationApiKeyDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `navigation_api_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationApiKey` instead "
    "of `ReadNavigationApiKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->navigation_api_key.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNavigationApiIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `navigation_api_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationApiId` instead "
    "of `ReadNavigationApiId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->navigation_api_id.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNavigationApiStateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `navigation_api_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationApiState` instead "
    "of `ReadNavigationApiState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 4
                    ? data_->navigation_api_state.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool protect_url_in_navigation_api() const {
    if (data_->header_.version < 5)
      return bool{};
    return data_->protect_url_in_navigation_api;
  }
  inline void GetInitiatorBaseUrlStringDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrlString(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `initiator_base_url_string` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrlString` instead "
    "of `ReadInitiatorBaseUrlString if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 6
                    ? data_->initiator_base_url_string.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageStateDataView {
 public:
  PageStateDataView() = default;

  PageStateDataView(
      internal::PageState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReferencedFilesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferencedFiles(UserType* output) {
    
    auto* pointer = data_->referenced_files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetTopDataView(
      FrameStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTop(UserType* output) {
    
    auto* pointer = data_->top.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ElementDataView {
 public:
  using Tag = internal::Element_Data::Element_Tag;

  ElementDataView() = default;

  ElementDataView(
      internal::Element_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_blob_uuid() const { return data_->tag == Tag::kBlobUuid; }
  inline void GetBlobUuidDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBlobUuid(UserType* output) const {
    
    CHECK(is_blob_uuid());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_blob_uuid.Get(), output, message_);
  }
  bool is_bytes() const { return data_->tag == Tag::kBytes; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) const {
    
    CHECK(is_bytes());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_bytes.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      FileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::blink::mojom::FileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_DEPRECATED_file_system_file() const { return data_->tag == Tag::kDeprecatedFileSystemFile; }
  inline void GetDeprecatedFileSystemFileDataView(
      DEPRECATED_FileSystemFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedFileSystemFile(UserType* output) const {
    
    CHECK(is_DEPRECATED_file_system_file());
    return mojo::internal::Deserialize<::blink::mojom::DEPRECATED_FileSystemFileDataView>(
        data_->data.f_DEPRECATED_file_system_file.Get(), output, message_);
  }

 private:
  internal::Element_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_DATA_VIEW_H_