// third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_error.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT FileSystemAccessError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessError, T>::value>;
  using DataView = FileSystemAccessErrorDataView;
  using Data_ = internal::FileSystemAccessError_Data;

  template <typename... Args>
  static FileSystemAccessErrorPtr New(Args&&... args) {
    return FileSystemAccessErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessErrorPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessError>::Convert(*this);
  }


  FileSystemAccessError();

  FileSystemAccessError(
      FileSystemAccessStatus status,
      ::base::File::Error file_error,
      const ::blink::String& message);


  ~FileSystemAccessError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessErrorPtr>
  FileSystemAccessErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessError_UnserializedMessageContext<
            UserType, FileSystemAccessError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessError_UnserializedMessageContext<
            UserType, FileSystemAccessError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FileSystemAccessStatus status;
  
  ::base::File::Error file_error;
  
  ::blink::String message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
FileSystemAccessErrorPtr FileSystemAccessError::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(file_error),
      mojo::Clone(message)
  );
}

template <typename T, FileSystemAccessError::EnableIfSame<T>*>
bool FileSystemAccessError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->file_error, other_struct.file_error))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, FileSystemAccessError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.file_error < rhs.file_error)
    return true;
  if (rhs.file_error < lhs.file_error)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FileSystemAccessError::DataView,
                                         ::blink::mojom::blink::FileSystemAccessErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::FileSystemAccessErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FileSystemAccessErrorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FileSystemAccessError::status) status(
      const ::blink::mojom::blink::FileSystemAccessErrorPtr& input) {
    return input->status;
  }

  static decltype(::blink::mojom::blink::FileSystemAccessError::file_error) file_error(
      const ::blink::mojom::blink::FileSystemAccessErrorPtr& input) {
    return input->file_error;
  }

  static const decltype(::blink::mojom::blink::FileSystemAccessError::message)& message(
      const ::blink::mojom::blink::FileSystemAccessErrorPtr& input) {
    return input->message;
  }

  static bool Read(::blink::mojom::blink::FileSystemAccessError::DataView input, ::blink::mojom::blink::FileSystemAccessErrorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_BLINK_H_