// third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CALL_STACK_GENERATOR_CALL_STACK_GENERATOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CALL_STACK_GENERATOR_CALL_STACK_GENERATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class CallStackGeneratorProxy;

template <typename ImplRefTraits>
class CallStackGeneratorStub;

class CallStackGeneratorRequestValidator;
class CallStackGeneratorResponseValidator;


class BLINK_COMMON_EXPORT CallStackGenerator
    : public CallStackGeneratorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.CallStackGenerator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CallStackGeneratorInterfaceBase;
  using Proxy_ = CallStackGeneratorProxy;

  template <typename ImplRefTraits>
  using Stub_ = CallStackGeneratorStub<ImplRefTraits>;

  using RequestValidator_ = CallStackGeneratorRequestValidator;
  using ResponseValidator_ = CallStackGeneratorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCollectJavaScriptCallStackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CollectJavaScriptCallStack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CallStackGenerator() = default;

  using CollectJavaScriptCallStackCallback = base::OnceCallback<void(const std::string&, const std::optional<::blink::LocalFrameToken>&)>;
  using CollectJavaScriptCallStackMojoCallback = base::OnceCallback<void(const std::string&, const std::optional<::blink::LocalFrameToken>&)>;

  virtual void CollectJavaScriptCallStack(CollectJavaScriptCallStackCallback callback) = 0;
};



class BLINK_COMMON_EXPORT CallStackGeneratorProxy
    : public CallStackGenerator {
 public:
  using InterfaceType = CallStackGenerator;

  explicit CallStackGeneratorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CollectJavaScriptCallStack(CollectJavaScriptCallStackCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT CallStackGeneratorStubDispatch {
 public:
  static bool Accept(CallStackGenerator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CallStackGenerator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CallStackGenerator>>
class CallStackGeneratorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CallStackGeneratorStub() = default;
  ~CallStackGeneratorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CallStackGeneratorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CallStackGeneratorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT CallStackGeneratorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT CallStackGeneratorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CALL_STACK_GENERATOR_CALL_STACK_GENERATOR_MOJOM_H_