// services/viz/privileged/mojom/compositing/renderer_settings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-test-utils.h"


namespace viz::mojom {
OcclusionCullerSettings::OcclusionCullerSettings()
    : quad_split_limit(),
      maximum_occluder_complexity(),
      minimum_fragments_reduced(),
      generate_complex_occluder_for_rounded_corners() {}

OcclusionCullerSettings::OcclusionCullerSettings(
    uint16_t quad_split_limit_in,
    uint16_t maximum_occluder_complexity_in,
    uint16_t minimum_fragments_reduced_in,
    bool generate_complex_occluder_for_rounded_corners_in)
    : quad_split_limit(std::move(quad_split_limit_in)),
      maximum_occluder_complexity(std::move(maximum_occluder_complexity_in)),
      minimum_fragments_reduced(std::move(minimum_fragments_reduced_in)),
      generate_complex_occluder_for_rounded_corners(std::move(generate_complex_occluder_for_rounded_corners_in)) {}

OcclusionCullerSettings::~OcclusionCullerSettings() = default;
size_t OcclusionCullerSettings::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->quad_split_limit);
  seed = mojo::internal::Hash(seed, this->maximum_occluder_complexity);
  seed = mojo::internal::Hash(seed, this->minimum_fragments_reduced);
  seed = mojo::internal::Hash(seed, this->generate_complex_occluder_for_rounded_corners);
  return seed;
}

void OcclusionCullerSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quad_split_limit"), this->quad_split_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_occluder_complexity"), this->maximum_occluder_complexity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minimum_fragments_reduced"), this->minimum_fragments_reduced,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generate_complex_occluder_for_rounded_corners"), this->generate_complex_occluder_for_rounded_corners,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OcclusionCullerSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RendererSettings::RendererSettings()
    : allow_antialiasing(),
      force_antialiasing(),
      force_blending_with_shaders(),
      highp_threshold_min(),
      partial_swap_enabled(),
      release_overlay_resources_after_gpu_query(),
      should_clear_root_render_pass(),
      slow_down_compositing_scale_factor(),
      auto_resize_output_surface(),
      requires_alpha_channel(),
      occlusion_culler_settings(),
      overlay_strategies() {}

RendererSettings::RendererSettings(
    bool allow_antialiasing_in,
    bool force_antialiasing_in,
    bool force_blending_with_shaders_in,
    int32_t highp_threshold_min_in,
    bool partial_swap_enabled_in,
    bool release_overlay_resources_after_gpu_query_in,
    bool should_clear_root_render_pass_in,
    int32_t slow_down_compositing_scale_factor_in,
    bool auto_resize_output_surface_in,
    bool requires_alpha_channel_in,
    OcclusionCullerSettingsPtr occlusion_culler_settings_in,
    std::vector<::viz::mojom::OverlayStrategy> overlay_strategies_in)
    : allow_antialiasing(std::move(allow_antialiasing_in)),
      force_antialiasing(std::move(force_antialiasing_in)),
      force_blending_with_shaders(std::move(force_blending_with_shaders_in)),
      highp_threshold_min(std::move(highp_threshold_min_in)),
      partial_swap_enabled(std::move(partial_swap_enabled_in)),
      release_overlay_resources_after_gpu_query(std::move(release_overlay_resources_after_gpu_query_in)),
      should_clear_root_render_pass(std::move(should_clear_root_render_pass_in)),
      slow_down_compositing_scale_factor(std::move(slow_down_compositing_scale_factor_in)),
      auto_resize_output_surface(std::move(auto_resize_output_surface_in)),
      requires_alpha_channel(std::move(requires_alpha_channel_in)),
      occlusion_culler_settings(std::move(occlusion_culler_settings_in)),
      overlay_strategies(std::move(overlay_strategies_in)) {}

RendererSettings::~RendererSettings() = default;

void RendererSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_antialiasing"), this->allow_antialiasing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_antialiasing"), this->force_antialiasing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_blending_with_shaders"), this->force_blending_with_shaders,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "highp_threshold_min"), this->highp_threshold_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partial_swap_enabled"), this->partial_swap_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_overlay_resources_after_gpu_query"), this->release_overlay_resources_after_gpu_query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_clear_root_render_pass"), this->should_clear_root_render_pass,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "slow_down_compositing_scale_factor"), this->slow_down_compositing_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_resize_output_surface"), this->auto_resize_output_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requires_alpha_channel"), this->requires_alpha_channel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "occlusion_culler_settings"), this->occlusion_culler_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OcclusionCullerSettingsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_strategies"), this->overlay_strategies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::viz::mojom::OverlayStrategy>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RendererSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DebugRendererSettings::DebugRendererSettings()
    : tint_composited_content(),
      tint_composited_content_modulate(),
      show_overdraw_feedback(),
      show_dc_layer_debug_borders(),
      show_aggregated_damage() {}

DebugRendererSettings::DebugRendererSettings(
    bool tint_composited_content_in,
    bool tint_composited_content_modulate_in,
    bool show_overdraw_feedback_in,
    bool show_dc_layer_debug_borders_in,
    bool show_aggregated_damage_in)
    : tint_composited_content(std::move(tint_composited_content_in)),
      tint_composited_content_modulate(std::move(tint_composited_content_modulate_in)),
      show_overdraw_feedback(std::move(show_overdraw_feedback_in)),
      show_dc_layer_debug_borders(std::move(show_dc_layer_debug_borders_in)),
      show_aggregated_damage(std::move(show_aggregated_damage_in)) {}

DebugRendererSettings::~DebugRendererSettings() = default;

void DebugRendererSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tint_composited_content"), this->tint_composited_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tint_composited_content_modulate"), this->tint_composited_content_modulate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_overdraw_feedback"), this->show_overdraw_feedback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_dc_layer_debug_borders"), this->show_dc_layer_debug_borders,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_aggregated_damage"), this->show_aggregated_damage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DebugRendererSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::OcclusionCullerSettings::DataView, ::viz::mojom::OcclusionCullerSettingsPtr>::Read(
    ::viz::mojom::OcclusionCullerSettings::DataView input,
    ::viz::mojom::OcclusionCullerSettingsPtr* output) {
  bool success = true;
  ::viz::mojom::OcclusionCullerSettingsPtr result(::viz::mojom::OcclusionCullerSettings::New());
  
      if (success)
        result->quad_split_limit = input.quad_split_limit();
      if (success)
        result->maximum_occluder_complexity = input.maximum_occluder_complexity();
      if (success)
        result->minimum_fragments_reduced = input.minimum_fragments_reduced();
      if (success)
        result->generate_complex_occluder_for_rounded_corners = input.generate_complex_occluder_for_rounded_corners();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::RendererSettings::DataView, ::viz::mojom::RendererSettingsPtr>::Read(
    ::viz::mojom::RendererSettings::DataView input,
    ::viz::mojom::RendererSettingsPtr* output) {
  bool success = true;
  ::viz::mojom::RendererSettingsPtr result(::viz::mojom::RendererSettings::New());
  
      if (success)
        result->allow_antialiasing = input.allow_antialiasing();
      if (success)
        result->force_antialiasing = input.force_antialiasing();
      if (success)
        result->force_blending_with_shaders = input.force_blending_with_shaders();
      if (success)
        result->highp_threshold_min = input.highp_threshold_min();
      if (success)
        result->partial_swap_enabled = input.partial_swap_enabled();
      if (success)
        result->release_overlay_resources_after_gpu_query = input.release_overlay_resources_after_gpu_query();
      if (success)
        result->should_clear_root_render_pass = input.should_clear_root_render_pass();
      if (success)
        result->slow_down_compositing_scale_factor = input.slow_down_compositing_scale_factor();
      if (success)
        result->auto_resize_output_surface = input.auto_resize_output_surface();
      if (success)
        result->requires_alpha_channel = input.requires_alpha_channel();
      if (success && !input.ReadOcclusionCullerSettings(&result->occlusion_culler_settings))
        success = false;
      if (success && !input.ReadOverlayStrategies(&result->overlay_strategies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::DebugRendererSettings::DataView, ::viz::mojom::DebugRendererSettingsPtr>::Read(
    ::viz::mojom::DebugRendererSettings::DataView input,
    ::viz::mojom::DebugRendererSettingsPtr* output) {
  bool success = true;
  ::viz::mojom::DebugRendererSettingsPtr result(::viz::mojom::DebugRendererSettings::New());
  
      if (success)
        result->tint_composited_content = input.tint_composited_content();
      if (success)
        result->tint_composited_content_modulate = input.tint_composited_content_modulate();
      if (success)
        result->show_overdraw_feedback = input.show_overdraw_feedback();
      if (success)
        result->show_dc_layer_debug_borders = input.show_dc_layer_debug_borders();
      if (success)
        result->show_aggregated_damage = input.show_aggregated_damage();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif