// services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-test-utils.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

FrameSinkManagerTestApi::IPCStableHashFunction FrameSinkManagerTestApi::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkManagerTestApi>(message.name())) {
    case messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources: {
      return &FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize: {
      return &FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerTestApi::kGetForceEnableZoomState: {
      return &FrameSinkManagerTestApi::GetForceEnableZoomState_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager: {
      return &FrameSinkManagerTestApi::WaitForSurfaceAnimationManager_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkManagerTestApi::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkManagerTestApi>(message.name())) {
      case messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources:
            return "Receive viz::mojom::FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources";
      case messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize:
            return "Receive viz::mojom::FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize";
      case messages::FrameSinkManagerTestApi::kGetForceEnableZoomState:
            return "Receive viz::mojom::FrameSinkManagerTestApi::GetForceEnableZoomState";
      case messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager:
            return "Receive viz::mojom::FrameSinkManagerTestApi::WaitForSurfaceAnimationManager";
    }
  } else {
    switch (static_cast<messages::FrameSinkManagerTestApi>(message.name())) {
      case messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources:
            return "Receive reply viz::mojom::FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources";
      case messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize:
            return "Receive reply viz::mojom::FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize";
      case messages::FrameSinkManagerTestApi::kGetForceEnableZoomState:
            return "Receive reply viz::mojom::FrameSinkManagerTestApi::GetForceEnableZoomState";
      case messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager:
            return "Receive reply viz::mojom::FrameSinkManagerTestApi::WaitForSurfaceAnimationManager";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe352867a;  // IPCStableHash for viz::mojom::FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c188af7;  // IPCStableHash for viz::mojom::FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerTestApi::GetForceEnableZoomState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ceec0fd;  // IPCStableHash for viz::mojom::FrameSinkManagerTestApi::GetForceEnableZoomState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerTestApi::WaitForSurfaceAnimationManager_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4e0825a;  // IPCStableHash for viz::mojom::FrameSinkManagerTestApi::WaitForSurfaceAnimationManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources(bool* out_has_resources) {
  NOTREACHED();
}
bool FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize(const ::gfx::Size& result_size) {
  NOTREACHED();
}
bool FrameSinkManagerTestApi::GetForceEnableZoomState(const ::viz::FrameSinkId& frame_sink_id, bool* out_enabled) {
  NOTREACHED();
}
bool FrameSinkManagerTestApi::WaitForSurfaceAnimationManager(const ::viz::FrameSinkId& frame_sink_id) {
  NOTREACHED();
}
class FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse(
      bool* result, bool* out_has_resources)
      : result_(result), out_has_resources_(out_has_resources) {
    DCHECK(!*result_);
  }

  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse(const FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse&) = delete;
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse& operator=(const FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_has_resources_;};

class FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback(
      FrameSinkManagerTestApi::HasUnclaimedViewTransitionResourcesCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback(const FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback&) = delete;
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback& operator=(const FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManagerTestApi::HasUnclaimedViewTransitionResourcesCallback callback_;
};
class FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse(const FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse&) = delete;
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse& operator=(const FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback(
      FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback(const FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback&) = delete;
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback& operator=(const FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSizeCallback callback_;
};
class FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse(
      bool* result, bool* out_enabled)
      : result_(result), out_enabled_(out_enabled) {
    DCHECK(!*result_);
  }

  FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse(const FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse&) = delete;
  FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse& operator=(const FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_enabled_;};

class FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback(
      FrameSinkManagerTestApi::GetForceEnableZoomStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback(const FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback&) = delete;
  FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback& operator=(const FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManagerTestApi::GetForceEnableZoomStateCallback callback_;
};
class FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse(const FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse&) = delete;
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse& operator=(const FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback(
      FrameSinkManagerTestApi::WaitForSurfaceAnimationManagerCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback(const FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback&) = delete;
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback& operator=(const FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManagerTestApi::WaitForSurfaceAnimationManagerCallback callback_;
};

FrameSinkManagerTestApiProxy::FrameSinkManagerTestApiProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FrameSinkManagerTestApiProxy::HasUnclaimedViewTransitionResources(
    bool* out_param_has_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call viz::mojom::FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources (sync)");
#else
  TRACE_EVENT0("mojom", "FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("HasUnclaimedViewTransitionResources");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse(
          &result, out_param_has_resources));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_resources"), out_param_has_resources,
                        "<value of type bool>");
   });
#endif
  return result;
}

void FrameSinkManagerTestApiProxy::HasUnclaimedViewTransitionResources(
    HasUnclaimedViewTransitionResourcesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("HasUnclaimedViewTransitionResources");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FrameSinkManagerTestApiProxy::SetSameDocNavigationScreenshotSize(
    const ::gfx::Size& param_result_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call viz::mojom::FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_size"), param_result_size,
                        "<value of type const ::gfx::Size&>");
   });
#else
  TRACE_EVENT0("mojom", "FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_size)::BaseType> result_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    param_result_size,
    result_size_fragment);

  params->result_size.Set(
      result_size_fragment.is_null() ? nullptr : result_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_size in FrameSinkManagerTestApi.SetSameDocNavigationScreenshotSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("SetSameDocNavigationScreenshotSize");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize");
#endif
  return result;
}

void FrameSinkManagerTestApiProxy::SetSameDocNavigationScreenshotSize(
    const ::gfx::Size& in_result_size, SetSameDocNavigationScreenshotSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_size"), in_result_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_size)::BaseType> result_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_result_size,
    result_size_fragment);

  params->result_size.Set(
      result_size_fragment.is_null() ? nullptr : result_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_size in FrameSinkManagerTestApi.SetSameDocNavigationScreenshotSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("SetSameDocNavigationScreenshotSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FrameSinkManagerTestApiProxy::GetForceEnableZoomState(
    const ::viz::FrameSinkId& param_frame_sink_id, bool* out_param_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call viz::mojom::FrameSinkManagerTestApi::GetForceEnableZoomState (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), param_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#else
  TRACE_EVENT0("mojom", "FrameSinkManagerTestApi::GetForceEnableZoomState");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kGetForceEnableZoomState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_GetForceEnableZoomState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    param_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManagerTestApi.GetForceEnableZoomState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("GetForceEnableZoomState");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse(
          &result, out_param_enabled));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FrameSinkManagerTestApi::GetForceEnableZoomState", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), out_param_enabled,
                        "<value of type bool>");
   });
#endif
  return result;
}

void FrameSinkManagerTestApiProxy::GetForceEnableZoomState(
    const ::viz::FrameSinkId& in_frame_sink_id, GetForceEnableZoomStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerTestApi::GetForceEnableZoomState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kGetForceEnableZoomState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_GetForceEnableZoomState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManagerTestApi.GetForceEnableZoomState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("GetForceEnableZoomState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FrameSinkManagerTestApiProxy::WaitForSurfaceAnimationManager(
    const ::viz::FrameSinkId& param_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call viz::mojom::FrameSinkManagerTestApi::WaitForSurfaceAnimationManager (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), param_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#else
  TRACE_EVENT0("mojom", "FrameSinkManagerTestApi::WaitForSurfaceAnimationManager");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    param_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManagerTestApi.WaitForSurfaceAnimationManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("WaitForSurfaceAnimationManager");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "FrameSinkManagerTestApi::WaitForSurfaceAnimationManager");
#endif
  return result;
}

void FrameSinkManagerTestApiProxy::WaitForSurfaceAnimationManager(
    const ::viz::FrameSinkId& in_frame_sink_id, WaitForSurfaceAnimationManagerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerTestApi::WaitForSurfaceAnimationManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManagerTestApi.WaitForSurfaceAnimationManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("WaitForSurfaceAnimationManager");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinkManagerTestApi::HasUnclaimedViewTransitionResourcesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder> proxy(
        new FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinkManagerTestApi::HasUnclaimedViewTransitionResourcesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_resources);
};

bool FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.0
  bool success = true;
  bool p_has_resources{};
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_resources = input_data_view.has_resources();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_resources));
  }
  return true;
}

void FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder::Run(
    bool in_has_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::FrameSinkManagerTestApi::HasUnclaimedViewTransitionResources", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_resources"), in_has_resources,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_resources = in_has_resources;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("HasUnclaimedViewTransitionResources");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.0
  bool success = true;
  bool p_has_resources{};
  FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_resources = input_data_view.has_resources();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 0, true);
    return false;
  }
  *out_has_resources_ = std::move(p_has_resources);
  *result_ = true;
  return true;
}
class FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder> proxy(
        new FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.1
  bool success = true;
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply viz::mojom::FrameSinkManagerTestApi::SetSameDocNavigationScreenshotSize");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("SetSameDocNavigationScreenshotSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.1
  bool success = true;
  FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 1, true);
    return false;
  }
  *result_ = true;
  return true;
}
class FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinkManagerTestApi::GetForceEnableZoomStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder> proxy(
        new FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinkManagerTestApi::GetForceEnableZoomStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool FrameSinkManagerTestApi_GetForceEnableZoomState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.2
  bool success = true;
  bool p_enabled{};
  FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled));
  }
  return true;
}

void FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::FrameSinkManagerTestApi::GetForceEnableZoomState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kGetForceEnableZoomState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("GetForceEnableZoomState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManagerTestApi_GetForceEnableZoomState_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.2
  bool success = true;
  bool p_enabled{};
  FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 2, true);
    return false;
  }
  *out_enabled_ = std::move(p_enabled);
  *result_ = true;
  return true;
}
class FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinkManagerTestApi::WaitForSurfaceAnimationManagerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder> proxy(
        new FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinkManagerTestApi::WaitForSurfaceAnimationManagerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.3
  bool success = true;
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply viz::mojom::FrameSinkManagerTestApi::WaitForSurfaceAnimationManager");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerTestApi::Name_);
  message.set_method_name("WaitForSurfaceAnimationManager");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FrameSinkManagerTestApi.3
  bool success = true;
  FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManagerTestApi::Name_, 3, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool FrameSinkManagerTestApiStubDispatch::Accept(
    FrameSinkManagerTestApi* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkManagerTestApi>(message->header()->name)) {
    case messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources: {
      break;
    }
    case messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize: {
      break;
    }
    case messages::FrameSinkManagerTestApi::kGetForceEnableZoomState: {
      break;
    }
    case messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager: {
      break;
    }
  }
  return false;
}

// static
bool FrameSinkManagerTestApiStubDispatch::AcceptWithResponder(
    FrameSinkManagerTestApi* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkManagerTestApi>(message->header()->name)) {
    case messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources: {
      internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinkManagerTestApi.0
      bool success = true;
      FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerTestApi::Name_, 0, false);
        return false;
      }
      auto callback =
          FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasUnclaimedViewTransitionResources(std::move(callback));
      return true;
    }
    case messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize: {
      internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinkManagerTestApi.1
      bool success = true;
      ::gfx::Size p_result_size{};
      FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultSize(&p_result_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerTestApi::Name_, 1, false);
        return false;
      }
      auto callback =
          FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSameDocNavigationScreenshotSize(        
        std::move(p_result_size), std::move(callback));
      return true;
    }
    case messages::FrameSinkManagerTestApi::kGetForceEnableZoomState: {
      internal::FrameSinkManagerTestApi_GetForceEnableZoomState_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManagerTestApi_GetForceEnableZoomState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinkManagerTestApi.2
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      FrameSinkManagerTestApi_GetForceEnableZoomState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerTestApi::Name_, 2, false);
        return false;
      }
      auto callback =
          FrameSinkManagerTestApi_GetForceEnableZoomState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetForceEnableZoomState(        
        std::move(p_frame_sink_id), std::move(callback));
      return true;
    }
    case messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager: {
      internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinkManagerTestApi.3
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerTestApi::Name_, 3, false);
        return false;
      }
      auto callback =
          FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForSurfaceAnimationManager(        
        std::move(p_frame_sink_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkManagerTestApiValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkManagerTestApi::kHasUnclaimedViewTransitionResources),
     { &internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_Params_Data::Validate,
      &internal::FrameSinkManagerTestApi_HasUnclaimedViewTransitionResources_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameSinkManagerTestApi::kSetSameDocNavigationScreenshotSize),
     { &internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_Params_Data::Validate,
      &internal::FrameSinkManagerTestApi_SetSameDocNavigationScreenshotSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameSinkManagerTestApi::kGetForceEnableZoomState),
     { &internal::FrameSinkManagerTestApi_GetForceEnableZoomState_Params_Data::Validate,
      &internal::FrameSinkManagerTestApi_GetForceEnableZoomState_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameSinkManagerTestApi::kWaitForSurfaceAnimationManager),
     { &internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_Params_Data::Validate,
      &internal::FrameSinkManagerTestApi_WaitForSurfaceAnimationManager_ResponseParams_Data::Validate}},
};

bool FrameSinkManagerTestApiRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::viz::mojom::FrameSinkManagerTestApi::Name_,
    kFrameSinkManagerTestApiValidationInfo);
}

bool FrameSinkManagerTestApiResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::viz::mojom::FrameSinkManagerTestApi::Name_,
    kFrameSinkManagerTestApiValidationInfo);

}


}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void FrameSinkManagerTestApiInterceptorForTesting::HasUnclaimedViewTransitionResources(HasUnclaimedViewTransitionResourcesCallback callback) {
  GetForwardingInterface()->HasUnclaimedViewTransitionResources(std::move(callback));
}
void FrameSinkManagerTestApiInterceptorForTesting::SetSameDocNavigationScreenshotSize(const ::gfx::Size& result_size, SetSameDocNavigationScreenshotSizeCallback callback) {
  GetForwardingInterface()->SetSameDocNavigationScreenshotSize(
    std::move(result_size)
    , std::move(callback));
}
void FrameSinkManagerTestApiInterceptorForTesting::GetForceEnableZoomState(const ::viz::FrameSinkId& frame_sink_id, GetForceEnableZoomStateCallback callback) {
  GetForwardingInterface()->GetForceEnableZoomState(
    std::move(frame_sink_id)
    , std::move(callback));
}
void FrameSinkManagerTestApiInterceptorForTesting::WaitForSurfaceAnimationManager(const ::viz::FrameSinkId& frame_sink_id, WaitForSurfaceAnimationManagerCallback callback) {
  GetForwardingInterface()->WaitForSurfaceAnimationManager(
    std::move(frame_sink_id)
    , std::move(callback));
}
FrameSinkManagerTestApiAsyncWaiter::FrameSinkManagerTestApiAsyncWaiter(
    FrameSinkManagerTestApi* proxy) : proxy_(proxy) {}

FrameSinkManagerTestApiAsyncWaiter::~FrameSinkManagerTestApiAsyncWaiter() = default;


void FrameSinkManagerTestApiAsyncWaiter::HasUnclaimedViewTransitionResources(
    bool* out_has_resources) {
  base::RunLoop loop;
  proxy_->HasUnclaimedViewTransitionResources(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_resources
,
             bool has_resources) {*out_has_resources = std::move(has_resources);
            loop->Quit();
          },
          &loop,
          out_has_resources));
  loop.Run();
}

bool FrameSinkManagerTestApiAsyncWaiter::HasUnclaimedViewTransitionResources(
    ) {
  bool async_wait_result;
  HasUnclaimedViewTransitionResources(&async_wait_result);
  return async_wait_result;
}

void FrameSinkManagerTestApiAsyncWaiter::SetSameDocNavigationScreenshotSize(
    const ::gfx::Size& result_size) {
  base::RunLoop loop;
  proxy_->SetSameDocNavigationScreenshotSize(
      std::move(result_size),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FrameSinkManagerTestApiAsyncWaiter::GetForceEnableZoomState(
    const ::viz::FrameSinkId& frame_sink_id, bool* out_enabled) {
  base::RunLoop loop;
  proxy_->GetForceEnableZoomState(
      std::move(frame_sink_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool FrameSinkManagerTestApiAsyncWaiter::GetForceEnableZoomState(
    const ::viz::FrameSinkId& frame_sink_id) {
  bool async_wait_result;
  GetForceEnableZoomState(std::move(frame_sink_id),&async_wait_result);
  return async_wait_result;
}

void FrameSinkManagerTestApiAsyncWaiter::WaitForSurfaceAnimationManager(
    const ::viz::FrameSinkId& frame_sink_id) {
  base::RunLoop loop;
  proxy_->WaitForSurfaceAnimationManager(
      std::move(frame_sink_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif