// services/network/public/mojom/websocket.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/websocket.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/websocket.mojom-params-data.h"
#include "services/network/public/mojom/websocket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/websocket.mojom-import-headers.h"
#include "services/network/public/mojom/websocket.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
HttpHeader::HttpHeader()
    : name(),
      value() {}

HttpHeader::HttpHeader(
    const std::string& name_in,
    const std::string& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

HttpHeader::~HttpHeader() = default;
size_t HttpHeader::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void HttpHeader::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebSocketHandshakeRequest::WebSocketHandshakeRequest()
    : url(),
      headers(),
      headers_text() {}

WebSocketHandshakeRequest::WebSocketHandshakeRequest(
    const ::GURL& url_in,
    std::vector<HttpHeaderPtr> headers_in,
    const std::string& headers_text_in)
    : url(std::move(url_in)),
      headers(std::move(headers_in)),
      headers_text(std::move(headers_text_in)) {}

WebSocketHandshakeRequest::~WebSocketHandshakeRequest() = default;

void WebSocketHandshakeRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<HttpHeaderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers_text"), this->headers_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebSocketHandshakeRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebSocketHandshakeResponse::WebSocketHandshakeResponse()
    : url(),
      http_version(),
      status_code(),
      status_text(),
      remote_endpoint(),
      headers(),
      headers_text(),
      selected_protocol(),
      extensions() {}

WebSocketHandshakeResponse::WebSocketHandshakeResponse(
    const ::GURL& url_in,
    const ::net::HttpVersion& http_version_in,
    int32_t status_code_in,
    const std::string& status_text_in,
    const ::net::IPEndPoint& remote_endpoint_in,
    std::vector<HttpHeaderPtr> headers_in,
    const std::string& headers_text_in,
    const std::string& selected_protocol_in,
    const std::string& extensions_in)
    : url(std::move(url_in)),
      http_version(std::move(http_version_in)),
      status_code(std::move(status_code_in)),
      status_text(std::move(status_text_in)),
      remote_endpoint(std::move(remote_endpoint_in)),
      headers(std::move(headers_in)),
      headers_text(std::move(headers_text_in)),
      selected_protocol(std::move(selected_protocol_in)),
      extensions(std::move(extensions_in)) {}

WebSocketHandshakeResponse::~WebSocketHandshakeResponse() = default;

void WebSocketHandshakeResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_version"), this->http_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HttpVersion&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_text"), this->status_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_endpoint"), this->remote_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<HttpHeaderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers_text"), this->headers_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_protocol"), this->selected_protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebSocketHandshakeResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebSocketAuthenticationHandler::IPCStableHashFunction WebSocketAuthenticationHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebSocketAuthenticationHandler>(message.name())) {
    case messages::WebSocketAuthenticationHandler::kOnAuthRequired: {
      return &WebSocketAuthenticationHandler::OnAuthRequired_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebSocketAuthenticationHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebSocketAuthenticationHandler>(message.name())) {
      case messages::WebSocketAuthenticationHandler::kOnAuthRequired:
            return "Receive network::mojom::WebSocketAuthenticationHandler::OnAuthRequired";
    }
  } else {
    switch (static_cast<messages::WebSocketAuthenticationHandler>(message.name())) {
      case messages::WebSocketAuthenticationHandler::kOnAuthRequired:
            return "Receive reply network::mojom::WebSocketAuthenticationHandler::OnAuthRequired";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebSocketAuthenticationHandler::OnAuthRequired_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6d5725b;  // IPCStableHash for network::mojom::WebSocketAuthenticationHandler::OnAuthRequired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback(
      WebSocketAuthenticationHandler::OnAuthRequiredCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback(const WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback&) = delete;
  WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback& operator=(const WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebSocketAuthenticationHandler::OnAuthRequiredCallback callback_;
};

WebSocketAuthenticationHandlerProxy::WebSocketAuthenticationHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketAuthenticationHandlerProxy::OnAuthRequired(
    const ::net::AuthChallengeInfo& in_info, const ::scoped_refptr<::net::HttpResponseHeaders>& in_headers, const ::net::IPEndPoint& in_remote_endpoint, OnAuthRequiredCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocketAuthenticationHandler::OnAuthRequired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::net::AuthChallengeInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_endpoint"), in_remote_endpoint,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketAuthenticationHandler::kOnAuthRequired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in WebSocketAuthenticationHandler.OnAuthRequired request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in WebSocketAuthenticationHandler.OnAuthRequired request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_endpoint)::BaseType> remote_endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_remote_endpoint,
    remote_endpoint_fragment);

  params->remote_endpoint.Set(
      remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_endpoint in WebSocketAuthenticationHandler.OnAuthRequired request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketAuthenticationHandler::Name_);
  message.set_method_name("OnAuthRequired");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebSocketAuthenticationHandler::OnAuthRequiredCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder> proxy(
        new WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebSocketAuthenticationHandler::OnAuthRequiredCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::net::AuthCredentials>& in_credentials);
};

bool WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebSocketAuthenticationHandler.0
  bool success = true;
  std::optional<::net::AuthCredentials> p_credentials{};
  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCredentials(&p_credentials))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebSocketAuthenticationHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_credentials));
  }
  return true;
}

void WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder::Run(
    const std::optional<::net::AuthCredentials>& in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::WebSocketAuthenticationHandler::OnAuthRequired", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials"), in_credentials,
                        "<value of type const std::optional<::net::AuthCredentials>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketAuthenticationHandler::kOnAuthRequired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credentials)::BaseType> credentials_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
    in_credentials,
    credentials_fragment);

  params->credentials.Set(
      credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketAuthenticationHandler::Name_);
  message.set_method_name("OnAuthRequired");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebSocketAuthenticationHandlerStubDispatch::Accept(
    WebSocketAuthenticationHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebSocketAuthenticationHandler>(message->header()->name)) {
    case messages::WebSocketAuthenticationHandler::kOnAuthRequired: {
      break;
    }
  }
  return false;
}

// static
bool WebSocketAuthenticationHandlerStubDispatch::AcceptWithResponder(
    WebSocketAuthenticationHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebSocketAuthenticationHandler>(message->header()->name)) {
    case messages::WebSocketAuthenticationHandler::kOnAuthRequired: {
      internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data* params =
          reinterpret_cast<
              internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebSocketAuthenticationHandler.0
      bool success = true;
      ::net::AuthChallengeInfo p_info{};
      ::scoped_refptr<::net::HttpResponseHeaders> p_headers{};
      ::net::IPEndPoint p_remote_endpoint{};
      WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRemoteEndpoint(&p_remote_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketAuthenticationHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthRequired(        
        std::move(p_info), 
        std::move(p_headers), 
        std::move(p_remote_endpoint), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketAuthenticationHandlerValidationInfo[] = {
    {base::to_underlying(messages::WebSocketAuthenticationHandler::kOnAuthRequired),
     { &internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data::Validate,
      &internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data::Validate}},
};

bool WebSocketAuthenticationHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::WebSocketAuthenticationHandler::Name_,
    kWebSocketAuthenticationHandlerValidationInfo);
}

bool WebSocketAuthenticationHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::WebSocketAuthenticationHandler::Name_,
    kWebSocketAuthenticationHandlerValidationInfo);

}
// The declaration includes the definition on other builds.

WebSocketHandshakeClient::IPCStableHashFunction WebSocketHandshakeClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebSocketHandshakeClient>(message.name())) {
    case messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted: {
      return &WebSocketHandshakeClient::OnOpeningHandshakeStarted_Sym::IPCStableHash;
    }
    case messages::WebSocketHandshakeClient::kOnFailure: {
      return &WebSocketHandshakeClient::OnFailure_Sym::IPCStableHash;
    }
    case messages::WebSocketHandshakeClient::kOnConnectionEstablished: {
      return &WebSocketHandshakeClient::OnConnectionEstablished_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebSocketHandshakeClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebSocketHandshakeClient>(message.name())) {
      case messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted:
            return "Receive network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted";
      case messages::WebSocketHandshakeClient::kOnFailure:
            return "Receive network::mojom::WebSocketHandshakeClient::OnFailure";
      case messages::WebSocketHandshakeClient::kOnConnectionEstablished:
            return "Receive network::mojom::WebSocketHandshakeClient::OnConnectionEstablished";
    }
  } else {
    switch (static_cast<messages::WebSocketHandshakeClient>(message.name())) {
      case messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted:
            return "Receive reply network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted";
      case messages::WebSocketHandshakeClient::kOnFailure:
            return "Receive reply network::mojom::WebSocketHandshakeClient::OnFailure";
      case messages::WebSocketHandshakeClient::kOnConnectionEstablished:
            return "Receive reply network::mojom::WebSocketHandshakeClient::OnConnectionEstablished";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebSocketHandshakeClient::OnOpeningHandshakeStarted_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a9a3826;  // IPCStableHash for network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebSocketHandshakeClient::OnFailure_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcdd21157;  // IPCStableHash for network::mojom::WebSocketHandshakeClient::OnFailure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebSocketHandshakeClient::OnConnectionEstablished_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x231323b9;  // IPCStableHash for network::mojom::WebSocketHandshakeClient::OnConnectionEstablished
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebSocketHandshakeClientProxy::WebSocketHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketHandshakeClientProxy::OnOpeningHandshakeStarted(
    WebSocketHandshakeRequestPtr in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type WebSocketHandshakeRequestPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebSocketHandshakeRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in WebSocketHandshakeClient.OnOpeningHandshakeStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnOpeningHandshakeStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebSocketHandshakeClientProxy::OnFailure(
    const std::string& in_message, int32_t in_net_error, int32_t in_response_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocketHandshakeClient::OnFailure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_code"), in_response_code,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketHandshakeClient::kOnFailure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketHandshakeClient_OnFailure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in WebSocketHandshakeClient.OnFailure request");

  params->net_error = in_net_error;

  params->response_code = in_response_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnFailure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebSocketHandshakeClientProxy::OnConnectionEstablished(
    ::mojo::PendingRemote<WebSocket> in_socket, ::mojo::PendingReceiver<WebSocketClient> in_client_receiver, WebSocketHandshakeResponsePtr in_response, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocketHandshakeClient::OnConnectionEstablished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingRemote<WebSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_receiver"), in_client_receiver,
                        "<value of type ::mojo::PendingReceiver<WebSocketClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type WebSocketHandshakeResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketHandshakeClient::kOnConnectionEstablished), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketInterfaceBase>>(
    in_socket,
    &params->socket,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->socket)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid socket in WebSocketHandshakeClient.OnConnectionEstablished request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebSocketClientInterfaceBase>>(
    in_client_receiver,
    &params->client_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_receiver in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebSocketHandshakeResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in WebSocketHandshakeClient.OnConnectionEstablished request");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_readable,
    &params->readable,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->readable)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid readable in WebSocketHandshakeClient.OnConnectionEstablished request");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_writable,
    &params->writable,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->writable)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid writable in WebSocketHandshakeClient.OnConnectionEstablished request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnConnectionEstablished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebSocketHandshakeClientStubDispatch::Accept(
    WebSocketHandshakeClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebSocketHandshakeClient>(message->header()->name)) {
    case messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted: {
      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketHandshakeClient.0
      bool success = true;
      WebSocketHandshakeRequestPtr p_request{};
      WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOpeningHandshakeStarted(        
        std::move(p_request));
      return true;
    }
    case messages::WebSocketHandshakeClient::kOnFailure: {
      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnFailure_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnFailure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketHandshakeClient.1
      bool success = true;
      std::string p_message{};
      int32_t p_net_error{};
      int32_t p_response_code{};
      WebSocketHandshakeClient_OnFailure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (success)
        p_response_code = input_data_view.response_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFailure(        
        std::move(p_message), 
        std::move(p_net_error), 
        std::move(p_response_code));
      return true;
    }
    case messages::WebSocketHandshakeClient::kOnConnectionEstablished: {
      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketHandshakeClient.2
      bool success = true;
      ::mojo::PendingRemote<WebSocket> p_socket{};
      ::mojo::PendingReceiver<WebSocketClient> p_client_receiver{};
      WebSocketHandshakeResponsePtr p_response{};
      ::mojo::ScopedDataPipeConsumerHandle p_readable{};
      ::mojo::ScopedDataPipeProducerHandle p_writable{};
      WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_client_receiver =
            input_data_view.TakeClientReceiver<decltype(p_client_receiver)>();
      }
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success)
        p_readable = input_data_view.TakeReadable();
      if (success)
        p_writable = input_data_view.TakeWritable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionEstablished(        
        std::move(p_socket), 
        std::move(p_client_receiver), 
        std::move(p_response), 
        std::move(p_readable), 
        std::move(p_writable));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketHandshakeClientStubDispatch::AcceptWithResponder(
    WebSocketHandshakeClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebSocketHandshakeClient>(message->header()->name)) {
    case messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted: {
      break;
    }
    case messages::WebSocketHandshakeClient::kOnFailure: {
      break;
    }
    case messages::WebSocketHandshakeClient::kOnConnectionEstablished: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketHandshakeClientValidationInfo[] = {
    {base::to_underlying(messages::WebSocketHandshakeClient::kOnOpeningHandshakeStarted),
     { &internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebSocketHandshakeClient::kOnFailure),
     { &internal::WebSocketHandshakeClient_OnFailure_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebSocketHandshakeClient::kOnConnectionEstablished),
     { &internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketHandshakeClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::WebSocketHandshakeClient::Name_,
    kWebSocketHandshakeClientValidationInfo);
}

// The declaration includes the definition on other builds.

WebSocketClient::IPCStableHashFunction WebSocketClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebSocketClient>(message.name())) {
    case messages::WebSocketClient::kOnDataFrame: {
      return &WebSocketClient::OnDataFrame_Sym::IPCStableHash;
    }
    case messages::WebSocketClient::kOnDropChannel: {
      return &WebSocketClient::OnDropChannel_Sym::IPCStableHash;
    }
    case messages::WebSocketClient::kOnClosingHandshake: {
      return &WebSocketClient::OnClosingHandshake_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebSocketClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebSocketClient>(message.name())) {
      case messages::WebSocketClient::kOnDataFrame:
            return "Receive network::mojom::WebSocketClient::OnDataFrame";
      case messages::WebSocketClient::kOnDropChannel:
            return "Receive network::mojom::WebSocketClient::OnDropChannel";
      case messages::WebSocketClient::kOnClosingHandshake:
            return "Receive network::mojom::WebSocketClient::OnClosingHandshake";
    }
  } else {
    switch (static_cast<messages::WebSocketClient>(message.name())) {
      case messages::WebSocketClient::kOnDataFrame:
            return "Receive reply network::mojom::WebSocketClient::OnDataFrame";
      case messages::WebSocketClient::kOnDropChannel:
            return "Receive reply network::mojom::WebSocketClient::OnDropChannel";
      case messages::WebSocketClient::kOnClosingHandshake:
            return "Receive reply network::mojom::WebSocketClient::OnClosingHandshake";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebSocketClient::OnDataFrame_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35b7afa9;  // IPCStableHash for network::mojom::WebSocketClient::OnDataFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebSocketClient::OnDropChannel_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c2e46b0;  // IPCStableHash for network::mojom::WebSocketClient::OnDropChannel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebSocketClient::OnClosingHandshake_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf51e408;  // IPCStableHash for network::mojom::WebSocketClient::OnClosingHandshake
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebSocketClientProxy::WebSocketClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketClientProxy::OnDataFrame(
    bool in_fin, WebSocketMessageType in_type, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocketClient::OnDataFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fin"), in_fin,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebSocketMessageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_length"), in_data_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketClient::kOnDataFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketClient_OnDataFrame_Params_Data> params(
          message);
  params.Allocate();

  params->fin = in_fin;

  
  mojo::internal::Serialize<::network::mojom::WebSocketMessageType>(
    in_type,
    &params->type);

  params->data_length = in_data_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnDataFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebSocketClientProxy::OnDropChannel(
    bool in_was_clean, uint16_t in_code, const std::string& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocketClient::OnDropChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_clean"), in_was_clean,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketClient::kOnDropChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketClient_OnDropChannel_Params_Data> params(
          message);
  params.Allocate();

  params->was_clean = in_was_clean;

  params->code = in_code;
  mojo::internal::MessageFragment<
      typename decltype(params->reason)::BaseType> reason_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_reason,
    reason_fragment);

  params->reason.Set(
      reason_fragment.is_null() ? nullptr : reason_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reason.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reason in WebSocketClient.OnDropChannel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnDropChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebSocketClientProxy::OnClosingHandshake(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::WebSocketClient::OnClosingHandshake");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketClient::kOnClosingHandshake), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketClient_OnClosingHandshake_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnClosingHandshake");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebSocketClientStubDispatch::Accept(
    WebSocketClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebSocketClient>(message->header()->name)) {
    case messages::WebSocketClient::kOnDataFrame: {
      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnDataFrame_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnDataFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketClient.0
      bool success = true;
      bool p_fin{};
      WebSocketMessageType p_type{};
      uint64_t p_data_length{};
      WebSocketClient_OnDataFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_fin = input_data_view.fin();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDataFrame(        
        std::move(p_fin), 
        std::move(p_type), 
        std::move(p_data_length));
      return true;
    }
    case messages::WebSocketClient::kOnDropChannel: {
      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnDropChannel_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnDropChannel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketClient.1
      bool success = true;
      bool p_was_clean{};
      uint16_t p_code{};
      std::string p_reason{};
      WebSocketClient_OnDropChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_was_clean = input_data_view.was_clean();
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDropChannel(        
        std::move(p_was_clean), 
        std::move(p_code), 
        std::move(p_reason));
      return true;
    }
    case messages::WebSocketClient::kOnClosingHandshake: {
      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnClosingHandshake_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnClosingHandshake_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketClient.2
      bool success = true;
      WebSocketClient_OnClosingHandshake_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosingHandshake(        );
      return true;
    }
  }
  return false;
}

// static
bool WebSocketClientStubDispatch::AcceptWithResponder(
    WebSocketClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebSocketClient>(message->header()->name)) {
    case messages::WebSocketClient::kOnDataFrame: {
      break;
    }
    case messages::WebSocketClient::kOnDropChannel: {
      break;
    }
    case messages::WebSocketClient::kOnClosingHandshake: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketClientValidationInfo[] = {
    {base::to_underlying(messages::WebSocketClient::kOnDataFrame),
     { &internal::WebSocketClient_OnDataFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebSocketClient::kOnDropChannel),
     { &internal::WebSocketClient_OnDropChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebSocketClient::kOnClosingHandshake),
     { &internal::WebSocketClient_OnClosingHandshake_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::WebSocketClient::Name_,
    kWebSocketClientValidationInfo);
}

// The declaration includes the definition on other builds.

WebSocket::IPCStableHashFunction WebSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebSocket>(message.name())) {
    case messages::WebSocket::kSendMessage: {
      return &WebSocket::SendMessage_Sym::IPCStableHash;
    }
    case messages::WebSocket::kStartReceiving: {
      return &WebSocket::StartReceiving_Sym::IPCStableHash;
    }
    case messages::WebSocket::kStartClosingHandshake: {
      return &WebSocket::StartClosingHandshake_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebSocket>(message.name())) {
      case messages::WebSocket::kSendMessage:
            return "Receive network::mojom::WebSocket::SendMessage";
      case messages::WebSocket::kStartReceiving:
            return "Receive network::mojom::WebSocket::StartReceiving";
      case messages::WebSocket::kStartClosingHandshake:
            return "Receive network::mojom::WebSocket::StartClosingHandshake";
    }
  } else {
    switch (static_cast<messages::WebSocket>(message.name())) {
      case messages::WebSocket::kSendMessage:
            return "Receive reply network::mojom::WebSocket::SendMessage";
      case messages::WebSocket::kStartReceiving:
            return "Receive reply network::mojom::WebSocket::StartReceiving";
      case messages::WebSocket::kStartClosingHandshake:
            return "Receive reply network::mojom::WebSocket::StartClosingHandshake";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebSocket::SendMessage_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74376a17;  // IPCStableHash for network::mojom::WebSocket::SendMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebSocket::StartReceiving_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b8b11b9;  // IPCStableHash for network::mojom::WebSocket::StartReceiving
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebSocket::StartClosingHandshake_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84486f3d;  // IPCStableHash for network::mojom::WebSocket::StartClosingHandshake
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebSocketProxy::WebSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketProxy::SendMessage(
    WebSocketMessageType in_type, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocket::SendMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebSocketMessageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_length"), in_data_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocket::kSendMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocket_SendMessage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::WebSocketMessageType>(
    in_type,
    &params->type);

  params->data_length = in_data_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("SendMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebSocketProxy::StartReceiving(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::WebSocket::StartReceiving");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocket::kStartReceiving), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocket_StartReceiving_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("StartReceiving");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebSocketProxy::StartClosingHandshake(
    uint16_t in_code, const std::string& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebSocket::StartClosingHandshake", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocket::kStartClosingHandshake), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocket_StartClosingHandshake_Params_Data> params(
          message);
  params.Allocate();

  params->code = in_code;
  mojo::internal::MessageFragment<
      typename decltype(params->reason)::BaseType> reason_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_reason,
    reason_fragment);

  params->reason.Set(
      reason_fragment.is_null() ? nullptr : reason_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reason.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reason in WebSocket.StartClosingHandshake request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("StartClosingHandshake");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebSocketStubDispatch::Accept(
    WebSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebSocket>(message->header()->name)) {
    case messages::WebSocket::kSendMessage: {
      DCHECK(message->is_serialized());
      internal::WebSocket_SendMessage_Params_Data* params =
          reinterpret_cast<internal::WebSocket_SendMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocket.0
      bool success = true;
      WebSocketMessageType p_type{};
      uint64_t p_data_length{};
      WebSocket_SendMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessage(        
        std::move(p_type), 
        std::move(p_data_length));
      return true;
    }
    case messages::WebSocket::kStartReceiving: {
      DCHECK(message->is_serialized());
      internal::WebSocket_StartReceiving_Params_Data* params =
          reinterpret_cast<internal::WebSocket_StartReceiving_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocket.1
      bool success = true;
      WebSocket_StartReceiving_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartReceiving(        );
      return true;
    }
    case messages::WebSocket::kStartClosingHandshake: {
      DCHECK(message->is_serialized());
      internal::WebSocket_StartClosingHandshake_Params_Data* params =
          reinterpret_cast<internal::WebSocket_StartClosingHandshake_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocket.2
      bool success = true;
      uint16_t p_code{};
      std::string p_reason{};
      WebSocket_StartClosingHandshake_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartClosingHandshake(        
        std::move(p_code), 
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketStubDispatch::AcceptWithResponder(
    WebSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebSocket>(message->header()->name)) {
    case messages::WebSocket::kSendMessage: {
      break;
    }
    case messages::WebSocket::kStartReceiving: {
      break;
    }
    case messages::WebSocket::kStartClosingHandshake: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketValidationInfo[] = {
    {base::to_underlying(messages::WebSocket::kSendMessage),
     { &internal::WebSocket_SendMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebSocket::kStartReceiving),
     { &internal::WebSocket_StartReceiving_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebSocket::kStartClosingHandshake),
     { &internal::WebSocket_StartClosingHandshake_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::WebSocket::Name_,
    kWebSocketValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::HttpHeader::DataView, ::network::mojom::HttpHeaderPtr>::Read(
    ::network::mojom::HttpHeader::DataView input,
    ::network::mojom::HttpHeaderPtr* output) {
  bool success = true;
  ::network::mojom::HttpHeaderPtr result(::network::mojom::HttpHeader::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::WebSocketHandshakeRequest::DataView, ::network::mojom::WebSocketHandshakeRequestPtr>::Read(
    ::network::mojom::WebSocketHandshakeRequest::DataView input,
    ::network::mojom::WebSocketHandshakeRequestPtr* output) {
  bool success = true;
  ::network::mojom::WebSocketHandshakeRequestPtr result(::network::mojom::WebSocketHandshakeRequest::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadHeadersText(&result->headers_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::WebSocketHandshakeResponse::DataView, ::network::mojom::WebSocketHandshakeResponsePtr>::Read(
    ::network::mojom::WebSocketHandshakeResponse::DataView input,
    ::network::mojom::WebSocketHandshakeResponsePtr* output) {
  bool success = true;
  ::network::mojom::WebSocketHandshakeResponsePtr result(::network::mojom::WebSocketHandshakeResponse::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHttpVersion(&result->http_version))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadStatusText(&result->status_text))
        success = false;
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadHeadersText(&result->headers_text))
        success = false;
      if (success && !input.ReadSelectedProtocol(&result->selected_protocol))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void WebSocketAuthenticationHandlerInterceptorForTesting::OnAuthRequired(const ::net::AuthChallengeInfo& info, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, const ::net::IPEndPoint& remote_endpoint, OnAuthRequiredCallback callback) {
  GetForwardingInterface()->OnAuthRequired(
    std::move(info)
    , 
    std::move(headers)
    , 
    std::move(remote_endpoint)
    , std::move(callback));
}
WebSocketAuthenticationHandlerAsyncWaiter::WebSocketAuthenticationHandlerAsyncWaiter(
    WebSocketAuthenticationHandler* proxy) : proxy_(proxy) {}

WebSocketAuthenticationHandlerAsyncWaiter::~WebSocketAuthenticationHandlerAsyncWaiter() = default;


void WebSocketAuthenticationHandlerAsyncWaiter::OnAuthRequired(
    const ::net::AuthChallengeInfo& info, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, const ::net::IPEndPoint& remote_endpoint, std::optional<::net::AuthCredentials>* out_credentials) {
  base::RunLoop loop;
  proxy_->OnAuthRequired(
      std::move(info),
      std::move(headers),
      std::move(remote_endpoint),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::net::AuthCredentials>* out_credentials
,
             const std::optional<::net::AuthCredentials>& credentials) {*out_credentials = std::move(credentials);
            loop->Quit();
          },
          &loop,
          out_credentials));
  loop.Run();
}

std::optional<::net::AuthCredentials> WebSocketAuthenticationHandlerAsyncWaiter::OnAuthRequired(
    const ::net::AuthChallengeInfo& info, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, const ::net::IPEndPoint& remote_endpoint) {
  std::optional<::net::AuthCredentials> async_wait_result;
  OnAuthRequired(std::move(info),std::move(headers),std::move(remote_endpoint),&async_wait_result);
  return async_wait_result;
}




void WebSocketHandshakeClientInterceptorForTesting::OnOpeningHandshakeStarted(WebSocketHandshakeRequestPtr request) {
  GetForwardingInterface()->OnOpeningHandshakeStarted(
    std::move(request)
    );
}
void WebSocketHandshakeClientInterceptorForTesting::OnFailure(const std::string& message, int32_t net_error, int32_t response_code) {
  GetForwardingInterface()->OnFailure(
    std::move(message)
    , 
    std::move(net_error)
    , 
    std::move(response_code)
    );
}
void WebSocketHandshakeClientInterceptorForTesting::OnConnectionEstablished(::mojo::PendingRemote<WebSocket> socket, ::mojo::PendingReceiver<WebSocketClient> client_receiver, WebSocketHandshakeResponsePtr response, ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable) {
  GetForwardingInterface()->OnConnectionEstablished(
    std::move(socket)
    , 
    std::move(client_receiver)
    , 
    std::move(response)
    , 
    std::move(readable)
    , 
    std::move(writable)
    );
}
WebSocketHandshakeClientAsyncWaiter::WebSocketHandshakeClientAsyncWaiter(
    WebSocketHandshakeClient* proxy) : proxy_(proxy) {}

WebSocketHandshakeClientAsyncWaiter::~WebSocketHandshakeClientAsyncWaiter() = default;





void WebSocketClientInterceptorForTesting::OnDataFrame(bool fin, WebSocketMessageType type, uint64_t data_length) {
  GetForwardingInterface()->OnDataFrame(
    std::move(fin)
    , 
    std::move(type)
    , 
    std::move(data_length)
    );
}
void WebSocketClientInterceptorForTesting::OnDropChannel(bool was_clean, uint16_t code, const std::string& reason) {
  GetForwardingInterface()->OnDropChannel(
    std::move(was_clean)
    , 
    std::move(code)
    , 
    std::move(reason)
    );
}
void WebSocketClientInterceptorForTesting::OnClosingHandshake() {
  GetForwardingInterface()->OnClosingHandshake();
}
WebSocketClientAsyncWaiter::WebSocketClientAsyncWaiter(
    WebSocketClient* proxy) : proxy_(proxy) {}

WebSocketClientAsyncWaiter::~WebSocketClientAsyncWaiter() = default;





void WebSocketInterceptorForTesting::SendMessage(WebSocketMessageType type, uint64_t data_length) {
  GetForwardingInterface()->SendMessage(
    std::move(type)
    , 
    std::move(data_length)
    );
}
void WebSocketInterceptorForTesting::StartReceiving() {
  GetForwardingInterface()->StartReceiving();
}
void WebSocketInterceptorForTesting::StartClosingHandshake(uint16_t code, const std::string& reason) {
  GetForwardingInterface()->StartClosingHandshake(
    std::move(code)
    , 
    std::move(reason)
    );
}
WebSocketAsyncWaiter::WebSocketAsyncWaiter(
    WebSocket* proxy) : proxy_(proxy) {}

WebSocketAsyncWaiter::~WebSocketAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif