// services/network/public/mojom/trust_token_access_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/trust_token_access_observer.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class TrustTokenAccessObserverProxy;

template <typename ImplRefTraits>
class TrustTokenAccessObserverStub;

class TrustTokenAccessObserverRequestValidator;


class TrustTokenAccessObserver
    : public TrustTokenAccessObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TrustTokenAccessObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustTokenAccessObserverInterfaceBase;
  using Proxy_ = TrustTokenAccessObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustTokenAccessObserverStub<ImplRefTraits>;

  using RequestValidator_ = TrustTokenAccessObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTrustTokensAccessedMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTrustTokensAccessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustTokenAccessObserver() = default;

  virtual void OnTrustTokensAccessed(TrustTokenAccessDetailsPtr details) = 0;

  virtual void Clone(::mojo::PendingReceiver<TrustTokenAccessObserver> listener) = 0;
};



class  TrustTokenAccessObserverProxy
    : public TrustTokenAccessObserver {
 public:
  using InterfaceType = TrustTokenAccessObserver;

  explicit TrustTokenAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTrustTokensAccessed(TrustTokenAccessDetailsPtr details) final;
  
  void Clone(::mojo::PendingReceiver<TrustTokenAccessObserver> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TrustTokenAccessObserverStubDispatch {
 public:
  static bool Accept(TrustTokenAccessObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustTokenAccessObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustTokenAccessObserver>>
class TrustTokenAccessObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustTokenAccessObserverStub() = default;
  ~TrustTokenAccessObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustTokenAccessObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustTokenAccessObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustTokenAccessObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  TrustTokenAccessDetails {
 public:
  using DataView = TrustTokenAccessDetailsDataView;
  using Data_ = internal::TrustTokenAccessDetails_Data;
  using Tag = Data_::TrustTokenAccessDetails_Tag;

  template <typename... Args>
  static TrustTokenAccessDetailsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |issuance|.
  static TrustTokenAccessDetailsPtr NewIssuance(
      TrustTokenIssuanceDetailsPtr value);
  // Construct an instance holding |redemption|.
  static TrustTokenAccessDetailsPtr NewRedemption(
      TrustTokenRedemptionDetailsPtr value);
  // Construct an instance holding |signing|.
  static TrustTokenAccessDetailsPtr NewSigning(
      TrustTokenSigningDetailsPtr value);

  template <typename U>
  static TrustTokenAccessDetailsPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenAccessDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenAccessDetails>::Convert(*this);
  }
  ~TrustTokenAccessDetails();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TrustTokenAccessDetails(const TrustTokenAccessDetails& other) = delete;
  TrustTokenAccessDetails& operator=(const TrustTokenAccessDetails& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TrustTokenAccessDetailsPtr>
  TrustTokenAccessDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TrustTokenAccessDetails>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TrustTokenAccessDetails>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_issuance() const { return tag_ == Tag::kIssuance; }
  const TrustTokenIssuanceDetailsPtr& get_issuance() const {
    CHECK(tag_ == Tag::kIssuance);
    return data_.issuance;
  }
  TrustTokenIssuanceDetailsPtr& get_issuance() {
    CHECK(tag_ == Tag::kIssuance);
    return data_.issuance;
  }
  void set_issuance(TrustTokenIssuanceDetailsPtr issuance);

  bool is_redemption() const { return tag_ == Tag::kRedemption; }
  const TrustTokenRedemptionDetailsPtr& get_redemption() const {
    CHECK(tag_ == Tag::kRedemption);
    return data_.redemption;
  }
  TrustTokenRedemptionDetailsPtr& get_redemption() {
    CHECK(tag_ == Tag::kRedemption);
    return data_.redemption;
  }
  void set_redemption(TrustTokenRedemptionDetailsPtr redemption);

  bool is_signing() const { return tag_ == Tag::kSigning; }
  const TrustTokenSigningDetailsPtr& get_signing() const {
    CHECK(tag_ == Tag::kSigning);
    return data_.signing;
  }
  TrustTokenSigningDetailsPtr& get_signing() {
    CHECK(tag_ == Tag::kSigning);
    return data_.signing;
  }
  void set_signing(TrustTokenSigningDetailsPtr signing);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenAccessDetails::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TrustTokenAccessDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIssuance)>,
        TrustTokenIssuanceDetailsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRedemption)>,
        TrustTokenRedemptionDetailsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSigning)>,
        TrustTokenSigningDetailsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TrustTokenIssuanceDetailsPtr issuance;
    TrustTokenRedemptionDetailsPtr redemption;
    TrustTokenSigningDetailsPtr signing;
  };

  TrustTokenAccessDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kIssuance)>,
      TrustTokenIssuanceDetailsPtr value);
  TrustTokenAccessDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kRedemption)>,
      TrustTokenRedemptionDetailsPtr value);
  TrustTokenAccessDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kSigning)>,
      TrustTokenSigningDetailsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  TrustTokenIssuanceDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenIssuanceDetails, T>::value>;
  using DataView = TrustTokenIssuanceDetailsDataView;
  using Data_ = internal::TrustTokenIssuanceDetails_Data;

  template <typename... Args>
  static TrustTokenIssuanceDetailsPtr New(Args&&... args) {
    return TrustTokenIssuanceDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenIssuanceDetailsPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenIssuanceDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenIssuanceDetails>::Convert(*this);
  }


  TrustTokenIssuanceDetails();

  TrustTokenIssuanceDetails(
      const ::url::Origin& origin,
      const std::optional<::url::Origin>& issuer,
      bool blocked);


  ~TrustTokenIssuanceDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenIssuanceDetailsPtr>
  TrustTokenIssuanceDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenIssuanceDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenIssuanceDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenIssuanceDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenIssuanceDetails_UnserializedMessageContext<
            UserType, TrustTokenIssuanceDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenIssuanceDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenIssuanceDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenIssuanceDetails_UnserializedMessageContext<
            UserType, TrustTokenIssuanceDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenIssuanceDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::optional<::url::Origin> issuer;
  
  bool blocked;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TrustTokenRedemptionDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenRedemptionDetails, T>::value>;
  using DataView = TrustTokenRedemptionDetailsDataView;
  using Data_ = internal::TrustTokenRedemptionDetails_Data;

  template <typename... Args>
  static TrustTokenRedemptionDetailsPtr New(Args&&... args) {
    return TrustTokenRedemptionDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenRedemptionDetailsPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenRedemptionDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenRedemptionDetails>::Convert(*this);
  }


  TrustTokenRedemptionDetails();

  TrustTokenRedemptionDetails(
      const ::url::Origin& origin,
      const std::optional<::url::Origin>& issuer,
      bool blocked);


  ~TrustTokenRedemptionDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenRedemptionDetailsPtr>
  TrustTokenRedemptionDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenRedemptionDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenRedemptionDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenRedemptionDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenRedemptionDetails_UnserializedMessageContext<
            UserType, TrustTokenRedemptionDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenRedemptionDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenRedemptionDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenRedemptionDetails_UnserializedMessageContext<
            UserType, TrustTokenRedemptionDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenRedemptionDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::optional<::url::Origin> issuer;
  
  bool blocked;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TrustTokenSigningDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenSigningDetails, T>::value>;
  using DataView = TrustTokenSigningDetailsDataView;
  using Data_ = internal::TrustTokenSigningDetails_Data;

  template <typename... Args>
  static TrustTokenSigningDetailsPtr New(Args&&... args) {
    return TrustTokenSigningDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenSigningDetailsPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenSigningDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenSigningDetails>::Convert(*this);
  }


  TrustTokenSigningDetails();

  TrustTokenSigningDetails(
      const ::url::Origin& origin,
      bool blocked);


  ~TrustTokenSigningDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenSigningDetailsPtr>
  TrustTokenSigningDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenSigningDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenSigningDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenSigningDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenSigningDetails_UnserializedMessageContext<
            UserType, TrustTokenSigningDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenSigningDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenSigningDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenSigningDetails_UnserializedMessageContext<
            UserType, TrustTokenSigningDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenSigningDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  bool blocked;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenSigningDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
TrustTokenAccessDetailsPtr TrustTokenAccessDetails::Clone() const {
  switch (tag_) {
    case Tag::kIssuance:
      return NewIssuance(
          mojo::Clone(data_.issuance));
    case Tag::kRedemption:
      return NewRedemption(
          mojo::Clone(data_.redemption));
    case Tag::kSigning:
      return NewSigning(
          mojo::Clone(data_.signing));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TrustTokenAccessDetails>::value>::type*>
bool TrustTokenAccessDetails::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kIssuance:
      return mojo::Equals(data_.issuance, other.data_.issuance);
    case Tag::kRedemption:
      return mojo::Equals(data_.redemption, other.data_.redemption);
    case Tag::kSigning:
      return mojo::Equals(data_.signing, other.data_.signing);
  }

  return false;
}
template <typename StructPtrType>
TrustTokenIssuanceDetailsPtr TrustTokenIssuanceDetails::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(issuer),
      mojo::Clone(blocked)
  );
}

template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>*>
bool TrustTokenIssuanceDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->blocked, other_struct.blocked))
    return false;
  return true;
}

template <typename T, TrustTokenIssuanceDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.blocked < rhs.blocked)
    return true;
  if (rhs.blocked < lhs.blocked)
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenRedemptionDetailsPtr TrustTokenRedemptionDetails::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(issuer),
      mojo::Clone(blocked)
  );
}

template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>*>
bool TrustTokenRedemptionDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->blocked, other_struct.blocked))
    return false;
  return true;
}

template <typename T, TrustTokenRedemptionDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.blocked < rhs.blocked)
    return true;
  if (rhs.blocked < lhs.blocked)
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenSigningDetailsPtr TrustTokenSigningDetails::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(blocked)
  );
}

template <typename T, TrustTokenSigningDetails::EnableIfSame<T>*>
bool TrustTokenSigningDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->blocked, other_struct.blocked))
    return false;
  return true;
}

template <typename T, TrustTokenSigningDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.blocked < rhs.blocked)
    return true;
  if (rhs.blocked < lhs.blocked)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::TrustTokenIssuanceDetails::DataView,
                                         ::network::mojom::TrustTokenIssuanceDetailsPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenIssuanceDetailsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenIssuanceDetailsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::TrustTokenIssuanceDetails::origin)& origin(
      const ::network::mojom::TrustTokenIssuanceDetailsPtr& input) {
    return input->origin;
  }

  static const decltype(::network::mojom::TrustTokenIssuanceDetails::issuer)& issuer(
      const ::network::mojom::TrustTokenIssuanceDetailsPtr& input) {
    return input->issuer;
  }

  static decltype(::network::mojom::TrustTokenIssuanceDetails::blocked) blocked(
      const ::network::mojom::TrustTokenIssuanceDetailsPtr& input) {
    return input->blocked;
  }

  static bool Read(::network::mojom::TrustTokenIssuanceDetails::DataView input, ::network::mojom::TrustTokenIssuanceDetailsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TrustTokenRedemptionDetails::DataView,
                                         ::network::mojom::TrustTokenRedemptionDetailsPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenRedemptionDetailsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenRedemptionDetailsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::TrustTokenRedemptionDetails::origin)& origin(
      const ::network::mojom::TrustTokenRedemptionDetailsPtr& input) {
    return input->origin;
  }

  static const decltype(::network::mojom::TrustTokenRedemptionDetails::issuer)& issuer(
      const ::network::mojom::TrustTokenRedemptionDetailsPtr& input) {
    return input->issuer;
  }

  static decltype(::network::mojom::TrustTokenRedemptionDetails::blocked) blocked(
      const ::network::mojom::TrustTokenRedemptionDetailsPtr& input) {
    return input->blocked;
  }

  static bool Read(::network::mojom::TrustTokenRedemptionDetails::DataView input, ::network::mojom::TrustTokenRedemptionDetailsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TrustTokenSigningDetails::DataView,
                                         ::network::mojom::TrustTokenSigningDetailsPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenSigningDetailsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenSigningDetailsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::TrustTokenSigningDetails::origin)& origin(
      const ::network::mojom::TrustTokenSigningDetailsPtr& input) {
    return input->origin;
  }

  static decltype(::network::mojom::TrustTokenSigningDetails::blocked) blocked(
      const ::network::mojom::TrustTokenSigningDetailsPtr& input) {
    return input->blocked;
  }

  static bool Read(::network::mojom::TrustTokenSigningDetails::DataView input, ::network::mojom::TrustTokenSigningDetailsPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::TrustTokenAccessDetails::DataView,
                                        ::network::mojom::TrustTokenAccessDetailsPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenAccessDetailsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenAccessDetailsPtr* output) { output->reset(); }

  static ::network::mojom::TrustTokenAccessDetails::Tag GetTag(const ::network::mojom::TrustTokenAccessDetailsPtr& input) {
    return input->which();
  }

  static const ::network::mojom::TrustTokenIssuanceDetailsPtr& issuance(const ::network::mojom::TrustTokenAccessDetailsPtr& input) {
    return input->get_issuance();
  }

  static const ::network::mojom::TrustTokenRedemptionDetailsPtr& redemption(const ::network::mojom::TrustTokenAccessDetailsPtr& input) {
    return input->get_redemption();
  }

  static const ::network::mojom::TrustTokenSigningDetailsPtr& signing(const ::network::mojom::TrustTokenAccessDetailsPtr& input) {
    return input->get_signing();
  }

  static bool Read(::network::mojom::TrustTokenAccessDetails::DataView input, ::network::mojom::TrustTokenAccessDetailsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_H_