// services/network/public/mojom/cors.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cors.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"




#include "services/network/public/mojom/cors.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::CorsPreflightPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::CorsPreflightPolicy> {};

template <>
struct hash<::network::mojom::CorsError>
    : public mojo::internal::EnumHashImpl<::network::mojom::CorsError> {};

template <>
struct hash<::network::mojom::PrivateNetworkAccessPreflightResult>
    : public mojo::internal::EnumHashImpl<::network::mojom::PrivateNetworkAccessPreflightResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsPreflightPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CorsPreflightPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CorsPreflightPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CorsError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CorsError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::PrivateNetworkAccessPreflightResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::PrivateNetworkAccessPreflightResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::PrivateNetworkAccessPreflightResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CorsErrorStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CorsErrorStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CorsErrorStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::CorsError>(
      Traits::cors_error(input),
      &fragment->cors_error);

    decltype(Traits::failed_parameter(input)) in_failed_parameter = Traits::failed_parameter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->failed_parameter)::BaseType> failed_parameter_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_failed_parameter,
      failed_parameter_fragment);

    fragment->failed_parameter.Set(
        failed_parameter_fragment.is_null() ? nullptr : failed_parameter_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->failed_parameter.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null failed_parameter in CorsErrorStatus struct");

    
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      Traits::target_address_space(input),
      &fragment->target_address_space);

    
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      Traits::resource_address_space(input),
      &fragment->resource_address_space);

    fragment->has_authorization_covered_by_wildcard_on_preflight = Traits::has_authorization_covered_by_wildcard_on_preflight(input);

    decltype(Traits::issue_id(input)) in_issue_id = Traits::issue_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issue_id)::BaseType> issue_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_issue_id,
      issue_id_fragment);

    fragment->issue_id.Set(
        issue_id_fragment.is_null() ? nullptr : issue_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issue_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issue_id in CorsErrorStatus struct");
  }

  static bool Deserialize(::network::mojom::internal::CorsErrorStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CorsErrorStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CorsErrorStatusDataView::GetFailedParameterDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->failed_parameter.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CorsErrorStatusDataView::GetIssueIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->issue_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CorsPreflightPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CorsPreflightPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CorsError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CorsError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::PrivateNetworkAccessPreflightResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::PrivateNetworkAccessPreflightResult value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_SHARED_H_