// services/network/public/mojom/cookie_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cookie_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cookie_manager.mojom-params-data.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cookie_manager.mojom-blink-import-headers.h"
#include "services/network/public/mojom/cookie_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
CookieManagerParams::CookieManagerParams()
    : block_third_party_cookies(false),
      tracking_protection_enabled_for_3pcd(false),
      mitigations_enabled_for_3pcd(false),
      content_settings(),
      secure_origin_cookies_allowed_schemes(),
      matching_scheme_cookies_allowed_schemes(),
      third_party_cookies_allowed_schemes(),
      allow_file_scheme_cookies(false),
      cookie_access_delegate_type(CookieAccessDelegateType::USE_CONTENT_SETTINGS) {}

CookieManagerParams::CookieManagerParams(
    bool block_third_party_cookies_in,
    bool tracking_protection_enabled_for_3pcd_in,
    bool mitigations_enabled_for_3pcd_in,
    ::blink::HashMap<::content_settings::mojom::blink::ContentSettingsType, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>> content_settings_in,
    ::blink::Vector<::blink::String> secure_origin_cookies_allowed_schemes_in,
    ::blink::Vector<::blink::String> matching_scheme_cookies_allowed_schemes_in,
    ::blink::Vector<::blink::String> third_party_cookies_allowed_schemes_in,
    bool allow_file_scheme_cookies_in,
    CookieAccessDelegateType cookie_access_delegate_type_in)
    : block_third_party_cookies(std::move(block_third_party_cookies_in)),
      tracking_protection_enabled_for_3pcd(std::move(tracking_protection_enabled_for_3pcd_in)),
      mitigations_enabled_for_3pcd(std::move(mitigations_enabled_for_3pcd_in)),
      content_settings(std::move(content_settings_in)),
      secure_origin_cookies_allowed_schemes(std::move(secure_origin_cookies_allowed_schemes_in)),
      matching_scheme_cookies_allowed_schemes(std::move(matching_scheme_cookies_allowed_schemes_in)),
      third_party_cookies_allowed_schemes(std::move(third_party_cookies_allowed_schemes_in)),
      allow_file_scheme_cookies(std::move(allow_file_scheme_cookies_in)),
      cookie_access_delegate_type(std::move(cookie_access_delegate_type_in)) {}

CookieManagerParams::~CookieManagerParams() = default;

void CookieManagerParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_third_party_cookies"), this->block_third_party_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracking_protection_enabled_for_3pcd"), this->tracking_protection_enabled_for_3pcd,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mitigations_enabled_for_3pcd"), this->mitigations_enabled_for_3pcd,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_settings"), this->content_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<::content_settings::mojom::blink::ContentSettingsType, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_origin_cookies_allowed_schemes"), this->secure_origin_cookies_allowed_schemes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matching_scheme_cookies_allowed_schemes"), this->matching_scheme_cookies_allowed_schemes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "third_party_cookies_allowed_schemes"), this->third_party_cookies_allowed_schemes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_file_scheme_cookies"), this->allow_file_scheme_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_access_delegate_type"), this->cookie_access_delegate_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessDelegateType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieManagerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieSameSiteContextMetadata::CookieSameSiteContextMetadata()
    : cross_site_redirect_downgrade(CookieSameSiteContextMetadataDowngradeType::kNoDowngrade),
      redirect_type_bug_1221316(ContextRedirectTypeBug1221316::kUnset) {}

CookieSameSiteContextMetadata::CookieSameSiteContextMetadata(
    CookieSameSiteContextMetadataDowngradeType cross_site_redirect_downgrade_in,
    ContextRedirectTypeBug1221316 redirect_type_bug_1221316_in)
    : cross_site_redirect_downgrade(std::move(cross_site_redirect_downgrade_in)),
      redirect_type_bug_1221316(std::move(redirect_type_bug_1221316_in)) {}

CookieSameSiteContextMetadata::~CookieSameSiteContextMetadata() = default;
size_t CookieSameSiteContextMetadata::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->cross_site_redirect_downgrade);
  seed = mojo::internal::WTFHash(seed, this->redirect_type_bug_1221316);
  return seed;
}

void CookieSameSiteContextMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_site_redirect_downgrade"), this->cross_site_redirect_downgrade,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSameSiteContextMetadataDowngradeType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_type_bug_1221316"), this->redirect_type_bug_1221316,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContextRedirectTypeBug1221316>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieSameSiteContextMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieSameSiteContext::CookieSameSiteContext()
    : context(ContextType::CROSS_SITE),
      schemeful_context(ContextType::CROSS_SITE),
      metadata(),
      schemeful_metadata() {}

CookieSameSiteContext::CookieSameSiteContext(
    ContextType context_in,
    ContextType schemeful_context_in,
    CookieSameSiteContextMetadataPtr metadata_in,
    CookieSameSiteContextMetadataPtr schemeful_metadata_in)
    : context(std::move(context_in)),
      schemeful_context(std::move(schemeful_context_in)),
      metadata(std::move(metadata_in)),
      schemeful_metadata(std::move(schemeful_metadata_in)) {}

CookieSameSiteContext::~CookieSameSiteContext() = default;
size_t CookieSameSiteContext::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->context);
  seed = mojo::internal::WTFHash(seed, this->schemeful_context);
  seed = mojo::internal::WTFHash(seed, this->metadata);
  seed = mojo::internal::WTFHash(seed, this->schemeful_metadata);
  return seed;
}

void CookieSameSiteContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context"), this->context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "schemeful_context"), this->schemeful_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSameSiteContextMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "schemeful_metadata"), this->schemeful_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSameSiteContextMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieSameSiteContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOptions::CookieOptions()
    : exclude_httponly(true),
      same_site_cookie_context(),
      update_access_time(true),
      return_excluded_cookies(false) {}

CookieOptions::CookieOptions(
    bool exclude_httponly_in,
    CookieSameSiteContextPtr same_site_cookie_context_in,
    bool update_access_time_in,
    bool return_excluded_cookies_in)
    : exclude_httponly(std::move(exclude_httponly_in)),
      same_site_cookie_context(std::move(same_site_cookie_context_in)),
      update_access_time(std::move(update_access_time_in)),
      return_excluded_cookies(std::move(return_excluded_cookies_in)) {}

CookieOptions::~CookieOptions() = default;
size_t CookieOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->exclude_httponly);
  seed = mojo::internal::WTFHash(seed, this->same_site_cookie_context);
  seed = mojo::internal::WTFHash(seed, this->update_access_time);
  seed = mojo::internal::WTFHash(seed, this->return_excluded_cookies);
  return seed;
}

void CookieOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_httponly"), this->exclude_httponly,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_site_cookie_context"), this->same_site_cookie_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSameSiteContextPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_access_time"), this->update_access_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "return_excluded_cookies"), this->return_excluded_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CanonicalCookie::CanonicalCookie()
    : name(),
      value(),
      domain(),
      path(),
      creation(),
      expiry(),
      last_access(),
      last_update(),
      secure(false),
      httponly(false),
      site_restrictions(CookieSameSite::NO_RESTRICTION),
      priority(CookiePriority::MEDIUM),
      source_scheme(CookieSourceScheme::kUnset),
      partition_key(),
      source_port(-1),
      source_type(CookieSourceType::kUnknown) {}

CanonicalCookie::CanonicalCookie(
    const ::blink::String& name_in,
    const ::blink::String& value_in,
    const ::blink::String& domain_in,
    const ::blink::String& path_in,
    ::base::Time creation_in,
    ::base::Time expiry_in,
    ::base::Time last_access_in,
    ::base::Time last_update_in,
    bool secure_in,
    bool httponly_in,
    CookieSameSite site_restrictions_in,
    CookiePriority priority_in,
    CookieSourceScheme source_scheme_in,
    ::network::mojom::blink::CookiePartitionKeyPtr partition_key_in,
    int32_t source_port_in,
    CookieSourceType source_type_in)
    : name(std::move(name_in)),
      value(std::move(value_in)),
      domain(std::move(domain_in)),
      path(std::move(path_in)),
      creation(std::move(creation_in)),
      expiry(std::move(expiry_in)),
      last_access(std::move(last_access_in)),
      last_update(std::move(last_update_in)),
      secure(std::move(secure_in)),
      httponly(std::move(httponly_in)),
      site_restrictions(std::move(site_restrictions_in)),
      priority(std::move(priority_in)),
      source_scheme(std::move(source_scheme_in)),
      partition_key(std::move(partition_key_in)),
      source_port(std::move(source_port_in)),
      source_type(std::move(source_type_in)) {}

CanonicalCookie::~CanonicalCookie() = default;

void CanonicalCookie::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation"), this->creation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_access"), this->last_access,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_update"), this->last_update,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure"), this->secure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "httponly"), this->httponly,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_restrictions"), this->site_restrictions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSameSite>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookiePriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_scheme"), this->source_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSourceScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partition_key"), this->partition_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::CookiePartitionKeyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_port"), this->source_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_type"), this->source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CanonicalCookie::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExclusionReasons::ExclusionReasons()
    : exclusions_bitmask() {}

ExclusionReasons::ExclusionReasons(
    uint64_t exclusions_bitmask_in)
    : exclusions_bitmask(std::move(exclusions_bitmask_in)) {}

ExclusionReasons::~ExclusionReasons() = default;
size_t ExclusionReasons::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->exclusions_bitmask);
  return seed;
}

void ExclusionReasons::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusions_bitmask"), this->exclusions_bitmask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExclusionReasons::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WarningReasons::WarningReasons()
    : warnings_bitmask() {}

WarningReasons::WarningReasons(
    uint64_t warnings_bitmask_in)
    : warnings_bitmask(std::move(warnings_bitmask_in)) {}

WarningReasons::~WarningReasons() = default;
size_t WarningReasons::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->warnings_bitmask);
  return seed;
}

void WarningReasons::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "warnings_bitmask"), this->warnings_bitmask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WarningReasons::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieInclusionStatus::CookieInclusionStatus()
    : exclusion_reasons(),
      warning_reasons(),
      exemption_reason() {}

CookieInclusionStatus::CookieInclusionStatus(
    ExclusionReasonsPtr exclusion_reasons_in,
    WarningReasonsPtr warning_reasons_in,
    CookieExemptionReason exemption_reason_in)
    : exclusion_reasons(std::move(exclusion_reasons_in)),
      warning_reasons(std::move(warning_reasons_in)),
      exemption_reason(std::move(exemption_reason_in)) {}

CookieInclusionStatus::~CookieInclusionStatus() = default;

void CookieInclusionStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusion_reasons"), this->exclusion_reasons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ExclusionReasonsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "warning_reasons"), this->warning_reasons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WarningReasonsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exemption_reason"), this->exemption_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieExemptionReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieInclusionStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieAndLineWithAccessResult::CookieAndLineWithAccessResult()
    : cookie(),
      cookie_string(),
      access_result() {}

CookieAndLineWithAccessResult::CookieAndLineWithAccessResult(
    const std::optional<::net::CanonicalCookie>& cookie_in,
    const ::blink::String& cookie_string_in,
    CookieAccessResultPtr access_result_in)
    : cookie(std::move(cookie_in)),
      cookie_string(std::move(cookie_string_in)),
      access_result(std::move(access_result_in)) {}

CookieAndLineWithAccessResult::~CookieAndLineWithAccessResult() = default;

void CookieAndLineWithAccessResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::CanonicalCookie>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_string"), this->cookie_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieAndLineWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOrLineWithAccessResult::CookieOrLineWithAccessResult()
    : cookie_or_line(),
      access_result() {}

CookieOrLineWithAccessResult::CookieOrLineWithAccessResult(
    CookieOrLinePtr cookie_or_line_in,
    CookieAccessResultPtr access_result_in)
    : cookie_or_line(std::move(cookie_or_line_in)),
      access_result(std::move(access_result_in)) {}

CookieOrLineWithAccessResult::~CookieOrLineWithAccessResult() = default;

void CookieOrLineWithAccessResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_or_line"), this->cookie_or_line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieOrLinePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieOrLineWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieAccessResult::CookieAccessResult()
    : effective_same_site(),
      access_semantics(),
      scope_semantics(),
      status(),
      is_allowed_to_access_secure_cookies() {}

CookieAccessResult::CookieAccessResult(
    CookieEffectiveSameSite effective_same_site_in,
    CookieAccessSemantics access_semantics_in,
    CookieScopeSemantics scope_semantics_in,
    ::net::CookieInclusionStatus status_in,
    bool is_allowed_to_access_secure_cookies_in)
    : effective_same_site(std::move(effective_same_site_in)),
      access_semantics(std::move(access_semantics_in)),
      scope_semantics(std::move(scope_semantics_in)),
      status(std::move(status_in)),
      is_allowed_to_access_secure_cookies(std::move(is_allowed_to_access_secure_cookies_in)) {}

CookieAccessResult::~CookieAccessResult() = default;

void CookieAccessResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effective_same_site"), this->effective_same_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieEffectiveSameSite>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_semantics"), this->access_semantics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessSemantics>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope_semantics"), this->scope_semantics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieScopeSemantics>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::CookieInclusionStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_allowed_to_access_secure_cookies"), this->is_allowed_to_access_secure_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieWithAccessResult::CookieWithAccessResult()
    : cookie(),
      access_result() {}

CookieWithAccessResult::CookieWithAccessResult(
    const ::net::CanonicalCookie& cookie_in,
    CookieAccessResultPtr access_result_in)
    : cookie(std::move(cookie_in)),
      access_result(std::move(access_result_in)) {}

CookieWithAccessResult::~CookieWithAccessResult() = default;

void CookieWithAccessResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::CanonicalCookie&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieChangeInfo::CookieChangeInfo()
    : cookie(),
      access_result(),
      cause() {}

CookieChangeInfo::CookieChangeInfo(
    const ::net::CanonicalCookie& cookie_in,
    CookieAccessResultPtr access_result_in,
    CookieChangeCause cause_in)
    : cookie(std::move(cookie_in)),
      access_result(std::move(access_result_in)),
      cause(std::move(cause_in)) {}

CookieChangeInfo::~CookieChangeInfo() = default;

void CookieChangeInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::CanonicalCookie&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cause"), this->cause,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieChangeCause>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieChangeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieDeletionFilter::CookieDeletionFilter()
    : created_after_time(),
      created_before_time(),
      excluding_domains(),
      including_domains(),
      cookie_name(),
      host_name(),
      url(),
      session_control(CookieDeletionSessionControl::IGNORE_CONTROL),
      cookie_partition_key_collection(),
      partitioned_state_only() {}

CookieDeletionFilter::CookieDeletionFilter(
    std::optional<::base::Time> created_after_time_in,
    std::optional<::base::Time> created_before_time_in,
    std::optional<::blink::Vector<::blink::String>> excluding_domains_in,
    std::optional<::blink::Vector<::blink::String>> including_domains_in,
    const ::blink::String& cookie_name_in,
    const ::blink::String& host_name_in,
    const std::optional<::blink::KURL>& url_in,
    CookieDeletionSessionControl session_control_in,
    ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection_in,
    bool partitioned_state_only_in)
    : created_after_time(std::move(created_after_time_in)),
      created_before_time(std::move(created_before_time_in)),
      excluding_domains(std::move(excluding_domains_in)),
      including_domains(std::move(including_domains_in)),
      cookie_name(std::move(cookie_name_in)),
      host_name(std::move(host_name_in)),
      url(std::move(url_in)),
      session_control(std::move(session_control_in)),
      cookie_partition_key_collection(std::move(cookie_partition_key_collection_in)),
      partitioned_state_only(std::move(partitioned_state_only_in)) {}

CookieDeletionFilter::~CookieDeletionFilter() = default;

void CookieDeletionFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "created_after_time"), this->created_after_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "created_before_time"), this->created_before_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "excluding_domains"), this->excluding_domains,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "including_domains"), this->including_domains,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_name"), this->cookie_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_name"), this->host_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_control"), this->session_control,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieDeletionSessionControl>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_partition_key_collection"), this->cookie_partition_key_collection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::CookiePartitionKeyCollectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partitioned_state_only"), this->partitioned_state_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieDeletionFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOrLinePtr
CookieOrLine::NewCookie(
    const ::net::CanonicalCookie& value) {
  return CookieOrLinePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCookie)>,
      std::move(value));
}

CookieOrLinePtr
CookieOrLine::NewCookieString(
    const ::blink::String& value) {
  return CookieOrLinePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCookieString)>,
      std::move(value));
}

CookieOrLine::CookieOrLine(
    std::in_place_index_t<static_cast<size_t>(Tag::kCookie)>,
    const ::net::CanonicalCookie& value)
    : tag_(Tag::kCookie),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCookie)>,
            std::move(value)) {}

CookieOrLine::CookieOrLine(
    std::in_place_index_t<static_cast<size_t>(Tag::kCookieString)>,
    const ::blink::String& value)
    : tag_(Tag::kCookieString),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCookieString)>,
            std::move(value)) {}
CookieOrLine::~CookieOrLine() {
  DestroyActive();
}

void CookieOrLine::set_cookie(const ::net::CanonicalCookie& cookie) {
  if (tag_ == Tag::kCookie) {
    data_.cookie = std::move(cookie);
  } else {
    DestroyActive();
    tag_ = Tag::kCookie;
    new (&data_.cookie) ::net::CanonicalCookie(
        std::move(cookie));
  }
}

void CookieOrLine::set_cookie_string(const ::blink::String& cookie_string) {
  if (tag_ == Tag::kCookieString) {
    data_.cookie_string = std::move(cookie_string);
  } else {
    DestroyActive();
    tag_ = Tag::kCookieString;
    new (&data_.cookie_string) ::blink::String(
        std::move(cookie_string));
  }
}


CookieOrLine::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCookie)>,
    const ::net::CanonicalCookie& value)
    : cookie(std::move(value)) {}

CookieOrLine::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCookieString)>,
    const ::blink::String& value)
    : cookie_string(std::move(value)) {}

void CookieOrLine::DestroyActive() {
  switch (tag_) {

    case Tag::kCookie:
      std::destroy_at(&data_.cookie);
      break;
    case Tag::kCookieString:
      std::destroy_at(&data_.cookie_string);
      break;
  }
}

bool CookieOrLine::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

CookieChangeListener::IPCStableHashFunction CookieChangeListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CookieChangeListener>(message.name())) {
    case messages::CookieChangeListener::kOnCookieChange: {
      return &CookieChangeListener::OnCookieChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CookieChangeListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CookieChangeListener>(message.name())) {
      case messages::CookieChangeListener::kOnCookieChange:
            return "Receive network::mojom::CookieChangeListener::OnCookieChange";
    }
  } else {
    switch (static_cast<messages::CookieChangeListener>(message.name())) {
      case messages::CookieChangeListener::kOnCookieChange:
            return "Receive reply network::mojom::CookieChangeListener::OnCookieChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CookieChangeListener::OnCookieChange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9fdd71e4;  // IPCStableHash for network::mojom::CookieChangeListener::OnCookieChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CookieChangeListenerProxy::CookieChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieChangeListenerProxy::OnCookieChange(
    CookieChangeInfoPtr in_change) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieChangeListener::OnCookieChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("change"), in_change,
                        "<value of type CookieChangeInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieChangeListener::kOnCookieChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieChangeListener_OnCookieChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->change)::BaseType> change_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieChangeInfoDataView>(
    in_change,
    change_fragment);

  params->change.Set(
      change_fragment.is_null() ? nullptr : change_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->change.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null change in CookieChangeListener.OnCookieChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieChangeListener::Name_);
  message.set_method_name("OnCookieChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CookieChangeListenerStubDispatch::Accept(
    CookieChangeListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CookieChangeListener>(message->header()->name)) {
    case messages::CookieChangeListener::kOnCookieChange: {
      DCHECK(message->is_serialized());
      internal::CookieChangeListener_OnCookieChange_Params_Data* params =
          reinterpret_cast<internal::CookieChangeListener_OnCookieChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieChangeListener.0
      bool success = true;
      CookieChangeInfoPtr p_change{};
      CookieChangeListener_OnCookieChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChange(&p_change))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieChangeListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCookieChange(        
        std::move(p_change));
      return true;
    }
  }
  return false;
}

// static
bool CookieChangeListenerStubDispatch::AcceptWithResponder(
    CookieChangeListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CookieChangeListener>(message->header()->name)) {
    case messages::CookieChangeListener::kOnCookieChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieChangeListenerValidationInfo[] = {
    {base::to_underlying(messages::CookieChangeListener::kOnCookieChange),
     { &internal::CookieChangeListener_OnCookieChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CookieChangeListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::CookieChangeListener::Name_,
    kCookieChangeListenerValidationInfo);
}

// The declaration includes the definition on other builds.

CookieRemoteAccessFilter::IPCStableHashFunction CookieRemoteAccessFilter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CookieRemoteAccessFilter>(message.name())) {
    case messages::CookieRemoteAccessFilter::kAllowedAccess: {
      return &CookieRemoteAccessFilter::AllowedAccess_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CookieRemoteAccessFilter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CookieRemoteAccessFilter>(message.name())) {
      case messages::CookieRemoteAccessFilter::kAllowedAccess:
            return "Receive network::mojom::CookieRemoteAccessFilter::AllowedAccess";
    }
  } else {
    switch (static_cast<messages::CookieRemoteAccessFilter>(message.name())) {
      case messages::CookieRemoteAccessFilter::kAllowedAccess:
            return "Receive reply network::mojom::CookieRemoteAccessFilter::AllowedAccess";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CookieRemoteAccessFilter::AllowedAccess_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7173d087;  // IPCStableHash for network::mojom::CookieRemoteAccessFilter::AllowedAccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(
      CookieRemoteAccessFilter::AllowedAccessCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(const CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback&) = delete;
  CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback& operator=(const CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieRemoteAccessFilter::AllowedAccessCallback callback_;
};

CookieRemoteAccessFilterProxy::CookieRemoteAccessFilterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieRemoteAccessFilterProxy::AllowedAccess(
    const ::blink::KURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, AllowedAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieRemoteAccessFilter::AllowedAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieRemoteAccessFilter::kAllowedAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CookieRemoteAccessFilter.AllowedAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in CookieRemoteAccessFilter.AllowedAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieRemoteAccessFilter::Name_);
  message.set_method_name("AllowedAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieRemoteAccessFilter::AllowedAccessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder> proxy(
        new CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieRemoteAccessFilter::AllowedAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);
};

bool CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieRemoteAccessFilter.0
  bool success = true;
  bool p_allowed{};
  CookieRemoteAccessFilter_AllowedAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieRemoteAccessFilter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_allowed));
  }
  return true;
}

void CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieRemoteAccessFilter::AllowedAccess", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieRemoteAccessFilter::kAllowedAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieRemoteAccessFilter::Name_);
  message.set_method_name("AllowedAccess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieRemoteAccessFilterStubDispatch::Accept(
    CookieRemoteAccessFilter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CookieRemoteAccessFilter>(message->header()->name)) {
    case messages::CookieRemoteAccessFilter::kAllowedAccess: {
      break;
    }
  }
  return false;
}

// static
bool CookieRemoteAccessFilterStubDispatch::AcceptWithResponder(
    CookieRemoteAccessFilter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CookieRemoteAccessFilter>(message->header()->name)) {
    case messages::CookieRemoteAccessFilter::kAllowedAccess: {
      internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data* params =
          reinterpret_cast<
              internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieRemoteAccessFilter.0
      bool success = true;
      ::blink::KURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      CookieRemoteAccessFilter_AllowedAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieRemoteAccessFilter::Name_, 0, false);
        return false;
      }
      auto callback =
          CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowedAccess(        
        std::move(p_url), 
        std::move(p_site_for_cookies), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieRemoteAccessFilterValidationInfo[] = {
    {base::to_underlying(messages::CookieRemoteAccessFilter::kAllowedAccess),
     { &internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data::Validate,
      &internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data::Validate}},
};

bool CookieRemoteAccessFilterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::CookieRemoteAccessFilter::Name_,
    kCookieRemoteAccessFilterValidationInfo);
}

bool CookieRemoteAccessFilterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::blink::CookieRemoteAccessFilter::Name_,
    kCookieRemoteAccessFilterValidationInfo);

}
// The declaration includes the definition on other builds.

CookieManager::IPCStableHashFunction CookieManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CookieManager>(message.name())) {
    case messages::CookieManager::kGetAllCookies: {
      return &CookieManager::GetAllCookies_Sym::IPCStableHash;
    }
    case messages::CookieManager::kGetAllCookiesWithAccessSemantics: {
      return &CookieManager::GetAllCookiesWithAccessSemantics_Sym::IPCStableHash;
    }
    case messages::CookieManager::kGetCookieList: {
      return &CookieManager::GetCookieList_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetCanonicalCookie: {
      return &CookieManager::SetCanonicalCookie_Sym::IPCStableHash;
    }
    case messages::CookieManager::kDeleteCanonicalCookie: {
      return &CookieManager::DeleteCanonicalCookie_Sym::IPCStableHash;
    }
    case messages::CookieManager::kDeleteCookies: {
      return &CookieManager::DeleteCookies_Sym::IPCStableHash;
    }
    case messages::CookieManager::kDeleteSessionOnlyCookies: {
      return &CookieManager::DeleteSessionOnlyCookies_Sym::IPCStableHash;
    }
    case messages::CookieManager::kDeleteStaleSessionOnlyCookies: {
      return &CookieManager::DeleteStaleSessionOnlyCookies_Sym::IPCStableHash;
    }
    case messages::CookieManager::kAddCookieChangeListener: {
      return &CookieManager::AddCookieChangeListener_Sym::IPCStableHash;
    }
    case messages::CookieManager::kAddGlobalChangeListener: {
      return &CookieManager::AddGlobalChangeListener_Sym::IPCStableHash;
    }
    case messages::CookieManager::kCloneInterface: {
      return &CookieManager::CloneInterface_Sym::IPCStableHash;
    }
    case messages::CookieManager::kFlushCookieStore: {
      return &CookieManager::FlushCookieStore_Sym::IPCStableHash;
    }
    case messages::CookieManager::kAllowFileSchemeCookies: {
      return &CookieManager::AllowFileSchemeCookies_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetContentSettings: {
      return &CookieManager::SetContentSettings_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetRemoteFilter: {
      return &CookieManager::SetRemoteFilter_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetForceKeepSessionState: {
      return &CookieManager::SetForceKeepSessionState_Sym::IPCStableHash;
    }
    case messages::CookieManager::kBlockThirdPartyCookies: {
      return &CookieManager::BlockThirdPartyCookies_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetMitigationsEnabledFor3pcd: {
      return &CookieManager::SetMitigationsEnabledFor3pcd_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd: {
      return &CookieManager::SetTrackingProtectionEnabledFor3pcd_Sym::IPCStableHash;
    }
    case messages::CookieManager::kSetPreCommitCallbackDelayForTesting: {
      return &CookieManager::SetPreCommitCallbackDelayForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CookieManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CookieManager>(message.name())) {
      case messages::CookieManager::kGetAllCookies:
            return "Receive network::mojom::CookieManager::GetAllCookies";
      case messages::CookieManager::kGetAllCookiesWithAccessSemantics:
            return "Receive network::mojom::CookieManager::GetAllCookiesWithAccessSemantics";
      case messages::CookieManager::kGetCookieList:
            return "Receive network::mojom::CookieManager::GetCookieList";
      case messages::CookieManager::kSetCanonicalCookie:
            return "Receive network::mojom::CookieManager::SetCanonicalCookie";
      case messages::CookieManager::kDeleteCanonicalCookie:
            return "Receive network::mojom::CookieManager::DeleteCanonicalCookie";
      case messages::CookieManager::kDeleteCookies:
            return "Receive network::mojom::CookieManager::DeleteCookies";
      case messages::CookieManager::kDeleteSessionOnlyCookies:
            return "Receive network::mojom::CookieManager::DeleteSessionOnlyCookies";
      case messages::CookieManager::kDeleteStaleSessionOnlyCookies:
            return "Receive network::mojom::CookieManager::DeleteStaleSessionOnlyCookies";
      case messages::CookieManager::kAddCookieChangeListener:
            return "Receive network::mojom::CookieManager::AddCookieChangeListener";
      case messages::CookieManager::kAddGlobalChangeListener:
            return "Receive network::mojom::CookieManager::AddGlobalChangeListener";
      case messages::CookieManager::kCloneInterface:
            return "Receive network::mojom::CookieManager::CloneInterface";
      case messages::CookieManager::kFlushCookieStore:
            return "Receive network::mojom::CookieManager::FlushCookieStore";
      case messages::CookieManager::kAllowFileSchemeCookies:
            return "Receive network::mojom::CookieManager::AllowFileSchemeCookies";
      case messages::CookieManager::kSetContentSettings:
            return "Receive network::mojom::CookieManager::SetContentSettings";
      case messages::CookieManager::kSetRemoteFilter:
            return "Receive network::mojom::CookieManager::SetRemoteFilter";
      case messages::CookieManager::kSetForceKeepSessionState:
            return "Receive network::mojom::CookieManager::SetForceKeepSessionState";
      case messages::CookieManager::kBlockThirdPartyCookies:
            return "Receive network::mojom::CookieManager::BlockThirdPartyCookies";
      case messages::CookieManager::kSetMitigationsEnabledFor3pcd:
            return "Receive network::mojom::CookieManager::SetMitigationsEnabledFor3pcd";
      case messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd:
            return "Receive network::mojom::CookieManager::SetTrackingProtectionEnabledFor3pcd";
      case messages::CookieManager::kSetPreCommitCallbackDelayForTesting:
            return "Receive network::mojom::CookieManager::SetPreCommitCallbackDelayForTesting";
    }
  } else {
    switch (static_cast<messages::CookieManager>(message.name())) {
      case messages::CookieManager::kGetAllCookies:
            return "Receive reply network::mojom::CookieManager::GetAllCookies";
      case messages::CookieManager::kGetAllCookiesWithAccessSemantics:
            return "Receive reply network::mojom::CookieManager::GetAllCookiesWithAccessSemantics";
      case messages::CookieManager::kGetCookieList:
            return "Receive reply network::mojom::CookieManager::GetCookieList";
      case messages::CookieManager::kSetCanonicalCookie:
            return "Receive reply network::mojom::CookieManager::SetCanonicalCookie";
      case messages::CookieManager::kDeleteCanonicalCookie:
            return "Receive reply network::mojom::CookieManager::DeleteCanonicalCookie";
      case messages::CookieManager::kDeleteCookies:
            return "Receive reply network::mojom::CookieManager::DeleteCookies";
      case messages::CookieManager::kDeleteSessionOnlyCookies:
            return "Receive reply network::mojom::CookieManager::DeleteSessionOnlyCookies";
      case messages::CookieManager::kDeleteStaleSessionOnlyCookies:
            return "Receive reply network::mojom::CookieManager::DeleteStaleSessionOnlyCookies";
      case messages::CookieManager::kAddCookieChangeListener:
            return "Receive reply network::mojom::CookieManager::AddCookieChangeListener";
      case messages::CookieManager::kAddGlobalChangeListener:
            return "Receive reply network::mojom::CookieManager::AddGlobalChangeListener";
      case messages::CookieManager::kCloneInterface:
            return "Receive reply network::mojom::CookieManager::CloneInterface";
      case messages::CookieManager::kFlushCookieStore:
            return "Receive reply network::mojom::CookieManager::FlushCookieStore";
      case messages::CookieManager::kAllowFileSchemeCookies:
            return "Receive reply network::mojom::CookieManager::AllowFileSchemeCookies";
      case messages::CookieManager::kSetContentSettings:
            return "Receive reply network::mojom::CookieManager::SetContentSettings";
      case messages::CookieManager::kSetRemoteFilter:
            return "Receive reply network::mojom::CookieManager::SetRemoteFilter";
      case messages::CookieManager::kSetForceKeepSessionState:
            return "Receive reply network::mojom::CookieManager::SetForceKeepSessionState";
      case messages::CookieManager::kBlockThirdPartyCookies:
            return "Receive reply network::mojom::CookieManager::BlockThirdPartyCookies";
      case messages::CookieManager::kSetMitigationsEnabledFor3pcd:
            return "Receive reply network::mojom::CookieManager::SetMitigationsEnabledFor3pcd";
      case messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd:
            return "Receive reply network::mojom::CookieManager::SetTrackingProtectionEnabledFor3pcd";
      case messages::CookieManager::kSetPreCommitCallbackDelayForTesting:
            return "Receive reply network::mojom::CookieManager::SetPreCommitCallbackDelayForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CookieManager::GetAllCookies_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8873fd99;  // IPCStableHash for network::mojom::CookieManager::GetAllCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::GetAllCookiesWithAccessSemantics_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2899a841;  // IPCStableHash for network::mojom::CookieManager::GetAllCookiesWithAccessSemantics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::GetCookieList_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47effd3a;  // IPCStableHash for network::mojom::CookieManager::GetCookieList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetCanonicalCookie_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1378e23;  // IPCStableHash for network::mojom::CookieManager::SetCanonicalCookie
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::DeleteCanonicalCookie_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7290f9b1;  // IPCStableHash for network::mojom::CookieManager::DeleteCanonicalCookie
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::DeleteCookies_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd19933b;  // IPCStableHash for network::mojom::CookieManager::DeleteCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::DeleteSessionOnlyCookies_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x031417a4;  // IPCStableHash for network::mojom::CookieManager::DeleteSessionOnlyCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::DeleteStaleSessionOnlyCookies_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ba5b9b0;  // IPCStableHash for network::mojom::CookieManager::DeleteStaleSessionOnlyCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::AddCookieChangeListener_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4be87140;  // IPCStableHash for network::mojom::CookieManager::AddCookieChangeListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::AddGlobalChangeListener_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2ddabf4;  // IPCStableHash for network::mojom::CookieManager::AddGlobalChangeListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::CloneInterface_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd703b10c;  // IPCStableHash for network::mojom::CookieManager::CloneInterface
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::FlushCookieStore_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9cf3dccf;  // IPCStableHash for network::mojom::CookieManager::FlushCookieStore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::AllowFileSchemeCookies_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6054b78;  // IPCStableHash for network::mojom::CookieManager::AllowFileSchemeCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetContentSettings_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9189b383;  // IPCStableHash for network::mojom::CookieManager::SetContentSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetRemoteFilter_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3b33f78;  // IPCStableHash for network::mojom::CookieManager::SetRemoteFilter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetForceKeepSessionState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbafa66d9;  // IPCStableHash for network::mojom::CookieManager::SetForceKeepSessionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::BlockThirdPartyCookies_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27c66f60;  // IPCStableHash for network::mojom::CookieManager::BlockThirdPartyCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetMitigationsEnabledFor3pcd_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a2e4040;  // IPCStableHash for network::mojom::CookieManager::SetMitigationsEnabledFor3pcd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetTrackingProtectionEnabledFor3pcd_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2464b2a0;  // IPCStableHash for network::mojom::CookieManager::SetTrackingProtectionEnabledFor3pcd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieManager::SetPreCommitCallbackDelayForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x840fe15a;  // IPCStableHash for network::mojom::CookieManager::SetPreCommitCallbackDelayForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CookieManager_GetAllCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetAllCookies_ForwardToCallback(
      CookieManager::GetAllCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_GetAllCookies_ForwardToCallback(const CookieManager_GetAllCookies_ForwardToCallback&) = delete;
  CookieManager_GetAllCookies_ForwardToCallback& operator=(const CookieManager_GetAllCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetAllCookiesCallback callback_;
};

class CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(
      CookieManager::GetAllCookiesWithAccessSemanticsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(const CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback&) = delete;
  CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback& operator=(const CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetAllCookiesWithAccessSemanticsCallback callback_;
};

class CookieManager_GetCookieList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetCookieList_ForwardToCallback(
      CookieManager::GetCookieListCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_GetCookieList_ForwardToCallback(const CookieManager_GetCookieList_ForwardToCallback&) = delete;
  CookieManager_GetCookieList_ForwardToCallback& operator=(const CookieManager_GetCookieList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetCookieListCallback callback_;
};

class CookieManager_SetCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_SetCanonicalCookie_ForwardToCallback(
      CookieManager::SetCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_SetCanonicalCookie_ForwardToCallback(const CookieManager_SetCanonicalCookie_ForwardToCallback&) = delete;
  CookieManager_SetCanonicalCookie_ForwardToCallback& operator=(const CookieManager_SetCanonicalCookie_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::SetCanonicalCookieCallback callback_;
};

class CookieManager_DeleteCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteCanonicalCookie_ForwardToCallback(
      CookieManager::DeleteCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_DeleteCanonicalCookie_ForwardToCallback(const CookieManager_DeleteCanonicalCookie_ForwardToCallback&) = delete;
  CookieManager_DeleteCanonicalCookie_ForwardToCallback& operator=(const CookieManager_DeleteCanonicalCookie_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteCanonicalCookieCallback callback_;
};

class CookieManager_DeleteCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteCookies_ForwardToCallback(
      CookieManager::DeleteCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_DeleteCookies_ForwardToCallback(const CookieManager_DeleteCookies_ForwardToCallback&) = delete;
  CookieManager_DeleteCookies_ForwardToCallback& operator=(const CookieManager_DeleteCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteCookiesCallback callback_;
};

class CookieManager_DeleteSessionOnlyCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteSessionOnlyCookies_ForwardToCallback(
      CookieManager::DeleteSessionOnlyCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_DeleteSessionOnlyCookies_ForwardToCallback(const CookieManager_DeleteSessionOnlyCookies_ForwardToCallback&) = delete;
  CookieManager_DeleteSessionOnlyCookies_ForwardToCallback& operator=(const CookieManager_DeleteSessionOnlyCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteSessionOnlyCookiesCallback callback_;
};

class CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback(
      CookieManager::DeleteStaleSessionOnlyCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback(const CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback&) = delete;
  CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback& operator=(const CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteStaleSessionOnlyCookiesCallback callback_;
};

class CookieManager_FlushCookieStore_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_FlushCookieStore_ForwardToCallback(
      CookieManager::FlushCookieStoreCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_FlushCookieStore_ForwardToCallback(const CookieManager_FlushCookieStore_ForwardToCallback&) = delete;
  CookieManager_FlushCookieStore_ForwardToCallback& operator=(const CookieManager_FlushCookieStore_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::FlushCookieStoreCallback callback_;
};

class CookieManager_AllowFileSchemeCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_AllowFileSchemeCookies_ForwardToCallback(
      CookieManager::AllowFileSchemeCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_AllowFileSchemeCookies_ForwardToCallback(const CookieManager_AllowFileSchemeCookies_ForwardToCallback&) = delete;
  CookieManager_AllowFileSchemeCookies_ForwardToCallback& operator=(const CookieManager_AllowFileSchemeCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::AllowFileSchemeCookiesCallback callback_;
};

class CookieManager_SetContentSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_SetContentSettings_ForwardToCallback(
      CookieManager::SetContentSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieManager_SetContentSettings_ForwardToCallback(const CookieManager_SetContentSettings_ForwardToCallback&) = delete;
  CookieManager_SetContentSettings_ForwardToCallback& operator=(const CookieManager_SetContentSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::SetContentSettingsCallback callback_;
};

CookieManagerProxy::CookieManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieManagerProxy::GetAllCookies(
    GetAllCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::CookieManager::GetAllCookies");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kGetAllCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookies_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetAllCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::GetAllCookiesWithAccessSemantics(
    GetAllCookiesWithAccessSemanticsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::CookieManager::GetAllCookiesWithAccessSemantics");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kGetAllCookiesWithAccessSemantics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookiesWithAccessSemantics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::GetCookieList(
    const ::blink::KURL& in_url, CookieOptionsPtr in_cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr in_cookie_partition_key_collection, GetCookieListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::GetCookieList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_options"), in_cookie_options,
                        "<value of type CookieOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_partition_key_collection"), in_cookie_partition_key_collection,
                        "<value of type ::network::mojom::blink::CookiePartitionKeyCollectionPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kGetCookieList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetCookieList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CookieManager.GetCookieList request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_options)::BaseType> cookie_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieOptionsDataView>(
    in_cookie_options,
    cookie_options_fragment);

  params->cookie_options.Set(
      cookie_options_fragment.is_null() ? nullptr : cookie_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie_options in CookieManager.GetCookieList request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_partition_key_collection)::BaseType> cookie_partition_key_collection_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookiePartitionKeyCollectionDataView>(
    in_cookie_partition_key_collection,
    cookie_partition_key_collection_fragment);

  params->cookie_partition_key_collection.Set(
      cookie_partition_key_collection_fragment.is_null() ? nullptr : cookie_partition_key_collection_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie_partition_key_collection.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie_partition_key_collection in CookieManager.GetCookieList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetCookieList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetCookieList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::SetCanonicalCookie(
    const ::net::CanonicalCookie& in_cookie, const ::blink::KURL& in_source_url, CookieOptionsPtr in_cookie_options, SetCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::SetCanonicalCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type const ::net::CanonicalCookie&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_options"), in_cookie_options,
                        "<value of type CookieOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetCanonicalCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetCanonicalCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
    in_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in CookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_source_url,
    source_url_fragment);

  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_url in CookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_options)::BaseType> cookie_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieOptionsDataView>(
    in_cookie_options,
    cookie_options_fragment);

  params->cookie_options.Set(
      cookie_options_fragment.is_null() ? nullptr : cookie_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie_options in CookieManager.SetCanonicalCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_SetCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::DeleteCanonicalCookie(
    const ::net::CanonicalCookie& in_cookie, DeleteCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::DeleteCanonicalCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type const ::net::CanonicalCookie&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteCanonicalCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCanonicalCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
    in_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in CookieManager.DeleteCanonicalCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::DeleteCookies(
    CookieDeletionFilterPtr in_filter, DeleteCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::DeleteCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type CookieDeletionFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCookies_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieDeletionFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in CookieManager.DeleteCookies request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::DeleteSessionOnlyCookies(
    DeleteSessionOnlyCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::CookieManager::DeleteSessionOnlyCookies");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteSessionOnlyCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteSessionOnlyCookies_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteSessionOnlyCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteSessionOnlyCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::DeleteStaleSessionOnlyCookies(
    DeleteStaleSessionOnlyCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::CookieManager::DeleteStaleSessionOnlyCookies");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteStaleSessionOnlyCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteStaleSessionOnlyCookies_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteStaleSessionOnlyCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::AddCookieChangeListener(
    const ::blink::KURL& in_url, const ::blink::String& in_name, ::mojo::PendingRemote<CookieChangeListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::AddCookieChangeListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<CookieChangeListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kAddCookieChangeListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AddCookieChangeListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CookieManager.AddCookieChangeListener request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in CookieManager.AddCookieChangeListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AddCookieChangeListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::AddGlobalChangeListener(
    ::mojo::PendingRemote<CookieChangeListener> in_notification_pointer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::AddGlobalChangeListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_pointer"), in_notification_pointer,
                        "<value of type ::mojo::PendingRemote<CookieChangeListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kAddGlobalChangeListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AddGlobalChangeListener_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
    in_notification_pointer,
    &params->notification_pointer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->notification_pointer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid notification_pointer in CookieManager.AddGlobalChangeListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AddGlobalChangeListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::CloneInterface(
    ::mojo::PendingReceiver<CookieManager> in_new_interface) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::CloneInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_interface"), in_new_interface,
                        "<value of type ::mojo::PendingReceiver<CookieManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kCloneInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_CloneInterface_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
    in_new_interface,
    &params->new_interface,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->new_interface)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid new_interface in CookieManager.CloneInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("CloneInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::FlushCookieStore(
    FlushCookieStoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::CookieManager::FlushCookieStore");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kFlushCookieStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_FlushCookieStore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("FlushCookieStore");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_FlushCookieStore_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::AllowFileSchemeCookies(
    bool in_allow, AllowFileSchemeCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::AllowFileSchemeCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow"), in_allow,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kAllowFileSchemeCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AllowFileSchemeCookies_Params_Data> params(
          message);
  params.Allocate();

  params->allow = in_allow;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AllowFileSchemeCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_AllowFileSchemeCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::SetContentSettings(
    ::content_settings::mojom::blink::ContentSettingsType in_content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings, SetContentSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::SetContentSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_settings_type"), in_content_settings_type,
                        "<value of type ::content_settings::mojom::blink::ContentSettingsType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetContentSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetContentSettings_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsType>(
    in_content_settings_type,
    &params->content_settings_type);
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType>
      settings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
    in_settings,
    settings_fragment,
    &settings_validate_params);

  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null settings in CookieManager.SetContentSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetContentSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_SetContentSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieManagerProxy::SetRemoteFilter(
    ::mojo::PendingRemote<CookieRemoteAccessFilter> in_remote_access_filter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::SetRemoteFilter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_access_filter"), in_remote_access_filter,
                        "<value of type ::mojo::PendingRemote<CookieRemoteAccessFilter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetRemoteFilter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetRemoteFilter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieRemoteAccessFilterInterfaceBase>>(
    in_remote_access_filter,
    &params->remote_access_filter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->remote_access_filter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid remote_access_filter in CookieManager.SetRemoteFilter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetRemoteFilter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::SetForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::CookieManager::SetForceKeepSessionState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetForceKeepSessionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetForceKeepSessionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::BlockThirdPartyCookies(
    bool in_block) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::BlockThirdPartyCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("block"), in_block,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kBlockThirdPartyCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_BlockThirdPartyCookies_Params_Data> params(
          message);
  params.Allocate();

  params->block = in_block;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("BlockThirdPartyCookies");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::SetMitigationsEnabledFor3pcd(
    bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::SetMitigationsEnabledFor3pcd", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetMitigationsEnabledFor3pcd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetMitigationsEnabledFor3pcd_Params_Data> params(
          message);
  params.Allocate();

  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetMitigationsEnabledFor3pcd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::SetTrackingProtectionEnabledFor3pcd(
    bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::SetTrackingProtectionEnabledFor3pcd", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data> params(
          message);
  params.Allocate();

  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetTrackingProtectionEnabledFor3pcd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieManagerProxy::SetPreCommitCallbackDelayForTesting(
    ::base::TimeDelta in_delay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieManager::SetPreCommitCallbackDelayForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay"), in_delay,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetPreCommitCallbackDelayForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delay)::BaseType> delay_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_delay,
    delay_fragment);

  params->delay.Set(
      delay_fragment.is_null() ? nullptr : delay_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->delay.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null delay in CookieManager.SetPreCommitCallbackDelayForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetPreCommitCallbackDelayForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CookieManager_GetAllCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::GetAllCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_GetAllCookies_ProxyToResponder> proxy(
        new CookieManager_GetAllCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_GetAllCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetAllCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_GetAllCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetAllCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::net::CanonicalCookie>& in_cookies);
};

bool CookieManager_GetAllCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_GetAllCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetAllCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.0
  bool success = true;
  ::blink::Vector<::net::CanonicalCookie> p_cookies{};
  CookieManager_GetAllCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies));
  }
  return true;
}

void CookieManager_GetAllCookies_ProxyToResponder::Run(
    const ::blink::Vector<::net::CanonicalCookie>& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::GetAllCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type const ::blink::Vector<::net::CanonicalCookie>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kGetAllCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookies_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
    in_cookies,
    cookies_fragment,
    &cookies_validate_params);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::GetAllCookiesWithAccessSemanticsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder> proxy(
        new CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetAllCookiesWithAccessSemanticsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::net::CanonicalCookie>& in_cookies, const ::blink::Vector<CookieAccessSemantics>& in_access_semantics_list);
};

bool CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.1
  bool success = true;
  ::blink::Vector<::net::CanonicalCookie> p_cookies{};
  ::blink::Vector<CookieAccessSemantics> p_access_semantics_list{};
  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (success && !input_data_view.ReadAccessSemanticsList(&p_access_semantics_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies), 
std::move(p_access_semantics_list));
  }
  return true;
}

void CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::Run(
    const ::blink::Vector<::net::CanonicalCookie>& in_cookies, const ::blink::Vector<CookieAccessSemantics>& in_access_semantics_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::GetAllCookiesWithAccessSemantics", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type const ::blink::Vector<::net::CanonicalCookie>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_semantics_list"), in_access_semantics_list,
                        "<value of type const ::blink::Vector<CookieAccessSemantics>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kGetAllCookiesWithAccessSemantics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
    in_cookies,
    cookies_fragment,
    &cookies_validate_params);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");
  mojo::internal::MessageFragment<
      typename decltype(params->access_semantics_list)::BaseType>
      access_semantics_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& access_semantics_list_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::CookieAccessSemantics_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAccessSemantics>>(
    in_access_semantics_list,
    access_semantics_list_fragment,
    &access_semantics_list_validate_params);

  params->access_semantics_list.Set(
      access_semantics_list_fragment.is_null() ? nullptr : access_semantics_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_semantics_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_semantics_list in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookiesWithAccessSemantics");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_GetCookieList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::GetCookieListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_GetCookieList_ProxyToResponder> proxy(
        new CookieManager_GetCookieList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_GetCookieList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetCookieList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_GetCookieList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetCookieListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<CookieWithAccessResultPtr> in_cookies, ::blink::Vector<CookieWithAccessResultPtr> in_excluded_cookies);
};

bool CookieManager_GetCookieList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_GetCookieList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetCookieList_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.2
  bool success = true;
  ::blink::Vector<CookieWithAccessResultPtr> p_cookies{};
  ::blink::Vector<CookieWithAccessResultPtr> p_excluded_cookies{};
  CookieManager_GetCookieList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (success && !input_data_view.ReadExcludedCookies(&p_excluded_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies), 
std::move(p_excluded_cookies));
  }
  return true;
}

void CookieManager_GetCookieList_ProxyToResponder::Run(
    ::blink::Vector<CookieWithAccessResultPtr> in_cookies, ::blink::Vector<CookieWithAccessResultPtr> in_excluded_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::GetCookieList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type ::blink::Vector<CookieWithAccessResultPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("excluded_cookies"), in_excluded_cookies,
                        "<value of type ::blink::Vector<CookieWithAccessResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kGetCookieList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetCookieList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
    in_cookies,
    cookies_fragment,
    &cookies_validate_params);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");
  mojo::internal::MessageFragment<
      typename decltype(params->excluded_cookies)::BaseType>
      excluded_cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& excluded_cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
    in_excluded_cookies,
    excluded_cookies_fragment,
    &excluded_cookies_validate_params);

  params->excluded_cookies.Set(
      excluded_cookies_fragment.is_null() ? nullptr : excluded_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->excluded_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null excluded_cookies in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetCookieList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_SetCanonicalCookie_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::SetCanonicalCookieCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_SetCanonicalCookie_ProxyToResponder> proxy(
        new CookieManager_SetCanonicalCookie_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_SetCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_SetCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_SetCanonicalCookie_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::SetCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CookieAccessResultPtr in_access_result);
};

bool CookieManager_SetCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_SetCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_SetCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.3
  bool success = true;
  CookieAccessResultPtr p_access_result{};
  CookieManager_SetCanonicalCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAccessResult(&p_access_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_access_result));
  }
  return true;
}

void CookieManager_SetCanonicalCookie_ProxyToResponder::Run(
    CookieAccessResultPtr in_access_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::SetCanonicalCookie", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_result"), in_access_result,
                        "<value of type CookieAccessResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetCanonicalCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetCanonicalCookie_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->access_result)::BaseType> access_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
    in_access_result,
    access_result_fragment);

  params->access_result.Set(
      access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteCanonicalCookie_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::DeleteCanonicalCookieCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_DeleteCanonicalCookie_ProxyToResponder> proxy(
        new CookieManager_DeleteCanonicalCookie_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_DeleteCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_DeleteCanonicalCookie_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool CookieManager_DeleteCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.4
  bool success = true;
  bool p_success{};
  CookieManager_DeleteCanonicalCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void CookieManager_DeleteCanonicalCookie_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::DeleteCanonicalCookie", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteCanonicalCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::DeleteCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_DeleteCookies_ProxyToResponder> proxy(
        new CookieManager_DeleteCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_DeleteCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_DeleteCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_num_deleted);
};

bool CookieManager_DeleteCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.5
  bool success = true;
  uint32_t p_num_deleted{};
  CookieManager_DeleteCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_num_deleted = input_data_view.num_deleted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_num_deleted));
  }
  return true;
}

void CookieManager_DeleteCookies_ProxyToResponder::Run(
    uint32_t in_num_deleted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::DeleteCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_deleted"), in_num_deleted,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCookies_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->num_deleted = in_num_deleted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteSessionOnlyCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::DeleteSessionOnlyCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_DeleteSessionOnlyCookies_ProxyToResponder> proxy(
        new CookieManager_DeleteSessionOnlyCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_DeleteSessionOnlyCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteSessionOnlyCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_DeleteSessionOnlyCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteSessionOnlyCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_num_deleted);
};

bool CookieManager_DeleteSessionOnlyCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.6
  bool success = true;
  uint32_t p_num_deleted{};
  CookieManager_DeleteSessionOnlyCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_num_deleted = input_data_view.num_deleted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_num_deleted));
  }
  return true;
}

void CookieManager_DeleteSessionOnlyCookies_ProxyToResponder::Run(
    uint32_t in_num_deleted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::DeleteSessionOnlyCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_deleted"), in_num_deleted,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteSessionOnlyCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->num_deleted = in_num_deleted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteSessionOnlyCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::DeleteStaleSessionOnlyCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder> proxy(
        new CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteStaleSessionOnlyCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_num_deleted);
};

bool CookieManager_DeleteStaleSessionOnlyCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.7
  bool success = true;
  uint32_t p_num_deleted{};
  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_num_deleted = input_data_view.num_deleted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_num_deleted));
  }
  return true;
}

void CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder::Run(
    uint32_t in_num_deleted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::DeleteStaleSessionOnlyCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_deleted"), in_num_deleted,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kDeleteStaleSessionOnlyCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->num_deleted = in_num_deleted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteStaleSessionOnlyCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_FlushCookieStore_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::FlushCookieStoreCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_FlushCookieStore_ProxyToResponder> proxy(
        new CookieManager_FlushCookieStore_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_FlushCookieStore_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_FlushCookieStore_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_FlushCookieStore_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::FlushCookieStoreCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CookieManager_FlushCookieStore_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_FlushCookieStore_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_FlushCookieStore_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.11
  bool success = true;
  CookieManager_FlushCookieStore_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void CookieManager_FlushCookieStore_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::CookieManager::FlushCookieStore");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kFlushCookieStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_FlushCookieStore_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("FlushCookieStore");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_AllowFileSchemeCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::AllowFileSchemeCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_AllowFileSchemeCookies_ProxyToResponder> proxy(
        new CookieManager_AllowFileSchemeCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_AllowFileSchemeCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_AllowFileSchemeCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_AllowFileSchemeCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::AllowFileSchemeCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool CookieManager_AllowFileSchemeCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.12
  bool success = true;
  bool p_success{};
  CookieManager_AllowFileSchemeCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void CookieManager_AllowFileSchemeCookies_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::CookieManager::AllowFileSchemeCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kAllowFileSchemeCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AllowFileSchemeCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_SetContentSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieManager::SetContentSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieManager_SetContentSettings_ProxyToResponder> proxy(
        new CookieManager_SetContentSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieManager_SetContentSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_SetContentSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieManager_SetContentSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::SetContentSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CookieManager_SetContentSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieManager_SetContentSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_SetContentSettings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieManager.13
  bool success = true;
  CookieManager_SetContentSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void CookieManager_SetContentSettings_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::CookieManager::SetContentSettings");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieManager::kSetContentSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetContentSettings_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetContentSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieManagerStubDispatch::Accept(
    CookieManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CookieManager>(message->header()->name)) {
    case messages::CookieManager::kGetAllCookies: {
      break;
    }
    case messages::CookieManager::kGetAllCookiesWithAccessSemantics: {
      break;
    }
    case messages::CookieManager::kGetCookieList: {
      break;
    }
    case messages::CookieManager::kSetCanonicalCookie: {
      break;
    }
    case messages::CookieManager::kDeleteCanonicalCookie: {
      break;
    }
    case messages::CookieManager::kDeleteCookies: {
      break;
    }
    case messages::CookieManager::kDeleteSessionOnlyCookies: {
      break;
    }
    case messages::CookieManager::kDeleteStaleSessionOnlyCookies: {
      break;
    }
    case messages::CookieManager::kAddCookieChangeListener: {
      DCHECK(message->is_serialized());
      internal::CookieManager_AddCookieChangeListener_Params_Data* params =
          reinterpret_cast<internal::CookieManager_AddCookieChangeListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.8
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_name{};
      ::mojo::PendingRemote<CookieChangeListener> p_listener{};
      CookieManager_AddCookieChangeListener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCookieChangeListener(        
        std::move(p_url), 
        std::move(p_name), 
        std::move(p_listener));
      return true;
    }
    case messages::CookieManager::kAddGlobalChangeListener: {
      DCHECK(message->is_serialized());
      internal::CookieManager_AddGlobalChangeListener_Params_Data* params =
          reinterpret_cast<internal::CookieManager_AddGlobalChangeListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.9
      bool success = true;
      ::mojo::PendingRemote<CookieChangeListener> p_notification_pointer{};
      CookieManager_AddGlobalChangeListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_notification_pointer =
            input_data_view.TakeNotificationPointer<decltype(p_notification_pointer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddGlobalChangeListener(        
        std::move(p_notification_pointer));
      return true;
    }
    case messages::CookieManager::kCloneInterface: {
      DCHECK(message->is_serialized());
      internal::CookieManager_CloneInterface_Params_Data* params =
          reinterpret_cast<internal::CookieManager_CloneInterface_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.10
      bool success = true;
      ::mojo::PendingReceiver<CookieManager> p_new_interface{};
      CookieManager_CloneInterface_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_new_interface =
            input_data_view.TakeNewInterface<decltype(p_new_interface)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneInterface(        
        std::move(p_new_interface));
      return true;
    }
    case messages::CookieManager::kFlushCookieStore: {
      break;
    }
    case messages::CookieManager::kAllowFileSchemeCookies: {
      break;
    }
    case messages::CookieManager::kSetContentSettings: {
      break;
    }
    case messages::CookieManager::kSetRemoteFilter: {
      DCHECK(message->is_serialized());
      internal::CookieManager_SetRemoteFilter_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetRemoteFilter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.14
      bool success = true;
      ::mojo::PendingRemote<CookieRemoteAccessFilter> p_remote_access_filter{};
      CookieManager_SetRemoteFilter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote_access_filter =
            input_data_view.TakeRemoteAccessFilter<decltype(p_remote_access_filter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRemoteFilter(        
        std::move(p_remote_access_filter));
      return true;
    }
    case messages::CookieManager::kSetForceKeepSessionState: {
      DCHECK(message->is_serialized());
      internal::CookieManager_SetForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.15
      bool success = true;
      CookieManager_SetForceKeepSessionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForceKeepSessionState(        );
      return true;
    }
    case messages::CookieManager::kBlockThirdPartyCookies: {
      DCHECK(message->is_serialized());
      internal::CookieManager_BlockThirdPartyCookies_Params_Data* params =
          reinterpret_cast<internal::CookieManager_BlockThirdPartyCookies_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.16
      bool success = true;
      bool p_block{};
      CookieManager_BlockThirdPartyCookies_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_block = input_data_view.block();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlockThirdPartyCookies(        
        std::move(p_block));
      return true;
    }
    case messages::CookieManager::kSetMitigationsEnabledFor3pcd: {
      DCHECK(message->is_serialized());
      internal::CookieManager_SetMitigationsEnabledFor3pcd_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetMitigationsEnabledFor3pcd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.17
      bool success = true;
      bool p_enable{};
      CookieManager_SetMitigationsEnabledFor3pcd_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMitigationsEnabledFor3pcd(        
        std::move(p_enable));
      return true;
    }
    case messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd: {
      DCHECK(message->is_serialized());
      internal::CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.18
      bool success = true;
      bool p_enable{};
      CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTrackingProtectionEnabledFor3pcd(        
        std::move(p_enable));
      return true;
    }
    case messages::CookieManager::kSetPreCommitCallbackDelayForTesting: {
      DCHECK(message->is_serialized());
      internal::CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CookieManager.19
      bool success = true;
      ::base::TimeDelta p_delay{};
      CookieManager_SetPreCommitCallbackDelayForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDelay(&p_delay))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreCommitCallbackDelayForTesting(        
        std::move(p_delay));
      return true;
    }
  }
  return false;
}

// static
bool CookieManagerStubDispatch::AcceptWithResponder(
    CookieManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CookieManager>(message->header()->name)) {
    case messages::CookieManager::kGetAllCookies: {
      internal::CookieManager_GetAllCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetAllCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.0
      bool success = true;
      CookieManager_GetAllCookies_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 0, false);
        return false;
      }
      auto callback =
          CookieManager_GetAllCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookies(std::move(callback));
      return true;
    }
    case messages::CookieManager::kGetAllCookiesWithAccessSemantics: {
      internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.1
      bool success = true;
      CookieManager_GetAllCookiesWithAccessSemantics_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 1, false);
        return false;
      }
      auto callback =
          CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookiesWithAccessSemantics(std::move(callback));
      return true;
    }
    case messages::CookieManager::kGetCookieList: {
      internal::CookieManager_GetCookieList_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetCookieList_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.2
      bool success = true;
      ::blink::KURL p_url{};
      CookieOptionsPtr p_cookie_options{};
      ::network::mojom::blink::CookiePartitionKeyCollectionPtr p_cookie_partition_key_collection{};
      CookieManager_GetCookieList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadCookieOptions(&p_cookie_options))
        success = false;
      if (success && !input_data_view.ReadCookiePartitionKeyCollection(&p_cookie_partition_key_collection))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 2, false);
        return false;
      }
      auto callback =
          CookieManager_GetCookieList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookieList(        
        std::move(p_url), 
        std::move(p_cookie_options), 
        std::move(p_cookie_partition_key_collection), std::move(callback));
      return true;
    }
    case messages::CookieManager::kSetCanonicalCookie: {
      internal::CookieManager_SetCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_SetCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.3
      bool success = true;
      ::net::CanonicalCookie p_cookie{};
      ::blink::KURL p_source_url{};
      CookieOptionsPtr p_cookie_options{};
      CookieManager_SetCanonicalCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (success && !input_data_view.ReadCookieOptions(&p_cookie_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 3, false);
        return false;
      }
      auto callback =
          CookieManager_SetCanonicalCookie_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanonicalCookie(        
        std::move(p_cookie), 
        std::move(p_source_url), 
        std::move(p_cookie_options), std::move(callback));
      return true;
    }
    case messages::CookieManager::kDeleteCanonicalCookie: {
      internal::CookieManager_DeleteCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.4
      bool success = true;
      ::net::CanonicalCookie p_cookie{};
      CookieManager_DeleteCanonicalCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 4, false);
        return false;
      }
      auto callback =
          CookieManager_DeleteCanonicalCookie_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCanonicalCookie(        
        std::move(p_cookie), std::move(callback));
      return true;
    }
    case messages::CookieManager::kDeleteCookies: {
      internal::CookieManager_DeleteCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.5
      bool success = true;
      CookieDeletionFilterPtr p_filter{};
      CookieManager_DeleteCookies_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 5, false);
        return false;
      }
      auto callback =
          CookieManager_DeleteCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCookies(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::CookieManager::kDeleteSessionOnlyCookies: {
      internal::CookieManager_DeleteSessionOnlyCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteSessionOnlyCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.6
      bool success = true;
      CookieManager_DeleteSessionOnlyCookies_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 6, false);
        return false;
      }
      auto callback =
          CookieManager_DeleteSessionOnlyCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSessionOnlyCookies(std::move(callback));
      return true;
    }
    case messages::CookieManager::kDeleteStaleSessionOnlyCookies: {
      internal::CookieManager_DeleteStaleSessionOnlyCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteStaleSessionOnlyCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.7
      bool success = true;
      CookieManager_DeleteStaleSessionOnlyCookies_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 7, false);
        return false;
      }
      auto callback =
          CookieManager_DeleteStaleSessionOnlyCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStaleSessionOnlyCookies(std::move(callback));
      return true;
    }
    case messages::CookieManager::kAddCookieChangeListener: {
      break;
    }
    case messages::CookieManager::kAddGlobalChangeListener: {
      break;
    }
    case messages::CookieManager::kCloneInterface: {
      break;
    }
    case messages::CookieManager::kFlushCookieStore: {
      internal::CookieManager_FlushCookieStore_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_FlushCookieStore_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.11
      bool success = true;
      CookieManager_FlushCookieStore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 11, false);
        return false;
      }
      auto callback =
          CookieManager_FlushCookieStore_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushCookieStore(std::move(callback));
      return true;
    }
    case messages::CookieManager::kAllowFileSchemeCookies: {
      internal::CookieManager_AllowFileSchemeCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_AllowFileSchemeCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.12
      bool success = true;
      bool p_allow{};
      CookieManager_AllowFileSchemeCookies_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_allow = input_data_view.allow();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 12, false);
        return false;
      }
      auto callback =
          CookieManager_AllowFileSchemeCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowFileSchemeCookies(        
        std::move(p_allow), std::move(callback));
      return true;
    }
    case messages::CookieManager::kSetContentSettings: {
      internal::CookieManager_SetContentSettings_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_SetContentSettings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieManager.13
      bool success = true;
      ::content_settings::mojom::blink::ContentSettingsType p_content_settings_type{};
      ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetContentSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentSettingsType(&p_content_settings_type))
        success = false;
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 13, false);
        return false;
      }
      auto callback =
          CookieManager_SetContentSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContentSettings(        
        std::move(p_content_settings_type), 
        std::move(p_settings), std::move(callback));
      return true;
    }
    case messages::CookieManager::kSetRemoteFilter: {
      break;
    }
    case messages::CookieManager::kSetForceKeepSessionState: {
      break;
    }
    case messages::CookieManager::kBlockThirdPartyCookies: {
      break;
    }
    case messages::CookieManager::kSetMitigationsEnabledFor3pcd: {
      break;
    }
    case messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd: {
      break;
    }
    case messages::CookieManager::kSetPreCommitCallbackDelayForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieManagerValidationInfo[] = {
    {base::to_underlying(messages::CookieManager::kGetAllCookies),
     { &internal::CookieManager_GetAllCookies_Params_Data::Validate,
      &internal::CookieManager_GetAllCookies_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kGetAllCookiesWithAccessSemantics),
     { &internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data::Validate,
      &internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kGetCookieList),
     { &internal::CookieManager_GetCookieList_Params_Data::Validate,
      &internal::CookieManager_GetCookieList_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kSetCanonicalCookie),
     { &internal::CookieManager_SetCanonicalCookie_Params_Data::Validate,
      &internal::CookieManager_SetCanonicalCookie_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kDeleteCanonicalCookie),
     { &internal::CookieManager_DeleteCanonicalCookie_Params_Data::Validate,
      &internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kDeleteCookies),
     { &internal::CookieManager_DeleteCookies_Params_Data::Validate,
      &internal::CookieManager_DeleteCookies_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kDeleteSessionOnlyCookies),
     { &internal::CookieManager_DeleteSessionOnlyCookies_Params_Data::Validate,
      &internal::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kDeleteStaleSessionOnlyCookies),
     { &internal::CookieManager_DeleteStaleSessionOnlyCookies_Params_Data::Validate,
      &internal::CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kAddCookieChangeListener),
     { &internal::CookieManager_AddCookieChangeListener_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kAddGlobalChangeListener),
     { &internal::CookieManager_AddGlobalChangeListener_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kCloneInterface),
     { &internal::CookieManager_CloneInterface_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kFlushCookieStore),
     { &internal::CookieManager_FlushCookieStore_Params_Data::Validate,
      &internal::CookieManager_FlushCookieStore_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kAllowFileSchemeCookies),
     { &internal::CookieManager_AllowFileSchemeCookies_Params_Data::Validate,
      &internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kSetContentSettings),
     { &internal::CookieManager_SetContentSettings_Params_Data::Validate,
      &internal::CookieManager_SetContentSettings_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CookieManager::kSetRemoteFilter),
     { &internal::CookieManager_SetRemoteFilter_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kSetForceKeepSessionState),
     { &internal::CookieManager_SetForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kBlockThirdPartyCookies),
     { &internal::CookieManager_BlockThirdPartyCookies_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kSetMitigationsEnabledFor3pcd),
     { &internal::CookieManager_SetMitigationsEnabledFor3pcd_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kSetTrackingProtectionEnabledFor3pcd),
     { &internal::CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieManager::kSetPreCommitCallbackDelayForTesting),
     { &internal::CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CookieManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::CookieManager::Name_,
    kCookieManagerValidationInfo);
}

bool CookieManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::blink::CookieManager::Name_,
    kCookieManagerValidationInfo);

}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CookieManagerParams::DataView, ::network::mojom::blink::CookieManagerParamsPtr>::Read(
    ::network::mojom::blink::CookieManagerParams::DataView input,
    ::network::mojom::blink::CookieManagerParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieManagerParamsPtr result(::network::mojom::blink::CookieManagerParams::New());
  
      if (success)
        result->block_third_party_cookies = input.block_third_party_cookies();
      if (success)
        result->tracking_protection_enabled_for_3pcd = input.tracking_protection_enabled_for_3pcd();
      if (success)
        result->mitigations_enabled_for_3pcd = input.mitigations_enabled_for_3pcd();
      if (success && !input.ReadContentSettings(&result->content_settings))
        success = false;
      if (success && !input.ReadSecureOriginCookiesAllowedSchemes(&result->secure_origin_cookies_allowed_schemes))
        success = false;
      if (success && !input.ReadMatchingSchemeCookiesAllowedSchemes(&result->matching_scheme_cookies_allowed_schemes))
        success = false;
      if (success && !input.ReadThirdPartyCookiesAllowedSchemes(&result->third_party_cookies_allowed_schemes))
        success = false;
      if (success)
        result->allow_file_scheme_cookies = input.allow_file_scheme_cookies();
      if (success && !input.ReadCookieAccessDelegateType(&result->cookie_access_delegate_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieSameSiteContextMetadata::DataView, ::network::mojom::blink::CookieSameSiteContextMetadataPtr>::Read(
    ::network::mojom::blink::CookieSameSiteContextMetadata::DataView input,
    ::network::mojom::blink::CookieSameSiteContextMetadataPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieSameSiteContextMetadataPtr result(::network::mojom::blink::CookieSameSiteContextMetadata::New());
  
      if (success && !input.ReadCrossSiteRedirectDowngrade(&result->cross_site_redirect_downgrade))
        success = false;
      if (success && !input.ReadRedirectTypeBug1221316(&result->redirect_type_bug_1221316))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieSameSiteContext::DataView, ::network::mojom::blink::CookieSameSiteContextPtr>::Read(
    ::network::mojom::blink::CookieSameSiteContext::DataView input,
    ::network::mojom::blink::CookieSameSiteContextPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieSameSiteContextPtr result(::network::mojom::blink::CookieSameSiteContext::New());
  
      if (success && !input.ReadContext(&result->context))
        success = false;
      if (success && !input.ReadSchemefulContext(&result->schemeful_context))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadSchemefulMetadata(&result->schemeful_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieOptions::DataView, ::network::mojom::blink::CookieOptionsPtr>::Read(
    ::network::mojom::blink::CookieOptions::DataView input,
    ::network::mojom::blink::CookieOptionsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieOptionsPtr result(::network::mojom::blink::CookieOptions::New());
  
      if (success)
        result->exclude_httponly = input.exclude_httponly();
      if (success && !input.ReadSameSiteCookieContext(&result->same_site_cookie_context))
        success = false;
      if (success)
        result->update_access_time = input.update_access_time();
      if (success)
        result->return_excluded_cookies = input.return_excluded_cookies();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CanonicalCookie::DataView, ::network::mojom::blink::CanonicalCookiePtr>::Read(
    ::network::mojom::blink::CanonicalCookie::DataView input,
    ::network::mojom::blink::CanonicalCookiePtr* output) {
  bool success = true;
  ::network::mojom::blink::CanonicalCookiePtr result(::network::mojom::blink::CanonicalCookie::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadCreation(&result->creation))
        success = false;
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success && !input.ReadLastAccess(&result->last_access))
        success = false;
      if (success && !input.ReadLastUpdate(&result->last_update))
        success = false;
      if (success)
        result->secure = input.secure();
      if (success)
        result->httponly = input.httponly();
      if (success && !input.ReadSiteRestrictions(&result->site_restrictions))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadSourceScheme(&result->source_scheme))
        success = false;
      if (success && !input.ReadPartitionKey(&result->partition_key))
        success = false;
      if (success)
        result->source_port = input.source_port();
      if (success && !input.ReadSourceType(&result->source_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ExclusionReasons::DataView, ::network::mojom::blink::ExclusionReasonsPtr>::Read(
    ::network::mojom::blink::ExclusionReasons::DataView input,
    ::network::mojom::blink::ExclusionReasonsPtr* output) {
  bool success = true;
  ::network::mojom::blink::ExclusionReasonsPtr result(::network::mojom::blink::ExclusionReasons::New());
  
      if (success)
        result->exclusions_bitmask = input.exclusions_bitmask();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WarningReasons::DataView, ::network::mojom::blink::WarningReasonsPtr>::Read(
    ::network::mojom::blink::WarningReasons::DataView input,
    ::network::mojom::blink::WarningReasonsPtr* output) {
  bool success = true;
  ::network::mojom::blink::WarningReasonsPtr result(::network::mojom::blink::WarningReasons::New());
  
      if (success)
        result->warnings_bitmask = input.warnings_bitmask();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieInclusionStatus::DataView, ::network::mojom::blink::CookieInclusionStatusPtr>::Read(
    ::network::mojom::blink::CookieInclusionStatus::DataView input,
    ::network::mojom::blink::CookieInclusionStatusPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieInclusionStatusPtr result(::network::mojom::blink::CookieInclusionStatus::New());
  
      if (success && !input.ReadExclusionReasons(&result->exclusion_reasons))
        success = false;
      if (success && !input.ReadWarningReasons(&result->warning_reasons))
        success = false;
      if (success && !input.ReadExemptionReason(&result->exemption_reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieAndLineWithAccessResult::DataView, ::network::mojom::blink::CookieAndLineWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieAndLineWithAccessResult::DataView input,
    ::network::mojom::blink::CookieAndLineWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAndLineWithAccessResultPtr result(::network::mojom::blink::CookieAndLineWithAccessResult::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadCookieString(&result->cookie_string))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieOrLineWithAccessResult::DataView, ::network::mojom::blink::CookieOrLineWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieOrLineWithAccessResult::DataView input,
    ::network::mojom::blink::CookieOrLineWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieOrLineWithAccessResultPtr result(::network::mojom::blink::CookieOrLineWithAccessResult::New());
  
      if (success && !input.ReadCookieOrLine(&result->cookie_or_line))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieAccessResult::DataView, ::network::mojom::blink::CookieAccessResultPtr>::Read(
    ::network::mojom::blink::CookieAccessResult::DataView input,
    ::network::mojom::blink::CookieAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAccessResultPtr result(::network::mojom::blink::CookieAccessResult::New());
  
      if (success && !input.ReadEffectiveSameSite(&result->effective_same_site))
        success = false;
      if (success && !input.ReadAccessSemantics(&result->access_semantics))
        success = false;
      if (success && !input.ReadScopeSemantics(&result->scope_semantics))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->is_allowed_to_access_secure_cookies = input.is_allowed_to_access_secure_cookies();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieWithAccessResult::DataView, ::network::mojom::blink::CookieWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieWithAccessResult::DataView input,
    ::network::mojom::blink::CookieWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieWithAccessResultPtr result(::network::mojom::blink::CookieWithAccessResult::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieChangeInfo::DataView, ::network::mojom::blink::CookieChangeInfoPtr>::Read(
    ::network::mojom::blink::CookieChangeInfo::DataView input,
    ::network::mojom::blink::CookieChangeInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieChangeInfoPtr result(::network::mojom::blink::CookieChangeInfo::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
      if (success && !input.ReadCause(&result->cause))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieDeletionFilter::DataView, ::network::mojom::blink::CookieDeletionFilterPtr>::Read(
    ::network::mojom::blink::CookieDeletionFilter::DataView input,
    ::network::mojom::blink::CookieDeletionFilterPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieDeletionFilterPtr result(::network::mojom::blink::CookieDeletionFilter::New());
  
      if (success && !input.ReadCreatedAfterTime(&result->created_after_time))
        success = false;
      if (success && !input.ReadCreatedBeforeTime(&result->created_before_time))
        success = false;
      if (success && !input.ReadExcludingDomains(&result->excluding_domains))
        success = false;
      if (success && !input.ReadIncludingDomains(&result->including_domains))
        success = false;
      if (success && !input.ReadCookieName(&result->cookie_name))
        success = false;
      if (success && !input.ReadHostName(&result->host_name))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSessionControl(&result->session_control))
        success = false;
      if (success && !input.ReadCookiePartitionKeyCollection(&result->cookie_partition_key_collection))
        success = false;
      if (success)
        result->partitioned_state_only = input.partitioned_state_only();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::CookieOrLine::DataView, ::network::mojom::blink::CookieOrLinePtr>::Read(
    ::network::mojom::blink::CookieOrLine::DataView input,
    ::network::mojom::blink::CookieOrLinePtr* output) {
  using UnionType = ::network::mojom::blink::CookieOrLine;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCookie: {
      ::net::CanonicalCookie result_cookie{};
      if (!input.ReadCookie(&result_cookie))
        return false;

      *output = UnionType::NewCookie(
          std::move(result_cookie));
      break;
    }
    case Tag::kCookieString: {
      ::blink::String result_cookie_string{};
      if (!input.ReadCookieString(&result_cookie_string))
        return false;

      *output = UnionType::NewCookieString(
          std::move(result_cookie_string));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void CookieChangeListenerInterceptorForTesting::OnCookieChange(CookieChangeInfoPtr change) {
  GetForwardingInterface()->OnCookieChange(
    std::move(change)
    );
}
CookieChangeListenerAsyncWaiter::CookieChangeListenerAsyncWaiter(
    CookieChangeListener* proxy) : proxy_(proxy) {}

CookieChangeListenerAsyncWaiter::~CookieChangeListenerAsyncWaiter() = default;





void CookieRemoteAccessFilterInterceptorForTesting::AllowedAccess(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, AllowedAccessCallback callback) {
  GetForwardingInterface()->AllowedAccess(
    std::move(url)
    , 
    std::move(site_for_cookies)
    , std::move(callback));
}
CookieRemoteAccessFilterAsyncWaiter::CookieRemoteAccessFilterAsyncWaiter(
    CookieRemoteAccessFilter* proxy) : proxy_(proxy) {}

CookieRemoteAccessFilterAsyncWaiter::~CookieRemoteAccessFilterAsyncWaiter() = default;


void CookieRemoteAccessFilterAsyncWaiter::AllowedAccess(
    const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, bool* out_allowed) {
  base::RunLoop loop;
  proxy_->AllowedAccess(
      std::move(url),
      std::move(site_for_cookies),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}

bool CookieRemoteAccessFilterAsyncWaiter::AllowedAccess(
    const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies) {
  bool async_wait_result;
  AllowedAccess(std::move(url),std::move(site_for_cookies),&async_wait_result);
  return async_wait_result;
}




void CookieManagerInterceptorForTesting::GetAllCookies(GetAllCookiesCallback callback) {
  GetForwardingInterface()->GetAllCookies(std::move(callback));
}
void CookieManagerInterceptorForTesting::GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) {
  GetForwardingInterface()->GetAllCookiesWithAccessSemantics(std::move(callback));
}
void CookieManagerInterceptorForTesting::GetCookieList(const ::blink::KURL& url, CookieOptionsPtr cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection, GetCookieListCallback callback) {
  GetForwardingInterface()->GetCookieList(
    std::move(url)
    , 
    std::move(cookie_options)
    , 
    std::move(cookie_partition_key_collection)
    , std::move(callback));
}
void CookieManagerInterceptorForTesting::SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, SetCanonicalCookieCallback callback) {
  GetForwardingInterface()->SetCanonicalCookie(
    std::move(cookie)
    , 
    std::move(source_url)
    , 
    std::move(cookie_options)
    , std::move(callback));
}
void CookieManagerInterceptorForTesting::DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) {
  GetForwardingInterface()->DeleteCanonicalCookie(
    std::move(cookie)
    , std::move(callback));
}
void CookieManagerInterceptorForTesting::DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) {
  GetForwardingInterface()->DeleteCookies(
    std::move(filter)
    , std::move(callback));
}
void CookieManagerInterceptorForTesting::DeleteSessionOnlyCookies(DeleteSessionOnlyCookiesCallback callback) {
  GetForwardingInterface()->DeleteSessionOnlyCookies(std::move(callback));
}
void CookieManagerInterceptorForTesting::DeleteStaleSessionOnlyCookies(DeleteStaleSessionOnlyCookiesCallback callback) {
  GetForwardingInterface()->DeleteStaleSessionOnlyCookies(std::move(callback));
}
void CookieManagerInterceptorForTesting::AddCookieChangeListener(const ::blink::KURL& url, const ::blink::String& name, ::mojo::PendingRemote<CookieChangeListener> listener) {
  GetForwardingInterface()->AddCookieChangeListener(
    std::move(url)
    , 
    std::move(name)
    , 
    std::move(listener)
    );
}
void CookieManagerInterceptorForTesting::AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) {
  GetForwardingInterface()->AddGlobalChangeListener(
    std::move(notification_pointer)
    );
}
void CookieManagerInterceptorForTesting::CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) {
  GetForwardingInterface()->CloneInterface(
    std::move(new_interface)
    );
}
void CookieManagerInterceptorForTesting::FlushCookieStore(FlushCookieStoreCallback callback) {
  GetForwardingInterface()->FlushCookieStore(std::move(callback));
}
void CookieManagerInterceptorForTesting::AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) {
  GetForwardingInterface()->AllowFileSchemeCookies(
    std::move(allow)
    , std::move(callback));
}
void CookieManagerInterceptorForTesting::SetContentSettings(::content_settings::mojom::blink::ContentSettingsType content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings, SetContentSettingsCallback callback) {
  GetForwardingInterface()->SetContentSettings(
    std::move(content_settings_type)
    , 
    std::move(settings)
    , std::move(callback));
}
void CookieManagerInterceptorForTesting::SetRemoteFilter(::mojo::PendingRemote<CookieRemoteAccessFilter> remote_access_filter) {
  GetForwardingInterface()->SetRemoteFilter(
    std::move(remote_access_filter)
    );
}
void CookieManagerInterceptorForTesting::SetForceKeepSessionState() {
  GetForwardingInterface()->SetForceKeepSessionState();
}
void CookieManagerInterceptorForTesting::BlockThirdPartyCookies(bool block) {
  GetForwardingInterface()->BlockThirdPartyCookies(
    std::move(block)
    );
}
void CookieManagerInterceptorForTesting::SetMitigationsEnabledFor3pcd(bool enable) {
  GetForwardingInterface()->SetMitigationsEnabledFor3pcd(
    std::move(enable)
    );
}
void CookieManagerInterceptorForTesting::SetTrackingProtectionEnabledFor3pcd(bool enable) {
  GetForwardingInterface()->SetTrackingProtectionEnabledFor3pcd(
    std::move(enable)
    );
}
void CookieManagerInterceptorForTesting::SetPreCommitCallbackDelayForTesting(::base::TimeDelta delay) {
  GetForwardingInterface()->SetPreCommitCallbackDelayForTesting(
    std::move(delay)
    );
}
CookieManagerAsyncWaiter::CookieManagerAsyncWaiter(
    CookieManager* proxy) : proxy_(proxy) {}

CookieManagerAsyncWaiter::~CookieManagerAsyncWaiter() = default;


void CookieManagerAsyncWaiter::GetAllCookies(
    ::blink::Vector<::net::CanonicalCookie>* out_cookies) {
  base::RunLoop loop;
  proxy_->GetAllCookies(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::net::CanonicalCookie>* out_cookies
,
             const ::blink::Vector<::net::CanonicalCookie>& cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}

::blink::Vector<::net::CanonicalCookie> CookieManagerAsyncWaiter::GetAllCookies(
    ) {
  ::blink::Vector<::net::CanonicalCookie> async_wait_result;
  GetAllCookies(&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::GetAllCookiesWithAccessSemantics(
    ::blink::Vector<::net::CanonicalCookie>* out_cookies, ::blink::Vector<CookieAccessSemantics>* out_access_semantics_list) {
  base::RunLoop loop;
  proxy_->GetAllCookiesWithAccessSemantics(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::net::CanonicalCookie>* out_cookies
,
             ::blink::Vector<CookieAccessSemantics>* out_access_semantics_list
,
             const ::blink::Vector<::net::CanonicalCookie>& cookies,
             const ::blink::Vector<CookieAccessSemantics>& access_semantics_list) {*out_cookies = std::move(cookies);*out_access_semantics_list = std::move(access_semantics_list);
            loop->Quit();
          },
          &loop,
          out_cookies,
          out_access_semantics_list));
  loop.Run();
}



void CookieManagerAsyncWaiter::GetCookieList(
    const ::blink::KURL& url, CookieOptionsPtr cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection, ::blink::Vector<CookieWithAccessResultPtr>* out_cookies, ::blink::Vector<CookieWithAccessResultPtr>* out_excluded_cookies) {
  base::RunLoop loop;
  proxy_->GetCookieList(
      std::move(url),
      std::move(cookie_options),
      std::move(cookie_partition_key_collection),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<CookieWithAccessResultPtr>* out_cookies
,
             ::blink::Vector<CookieWithAccessResultPtr>* out_excluded_cookies
,
             ::blink::Vector<CookieWithAccessResultPtr> cookies,
             ::blink::Vector<CookieWithAccessResultPtr> excluded_cookies) {*out_cookies = std::move(cookies);*out_excluded_cookies = std::move(excluded_cookies);
            loop->Quit();
          },
          &loop,
          out_cookies,
          out_excluded_cookies));
  loop.Run();
}



void CookieManagerAsyncWaiter::SetCanonicalCookie(
    const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, CookieAccessResultPtr* out_access_result) {
  base::RunLoop loop;
  proxy_->SetCanonicalCookie(
      std::move(cookie),
      std::move(source_url),
      std::move(cookie_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             CookieAccessResultPtr* out_access_result
,
             CookieAccessResultPtr access_result) {*out_access_result = std::move(access_result);
            loop->Quit();
          },
          &loop,
          out_access_result));
  loop.Run();
}

CookieAccessResultPtr CookieManagerAsyncWaiter::SetCanonicalCookie(
    const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options) {
  CookieAccessResultPtr async_wait_result;
  SetCanonicalCookie(std::move(cookie),std::move(source_url),std::move(cookie_options),&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::DeleteCanonicalCookie(
    const ::net::CanonicalCookie& cookie, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteCanonicalCookie(
      std::move(cookie),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool CookieManagerAsyncWaiter::DeleteCanonicalCookie(
    const ::net::CanonicalCookie& cookie) {
  bool async_wait_result;
  DeleteCanonicalCookie(std::move(cookie),&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::DeleteCookies(
    CookieDeletionFilterPtr filter, uint32_t* out_num_deleted) {
  base::RunLoop loop;
  proxy_->DeleteCookies(
      std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_num_deleted
,
             uint32_t num_deleted) {*out_num_deleted = std::move(num_deleted);
            loop->Quit();
          },
          &loop,
          out_num_deleted));
  loop.Run();
}

uint32_t CookieManagerAsyncWaiter::DeleteCookies(
    CookieDeletionFilterPtr filter) {
  uint32_t async_wait_result;
  DeleteCookies(std::move(filter),&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::DeleteSessionOnlyCookies(
    uint32_t* out_num_deleted) {
  base::RunLoop loop;
  proxy_->DeleteSessionOnlyCookies(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_num_deleted
,
             uint32_t num_deleted) {*out_num_deleted = std::move(num_deleted);
            loop->Quit();
          },
          &loop,
          out_num_deleted));
  loop.Run();
}

uint32_t CookieManagerAsyncWaiter::DeleteSessionOnlyCookies(
    ) {
  uint32_t async_wait_result;
  DeleteSessionOnlyCookies(&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::DeleteStaleSessionOnlyCookies(
    uint32_t* out_num_deleted) {
  base::RunLoop loop;
  proxy_->DeleteStaleSessionOnlyCookies(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_num_deleted
,
             uint32_t num_deleted) {*out_num_deleted = std::move(num_deleted);
            loop->Quit();
          },
          &loop,
          out_num_deleted));
  loop.Run();
}

uint32_t CookieManagerAsyncWaiter::DeleteStaleSessionOnlyCookies(
    ) {
  uint32_t async_wait_result;
  DeleteStaleSessionOnlyCookies(&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::FlushCookieStore(
    ) {
  base::RunLoop loop;
  proxy_->FlushCookieStore(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void CookieManagerAsyncWaiter::AllowFileSchemeCookies(
    bool allow, bool* out_success) {
  base::RunLoop loop;
  proxy_->AllowFileSchemeCookies(
      std::move(allow),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool CookieManagerAsyncWaiter::AllowFileSchemeCookies(
    bool allow) {
  bool async_wait_result;
  AllowFileSchemeCookies(std::move(allow),&async_wait_result);
  return async_wait_result;
}

void CookieManagerAsyncWaiter::SetContentSettings(
    ::content_settings::mojom::blink::ContentSettingsType content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings) {
  base::RunLoop loop;
  proxy_->SetContentSettings(
      std::move(content_settings_type),
      std::move(settings),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif