// services/device/public/mojom/sensor.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/sensor.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/sensor.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/sensor.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class SensorProxy;

template <typename ImplRefTraits>
class SensorStub;

class SensorRequestValidator;
class SensorResponseValidator;


class BLINK_PLATFORM_EXPORT Sensor
    : public SensorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.Sensor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SensorInterfaceBase;
  using Proxy_ = SensorProxy;

  template <typename ImplRefTraits>
  using Stub_ = SensorStub<ImplRefTraits>;

  using RequestValidator_ = SensorRequestValidator;
  using ResponseValidator_ = SensorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDefaultConfigurationMinVersion = 0,
    kAddConfigurationMinVersion = 0,
    kRemoveConfigurationMinVersion = 0,
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kConfigureReadingChangeNotificationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDefaultConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Suspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigureReadingChangeNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Sensor() = default;

  using GetDefaultConfigurationCallback = base::OnceCallback<void(SensorConfigurationPtr)>;
  using GetDefaultConfigurationMojoCallback = base::OnceCallback<void(SensorConfigurationPtr)>;

  virtual void GetDefaultConfiguration(GetDefaultConfigurationCallback callback) = 0;

  using AddConfigurationCallback = base::OnceCallback<void(bool)>;
  using AddConfigurationMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AddConfiguration(SensorConfigurationPtr configuration, AddConfigurationCallback callback) = 0;

  virtual void RemoveConfiguration(SensorConfigurationPtr configuration) = 0;

  virtual void Suspend() = 0;

  virtual void Resume() = 0;

  virtual void ConfigureReadingChangeNotifications(bool enabled) = 0;
};

class SensorClientProxy;

template <typename ImplRefTraits>
class SensorClientStub;

class SensorClientRequestValidator;


class BLINK_PLATFORM_EXPORT SensorClient
    : public SensorClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SensorClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SensorClientInterfaceBase;
  using Proxy_ = SensorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SensorClientStub<ImplRefTraits>;

  using RequestValidator_ = SensorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRaiseErrorMinVersion = 0,
    kSensorReadingChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RaiseError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SensorReadingChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SensorClient() = default;

  virtual void RaiseError() = 0;

  virtual void SensorReadingChanged() = 0;
};



class BLINK_PLATFORM_EXPORT SensorProxy
    : public Sensor {
 public:
  using InterfaceType = Sensor;

  explicit SensorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDefaultConfiguration(GetDefaultConfigurationCallback callback) final;
  
  void AddConfiguration(SensorConfigurationPtr configuration, AddConfigurationCallback callback) final;
  
  void RemoveConfiguration(SensorConfigurationPtr configuration) final;
  
  void Suspend() final;
  
  void Resume() final;
  
  void ConfigureReadingChangeNotifications(bool enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT SensorClientProxy
    : public SensorClient {
 public:
  using InterfaceType = SensorClient;

  explicit SensorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RaiseError() final;
  
  void SensorReadingChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT SensorStubDispatch {
 public:
  static bool Accept(Sensor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Sensor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Sensor>>
class SensorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SensorStub() = default;
  ~SensorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SensorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SensorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SensorClientStubDispatch {
 public:
  static bool Accept(SensorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SensorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SensorClient>>
class SensorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SensorClientStub() = default;
  ~SensorClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SensorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SensorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SensorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SensorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SensorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_PLATFORM_EXPORT SensorConfiguration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SensorConfiguration, T>::value>;
  using DataView = SensorConfigurationDataView;
  using Data_ = internal::SensorConfiguration_Data;

  template <typename... Args>
  static SensorConfigurationPtr New(Args&&... args) {
    return SensorConfigurationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SensorConfigurationPtr From(const U& u) {
    return mojo::TypeConverter<SensorConfigurationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SensorConfiguration>::Convert(*this);
  }


  SensorConfiguration();

  explicit SensorConfiguration(
      double frequency);


  ~SensorConfiguration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SensorConfigurationPtr>
  SensorConfigurationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SensorConfiguration::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SensorConfiguration::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SensorConfiguration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SensorConfiguration_UnserializedMessageContext<
            UserType, SensorConfiguration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SensorConfiguration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SensorConfiguration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SensorConfiguration_UnserializedMessageContext<
            UserType, SensorConfiguration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SensorConfiguration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double frequency;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SensorConfiguration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT SensorReadingRaw {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SensorReadingRaw, T>::value>;
  using DataView = SensorReadingRawDataView;
  using Data_ = internal::SensorReadingRaw_Data;

  template <typename... Args>
  static SensorReadingRawPtr New(Args&&... args) {
    return SensorReadingRawPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SensorReadingRawPtr From(const U& u) {
    return mojo::TypeConverter<SensorReadingRawPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SensorReadingRaw>::Convert(*this);
  }


  SensorReadingRaw();

  SensorReadingRaw(
      double timestamp,
      ::blink::Vector<double> values);


  ~SensorReadingRaw();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SensorReadingRawPtr>
  SensorReadingRawPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SensorReadingRaw::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SensorReadingRaw::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SensorReadingRaw::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SensorReadingRaw_UnserializedMessageContext<
            UserType, SensorReadingRaw::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SensorReadingRaw::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SensorReadingRaw::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SensorReadingRaw_UnserializedMessageContext<
            UserType, SensorReadingRaw::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SensorReadingRaw::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double timestamp;
  
  ::blink::Vector<double> values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SensorReadingRaw::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
SensorReadingRawPtr SensorReadingRaw::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(values)
  );
}

template <typename T, SensorReadingRaw::EnableIfSame<T>*>
bool SensorReadingRaw::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->values, other_struct.values))
    return false;
  return true;
}

template <typename T, SensorReadingRaw::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.values < rhs.values)
    return true;
  if (rhs.values < lhs.values)
    return false;
  return false;
}
template <typename StructPtrType>
SensorConfigurationPtr SensorConfiguration::Clone() const {
  return New(
      mojo::Clone(frequency)
  );
}

template <typename T, SensorConfiguration::EnableIfSame<T>*>
bool SensorConfiguration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frequency, other_struct.frequency))
    return false;
  return true;
}

template <typename T, SensorConfiguration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frequency < rhs.frequency)
    return true;
  if (rhs.frequency < lhs.frequency)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::SensorReadingRaw::DataView,
                                         ::device::mojom::blink::SensorReadingRawPtr> {
  static bool IsNull(const ::device::mojom::blink::SensorReadingRawPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::SensorReadingRawPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::SensorReadingRaw::timestamp) timestamp(
      const ::device::mojom::blink::SensorReadingRawPtr& input) {
    return input->timestamp;
  }

  static const decltype(::device::mojom::blink::SensorReadingRaw::values)& values(
      const ::device::mojom::blink::SensorReadingRawPtr& input) {
    return input->values;
  }

  static bool Read(::device::mojom::blink::SensorReadingRaw::DataView input, ::device::mojom::blink::SensorReadingRawPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::SensorConfiguration::DataView,
                                         ::device::mojom::blink::SensorConfigurationPtr> {
  static bool IsNull(const ::device::mojom::blink::SensorConfigurationPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::SensorConfigurationPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::SensorConfiguration::frequency) frequency(
      const ::device::mojom::blink::SensorConfigurationPtr& input) {
    return input->frequency;
  }

  static bool Read(::device::mojom::blink::SensorConfiguration::DataView input, ::device::mojom::blink::SensorConfigurationPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_MOJOM_BLINK_H_