// media/mojo/mojom/video_encoder_metrics_provider.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_METRICS_PROVIDER_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_METRICS_PROVIDER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  VideoEncoderMetricsProvider_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t encoder_id;
  int32_t encoder_use_case;
  int32_t profile;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> encode_size;
  uint8_t is_hardware_encoder : 1;
  uint8_t pad4_[3];
  int32_t svc_mode;

 private:
  friend class mojo::internal::MessageFragment<VideoEncoderMetricsProvider_Initialize_Params_Data>;

  VideoEncoderMetricsProvider_Initialize_Params_Data();
  ~VideoEncoderMetricsProvider_Initialize_Params_Data() = delete;
};
static_assert(sizeof(VideoEncoderMetricsProvider_Initialize_Params_Data) == 40,
              "Bad sizeof(VideoEncoderMetricsProvider_Initialize_Params_Data)");
class  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t encoder_id;
  uint64_t num_encoded_frames;

 private:
  friend class mojo::internal::MessageFragment<VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data>;

  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data();
  ~VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data() = delete;
};
static_assert(sizeof(VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data) == 24,
              "Bad sizeof(VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data)");
class  VideoEncoderMetricsProvider_SetError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t encoder_id;
  mojo::internal::Pointer<::media::mojom::internal::EncoderStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<VideoEncoderMetricsProvider_SetError_Params_Data>;

  VideoEncoderMetricsProvider_SetError_Params_Data();
  ~VideoEncoderMetricsProvider_SetError_Params_Data() = delete;
};
static_assert(sizeof(VideoEncoderMetricsProvider_SetError_Params_Data) == 24,
              "Bad sizeof(VideoEncoderMetricsProvider_SetError_Params_Data)");
class  VideoEncoderMetricsProvider_Complete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t encoder_id;

 private:
  friend class mojo::internal::MessageFragment<VideoEncoderMetricsProvider_Complete_Params_Data>;

  VideoEncoderMetricsProvider_Complete_Params_Data();
  ~VideoEncoderMetricsProvider_Complete_Params_Data() = delete;
};
static_assert(sizeof(VideoEncoderMetricsProvider_Complete_Params_Data) == 16,
              "Bad sizeof(VideoEncoderMetricsProvider_Complete_Params_Data)");

}  // namespace internal


class VideoEncoderMetricsProvider_Initialize_ParamsDataView {
 public:
  VideoEncoderMetricsProvider_Initialize_ParamsDataView() = default;

  VideoEncoderMetricsProvider_Initialize_ParamsDataView(
      internal::VideoEncoderMetricsProvider_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t encoder_id() const {
    return data_->encoder_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEncoderUseCase(UserType* output) const {
    auto data_value = data_->encoder_use_case;
    return mojo::internal::Deserialize<::media::mojom::VideoEncoderUseCase>(
        data_value, output);
  }
  VideoEncoderUseCase encoder_use_case() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoEncoderUseCase>(data_->encoder_use_case));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile));
  }
  inline void GetEncodeSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodeSize(UserType* output) {
    
    auto* pointer = data_->encode_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool is_hardware_encoder() const {
    return data_->is_hardware_encoder;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSvcMode(UserType* output) const {
    auto data_value = data_->svc_mode;
    return mojo::internal::Deserialize<::media::mojom::SVCScalabilityMode>(
        data_value, output);
  }
  ::media::mojom::SVCScalabilityMode svc_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SVCScalabilityMode>(data_->svc_mode));
  }
 private:
  internal::VideoEncoderMetricsProvider_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsDataView {
 public:
  VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsDataView() = default;

  VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsDataView(
      internal::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t encoder_id() const {
    return data_->encoder_id;
  }
  uint64_t num_encoded_frames() const {
    return data_->num_encoded_frames;
  }
 private:
  internal::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data* data_ = nullptr;
};


class VideoEncoderMetricsProvider_SetError_ParamsDataView {
 public:
  VideoEncoderMetricsProvider_SetError_ParamsDataView() = default;

  VideoEncoderMetricsProvider_SetError_ParamsDataView(
      internal::VideoEncoderMetricsProvider_SetError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t encoder_id() const {
    return data_->encoder_id;
  }
  inline void GetStatusDataView(
      ::media::mojom::EncoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::mojom::EncoderStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncoderMetricsProvider_SetError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncoderMetricsProvider_Complete_ParamsDataView {
 public:
  VideoEncoderMetricsProvider_Complete_ParamsDataView() = default;

  VideoEncoderMetricsProvider_Complete_ParamsDataView(
      internal::VideoEncoderMetricsProvider_Complete_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t encoder_id() const {
    return data_->encoder_id;
  }
 private:
  internal::VideoEncoderMetricsProvider_Complete_Params_Data* data_ = nullptr;
};

inline void VideoEncoderMetricsProvider_Initialize_ParamsDataView::GetEncodeSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->encode_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}




inline void VideoEncoderMetricsProvider_SetError_ParamsDataView::GetStatusDataView(
    ::media::mojom::EncoderStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::mojom::EncoderStatusDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_METRICS_PROVIDER_MOJOM_PARAMS_DATA_H_