// media/mojo/mojom/video_encoder_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_encoder_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encoder_info.mojom-params-data.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_encoder_info.mojom-blink-import-headers.h"
#include "media/mojo/mojom/video_encoder_info.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
ResolutionRateLimit::ResolutionRateLimit()
    : frame_size(),
      min_start_bitrate_bps(),
      min_bitrate_bps(),
      max_bitrate_bps(),
      max_framerate_numerator(),
      max_framerate_denominator() {}

ResolutionRateLimit::ResolutionRateLimit(
    const ::gfx::Size& frame_size_in,
    int32_t min_start_bitrate_bps_in,
    int32_t min_bitrate_bps_in,
    int32_t max_bitrate_bps_in,
    uint32_t max_framerate_numerator_in,
    uint32_t max_framerate_denominator_in)
    : frame_size(std::move(frame_size_in)),
      min_start_bitrate_bps(std::move(min_start_bitrate_bps_in)),
      min_bitrate_bps(std::move(min_bitrate_bps_in)),
      max_bitrate_bps(std::move(max_bitrate_bps_in)),
      max_framerate_numerator(std::move(max_framerate_numerator_in)),
      max_framerate_denominator(std::move(max_framerate_denominator_in)) {}

ResolutionRateLimit::~ResolutionRateLimit() = default;

void ResolutionRateLimit::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_size"), this->frame_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_start_bitrate_bps"), this->min_start_bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_bitrate_bps"), this->min_bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_bitrate_bps"), this->max_bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_numerator"), this->max_framerate_numerator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_denominator"), this->max_framerate_denominator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolutionRateLimit::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncoderInfo::VideoEncoderInfo()
    : implementation_name(),
      has_frame_delay(false),
      frame_delay(),
      has_input_capacity(false),
      input_capacity(),
      supports_native_handle(),
      has_trusted_rate_controller(),
      is_hardware_accelerated(),
      supports_simulcast(),
      reports_average_qp(),
      requested_resolution_alignment(),
      apply_alignment_to_all_simulcast_layers(),
      supports_frame_size_change(false),
      fps_allocation(),
      resolution_rate_limits() {}

VideoEncoderInfo::VideoEncoderInfo(
    const ::blink::String& implementation_name_in,
    bool has_frame_delay_in,
    int32_t frame_delay_in,
    bool has_input_capacity_in,
    int32_t input_capacity_in,
    bool supports_native_handle_in,
    bool has_trusted_rate_controller_in,
    bool is_hardware_accelerated_in,
    bool supports_simulcast_in,
    bool reports_average_qp_in,
    uint32_t requested_resolution_alignment_in,
    bool apply_alignment_to_all_simulcast_layers_in,
    bool supports_frame_size_change_in,
    ::blink::Vector<::blink::Vector<uint8_t>> fps_allocation_in,
    ::blink::Vector<ResolutionRateLimitPtr> resolution_rate_limits_in)
    : implementation_name(std::move(implementation_name_in)),
      has_frame_delay(std::move(has_frame_delay_in)),
      frame_delay(std::move(frame_delay_in)),
      has_input_capacity(std::move(has_input_capacity_in)),
      input_capacity(std::move(input_capacity_in)),
      supports_native_handle(std::move(supports_native_handle_in)),
      has_trusted_rate_controller(std::move(has_trusted_rate_controller_in)),
      is_hardware_accelerated(std::move(is_hardware_accelerated_in)),
      supports_simulcast(std::move(supports_simulcast_in)),
      reports_average_qp(std::move(reports_average_qp_in)),
      requested_resolution_alignment(std::move(requested_resolution_alignment_in)),
      apply_alignment_to_all_simulcast_layers(std::move(apply_alignment_to_all_simulcast_layers_in)),
      supports_frame_size_change(std::move(supports_frame_size_change_in)),
      fps_allocation(std::move(fps_allocation_in)),
      resolution_rate_limits(std::move(resolution_rate_limits_in)) {}

VideoEncoderInfo::~VideoEncoderInfo() = default;

void VideoEncoderInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "implementation_name"), this->implementation_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_frame_delay"), this->has_frame_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_delay"), this->frame_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_input_capacity"), this->has_input_capacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_capacity"), this->input_capacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_native_handle"), this->supports_native_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_trusted_rate_controller"), this->has_trusted_rate_controller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_hardware_accelerated"), this->is_hardware_accelerated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_simulcast"), this->supports_simulcast,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reports_average_qp"), this->reports_average_qp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_resolution_alignment"), this->requested_resolution_alignment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "apply_alignment_to_all_simulcast_layers"), this->apply_alignment_to_all_simulcast_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_frame_size_change"), this->supports_frame_size_change,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fps_allocation"), this->fps_allocation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolution_rate_limits"), this->resolution_rate_limits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<ResolutionRateLimitPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncoderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::ResolutionRateLimit::DataView, ::media::mojom::blink::ResolutionRateLimitPtr>::Read(
    ::media::mojom::blink::ResolutionRateLimit::DataView input,
    ::media::mojom::blink::ResolutionRateLimitPtr* output) {
  bool success = true;
  ::media::mojom::blink::ResolutionRateLimitPtr result(::media::mojom::blink::ResolutionRateLimit::New());
  
      if (success && !input.ReadFrameSize(&result->frame_size))
        success = false;
      if (success)
        result->min_start_bitrate_bps = input.min_start_bitrate_bps();
      if (success)
        result->min_bitrate_bps = input.min_bitrate_bps();
      if (success)
        result->max_bitrate_bps = input.max_bitrate_bps();
      if (success)
        result->max_framerate_numerator = input.max_framerate_numerator();
      if (success)
        result->max_framerate_denominator = input.max_framerate_denominator();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoEncoderInfo::DataView, ::media::mojom::blink::VideoEncoderInfoPtr>::Read(
    ::media::mojom::blink::VideoEncoderInfo::DataView input,
    ::media::mojom::blink::VideoEncoderInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoEncoderInfoPtr result(::media::mojom::blink::VideoEncoderInfo::New());
  
      if (success && !input.ReadImplementationName(&result->implementation_name))
        success = false;
      if (success)
        result->has_frame_delay = input.has_frame_delay();
      if (success)
        result->frame_delay = input.frame_delay();
      if (success)
        result->has_input_capacity = input.has_input_capacity();
      if (success)
        result->input_capacity = input.input_capacity();
      if (success)
        result->supports_native_handle = input.supports_native_handle();
      if (success)
        result->has_trusted_rate_controller = input.has_trusted_rate_controller();
      if (success)
        result->is_hardware_accelerated = input.is_hardware_accelerated();
      if (success)
        result->supports_simulcast = input.supports_simulcast();
      if (success)
        result->reports_average_qp = input.reports_average_qp();
      if (success)
        result->requested_resolution_alignment = input.requested_resolution_alignment();
      if (success)
        result->apply_alignment_to_all_simulcast_layers = input.apply_alignment_to_all_simulcast_layers();
      if (success)
        result->supports_frame_size_change = input.supports_frame_size_change();
      if (success && !input.ReadFpsAllocation(&result->fps_allocation))
        success = false;
      if (success && !input.ReadResolutionRateLimits(&result->resolution_rate_limits))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {




}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif