// media/mojo/mojom/video_encode_accelerator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/video_encode_accelerator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* VideoEncodeAcceleratorSupportedRateControlModeToStringHelper(VideoEncodeAcceleratorSupportedRateControlMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorSupportedRateControlMode::kNoMode:
      return "kNoMode";
    case VideoEncodeAcceleratorSupportedRateControlMode::kConstantMode:
      return "kConstantMode";
    case VideoEncodeAcceleratorSupportedRateControlMode::kVariableMode:
      return "kVariableMode";
    case VideoEncodeAcceleratorSupportedRateControlMode::kExternalMode:
      return "kExternalMode";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorSupportedRateControlModeToString(VideoEncodeAcceleratorSupportedRateControlMode value) {
  const char *str = VideoEncodeAcceleratorSupportedRateControlModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorSupportedRateControlMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorSupportedRateControlMode value) {
  return os << VideoEncodeAcceleratorSupportedRateControlModeToString(value);
}

NOINLINE static const char* VideoEncodeAcceleratorConfig_ContentTypeToStringHelper(VideoEncodeAcceleratorConfig_ContentType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorConfig_ContentType::kCamera:
      return "kCamera";
    case VideoEncodeAcceleratorConfig_ContentType::kDisplay:
      return "kDisplay";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorConfig_ContentTypeToString(VideoEncodeAcceleratorConfig_ContentType value) {
  const char *str = VideoEncodeAcceleratorConfig_ContentTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorConfig_ContentType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_ContentType value) {
  return os << VideoEncodeAcceleratorConfig_ContentTypeToString(value);
}

NOINLINE static const char* VideoEncodeAcceleratorConfig_StorageTypeToStringHelper(VideoEncodeAcceleratorConfig_StorageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorConfig_StorageType::kShmem:
      return "kShmem";
    case VideoEncodeAcceleratorConfig_StorageType::kGpuMemoryBuffer:
      return "kGpuMemoryBuffer";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorConfig_StorageTypeToString(VideoEncodeAcceleratorConfig_StorageType value) {
  const char *str = VideoEncodeAcceleratorConfig_StorageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorConfig_StorageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_StorageType value) {
  return os << VideoEncodeAcceleratorConfig_StorageTypeToString(value);
}

NOINLINE static const char* VideoEncodeAcceleratorConfig_EncoderTypeToStringHelper(VideoEncodeAcceleratorConfig_EncoderType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorConfig_EncoderType::kHardware:
      return "kHardware";
    case VideoEncodeAcceleratorConfig_EncoderType::kSoftware:
      return "kSoftware";
    case VideoEncodeAcceleratorConfig_EncoderType::kNoPreference:
      return "kNoPreference";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorConfig_EncoderTypeToString(VideoEncodeAcceleratorConfig_EncoderType value) {
  const char *str = VideoEncodeAcceleratorConfig_EncoderTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorConfig_EncoderType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_EncoderType value) {
  return os << VideoEncodeAcceleratorConfig_EncoderTypeToString(value);
}

namespace internal {
// static
bool Bitrate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Bitrate_Data* object = static_cast<const Bitrate_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Bitrate_Tag::kConstant: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_constant, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_constant, validation_context))
        return false;
      return true;
    }
    case Bitrate_Tag::kVariable: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_variable, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_variable, validation_context))
        return false;
      return true;
    }
    case Bitrate_Tag::kExternal: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_external, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_external, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Bitrate");
      return false;
    }
  }
}
// static
bool OptionalMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const OptionalMetadata_Data* object = static_cast<const OptionalMetadata_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case OptionalMetadata_Tag::kDrop: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_drop, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_drop, validation_context))
        return false;
      return true;
    }
    case OptionalMetadata_Tag::kH264: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_h264, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_h264, validation_context))
        return false;
      return true;
    }
    case OptionalMetadata_Tag::kVp8: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_vp8, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_vp8, validation_context))
        return false;
      return true;
    }
    case OptionalMetadata_Tag::kVp9: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_vp9, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_vp9, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in OptionalMetadata");
      return false;
    }
  }
}


// static
bool VideoEncodeAcceleratorSupportedProfile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorSupportedProfile_Data* object =
      static_cast<const VideoEncodeAcceleratorSupportedProfile_Data*>(data);


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_resolution, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_resolution, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_resolution, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_resolution, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rate_control_modes, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rate_control_modes_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoEncodeAcceleratorSupportedRateControlMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->rate_control_modes, validation_context,
                                         &rate_control_modes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scalability_modes, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scalability_modes_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::SVCScalabilityMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->scalability_modes, validation_context,
                                         &scalability_modes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_supported_pixel_formats, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gpu_supported_pixel_formats_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoPixelFormat_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->gpu_supported_pixel_formats, validation_context,
                                         &gpu_supported_pixel_formats_validate_params)) {
    return false;
  }

  return true;
}

VideoEncodeAcceleratorSupportedProfile_Data::VideoEncodeAcceleratorSupportedProfile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EncodeCommandBufferId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EncodeCommandBufferId_Data* object =
      static_cast<const EncodeCommandBufferId_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->channel_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->channel_token, validation_context))
    return false;

  return true;
}

EncodeCommandBufferId_Data::EncodeCommandBufferId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VariableBitratePeak_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VariableBitratePeak_Data* object =
      static_cast<const VariableBitratePeak_Data*>(data);

  return true;
}

VariableBitratePeak_Data::VariableBitratePeak_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoBitrateAllocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoBitrateAllocation_Data* object =
      static_cast<const VideoBitrateAllocation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitrates, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bitrates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bitrates, validation_context,
                                         &bitrates_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->variable_bitrate_peak, validation_context))
    return false;

  return true;
}

VideoBitrateAllocation_Data::VideoBitrateAllocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpatialLayer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpatialLayer_Data* object =
      static_cast<const SpatialLayer_Data*>(data);

  return true;
}

SpatialLayer_Data::SpatialLayer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConstantBitrate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConstantBitrate_Data* object =
      static_cast<const ConstantBitrate_Data*>(data);

  return true;
}

ConstantBitrate_Data::ConstantBitrate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VariableBitrate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VariableBitrate_Data* object =
      static_cast<const VariableBitrate_Data*>(data);

  return true;
}

VariableBitrate_Data::VariableBitrate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExternalBitrate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExternalBitrate_Data* object =
      static_cast<const ExternalBitrate_Data*>(data);

  return true;
}

ExternalBitrate_Data::ExternalBitrate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorConfig_Data* object =
      static_cast<const VideoEncodeAcceleratorConfig_Data*>(data);


  if (!::media::mojom::internal::VideoPixelFormat_Data
        ::Validate(object->input_format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_visible_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_visible_size, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->output_profile, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->bitrate, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->bitrate, validation_context))
    return false;


  if (!::media::mojom::internal::VideoEncodeAcceleratorConfig_StorageType_Data
        ::Validate(object->storage_type, validation_context))
    return false;


  if (!::media::mojom::internal::VideoEncodeAcceleratorConfig_ContentType_Data
        ::Validate(object->content_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spatial_layers, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->spatial_layers, validation_context,
                                         &spatial_layers_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::SVCInterLayerPredMode_Data
        ::Validate(object->inter_layer_pred, validation_context))
    return false;


  if (!::media::mojom::internal::VideoEncodeAcceleratorConfig_EncoderType_Data
        ::Validate(object->required_encoder_type, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorConfig_Data::VideoEncodeAcceleratorConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeOptions_Data* object =
      static_cast<const VideoEncodeOptions_Data*>(data);

  return true;
}

VideoEncodeOptions_Data::VideoEncodeOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DropFrameMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DropFrameMetadata_Data* object =
      static_cast<const DropFrameMetadata_Data*>(data);

  return true;
}

DropFrameMetadata_Data::DropFrameMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool H264Metadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const H264Metadata_Data* object =
      static_cast<const H264Metadata_Data*>(data);

  return true;
}

H264Metadata_Data::H264Metadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Vp8Metadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Vp8Metadata_Data* object =
      static_cast<const Vp8Metadata_Data*>(data);

  return true;
}

Vp8Metadata_Data::Vp8Metadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Vp9Metadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Vp9Metadata_Data* object =
      static_cast<const Vp9Metadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spatial_layer_resolutions, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& spatial_layer_resolutions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->spatial_layer_resolutions, validation_context,
                                         &spatial_layer_resolutions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->p_diffs, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& p_diffs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->p_diffs, validation_context,
                                         &p_diffs_validate_params)) {
    return false;
  }

  return true;
}

Vp9Metadata_Data::Vp9Metadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SVCGenericMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SVCGenericMetadata_Data* object =
      static_cast<const SVCGenericMetadata_Data*>(data);

  return true;
}

SVCGenericMetadata_Data::SVCGenericMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BitstreamBufferMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BitstreamBufferMetadata_Data* object =
      static_cast<const BitstreamBufferMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->optional_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->svc_generic, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->encoded_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->encoded_color_space, validation_context))
    return false;

  return true;
}

BitstreamBufferMetadata_Data::BitstreamBufferMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->command_buffer_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data*>(data);

  return true;
}

VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* object =
      static_cast<const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profiles, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& profiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->profiles, validation_context,
                                         &profiles_validate_params)) {
    return false;
  }

  return true;
}

VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params_Data::VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_Initialize_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_Initialize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_log, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_log,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoEncodeAccelerator_Initialize_Params_Data::VideoEncodeAccelerator_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_Initialize_ResponseParams_Data* object =
      static_cast<const VideoEncodeAccelerator_Initialize_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_Initialize_ResponseParams_Data::VideoEncodeAccelerator_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Encode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_Encode_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_Encode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_Encode_Params_Data::VideoEncodeAccelerator_Encode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Encode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_Encode_ResponseParams_Data* object =
      static_cast<const VideoEncodeAccelerator_Encode_ResponseParams_Data*>(data);

  return true;
}

VideoEncodeAccelerator_Encode_ResponseParams_Data::VideoEncodeAccelerator_Encode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitrate_allocation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitrate_allocation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->bitrate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->bitrate, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_IsFlushSupported_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_IsFlushSupported_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_IsFlushSupported_Params_Data*>(data);

  return true;
}

VideoEncodeAccelerator_IsFlushSupported_Params_Data::VideoEncodeAccelerator_IsFlushSupported_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* object =
      static_cast<const VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data*>(data);

  return true;
}

VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_Flush_Params_Data* object =
      static_cast<const VideoEncodeAccelerator_Flush_Params_Data*>(data);

  return true;
}

VideoEncodeAccelerator_Flush_Params_Data::VideoEncodeAccelerator_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAccelerator_Flush_ResponseParams_Data* object =
      static_cast<const VideoEncodeAccelerator_Flush_ResponseParams_Data*>(data);

  return true;
}

VideoEncodeAccelerator_Flush_ResponseParams_Data::VideoEncodeAccelerator_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_coded_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_coded_size, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data* object =
      static_cast<const VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorSupportedRateControlMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorSupportedRateControlMode value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorSupportedRateControlModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorConfig_ContentType value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorConfig_ContentTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorConfig_StorageType value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorConfig_StorageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorConfig_EncoderType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorConfig_EncoderType value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorConfig_EncoderTypeToString(value));
}

} // namespace perfetto