// gpu/ipc/common/gpu_channel.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SHARED_INTERNAL_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "gpu/ipc/common/capabilities.mojom-shared-internal.h"
#include "gpu/ipc/common/context_result.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared-internal.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared-internal.h"
#include "gpu/ipc/common/shared_image_pool_id.mojom-shared-internal.h"
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-shared-internal.h"
#include "gpu/ipc/common/surface_handle.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared-internal.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared-internal.h"
#include "skia/public/mojom/image_info.mojom-shared-internal.h"
#include "skia/public/mojom/surface_origin.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/color_space.mojom-shared-internal.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared-internal.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-shared-internal.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace gpu::mojom {
namespace internal {
class ContextCreationAttribs_Data;
class CreateCommandBufferParams_Data;
class CommandBufferState_Data;
class ScheduleImageDecodeParams_Data;
using SwapBuffersCompleteParams_Data = mojo::native::internal::NativeStruct_Data;
class DeferredRequest_Data;
class DeferredCommandBufferRequest_Data;
class AsyncFlushParams_Data;
class SharedImageInfo_Data;
class CreateSharedImageParams_Data;
class CreateSharedImageWithDataParams_Data;
class CreateSharedImageWithBufferParams_Data;
class UpdateSharedImageParams_Data;
class AddReferenceToSharedImageParams_Data;
class CopyToGpuMemoryBufferParams_Data;
class CreateSharedImagePoolParams_Data;
class DestroySharedImagePoolParams_Data;
class DeferredRequestParams_Data;
class DeferredCommandBufferRequestParams_Data;
class DeferredSharedImageRequest_Data;

struct ContextType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ContextColorSpace_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SchedulingPriority_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};
using Error_Data =
    mojo::internal::NativeEnum_Data;
using ContextLostReason_Data =
    mojo::internal::NativeEnum_Data;

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) DeferredRequestParams_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  DeferredRequestParams_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~DeferredRequestParams_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<DeferredRequestParams_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class DeferredRequestParams_Tag : uint32_t {

    
    kCommandBufferRequest,
    
    kSharedImageRequest,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::DeferredCommandBufferRequest_Data> f_command_buffer_request;
    mojo::internal::Pointer<internal::DeferredSharedImageRequest_Data> f_shared_image_request;
    uint64_t unknown;
  };

  uint32_t size;
  DeferredRequestParams_Tag tag;
  Union_ data;
};
static_assert(sizeof(DeferredRequestParams_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(DeferredRequestParams_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) DeferredCommandBufferRequestParams_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  DeferredCommandBufferRequestParams_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~DeferredCommandBufferRequestParams_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<DeferredCommandBufferRequestParams_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class DeferredCommandBufferRequestParams_Tag : uint32_t {

    
    kAsyncFlush,
    
    kDestroyTransferBuffer,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::AsyncFlushParams_Data> f_async_flush;
    int32_t f_destroy_transfer_buffer;
    uint64_t unknown;
  };

  uint32_t size;
  DeferredCommandBufferRequestParams_Tag tag;
  Union_ data;
};
static_assert(sizeof(DeferredCommandBufferRequestParams_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(DeferredCommandBufferRequestParams_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) DeferredSharedImageRequest_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  DeferredSharedImageRequest_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~DeferredSharedImageRequest_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<DeferredSharedImageRequest_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class DeferredSharedImageRequest_Tag : uint32_t {

    
    kNop,
    
    kCreateSharedImage,
    
    kCreateSharedImageWithData,
    
    kCreateSharedImageWithBuffer,
    
    kRegisterUploadBuffer,
    
    kUpdateSharedImage,
    
    kCopyToGpuMemoryBuffer,
    
    kDestroySharedImage,
    
    kAddReferenceToSharedImage,
    
    kCreateSharedImagePool,
    
    kDestroySharedImagePool,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    uint8_t f_nop;
    mojo::internal::Pointer<internal::CreateSharedImageParams_Data> f_create_shared_image;
    mojo::internal::Pointer<internal::CreateSharedImageWithDataParams_Data> f_create_shared_image_with_data;
    mojo::internal::Pointer<internal::CreateSharedImageWithBufferParams_Data> f_create_shared_image_with_buffer;
    mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> f_register_upload_buffer;
    mojo::internal::Pointer<internal::UpdateSharedImageParams_Data> f_update_shared_image;
    mojo::internal::Pointer<internal::CopyToGpuMemoryBufferParams_Data> f_copy_to_gpu_memory_buffer;
    mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> f_destroy_shared_image;
    mojo::internal::Pointer<internal::AddReferenceToSharedImageParams_Data> f_add_reference_to_shared_image;
    mojo::internal::Pointer<internal::CreateSharedImagePoolParams_Data> f_create_shared_image_pool;
    mojo::internal::Pointer<internal::DestroySharedImagePoolParams_Data> f_destroy_shared_image_pool;
    uint64_t unknown;
  };

  uint32_t size;
  DeferredSharedImageRequest_Tag tag;
  Union_ data;
};
static_assert(sizeof(DeferredSharedImageRequest_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(DeferredSharedImageRequest_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) ContextCreationAttribs_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t gpu_preference;
  uint8_t fail_if_major_perf_caveat : 1;
  uint8_t lose_context_when_out_of_memory : 1;
  uint8_t enable_gles2_interface : 1;
  uint8_t enable_grcontext : 1;
  uint8_t enable_raster_interface : 1;
  uint8_t enable_gpu_rasterization : 1;
  uint8_t pad6_[3];
  int32_t context_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ContextCreationAttribs_Data>;

  ContextCreationAttribs_Data();
  ~ContextCreationAttribs_Data() = delete;
};
static_assert(sizeof(ContextCreationAttribs_Data) == 24,
              "Bad sizeof(ContextCreationAttribs_Data)");
// Used by ContextCreationAttribs::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ContextCreationAttribs_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ContextCreationAttribs_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ContextCreationAttribs_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ContextCreationAttribs_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ContextCreationAttribs_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CreateCommandBufferParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t share_group_id;
  int32_t stream_id;
  int32_t stream_priority;
  uint8_t pad2_[4];
  mojo::internal::Pointer<internal::ContextCreationAttribs_Data> attribs;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> active_url;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<CreateCommandBufferParams_Data>;

  CreateCommandBufferParams_Data();
  ~CreateCommandBufferParams_Data() = delete;
};
static_assert(sizeof(CreateCommandBufferParams_Data) == 48,
              "Bad sizeof(CreateCommandBufferParams_Data)");
// Used by CreateCommandBufferParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateCommandBufferParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateCommandBufferParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateCommandBufferParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CreateCommandBufferParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateCommandBufferParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBufferState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t get_offset;
  int32_t token;
  uint64_t release_count;
  int32_t error;
  int32_t context_lost_reason;
  uint32_t generation;
  uint32_t set_get_buffer_count;

 private:
  friend class mojo::internal::MessageFragment<CommandBufferState_Data>;

  CommandBufferState_Data();
  ~CommandBufferState_Data() = delete;
};
static_assert(sizeof(CommandBufferState_Data) == 40,
              "Bad sizeof(CommandBufferState_Data)");
// Used by CommandBufferState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CommandBufferState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CommandBufferState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CommandBufferState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CommandBufferState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CommandBufferState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) ScheduleImageDecodeParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> encoded_data;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> output_size;
  int32_t raster_decoder_route_id;
  uint32_t transfer_cache_entry_id;
  int32_t discardable_handle_shm_id;
  uint32_t discardable_handle_shm_offset;
  uint64_t discardable_handle_release_count;
  mojo::internal::Pointer<::gfx::mojom::internal::ColorSpace_Data> target_color_space;
  uint8_t needs_mips : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ScheduleImageDecodeParams_Data>;

  ScheduleImageDecodeParams_Data();
  ~ScheduleImageDecodeParams_Data() = delete;
};
static_assert(sizeof(ScheduleImageDecodeParams_Data) == 64,
              "Bad sizeof(ScheduleImageDecodeParams_Data)");
// Used by ScheduleImageDecodeParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScheduleImageDecodeParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScheduleImageDecodeParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScheduleImageDecodeParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScheduleImageDecodeParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScheduleImageDecodeParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) DeferredRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::DeferredRequestParams_Data params;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data>>> sync_token_fences;
  uint64_t release_count;

 private:
  friend class mojo::internal::MessageFragment<DeferredRequest_Data>;

  DeferredRequest_Data();
  ~DeferredRequest_Data() = delete;
};
static_assert(sizeof(DeferredRequest_Data) == 40,
              "Bad sizeof(DeferredRequest_Data)");
// Used by DeferredRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DeferredRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DeferredRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DeferredRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DeferredRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DeferredRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) DeferredCommandBufferRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  uint8_t pad0_[4];
  internal::DeferredCommandBufferRequestParams_Data params;

 private:
  friend class mojo::internal::MessageFragment<DeferredCommandBufferRequest_Data>;

  DeferredCommandBufferRequest_Data();
  ~DeferredCommandBufferRequest_Data() = delete;
};
static_assert(sizeof(DeferredCommandBufferRequest_Data) == 32,
              "Bad sizeof(DeferredCommandBufferRequest_Data)");
// Used by DeferredCommandBufferRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DeferredCommandBufferRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DeferredCommandBufferRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DeferredCommandBufferRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DeferredCommandBufferRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DeferredCommandBufferRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) AsyncFlushParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t put_offset;
  uint32_t flush_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data>>> sync_token_fences;

 private:
  friend class mojo::internal::MessageFragment<AsyncFlushParams_Data>;

  AsyncFlushParams_Data();
  ~AsyncFlushParams_Data() = delete;
};
static_assert(sizeof(AsyncFlushParams_Data) == 24,
              "Bad sizeof(AsyncFlushParams_Data)");
// Used by AsyncFlushParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AsyncFlushParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AsyncFlushParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AsyncFlushParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AsyncFlushParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AsyncFlushParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) SharedImageInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImageMetadata_Data> meta;
  mojo::internal::Pointer<mojo::internal::String_Data> debug_label;

 private:
  friend class mojo::internal::MessageFragment<SharedImageInfo_Data>;

  SharedImageInfo_Data();
  ~SharedImageInfo_Data() = delete;
};
static_assert(sizeof(SharedImageInfo_Data) == 24,
              "Bad sizeof(SharedImageInfo_Data)");
// Used by SharedImageInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SharedImageInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SharedImageInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SharedImageInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SharedImageInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SharedImageInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CreateSharedImageParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;
  mojo::internal::Pointer<internal::SharedImageInfo_Data> si_info;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImagePoolId_Data> pool_id;

 private:
  friend class mojo::internal::MessageFragment<CreateSharedImageParams_Data>;

  CreateSharedImageParams_Data();
  ~CreateSharedImageParams_Data() = delete;
};
static_assert(sizeof(CreateSharedImageParams_Data) == 32,
              "Bad sizeof(CreateSharedImageParams_Data)");
// Used by CreateSharedImageParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateSharedImageParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateSharedImageParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateSharedImageParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CreateSharedImageParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateSharedImageParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CreateSharedImageWithDataParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;
  mojo::internal::Pointer<internal::SharedImageInfo_Data> si_info;
  uint32_t pixel_data_offset;
  uint32_t pixel_data_size;
  uint8_t done_with_shm : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CreateSharedImageWithDataParams_Data>;

  CreateSharedImageWithDataParams_Data();
  ~CreateSharedImageWithDataParams_Data() = delete;
};
static_assert(sizeof(CreateSharedImageWithDataParams_Data) == 40,
              "Bad sizeof(CreateSharedImageWithDataParams_Data)");
// Used by CreateSharedImageWithDataParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateSharedImageWithDataParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateSharedImageWithDataParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateSharedImageWithDataParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CreateSharedImageWithDataParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateSharedImageWithDataParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CreateSharedImageWithBufferParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;
  mojo::internal::Pointer<internal::SharedImageInfo_Data> si_info;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> buffer_handle;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImagePoolId_Data> pool_id;

 private:
  friend class mojo::internal::MessageFragment<CreateSharedImageWithBufferParams_Data>;

  CreateSharedImageWithBufferParams_Data();
  ~CreateSharedImageWithBufferParams_Data() = delete;
};
static_assert(sizeof(CreateSharedImageWithBufferParams_Data) == 40,
              "Bad sizeof(CreateSharedImageWithBufferParams_Data)");
// Used by CreateSharedImageWithBufferParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateSharedImageWithBufferParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateSharedImageWithBufferParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateSharedImageWithBufferParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CreateSharedImageWithBufferParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateSharedImageWithBufferParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) UpdateSharedImageParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuFenceHandle_Data> in_fence_handle;

 private:
  friend class mojo::internal::MessageFragment<UpdateSharedImageParams_Data>;

  UpdateSharedImageParams_Data();
  ~UpdateSharedImageParams_Data() = delete;
};
static_assert(sizeof(UpdateSharedImageParams_Data) == 24,
              "Bad sizeof(UpdateSharedImageParams_Data)");
// Used by UpdateSharedImageParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UpdateSharedImageParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UpdateSharedImageParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UpdateSharedImageParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UpdateSharedImageParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UpdateSharedImageParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) AddReferenceToSharedImageParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;

 private:
  friend class mojo::internal::MessageFragment<AddReferenceToSharedImageParams_Data>;

  AddReferenceToSharedImageParams_Data();
  ~AddReferenceToSharedImageParams_Data() = delete;
};
static_assert(sizeof(AddReferenceToSharedImageParams_Data) == 16,
              "Bad sizeof(AddReferenceToSharedImageParams_Data)");
// Used by AddReferenceToSharedImageParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AddReferenceToSharedImageParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AddReferenceToSharedImageParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AddReferenceToSharedImageParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AddReferenceToSharedImageParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AddReferenceToSharedImageParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CopyToGpuMemoryBufferParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::Mailbox_Data> mailbox;

 private:
  friend class mojo::internal::MessageFragment<CopyToGpuMemoryBufferParams_Data>;

  CopyToGpuMemoryBufferParams_Data();
  ~CopyToGpuMemoryBufferParams_Data() = delete;
};
static_assert(sizeof(CopyToGpuMemoryBufferParams_Data) == 16,
              "Bad sizeof(CopyToGpuMemoryBufferParams_Data)");
// Used by CopyToGpuMemoryBufferParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CopyToGpuMemoryBufferParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CopyToGpuMemoryBufferParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CopyToGpuMemoryBufferParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CopyToGpuMemoryBufferParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CopyToGpuMemoryBufferParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CreateSharedImagePoolParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImagePoolId_Data> pool_id;
  mojo::internal::Interface_Data client_remote;

 private:
  friend class mojo::internal::MessageFragment<CreateSharedImagePoolParams_Data>;

  CreateSharedImagePoolParams_Data();
  ~CreateSharedImagePoolParams_Data() = delete;
};
static_assert(sizeof(CreateSharedImagePoolParams_Data) == 24,
              "Bad sizeof(CreateSharedImagePoolParams_Data)");
// Used by CreateSharedImagePoolParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CreateSharedImagePoolParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CreateSharedImagePoolParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CreateSharedImagePoolParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CreateSharedImagePoolParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CreateSharedImagePoolParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) DestroySharedImagePoolParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImagePoolId_Data> pool_id;

 private:
  friend class mojo::internal::MessageFragment<DestroySharedImagePoolParams_Data>;

  DestroySharedImagePoolParams_Data();
  ~DestroySharedImagePoolParams_Data() = delete;
};
static_assert(sizeof(DestroySharedImagePoolParams_Data) == 16,
              "Bad sizeof(DestroySharedImagePoolParams_Data)");
// Used by DestroySharedImagePoolParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DestroySharedImagePoolParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DestroySharedImagePoolParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DestroySharedImagePoolParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DestroySharedImagePoolParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DestroySharedImagePoolParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SHARED_INTERNAL_H_