// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_PARAMS_DATA_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace auction_worklet::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) GenerateBidClient_OnBiddingSignalsReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, double>> priority_vector;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> trusted_signals_fetch_latency;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> update_if_older_than;

 private:
  friend class mojo::internal::MessageFragment<GenerateBidClient_OnBiddingSignalsReceived_Params_Data>;

  GenerateBidClient_OnBiddingSignalsReceived_Params_Data();
  ~GenerateBidClient_OnBiddingSignalsReceived_Params_Data() = delete;
};
static_assert(sizeof(GenerateBidClient_OnBiddingSignalsReceived_Params_Data) == 32,
              "Bad sizeof(GenerateBidClient_OnBiddingSignalsReceived_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data>;

  GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data();
  ~GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data() = delete;
};
static_assert(sizeof(GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data) == 8,
              "Bad sizeof(GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) GenerateBidClient_OnGenerateBidComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::BidderWorkletBid_Data>>> bids;
  uint8_t bidding_signals_data_version_$flag : 1;
  uint8_t set_priority_$flag : 1;
  uint8_t pad2_[3];
  uint32_t bidding_signals_data_version_$value;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> debug_loss_report_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> debug_win_report_url;
  double set_priority_$value;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<internal::PrioritySignalsDouble_Data>>> update_priority_signals_overrides;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>>> pa_requests;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>>> non_kanon_pa_requests;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::RealTimeReportingContribution_Data>>> real_time_contributions;
  mojo::internal::Pointer<internal::BidderTimingMetrics_Data> generate_bid_timing_metrics;
  mojo::internal::Pointer<internal::GenerateBidDependencyLatencies_Data> generate_bid_dependency_latencies;
  int32_t reject_reason;
  uint8_t pad13_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> errors;

 private:
  friend class mojo::internal::MessageFragment<GenerateBidClient_OnGenerateBidComplete_Params_Data>;

  GenerateBidClient_OnGenerateBidComplete_Params_Data();
  ~GenerateBidClient_OnGenerateBidComplete_Params_Data() = delete;
};
static_assert(sizeof(GenerateBidClient_OnGenerateBidComplete_Params_Data) == 112,
              "Bad sizeof(GenerateBidClient_OnGenerateBidComplete_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) GenerateBidFinalizer_FinishGenerateBid_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> auction_signals_json;
  mojo::internal::Pointer<mojo::internal::String_Data> per_buyer_signals_json;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> per_buyer_timeout;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> expected_buyer_currency;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_per_buyer_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_per_buyer_signals_header_ad_slot;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_auction_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_auction_signals_header_ad_slot;

 private:
  friend class mojo::internal::MessageFragment<GenerateBidFinalizer_FinishGenerateBid_Params_Data>;

  GenerateBidFinalizer_FinishGenerateBid_Params_Data();
  ~GenerateBidFinalizer_FinishGenerateBid_Params_Data() = delete;
};
static_assert(sizeof(GenerateBidFinalizer_FinishGenerateBid_Params_Data) == 72,
              "Bad sizeof(GenerateBidFinalizer_FinishGenerateBid_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) BidderWorklet_BeginGenerateBid_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BidderWorkletNonSharedParams_Data> bidder_worklet_non_shared_params;
  mojo::internal::Pointer<::auction_worklet::mojom::internal::TrustedSignalsCacheKey_Data> key_value_signals_cache_key;
  int32_t kanon_mode;
  uint8_t browser_signal_for_debugging_only_sampling : 1;
  uint8_t pad3_[1];
  uint16_t multi_bid_limit;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> interest_group_join_origin;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_per_buyer_signals;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_auction_signals;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> browser_signal_seller_origin;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> browser_signal_top_level_seller_origin;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> browser_signal_recency;
  mojo::internal::Pointer<::blink::mojom::internal::BiddingBrowserSignals_Data> bidding_browser_signals;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> auction_start_time;
  mojo::internal::Pointer<::blink::mojom::internal::AdSize_Data> requested_ad_size;
  uint64_t group_by_origin_id;
  uint64_t trace_id;
  mojo::internal::AssociatedInterface_Data generate_bid_client;
  mojo::internal::AssociatedEndpointHandle_Data bid_finalizer;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BidderWorklet_BeginGenerateBid_Params_Data>;

  BidderWorklet_BeginGenerateBid_Params_Data();
  ~BidderWorklet_BeginGenerateBid_Params_Data() = delete;
};
static_assert(sizeof(BidderWorklet_BeginGenerateBid_Params_Data) == 136,
              "Bad sizeof(BidderWorklet_BeginGenerateBid_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) BidderWorklet_SendPendingSignalsRequests_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<BidderWorklet_SendPendingSignalsRequests_Params_Data>;

  BidderWorklet_SendPendingSignalsRequests_Params_Data();
  ~BidderWorklet_SendPendingSignalsRequests_Params_Data() = delete;
};
static_assert(sizeof(BidderWorklet_SendPendingSignalsRequests_Params_Data) == 8,
              "Bad sizeof(BidderWorklet_SendPendingSignalsRequests_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) BidderWorklet_ReportWin_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_for_additional_bid : 1;
  uint8_t browser_signal_made_highest_scoring_other_bid : 1;
  uint8_t browser_signal_ad_cost_$flag : 1;
  uint8_t browser_signal_modeling_signals_$flag : 1;
  uint8_t bidding_signals_data_version_$flag : 1;
  uint8_t browser_signal_join_count;
  uint16_t browser_signal_modeling_signals_$value;
  int32_t kanon_status;
  mojo::internal::Pointer<mojo::internal::String_Data> interest_group_name_reporting_id;
  mojo::internal::Pointer<mojo::internal::String_Data> buyer_reporting_id;
  mojo::internal::Pointer<mojo::internal::String_Data> buyer_and_seller_reporting_id;
  mojo::internal::Pointer<mojo::internal::String_Data> selected_buyer_and_seller_reporting_id;
  mojo::internal::Pointer<mojo::internal::String_Data> auction_signals_json;
  mojo::internal::Pointer<mojo::internal::String_Data> per_buyer_signals_json;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_per_buyer_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_per_buyer_signals_header_ad_slot;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_auction_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_auction_signals_header_ad_slot;
  mojo::internal::Pointer<mojo::internal::String_Data> seller_signals_json;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> browser_signal_render_url;
  double browser_signal_bid;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> browser_signal_bid_currency;
  double browser_signal_highest_scoring_other_bid;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> browser_signal_highest_scoring_other_bid_currency;
  double browser_signal_ad_cost_$value;
  uint8_t browser_signal_recency;
  uint8_t pad25_[3];
  uint32_t bidding_signals_data_version_$value;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> browser_signal_seller_origin;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> browser_signal_top_level_seller_origin;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> browser_signal_reporting_timeout;
  mojo::internal::Pointer<mojo::internal::String_Data> aggregate_win_signals;
  uint64_t trace_id;

 private:
  friend class mojo::internal::MessageFragment<BidderWorklet_ReportWin_Params_Data>;

  BidderWorklet_ReportWin_Params_Data();
  ~BidderWorklet_ReportWin_Params_Data() = delete;
};
static_assert(sizeof(BidderWorklet_ReportWin_Params_Data) == 200,
              "Bad sizeof(BidderWorklet_ReportWin_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) BidderWorklet_ReportWin_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> report_url;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> ad_beacon_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<mojo::internal::String_Data>>> ad_macro_map;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>>> pa_requests;
  mojo::internal::Pointer<internal::PrivateModelTrainingRequestData_Data> pmt_request_data;
  mojo::internal::Pointer<internal::BidderTimingMetrics_Data> timing_metrics;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> errors;

 private:
  friend class mojo::internal::MessageFragment<BidderWorklet_ReportWin_ResponseParams_Data>;

  BidderWorklet_ReportWin_ResponseParams_Data();
  ~BidderWorklet_ReportWin_ResponseParams_Data() = delete;
};
static_assert(sizeof(BidderWorklet_ReportWin_ResponseParams_Data) == 64,
              "Bad sizeof(BidderWorklet_ReportWin_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) BidderWorklet_ConnectDevToolsAgent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data agent;
  uint32_t thread_index;

 private:
  friend class mojo::internal::MessageFragment<BidderWorklet_ConnectDevToolsAgent_Params_Data>;

  BidderWorklet_ConnectDevToolsAgent_Params_Data();
  ~BidderWorklet_ConnectDevToolsAgent_Params_Data() = delete;
};
static_assert(sizeof(BidderWorklet_ConnectDevToolsAgent_Params_Data) == 16,
              "Bad sizeof(BidderWorklet_ConnectDevToolsAgent_Params_Data)");

}  // namespace internal


class GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView {
 public:
  GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView() = default;

  GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView(
      internal::GenerateBidClient_OnBiddingSignalsReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPriorityVectorDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPriorityVector(UserType* output) {
    
    auto* pointer = data_->priority_vector.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  inline void GetTrustedSignalsFetchLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedSignalsFetchLatency(UserType* output) {
    
    auto* pointer = data_->trusted_signals_fetch_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateIfOlderThanDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateIfOlderThan(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `update_if_older_than` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateIfOlderThan` instead "
    "of `ReadUpdateIfOlderThan if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_if_older_than.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::GenerateBidClient_OnBiddingSignalsReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GenerateBidClient_OnBiddingSignalsReceived_ResponseParamsDataView {
 public:
  GenerateBidClient_OnBiddingSignalsReceived_ResponseParamsDataView() = default;

  GenerateBidClient_OnBiddingSignalsReceived_ResponseParamsDataView(
      internal::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data* data_ = nullptr;
};


class GenerateBidClient_OnGenerateBidComplete_ParamsDataView {
 public:
  GenerateBidClient_OnGenerateBidComplete_ParamsDataView() = default;

  GenerateBidClient_OnGenerateBidComplete_ParamsDataView(
      internal::GenerateBidClient_OnGenerateBidComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBidsDataView(
      mojo::ArrayDataView<BidderWorkletBidDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBids(UserType* output) {
    
    auto* pointer = data_->bids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::BidderWorkletBidDataView>>(
        pointer, output, message_);
  }
  std::optional<uint32_t> bidding_signals_data_version() const {

    return data_->bidding_signals_data_version_$flag
        ? std::make_optional(data_->bidding_signals_data_version_$value)
        : std::nullopt;
  }
  inline void GetDebugLossReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugLossReportUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `debug_loss_report_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebugLossReportUrl` instead "
    "of `ReadDebugLossReportUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug_loss_report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDebugWinReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugWinReportUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `debug_win_report_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebugWinReportUrl` instead "
    "of `ReadDebugWinReportUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug_win_report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  std::optional<double> set_priority() const {

    return data_->set_priority_$flag
        ? std::make_optional(data_->set_priority_$value)
        : std::nullopt;
  }
  inline void GetUpdatePrioritySignalsOverridesDataView(
      mojo::MapDataView<mojo::StringDataView, PrioritySignalsDoubleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatePrioritySignalsOverrides(UserType* output) {
    
    auto* pointer = data_->update_priority_signals_overrides.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::auction_worklet::mojom::PrioritySignalsDoubleDataView>>(
        pointer, output, message_);
  }
  inline void GetPaRequestsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaRequests(UserType* output) {
    
    auto* pointer = data_->pa_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetNonKanonPaRequestsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonKanonPaRequests(UserType* output) {
    
    auto* pointer = data_->non_kanon_pa_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetRealTimeContributionsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRealTimeContributions(UserType* output) {
    
    auto* pointer = data_->real_time_contributions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>>(
        pointer, output, message_);
  }
  inline void GetGenerateBidTimingMetricsDataView(
      BidderTimingMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerateBidTimingMetrics(UserType* output) {
    
    auto* pointer = data_->generate_bid_timing_metrics.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::BidderTimingMetricsDataView>(
        pointer, output, message_);
  }
  inline void GetGenerateBidDependencyLatenciesDataView(
      GenerateBidDependencyLatenciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerateBidDependencyLatencies(UserType* output) {
    
    auto* pointer = data_->generate_bid_dependency_latencies.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRejectReason(UserType* output) const {
    auto data_value = data_->reject_reason;
    return mojo::internal::Deserialize<::auction_worklet::mojom::RejectReason>(
        data_value, output);
  }
  ::auction_worklet::mojom::RejectReason reject_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::RejectReason>(data_->reject_reason));
  }
  inline void GetErrorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrors(UserType* output) {
    
    auto* pointer = data_->errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GenerateBidClient_OnGenerateBidComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GenerateBidFinalizer_FinishGenerateBid_ParamsDataView {
 public:
  GenerateBidFinalizer_FinishGenerateBid_ParamsDataView() = default;

  GenerateBidFinalizer_FinishGenerateBid_ParamsDataView(
      internal::GenerateBidFinalizer_FinishGenerateBid_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAuctionSignalsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionSignalsJson(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `auction_signals_json` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionSignalsJson` instead "
    "of `ReadAuctionSignalsJson if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_signals_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerSignalsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerSignalsJson(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `per_buyer_signals_json` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerSignalsJson` instead "
    "of `ReadPerBuyerSignalsJson if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_signals_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `per_buyer_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerTimeout` instead "
    "of `ReadPerBuyerTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetExpectedBuyerCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedBuyerCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `expected_buyer_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpectedBuyerCurrency` instead "
    "of `ReadExpectedBuyerCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expected_buyer_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerPerBuyerSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerPerBuyerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_per_buyer_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerPerBuyerSignals` instead "
    "of `ReadDirectFromSellerPerBuyerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_per_buyer_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerPerBuyerSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerPerBuyerSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_per_buyer_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerPerBuyerSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerPerBuyerSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_per_buyer_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignals` instead "
    "of `ReadDirectFromSellerAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerAuctionSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GenerateBidFinalizer_FinishGenerateBid_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorklet_BeginGenerateBid_ParamsDataView {
 public:
  BidderWorklet_BeginGenerateBid_ParamsDataView() = default;

  BidderWorklet_BeginGenerateBid_ParamsDataView(
      internal::BidderWorklet_BeginGenerateBid_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBidderWorkletNonSharedParamsDataView(
      BidderWorkletNonSharedParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidderWorkletNonSharedParams(UserType* output) {
    
    auto* pointer = data_->bidder_worklet_non_shared_params.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView>(
        pointer, output, message_);
  }
  inline void GetKeyValueSignalsCacheKeyDataView(
      ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyValueSignalsCacheKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView, UserType>(),
    "Attempting to read the optional `key_value_signals_cache_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyValueSignalsCacheKey` instead "
    "of `ReadKeyValueSignalsCacheKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_value_signals_cache_key.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::TrustedSignalsCacheKeyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadKanonMode(UserType* output) const {
    auto data_value = data_->kanon_mode;
    return mojo::internal::Deserialize<::auction_worklet::mojom::KAnonymityBidMode>(
        data_value, output);
  }
  KAnonymityBidMode kanon_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::KAnonymityBidMode>(data_->kanon_mode));
  }
  inline void GetInterestGroupJoinOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupJoinOrigin(UserType* output) {
    
    auto* pointer = data_->interest_group_join_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerPerBuyerSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerPerBuyerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_per_buyer_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerPerBuyerSignals` instead "
    "of `ReadDirectFromSellerPerBuyerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_per_buyer_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignals` instead "
    "of `ReadDirectFromSellerAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalSellerOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalSellerOrigin(UserType* output) {
    
    auto* pointer = data_->browser_signal_seller_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalTopLevelSellerOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalTopLevelSellerOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `browser_signal_top_level_seller_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalTopLevelSellerOrigin` instead "
    "of `ReadBrowserSignalTopLevelSellerOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_top_level_seller_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalRecencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalRecency(UserType* output) {
    
    auto* pointer = data_->browser_signal_recency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool browser_signal_for_debugging_only_sampling() const {
    return data_->browser_signal_for_debugging_only_sampling;
  }
  inline void GetBiddingBrowserSignalsDataView(
      ::blink::mojom::BiddingBrowserSignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiddingBrowserSignals(UserType* output) {
    
    auto* pointer = data_->bidding_browser_signals.Get();
    return mojo::internal::Deserialize<::blink::mojom::BiddingBrowserSignalsDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionStartTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionStartTime(UserType* output) {
    
    auto* pointer = data_->auction_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetRequestedAdSizeDataView(
      ::blink::mojom::AdSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedAdSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdSizeDataView, UserType>(),
    "Attempting to read the optional `requested_ad_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestedAdSize` instead "
    "of `ReadRequestedAdSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->requested_ad_size.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdSizeDataView>(
        pointer, output, message_);
  }
  uint16_t multi_bid_limit() const {
    return data_->multi_bid_limit;
  }
  uint64_t group_by_origin_id() const {
    return data_->group_by_origin_id;
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  template <typename UserType>
  UserType TakeGenerateBidClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::auction_worklet::mojom::GenerateBidClientAssociatedPtrInfoDataView>(
            &data_->generate_bid_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeBidFinalizer() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::auction_worklet::mojom::GenerateBidFinalizerAssociatedRequestDataView>(
            &data_->bid_finalizer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BidderWorklet_BeginGenerateBid_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorklet_SendPendingSignalsRequests_ParamsDataView {
 public:
  BidderWorklet_SendPendingSignalsRequests_ParamsDataView() = default;

  BidderWorklet_SendPendingSignalsRequests_ParamsDataView(
      internal::BidderWorklet_SendPendingSignalsRequests_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::BidderWorklet_SendPendingSignalsRequests_Params_Data* data_ = nullptr;
};


class BidderWorklet_ReportWin_ParamsDataView {
 public:
  BidderWorklet_ReportWin_ParamsDataView() = default;

  BidderWorklet_ReportWin_ParamsDataView(
      internal::BidderWorklet_ReportWin_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_for_additional_bid() const {
    return data_->is_for_additional_bid;
  }
  inline void GetInterestGroupNameReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupNameReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `interest_group_name_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterestGroupNameReportingId` instead "
    "of `ReadInterestGroupNameReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interest_group_name_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `buyer_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuyerReportingId` instead "
    "of `ReadBuyerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buyer_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuyerAndSellerReportingId` instead "
    "of `ReadBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `selected_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelectedBuyerAndSellerReportingId` instead "
    "of `ReadSelectedBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selected_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionSignalsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionSignalsJson(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `auction_signals_json` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuctionSignalsJson` instead "
    "of `ReadAuctionSignalsJson if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auction_signals_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPerBuyerSignalsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerBuyerSignalsJson(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `per_buyer_signals_json` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPerBuyerSignalsJson` instead "
    "of `ReadPerBuyerSignalsJson if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->per_buyer_signals_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerPerBuyerSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerPerBuyerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_per_buyer_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerPerBuyerSignals` instead "
    "of `ReadDirectFromSellerPerBuyerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_per_buyer_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerPerBuyerSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerPerBuyerSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_per_buyer_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerPerBuyerSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerPerBuyerSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_per_buyer_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignals` instead "
    "of `ReadDirectFromSellerAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerAuctionSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSellerSignalsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerSignalsJson(UserType* output) {
    
    auto* pointer = data_->seller_signals_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadKanonStatus(UserType* output) const {
    auto data_value = data_->kanon_status;
    return mojo::internal::Deserialize<::auction_worklet::mojom::KAnonymityStatus>(
        data_value, output);
  }
  KAnonymityStatus kanon_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::KAnonymityStatus>(data_->kanon_status));
  }
  inline void GetBrowserSignalRenderUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalRenderUrl(UserType* output) {
    
    auto* pointer = data_->browser_signal_render_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  double browser_signal_bid() const {
    return data_->browser_signal_bid;
  }
  inline void GetBrowserSignalBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `browser_signal_bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalBidCurrency` instead "
    "of `ReadBrowserSignalBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  double browser_signal_highest_scoring_other_bid() const {
    return data_->browser_signal_highest_scoring_other_bid;
  }
  inline void GetBrowserSignalHighestScoringOtherBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalHighestScoringOtherBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `browser_signal_highest_scoring_other_bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalHighestScoringOtherBidCurrency` instead "
    "of `ReadBrowserSignalHighestScoringOtherBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_highest_scoring_other_bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  bool browser_signal_made_highest_scoring_other_bid() const {
    return data_->browser_signal_made_highest_scoring_other_bid;
  }
  std::optional<double> browser_signal_ad_cost() const {

    return data_->browser_signal_ad_cost_$flag
        ? std::make_optional(data_->browser_signal_ad_cost_$value)
        : std::nullopt;
  }
  std::optional<uint16_t> browser_signal_modeling_signals() const {

    return data_->browser_signal_modeling_signals_$flag
        ? std::make_optional(data_->browser_signal_modeling_signals_$value)
        : std::nullopt;
  }
  uint8_t browser_signal_join_count() const {
    return data_->browser_signal_join_count;
  }
  uint8_t browser_signal_recency() const {
    return data_->browser_signal_recency;
  }
  inline void GetBrowserSignalSellerOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalSellerOrigin(UserType* output) {
    
    auto* pointer = data_->browser_signal_seller_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalTopLevelSellerOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalTopLevelSellerOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `browser_signal_top_level_seller_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalTopLevelSellerOrigin` instead "
    "of `ReadBrowserSignalTopLevelSellerOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_top_level_seller_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalReportingTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalReportingTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `browser_signal_reporting_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalReportingTimeout` instead "
    "of `ReadBrowserSignalReportingTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_reporting_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  std::optional<uint32_t> bidding_signals_data_version() const {

    return data_->bidding_signals_data_version_$flag
        ? std::make_optional(data_->bidding_signals_data_version_$value)
        : std::nullopt;
  }
  inline void GetAggregateWinSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregateWinSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `aggregate_win_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregateWinSignals` instead "
    "of `ReadAggregateWinSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregate_win_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
 private:
  internal::BidderWorklet_ReportWin_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorklet_ReportWin_ResponseParamsDataView {
 public:
  BidderWorklet_ReportWin_ResponseParamsDataView() = default;

  BidderWorklet_ReportWin_ResponseParamsDataView(
      internal::BidderWorklet_ReportWin_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `report_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportUrl` instead "
    "of `ReadReportUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAdBeaconMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdBeaconMap(UserType* output) {
    
    auto* pointer = data_->ad_beacon_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetAdMacroMapDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdMacroMap(UserType* output) {
    
    auto* pointer = data_->ad_macro_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetPaRequestsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaRequests(UserType* output) {
    
    auto* pointer = data_->pa_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetPmtRequestDataDataView(
      PrivateModelTrainingRequestDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPmtRequestData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::PrivateModelTrainingRequestDataDataView, UserType>(),
    "Attempting to read the optional `pmt_request_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPmtRequestData` instead "
    "of `ReadPmtRequestData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pmt_request_data.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::PrivateModelTrainingRequestDataDataView>(
        pointer, output, message_);
  }
  inline void GetTimingMetricsDataView(
      BidderTimingMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingMetrics(UserType* output) {
    
    auto* pointer = data_->timing_metrics.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::BidderTimingMetricsDataView>(
        pointer, output, message_);
  }
  inline void GetErrorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrors(UserType* output) {
    
    auto* pointer = data_->errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BidderWorklet_ReportWin_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorklet_ConnectDevToolsAgent_ParamsDataView {
 public:
  BidderWorklet_ConnectDevToolsAgent_ParamsDataView() = default;

  BidderWorklet_ConnectDevToolsAgent_ParamsDataView(
      internal::BidderWorklet_ConnectDevToolsAgent_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAgent() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
            &data_->agent, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint32_t thread_index() const {
    return data_->thread_index;
  }
 private:
  internal::BidderWorklet_ConnectDevToolsAgent_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView::GetPriorityVectorDataView(
    mojo::MapDataView<mojo::StringDataView, double>* output) {
  auto pointer = data_->priority_vector.Get();
  *output = mojo::MapDataView<mojo::StringDataView, double>(pointer, message_);
}
inline void GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView::GetTrustedSignalsFetchLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->trusted_signals_fetch_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GenerateBidClient_OnBiddingSignalsReceived_ParamsDataView::GetUpdateIfOlderThanDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->update_if_older_than.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetBidsDataView(
    mojo::ArrayDataView<BidderWorkletBidDataView>* output) {
  auto pointer = data_->bids.Get();
  *output = mojo::ArrayDataView<BidderWorkletBidDataView>(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetDebugLossReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->debug_loss_report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetDebugWinReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->debug_win_report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetUpdatePrioritySignalsOverridesDataView(
    mojo::MapDataView<mojo::StringDataView, PrioritySignalsDoubleDataView>* output) {
  auto pointer = data_->update_priority_signals_overrides.Get();
  *output = mojo::MapDataView<mojo::StringDataView, PrioritySignalsDoubleDataView>(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetPaRequestsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output) {
  auto pointer = data_->pa_requests.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetNonKanonPaRequestsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output) {
  auto pointer = data_->non_kanon_pa_requests.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetRealTimeContributionsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>* output) {
  auto pointer = data_->real_time_contributions.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetGenerateBidTimingMetricsDataView(
    BidderTimingMetricsDataView* output) {
  auto pointer = data_->generate_bid_timing_metrics.Get();
  *output = BidderTimingMetricsDataView(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetGenerateBidDependencyLatenciesDataView(
    GenerateBidDependencyLatenciesDataView* output) {
  auto pointer = data_->generate_bid_dependency_latencies.Get();
  *output = GenerateBidDependencyLatenciesDataView(pointer, message_);
}
inline void GenerateBidClient_OnGenerateBidComplete_ParamsDataView::GetErrorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->errors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetAuctionSignalsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->auction_signals_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetPerBuyerSignalsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->per_buyer_signals_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetPerBuyerTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->per_buyer_timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetExpectedBuyerCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->expected_buyer_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetDirectFromSellerPerBuyerSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_per_buyer_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetDirectFromSellerPerBuyerSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_per_buyer_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetDirectFromSellerAuctionSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void GenerateBidFinalizer_FinishGenerateBid_ParamsDataView::GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetBidderWorkletNonSharedParamsDataView(
    BidderWorkletNonSharedParamsDataView* output) {
  auto pointer = data_->bidder_worklet_non_shared_params.Get();
  *output = BidderWorkletNonSharedParamsDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetKeyValueSignalsCacheKeyDataView(
    ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView* output) {
  auto pointer = data_->key_value_signals_cache_key.Get();
  *output = ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetInterestGroupJoinOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->interest_group_join_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetDirectFromSellerPerBuyerSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_per_buyer_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetDirectFromSellerAuctionSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetBrowserSignalSellerOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->browser_signal_seller_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetBrowserSignalTopLevelSellerOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->browser_signal_top_level_seller_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetBrowserSignalRecencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->browser_signal_recency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetBiddingBrowserSignalsDataView(
    ::blink::mojom::BiddingBrowserSignalsDataView* output) {
  auto pointer = data_->bidding_browser_signals.Get();
  *output = ::blink::mojom::BiddingBrowserSignalsDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetAuctionStartTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->auction_start_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void BidderWorklet_BeginGenerateBid_ParamsDataView::GetRequestedAdSizeDataView(
    ::blink::mojom::AdSizeDataView* output) {
  auto pointer = data_->requested_ad_size.Get();
  *output = ::blink::mojom::AdSizeDataView(pointer, message_);
}




inline void BidderWorklet_ReportWin_ParamsDataView::GetInterestGroupNameReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->interest_group_name_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBuyerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->buyer_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetSelectedBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->selected_buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetAuctionSignalsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->auction_signals_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetPerBuyerSignalsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->per_buyer_signals_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetDirectFromSellerPerBuyerSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_per_buyer_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetDirectFromSellerPerBuyerSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_per_buyer_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetDirectFromSellerAuctionSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetSellerSignalsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->seller_signals_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBrowserSignalRenderUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->browser_signal_render_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBrowserSignalBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->browser_signal_bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBrowserSignalHighestScoringOtherBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->browser_signal_highest_scoring_other_bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBrowserSignalSellerOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->browser_signal_seller_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBrowserSignalTopLevelSellerOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->browser_signal_top_level_seller_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetBrowserSignalReportingTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->browser_signal_reporting_timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ParamsDataView::GetAggregateWinSignalsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->aggregate_win_signals.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetAdBeaconMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output) {
  auto pointer = data_->ad_beacon_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>(pointer, message_);
}
inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetAdMacroMapDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->ad_macro_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}
inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetPaRequestsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output) {
  auto pointer = data_->pa_requests.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>(pointer, message_);
}
inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetPmtRequestDataDataView(
    PrivateModelTrainingRequestDataDataView* output) {
  auto pointer = data_->pmt_request_data.Get();
  *output = PrivateModelTrainingRequestDataDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetTimingMetricsDataView(
    BidderTimingMetricsDataView* output) {
  auto pointer = data_->timing_metrics.Get();
  *output = BidderTimingMetricsDataView(pointer, message_);
}
inline void BidderWorklet_ReportWin_ResponseParamsDataView::GetErrorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->errors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}





}  // auction_worklet::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_PARAMS_DATA_H_