// content/browser/tracing/traces_internals/traces_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/tracing/traces_internals/traces_internals.mojom-features.h"  // IWYU pragma: export
#include "content/browser/tracing/traces_internals/traces_internals.mojom-shared.h"  // IWYU pragma: export
#include "content/browser/tracing/traces_internals/traces_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/browser/tracing/trace_report_database.h"
#include "content/browser/tracing/traces_internals/traces_internals_mojom_traits.h"
#include "content/browser/tracing/tracing_scenario.h"




namespace traces_internals::mojom {

class TracesInternalsHandlerFactoryProxy;

template <typename ImplRefTraits>
class TracesInternalsHandlerFactoryStub;

class TracesInternalsHandlerFactoryRequestValidator;


class TracesInternalsHandlerFactory
    : public TracesInternalsHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "traces_internals.mojom.TracesInternalsHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TracesInternalsHandlerFactoryInterfaceBase;
  using Proxy_ = TracesInternalsHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = TracesInternalsHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = TracesInternalsHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TracesInternalsHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "traces_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartTraceSessionMinVersion = 0,
    kCloneTraceSessionMinVersion = 0,
    kStopTraceSessionMinVersion = 0,
    kGetTrackEventCategoriesMinVersion = 0,
    kGetBufferUsageMinVersion = 0,
    kGetAllTraceReportsMinVersion = 0,
    kDeleteSingleTraceMinVersion = 0,
    kDeleteAllTracesMinVersion = 0,
    kUserUploadSingleTraceMinVersion = 0,
    kDownloadTraceMinVersion = 0,
    kGetAllScenariosMinVersion = 0,
    kSetEnabledScenariosMinVersion = 0,
    kSetScenariosConfigFromStringMinVersion = 0,
    kSetScenariosConfigFromBufferMinVersion = 0,
    kGetPrivacyFilterEnabledMinVersion = 0,
    kSetPrivacyFilterEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartTraceSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloneTraceSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopTraceSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTrackEventCategories_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBufferUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllTraceReports_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteSingleTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAllTraces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UserUploadSingleTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllScenarios_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnabledScenarios_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetScenariosConfigFromString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetScenariosConfigFromBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPrivacyFilterEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPrivacyFilterEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using StartTraceSessionCallback = base::OnceCallback<void(bool)>;
  using StartTraceSessionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void StartTraceSession(::mojo_base::BigBuffer config_pb, bool enable_privacy_filters, StartTraceSessionCallback callback) = 0;

  using CloneTraceSessionCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>, const std::optional<::base::Token>&)>;
  using CloneTraceSessionMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>, const std::optional<::base::Token>&)>;

  virtual void CloneTraceSession(CloneTraceSessionCallback callback) = 0;

  using StopTraceSessionCallback = base::OnceCallback<void(bool)>;
  using StopTraceSessionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void StopTraceSession(StopTraceSessionCallback callback) = 0;

  using GetTrackEventCategoriesCallback = base::OnceCallback<void(std::vector<TraceCategoryPtr>)>;
  using GetTrackEventCategoriesMojoCallback = base::OnceCallback<void(std::vector<TraceCategoryPtr>)>;

  virtual void GetTrackEventCategories(GetTrackEventCategoriesCallback callback) = 0;

  using GetBufferUsageCallback = base::OnceCallback<void(bool, float, bool)>;
  using GetBufferUsageMojoCallback = base::OnceCallback<void(bool, float, bool)>;

  virtual void GetBufferUsage(GetBufferUsageCallback callback) = 0;

  using GetAllTraceReportsCallback = base::OnceCallback<void(std::vector<ClientTraceReportPtr>)>;
  using GetAllTraceReportsMojoCallback = base::OnceCallback<void(std::vector<ClientTraceReportPtr>)>;

  virtual void GetAllTraceReports(GetAllTraceReportsCallback callback) = 0;

  using DeleteSingleTraceCallback = base::OnceCallback<void(bool)>;
  using DeleteSingleTraceMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) = 0;

  using DeleteAllTracesCallback = base::OnceCallback<void(bool)>;
  using DeleteAllTracesMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteAllTraces(DeleteAllTracesCallback callback) = 0;

  using UserUploadSingleTraceCallback = base::OnceCallback<void(bool)>;
  using UserUploadSingleTraceMojoCallback = base::OnceCallback<void(bool)>;

  virtual void UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) = 0;

  using DownloadTraceCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  using DownloadTraceMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;

  virtual void DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) = 0;

  using GetAllScenariosCallback = base::OnceCallback<void(std::vector<ScenarioPtr>)>;
  using GetAllScenariosMojoCallback = base::OnceCallback<void(std::vector<ScenarioPtr>)>;

  virtual void GetAllScenarios(GetAllScenariosCallback callback) = 0;

  using SetEnabledScenariosCallback = base::OnceCallback<void(bool)>;
  using SetEnabledScenariosMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) = 0;

  using SetScenariosConfigFromStringCallback = base::OnceCallback<void(bool)>;
  using SetScenariosConfigFromStringMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetScenariosConfigFromString(const std::string& config_string, SetScenariosConfigFromStringCallback callback) = 0;

  using SetScenariosConfigFromBufferCallback = base::OnceCallback<void(bool)>;
  using SetScenariosConfigFromBufferMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetScenariosConfigFromBuffer(::mojo_base::BigBuffer config_pb, SetScenariosConfigFromBufferCallback callback) = 0;

  using GetPrivacyFilterEnabledCallback = base::OnceCallback<void(bool)>;
  using GetPrivacyFilterEnabledMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) = 0;

  virtual void SetPrivacyFilterEnabled(bool enable) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "traces_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTraceCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTraceComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnTraceComplete(std::optional<::mojo_base::BigBuffer> trace, const std::optional<::base::Token>& uuid) = 0;
};



class  TracesInternalsHandlerFactoryProxy
    : public TracesInternalsHandlerFactory {
 public:
  using InterfaceType = TracesInternalsHandlerFactory;

  explicit TracesInternalsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartTraceSession(::mojo_base::BigBuffer config_pb, bool enable_privacy_filters, StartTraceSessionCallback callback) final;
  
  void CloneTraceSession(CloneTraceSessionCallback callback) final;
  
  void StopTraceSession(StopTraceSessionCallback callback) final;
  
  void GetTrackEventCategories(GetTrackEventCategoriesCallback callback) final;
  
  void GetBufferUsage(GetBufferUsageCallback callback) final;
  
  void GetAllTraceReports(GetAllTraceReportsCallback callback) final;
  
  void DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) final;
  
  void DeleteAllTraces(DeleteAllTracesCallback callback) final;
  
  void UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) final;
  
  void DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) final;
  
  void GetAllScenarios(GetAllScenariosCallback callback) final;
  
  void SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) final;
  
  void SetScenariosConfigFromString(const std::string& config_string, SetScenariosConfigFromStringCallback callback) final;
  
  void SetScenariosConfigFromBuffer(::mojo_base::BigBuffer config_pb, SetScenariosConfigFromBufferCallback callback) final;
  
  void GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) final;
  
  void SetPrivacyFilterEnabled(bool enable) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTraceComplete(std::optional<::mojo_base::BigBuffer> trace, const std::optional<::base::Token>& uuid) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TracesInternalsHandlerFactoryStubDispatch {
 public:
  static bool Accept(TracesInternalsHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TracesInternalsHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TracesInternalsHandlerFactory>>
class TracesInternalsHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TracesInternalsHandlerFactoryStub() = default;
  ~TracesInternalsHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracesInternalsHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracesInternalsHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TracesInternalsHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  ClientTraceReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientTraceReport, T>::value>;
  using DataView = ClientTraceReportDataView;
  using Data_ = internal::ClientTraceReport_Data;

  template <typename... Args>
  static ClientTraceReportPtr New(Args&&... args) {
    return ClientTraceReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientTraceReportPtr From(const U& u) {
    return mojo::TypeConverter<ClientTraceReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientTraceReport>::Convert(*this);
  }


  ClientTraceReport();

  ClientTraceReport(
      const ::base::Token& uuid,
      ::base::Time creation_time,
      const std::string& scenario_name,
      const std::string& upload_rule_name,
      std::optional<int32_t> upload_rule_value,
      int64_t total_size,
      ::content::ReportUploadState upload_state,
      ::base::Time upload_time,
      ::content::SkipUploadReason skip_reason,
      bool has_trace_content);


  ~ClientTraceReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientTraceReportPtr>
  ClientTraceReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientTraceReport::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientTraceReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientTraceReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientTraceReport_UnserializedMessageContext<
            UserType, ClientTraceReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClientTraceReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClientTraceReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientTraceReport_UnserializedMessageContext<
            UserType, ClientTraceReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientTraceReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token uuid;
  
  ::base::Time creation_time;
  
  std::string scenario_name;
  
  std::string upload_rule_name;
  
  std::optional<int32_t> upload_rule_value;
  
  int64_t total_size;
  
  ::content::ReportUploadState upload_state;
  
  ::base::Time upload_time;
  
  ::content::SkipUploadReason skip_reason;
  
  bool has_trace_content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientTraceReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Scenario {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Scenario, T>::value>;
  using DataView = ScenarioDataView;
  using Data_ = internal::Scenario_Data;

  template <typename... Args>
  static ScenarioPtr New(Args&&... args) {
    return ScenarioPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScenarioPtr From(const U& u) {
    return mojo::TypeConverter<ScenarioPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Scenario>::Convert(*this);
  }


  Scenario();

  Scenario(
      const std::string& scenario_name,
      const std::string& description,
      bool is_local_scenario,
      bool is_enabled,
      ::content::TracingScenario::State current_state);


  ~Scenario();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScenarioPtr>
  ScenarioPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Scenario::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Scenario::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Scenario::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Scenario::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Scenario::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Scenario::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Scenario_UnserializedMessageContext<
            UserType, Scenario::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Scenario::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Scenario::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Scenario_UnserializedMessageContext<
            UserType, Scenario::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Scenario::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string scenario_name;
  
  std::string description;
  
  bool is_local_scenario;
  
  bool is_enabled;
  
  ::content::TracingScenario::State current_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Scenario::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TraceCategory {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TraceCategory, T>::value>;
  using DataView = TraceCategoryDataView;
  using Data_ = internal::TraceCategory_Data;

  template <typename... Args>
  static TraceCategoryPtr New(Args&&... args) {
    return TraceCategoryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TraceCategoryPtr From(const U& u) {
    return mojo::TypeConverter<TraceCategoryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TraceCategory>::Convert(*this);
  }


  TraceCategory();

  TraceCategory(
      const std::string& name,
      bool is_group,
      const std::string& description,
      std::vector<std::string> tags);


  ~TraceCategory();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TraceCategoryPtr>
  TraceCategoryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TraceCategory::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TraceCategory::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TraceCategory::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TraceCategory_UnserializedMessageContext<
            UserType, TraceCategory::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TraceCategory::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TraceCategory::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TraceCategory_UnserializedMessageContext<
            UserType, TraceCategory::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TraceCategory::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  bool is_group;
  
  std::string description;
  
  std::vector<std::string> tags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TraceCategory::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ClientTraceReportPtr ClientTraceReport::Clone() const {
  return New(
      mojo::Clone(uuid),
      mojo::Clone(creation_time),
      mojo::Clone(scenario_name),
      mojo::Clone(upload_rule_name),
      mojo::Clone(upload_rule_value),
      mojo::Clone(total_size),
      mojo::Clone(upload_state),
      mojo::Clone(upload_time),
      mojo::Clone(skip_reason),
      mojo::Clone(has_trace_content)
  );
}

template <typename T, ClientTraceReport::EnableIfSame<T>*>
bool ClientTraceReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->scenario_name, other_struct.scenario_name))
    return false;
  if (!mojo::Equals(this->upload_rule_name, other_struct.upload_rule_name))
    return false;
  if (!mojo::Equals(this->upload_rule_value, other_struct.upload_rule_value))
    return false;
  if (!mojo::Equals(this->total_size, other_struct.total_size))
    return false;
  if (!mojo::Equals(this->upload_state, other_struct.upload_state))
    return false;
  if (!mojo::Equals(this->upload_time, other_struct.upload_time))
    return false;
  if (!mojo::Equals(this->skip_reason, other_struct.skip_reason))
    return false;
  if (!mojo::Equals(this->has_trace_content, other_struct.has_trace_content))
    return false;
  return true;
}

template <typename T, ClientTraceReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  if (lhs.scenario_name < rhs.scenario_name)
    return true;
  if (rhs.scenario_name < lhs.scenario_name)
    return false;
  if (lhs.upload_rule_name < rhs.upload_rule_name)
    return true;
  if (rhs.upload_rule_name < lhs.upload_rule_name)
    return false;
  if (lhs.upload_rule_value < rhs.upload_rule_value)
    return true;
  if (rhs.upload_rule_value < lhs.upload_rule_value)
    return false;
  if (lhs.total_size < rhs.total_size)
    return true;
  if (rhs.total_size < lhs.total_size)
    return false;
  if (lhs.upload_state < rhs.upload_state)
    return true;
  if (rhs.upload_state < lhs.upload_state)
    return false;
  if (lhs.upload_time < rhs.upload_time)
    return true;
  if (rhs.upload_time < lhs.upload_time)
    return false;
  if (lhs.skip_reason < rhs.skip_reason)
    return true;
  if (rhs.skip_reason < lhs.skip_reason)
    return false;
  if (lhs.has_trace_content < rhs.has_trace_content)
    return true;
  if (rhs.has_trace_content < lhs.has_trace_content)
    return false;
  return false;
}
template <typename StructPtrType>
ScenarioPtr Scenario::Clone() const {
  return New(
      mojo::Clone(scenario_name),
      mojo::Clone(description),
      mojo::Clone(is_local_scenario),
      mojo::Clone(is_enabled),
      mojo::Clone(current_state)
  );
}

template <typename T, Scenario::EnableIfSame<T>*>
bool Scenario::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scenario_name, other_struct.scenario_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->is_local_scenario, other_struct.is_local_scenario))
    return false;
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->current_state, other_struct.current_state))
    return false;
  return true;
}

template <typename T, Scenario::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scenario_name < rhs.scenario_name)
    return true;
  if (rhs.scenario_name < lhs.scenario_name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.is_local_scenario < rhs.is_local_scenario)
    return true;
  if (rhs.is_local_scenario < lhs.is_local_scenario)
    return false;
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.current_state < rhs.current_state)
    return true;
  if (rhs.current_state < lhs.current_state)
    return false;
  return false;
}
template <typename StructPtrType>
TraceCategoryPtr TraceCategory::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(is_group),
      mojo::Clone(description),
      mojo::Clone(tags)
  );
}

template <typename T, TraceCategory::EnableIfSame<T>*>
bool TraceCategory::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->is_group, other_struct.is_group))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->tags, other_struct.tags))
    return false;
  return true;
}

template <typename T, TraceCategory::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.is_group < rhs.is_group)
    return true;
  if (rhs.is_group < lhs.is_group)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.tags < rhs.tags)
    return true;
  if (rhs.tags < lhs.tags)
    return false;
  return false;
}


}  // traces_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::traces_internals::mojom::ClientTraceReport::DataView,
                                         ::traces_internals::mojom::ClientTraceReportPtr> {
  static bool IsNull(const ::traces_internals::mojom::ClientTraceReportPtr& input) { return !input; }
  static void SetToNull(::traces_internals::mojom::ClientTraceReportPtr* output) { output->reset(); }

  static const decltype(::traces_internals::mojom::ClientTraceReport::uuid)& uuid(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->uuid;
  }

  static const decltype(::traces_internals::mojom::ClientTraceReport::creation_time)& creation_time(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->creation_time;
  }

  static const decltype(::traces_internals::mojom::ClientTraceReport::scenario_name)& scenario_name(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->scenario_name;
  }

  static const decltype(::traces_internals::mojom::ClientTraceReport::upload_rule_name)& upload_rule_name(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->upload_rule_name;
  }

  static decltype(::traces_internals::mojom::ClientTraceReport::upload_rule_value) upload_rule_value(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->upload_rule_value;
  }

  static decltype(::traces_internals::mojom::ClientTraceReport::total_size) total_size(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->total_size;
  }

  static decltype(::traces_internals::mojom::ClientTraceReport::upload_state) upload_state(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->upload_state;
  }

  static const decltype(::traces_internals::mojom::ClientTraceReport::upload_time)& upload_time(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->upload_time;
  }

  static decltype(::traces_internals::mojom::ClientTraceReport::skip_reason) skip_reason(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->skip_reason;
  }

  static decltype(::traces_internals::mojom::ClientTraceReport::has_trace_content) has_trace_content(
      const ::traces_internals::mojom::ClientTraceReportPtr& input) {
    return input->has_trace_content;
  }

  static bool Read(::traces_internals::mojom::ClientTraceReport::DataView input, ::traces_internals::mojom::ClientTraceReportPtr* output);
};


template <>
struct  StructTraits<::traces_internals::mojom::Scenario::DataView,
                                         ::traces_internals::mojom::ScenarioPtr> {
  static bool IsNull(const ::traces_internals::mojom::ScenarioPtr& input) { return !input; }
  static void SetToNull(::traces_internals::mojom::ScenarioPtr* output) { output->reset(); }

  static const decltype(::traces_internals::mojom::Scenario::scenario_name)& scenario_name(
      const ::traces_internals::mojom::ScenarioPtr& input) {
    return input->scenario_name;
  }

  static const decltype(::traces_internals::mojom::Scenario::description)& description(
      const ::traces_internals::mojom::ScenarioPtr& input) {
    return input->description;
  }

  static decltype(::traces_internals::mojom::Scenario::is_local_scenario) is_local_scenario(
      const ::traces_internals::mojom::ScenarioPtr& input) {
    return input->is_local_scenario;
  }

  static decltype(::traces_internals::mojom::Scenario::is_enabled) is_enabled(
      const ::traces_internals::mojom::ScenarioPtr& input) {
    return input->is_enabled;
  }

  static decltype(::traces_internals::mojom::Scenario::current_state) current_state(
      const ::traces_internals::mojom::ScenarioPtr& input) {
    return input->current_state;
  }

  static bool Read(::traces_internals::mojom::Scenario::DataView input, ::traces_internals::mojom::ScenarioPtr* output);
};


template <>
struct  StructTraits<::traces_internals::mojom::TraceCategory::DataView,
                                         ::traces_internals::mojom::TraceCategoryPtr> {
  static bool IsNull(const ::traces_internals::mojom::TraceCategoryPtr& input) { return !input; }
  static void SetToNull(::traces_internals::mojom::TraceCategoryPtr* output) { output->reset(); }

  static const decltype(::traces_internals::mojom::TraceCategory::name)& name(
      const ::traces_internals::mojom::TraceCategoryPtr& input) {
    return input->name;
  }

  static decltype(::traces_internals::mojom::TraceCategory::is_group) is_group(
      const ::traces_internals::mojom::TraceCategoryPtr& input) {
    return input->is_group;
  }

  static const decltype(::traces_internals::mojom::TraceCategory::description)& description(
      const ::traces_internals::mojom::TraceCategoryPtr& input) {
    return input->description;
  }

  static const decltype(::traces_internals::mojom::TraceCategory::tags)& tags(
      const ::traces_internals::mojom::TraceCategoryPtr& input) {
    return input->tags;
  }

  static bool Read(::traces_internals::mojom::TraceCategory::DataView input, ::traces_internals::mojom::TraceCategoryPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_H_