// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.h.template is used to generate vector_icons.h. Edit the former
// rather than the latter.

#ifndef COMPONENTS_VECTOR_ICONS_VECTOR_ICONS_H_
#define COMPONENTS_VECTOR_ICONS_VECTOR_ICONS_H_

namespace gfx {
struct VectorIcon;
}

#define VECTOR_ICON_TEMPLATE_H(icon_name) \
extern const gfx::VectorIcon icon_name;

#if defined(FEATURE_MODULES) && defined(COMPONENTS_VECTOR_ICONS_IMPL)
#define VECTOR_ICON_EXPORT __attribute__((visibility("default")))
#endif

namespace vector_icons {

VECTOR_ICON_TEMPLATE_H(kProductIcon)
VECTOR_ICON_TEMPLATE_H(kProductRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kAccountCircleIcon)
VECTOR_ICON_TEMPLATE_H(kAccountCircleChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kAccountCircleOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kAddIcon)
VECTOR_ICON_TEMPLATE_H(kAddLinkIcon)
VECTOR_ICON_TEMPLATE_H(kAdsIcon)
VECTOR_ICON_TEMPLATE_H(kAdsChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kAdsClickIcon)
VECTOR_ICON_TEMPLATE_H(kAdsOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kArrowBackIcon)
VECTOR_ICON_TEMPLATE_H(kArrowBackChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kArrowRightAltIcon)
VECTOR_ICON_TEMPLATE_H(kBackArrowIcon)
VECTOR_ICON_TEMPLATE_H(kBackArrowChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kBackToTabIcon)
VECTOR_ICON_TEMPLATE_H(kBackToTabChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kBlockedBadgeIcon)
VECTOR_ICON_TEMPLATE_H(kBluetoothIcon)
VECTOR_ICON_TEMPLATE_H(kBluetoothChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kBluetoothConnectedIcon)
VECTOR_ICON_TEMPLATE_H(kBluetoothOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kBluetoothScanningIcon)
VECTOR_ICON_TEMPLATE_H(kBluetoothScanningChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kBusinessIcon)
VECTOR_ICON_TEMPLATE_H(kBusinessChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kCallIcon)
VECTOR_ICON_TEMPLATE_H(kCallEndIcon)
VECTOR_ICON_TEMPLATE_H(kCallRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kCancelIcon)
VECTOR_ICON_TEMPLATE_H(kCancelChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kCaptureIcon)
VECTOR_ICON_TEMPLATE_H(kCardboardIcon)
VECTOR_ICON_TEMPLATE_H(kCaretDownIcon)
VECTOR_ICON_TEMPLATE_H(kCaretUpIcon)
VECTOR_ICON_TEMPLATE_H(kCastIcon)
VECTOR_ICON_TEMPLATE_H(kCastWarningIcon)
VECTOR_ICON_TEMPLATE_H(kCelebrationIcon)
VECTOR_ICON_TEMPLATE_H(kCertificateIcon)
VECTOR_ICON_TEMPLATE_H(kCertificateOffIcon)
VECTOR_ICON_TEMPLATE_H(kChatIcon)
VECTOR_ICON_TEMPLATE_H(kChatSparkIcon)
VECTOR_ICON_TEMPLATE_H(kCheckCircleIcon)
VECTOR_ICON_TEMPLATE_H(kChecklistIcon)
VECTOR_ICON_TEMPLATE_H(kCloseIcon)
VECTOR_ICON_TEMPLATE_H(kCloseChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kCloseRoundedIcon)
VECTOR_ICON_TEMPLATE_H(kCloseSmallIcon)
VECTOR_ICON_TEMPLATE_H(kCodeIcon)
VECTOR_ICON_TEMPLATE_H(kCodeChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kCodeOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kContentCopyIcon)
VECTOR_ICON_TEMPLATE_H(kContentPasteIcon)
VECTOR_ICON_TEMPLATE_H(kContentPasteOffIcon)
VECTOR_ICON_TEMPLATE_H(kCookieIcon)
VECTOR_ICON_TEMPLATE_H(kCookieChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kCookieOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kDangerousIcon)
VECTOR_ICON_TEMPLATE_H(kDangerousChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kDatabaseIcon)
VECTOR_ICON_TEMPLATE_H(kDatabaseOffIcon)
VECTOR_ICON_TEMPLATE_H(kDescriptionIcon)
VECTOR_ICON_TEMPLATE_H(kDevicesIcon)
VECTOR_ICON_TEMPLATE_H(kDevicesOffIcon)
VECTOR_ICON_TEMPLATE_H(kDirectionsCarIcon)
VECTOR_ICON_TEMPLATE_H(kDocumentScannerIcon)
VECTOR_ICON_TEMPLATE_H(kDogfoodIcon)
VECTOR_ICON_TEMPLATE_H(kEditIcon)
VECTOR_ICON_TEMPLATE_H(kEditChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kEmailIcon)
VECTOR_ICON_TEMPLATE_H(kEmailOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kErrorIcon)
VECTOR_ICON_TEMPLATE_H(kErrorOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kEthernetIcon)
VECTOR_ICON_TEMPLATE_H(kExpandMoreIcon)
VECTOR_ICON_TEMPLATE_H(kExtensionIcon)
VECTOR_ICON_TEMPLATE_H(kExtensionChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kExtensionOffIcon)
VECTOR_ICON_TEMPLATE_H(kExtensionOnIcon)
VECTOR_ICON_TEMPLATE_H(kFamilyLinkIcon)
VECTOR_ICON_TEMPLATE_H(kFeedbackIcon)
VECTOR_ICON_TEMPLATE_H(kFileDownloadIcon)
VECTOR_ICON_TEMPLATE_H(kFileDownloadChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kFileDownloadOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kFingerprintIcon)
VECTOR_ICON_TEMPLATE_H(kFingerprintOffIcon)
VECTOR_ICON_TEMPLATE_H(kFolderIcon)
VECTOR_ICON_TEMPLATE_H(kFolderChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kFolderManagedRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kFolderOpenIcon)
VECTOR_ICON_TEMPLATE_H(kFontDownloadIcon)
VECTOR_ICON_TEMPLATE_H(kFontDownloadChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kFontDownloadOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kForward10Icon)
VECTOR_ICON_TEMPLATE_H(kForwardArrowIcon)
VECTOR_ICON_TEMPLATE_H(kForwardArrowChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kGlobeIcon)
VECTOR_ICON_TEMPLATE_H(kGoogleColorIcon)
VECTOR_ICON_TEMPLATE_H(kGppMaybeIcon)
VECTOR_ICON_TEMPLATE_H(kHandGestureIcon)
VECTOR_ICON_TEMPLATE_H(kHandGestureOffIcon)
VECTOR_ICON_TEMPLATE_H(kHeadsetIcon)
VECTOR_ICON_TEMPLATE_H(kHelpIcon)
VECTOR_ICON_TEMPLATE_H(kHelpOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kHistoryIcon)
VECTOR_ICON_TEMPLATE_H(kHistoryChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kHomeIcon)
VECTOR_ICON_TEMPLATE_H(kHttpsValidIcon)
VECTOR_ICON_TEMPLATE_H(kIdCardIcon)
VECTOR_ICON_TEMPLATE_H(kIframeIcon)
VECTOR_ICON_TEMPLATE_H(kIframeOffIcon)
VECTOR_ICON_TEMPLATE_H(kImageSearchIcon)
VECTOR_ICON_TEMPLATE_H(kInfoOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kInfoRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kInsertDriveFileOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kInstallDesktopIcon)
VECTOR_ICON_TEMPLATE_H(kInstallDesktopOffIcon)
VECTOR_ICON_TEMPLATE_H(kKeyboardIcon)
VECTOR_ICON_TEMPLATE_H(kKeyboardLockIcon)
VECTOR_ICON_TEMPLATE_H(kKeyboardLockOffIcon)
VECTOR_ICON_TEMPLATE_H(kLaunchIcon)
VECTOR_ICON_TEMPLATE_H(kLaunchChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kLaunchOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kLightbulbOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kLightbulbOutlineChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kLinkIcon)
VECTOR_ICON_TEMPLATE_H(kLiveCaptionOnIcon)
VECTOR_ICON_TEMPLATE_H(kLocationOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kLocationOnIcon)
VECTOR_ICON_TEMPLATE_H(kLocationOnChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kLockIcon)
VECTOR_ICON_TEMPLATE_H(kLoyaltyIcon)
VECTOR_ICON_TEMPLATE_H(kMagicButtonIcon)
VECTOR_ICON_TEMPLATE_H(kMediaNextTrackIcon)
VECTOR_ICON_TEMPLATE_H(kMediaPreviousTrackIcon)
VECTOR_ICON_TEMPLATE_H(kMediaRouterActiveChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kMediaRouterErrorIcon)
VECTOR_ICON_TEMPLATE_H(kMediaRouterIdleIcon)
VECTOR_ICON_TEMPLATE_H(kMediaRouterIdleChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kMediaRouterPausedIcon)
VECTOR_ICON_TEMPLATE_H(kMediaRouterWarningChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kMediaSeekBackwardIcon)
VECTOR_ICON_TEMPLATE_H(kMediaSeekForwardIcon)
VECTOR_ICON_TEMPLATE_H(kMicIcon)
VECTOR_ICON_TEMPLATE_H(kMicChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kMicOffIcon)
VECTOR_ICON_TEMPLATE_H(kMicOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kMidiIcon)
VECTOR_ICON_TEMPLATE_H(kMidiChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kMidiOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kNoEncryptionIcon)
VECTOR_ICON_TEMPLATE_H(kNotSecureWarningIcon)
VECTOR_ICON_TEMPLATE_H(kNotSecureWarningChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kNotSecureWarningOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kNotUploadedIcon)
VECTOR_ICON_TEMPLATE_H(kNotificationWarningIcon)
VECTOR_ICON_TEMPLATE_H(kNotificationsIcon)
VECTOR_ICON_TEMPLATE_H(kNotificationsChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kNotificationsOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kPageInfoContentPasteIcon)
VECTOR_ICON_TEMPLATE_H(kPasskeyIcon)
VECTOR_ICON_TEMPLATE_H(kPasswordManagerIcon)
VECTOR_ICON_TEMPLATE_H(kPasswordManagerOffIcon)
VECTOR_ICON_TEMPLATE_H(kPauseIcon)
VECTOR_ICON_TEMPLATE_H(kPauseChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kPersonCheckIcon)
VECTOR_ICON_TEMPLATE_H(kPhotoIcon)
VECTOR_ICON_TEMPLATE_H(kPhotoChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kPhotoOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kPictureInPictureIcon)
VECTOR_ICON_TEMPLATE_H(kPictureInPictureAltIcon)
VECTOR_ICON_TEMPLATE_H(kPipExitIcon)
VECTOR_ICON_TEMPLATE_H(kPlayArrowIcon)
VECTOR_ICON_TEMPLATE_H(kPlayArrowChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kPointerLockIcon)
VECTOR_ICON_TEMPLATE_H(kPointerLockOffIcon)
VECTOR_ICON_TEMPLATE_H(kPrinterIcon)
VECTOR_ICON_TEMPLATE_H(kProtectedContentIcon)
VECTOR_ICON_TEMPLATE_H(kProtocolHandlerIcon)
VECTOR_ICON_TEMPLATE_H(kProtocolHandlerChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kProtocolHandlerOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kQwacStatusIcon)
VECTOR_ICON_TEMPLATE_H(kRadioButtonCheckedIcon)
VECTOR_ICON_TEMPLATE_H(kReceiptLongIcon)
VECTOR_ICON_TEMPLATE_H(kReloadIcon)
VECTOR_ICON_TEMPLATE_H(kReloadChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kReplayIcon)
VECTOR_ICON_TEMPLATE_H(kReplay10Icon)
VECTOR_ICON_TEMPLATE_H(kRouterIcon)
VECTOR_ICON_TEMPLATE_H(kRouterOffIcon)
VECTOR_ICON_TEMPLATE_H(kSaveCloudIcon)
VECTOR_ICON_TEMPLATE_H(kScienceIcon)
VECTOR_ICON_TEMPLATE_H(kScreenRecordIcon)
VECTOR_ICON_TEMPLATE_H(kScreenShareIcon)
VECTOR_ICON_TEMPLATE_H(kScreenShareOldIcon)
VECTOR_ICON_TEMPLATE_H(kSearchIcon)
VECTOR_ICON_TEMPLATE_H(kSearchChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSelectWindowIcon)
VECTOR_ICON_TEMPLATE_H(kSelectWindowChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSelectWindowOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSendIcon)
VECTOR_ICON_TEMPLATE_H(kSensorsIcon)
VECTOR_ICON_TEMPLATE_H(kSensorsChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSensorsOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSerialPortIcon)
VECTOR_ICON_TEMPLATE_H(kSerialPortChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSerialPortOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSettingsIcon)
VECTOR_ICON_TEMPLATE_H(kSettingsChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSettingsOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kShoppingBagIcon)
VECTOR_ICON_TEMPLATE_H(kShoppingBagRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kShoppingmodeIcon)
VECTOR_ICON_TEMPLATE_H(kSkipNextIcon)
VECTOR_ICON_TEMPLATE_H(kSkipPreviousIcon)
VECTOR_ICON_TEMPLATE_H(kSmartCardReaderIcon)
VECTOR_ICON_TEMPLATE_H(kSmartCardReaderOffIcon)
VECTOR_ICON_TEMPLATE_H(kSmsIcon)
VECTOR_ICON_TEMPLATE_H(kStarIcon)
VECTOR_ICON_TEMPLATE_H(kStarHalfIcon)
VECTOR_ICON_TEMPLATE_H(kStickyNote2Icon)
VECTOR_ICON_TEMPLATE_H(kStopCircleIcon)
VECTOR_ICON_TEMPLATE_H(kStorageAccessIcon)
VECTOR_ICON_TEMPLATE_H(kStorageAccessOffIcon)
VECTOR_ICON_TEMPLATE_H(kStorefrontIcon)
VECTOR_ICON_TEMPLATE_H(kSubmenuArrowIcon)
VECTOR_ICON_TEMPLATE_H(kSubmenuArrowChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSyncIcon)
VECTOR_ICON_TEMPLATE_H(kSyncChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSyncOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSyncProblemChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kSyncSavedLocallyIcon)
VECTOR_ICON_TEMPLATE_H(kTabSearchIcon)
VECTOR_ICON_TEMPLATE_H(kTenancyIcon)
VECTOR_ICON_TEMPLATE_H(kThumbDownIcon)
VECTOR_ICON_TEMPLATE_H(kThumbDownFilledIcon)
VECTOR_ICON_TEMPLATE_H(kThumbUpIcon)
VECTOR_ICON_TEMPLATE_H(kThumbUpFilledIcon)
VECTOR_ICON_TEMPLATE_H(kTouchpadMouseIcon)
VECTOR_ICON_TEMPLATE_H(kTouchpadMouseOffIcon)
VECTOR_ICON_TEMPLATE_H(kTranslateIcon)
VECTOR_ICON_TEMPLATE_H(kUndoIcon)
VECTOR_ICON_TEMPLATE_H(kUsbIcon)
VECTOR_ICON_TEMPLATE_H(kUsbChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kUsbOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVideoLibraryIcon)
VECTOR_ICON_TEMPLATE_H(kVideocamIcon)
VECTOR_ICON_TEMPLATE_H(kVideocamChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVideocamOffIcon)
VECTOR_ICON_TEMPLATE_H(kVideocamOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVideogameAssetIcon)
VECTOR_ICON_TEMPLATE_H(kVideogameAssetChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVideogameAssetOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kViewInArChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kViewInArOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVisibilityIcon)
VECTOR_ICON_TEMPLATE_H(kVisibilityOffIcon)
VECTOR_ICON_TEMPLATE_H(kVolumeOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVolumeUpIcon)
VECTOR_ICON_TEMPLATE_H(kVolumeUpChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVrHeadsetIcon)
VECTOR_ICON_TEMPLATE_H(kVrHeadsetChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kVrHeadsetOffChromeRefreshIcon)
VECTOR_ICON_TEMPLATE_H(kWarningIcon)
VECTOR_ICON_TEMPLATE_H(kWarningOutlineIcon)
VECTOR_ICON_TEMPLATE_H(kWebAssetOffIcon)
VECTOR_ICON_TEMPLATE_H(kWorkIcon)

}  // namespace vector_icons

#undef VECTOR_ICON_TEMPLATE_H

#endif  // COMPONENTS_VECTOR_ICONS_VECTOR_ICONS_H_
