// components/services/storage/public/mojom/quota_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/quota_client.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/quota_client.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/quota_client.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/quota/quota_types.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class QuotaClientProxy;

template <typename ImplRefTraits>
class QuotaClientStub;

class QuotaClientRequestValidator;
class QuotaClientResponseValidator;


class QuotaClient
    : public QuotaClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.QuotaClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = QuotaClientInterfaceBase;
  using Proxy_ = QuotaClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuotaClientStub<ImplRefTraits>;

  using RequestValidator_ = QuotaClientRequestValidator;
  using ResponseValidator_ = QuotaClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBucketUsageMinVersion = 0,
    kGetDefaultStorageKeysMinVersion = 0,
    kDeleteBucketDataMinVersion = 0,
    kPerformStorageCleanupMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBucketUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDefaultStorageKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteBucketData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformStorageCleanup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~QuotaClient() = default;

  using GetBucketUsageCallback = base::OnceCallback<void(int64_t)>;
  using GetBucketUsageMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void GetBucketUsage(const ::storage::BucketLocator& bucket, GetBucketUsageCallback callback) = 0;

  using GetDefaultStorageKeysCallback = base::OnceCallback<void(const std::vector<::blink::StorageKey>&)>;
  using GetDefaultStorageKeysMojoCallback = base::OnceCallback<void(const std::vector<::blink::StorageKey>&)>;

  virtual void GetDefaultStorageKeys(GetDefaultStorageKeysCallback callback) = 0;

  using DeleteBucketDataCallback = base::OnceCallback<void(::blink::mojom::QuotaStatusCode)>;
  using DeleteBucketDataMojoCallback = base::OnceCallback<void(::blink::mojom::QuotaStatusCode)>;

  virtual void DeleteBucketData(const ::storage::BucketLocator& bucket, DeleteBucketDataCallback callback) = 0;

  using PerformStorageCleanupCallback = base::OnceCallback<void()>;
  using PerformStorageCleanupMojoCallback = base::OnceCallback<void()>;

  virtual void PerformStorageCleanup(PerformStorageCleanupCallback callback) = 0;
};



class  QuotaClientProxy
    : public QuotaClient {
 public:
  using InterfaceType = QuotaClient;

  explicit QuotaClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBucketUsage(const ::storage::BucketLocator& bucket, GetBucketUsageCallback callback) final;
  
  void GetDefaultStorageKeys(GetDefaultStorageKeysCallback callback) final;
  
  void DeleteBucketData(const ::storage::BucketLocator& bucket, DeleteBucketDataCallback callback) final;
  
  void PerformStorageCleanup(PerformStorageCleanupCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  QuotaClientStubDispatch {
 public:
  static bool Accept(QuotaClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      QuotaClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<QuotaClient>>
class QuotaClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuotaClientStub() = default;
  ~QuotaClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuotaClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuotaClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  QuotaClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  QuotaClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_QUOTA_CLIENT_MOJOM_H_