// components/services/storage/public/mojom/filesystem/directory.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"


namespace storage::mojom {
class StrictRelativePathDataView;

class PathAccessInfoDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::StrictRelativePathDataView> {
  using Data = ::storage::mojom::internal::StrictRelativePath_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::PathAccessInfoDataView> {
  using Data = ::storage::mojom::internal::PathAccessInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class GetEntriesMode : int32_t {
  
  kFilesOnly = 0,
  
  kFilesAndDirectories = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GetEntriesMode value);
inline bool IsKnownEnumValue(GetEntriesMode value) {
  return internal::GetEntriesMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileOpenMode : int32_t {
  
  kOpenIfExists = 0,
  
  kCreateAndOpenOnlyIfNotExists = 1,
  
  kAlwaysOpen = 2,
  
  kAlwaysCreate = 3,
  
  kOpenIfExistsAndTruncate = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileOpenMode value);
inline bool IsKnownEnumValue(FileOpenMode value) {
  return internal::FileOpenMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileReadAccess : int32_t {
  
  kReadNotAllowed = 0,
  
  kReadAllowed = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileReadAccess value);
inline bool IsKnownEnumValue(FileReadAccess value) {
  return internal::FileReadAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileWriteAccess : int32_t {
  
  kWriteNotAllowed = 0,
  
  kWriteAllowed = 1,
  
  kAppendOnly = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileWriteAccess value);
inline bool IsKnownEnumValue(FileWriteAccess value) {
  return internal::FileWriteAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileLockInterfaceBase {};

using FileLockPtrDataView =
    mojo::InterfacePtrDataView<FileLockInterfaceBase>;
using FileLockRequestDataView =
    mojo::InterfaceRequestDataView<FileLockInterfaceBase>;
using FileLockAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileLockInterfaceBase>;
using FileLockAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileLockInterfaceBase>;
class DirectoryInterfaceBase {};

using DirectoryPtrDataView =
    mojo::InterfacePtrDataView<DirectoryInterfaceBase>;
using DirectoryRequestDataView =
    mojo::InterfaceRequestDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DirectoryInterfaceBase>;


class StrictRelativePathDataView {
 public:
  StrictRelativePathDataView() = default;

  StrictRelativePathDataView(
      internal::StrictRelativePath_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::StrictRelativePath_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PathAccessInfoDataView {
 public:
  PathAccessInfoDataView() = default;

  PathAccessInfoDataView(
      internal::PathAccessInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_read() const {
    return data_->can_read;
  }
  bool can_write() const {
    return data_->can_write;
  }
 private:
  internal::PathAccessInfo_Data* data_ = nullptr;
};


}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_DATA_VIEW_H_