// components/services/storage/privileged/mojom/indexed_db_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/privileged/mojom/indexed_db_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/privileged/mojom/indexed_db_control.mojom-params-data.h"
#include "components/services/storage/privileged/mojom/indexed_db_control.mojom-shared-message-ids.h"

#include "components/services/storage/privileged/mojom/indexed_db_control.mojom-import-headers.h"
#include "components/services/storage/privileged/mojom/indexed_db_control.mojom-test-utils.h"


namespace storage::mojom {
// The declaration includes the definition on other builds.

IndexedDBObserver::IPCStableHashFunction IndexedDBObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IndexedDBObserver>(message.name())) {
    case messages::IndexedDBObserver::kOnIndexedDBListChanged: {
      return &IndexedDBObserver::OnIndexedDBListChanged_Sym::IPCStableHash;
    }
    case messages::IndexedDBObserver::kOnIndexedDBContentChanged: {
      return &IndexedDBObserver::OnIndexedDBContentChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IndexedDBObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IndexedDBObserver>(message.name())) {
      case messages::IndexedDBObserver::kOnIndexedDBListChanged:
            return "Receive storage::mojom::IndexedDBObserver::OnIndexedDBListChanged";
      case messages::IndexedDBObserver::kOnIndexedDBContentChanged:
            return "Receive storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged";
    }
  } else {
    switch (static_cast<messages::IndexedDBObserver>(message.name())) {
      case messages::IndexedDBObserver::kOnIndexedDBListChanged:
            return "Receive reply storage::mojom::IndexedDBObserver::OnIndexedDBListChanged";
      case messages::IndexedDBObserver::kOnIndexedDBContentChanged:
            return "Receive reply storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IndexedDBObserver::OnIndexedDBListChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7fd8d78e;  // IPCStableHash for storage::mojom::IndexedDBObserver::OnIndexedDBListChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBObserver::OnIndexedDBContentChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c7d4702;  // IPCStableHash for storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IndexedDBObserverProxy::IndexedDBObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBObserverProxy::OnIndexedDBListChanged(
    const ::storage::BucketLocator& in_bucket_locator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBObserver::OnIndexedDBListChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBObserver::kOnIndexedDBListChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
    in_bucket_locator,
    bucket_locator_fragment);

  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_locator.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_locator in IndexedDBObserver.OnIndexedDBListChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBObserver::Name_);
  message.set_method_name("OnIndexedDBListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IndexedDBObserverProxy::OnIndexedDBContentChanged(
    const ::storage::BucketLocator& in_bucket_locator, const ::std::u16string& in_database_name, const ::std::u16string& in_object_store_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_name"), in_database_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_name"), in_object_store_name,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBObserver::kOnIndexedDBContentChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
    in_bucket_locator,
    bucket_locator_fragment);

  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_locator.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_locator in IndexedDBObserver.OnIndexedDBContentChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->database_name)::BaseType> database_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_database_name,
    database_name_fragment);

  params->database_name.Set(
      database_name_fragment.is_null() ? nullptr : database_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->database_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null database_name in IndexedDBObserver.OnIndexedDBContentChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->object_store_name)::BaseType> object_store_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_object_store_name,
    object_store_name_fragment);

  params->object_store_name.Set(
      object_store_name_fragment.is_null() ? nullptr : object_store_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->object_store_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null object_store_name in IndexedDBObserver.OnIndexedDBContentChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBObserver::Name_);
  message.set_method_name("OnIndexedDBContentChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IndexedDBObserverStubDispatch::Accept(
    IndexedDBObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IndexedDBObserver>(message->header()->name)) {
    case messages::IndexedDBObserver::kOnIndexedDBListChanged: {
      DCHECK(message->is_serialized());
      internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data* params =
          reinterpret_cast<internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBObserver.0
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      IndexedDBObserver_OnIndexedDBListChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIndexedDBListChanged(        
        std::move(p_bucket_locator));
      return true;
    }
    case messages::IndexedDBObserver::kOnIndexedDBContentChanged: {
      DCHECK(message->is_serialized());
      internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data* params =
          reinterpret_cast<internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBObserver.1
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      ::std::u16string p_database_name{};
      ::std::u16string p_object_store_name{};
      IndexedDBObserver_OnIndexedDBContentChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (success && !input_data_view.ReadObjectStoreName(&p_object_store_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIndexedDBContentChanged(        
        std::move(p_bucket_locator), 
        std::move(p_database_name), 
        std::move(p_object_store_name));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBObserverStubDispatch::AcceptWithResponder(
    IndexedDBObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IndexedDBObserver>(message->header()->name)) {
    case messages::IndexedDBObserver::kOnIndexedDBListChanged: {
      break;
    }
    case messages::IndexedDBObserver::kOnIndexedDBContentChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBObserverValidationInfo[] = {
    {base::to_underlying(messages::IndexedDBObserver::kOnIndexedDBListChanged),
     { &internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::IndexedDBObserver::kOnIndexedDBContentChanged),
     { &internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::storage::mojom::IndexedDBObserver::Name_,
    kIndexedDBObserverValidationInfo);
}

// The declaration includes the definition on other builds.

IndexedDBControl::IPCStableHashFunction IndexedDBControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IndexedDBControl>(message.name())) {
    case messages::IndexedDBControl::kBindIndexedDB: {
      return &IndexedDBControl::BindIndexedDB_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kForceClose: {
      return &IndexedDBControl::ForceClose_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kDownloadBucketData: {
      return &IndexedDBControl::DownloadBucketData_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kGetAllBucketsDetails: {
      return &IndexedDBControl::GetAllBucketsDetails_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kStartMetadataRecording: {
      return &IndexedDBControl::StartMetadataRecording_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kStopMetadataRecording: {
      return &IndexedDBControl::StopMetadataRecording_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kSetForceKeepSessionState: {
      return &IndexedDBControl::SetForceKeepSessionState_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kAddObserver: {
      return &IndexedDBControl::AddObserver_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kApplyPolicyUpdates: {
      return &IndexedDBControl::ApplyPolicyUpdates_Sym::IPCStableHash;
    }
    case messages::IndexedDBControl::kBindTestInterfaceForTesting: {
      return &IndexedDBControl::BindTestInterfaceForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IndexedDBControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IndexedDBControl>(message.name())) {
      case messages::IndexedDBControl::kBindIndexedDB:
            return "Receive storage::mojom::IndexedDBControl::BindIndexedDB";
      case messages::IndexedDBControl::kForceClose:
            return "Receive storage::mojom::IndexedDBControl::ForceClose";
      case messages::IndexedDBControl::kDownloadBucketData:
            return "Receive storage::mojom::IndexedDBControl::DownloadBucketData";
      case messages::IndexedDBControl::kGetAllBucketsDetails:
            return "Receive storage::mojom::IndexedDBControl::GetAllBucketsDetails";
      case messages::IndexedDBControl::kStartMetadataRecording:
            return "Receive storage::mojom::IndexedDBControl::StartMetadataRecording";
      case messages::IndexedDBControl::kStopMetadataRecording:
            return "Receive storage::mojom::IndexedDBControl::StopMetadataRecording";
      case messages::IndexedDBControl::kSetForceKeepSessionState:
            return "Receive storage::mojom::IndexedDBControl::SetForceKeepSessionState";
      case messages::IndexedDBControl::kAddObserver:
            return "Receive storage::mojom::IndexedDBControl::AddObserver";
      case messages::IndexedDBControl::kApplyPolicyUpdates:
            return "Receive storage::mojom::IndexedDBControl::ApplyPolicyUpdates";
      case messages::IndexedDBControl::kBindTestInterfaceForTesting:
            return "Receive storage::mojom::IndexedDBControl::BindTestInterfaceForTesting";
    }
  } else {
    switch (static_cast<messages::IndexedDBControl>(message.name())) {
      case messages::IndexedDBControl::kBindIndexedDB:
            return "Receive reply storage::mojom::IndexedDBControl::BindIndexedDB";
      case messages::IndexedDBControl::kForceClose:
            return "Receive reply storage::mojom::IndexedDBControl::ForceClose";
      case messages::IndexedDBControl::kDownloadBucketData:
            return "Receive reply storage::mojom::IndexedDBControl::DownloadBucketData";
      case messages::IndexedDBControl::kGetAllBucketsDetails:
            return "Receive reply storage::mojom::IndexedDBControl::GetAllBucketsDetails";
      case messages::IndexedDBControl::kStartMetadataRecording:
            return "Receive reply storage::mojom::IndexedDBControl::StartMetadataRecording";
      case messages::IndexedDBControl::kStopMetadataRecording:
            return "Receive reply storage::mojom::IndexedDBControl::StopMetadataRecording";
      case messages::IndexedDBControl::kSetForceKeepSessionState:
            return "Receive reply storage::mojom::IndexedDBControl::SetForceKeepSessionState";
      case messages::IndexedDBControl::kAddObserver:
            return "Receive reply storage::mojom::IndexedDBControl::AddObserver";
      case messages::IndexedDBControl::kApplyPolicyUpdates:
            return "Receive reply storage::mojom::IndexedDBControl::ApplyPolicyUpdates";
      case messages::IndexedDBControl::kBindTestInterfaceForTesting:
            return "Receive reply storage::mojom::IndexedDBControl::BindTestInterfaceForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IndexedDBControl::BindIndexedDB_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x613bb435;  // IPCStableHash for storage::mojom::IndexedDBControl::BindIndexedDB
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::ForceClose_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e47d446;  // IPCStableHash for storage::mojom::IndexedDBControl::ForceClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::DownloadBucketData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7934dc54;  // IPCStableHash for storage::mojom::IndexedDBControl::DownloadBucketData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::GetAllBucketsDetails_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6912a3ab;  // IPCStableHash for storage::mojom::IndexedDBControl::GetAllBucketsDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::StartMetadataRecording_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7496f4b6;  // IPCStableHash for storage::mojom::IndexedDBControl::StartMetadataRecording
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::StopMetadataRecording_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1001cac9;  // IPCStableHash for storage::mojom::IndexedDBControl::StopMetadataRecording
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::SetForceKeepSessionState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcf93ed4;  // IPCStableHash for storage::mojom::IndexedDBControl::SetForceKeepSessionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac95422c;  // IPCStableHash for storage::mojom::IndexedDBControl::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::ApplyPolicyUpdates_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e1f3098;  // IPCStableHash for storage::mojom::IndexedDBControl::ApplyPolicyUpdates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBControl::BindTestInterfaceForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x441c3082;  // IPCStableHash for storage::mojom::IndexedDBControl::BindTestInterfaceForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IndexedDBControl_ForceClose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_ForceClose_ForwardToCallback(
      IndexedDBControl::ForceCloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControl_ForceClose_ForwardToCallback(const IndexedDBControl_ForceClose_ForwardToCallback&) = delete;
  IndexedDBControl_ForceClose_ForwardToCallback& operator=(const IndexedDBControl_ForceClose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::ForceCloseCallback callback_;
};

class IndexedDBControl_DownloadBucketData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_DownloadBucketData_ForwardToCallback(
      IndexedDBControl::DownloadBucketDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControl_DownloadBucketData_ForwardToCallback(const IndexedDBControl_DownloadBucketData_ForwardToCallback&) = delete;
  IndexedDBControl_DownloadBucketData_ForwardToCallback& operator=(const IndexedDBControl_DownloadBucketData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::DownloadBucketDataCallback callback_;
};

class IndexedDBControl_GetAllBucketsDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetAllBucketsDetails_ForwardToCallback(
      IndexedDBControl::GetAllBucketsDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControl_GetAllBucketsDetails_ForwardToCallback(const IndexedDBControl_GetAllBucketsDetails_ForwardToCallback&) = delete;
  IndexedDBControl_GetAllBucketsDetails_ForwardToCallback& operator=(const IndexedDBControl_GetAllBucketsDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetAllBucketsDetailsCallback callback_;
};

class IndexedDBControl_StartMetadataRecording_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_StartMetadataRecording_ForwardToCallback(
      IndexedDBControl::StartMetadataRecordingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControl_StartMetadataRecording_ForwardToCallback(const IndexedDBControl_StartMetadataRecording_ForwardToCallback&) = delete;
  IndexedDBControl_StartMetadataRecording_ForwardToCallback& operator=(const IndexedDBControl_StartMetadataRecording_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::StartMetadataRecordingCallback callback_;
};

class IndexedDBControl_StopMetadataRecording_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_StopMetadataRecording_ForwardToCallback(
      IndexedDBControl::StopMetadataRecordingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBControl_StopMetadataRecording_ForwardToCallback(const IndexedDBControl_StopMetadataRecording_ForwardToCallback&) = delete;
  IndexedDBControl_StopMetadataRecording_ForwardToCallback& operator=(const IndexedDBControl_StopMetadataRecording_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::StopMetadataRecordingCallback callback_;
};

IndexedDBControlProxy::IndexedDBControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBControlProxy::BindIndexedDB(
    const ::storage::BucketLocator& in_bucket_locator, const ::storage::BucketClientInfo& in_client_info, ::mojo::PendingRemote<::storage::mojom::IndexedDBClientStateChecker> in_client_state_checker_remote, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::BindIndexedDB", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_info"), in_client_info,
                        "<value of type const ::storage::BucketClientInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_state_checker_remote"), in_client_state_checker_remote,
                        "<value of type ::mojo::PendingRemote<::storage::mojom::IndexedDBClientStateChecker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::IDBFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kBindIndexedDB), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_BindIndexedDB_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
    in_bucket_locator,
    bucket_locator_fragment);

  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_locator.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_locator in IndexedDBControl.BindIndexedDB request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_info)::BaseType> client_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketClientInfoDataView>(
    in_client_info,
    client_info_fragment);

  params->client_info.Set(
      client_info_fragment.is_null() ? nullptr : client_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_info in IndexedDBControl.BindIndexedDB request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::IndexedDBClientStateCheckerInterfaceBase>>(
    in_client_state_checker_remote,
    &params->client_state_checker_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_state_checker_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_state_checker_remote in IndexedDBControl.BindIndexedDB request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::IDBFactoryInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in IndexedDBControl.BindIndexedDB request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("BindIndexedDB");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IndexedDBControlProxy::ForceClose(
    ::storage::BucketId in_bucket_id, ForceCloseReason in_reason, ForceCloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::ForceClose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_id"), in_bucket_id,
                        "<value of type ::storage::BucketId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ForceCloseReason>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kForceClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_ForceClose_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_id)::BaseType> bucket_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
    in_bucket_id,
    bucket_id_fragment);

  params->bucket_id.Set(
      bucket_id_fragment.is_null() ? nullptr : bucket_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_id in IndexedDBControl.ForceClose request");

  
  mojo::internal::Serialize<::storage::mojom::ForceCloseReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ForceClose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_ForceClose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlProxy::DownloadBucketData(
    ::storage::BucketId in_bucket_id, DownloadBucketDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::DownloadBucketData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_id"), in_bucket_id,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kDownloadBucketData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_DownloadBucketData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_id)::BaseType> bucket_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
    in_bucket_id,
    bucket_id_fragment);

  params->bucket_id.Set(
      bucket_id_fragment.is_null() ? nullptr : bucket_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_id in IndexedDBControl.DownloadBucketData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DownloadBucketData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_DownloadBucketData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlProxy::GetAllBucketsDetails(
    GetAllBucketsDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControl::GetAllBucketsDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kGetAllBucketsDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetAllBucketsDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetAllBucketsDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetAllBucketsDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlProxy::StartMetadataRecording(
    ::storage::BucketId in_bucket_id, StartMetadataRecordingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::StartMetadataRecording", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_id"), in_bucket_id,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kStartMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_StartMetadataRecording_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_id)::BaseType> bucket_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
    in_bucket_id,
    bucket_id_fragment);

  params->bucket_id.Set(
      bucket_id_fragment.is_null() ? nullptr : bucket_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_id in IndexedDBControl.StartMetadataRecording request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("StartMetadataRecording");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_StartMetadataRecording_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlProxy::StopMetadataRecording(
    ::storage::BucketId in_bucket_id, StopMetadataRecordingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::StopMetadataRecording", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_id"), in_bucket_id,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kStopMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_StopMetadataRecording_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_id)::BaseType> bucket_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
    in_bucket_id,
    bucket_id_fragment);

  params->bucket_id.Set(
      bucket_id_fragment.is_null() ? nullptr : bucket_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_id in IndexedDBControl.StopMetadataRecording request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("StopMetadataRecording");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_StopMetadataRecording_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBControlProxy::SetForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IndexedDBControl::SetForceKeepSessionState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kSetForceKeepSessionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_SetForceKeepSessionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("SetForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IndexedDBControlProxy::AddObserver(
    ::mojo::PendingRemote<IndexedDBObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<IndexedDBObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::IndexedDBObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in IndexedDBControl.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IndexedDBControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates,
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kApplyPolicyUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& policy_updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
    in_policy_updates,
    policy_updates_fragment,
    &policy_updates_validate_params);

  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_updates in IndexedDBControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IndexedDBControlProxy::BindTestInterfaceForTesting(
    ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBControl::BindTestInterfaceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kBindTestInterfaceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_BindTestInterfaceForTesting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::IndexedDBControlTestInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in IndexedDBControl.BindTestInterfaceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("BindTestInterfaceForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class IndexedDBControl_ForceClose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControl::ForceCloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControl_ForceClose_ProxyToResponder> proxy(
        new IndexedDBControl_ForceClose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControl_ForceClose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_ForceClose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControl_ForceClose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::ForceCloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool IndexedDBControl_ForceClose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControl_ForceClose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_ForceClose_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControl.1
  bool success = true;
  IndexedDBControl_ForceClose_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void IndexedDBControl_ForceClose_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::IndexedDBControl::ForceClose");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kForceClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_ForceClose_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ForceClose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_DownloadBucketData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControl::DownloadBucketDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControl_DownloadBucketData_ProxyToResponder> proxy(
        new IndexedDBControl_DownloadBucketData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControl_DownloadBucketData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_DownloadBucketData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControl_DownloadBucketData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::DownloadBucketDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::base::FilePath& in_temp_path, const ::base::FilePath& in_zip_path);
};

bool IndexedDBControl_DownloadBucketData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControl_DownloadBucketData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_DownloadBucketData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControl.2
  bool success = true;
  bool p_success{};
  ::base::FilePath p_temp_path{};
  ::base::FilePath p_zip_path{};
  IndexedDBControl_DownloadBucketData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadTempPath(&p_temp_path))
    success = false;
  if (success && !input_data_view.ReadZipPath(&p_zip_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_temp_path), 
std::move(p_zip_path));
  }
  return true;
}

void IndexedDBControl_DownloadBucketData_ProxyToResponder::Run(
    bool in_success, const ::base::FilePath& in_temp_path, const ::base::FilePath& in_zip_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControl::DownloadBucketData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_path"), in_temp_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zip_path"), in_zip_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kDownloadBucketData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_DownloadBucketData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->temp_path)::BaseType> temp_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_temp_path,
    temp_path_fragment);

  params->temp_path.Set(
      temp_path_fragment.is_null() ? nullptr : temp_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->temp_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null temp_path in ");
  mojo::internal::MessageFragment<
      typename decltype(params->zip_path)::BaseType> zip_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_zip_path,
    zip_path_fragment);

  params->zip_path.Set(
      zip_path_fragment.is_null() ? nullptr : zip_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->zip_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null zip_path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DownloadBucketData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_GetAllBucketsDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControl::GetAllBucketsDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControl_GetAllBucketsDetails_ProxyToResponder> proxy(
        new IndexedDBControl_GetAllBucketsDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControl_GetAllBucketsDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetAllBucketsDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControl_GetAllBucketsDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetAllBucketsDetailsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_incognito, std::vector<::storage::mojom::IdbOriginMetadataPtr> in_details);
};

bool IndexedDBControl_GetAllBucketsDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetAllBucketsDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetAllBucketsDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControl.3
  bool success = true;
  bool p_incognito{};
  std::vector<::storage::mojom::IdbOriginMetadataPtr> p_details{};
  IndexedDBControl_GetAllBucketsDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_incognito = input_data_view.incognito();
  if (success && !input_data_view.ReadDetails(&p_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_incognito), 
std::move(p_details));
  }
  return true;
}

void IndexedDBControl_GetAllBucketsDetails_ProxyToResponder::Run(
    bool in_incognito, std::vector<::storage::mojom::IdbOriginMetadataPtr> in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControl::GetAllBucketsDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("incognito"), in_incognito,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type std::vector<::storage::mojom::IdbOriginMetadataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kGetAllBucketsDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_GetAllBucketsDetails_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->incognito = in_incognito;
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType>
      details_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbOriginMetadataDataView>>(
    in_details,
    details_fragment,
    &details_validate_params);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetAllBucketsDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_StartMetadataRecording_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControl::StartMetadataRecordingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControl_StartMetadataRecording_ProxyToResponder> proxy(
        new IndexedDBControl_StartMetadataRecording_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControl_StartMetadataRecording_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_StartMetadataRecording_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControl_StartMetadataRecording_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::StartMetadataRecordingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool IndexedDBControl_StartMetadataRecording_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControl_StartMetadataRecording_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_StartMetadataRecording_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControl.4
  bool success = true;
  IndexedDBControl_StartMetadataRecording_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void IndexedDBControl_StartMetadataRecording_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::IndexedDBControl::StartMetadataRecording");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kStartMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_StartMetadataRecording_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("StartMetadataRecording");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_StopMetadataRecording_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBControl::StopMetadataRecordingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBControl_StopMetadataRecording_ProxyToResponder> proxy(
        new IndexedDBControl_StopMetadataRecording_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBControl_StopMetadataRecording_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_StopMetadataRecording_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBControl_StopMetadataRecording_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::StopMetadataRecordingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::storage::mojom::IdbBucketMetadataPtr> in_metadata);
};

bool IndexedDBControl_StopMetadataRecording_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBControl_StopMetadataRecording_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_StopMetadataRecording_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IndexedDBControl.5
  bool success = true;
  std::vector<::storage::mojom::IdbBucketMetadataPtr> p_metadata{};
  IndexedDBControl_StopMetadataRecording_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_metadata));
  }
  return true;
}

void IndexedDBControl_StopMetadataRecording_ProxyToResponder::Run(
    std::vector<::storage::mojom::IdbBucketMetadataPtr> in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBControl::StopMetadataRecording", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type std::vector<::storage::mojom::IdbBucketMetadataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBControl::kStopMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBControl_StopMetadataRecording_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType>
      metadata_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbBucketMetadataDataView>>(
    in_metadata,
    metadata_fragment,
    &metadata_validate_params);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("StopMetadataRecording");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IndexedDBControlStubDispatch::Accept(
    IndexedDBControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IndexedDBControl>(message->header()->name)) {
    case messages::IndexedDBControl::kBindIndexedDB: {
      DCHECK(message->is_serialized());
      internal::IndexedDBControl_BindIndexedDB_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_BindIndexedDB_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBControl.0
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      ::storage::BucketClientInfo p_client_info{};
      ::mojo::PendingRemote<::storage::mojom::IndexedDBClientStateChecker> p_client_state_checker_remote{};
      ::mojo::PendingReceiver<::blink::mojom::IDBFactory> p_receiver{};
      IndexedDBControl_BindIndexedDB_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (success && !input_data_view.ReadClientInfo(&p_client_info))
        success = false;
      if (success) {
        p_client_state_checker_remote =
            input_data_view.TakeClientStateCheckerRemote<decltype(p_client_state_checker_remote)>();
      }
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindIndexedDB(        
        std::move(p_bucket_locator), 
        std::move(p_client_info), 
        std::move(p_client_state_checker_remote), 
        std::move(p_receiver));
      return true;
    }
    case messages::IndexedDBControl::kForceClose: {
      break;
    }
    case messages::IndexedDBControl::kDownloadBucketData: {
      break;
    }
    case messages::IndexedDBControl::kGetAllBucketsDetails: {
      break;
    }
    case messages::IndexedDBControl::kStartMetadataRecording: {
      break;
    }
    case messages::IndexedDBControl::kStopMetadataRecording: {
      break;
    }
    case messages::IndexedDBControl::kSetForceKeepSessionState: {
      DCHECK(message->is_serialized());
      internal::IndexedDBControl_SetForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_SetForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBControl.6
      bool success = true;
      IndexedDBControl_SetForceKeepSessionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForceKeepSessionState(        );
      return true;
    }
    case messages::IndexedDBControl::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::IndexedDBControl_AddObserver_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBControl.7
      bool success = true;
      ::mojo::PendingRemote<IndexedDBObserver> p_observer{};
      IndexedDBControl_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::IndexedDBControl::kApplyPolicyUpdates: {
      DCHECK(message->is_serialized());
      internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBControl.8
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      IndexedDBControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(        
        std::move(p_policy_updates));
      return true;
    }
    case messages::IndexedDBControl::kBindTestInterfaceForTesting: {
      DCHECK(message->is_serialized());
      internal::IndexedDBControl_BindTestInterfaceForTesting_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_BindTestInterfaceForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IndexedDBControl.9
      bool success = true;
      ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> p_receiver{};
      IndexedDBControl_BindTestInterfaceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestInterfaceForTesting(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBControlStubDispatch::AcceptWithResponder(
    IndexedDBControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IndexedDBControl>(message->header()->name)) {
    case messages::IndexedDBControl::kBindIndexedDB: {
      break;
    }
    case messages::IndexedDBControl::kForceClose: {
      internal::IndexedDBControl_ForceClose_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_ForceClose_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControl.1
      bool success = true;
      ::storage::BucketId p_bucket_id{};
      ForceCloseReason p_reason{};
      IndexedDBControl_ForceClose_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucket_id))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 1, false);
        return false;
      }
      auto callback =
          IndexedDBControl_ForceClose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceClose(        
        std::move(p_bucket_id), 
        std::move(p_reason), std::move(callback));
      return true;
    }
    case messages::IndexedDBControl::kDownloadBucketData: {
      internal::IndexedDBControl_DownloadBucketData_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_DownloadBucketData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControl.2
      bool success = true;
      ::storage::BucketId p_bucket_id{};
      IndexedDBControl_DownloadBucketData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucket_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 2, false);
        return false;
      }
      auto callback =
          IndexedDBControl_DownloadBucketData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadBucketData(        
        std::move(p_bucket_id), std::move(callback));
      return true;
    }
    case messages::IndexedDBControl::kGetAllBucketsDetails: {
      internal::IndexedDBControl_GetAllBucketsDetails_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetAllBucketsDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControl.3
      bool success = true;
      IndexedDBControl_GetAllBucketsDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 3, false);
        return false;
      }
      auto callback =
          IndexedDBControl_GetAllBucketsDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllBucketsDetails(std::move(callback));
      return true;
    }
    case messages::IndexedDBControl::kStartMetadataRecording: {
      internal::IndexedDBControl_StartMetadataRecording_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_StartMetadataRecording_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControl.4
      bool success = true;
      ::storage::BucketId p_bucket_id{};
      IndexedDBControl_StartMetadataRecording_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucket_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 4, false);
        return false;
      }
      auto callback =
          IndexedDBControl_StartMetadataRecording_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartMetadataRecording(        
        std::move(p_bucket_id), std::move(callback));
      return true;
    }
    case messages::IndexedDBControl::kStopMetadataRecording: {
      internal::IndexedDBControl_StopMetadataRecording_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_StopMetadataRecording_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IndexedDBControl.5
      bool success = true;
      ::storage::BucketId p_bucket_id{};
      IndexedDBControl_StopMetadataRecording_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucket_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 5, false);
        return false;
      }
      auto callback =
          IndexedDBControl_StopMetadataRecording_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopMetadataRecording(        
        std::move(p_bucket_id), std::move(callback));
      return true;
    }
    case messages::IndexedDBControl::kSetForceKeepSessionState: {
      break;
    }
    case messages::IndexedDBControl::kAddObserver: {
      break;
    }
    case messages::IndexedDBControl::kApplyPolicyUpdates: {
      break;
    }
    case messages::IndexedDBControl::kBindTestInterfaceForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBControlValidationInfo[] = {
    {base::to_underlying(messages::IndexedDBControl::kBindIndexedDB),
     { &internal::IndexedDBControl_BindIndexedDB_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::IndexedDBControl::kForceClose),
     { &internal::IndexedDBControl_ForceClose_Params_Data::Validate,
      &internal::IndexedDBControl_ForceClose_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControl::kDownloadBucketData),
     { &internal::IndexedDBControl_DownloadBucketData_Params_Data::Validate,
      &internal::IndexedDBControl_DownloadBucketData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControl::kGetAllBucketsDetails),
     { &internal::IndexedDBControl_GetAllBucketsDetails_Params_Data::Validate,
      &internal::IndexedDBControl_GetAllBucketsDetails_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControl::kStartMetadataRecording),
     { &internal::IndexedDBControl_StartMetadataRecording_Params_Data::Validate,
      &internal::IndexedDBControl_StartMetadataRecording_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControl::kStopMetadataRecording),
     { &internal::IndexedDBControl_StopMetadataRecording_Params_Data::Validate,
      &internal::IndexedDBControl_StopMetadataRecording_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBControl::kSetForceKeepSessionState),
     { &internal::IndexedDBControl_SetForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::IndexedDBControl::kAddObserver),
     { &internal::IndexedDBControl_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::IndexedDBControl::kApplyPolicyUpdates),
     { &internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::IndexedDBControl::kBindTestInterfaceForTesting),
     { &internal::IndexedDBControl_BindTestInterfaceForTesting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::storage::mojom::IndexedDBControl::Name_,
    kIndexedDBControlValidationInfo);
}

bool IndexedDBControlResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::storage::mojom::IndexedDBControl::Name_,
    kIndexedDBControlValidationInfo);

}


}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void IndexedDBObserverInterceptorForTesting::OnIndexedDBListChanged(const ::storage::BucketLocator& bucket_locator) {
  GetForwardingInterface()->OnIndexedDBListChanged(
    std::move(bucket_locator)
    );
}
void IndexedDBObserverInterceptorForTesting::OnIndexedDBContentChanged(const ::storage::BucketLocator& bucket_locator, const ::std::u16string& database_name, const ::std::u16string& object_store_name) {
  GetForwardingInterface()->OnIndexedDBContentChanged(
    std::move(bucket_locator)
    , 
    std::move(database_name)
    , 
    std::move(object_store_name)
    );
}
IndexedDBObserverAsyncWaiter::IndexedDBObserverAsyncWaiter(
    IndexedDBObserver* proxy) : proxy_(proxy) {}

IndexedDBObserverAsyncWaiter::~IndexedDBObserverAsyncWaiter() = default;





void IndexedDBControlInterceptorForTesting::BindIndexedDB(const ::storage::BucketLocator& bucket_locator, const ::storage::BucketClientInfo& client_info, ::mojo::PendingRemote<::storage::mojom::IndexedDBClientStateChecker> client_state_checker_remote, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> receiver) {
  GetForwardingInterface()->BindIndexedDB(
    std::move(bucket_locator)
    , 
    std::move(client_info)
    , 
    std::move(client_state_checker_remote)
    , 
    std::move(receiver)
    );
}
void IndexedDBControlInterceptorForTesting::ForceClose(::storage::BucketId bucket_id, ForceCloseReason reason, ForceCloseCallback callback) {
  GetForwardingInterface()->ForceClose(
    std::move(bucket_id)
    , 
    std::move(reason)
    , std::move(callback));
}
void IndexedDBControlInterceptorForTesting::DownloadBucketData(::storage::BucketId bucket_id, DownloadBucketDataCallback callback) {
  GetForwardingInterface()->DownloadBucketData(
    std::move(bucket_id)
    , std::move(callback));
}
void IndexedDBControlInterceptorForTesting::GetAllBucketsDetails(GetAllBucketsDetailsCallback callback) {
  GetForwardingInterface()->GetAllBucketsDetails(std::move(callback));
}
void IndexedDBControlInterceptorForTesting::StartMetadataRecording(::storage::BucketId bucket_id, StartMetadataRecordingCallback callback) {
  GetForwardingInterface()->StartMetadataRecording(
    std::move(bucket_id)
    , std::move(callback));
}
void IndexedDBControlInterceptorForTesting::StopMetadataRecording(::storage::BucketId bucket_id, StopMetadataRecordingCallback callback) {
  GetForwardingInterface()->StopMetadataRecording(
    std::move(bucket_id)
    , std::move(callback));
}
void IndexedDBControlInterceptorForTesting::SetForceKeepSessionState() {
  GetForwardingInterface()->SetForceKeepSessionState();
}
void IndexedDBControlInterceptorForTesting::AddObserver(::mojo::PendingRemote<IndexedDBObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void IndexedDBControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) {
  GetForwardingInterface()->ApplyPolicyUpdates(
    std::move(policy_updates)
    );
}
void IndexedDBControlInterceptorForTesting::BindTestInterfaceForTesting(::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> receiver) {
  GetForwardingInterface()->BindTestInterfaceForTesting(
    std::move(receiver)
    );
}
IndexedDBControlAsyncWaiter::IndexedDBControlAsyncWaiter(
    IndexedDBControl* proxy) : proxy_(proxy) {}

IndexedDBControlAsyncWaiter::~IndexedDBControlAsyncWaiter() = default;


void IndexedDBControlAsyncWaiter::ForceClose(
    ::storage::BucketId bucket_id, ForceCloseReason reason) {
  base::RunLoop loop;
  proxy_->ForceClose(
      std::move(bucket_id),
      std::move(reason),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void IndexedDBControlAsyncWaiter::DownloadBucketData(
    ::storage::BucketId bucket_id, bool* out_success, ::base::FilePath* out_temp_path, ::base::FilePath* out_zip_path) {
  base::RunLoop loop;
  proxy_->DownloadBucketData(
      std::move(bucket_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::base::FilePath* out_temp_path
,
             ::base::FilePath* out_zip_path
,
             bool success,
             const ::base::FilePath& temp_path,
             const ::base::FilePath& zip_path) {*out_success = std::move(success);*out_temp_path = std::move(temp_path);*out_zip_path = std::move(zip_path);
            loop->Quit();
          },
          &loop,
          out_success,
          out_temp_path,
          out_zip_path));
  loop.Run();
}



void IndexedDBControlAsyncWaiter::GetAllBucketsDetails(
    bool* out_incognito, std::vector<::storage::mojom::IdbOriginMetadataPtr>* out_details) {
  base::RunLoop loop;
  proxy_->GetAllBucketsDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_incognito
,
             std::vector<::storage::mojom::IdbOriginMetadataPtr>* out_details
,
             bool incognito,
             std::vector<::storage::mojom::IdbOriginMetadataPtr> details) {*out_incognito = std::move(incognito);*out_details = std::move(details);
            loop->Quit();
          },
          &loop,
          out_incognito,
          out_details));
  loop.Run();
}



void IndexedDBControlAsyncWaiter::StartMetadataRecording(
    ::storage::BucketId bucket_id) {
  base::RunLoop loop;
  proxy_->StartMetadataRecording(
      std::move(bucket_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void IndexedDBControlAsyncWaiter::StopMetadataRecording(
    ::storage::BucketId bucket_id, std::vector<::storage::mojom::IdbBucketMetadataPtr>* out_metadata) {
  base::RunLoop loop;
  proxy_->StopMetadataRecording(
      std::move(bucket_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::storage::mojom::IdbBucketMetadataPtr>* out_metadata
,
             std::vector<::storage::mojom::IdbBucketMetadataPtr> metadata) {*out_metadata = std::move(metadata);
            loop->Quit();
          },
          &loop,
          out_metadata));
  loop.Run();
}

std::vector<::storage::mojom::IdbBucketMetadataPtr> IndexedDBControlAsyncWaiter::StopMetadataRecording(
    ::storage::BucketId bucket_id) {
  std::vector<::storage::mojom::IdbBucketMetadataPtr> async_wait_result;
  StopMetadataRecording(std::move(bucket_id),&async_wait_result);
  return async_wait_result;
}






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif