// components/metrics/dwa/mojom/dwa_interface.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_H_
#define COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/metrics/dwa/mojom/dwa_interface.mojom-features.h"  // IWYU pragma: export
#include "components/metrics/dwa/mojom/dwa_interface.mojom-shared.h"  // IWYU pragma: export
#include "components/metrics/dwa/mojom/dwa_interface.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace metrics::dwa::mojom {

class DwaRecorderClientInterfaceProxy;

template <typename ImplRefTraits>
class DwaRecorderClientInterfaceStub;

class DwaRecorderClientInterfaceRequestValidator;


class DwaRecorderClientInterface
    : public DwaRecorderClientInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics.dwa.mojom.DwaRecorderClientInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DwaRecorderClientInterfaceInterfaceBase;
  using Proxy_ = DwaRecorderClientInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DwaRecorderClientInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = DwaRecorderClientInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DwaRecorderClientInterface() = default;
};

class DwaRecorderInterfaceProxy;

template <typename ImplRefTraits>
class DwaRecorderInterfaceStub;

class DwaRecorderInterfaceRequestValidator;


class DwaRecorderInterface
    : public DwaRecorderInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics.dwa.mojom.DwaRecorderInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DwaRecorderInterfaceInterfaceBase;
  using Proxy_ = DwaRecorderInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DwaRecorderInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = DwaRecorderInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddEntryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DwaRecorderInterface() = default;

  virtual void AddEntry(DwaEntryPtr entry) = 0;
};

class DwaRecorderFactoryProxy;

template <typename ImplRefTraits>
class DwaRecorderFactoryStub;

class DwaRecorderFactoryRequestValidator;


class DwaRecorderFactory
    : public DwaRecorderFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics.dwa.mojom.DwaRecorderFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DwaRecorderFactoryInterfaceBase;
  using Proxy_ = DwaRecorderFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = DwaRecorderFactoryStub<ImplRefTraits>;

  using RequestValidator_ = DwaRecorderFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateDwaRecorderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateDwaRecorder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DwaRecorderFactory() = default;

  virtual void CreateDwaRecorder(::mojo::PendingReceiver<DwaRecorderInterface> receiver, ::mojo::PendingRemote<DwaRecorderClientInterface> client_remote) = 0;
};



class  DwaRecorderClientInterfaceProxy
    : public DwaRecorderClientInterface {
 public:
  using InterfaceType = DwaRecorderClientInterface;

  explicit DwaRecorderClientInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DwaRecorderInterfaceProxy
    : public DwaRecorderInterface {
 public:
  using InterfaceType = DwaRecorderInterface;

  explicit DwaRecorderInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddEntry(DwaEntryPtr entry) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DwaRecorderFactoryProxy
    : public DwaRecorderFactory {
 public:
  using InterfaceType = DwaRecorderFactory;

  explicit DwaRecorderFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateDwaRecorder(::mojo::PendingReceiver<DwaRecorderInterface> receiver, ::mojo::PendingRemote<DwaRecorderClientInterface> client_remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DwaRecorderClientInterfaceStubDispatch {
 public:
  static bool Accept(DwaRecorderClientInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DwaRecorderClientInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DwaRecorderClientInterface>>
class DwaRecorderClientInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DwaRecorderClientInterfaceStub() = default;
  ~DwaRecorderClientInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DwaRecorderClientInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DwaRecorderClientInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DwaRecorderInterfaceStubDispatch {
 public:
  static bool Accept(DwaRecorderInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DwaRecorderInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DwaRecorderInterface>>
class DwaRecorderInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DwaRecorderInterfaceStub() = default;
  ~DwaRecorderInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DwaRecorderInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DwaRecorderInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DwaRecorderFactoryStubDispatch {
 public:
  static bool Accept(DwaRecorderFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DwaRecorderFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DwaRecorderFactory>>
class DwaRecorderFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DwaRecorderFactoryStub() = default;
  ~DwaRecorderFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DwaRecorderFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DwaRecorderFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DwaRecorderClientInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DwaRecorderInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DwaRecorderFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  DwaEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DwaEntry, T>::value>;
  using DataView = DwaEntryDataView;
  using Data_ = internal::DwaEntry_Data;

  template <typename... Args>
  static DwaEntryPtr New(Args&&... args) {
    return DwaEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DwaEntryPtr From(const U& u) {
    return mojo::TypeConverter<DwaEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DwaEntry>::Convert(*this);
  }


  DwaEntry();

  DwaEntry(
      uint64_t event_hash,
      uint64_t content_hash,
      const base::flat_map<std::string, bool>& studies_of_interest,
      const base::flat_map<uint64_t, int64_t>& metrics);


  ~DwaEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DwaEntryPtr>
  DwaEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DwaEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DwaEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DwaEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DwaEntry_UnserializedMessageContext<
            UserType, DwaEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DwaEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DwaEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DwaEntry_UnserializedMessageContext<
            UserType, DwaEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DwaEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t event_hash;
  
  uint64_t content_hash;
  
  base::flat_map<std::string, bool> studies_of_interest;
  
  base::flat_map<uint64_t, int64_t> metrics;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DwaEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DwaEntryPtr DwaEntry::Clone() const {
  return New(
      mojo::Clone(event_hash),
      mojo::Clone(content_hash),
      mojo::Clone(studies_of_interest),
      mojo::Clone(metrics)
  );
}

template <typename T, DwaEntry::EnableIfSame<T>*>
bool DwaEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->event_hash, other_struct.event_hash))
    return false;
  if (!mojo::Equals(this->content_hash, other_struct.content_hash))
    return false;
  if (!mojo::Equals(this->studies_of_interest, other_struct.studies_of_interest))
    return false;
  if (!mojo::Equals(this->metrics, other_struct.metrics))
    return false;
  return true;
}

template <typename T, DwaEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.event_hash < rhs.event_hash)
    return true;
  if (rhs.event_hash < lhs.event_hash)
    return false;
  if (lhs.content_hash < rhs.content_hash)
    return true;
  if (rhs.content_hash < lhs.content_hash)
    return false;
  if (lhs.studies_of_interest < rhs.studies_of_interest)
    return true;
  if (rhs.studies_of_interest < lhs.studies_of_interest)
    return false;
  if (lhs.metrics < rhs.metrics)
    return true;
  if (rhs.metrics < lhs.metrics)
    return false;
  return false;
}


}  // metrics::dwa::mojom

namespace mojo {


template <>
struct  StructTraits<::metrics::dwa::mojom::DwaEntry::DataView,
                                         ::metrics::dwa::mojom::DwaEntryPtr> {
  static bool IsNull(const ::metrics::dwa::mojom::DwaEntryPtr& input) { return !input; }
  static void SetToNull(::metrics::dwa::mojom::DwaEntryPtr* output) { output->reset(); }

  static decltype(::metrics::dwa::mojom::DwaEntry::event_hash) event_hash(
      const ::metrics::dwa::mojom::DwaEntryPtr& input) {
    return input->event_hash;
  }

  static decltype(::metrics::dwa::mojom::DwaEntry::content_hash) content_hash(
      const ::metrics::dwa::mojom::DwaEntryPtr& input) {
    return input->content_hash;
  }

  static const decltype(::metrics::dwa::mojom::DwaEntry::studies_of_interest)& studies_of_interest(
      const ::metrics::dwa::mojom::DwaEntryPtr& input) {
    return input->studies_of_interest;
  }

  static const decltype(::metrics::dwa::mojom::DwaEntry::metrics)& metrics(
      const ::metrics::dwa::mojom::DwaEntryPtr& input) {
    return input->metrics;
  }

  static bool Read(::metrics::dwa::mojom::DwaEntry::DataView input, ::metrics::dwa::mojom::DwaEntryPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_H_