// ui/gfx/mojom/presentation_feedback.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/presentation_feedback.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace gfx::mojom {
class PresentationFeedbackDataView;



}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::PresentationFeedbackDataView> {
  using Data = ::gfx::mojom::internal::PresentationFeedback_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class PresentationFeedbackDataView {
 public:
  PresentationFeedbackDataView() = default;

  PresentationFeedbackDataView(
      internal::PresentationFeedback_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterval(UserType* output) {
    
    auto* pointer = data_->interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint32_t flags() const {
    return data_->flags;
  }
  inline void GetAvailableTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvailableTimestamp(UserType* output) {
    
    auto* pointer = data_->available_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetReadyTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadyTimestamp(UserType* output) {
    
    auto* pointer = data_->ready_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLatchTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatchTimestamp(UserType* output) {
    
    auto* pointer = data_->latch_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetWritesDoneTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWritesDoneTimestamp(UserType* output) {
    
    auto* pointer = data_->writes_done_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  std::optional<int64_t> display_trace_id() const {

    return data_->display_trace_id_$flag
        ? std::make_optional(data_->display_trace_id_$value)
        : std::nullopt;
  }
 private:
  internal::PresentationFeedback_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::PresentationFeedbackDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::PresentationFeedbackDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::PresentationFeedback_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in PresentationFeedback struct");
    decltype(Traits::interval(input)) in_interval = Traits::interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interval)::BaseType> interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_interval, interval_fragment);
    fragment->interval.Set(
        interval_fragment.is_null() ? nullptr : interval_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->interval.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interval in PresentationFeedback struct");
    fragment->flags = Traits::flags(input);
    decltype(Traits::available_timestamp(input)) in_available_timestamp = Traits::available_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->available_timestamp)::BaseType> available_timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_available_timestamp, available_timestamp_fragment);
    fragment->available_timestamp.Set(
        available_timestamp_fragment.is_null() ? nullptr : available_timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->available_timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null available_timestamp in PresentationFeedback struct");
    decltype(Traits::ready_timestamp(input)) in_ready_timestamp = Traits::ready_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ready_timestamp)::BaseType> ready_timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_ready_timestamp, ready_timestamp_fragment);
    fragment->ready_timestamp.Set(
        ready_timestamp_fragment.is_null() ? nullptr : ready_timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ready_timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ready_timestamp in PresentationFeedback struct");
    decltype(Traits::latch_timestamp(input)) in_latch_timestamp = Traits::latch_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latch_timestamp)::BaseType> latch_timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_latch_timestamp, latch_timestamp_fragment);
    fragment->latch_timestamp.Set(
        latch_timestamp_fragment.is_null() ? nullptr : latch_timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->latch_timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latch_timestamp in PresentationFeedback struct");
    decltype(Traits::writes_done_timestamp(input)) in_writes_done_timestamp = Traits::writes_done_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->writes_done_timestamp)::BaseType> writes_done_timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_writes_done_timestamp, writes_done_timestamp_fragment);
    fragment->writes_done_timestamp.Set(
        writes_done_timestamp_fragment.is_null() ? nullptr : writes_done_timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->writes_done_timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null writes_done_timestamp in PresentationFeedback struct");
    fragment->display_trace_id_$flag = Traits::display_trace_id(input).has_value();
    if (Traits::display_trace_id(input).has_value()) {
      fragment->display_trace_id_$value = Traits::display_trace_id(input).value();
    }
  }

  static bool Deserialize(::gfx::mojom::internal::PresentationFeedback_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::PresentationFeedbackDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void PresentationFeedbackDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void PresentationFeedbackDataView::GetIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void PresentationFeedbackDataView::GetAvailableTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->available_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void PresentationFeedbackDataView::GetReadyTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->ready_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void PresentationFeedbackDataView::GetLatchTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->latch_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void PresentationFeedbackDataView::GetWritesDoneTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->writes_done_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_SHARED_H_