// third_party/blink/public/mojom/mediastream/media_stream.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/display_media_information.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink::mojom {
class SearchOnlyByDeviceIdDataView;

class SearchBySessionIdDataView;

class MediaStreamDeviceDataView;

class TrackControlsDataView;

class StreamControlsDataView;

class GetOpenDeviceResponseDataView;

class CapturedWheelActionDataView;

class StreamDevicesDataView;

class StreamDevicesSetDataView;

class StreamSelectionInfoDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SearchOnlyByDeviceIdDataView> {
  using Data = ::blink::mojom::internal::SearchOnlyByDeviceId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SearchBySessionIdDataView> {
  using Data = ::blink::mojom::internal::SearchBySessionId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MediaStreamDeviceDataView> {
  using Data = ::blink::mojom::internal::MediaStreamDevice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TrackControlsDataView> {
  using Data = ::blink::mojom::internal::TrackControls_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamControlsDataView> {
  using Data = ::blink::mojom::internal::StreamControls_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetOpenDeviceResponseDataView> {
  using Data = ::blink::mojom::internal::GetOpenDeviceResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CapturedWheelActionDataView> {
  using Data = ::blink::mojom::internal::CapturedWheelAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamDevicesDataView> {
  using Data = ::blink::mojom::internal::StreamDevices_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamDevicesSetDataView> {
  using Data = ::blink::mojom::internal::StreamDevicesSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamSelectionInfoDataView> {
  using Data = ::blink::mojom::internal::StreamSelectionInfo_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class MediaStreamType : int32_t {
  
  NO_SERVICE = 0,
  
  DEVICE_AUDIO_CAPTURE = 1,
  
  DEVICE_VIDEO_CAPTURE = 2,
  
  GUM_TAB_AUDIO_CAPTURE = 3,
  
  GUM_TAB_VIDEO_CAPTURE = 4,
  
  GUM_DESKTOP_VIDEO_CAPTURE = 5,
  
  GUM_DESKTOP_AUDIO_CAPTURE = 6,
  
  DISPLAY_VIDEO_CAPTURE = 7,
  
  DISPLAY_AUDIO_CAPTURE = 8,
  
  DISPLAY_VIDEO_CAPTURE_THIS_TAB = 9,
  
  DISPLAY_VIDEO_CAPTURE_SET = 10,
  
  NUM_MEDIA_TYPES = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaStreamType value);
inline bool IsKnownEnumValue(MediaStreamType value) {
  return internal::MediaStreamType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaStreamRequestResult : int32_t {
  
  OK = 0,
  
  PERMISSION_DENIED = 1,
  
  PERMISSION_DISMISSED = 2,
  
  INVALID_STATE = 3,
  
  NO_HARDWARE = 4,
  
  INVALID_SECURITY_ORIGIN = 5,
  
  TAB_CAPTURE_FAILURE = 6,
  
  SCREEN_CAPTURE_FAILURE = 7,
  
  CAPTURE_FAILURE = 8,
  
  CONSTRAINT_NOT_SATISFIED = 9,
  
  TRACK_START_FAILURE_AUDIO = 10,
  
  TRACK_START_FAILURE_VIDEO = 11,
  
  NOT_SUPPORTED = 12,
  
  FAILED_DUE_TO_SHUTDOWN = 13,
  
  KILL_SWITCH_ON = 14,
  
  SYSTEM_PERMISSION_DENIED = 15,
  
  DEVICE_IN_USE = 16,
  
  REQUEST_CANCELLED = 17,
  
  START_TIMEOUT = 18,
  
  NUM_MEDIA_REQUEST_RESULTS = 19,
  kMinValue = 0,
  kMaxValue = 19,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaStreamRequestResult value);
inline bool IsKnownEnumValue(MediaStreamRequestResult value) {
  return internal::MediaStreamRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaStreamStateChange : int32_t {
  
  PLAY = 0,
  
  PAUSE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaStreamStateChange value);
inline bool IsKnownEnumValue(MediaStreamStateChange value) {
  return internal::MediaStreamStateChange_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PreferredDisplaySurface : int32_t {
  
  NO_PREFERENCE = 0,
  
  MONITOR = 1,
  
  WINDOW = 2,
  
  BROWSER = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PreferredDisplaySurface value);
inline bool IsKnownEnumValue(PreferredDisplaySurface value) {
  return internal::PreferredDisplaySurface_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CapturedSurfaceControlResult : int32_t {
  
  kSuccess = 0,
  
  kUnknownError = 1,
  
  kNoPermissionError = 2,
  
  kCapturerNotFoundError = 3,
  
  kCapturedSurfaceNotFoundError = 4,
  
  kDisallowedForSelfCaptureError = 5,
  
  kCapturerNotFocusedError = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CapturedSurfaceControlResult value);
inline bool IsKnownEnumValue(CapturedSurfaceControlResult value) {
  return internal::CapturedSurfaceControlResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaStreamDeviceObserverInterfaceBase {};

using MediaStreamDeviceObserverPtrDataView =
    mojo::InterfacePtrDataView<MediaStreamDeviceObserverInterfaceBase>;
using MediaStreamDeviceObserverRequestDataView =
    mojo::InterfaceRequestDataView<MediaStreamDeviceObserverInterfaceBase>;
using MediaStreamDeviceObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStreamDeviceObserverInterfaceBase>;
using MediaStreamDeviceObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStreamDeviceObserverInterfaceBase>;
class MediaStreamDispatcherHostInterfaceBase {};

using MediaStreamDispatcherHostPtrDataView =
    mojo::InterfacePtrDataView<MediaStreamDispatcherHostInterfaceBase>;
using MediaStreamDispatcherHostRequestDataView =
    mojo::InterfaceRequestDataView<MediaStreamDispatcherHostInterfaceBase>;
using MediaStreamDispatcherHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStreamDispatcherHostInterfaceBase>;
using MediaStreamDispatcherHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStreamDispatcherHostInterfaceBase>;
class MediaStreamTrackMetricsHostInterfaceBase {};

using MediaStreamTrackMetricsHostPtrDataView =
    mojo::InterfacePtrDataView<MediaStreamTrackMetricsHostInterfaceBase>;
using MediaStreamTrackMetricsHostRequestDataView =
    mojo::InterfaceRequestDataView<MediaStreamTrackMetricsHostInterfaceBase>;
using MediaStreamTrackMetricsHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStreamTrackMetricsHostInterfaceBase>;
using MediaStreamTrackMetricsHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStreamTrackMetricsHostInterfaceBase>;


class SearchOnlyByDeviceIdDataView {
 public:
  SearchOnlyByDeviceIdDataView() = default;

  SearchOnlyByDeviceIdDataView(
      internal::SearchOnlyByDeviceId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SearchOnlyByDeviceId_Data* data_ = nullptr;
};


class SearchBySessionIdDataView {
 public:
  SearchBySessionIdDataView() = default;

  SearchBySessionIdDataView(
      internal::SearchBySessionId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionIdMap(UserType* output) {
    
    auto* pointer = data_->session_id_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SearchBySessionId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceDataView {
 public:
  MediaStreamDeviceDataView() = default;

  MediaStreamDeviceDataView(
      internal::MediaStreamDevice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamType>(
        data_value, output);
  }
  MediaStreamType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamType>(data_->type));
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t display_id() const {
    return data_->display_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVideoFacing(UserType* output) const {
    auto data_value = data_->video_facing;
    return mojo::internal::Deserialize<::media::mojom::VideoFacingMode>(
        data_value, output);
  }
  ::media::mojom::VideoFacingMode video_facing() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoFacingMode>(data_->video_facing));
  }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `group_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupId` instead "
    "of `ReadGroupId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMatchedOutputDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchedOutputDeviceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `matched_output_device_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMatchedOutputDeviceId` instead "
    "of `ReadMatchedOutputDeviceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->matched_output_device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInputDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `session_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSessionId` instead "
    "of `ReadSessionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayMediaInfoDataView(
      ::media::mojom::DisplayMediaInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayMediaInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::DisplayMediaInformationDataView, UserType>(),
    "Attempting to read the optional `display_media_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisplayMediaInfo` instead "
    "of `ReadDisplayMediaInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->display_media_info.Get();
    return mojo::internal::Deserialize<::media::mojom::DisplayMediaInformationDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDevice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrackControlsDataView {
 public:
  TrackControlsDataView() = default;

  TrackControlsDataView(
      internal::TrackControls_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamType(UserType* output) const {
    auto data_value = data_->stream_type;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamType>(
        data_value, output);
  }
  MediaStreamType stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamType>(data_->stream_type));
  }
  inline void GetDeviceIdsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceIds(UserType* output) {
    
    auto* pointer = data_->device_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TrackControls_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StreamControlsDataView {
 public:
  StreamControlsDataView() = default;

  StreamControlsDataView(
      internal::StreamControls_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioDataView(
      TrackControlsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudio(UserType* output) {
    
    auto* pointer = data_->audio.Get();
    return mojo::internal::Deserialize<::blink::mojom::TrackControlsDataView>(
        pointer, output, message_);
  }
  inline void GetVideoDataView(
      TrackControlsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideo(UserType* output) {
    
    auto* pointer = data_->video.Get();
    return mojo::internal::Deserialize<::blink::mojom::TrackControlsDataView>(
        pointer, output, message_);
  }
  bool hotword_enabled() const {
    return data_->hotword_enabled;
  }
  bool disable_local_echo() const {
    return data_->disable_local_echo;
  }
  bool suppress_local_audio_playback() const {
    return data_->suppress_local_audio_playback;
  }
  bool exclude_system_audio() const {
    return data_->exclude_system_audio;
  }
  bool exclude_self_browser_surface() const {
    return data_->exclude_self_browser_surface;
  }
  bool request_pan_tilt_zoom_permission() const {
    return data_->request_pan_tilt_zoom_permission;
  }
  bool request_all_screens() const {
    return data_->request_all_screens;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredDisplaySurface(UserType* output) const {
    auto data_value = data_->preferred_display_surface;
    return mojo::internal::Deserialize<::blink::mojom::PreferredDisplaySurface>(
        data_value, output);
  }
  PreferredDisplaySurface preferred_display_surface() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredDisplaySurface>(data_->preferred_display_surface));
  }
  bool dynamic_surface_switching_requested() const {
    return data_->dynamic_surface_switching_requested;
  }
  bool exclude_monitor_type_surfaces() const {
    return data_->exclude_monitor_type_surfaces;
  }
 private:
  internal::StreamControls_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetOpenDeviceResponseDataView {
 public:
  GetOpenDeviceResponseDataView() = default;

  GetOpenDeviceResponseDataView(
      internal::GetOpenDeviceResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  bool pan_tilt_zoom_allowed() const {
    return data_->pan_tilt_zoom_allowed;
  }
 private:
  internal::GetOpenDeviceResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CapturedWheelActionDataView {
 public:
  CapturedWheelActionDataView() = default;

  CapturedWheelActionDataView(
      internal::CapturedWheelAction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double relative_x() const {
    return data_->relative_x;
  }
  double relative_y() const {
    return data_->relative_y;
  }
  int32_t wheel_delta_x() const {
    return data_->wheel_delta_x;
  }
  int32_t wheel_delta_y() const {
    return data_->wheel_delta_y;
  }
 private:
  internal::CapturedWheelAction_Data* data_ = nullptr;
};


class StreamDevicesDataView {
 public:
  StreamDevicesDataView() = default;

  StreamDevicesDataView(
      internal::StreamDevices_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioDevice(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MediaStreamDeviceDataView, UserType>(),
    "Attempting to read the optional `audio_device` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioDevice` instead "
    "of `ReadAudioDevice if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->audio_device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  inline void GetVideoDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoDevice(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MediaStreamDeviceDataView, UserType>(),
    "Attempting to read the optional `video_device` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVideoDevice` instead "
    "of `ReadVideoDevice if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->video_device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::StreamDevices_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StreamDevicesSetDataView {
 public:
  StreamDevicesSetDataView() = default;

  StreamDevicesSetDataView(
      internal::StreamDevicesSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStreamDevicesDataView(
      mojo::ArrayDataView<StreamDevicesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamDevices(UserType* output) {
    
    auto* pointer = data_->stream_devices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::StreamDevicesDataView>>(
        pointer, output, message_);
  }
 private:
  internal::StreamDevicesSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StreamSelectionInfoDataView {
 public:
  using Tag = internal::StreamSelectionInfo_Data::StreamSelectionInfo_Tag;

  StreamSelectionInfoDataView() = default;

  StreamSelectionInfoDataView(
      internal::StreamSelectionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_search_only_by_device_id() const { return data_->tag == Tag::kSearchOnlyByDeviceId; }
  inline void GetSearchOnlyByDeviceIdDataView(
      SearchOnlyByDeviceIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSearchOnlyByDeviceId(UserType* output) const {
    
    CHECK(is_search_only_by_device_id());
    return mojo::internal::Deserialize<::blink::mojom::SearchOnlyByDeviceIdDataView>(
        data_->data.f_search_only_by_device_id.Get(), output, message_);
  }
  bool is_search_by_session_id() const { return data_->tag == Tag::kSearchBySessionId; }
  inline void GetSearchBySessionIdDataView(
      SearchBySessionIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSearchBySessionId(UserType* output) const {
    
    CHECK(is_search_by_session_id());
    return mojo::internal::Deserialize<::blink::mojom::SearchBySessionIdDataView>(
        data_->data.f_search_by_session_id.Get(), output, message_);
  }

 private:
  internal::StreamSelectionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::MediaStreamType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaStreamType> {};

template <>
struct hash<::blink::mojom::MediaStreamRequestResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaStreamRequestResult> {};

template <>
struct hash<::blink::mojom::MediaStreamStateChange>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MediaStreamStateChange> {};

template <>
struct hash<::blink::mojom::PreferredDisplaySurface>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PreferredDisplaySurface> {};

template <>
struct hash<::blink::mojom::CapturedSurfaceControlResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CapturedSurfaceControlResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaStreamType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaStreamType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamRequestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaStreamRequestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaStreamRequestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamStateChange, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MediaStreamStateChange, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MediaStreamStateChange>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PreferredDisplaySurface, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PreferredDisplaySurface, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PreferredDisplaySurface>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CapturedSurfaceControlResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CapturedSurfaceControlResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CapturedSurfaceControlResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SearchOnlyByDeviceIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SearchOnlyByDeviceIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SearchOnlyByDeviceId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::blink::mojom::internal::SearchOnlyByDeviceId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SearchOnlyByDeviceIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SearchBySessionIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SearchBySessionIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SearchBySessionId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::session_id_map(input)) in_session_id_map = Traits::session_id_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_id_map)::BaseType>
        session_id_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& session_id_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>>(
        in_session_id_map, session_id_map_fragment, &session_id_map_validate_params);
    fragment->session_id_map.Set(
        session_id_map_fragment.is_null() ? nullptr : session_id_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session_id_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_id_map in SearchBySessionId struct");
  }

  static bool Deserialize(::blink::mojom::internal::SearchBySessionId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SearchBySessionIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MediaStreamDeviceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaStreamDeviceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaStreamDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in MediaStreamDevice struct");
    fragment->display_id = Traits::display_id(input);
    mojo::internal::Serialize<::media::mojom::VideoFacingMode>(
        Traits::video_facing(input), &fragment->video_facing);
    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_group_id, group_id_fragment);
    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());
    decltype(Traits::matched_output_device_id(input)) in_matched_output_device_id = Traits::matched_output_device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->matched_output_device_id)::BaseType> matched_output_device_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_matched_output_device_id, matched_output_device_id_fragment);
    fragment->matched_output_device_id.Set(
        matched_output_device_id_fragment.is_null() ? nullptr : matched_output_device_id_fragment.data());
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in MediaStreamDevice struct");
    decltype(Traits::input(input)) in_input = Traits::input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input)::BaseType> input_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
        in_input, input_fragment);
    fragment->input.Set(
        input_fragment.is_null() ? nullptr : input_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->input.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in MediaStreamDevice struct");
    decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_id)::BaseType> session_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_session_id, session_id_fragment);
    fragment->session_id.Set(
        session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
    decltype(Traits::display_media_info(input)) in_display_media_info = Traits::display_media_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_media_info)::BaseType> display_media_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::DisplayMediaInformationDataView>(
        in_display_media_info, display_media_info_fragment);
    fragment->display_media_info.Set(
        display_media_info_fragment.is_null() ? nullptr : display_media_info_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::MediaStreamDevice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MediaStreamDeviceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TrackControlsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TrackControlsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TrackControls_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
        Traits::stream_type(input), &fragment->stream_type);
    decltype(Traits::device_ids(input)) in_device_ids = Traits::device_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_ids)::BaseType>
        device_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& device_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_device_ids, device_ids_fragment, &device_ids_validate_params);
    fragment->device_ids.Set(
        device_ids_fragment.is_null() ? nullptr : device_ids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_ids in TrackControls struct");
  }

  static bool Deserialize(::blink::mojom::internal::TrackControls_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TrackControlsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamControlsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamControlsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamControls_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::audio(input)) in_audio = Traits::audio(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio)::BaseType> audio_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::TrackControlsDataView>(
        in_audio, audio_fragment);
    fragment->audio.Set(
        audio_fragment.is_null() ? nullptr : audio_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->audio.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio in StreamControls struct");
    decltype(Traits::video(input)) in_video = Traits::video(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video)::BaseType> video_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::TrackControlsDataView>(
        in_video, video_fragment);
    fragment->video.Set(
        video_fragment.is_null() ? nullptr : video_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->video.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video in StreamControls struct");
    fragment->hotword_enabled = Traits::hotword_enabled(input);
    fragment->disable_local_echo = Traits::disable_local_echo(input);
    fragment->suppress_local_audio_playback = Traits::suppress_local_audio_playback(input);
    fragment->exclude_system_audio = Traits::exclude_system_audio(input);
    fragment->exclude_self_browser_surface = Traits::exclude_self_browser_surface(input);
    fragment->request_pan_tilt_zoom_permission = Traits::request_pan_tilt_zoom_permission(input);
    fragment->request_all_screens = Traits::request_all_screens(input);
    mojo::internal::Serialize<::blink::mojom::PreferredDisplaySurface>(
        Traits::preferred_display_surface(input), &fragment->preferred_display_surface);
    fragment->dynamic_surface_switching_requested = Traits::dynamic_surface_switching_requested(input);
    fragment->exclude_monitor_type_surfaces = Traits::exclude_monitor_type_surfaces(input);
  }

  static bool Deserialize(::blink::mojom::internal::StreamControls_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamControlsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetOpenDeviceResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetOpenDeviceResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GetOpenDeviceResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in GetOpenDeviceResponse struct");
    decltype(Traits::device(input)) in_device = Traits::device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device)::BaseType> device_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
        in_device, device_fragment);
    fragment->device.Set(
        device_fragment.is_null() ? nullptr : device_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device in GetOpenDeviceResponse struct");
    fragment->pan_tilt_zoom_allowed = Traits::pan_tilt_zoom_allowed(input);
  }

  static bool Deserialize(::blink::mojom::internal::GetOpenDeviceResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetOpenDeviceResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CapturedWheelActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CapturedWheelActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CapturedWheelAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->relative_x = Traits::relative_x(input);
    fragment->relative_y = Traits::relative_y(input);
    fragment->wheel_delta_x = Traits::wheel_delta_x(input);
    fragment->wheel_delta_y = Traits::wheel_delta_y(input);
  }

  static bool Deserialize(::blink::mojom::internal::CapturedWheelAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CapturedWheelActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamDevicesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamDevicesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamDevices_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::audio_device(input)) in_audio_device = Traits::audio_device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_device)::BaseType> audio_device_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
        in_audio_device, audio_device_fragment);
    fragment->audio_device.Set(
        audio_device_fragment.is_null() ? nullptr : audio_device_fragment.data());
    decltype(Traits::video_device(input)) in_video_device = Traits::video_device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_device)::BaseType> video_device_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
        in_video_device, video_device_fragment);
    fragment->video_device.Set(
        video_device_fragment.is_null() ? nullptr : video_device_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::StreamDevices_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamDevicesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamDevicesSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamDevicesSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamDevicesSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::stream_devices(input)) in_stream_devices = Traits::stream_devices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stream_devices)::BaseType>
        stream_devices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stream_devices_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StreamDevicesDataView>>(
        in_stream_devices, stream_devices_fragment, &stream_devices_validate_params);
    fragment->stream_devices.Set(
        stream_devices_fragment.is_null() ? nullptr : stream_devices_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->stream_devices.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stream_devices in StreamDevicesSet struct");
  }

  static bool Deserialize(::blink::mojom::internal::StreamDevicesSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamDevicesSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StreamSelectionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::StreamSelectionInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::StreamSelectionInfo_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::StreamSelectionInfoDataView::Tag::kSearchOnlyByDeviceId: {
        decltype(Traits::search_only_by_device_id(input))
            in_search_only_by_device_id = Traits::search_only_by_device_id(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_search_only_by_device_id)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::SearchOnlyByDeviceIdDataView>(
            in_search_only_by_device_id, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null search_only_by_device_id in StreamSelectionInfo union");
        fragment->data.f_search_only_by_device_id.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::StreamSelectionInfoDataView::Tag::kSearchBySessionId: {
        decltype(Traits::search_by_session_id(input))
            in_search_by_session_id = Traits::search_by_session_id(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_search_by_session_id)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::SearchBySessionIdDataView>(
            in_search_by_session_id, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null search_by_session_id in StreamSelectionInfo union");
        fragment->data.f_search_by_session_id.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::StreamSelectionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StreamSelectionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void SearchBySessionIdDataView::GetSessionIdMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->session_id_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, message_);
}


inline void MediaStreamDeviceDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetMatchedOutputDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->matched_output_device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetInputDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->input.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetSessionIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void MediaStreamDeviceDataView::GetDisplayMediaInfoDataView(
    ::media::mojom::DisplayMediaInformationDataView* output) {
  auto pointer = data_->display_media_info.Get();
  *output = ::media::mojom::DisplayMediaInformationDataView(pointer, message_);
}


inline void TrackControlsDataView::GetDeviceIdsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->device_ids.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void StreamControlsDataView::GetAudioDataView(
    TrackControlsDataView* output) {
  auto pointer = data_->audio.Get();
  *output = TrackControlsDataView(pointer, message_);
}
inline void StreamControlsDataView::GetVideoDataView(
    TrackControlsDataView* output) {
  auto pointer = data_->video.Get();
  *output = TrackControlsDataView(pointer, message_);
}


inline void GetOpenDeviceResponseDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GetOpenDeviceResponseDataView::GetDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}




inline void StreamDevicesDataView::GetAudioDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->audio_device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}
inline void StreamDevicesDataView::GetVideoDeviceDataView(
    MediaStreamDeviceDataView* output) {
  auto pointer = data_->video_device.Get();
  *output = MediaStreamDeviceDataView(pointer, message_);
}


inline void StreamDevicesSetDataView::GetStreamDevicesDataView(
    mojo::ArrayDataView<StreamDevicesDataView>* output) {
  auto pointer = data_->stream_devices.Get();
  *output = mojo::ArrayDataView<StreamDevicesDataView>(pointer, message_);
}


inline void StreamSelectionInfoDataView::GetSearchOnlyByDeviceIdDataView(
    SearchOnlyByDeviceIdDataView* output) const {
  CHECK(is_search_only_by_device_id());
  *output = SearchOnlyByDeviceIdDataView(data_->data.f_search_only_by_device_id.Get(), message_);
}
inline void StreamSelectionInfoDataView::GetSearchBySessionIdDataView(
    SearchBySessionIdDataView* output) const {
  CHECK(is_search_by_session_id());
  *output = SearchBySessionIdDataView(data_->data.f_search_by_session_id.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaStreamType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaStreamType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaStreamRequestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaStreamRequestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MediaStreamStateChange> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MediaStreamStateChange value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PreferredDisplaySurface> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PreferredDisplaySurface value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CapturedSurfaceControlResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CapturedSurfaceControlResult value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SHARED_H_