// services/network/public/mojom/ct_log_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ct_log_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace network::mojom {
class PreviousOperatorEntryDataView;

class CTLogInfoDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::PreviousOperatorEntryDataView> {
  using Data = ::network::mojom::internal::PreviousOperatorEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CTLogInfoDataView> {
  using Data = ::network::mojom::internal::CTLogInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CTLogInfo_LogType : int32_t {
  
  kUnspecified = 0,
  
  kRFC6962 = 1,
  
  kStaticCTAPI = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CTLogInfo_LogType value);
inline bool IsKnownEnumValue(CTLogInfo_LogType value) {
  return internal::CTLogInfo_LogType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PreviousOperatorEntryDataView {
 public:
  PreviousOperatorEntryDataView() = default;

  PreviousOperatorEntryDataView(
      internal::PreviousOperatorEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEndTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndTime(UserType* output) {
    
    auto* pointer = data_->end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::PreviousOperatorEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CTLogInfoDataView {
 public:
  CTLogInfoDataView() = default;

  CTLogInfoDataView(
      internal::CTLogInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetPublicKeyDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKey(UserType* output) {
    
    auto* pointer = data_->public_key.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisqualifiedAtDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisqualifiedAt(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `disqualified_at` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisqualifiedAt` instead "
    "of `ReadDisqualifiedAt if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->disqualified_at.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetMmdDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMmd(UserType* output) {
    
    auto* pointer = data_->mmd.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentOperatorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentOperator(UserType* output) {
    
    auto* pointer = data_->current_operator.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousOperatorsDataView(
      mojo::ArrayDataView<PreviousOperatorEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousOperators(UserType* output) {
    
    auto* pointer = data_->previous_operators.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PreviousOperatorEntryDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLogType(UserType* output) const {
    auto data_value = data_->log_type;
    return mojo::internal::Deserialize<::network::mojom::CTLogInfo_LogType>(
        data_value, output);
  }
  CTLogInfo_LogType log_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CTLogInfo_LogType>(data_->log_type));
  }
 private:
  internal::CTLogInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::CTLogInfo_LogType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CTLogInfo_LogType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CTLogInfo_LogType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CTLogInfo_LogType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CTLogInfo_LogType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::PreviousOperatorEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PreviousOperatorEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PreviousOperatorEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in PreviousOperatorEntry struct");
    decltype(Traits::end_time(input)) in_end_time = Traits::end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end_time)::BaseType> end_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_end_time, end_time_fragment);
    fragment->end_time.Set(
        end_time_fragment.is_null() ? nullptr : end_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->end_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null end_time in PreviousOperatorEntry struct");
  }

  static bool Deserialize(::network::mojom::internal::PreviousOperatorEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::PreviousOperatorEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CTLogInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CTLogInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CTLogInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in CTLogInfo struct");
    decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key)::BaseType> public_key_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_public_key, public_key_fragment);
    fragment->public_key.Set(
        public_key_fragment.is_null() ? nullptr : public_key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->public_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null public_key in CTLogInfo struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in CTLogInfo struct");
    decltype(Traits::disqualified_at(input)) in_disqualified_at = Traits::disqualified_at(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disqualified_at)::BaseType> disqualified_at_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_disqualified_at, disqualified_at_fragment);
    fragment->disqualified_at.Set(
        disqualified_at_fragment.is_null() ? nullptr : disqualified_at_fragment.data());
    decltype(Traits::mmd(input)) in_mmd = Traits::mmd(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mmd)::BaseType> mmd_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_mmd, mmd_fragment);
    fragment->mmd.Set(
        mmd_fragment.is_null() ? nullptr : mmd_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mmd.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mmd in CTLogInfo struct");
    decltype(Traits::current_operator(input)) in_current_operator = Traits::current_operator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_operator)::BaseType> current_operator_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_current_operator, current_operator_fragment);
    fragment->current_operator.Set(
        current_operator_fragment.is_null() ? nullptr : current_operator_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->current_operator.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null current_operator in CTLogInfo struct");
    decltype(Traits::previous_operators(input)) in_previous_operators = Traits::previous_operators(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->previous_operators)::BaseType>
        previous_operators_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& previous_operators_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PreviousOperatorEntryDataView>>(
        in_previous_operators, previous_operators_fragment, &previous_operators_validate_params);
    fragment->previous_operators.Set(
        previous_operators_fragment.is_null() ? nullptr : previous_operators_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->previous_operators.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null previous_operators in CTLogInfo struct");
    mojo::internal::Serialize<::network::mojom::CTLogInfo_LogType>(
        Traits::log_type(input), &fragment->log_type);
  }

  static bool Deserialize(::network::mojom::internal::CTLogInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CTLogInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void PreviousOperatorEntryDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PreviousOperatorEntryDataView::GetEndTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->end_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void CTLogInfoDataView::GetIdDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void CTLogInfoDataView::GetPublicKeyDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->public_key.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void CTLogInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CTLogInfoDataView::GetDisqualifiedAtDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->disqualified_at.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CTLogInfoDataView::GetMmdDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->mmd.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void CTLogInfoDataView::GetCurrentOperatorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->current_operator.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CTLogInfoDataView::GetPreviousOperatorsDataView(
    mojo::ArrayDataView<PreviousOperatorEntryDataView>* output) {
  auto pointer = data_->previous_operators.Get();
  *output = mojo::ArrayDataView<PreviousOperatorEntryDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CTLogInfo_LogType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CTLogInfo_LogType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_SHARED_H_